<?php
################################################################################
##              -= YOU MAY NOT REMOVE OR CHANGE THIS NOTICE =-                 #
## --------------------------------------------------------------------------- #
##  ApPHP Tabs version 1.0.2 (20.11.2009)                                      #
##  Developed by:  ApPhp <info@apphp.com>                                      #
##  License:       GNU GPL v.2                                                 #
##  Site:          http://www.apphp.com/php-tabs/                              #
##  Copyright:     ApPHP Tabs (c) 2009. All rights reserved.                   #
##                                                                             #
################################################################################
 class Tab
 {
        // PUBLIC
        // -------
        // constructor
        // AddTab
        // View
        // Enable
        // Disable
        // IsSelected
        // Deselect
        // GetCaption
        // GetId
        // GetNumChildren
        //
        // PRIVATE
        // --------
        // SelectWithChildren
        // Calculate

    private $caption;
    private $enabled=true;
    private $selected=false;
    private $level;
    private $id;
    private $filename;
    private $tabs;
    private $numOfSelectedTabs;
    private $numchildren=1;
    private $parent;
    private $preselected="";
    private $defaultTab;
    private $tabsVersion="1.0.2";
    /**
	 *	Create new set of tabs
	        @param $caption - text on the tab
	        @param $parent - caption of the parent's tab
	        @param $file - graphic file associated with this tab
	        @param $defaultTab - caption of the child's tab which should be selected by default
	        @param $enabled - is tab enabled or disabled
	*
	*/
	function Tab($caption,$parent=null,$file="",$defaultTab="",$enabled=true)
	{
           $this->file=$file;
           $this->tabs=array();
           $this->filename=array();
           $this->numOfSelectedTabs;
           $this->caption=$caption;
           $this->enabled=$enabled;
           $this->defaultTab=$defaultTab;
           if($this->preselected=="")
               //picking up $_GET parameters
               Tab::Calculate();
           if($parent==null)
           {
              $this->parent=null;
              $this->level=0;
              $this->id=1;
              $this->selected=true;
              return;
           	}
           	else
           	{
              $this->parent=$parent;
              $this->level=$parent->level+1;
              $this->id=$this->parent->GetId()*10+$this->parent->GetNumChildren();
           }

           if($this->preselected!=""&&substr($this->preselected,$this->level,1)==$this->id%10)
              $this->selected=true;
           else $this->Deselect();
	}

	/**
	*	Add a new child tab to this set of tabs
	      @param $caption - text on the tab
	      @param $parent - the direct parent of this tab (current tab object may be its grandgrandfather etc.)
	      @param $file - graphic file associated with this tab
	      @param $defaultTab - caption of the child's tab which should be selected by default
	      @param $enabled - is tab enabled or disabled
	*
	*/
	public function AddTab($caption,$parent,$file="",$defaultTab="",$enabled=true)
    {
          if($parent==$this->caption)
          {
             if ($this->numchildren<10)
             {
                $this->tabs[$this->numchildren]=new Tab($caption,$this,$file,$defaultTab,$enabled);
                $this->numchildren++;
             }
             return true;
          }
          else foreach($this->tabs as $tab)
          {
          	 if($tab->AddTab($caption,$parent,$file,$defaultTab,$enabled))
          	    return true;
          }
    }

	/**
	*	Display this tab and selected child tab (recursive function)
	*
	*/
    public function View()
    {
      $g=0;
       //display this tab
       $this->SelectWithChildren();
       if($this->numchildren!=1)
       {
          echo "<ul id=\"navlist\" class=\"menu\">";
		  $request_uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : "0";
		  $request_uri_pos = isset($_SERVER['REQUEST_URI']) ? strrpos($_SERVER['REQUEST_URI'],'?') : "0";
          $root=substr($request_uri,0,$request_uri_pos);
          foreach($this->tabs as $tab)
          {
             $href=$root."?id=".$tab->id;
             if($tab->selected)
                $style="sel";
             else if($tab->enabled)
                $style="";
             else
             {
                $href="#";
                $style="dis";
             }
            echo "\n\t<li class=\"element\"><a href=\"".$href."\" class=\"tab".$style."\"><span class=\"inner".$style."\">".$tab->caption."</span></a></li>";
	      }
          echo "\n</ul><br/>\n";
          $g=0;
          //display selected child tab
          foreach($this->tabs as $tab)
             if($tab->isSelected())
             {
                $tab->View();
                $g=1;
                break;
             }
          //display image which is associated with this tab
       }
       if($this->isSelected()&&$this->file!=""&&$g==0)
          echo "<img border=\"0\" src=\"style/images/",$this->file,"\">";
       if($this->level==0)
          echo "\n<!-- END This script was generated by tabs.class.php v.".$this->tabsVersion."(http://www.apphp.com/php-tabs/index.php) END -->\n";

    }
    /**
	 *	disable the tab or one of its child tabs
	       @param $caption - caption of the tab that should be disabled
     *
	 */
    public function Disable($caption)
    {
       if($caption==$this->caption)
       {
          $this->enabled=false;
          return true;
       }
       else foreach($this->tabs as $tab)
          if($tab->Disable($caption))
             return true;
       return false;
    }
    /**
	*	enable the tab or one of its child tabs
	        @param $caption - caption of the tab that should be disabled
	*
	*/
    public function Enable($caption)
    {
        if($caption==$this->caption)
        {
           $this->enabled=true;
           return true;
        }
        else foreach($this->tabs as $tab)
           if($tab->Enable($caption))
              return true;
        return false;
    }
    /**
	 *	Pick up $_GET parameter id which denotes which tabs should be selected
	    in the form: id=45 => button #4 on the first level and button #5 on the second level should be selected
	    Define its number of digits (which means number of levels in the menu)
	 *
	 */
     private function Calculate()
     {
        $this->preselected= isset ($_GET['id']) ? $_GET['id'] : "";
        if($this->preselected!="")
        {
           for($i=0;$i<strlen($this->preselected);$i++)
             $numOfSelectedTabs[$i++]=substr($this->preselected,$i,1);
        }
     }

     /**
	  *	selecting this tab and necessary lower tabs
	  *
	  */
     private function SelectWithChildren()
     {
        //select this tab
        $this->selected=true;
        $g=true;
        //check if one of its child tabs has already been selected manually
        foreach($this->tabs as $tab)
        {
           if($tab->isSelected())
           {
              $tab->SelectWithChildren();
              return;
           }
        }
        //if default tab for selection is not indicated select the first enabled child tab
        if($this->defaultTab=="")
        {
            foreach($this->tabs as $tab)
               if($tab->enabled==true)
               {
                  $tab->SelectWithChildren();
                  break;
               }
        }
        //if default tab for selection is indicated select it
        else foreach($this->tabs as $tab)
        {
           if($tab->caption==$this->defaultTab)
           {
              $tab->SelectWithChildren();
           }
        }

     }

     public function IsSelected()
     {
        return $this->selected;
     }
     public function Deselect()
     {
        $this->selected=false;
     }
     public function GetCaption()
     {
        return $this->caption;
     }
     public function GetId()
     {
        return $this->id;
     }
     public function GetNumChildren()
     {
        return $this->numchildren;
     }

 }
?>