/*!
GLGE WebGL Graphics Engine
Copyright (c) 2010, Paul Brunt
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of GLGE nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL PAUL BRUNT BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
typeof GLGE=="undefined"&&(GLGE={}),function(a){function c(){var b=a.Vec([1,2,3,4]),c=a.Vec4(a.getVec4(b,3),a.get1basedVec4(b,3),a.getVec4(b,1),a.getVec4(b,0)),d=a.identMatrix(),e=a.mulMat4Vec4(d,c);if(a.getVec4(e,0)!=4||a.getVec4(e,1)!=3||a.getVec4(e,2)!=2||a.getVec4(e,3)!=1)throw"Unit Test 1 failed MatVecMul "+e;var f=a.Mat4([3,4,5,0,.5,.75,0,0,.75,.5,0,0,.25,.25,1,1]),g=a.Mat4([2,1,8,2,1,4,3,2,1,.5,6.5,2,8,3,1,.25]),h=a.mulMat4(f,g),i=a.Mat4([15,21.5,68.5,24,1.75,3.5,6.25,2.5,2,2.75,7.5,2.5,9.75,4.75,10.25,3.25]);for(var j=0;j<4;++j)for(var k=0;k<4;++k){var l=a.getMat4(h,j,k)-a.getMat4(i,j,k);if(l>=1e-6||l<=-1e-6)throw"Unit Test 1 failed Multiplication "+a.getMat4(h,j,k)+" != "+a.getMat4(i,j,k)}var m=a.inverseMat4(f),n=a.mulMat4(f,m),o=a.mulMat4(m,f);for(var j=0;j<4;++j)for(var k=0;k<4;++k){var l=a.getMat4(n,j,k)-a.getMat4(d,j,k);if(l>=1e-4||l<=-1e-4)throw"Unit Test 1 failed Inverse "+a.getMat4(n,j,k)+" != "+a.getMat4(d,j,k)}}var b=[];a.reuseMatrix4=function(a){},a.matrix4=function(a,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){if(b.length==0)var r=[a,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q];else{var r=b.shift();r[0]=a,r[1]=c,r[2]=d,r[3]=e,r[4]=f,r[5]=g,r[6]=h,r[7]=i,r[8]=j,r[9]=k,r[10]=l,r[11]=m,r[12]=n,r[13]=o,r[14]=p,r[15]=q}return r},a.Vec=function(a){return a.slice(0)},a.Vec3=function(a,b,c){return[a,b,c]},a.Vec4=function(a,b,c,d){return[a,b,c,d]},a.get1basedVec4=function(a,b){return a[b-1]},a.get1basedVec3=function(a,b){return a[b-1]},a.getVec4=function(a,b){return a[b]},a.getVec3=function(a,b){return a[b]},a.addVec4=function(a,b){return[a[0]+b[0],a[1]+b[1],a[2]+b[2],a[3]+b[3]]},a.addVec3=function(a,b){return[a[0]+b[0],a[1]+b[1],a[2]+b[2]]},a.subVec4=function(a,b){return[a[0]-b[0],a[1]-b[1],a[2]-b[2],a[3]-b[3]]},a.subVec3=function(a,b){return[a[0]-b[0],a[1]-b[1],a[2]-b[2]]},a.negVec4=function(a){return[-a[0],-a[1],-a[2],-a[3]]},a.negVec3=function(a){return[-a[0],-a[1],-a[2]]},a.dotVec3=function(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]},a.dotVec4=function(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]+a[3]*b[3]},a.scaleVec4=function(a,b){return[a[0]*b,a[1]*b,a[2]*b,a[3]*b]},a.scaleVec3=function(a,b){return[a[0]*b,a[1]*b,a[2]*b]},a.crossVec3=function(a,b){return[a[1]*b[2]-a[2]*b[1],a[2]*b[0]-a[0]*b[2],a[0]*b[1]-a[1]*b[0]]},a.toUnitVec3=function(a){var b=a[0]*a[0]+a[1]*a[1]+a[2]*a[2],c=1;b>0&&(c=Math.pow(b,.5));return[a[0]/c,a[1]/c,a[2]/c]},a.toUnitVec4=function(a){var b=a[0]*a[0]+a[1]*a[1]+a[2]*a[2]+a[3]*a[3],c=1;b>0&&(c=Math.pow(b,.5));return[a[0]/c,a[1]/c,a[2]/c,a[3]/c]},a.lengthVec3=function(a){return Math.pow(a[0]*a[0]+a[1]*a[1]+a[2]*a[2],.5)},a.distanceVec3=function(b,c){return a.lengthVec3(a.subVec3(b,c))},a.lengthVec4=function(a,b){return Math.pow(a[0]*a[0]+a[1]*a[1]+a[2]*a[2]+a[3]*a[3],.5)},a.distanceVec4=function(b,c){return a.lengthVec4(a.subVec4(b,c))},a.angleVec3=function(b,c){b=a.toUnitVec3(b),c=a.toUnitVec3(c),d=a.dotVec3(b,c),d<-1&&(d=-1),d>1&&(d=1);return Math.acos(d)},a.angleVec4=function(b,c){b=a.toUnitVec4(b),c=a.toUnitVec4(c),d=a.dotVec4(b,c),d<-1&&(d=-1),d>1&&(d=1);return Math.acos(d)},GLGE_math_use_webgl_float=!1,a.Mat3=GLGE_math_use_webgl_float?function(a){if(a.length==9)return new Float32Array(a);if(a.length==16)return new Float32Array([a[0],a[1],a[2],a[4],a[5],a[6],a[8],a[9],a[10]]);throw"invalid matrix length"}:function(a){var b;if(a.length==9)b=a.slice(0);else if(a.length==16)b=[a[0],a[1],a[2],a[4],a[5],a[6],a[8],a[9],a[10]];else throw"invalid matrix length";b.get=function(a){return this[a]};return b},a.Mat=GLGE_math_use_webgl_float?function(a){return new Float32Array(a)}:function(a){var b=a.slice(0);b.get=function(a){return this[a]};return b},a.Mat4=function(a){var b;if(a.length==9)b=[a[0],a[1],a[2],0,a[3],a[4],a[5],0,a[6],a[7],a[8],0,0,0,0,1];else if(a.length==16)a.slice?b=a.slice(0):b=a.subarray(0);else throw"invalid matrix length";b.get=function(a){return this[a]};return b},a.determinantMat4=function(a){return a[12]*a[9]*a[6]*a[3]-a[8]*a[13]*a[6]*a[3]-a[12]*a[5]*a[10]*a[3]+a[4]*a[13]*a[10]*a[3]+a[8]*a[5]*a[14]*a[3]-a[4]*a[9]*a[14]*a[3]-a[12]*a[9]*a[2]*a[7]+a[8]*a[13]*a[2]*a[7]+a[12]*a[1]*a[10]*a[7]-a[0]*a[13]*a[10]*a[7]-a[8]*a[1]*a[14]*a[7]+a[0]*a[9]*a[14]*a[7]+a[12]*a[5]*a[2]*a[11]-a[4]*a[13]*a[2]*a[11]-a[12]*a[1]*a[6]*a[11]+a[0]*a[13]*a[6]*a[11]+a[4]*a[1]*a[14]*a[11]-a[0]*a[5]*a[14]*a[11]-a[8]*a[5]*a[2]*a[15]+a[4]*a[9]*a[2]*a[15]+a[8]*a[1]*a[6]*a[15]-a[0]*a[9]*a[6]*a[15]-a[4]*a[1]*a[10]*a[15]+a[0]*a[5]*a[10]*a[15]},a.inverseMat4=function(b){var c=b[0],d=b[1],e=b[2],f=b[3],g=b[4],h=b[5],i=b[6],j=b[7],k=b[8],l=b[9],m=b[10],n=b[11],o=b[12],p=b[13],q=b[14],r=b[15],s=o*l*i*f-k*p*i*f-o*h*m*f+g*p*m*f+k*h*q*f-g*l*q*f-o*l*e*j+k*p*e*j+o*d*m*j-c*p*m*j-k*d*q*j+c*l*q*j+o*h*e*n-g*p*e*n-o*d*i*n+c*p*i*n+g*d*q*n-c*h*q*n-k*h*e*r+g*l*e*r+k*d*i*r-c*l*i*r-g*d*m*r+c*h*m*r;return a.matrix4((l*q*j-p*m*j+p*i*n-h*q*n-l*i*r+h*m*r)/s,(p*m*f-l*q*f-p*e*n+d*q*n+l*e*r-d*m*r)/s,(h*q*f-p*i*f+p*e*j-d*q*j-h*e*r+d*i*r)/s,(l*i*f-h*m*f-l*e*j+d*m*j+h*e*n-d*i*n)/s,(o*m*j-k*q*j-o*i*n+g*q*n+k*i*r-g*m*r)/s,(k*q*f-o*m*f+o*e*n-c*q*n-k*e*r+c*m*r)/s,(o*i*f-g*q*f-o*e*j+c*q*j+g*e*r-c*i*r)/s,(g*m*f-k*i*f+k*e*j-c*m*j-g*e*n+c*i*n)/s,(k*p*j-o*l*j+o*h*n-g*p*n-k*h*r+g*l*r)/s,(o*l*f-k*p*f-o*d*n+c*p*n+k*d*r-c*l*r)/s,(g*p*f-o*h*f+o*d*j-c*p*j-g*d*r+c*h*r)/s,(k*h*f-g*l*f-k*d*j+c*l*j+g*d*n-c*h*n)/s,(o*l*i-k*p*i-o*h*m+g*p*m+k*h*q-g*l*q)/s,(k*p*e-o*l*e+o*d*m-c*p*m-k*d*q+c*l*q)/s,(o*h*e-g*p*e-o*d*i+c*p*i+g*d*q-c*h*q)/s,(g*l*e-k*h*e+k*d*i-c*l*i-g*d*m+c*h*m)/s)},a.mulMat4Vec3=function(b,c){return a.Vec3(b[0]*c[0]+b[1]*c[1]+b[2]*c[2]+b[3],b[4]*c[0]+b[5]*c[1]+b[6]*c[2]+b[7],b[8]*c[0]+b[9]*c[1]+b[10]*c[2]+b[11])},a.mulMat4Vec4=function(b,c){return a.Vec4(b[0]*c[0]+b[1]*c[1]+b[2]*c[2]+b[3]*c[3],b[4]*c[0]+b[5]*c[1]+b[6]*c[2]+b[7]*c[3],b[8]*c[0]+b[9]*c[1]+b[10]*c[2]+b[11]*c[3],b[12]*c[0]+b[13]*c[1]+b[14]*c[2]+b[15]*c[3])},a.scaleMat4=function(b,c){return a.matrix4([b[0]*c,b[1]*c,b[2]*c,b[3]*c,b[4]*c,b[5]*c,b[6]*c,b[7]*c,b[8]*c,b[9]*c,b[10]*c,b[11]*c,b[12]*c,b[13]*c,b[14]*c,b[15]*c])},a.scaleInPlaceMat4=function(a,b){a.set(0,a[0]*b),a.set(1,a[1]*b),a.set(2,a[2]*b),a.set(3,a[3]*b),a.set(4,a[4]*b),a.set(5,a[5]*b),a.set(6,a[6]*b),a.set(7,a[7]*b),a.set(8,a[8]*b),a.set(9,a[9]*b),a.set(10,a[10]*b),a.set(11,a[11]*b),a.set(12,a[12]*b),a.set(13,a[13]*b),a.set(14,a[14]*b),a.set(15,a[15]*b);return a},a.addInPlaceMat4=function(a,b){a.set(0,a[0]+b[0]),a.set(1,a[1]+b[1]),a.set(2,a[2]+b[2]),a.set(3,a[3]+b[3]),a.set(4,a[4]+b[4]),a.set(5,a[5]+b[5]),a.set(6,a[6]+b[6]),a.set(7,a[7]+b[7]),a.set(8,a[8]+b[8]),a.set(9,a[9]+b[9]),a.set(10,a[10]+b[10]),a.set(11,a[11]+b[11]),a.set(12,a[12]+b[12]),a.set(13,a[13]+b[13]),a.set(14,a[14]+b[14]),a.set(15,a[15]+b[15]);return a},a.addMat4=function(b,c){return a.Mat([b[0]+c[0],b[1]+c[1],b[2]+c[2],b[3]+c[3],b[4]+c[4],b[5]+c[5],b[6]+c[6],b[7]+c[7],b[8]+c[8],b[9]+c[9],b[10]+c[10],b[11]+c[11],b[12]+c[12],b[13]+c[13],b[14]+c[14],b[15]+c[15]])},a.subInPlaceMat4=function(a,b){a.set(0,a[0]-b[0]),a.set(1,a[1]-b[1]),a.set(2,a[2]-b[2]),a.set(3,a[3]-b[3]),a.set(4,a[4]-b[4]),a.set(5,a[5]-b[5]),a.set(6,a[6]-b[6]),a.set(7,a[7]-b[7]),a.set(8,a[8]-b[8]),a.set(9,a[9]-b[9]),a.set(10,a[10]-b[10]),a.set(11,a[11]-b[11]),a.set(12,a[12]-b[12]),a.set(13,a[13]-b[13]),a.set(14,a[14]-b[14]),a.set(15,a[15]-b[15]);return a},a.subMat4=function(b,c){return a.Mat([b[0]-c[0],b[1]-c[1],b[2]-c[2],b[3]-c[3],b[4]-c[4],b[5]-c[5],b[6]-c[6],b[7]-c[7],b[8]-c[8],b[9]-c[9],b[10]-c[10],b[11]-c[11],b[12]-c[12],b[13]-c[13],b[14]-c[14],b[15]-c[15]])},a.mulMat4=function(b,c){var d=c[0],e=c[1],f=c[2],g=c[3],h=c[4],i=c[5],j=c[6],k=c[7],l=c[8],m=c[9],n=c[10],o=c[11],p=c[12],q=c[13],r=c[14],s=c[15],t=b[0],u=b[1],v=b[2],w=b[3],x=b[4],y=b[5],z=b[6],A=b[7],B=b[8],C=b[9],D=b[10],E=b[11],F=b[12],G=b[13],H=b[14],I=b[15];return a.matrix4(t*d+u*h+v*l+w*p,t*e+u*i+v*m+w*q,t*f+u*j+v*n+w*r,t*g+u*k+v*o+w*s,x*d+y*h+z*l+A*p,x*e+y*i+z*m+A*q,x*f+y*j+z*n+A*r,x*g+y*k+z*o+A*s,B*d+C*h+D*l+E*p,B*e+C*i+D*m+E*q,B*f+C*j+D*n+E*r,B*g+C*k+D*o+E*s,F*d+G*h+H*l+I*p,F*e+G*i+H*m+I*q,F*f+G*j+H*n+I*r,F*g+G*k+H*o+I*s)},a.transposeInPlaceMat4=function(a){var b=a[1];a.set(1,a[4]),a.set(4,b),b=a[8],a.set(8,a[2]),a.set(2,b),b=a[3],a.set(3,a[12]),a.set(12,b),b=a[9],a.set(9,a[6]),a.set(6,b),b=a[13],a.set(13,a[7]),a.set(7,b),b=a[14],a.set(14,a[11]),a.set(11,b)},a.transposeMat4=function(b){return a.matrix4(b[0],b[4],b[8],b[12],b[1],b[5],b[9],b[13],b[2],b[6],b[10],b[14],b[3],b[7],b[11],b[15])},a.mat4gl=function(a,b){b[0]=a[0],b[1]=a[1],b[2]=a[2],b[3]=a[3],b[4]=a[4],b[5]=a[5],b[6]=a[6],b[7]=a[7],b[8]=a[8],b[9]=a[9],b[10]=a[10],b[11]=a[11],b[12]=a[12],b[13]=a[13],b[14]=a[14],b[15]=a[15]},a.set1basedMat4=function(a,b,c,d){a[(b-1)*4+(c-1)]=d,a.glData!==undefined&&delete a.glData},a.setMat4=function(a,b,c,d){a[b*4+c]=d,a.glData!==undefined&&delete a.glData},a.get1basedMat4=function(a,b,c){return a.get((b-1)*4+(c-1))},a.getMat4=function(a,b,c){return a[b*4+c]},a.glDataMat4=function(a){a.glArray=new Float32Array(a);return a.glArray},a.identMatrix=function(){return a.matrix4(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)},a.translateMatrix=function(b){var c,d,e;arguments.length==3?(c=arguments[0],d=arguments[1],e=arguments[2]):b.data?(c=b.data[0],d=b.data[1],e=b.data[2]):b instanceof Array&&(c=b[0],d=b[1],e=b[2]);return a.matrix4(1,0,0,c,0,1,0,d,0,0,1,e,0,0,0,1)},a.scaleMatrix=function(b){var c,d,e;arguments.length==3?(c=arguments[0],d=arguments[1],e=arguments[2]):b.data?(c=b.data[0],d=b.data[1],e=b.data[2]):b instanceof Array&&(c=b[0],d=b[1],e=b[2]);return a.matrix4(c,0,0,0,0,d,0,0,0,0,e,0,0,0,0,1)},a.ROT_XYZ=1,a.ROT_XZY=2,a.ROT_YXZ=3,a.ROT_YZX=4,a.ROT_ZXY=5,a.ROT_ZYX=6,a.rotateMatrix=function(b,c){var d,e,f;arguments.length>2?(d=arguments[0],e=arguments[1],f=arguments[2],c=arguments[3]):b.data?(d=b.data[0],e=b.data[1],f=b.data[2]):b instanceof Array&&(d=b[0],e=b[1],f=b[2]),c||(c=a.ROT_XYZ);var g=Math.cos(d),h=Math.sin(d),i=Math.cos(e),j=Math.sin(e),k=Math.cos(f),l=Math.sin(f),m=a.matrix4(1,0,0,0,0,g,-h,0,0,h,g,0,0,0,0,1),n=a.matrix4(i,0,j,0,0,1,0,0,-j,0,i,0,0,0,0,1),o=a.matrix4(k,-l,0,0,l,k,0,0,0,0,1,0,0,0,0,1);switch(c){case a.ROT_XYZ:return a.mulMat4(m,a.mulMat4(n,o));case a.ROT_XZY:return a.mulMat4(m,a.mulMat4(o,n));case a.ROT_YXZ:return a.mulMat4(n,a.mulMat4(m,o));case a.ROT_YZX:return a.mulMat4(n,a.mulMat4(o,m));case a.ROT_ZXY:return a.mulMat4(o,a.mulMat4(m,n));case a.ROT_ZYX:return a.mulMat4(o,a.mulMat4(n,m))}},a.angleAxis=function(b,c){var d,e,f,g,h,i,j,k,l;c=[c[0],c[1],c[2],0];var m=c[0],n=c[1],o=c[2],p=Math.cos(b),q=1-p,r=Math.sin(b);j=m*r,k=n*r,l=o*r,d=m*m,e=n*n,f=o*o,g=m*n,h=n*o,i=o*m;var s=a.matrix4(q*d+p,q*g-l,q*i+k,0,q*g+l,q*e+p,q*h-j,0,q*i-k,q*h+j,q*f+p,0,0,0,0,1);return a.Mat(s)},a.quatFromAxisAngle=function(a,b){var c=[],d=b*.5,e=Math.sin(d),f=Math.cos(d);c[0]=a[0]*e,c[1]=a[1]*e,c[2]=a[2]*e,c[3]=f;return c},a.mulQuat=function(a,b){var c=[],d=a[0],e=a[1],f=a[2],g=a[3],h=b[0],i=b[1],j=b[2],k=b[3],l=e*j-f*i,m=f*h-d*j,n=d*i-e*h,o=d*h+e*i+f*j;c[0]=d*k+h*g+l,c[1]=e*k+i*g+m,c[2]=f*k+j*g+n,c[3]=g*k-o;return c},a.mat4FromQuat=function(a){var b=a[0]*a[0],c=a[1]*a[1],d=a[2]*a[2],e=a[0]*a[1],f=a[2]*a[3],g=a[2]*a[0],h=a[1]*a[3],i=a[1]*a[2],j=a[0]*a[3],k=[];k[0]=1-2*(c+d),k[1]=2*(e+f),k[2]=2*(g-h),k[3]=0,k[4]=2*(e-f),k[5]=1-2*(d+b),k[6]=2*(i+j),k[7]=0,k[8]=2*(g+h),k[9]=2*(i-j),k[10]=1-2*(c+b),k[11]=0,k[12]=0,k[13]=0,k[14]=0,k[15]=1;return k},a.quatRotation=function(b,c,d,e){return a.matrix4(1-2*c*c-2*d*d,2*b*c-2*d*e,2*b*d+2*c*e,0,2*b*c+2*d*e,1-2*b*b-2*d*d,2*c*d-2*b*e,0,2*b*d-2*c*e,2*c*d+2*b*e,1-2*b*b-2*c*c,0,0,0,0,1)},a.makeOrtho=function(b,c,d,e,f,g){var h=-(c+b)/(c-b),i=-(e+d)/(e-d),j=-(g+f)/(g-f);return a.matrix4(2/(c-b),0,0,h,0,2/(e-d),0,i,0,0,-2/(g-f),j,0,0,0,1)},a.makeFrustum=function(b,c,d,e,f,g){var h=2*f/(c-b),i=2*f/(e-d),j=(c+b)/(c-b),k=(e+d)/(e-d),l=-(g+f)/(g-f),m=-2*g*f/(g-f);return a.matrix4(h,0,j,0,0,i,k,0,0,0,l,m,0,0,-1,0)},a.makePerspective=function(b,c,d,e){var f=d*Math.tan(b*.00872664625972),g=-f,h=g*c,i=f*c;return a.makeFrustum(h,i,g,f,d,e)},a.makePerspectiveX=function(b,c,d,e){var f=d*Math.tan(b*.00872664625972),g=-f,h=g/c,i=f/c;return a.makeFrustum(g,f,h,i,d,e)},a.matrix2Scale=function(a){var b=a[0],c=a[1],d=a[2],e=a[4],f=a[5],g=a[6],h=a[8],i=a[9],j=a[10],k=Math.sqrt(b*b+c*c+d*d),l=Math.sqrt(e*e+f*f+g*g),m=Math.sqrt(h*h+i*i+j*j);return[k,l,m]},a.rotationMatrix2Quat=function(a){var b=a[0]+a[5]+a[10]+1,c,d,e,f,g;b>0?(c=.5/Math.sqrt(b),g=.25/c,d=(a[9]-a[6])*c,e=(a[2]-a[8])*c,f=(a[4]-a[1])*c):a[0]>a[5]&&a[0]>a[10]?(c=Math.sqrt(1+a[0]-a[5]-a[10])*2,g=(a[9]-a[6])/c,d=.25/c,e=(a[1]+a[4])/c,f=(a[2]+a[8])/c):a[5]>a[10]?(c=Math.sqrt(1+a[5]-a[0]-a[10])*2,g=(a[2]-a[8])/c,d=(a[1]+a[4])/c,e=.25/c,f=(a[6]+a[9])/c):(c=Math.sqrt(1+a[10]-a[0]-a[5])*2,g=(a[4]-a[1])/c,d=(a[2]+a[8])/c,e=(a[6]+a[9])/c,f=.25/c);var h=Math.sqrt(d*d+e*e+f*f+g*g);return[d/h,e/h,f/h,g/h]},a.rayToPlane=function(b,c){var d=a.toUnitVec3(c);return[d[0],d[1],d[2],a.dotVec3(b,d)]},a.rayIntersectPlane=function(b,c,d){var e=[d[0],d[1],d[2]],f=d[3],g=a.dotVec3(e,c);if(g<=0)return!1;var h=-(a.dotVec3(e,b)+f),i=h/g;if(i<=0)return!1;return a.addVec3(b,a.scaleVec3(c,i))},a.screenToDirection=function(b,c,d,e,f){xcoord=-(2*b/d-1)/f[0],ycoord=(2*c/e-1)/f[5],zcoord=1;return a.toUnitVec3([xcoord,ycoord,zcoord])},a.BoundingVolume=function(a,b,c,d,e,f){this.limits=[a,b,c,d,e,f],this.calcProps()},a.BoundingVolume.prototype.getCornerPoints=function(){return this.points},a.BoundingVolume.prototype.getSphereRadius=function(){return this.radius},a.BoundingVolume.prototype.getCenter=function(){return this.center},a.BoundingVolume.prototype.isNull=function(){return this.limits[0]==0&&this.limits[1]==0&&this.limits[2]==0&&this.limits[3]==0&&this.limits[4]==0&&this.limits[5]==0},a.BoundingVolume.prototype.addBoundingVolume=function(a){this.isNull()?(this.limits[0]=a.limits[0],this.limits[1]=a.limits[1],this.limits[2]=a.limits[2],this.limits[3]=a.limits[3],this.limits[4]=a.limits[4],this.limits[5]=a.limits[5]):a.isNull()||(this.limits[0]=Math.min(a.limits[0],this.limits[0]),this.limits[2]=Math.min(a.limits[2],this.limits[2]),this.limits[4]=Math.min(a.limits[4],this.limits[4]),this.limits[1]=Math.max(a.limits[1],this.limits[1]),this.limits[3]=Math.max(a.limits[3],this.limits[3]),this.limits[5]=Math.max(a.limits[5],this.limits[5])),this.calcProps()},a.BoundingVolume.prototype.applyMatrix=function(b){var c=a.mulMat4Vec4(b,[this.limits[0],this.limits[2],this.limits[4],1]),d=a.mulMat4Vec4(b,[this.limits[1],this.limits[2],this.limits[4],1]),e=a.mulMat4Vec4(b,[this.limits[0],this.limits[3],this.limits[4],1]),f=a.mulMat4Vec4(b,[this.limits[1],this.limits[3],this.limits[4],1]),g=a.mulMat4Vec4(b,[this.limits[0],this.limits[2],this.limits[5],1]),h=a.mulMat4Vec4(b,[this.limits[1],this.limits[2],this.limits[5],1]),i=a.mulMat4Vec4(b,[this.limits[0],this.limits[3],this.limits[5],1]),j=a.mulMat4Vec4(b,[this.limits[1],this.limits[3],this.limits[5],1]);this.limits[0]=Math.min(c[0],d[0],e[0],f[0],g[0],h[0],i[0],j[0]),this.limits[1]=Math.max(c[0],d[0],e[0],f[0],g[0],h[0],i[0],j[0]),this.limits[2]=Math.min(c[1],d[1],e[1],f[1],g[1],h[1],i[1],j[1]),this.limits[3]=Math.max(c[1],d[1],e[1],f[1],g[1],h[1],i[1],j[1]),this.limits[4]=Math.min(c[2],d[2],e[2],f[2],g[2],h[2],i[2],j[2]),this.limits[5]=Math.max(c[2],d[2],e[2],f[2],g[2],h[2],i[2],j[2]),this.calcProps()},a.BoundingVolume.prototype.calcProps=function(){var a=this.limits[0],b=this.limits[1],c=this.limits[2],d=this.limits[3],e=this.limits[4],f=this.limits[5];this.points=[[a,c,e],[b,c,e],[a,d,e],[b,d,e],[a,c,f],[b,c,f],[a,d,f],[b,d,f]],this.center=[(this.limits[1]-this.limits[0])/2+this.limits[0],(this.limits[3]-this.limits[2])/2+this.limits[2],(this.limits[5]-this.limits[4])/2+this.limits[4]];var g=this.limits[0]-this.center[0],h=this.limits[2]-this.center[1],i=this.limits[4]-this.center[2];this.radius=Math.sqrt(g*g+h*h+i*i)},a.BoundingVolume.prototype.clone=function(){return new a.BoundingVolume(this.limits[0],this.limits[1],this.limits[2],this.limits[3],this.limits[4],this.limits[5])},a.BoundingVolume.prototype.toString=function(){return this.limits.toString()},a.cameraViewProjectionToPlanes=function(b){var c=a.inverseMat4(b),d=a.mulMat4Vec4,e=a.subVec3,f=a.crossVec3,g=a.toUnitVec3,h=a.dotVec3,i=d(c,[-1,-1,-1,1]),j=d(c,[1,-1,-1,1]),k=d(c,[-1,-1,1,1]),l=d(c,[1,1,-1,1]),m=d(c,[1,1,1,1]),n=d(c,[-1,1,1,1]);i=[i[0]/i[3],i[1]/i[3],i[2]/i[3]],j=[j[0]/j[3],j[1]/j[3],j[2]/j[3]],k=[k[0]/k[3],k[1]/k[3],k[2]/k[3]],l=[l[0]/l[3],l[1]/l[3],l[2]/l[3]],m=[m[0]/m[3],m[1]/m[3],m[2]/m[3]],n=[n[0]/n[3],n[1]/n[3],n[2]/n[3]];var o=g(f(e(l,j),e(i,j))),p=g(f(e(n,k),e(m,k))),q=g(f(e(i,k),e(n,k))),r=g(f(e(m,l),e(l,j))),s=g(f(e(n,l),e(l,m))),t=g(f(e(i,j),e(k,i)));o.push(h(o,i)),p.push(h(p,k)),q.push(h(q,i)),r.push(h(r,j)),s.push(h(s,m)),t.push(h(t,i));return[o,p,q,r,s,t]},a.sphereInFrustumPlanes=function(a,b){var c=a[0],d=a[1],e=a[2],f=a[3],g=b[0],h=b[1],i=b[2],j=b[3],k=b[4],l=b[5];return c*g[0]+d*g[1]+e*g[2]-g[3]-f>0||c*h[0]+d*h[1]+e*h[2]-h[3]-f>0||c*i[0]+d*i[1]+e*i[2]-i[3]-f>0||c*j[0]+d*j[1]+e*j[2]-j[3]-f>0||c*k[0]+d*k[1]+e*k[2]-k[3]-f>0||c*l[0]+d*l[1]+e*l[2]-l[3]-f>0?!1:!0},a.pointsInFrustumPlanes=function(a,b){var c=b[0],d=b[1],e=b[2],f=b[3],g=b[4],h=b[5],i,j,k;for(var l=0;l<a.length;l++){i=a[l][0],j=a[l][1],k=a[l][2];if(i*c[0]+j*c[1]+k*c[2]-c[3]>0&&i*d[0]+j*d[1]+k*d[2]-d[3]>0&&i*e[0]+j*e[1]+k*e[2]-f[3]>0&&i*f[0]+j*f[1]+k*f[2]-g[3]>0&&i*g[0]+j*g[1]+k*g[2]-g[3]>0&&i*h[0]+j*h[1]+k*h[2]-h[3]>0)return!1}return!0},a.getDirLightProjection=function(b,c,d,e){var f=a.mulMat4(c,a.inverseMat4(b)),g=[0,0,0],h=[0,0,0];for(var i=0;i<2;i++)for(var j=0;j<2;j++)for(var k=0;k<2;k++){var l=a.mulMat4Vec4(f,[i*2-1,j*2-1,k*2-1,1]);l[0]=l[0]/l[3],l[1]=l[1]/l[3],l[2]=l[2]/l[3],g[0]=g[0]>l[0]?l[0]:g[0],g[1]=g[1]>l[1]?l[1]:g[1],h[0]=h[0]<l[0]?l[0]:h[0],h[1]=h[1]<l[1]?l[1]:h[1],h[2]=h[2]<l[2]?l[2]:h[2]}var m=a.makeOrtho(g[0],h[0],g[1],h[1],.01,+e);return m},c()}(GLGE),typeof GLGE=="undefined"&&(GLGE={}),function(a){var b=function(a){return typeof a!="number"?parseFloat(a):a};a.augment=function(a,b){b.prototype.baseclass=a;for(var c in a.prototype)b.prototype[c]?b.prototype.baseclass[c]=a.prototype[c]:b.prototype[c]=a.prototype[c]},a.makeGlobal=function(){for(var b in a)window[b]=a[b]},a.New=function(b){return a[b].prototype.className!=""?new a[b]:!1},a.TRUE=1,a.FALSE=0,a.GLOBAL=0,a.LOCAL=1,a.DRAW_TRIS=1,a.DRAW_LINES=2,a.DRAW_LINELOOPS=3,a.DRAW_LINESTRIPS=4,a.DRAW_POINTS=5,a.DRAW_TRIANGLESTRIP=6,a.RENDER_DEFAULT=0,a.RENDER_SHADOW=1,a.RENDER_PICK=2,a.RENDER_NORMAL=3,a.RENDER_EMIT=4,a.RENDER_DEPTH=5,a.RENDER_NULL=6,a.TEXT_BOXPICK=1,a.TEXT_TEXTPICK=2,a.P_EULER=1,a.P_QUAT=2,a.P_MATRIX=3,a.NONE=0,a.XAXIS=1,a.YAXIS=2,a.ZAXIS=3,a.POS_XAXIS=1,a.NEG_XAXIS=2,a.POS_YAXIS=3,a.NEG_YAXIS=4,a.POS_ZAXIS=5,a.NEG_ZAXIS=6,a.ZERO="ZERO",a.ONE="ONE",a.SRC_COLOR="SRC_COLOR",a.ONE_MINUS_SRC_COLOR="ONE_MINUS_SRC_COLOR",a.SRC_ALPHA="SRC_ALPHA",a.ONE_MINUS_SRC_ALPHA="ONE_MINUS_SRC_ALPHA",a.DST_ALPHA="DST_ALPHA",a.ONE_MINUS_DST_ALPHA="ONE_MINUS_DST_ALPHA",a.LINEAR_BLEND=function(a){return a},a.QUAD_BLEND=function(a){return a*a},a.SPECIAL_BLEND=function(a){a=a*(2-a);return a*a},a.error=function(a){console&&console.log&&console.log("GLGE error: "+a)},a.warning=function(a){console&&console.log&&console.log("GLGE warning: "+a)},a.Assets={},a.Assets.assets={},a.REGISTER_ASSETS=!1,a.Assets.createUUID=function(){var a=["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"],b=["8","9","A","B"];uuid="";for(var c=0;c<38;c++)switch(c){case 8:uuid=uuid+"-";break;case 13:uuid=uuid+"-";break;case 18:uuid=uuid+"-";break;case 14:uuid=uuid+"4";break;case 19:uuid=uuid+b[Math.round(Math.random()*3)];break;default:uuid=uuid+a[Math.round(Math.random()*15)]}return uuid},a.Assets.registerAsset=function(b,c){typeof c=="object"&&(b._&&b._(c),c=c.uid),c||(c=a.Assets.createUUID()),b.uid=c,a.REGISTER_ASSETS&&(a.Assets.assets[c]=b)},a.Assets.unregisterAsset=function(b){delete a.Assets.assets[b]},a.Assets.get=function(b){var c=a.Assets.assets[b];return c?c:!1},a.DJBHash=function(a){var b=5381;for(var c=0;c<a.length;c++)b=(b<<5)+b+a.charCodeAt(c);return b},a.getGLShader=function(b,c,d){var e=a.DJBHash(d);b.shaderCache||(b.shaderCache={});if(!b.shaderCache[e]){var f=b.createShader(c);b.shaderSource(f,d),b.compileShader(f);if(!b.getShaderParameter(f,b.COMPILE_STATUS))try{a.error(b.getShaderInfoLog(f));return}catch(g){}b.shaderCache[e]=f}return b.shaderCache[e]};var c=0;a.getGLProgram=function(b,d,e){b.programCache||(b.programCache=[]);var f=b.programCache;for(var g=0;g<f.length;g++)if(f[g].fShader==e&&f[g].vShader==d)return f[g].program;var h=b.createProgram();h.progIdx=c++,b.attachShader(h,d),b.attachShader(h,e),b.linkProgram(h),b.getProgramParameter(h,b.LINK_STATUS)||a.error("Couldn't link shader: "+b.getProgramInfoLog(h)),f.push({vShader:d,fShader:e,program:h});if(!h.uniformDetails){h.uniformDetails={};var i=b.getProgramParameter(h,b.ACTIVE_UNIFORMS);for(var g=0;g<i;++g){var j=b.getActiveUniform(h,g);h.uniformDetails[j.name]={loc:a.getUniformLocation(b,h,j.name),info:j}}}return h},a.getUniformLocation=function(a,b,c){b.uniformCache||(b.uniformCache={}),b.uniformChecked||(b.uniformChecked={}),b.uniformChecked[c]||(b.uniformCache[c]=a.getUniformLocation(b,c),b.uniformChecked[c]=!0);return b.uniformCache[c]},a.setUniform=function(a,b,c,d){typeof d=="string"&&(d=+d),c!=null&&a["uniform"+b](c,d)},a.setUniform3=function(a,b,c,d,e,f){typeof d=="string"&&(d=+d),typeof e=="string"&&(e=+e),typeof f=="string"&&(f=+f),c!=null&&a["uniform"+b](c,d,e,f)},a.setUniform2=function(a,b,c,d,e){typeof d=="string"&&(d=+d),typeof e=="string"&&(e=+e),c!=null&&a["uniform"+b](c,d,e)},a.setUniform4=function(a,b,c,d,e,f,g){c!=null&&a["uniform"+b](c,d,e,f,g)},a.setUniformMatrix=function(a,b,c,d,e){c!=null&&a["uniform"+b](c,d,e)},a.getAttribLocation=function(a,b,c){b.attribCache||(b.attribCache={}),b.attribCache[c]==undefined&&(b.attribCache[c]=a.getAttribLocation(b,c));return b.attribCache[c]},a.colorParse=function(a){var b,c,d,e,f={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"};f[a]&&(a="#"+f[a]);if(a.substr&&a.substr(0,1)=="#")a=a.substr(1),a.length==8?(b=parseInt("0x"+a.substr(0,2))/255,c=parseInt("0x"+a.substr(2,2))/255,d=parseInt("0x"+a.substr(4,2))/255,e=parseInt("0x"+a.substr(6,2))/255):a.length==4?(b=parseInt("0x"+a.substr(0,1))/15,c=parseInt("0x"+a.substr(1,1))/15,d=parseInt("0x"+a.substr(2,1))/15,e=parseInt("0x"+a.substr(3,1))/15):a.length==6?(b=parseInt("0x"+a.substr(0,2))/255,c=parseInt("0x"+a.substr(2,2))/255,d=parseInt("0x"+a.substr(4,2))/255,e=1):a.length==3&&(b=parseInt("0x"+a.substr(0,1))/15,c=parseInt("0x"+a.substr(1,1))/15,d=parseInt("0x"+a.substr(2,1))/15,e=1);else if(a.substr&&a.substr(0,4)=="rgb("){var g=a.substr(4).split(",");b=parseInt(g[0])/255,c=parseInt(g[1])/255,d=parseInt(g[2])/255,e=1}else if(a.substr&&a.substr(0,5)=="rgba("){var g=a.substr(4).split(",");b=parseInt(g[0])/255,c=parseInt(g[1])/255,d=parseInt(g[2])/255,e=parseInt(g[3])/255}else b=0,c=0,d=0,e=0;return{r:b,g:c,b:d,a:e}}}(GLGE),function(a){a.Events=function(){},a.Events.prototype.fireEvent=function(a,b){if(this.events&&this.events[a]){var c=this.events[a];for(var d=0;d<c.length;d++)c[d]&&c[d].call&&c[d].call(this,b)}},a.Events.prototype.addEventListener=function(a,b){this.events||(this.events={}),this.events[a]||(this.events[a]=[]),this.events[a].push(b)},a.Events.prototype.removeEventListener=function(a,b){if(this.events[a]){var c=this.events[a].indexOf(b);c!=-1&&this.events[a].splice(c,1)}}}(GLGE),function(a){a.QuickNotation=function(){},a.QuickNotation.prototype._=function(){var a;for(var b=0;b<arguments.length;b++){a=arguments[b];if(typeof a=="object")if(a.className&&this["add"+a.className])this["add"+a.className](a);else for(var c in a)this["set"+c]&&this["set"+c](a[c])}return this}}(GLGE),function(a){a.Animatable=function(){},a.augment(a.Events,a.Animatable),a.Animatable.prototype.animationStart=null,a.Animatable.prototype.animation=null,a.Animatable.prototype.blendStart=0,a.Animatable.prototype.blendTime=0,a.Animatable.prototype.lastFrame=null,a.Animatable.prototype.frameRate=30,a.Animatable.prototype.loop=a.TRUE,a.Animatable.prototype.paused=a.FALSE,a.Animatable.prototype.pausedTime=null,a.Animatable.prototype.blendFunction=a.LINEAR_BLEND,a.Animatable.prototype.blendTo=function(b,c,d){d||(d=a.LINEAR_BLEND);var e=new a.AnimationVector,f,g;for(var h in b)f=new a.AnimationCurve,f.setChannel(h),g=new a.LinearPoint,g.setX(1),g.setY(b[h]),f.addPoint(g),e.addAnimationCurve(f);this.setBlendFunction(d),this.setAnimation(e,c);return this},a.Animatable.prototype.setBlendFunction=function(a){this.blendFunction=a;return this},a.Animatable.prototype.getBlendFunction=function(){return this.blendFunction},a.Animatable.prototype.setName=function(a){this.name=a;return this},a.Animatable.prototype.getName=function(){return this.name},a.Animatable.prototype.getFrameNumber=function(a){this.startFrame||(this.startFrame=this.animation.startFrame),this.animFrames||(this.animFrames=this.animation.frames);var b;a||(a=parseInt((new Date).getTime())),this.animFrames>1?this.loop?b=(parseFloat(a)-parseFloat(this.animationStart))/1e3*this.frameRate%(this.animFrames-1)+1+this.startFrame:(b=(parseFloat(a)-parseFloat(this.animationStart))/1e3*this.frameRate+1+this.startFrame,b>=this.animFrames+this.startFrame&&(b=this.animFrames)):b=1;return Math.round(b)},a.Animatable.prototype.setStartFrame=function(a,b,c){this.loop=c;var d=parseInt((new Date).getTime());b||(b=0),b>0&&(this.animation&&(this.blendInitValues=this.getInitialValues(this.animation,d),this.blendTime=b)),this.animationStart=d,this.lastFrame=null,this.animFinished=!1,this.startFrame=a;if(this.children)for(var e=0;e<this.children.length;e++)this.children[e].setStartFrame&&this.children[e].setStartFrame(a,b,c);return this},a.Animatable.prototype.setFrames=function(a){this.animFrames=a;if(this.children)for(var b=0;b<this.children.length;b++)this.children[b].setFrames&&this.children[b].setFrames(a);return this},a.Animatable.prototype.getInitialValues=function(a,b){var c={};this.animation&&(this.lastFrame=null,this.animate(b,!0));for(var d in a.curves)this["get"+d]&&(c[d]=this["get"+d]());return c},a.Animatable.prototype.animate=function(a,b){if(!this.paused&&this.animation){a||(a=parseInt((new Date).getTime()));var c=this.getFrameNumber(a);this.animation.animationCache||(this.animation.animationCache={});if(c!=this.lastFrame||this.blendTime!=0){this.lastFrame=c;if(this.blendTime==0)if(!this.animation.animationCache[c]||b){this.animation.animationCache[c]=[];if(this.animation.curves.LocX&&this.animation.curves.LocY&&this.animation.curves.LocZ&&this.animation.curves.ScaleX&&this.animation.curves.ScaleY&&this.animation.curves.ScaleZ&&this.animation.curves.QuatX&&this.animation.curves.QuatY&&this.animation.curves.QuatZ&&this.animation.curves.QuatW){for(var d in this.animation.curves)if(this["set"+d]){var e=this.animation.curves[d].getValue(parseFloat(c));switch(d){case"QuatX":case"QuatY":case"QuatZ":case"QuatW":case"LocX":case"LocY":case"LocZ":case"ScaleX":case"ScaleY":case"ScaleZ":break;default:this.animation.animationCache[c].push({property:d,value:e})}this["set"+d](e)}this.animation.animationCache[c].push({property:"StaticMatrix",value:this.getLocalMatrix()})}else{for(d in this.animation.curves)if(this["set"+d]){var e=this.animation.curves[d].getValue(parseFloat(c));switch(d){case"QuatX":case"QuatY":case"QuatZ":case"QuatW":case"RotX":case"RotY":case"RotZ":var f=!0;break;default:this.animation.animationCache[c].push({property:d,value:e})}this["set"+d](e)}f&&(e=this.getRotMatrix(),this.animation.animationCache[c].push({property:"RotMatrix",value:e}))}}else{var g=this.animation.animationCache[c];for(var h=0;h<g.length;h++)this["set"+g[h].property]&&this["set"+g[h].property](g[h].value)}else{var i=a-this.animationStart;if(i<this.blendTime){var j=i/this.blendTime;j=this.blendFunction(j);for(d in this.animation.curves)if(this["set"+d]){var e=this.animation.curves[d].getValue(parseFloat(c));e=e*j+this.blendInitValues[d]*(1-j),this["set"+d](e)}}else this.blendTime=0}}}if(this.children)for(var h=0;h<this.children.length;h++)this.children[h].animate&&this.children[h].animate(a,b);this.animation&&!this.animFinished&&this.blendTime==0&&this.animation.frames==c&&!b&&(this.animFinished=!0,this.fireEvent("animFinished",{}))},a.Animatable.prototype.setAnimation=function(a,b,c){c==null&&(c=parseInt((new Date).getTime())),b||(b=0),b>0&&(this.blendInitValues=this.getInitialValues(a,c),this.blendTime=b),this.animFrames=null,this.startFrame=null,this.animationStart=c,this.lastFrame=null,this.animation=a,this.animFinished=!1;return this},a.Animatable.prototype.getAnimation=function(){return this.animation},a.Animatable.prototype.setFrameRate=function(a){this.frameRate=a;if(this.children)for(var b=0;b<this.children.length;b++)this.children[b].setFrameRate&&this.children[b].setFrameRate(a);return this},a.Animatable.prototype.getFrameRate=function(){return this.frameRate},a.Animatable.prototype.setLoop=function(a){this.loop=a;return this},a.Animatable.prototype.getLoop=function(){return this.loop},a.Animatable.prototype.isLooping=a.Animatable.prototype.getLoop,a.Animatable.prototype.setPaused=function(a){a?this.pauseTime=parseInt((new Date).getTime()):this.animationStart=this.animationStart+(parseInt((new Date).getTime())-this.pauseTime),this.paused=a;return this},a.Animatable.prototype.getPaused=function(){return this.paused},a.Animatable.prototype.togglePaused=function(){this.setPaused(!this.getPaused());return this.paused}}(GLGE),function(a){a.Document=function(){this.listeners=[],this.documents=[]},a.Document.prototype.listeners=null,a.Document.prototype.documents=null,a.Document.prototype.rootURL=null,a.Document.prototype.loadCount=0,a.Document.prototype.version=0,a.Document.prototype.preloader=null,a.Document.prototype.getElementById=function(a){var b=this.getElementsByTagName("*");for(var c=0;c<b.length;c++)if(b[c].getAttribute("id")==a)return b[c];return null},a.Document.prototype.getAbsolutePath=function(a,b){if(a.substr(0,7)=="http://"||a.substr(0,7)=="file://"||a.substr(0,8)=="https://")return a;b||(b=window.location.href);var c=b.split("/"),d=c[2],e=c[0],f=[];for(var g=3;g<c.length-1;g++)f.push(c[g]);a.substr(0,1)=="/"&&(f=[]);var h=a.split("/");for(var g=0;g<h.length;g++)h[g]==".."?f.pop():h[g]!=""&&f.push(h[g]);return e+"//"+d+"/"+f.join("/")},a.Document.prototype.load=function(a,b){b&&this.usePreloader(b),this.documents=[],this.rootURL=a,this.loadDocument(a,null)},a.Document.prototype.loadDocument=function(b,c){this.loadCount++,b=this.getAbsolutePath(b,c);if(this.preloader)this.preloader.loadXMLFile(b);else{var d=new XMLHttpRequest;d&&(d.docurl=b,d.docObj=this,d.overrideMimeType("text/xml"),d.onreadystatechange=function(){this.readyState==4&&(this.status==200||this.status==0?(this.responseXML.getElementById=this.docObj.getElementById,this.docObj.loaded(this.docurl,this.responseXML)):a.error("Error loading Document: "+this.docurl+" status "+this.status))},d.open("GET",b,!0),d.send(""))}},a.Document.prototype.loaded=function(a,b){this.loadCount--,this.documents[a]={xml:b,url:a};var c=b.getElementsByTagName("glge");c[0]&&c[0].hasAttribute("version")&&(this.version=parseFloat(c[0].getAttribute("version")));var d=b.getElementsByTagName("import");for(var e=0;e<d.length;e++)this.documents[this.getAbsolutePath(d[e].getAttribute("url"),a)]||(this.documents[this.getAbsolutePath(d[e].getAttribute("url"),a)]={},this.loadDocument(d[e].getAttribute("url"),a));this.loadCount==0&&this.finishedLoading()},a.Document.prototype.finishedLoading=function(){for(var a=0;a<this.listeners.length;a++)this.listeners[a](this.rootURL);this.onLoad()},a.Document.prototype.onLoad=function(){},a.Document.prototype.usePreloader=function(b){this.preloader=new a.DocumentPreloader(this,b);var c=this;this.addLoadListener(function(a){c.preloadImages.call(c)})},a.Document.prototype.preloadImages=function(){var a=[],b=[];for(var c in this.documents)this.documents[c].xml&&(a.push(this.documents[c].xml.getElementsByTagName("texture")),b.push(this.documents[c].url));for(var d in a)for(var e=0;e<a[d].length;e++){var f=a[d][e].getAttribute("src");f&&this.preloader.addImage(this.getAbsolutePath(f,b[d]))}this.preloader.loadImages()},a.Document.prototype.classString=function(a){if(!a)return!1;var b=a.split("_"),c="";for(var d=0;d<b.length;d++)c=c+b[d][0].toUpperCase()+b[d].substr(1);return c},a.Document.prototype.setProperties=function(b){var c,d,e;for(var f=0;f<b.attributes.length;f++)e=!1,c="set"+this.classString(b.attributes[f].nodeName),b.attributes[f].value[0]=="#"&&(e=this.getElement(b.attributes[f].value.substr(1),!0)),e||(typeof a[b.attributes[f].value]!="undefined"?e=a[b.attributes[f].value]:e=b.attributes[f].value),b.object[c]&&b.object[c](e==parseFloat(e)?parseFloat(e):e),b.attributes[f].nodeName=="uid"&&(a.Assets.unregisterAsset(b.object.uid),b.object.uid=b.attributes[f].value,a.Assets.registerAsset(b.object,b.attributes[f].value))},a.Document.prototype.addChildren=function(a){var b,c=a.firstChild;while(c)b="add"+this.classString(c.tagName),a.object[b]&&a.object[b](this.getElement(c)),c=c.nextSibling},a.Document.prototype.getElement=function(b,c){var d,e;if(typeof b=="string")for(var e in this.documents)if(this.documents[e].xml){d=this.documents[e].xml.getElementById(b);if(d){b=d;break}}if(typeof b=="string"){c||a.error("Element "+b+" not found in document");return!1}return this["get"+this.classString(b.tagName)]?this["get"+this.classString(b.tagName)](b):this.getDefault(b)},a.Document.prototype.getData=function(b){if(!b.object){b.object=this.parseArray(b);if(b.hasAttribute("type")){var c=b.getAttribute("type");switch(c){case"matrix":for(var d=0;d<b.object.length;d++)b.object[d]=a.Mat4(b.object[d].split(" "));break;case"links":for(var d=0;d<b.object.length;d++)b.object[d]=this.getElement(b.object[d].substr(1))}}}return b.object},a.Document.prototype.getDefault=function(b){b.object||(a[this.classString(b.tagName)]?(b.object=new(a[this.classString(b.tagName)]),this.setProperties(b),this.addChildren(b)):a.error("XML Parse Error: GLGE Object not found"));return b.object},a.Document.prototype.getTexture=function(b){if(!b.object){var c=this.getAbsolutePath(this.rootURL,null);b.object=new(a[this.classString(b.tagName)]),b.object.setSrc(this.getAbsolutePath(b.getAttribute("src"),c)),b.removeAttribute("src"),this.setProperties(b)}return b.object},a.Document.prototype.getTextureVideo=a.Document.prototype.getTexture,a.Document.prototype.parseArray=function(a){var b=a.firstChild,c="",d=[],e,f;while(b){e=(c+b.nodeValue).split(","),b=b.nextSibling,e[0]==""&&e.unshift(),b&&(c=e.pop());for(var f=0;f<e.length;f++)d.push(e[f])}return d},a.Document.prototype.getMesh=function(b){if(this.version>0)return this.getDefault(b);if(!b.object){b.object=new a.Mesh,this.setProperties(b);var c=b.firstChild;while(c){switch(c.tagName){case"positions":b.object.setPositions(this.parseArray(c));break;case"normals":b.object.setNormals(this.parseArray(c));break;case"uv1":b.object.setUV(this.parseArray(c));break;case"uv2":b.object.setUV2(this.parseArray(c));break;case"faces":b.object.setFaces(this.parseArray(c));break;case"color":b.object.setVertexColors(this.parseArray(c));break;case"joint_names":var d=this.parseArray(c),e=[];for(var f=0;f<d.length;f++)d[f].substr(0,1)=="#"?e.push(this.getElement(d[f].substr(1))):e.push(d[f]);b.object.setJoints(e);break;case"bind_matrix":var g=this.parseArray(c),h=[];for(var f=0;f<g.length;f++)h.push(a.Mat4(g[f].split(" ")));b.object.setInvBindMatrix(h);break;case"joints":b.object.setVertexJoints(this.parseArray(c),c.getAttribute("count"));break;case"weights":b.object.setVertexWeights(this.parseArray(c),c.getAttribute("count"))}c=c.nextSibling}}return b.object},a.Document.prototype.addLoadListener=function(a){this.listeners.push(a)},a.Document.prototype.removeLoadListener=function(a){for(var b=0;b<this.listeners.length;b++)this.listeners[b]===a&&this.listeners.splice(b,1)},a.Document.prototype.parseScript=function(a){this.rootURL=window.location.toString();var b=document.getElementById(a);if(!b)return null;var c="",d=b.firstChild;while(d)d.nodeType==3&&(c+=d.textContent),d=d.nextSibling;var e=new DOMParser,f=e.parseFromString(c,"text/xml");f.getElementById=this.getElementById,this.documents["#"+a]={xml:f};var g=f.getElementsByTagName("import");for(var h=0;h<g.length;h++)this.documents[this.getAbsolutePath(g[h].getAttribute("url"),url)]||(this.documents[this.getAbsolutePath(g[h].getAttribute("url"),url)]={},this.loadDocument(g[h].getAttribute("url")));this.loadCount==0&&this.finishedLoading()}}(GLGE),function(a){a.ZUP=[0,0,1],a.YUP=[0,1,0],a.XUP=[1,0,0],a.Placeable=function(){},a.Placeable.prototype.locX=0,a.Placeable.prototype.locY=0,a.Placeable.prototype.locZ=0,a.Placeable.prototype.dLocX=0,a.Placeable.prototype.dLocY=0,a.Placeable.prototype.dLocZ=0,a.Placeable.prototype.quatX=0,a.Placeable.prototype.quatY=0,a.Placeable.prototype.quatZ=0,a.Placeable.prototype.quatW=0,a.Placeable.prototype.rotX=0,a.Placeable.prototype.rotY=0,a.Placeable.prototype.rotZ=0,a.Placeable.prototype.dRotX=0,a.Placeable.prototype.dRotY=0,a.Placeable.prototype.dRotZ=0,a.Placeable.prototype.scaleX=1,a.Placeable.prototype.scaleY=1,a.Placeable.prototype.scaleZ=1,a.Placeable.prototype.dScaleX=0,a.Placeable.prototype.dScaleY=0,a.Placeable.prototype.dScaleZ=0,a.Placeable.prototype.matrix=null,a.Placeable.prototype.rotOrder=a.ROT_XYZ,a.Placeable.prototype.lookAt=null,a.Placeable.prototype.mode=a.P_EULER,a.Placeable.prototype.upAxis=a.ZUP,a.Placeable.prototype.getRoot=function(){if(this.type==a.G_ROOT)return this;if(this.parent){var b=this.parent.getRoot();return b?b:this}return this},a.Placeable.prototype.getRef=function(){return this.id?this.id:this.parent?this.parent.getRef():null},a.Placeable.prototype.setId=function(a){this.id=a;return this},a.Placeable.prototype.getId=function(){return this.id},a.Placeable.prototype.getLookat=function(){return this.lookAt},a.Placeable.prototype.setLookat=function(a){this.lookAt=a;return this},a.Placeable.prototype.getUpAxis=function(){return this.upAxis},a.Placeable.prototype.setUpAxis=function(a){this.upAxis=a;return this},a.Placeable.prototype.Lookat=function(b){var c,d=this.getPosition();b.getPosition?c=b.getPosition():c={x:b[0],y:b[1],z:b[2]};var e=[d.x-c.x,d.y-c.y,d.z-c.z],f=a.toUnitVec3(e),g=a.toUnitVec3(a.crossVec3(this.upAxis,f));g[0]==0&&g[1]==0&&g[2]==0&&(g[1]=1);var h=a.toUnitVec3(a.crossVec3(f,g));this.setRotMatrix(a.Mat4([g[0],h[0],f[0],0,g[1],h[1],f[1],0,g[2],h[2],f[2],0,0,0,0,1]))},a.Placeable.prototype.setTransformMode=function(a){this.mode=a,this.matrix=null;return this},a.Placeable.prototype.getRotOrder=function(){return this.rotOrder},a.Placeable.prototype.setRotOrder=function(a){this.rotOrder=a,this.matrix=null,this.rotmatrix=null;return this},a.Placeable.prototype.getRotMatrix=function(){if(!this.rotmatrix){var b=this.getRotation();this.mode==a.P_EULER&&(this.rotmatrix=a.rotateMatrix(b.x,b.y,b.z,this.rotOrder)),this.mode==a.P_QUAT&&(this.rotmatrix=a.quatRotation(b.x,b.y,b.z,b.w))}return this.rotmatrix},a.Placeable.prototype.setRotMatrix=function(b){this.mode=a.P_MATRIX,this.rotmatrix=b,this.updateMatrix();return this},a.Placeable.prototype.setLocX=function(a){this.locX=a,this.translateMatrix=null,this.staticMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setLocY=function(a){this.locY=a,this.translateMatrix=null,this.staticMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setLocZ=function(a){this.locZ=a,this.translateMatrix=null,this.staticMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setLoc=function(a,b,c){this.locX=a,this.locY=b,this.locZ=c,this.translateMatrix=null,this.staticMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDLocX=function(a){this.dLocX=a,this.translateMatrix=null,this.staticMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDLocY=function(a){this.dLocY=a,this.translateMatrix=null,this.staticMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDLocZ=function(a){this.dLocZ=a,this.translateMatrix=null,this.staticMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDLoc=function(a,b,c){this.dLocX=a,this.dLocY=b,this.dLocZ=c,this.translateMatrix=null,this.staticMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setQuatX=function(b){this.mode=a.P_QUAT,this.quatX=parseFloat(b),this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setQuatY=function(b){this.mode=a.P_QUAT,this.quatY=parseFloat(b),this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setQuatZ=function(b){this.mode=a.P_QUAT,this.quatZ=parseFloat(b),this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setQuatW=function(b){this.mode=a.P_QUAT,this.quatW=parseFloat(b),this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setQuat=function(b,c,d,e){this.mode=a.P_QUAT,this.quatX=b,this.quatY=c,this.quatZ=d,this.quatW=e,this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setRotX=function(b){this.mode=a.P_EULER,this.rotX=b,this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setRotY=function(b){this.mode=a.P_EULER,this.rotY=b,this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setRotZ=function(b){this.mode=a.P_EULER,this.rotZ=b,this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setRot=function(b,c,d){this.mode=a.P_EULER,this.rotX=b,this.rotY=c,this.rotZ=d,this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDRotX=function(b){this.mode=a.P_EULER,this.dRotX=b,this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDRotY=function(b){this.mode=a.P_EULER,this.dRotY=b,this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDRotZ=function(b){this.mode=a.P_EULER,this.dRotZ=b,this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDRot=function(b,c,d){this.mode=a.P_EULER,this.dRotX=b,this.dRotY=c,this.dRotZ=d,this.staticMatrix=null,this.rotmatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setScaleX=function(a){if(this.ScaleX==a)return this;this.scaleX=a,this.staticMatrix=null,this.scaleMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setScaleY=function(a){if(this.ScaleY==a)return this;this.scaleY=a,this.staticMatrix=null,this.scaleMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setScaleZ=function(a){if(this.ScaleZ==a)return this;this.scaleZ=a,this.staticMatrix=null,this.scaleMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setScale=function(a,b,c){b||(b=a,c=a),this.scaleX=a,this.scaleY=b,this.scaleZ=c,this.staticMatrix=null,this.scaleMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDScaleX=function(a){if(this.dScaleX==a)return this;this.dScaleX=a,this.staticMatrix=null,this.scaleMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDScaleY=function(a){if(this.dScaleY==a)return this;this.dScaleY=a,this.staticMatrix=null,this.scaleMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDScaleZ=function(a){if(this.dScaleZ==a)return this;this.dScaleZ=a,this.staticMatrix=null,this.scaleMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.setDScale=function(a,b,c){this.dScaleX=a,this.dScaleY=b,this.dScaleZ=c,this.staticMatrix==null,this.scaleMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.getLocX=function(){return parseFloat(this.locX)},a.Placeable.prototype.getLocY=function(){return parseFloat(this.locY)},a.Placeable.prototype.getLocZ=function(){return parseFloat(this.locZ)},a.Placeable.prototype.getLoc=function(){return new a.Vec3(parseFloat(this.locX),parseFloat(this.locY),parseFloat(this.locZ))},a.Placeable.prototype.getDLocX=function(){return this.dLocX},a.Placeable.prototype.getDLocY=function(){return this.dLocY},a.Placeable.prototype.getDLocZ=function(){return this.dLocZ},a.Placeable.prototype.getQuatX=function(){return this.quatX},a.Placeable.prototype.getQuatY=function(){return this.quatY},a.Placeable.prototype.getQuatZ=function(){return this.quatZ},a.Placeable.prototype.getQuatW=function(){return this.quatW},a.Placeable.prototype.getRotX=function(){return this.rotX},a.Placeable.prototype.getRotY=function(){return this.rotY},a.Placeable.prototype.getRotZ=function(){return this.rotZ},a.Placeable.prototype.getDRotX=function(){return this.dRotX},a.Placeable.prototype.getDRotY=function(){return this.dRotY},a.Placeable.prototype.getDRotZ=function(){return this.dRotZ},a.Placeable.prototype.getScaleX=function(){return this.scaleX},a.Placeable.prototype.getScaleY=function(){return this.scaleY},a.Placeable.prototype.getScaleZ=function(){return this.scaleZ},a.Placeable.prototype.getDScaleX=function(){return this.dScaleX},a.Placeable.prototype.getDScaleY=function(){return this.dScaleY},a.Placeable.prototype.getDScaleZ=function(){return this.dScaleZ},a.Placeable.prototype.getPosition=function(){var a={};a.x=parseFloat(this.locX)+parseFloat(this.dLocX),a.y=parseFloat(this.locY)+parseFloat(this.dLocY),a.z=parseFloat(this.locZ)+parseFloat(this.dLocZ);return a},a.Placeable.prototype.getRotation=function(){var b={};this.mode==a.P_EULER&&(b.x=parseFloat(this.rotX)+parseFloat(this.dRotX),b.y=parseFloat(this.rotY)+parseFloat(this.dRotY),b.z=parseFloat(this.rotZ)+parseFloat(this.dRotZ)),this.mode==a.P_QUAT&&(b.x=parseFloat(this.quatX),b.y=parseFloat(this.quatY),b.z=parseFloat(this.quatZ),b.w=parseFloat(this.quatW));return b},a.Placeable.prototype.getScale=function(){var a={};a.x=parseFloat(this.scaleX)+parseFloat(this.dScaleX),a.y=parseFloat(this.scaleY)+parseFloat(this.dScaleY),a.z=parseFloat(this.scaleZ)+parseFloat(this.dScaleZ);return a},a.Placeable.prototype.getScaleMatrix=function(){this.scaleMatrix||(this.scaleMatrix=a.scaleMatrix(parseFloat(this.scaleX)+parseFloat(this.dScaleX),parseFloat(this.scaleY)+parseFloat(this.dScaleY),parseFloat(this.scaleZ)+parseFloat(this.dScaleZ)));return this.scaleMatrix},a.Placeable.prototype.getTranslateMatrix=function(){this.tmatrix||(this.tmatrix=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]),this.translateMatrix||(this.tmatrix[3]=+this.locX+this.dLocX,this.tmatrix[7]=+this.locY+this.dLocY,this.tmatrix[11]=+this.locZ+this.dLocZ,this.translateMatrix=this.tmatrix);return this.translateMatrix},a.Placeable.prototype.getLocalMatrix=function(){this.getModelMatrix();return this.localMatrix},a.Placeable.prototype.setStaticMatrix=function(a){this.staticMatrix=a,this.updateMatrix();return this},a.Placeable.prototype.clearStaticMatrix=function(){this.staticMatrix=null,this.updateMatrix();return this},a.Placeable.prototype.updateMatrix=function(){this.matrix=null;if(this.children)for(var a=0;a<this.children.length;a++)this.children[a].updateMatrix();var b=obj=this;obj.fireEvent("matrixUpdate",{obj:b}),(obj=obj.parent)&&obj.fireEvent("childMatrixUpdate",{obj:b})},a.Placeable.prototype.getModelMatrix=function(){if(!this.matrix){a.reuseMatrix4(this.invmatrix),a.reuseMatrix4(this.transmatrix),a.reuseMatrix4(this.transinvmatrix),this.invmatrix=null,this.transmatrix=null,this.transinvmatrix=null;if(this.staticMatrix){var b=this.staticMatrix;this.localMatrix=this.staticMatrix,this.parent&&(b=a.mulMat4(this.parent.getModelMatrix(),b)),this.matrix=b}else{var c=this.getTranslateMatrix(),d=this.getScaleMatrix(),e=a.mulMat4(this.getRotMatrix(),d),b=a.mulMat4(c,e);this.localMatrix=b,this.parent&&(b=a.mulMat4(this.parent.getModelMatrix(),b)),this.matrix=b}}return this.matrix},a.Placeable.prototype.getInverseModelMatrix=function(){this.matrix||this.getModelMatrix(),this.invmatrix||(this.invmatrix=a.transposeMat4(this.matrix));return this.invmatrix},a.Placeable.prototype.getTransposeModelMatrix=function(){this.matrix||this.getModelMatrix(),this.transmatrix||(this.transmatrix=a.transposeMat4(this.matrix));return this.transmatrix},a.Placeable.prototype.getTransposeInverseModelMatrix=function(){this.matrix||this.getModelMatrix(),this.transinvmatrix||(this.invtransmatrix=a.transposeMat4(this.getInverseModelMatrix()));return this.transinvmatrix},a.Placeable.prototype.move=function(b,c){c||(c=a.GLOBAL);switch(c){case a.GLOBAL:this.setLocX(+this.locX+b[0]),this.setLocY(+this.locY+b[1]),this.setLocZ(+this.locZ+b[2]);break;case a.LOCAL:var d=this.getModelMatrix(),e=a.toUnitVec3([d[0],d[1],d[2]]),f=a.toUnitVec3([d[4],d[5],d[6]]),g=a.toUnitVec3([d[8],d[9],d[10]]),h=e[0]*b[0]+e[1]*b[1]+e[2]*b[2],i=f[0]*b[0]+f[1]*b[1]+f[2]*b[2],j=g[0]*b[0]+g[1]*b[1]+g[2]*b[2];this.setLocX(+this.locX+h),this.setLocY(+this.locY+i),this.setLocZ(+this.locZ+j)}return this}}(GLGE),function(a){a.JSONLoader=function(){},a.JSONLoader.prototype.downloadPriority=0,a.JSONLoader.prototype.setJSONSrc=function(b){var c=this;a.Message.messageLoader(b,function(a){c.setJSONString(a)},this.downloadPriority)},a.JSONLoader.prototype.setJSONString=function(b){var c=JSON.parse(b);c.type==this.className&&(c.uid=this.uid,c.command="update",a.Message.parseMessage(c))},a.JSONLoader.prototype.setDownloadPriority=function(a){this.downloadPriority=a},a.JSONLoader.prototype.getDownloadPriority=function(){return this.downloadPriority}}(GLGE),function(a){a.G_NODE=1,a.G_ROOT=2,a.Group=function(b){this.children=[];var c=this;this.downloadComplete=function(){c.isComplete()&&c.fireEvent("downloadComplete")},a.Assets.registerAsset(this,b)},a.augment(a.Placeable,a.Group),a.augment(a.Animatable,a.Group),a.augment(a.QuickNotation,a.Group),a.augment(a.JSONLoader,a.Group),a.Group.prototype.children=null,a.Group.prototype.className="Group",a.Group.prototype.type=a.G_NODE,a.Group.prototype.visible=!0,a.Group.prototype.pickable=!0,a.Group.prototype.setVisible=function(a){this.visible=a;return this},a.Group.prototype.getVisible=function(){return this.visible},a.Group.prototype.isComplete=function(){for(var a=0;a<this.children.length;a++)if(this.children[a].isComplete&&!this.children[a].isComplete())return!1;return!0},a.Group.prototype.setAction=function(a,b,c){a.start(b,c,this.getNames());return this},a.Group.prototype.getNames=function(a){a||(a={});var b=this.getName();b!=""&&(a[b]=this);for(var c=0;c<this.children.length;c++)this.children[c].getNames&&this.children[c].getNames(a);return a},a.Group.prototype.getBoundingVolume=function(b){this.boundingVolume=null;for(var c=0;c<this.children.length;c++)this.children[c].getBoundingVolume&&(this.boundingVolume?this.boundingVolume.addBoundingVolume(this.children[c].getBoundingVolume(!0)):this.boundingVolume=this.children[c].getBoundingVolume(!0).clone());this.boundingVolume||(this.boundingVolume=new a.BoundingVolume(0,0,0,0,0,0)),b?this.boundingVolume.applyMatrix(this.getLocalMatrix()):this.boundingVolume.applyMatrix(this.getModelMatrix());return this.boundingVolume},a.Group.prototype.getObjects=function(a){this.lookAt&&this.Lookat(this.lookAt),this.animation&&this.animate(),a||(a=[]);for(var b=0;b<this.children.length;b++)if(this.children[b].className=="Object"||this.children[b].className=="Text"||this.children[b].toRender){if(this.children[b].visible||this.children[b].visible==undefined)this.children[b].renderFirst?a.unshift(this.children[b]):a.push(this.children[b])}else this.children[b].getObjects&&((this.children[b].visible||this.children[b].visible==undefined)&&this.children[b].getObjects(a));return a},a.Group.prototype.getLights=function(a){a||(a=[]);for(var b=0;b<this.children.length;b++)this.children[b].className=="Light"?a.push(this.children[b]):this.children[b].getLights&&this.children[b].getLights(a);return a},a.Group.prototype.updateAllPrograms=function(){var a=this.getObjects();for(var b=0;b<a.length;b++)a[b].updateProgram&&a[b].updateProgram()},a.Group.prototype.addChild=function(b){b.parent&&b.parent.removeChild(b),this.noCastShadows!=null&&b.noCastShadows==null&&b.setCastShadows&&b.setCastShadows(!this.noCastShadows),a.reuseMatrix4(b.matrix),b.matrix=null,b.parent=this,this.children.push(b);if(b.getLights&&b.getLights().length>0||b.className=="Light"){var c=b;while(c.parent)c=c.parent;c.updateAllPrograms()}b.addEventListener&&(b.addEventListener("shaderupdate",function(){var a=this;while(a.parent)a=a.parent;a.updateAllPrograms()}),b.addEventListener("downloadComplete",this.downloadComplete)),this.fireEvent("childAdded",{obj:b}),b.fireEvent&&b.fireEvent("appened",{obj:this}),this.fireEvent("childAdded",{obj:b});var d=this;while(d=d.parent)d.fireEvent("childAdded",{obj:b,target:this});return this},a.Group.prototype.addObject=a.Group.prototype.addChild,a.Group.prototype.addObjectInstance=a.Group.prototype.addChild,a.Group.prototype.addGroup=a.Group.prototype.addChild,a.Group.prototype.addLight=a.Group.prototype.addChild,a.Group.prototype.addText=a.Group.prototype.addChild,a.Group.prototype.addSkeleton=a.Group.prototype.addChild,a.Group.prototype.addCamera=a.Group.prototype.addChild,a.Group.prototype.addWavefront=a.Group.prototype.addChild,a.Group.prototype.removeChild=function(a){var b;if(typeof a=="object"){for(var c=0;c<this.children.length;c++)if(this.children[c]==a){a=c,b=a;break}if(!b)return}else{if(this.children.length<=a)return;b=this.children[a]}this.children[a].removeEventListener&&this.children[a].removeEventListener("downloadComplete",this.downloadComplete),this.children.splice(a,1),this.scene&&this.scene["remove"+b.className]&&this.scene["remove"+b.className](b),b.fireEvent&&b.fireEvent("removed",{obj:this}),this.fireEvent("childRemoved",{obj:b});var d=this;while(d=d.parent)d.fireEvent("childRemoved",{obj:b,target:this})},a.Group.prototype.getChildren=function(){return this.children},a.Group.prototype.GLInit=function(a){this.gl=a;for(var b=0;b<this.children.length;b++)this.children[b].GLInit&&this.children[b].GLInit(a)},a.Group.prototype.getPickable=function(){return this.pickable},a.Group.prototype.setPickable=function(a){for(var b=0;b<this.children.length;b++)this.children[b].setPickable&&this.children[b].setPickable(a);this.pickable=a;return this}}(GLGE),function(a){a.Message={},a.Message.parseMessage=function(b){switch(b.command){case"create":var c=new a[b.type](b.uid);this.setAttributes(c,b.attributes),b.children&&a.Message.addChildren(c,b.children);return c;case"update":var c=a.Assets.get(b.uid);this.setAttributes(c,b.attributes),b.add&&a.Message.addChildren(c,b.add),b.remove&&a.Message.removeChildren(c,b.remove);return c}return null},a.Message.setAttributes=function(b,c){if(c)for(var d in c)b["set"+d]&&(c[d].command&&(c[d]=a.Message.parseMessage(c[d])),b["set"+d](c[d]));return this},a.Message.addChildren=function(b,c){c instanceof Array||(c=[c]);for(var d=0;d<c.length;d++){if(c[d].command)var e=a.Message.parseMessage(c[d]);else var e=a.Assets.get(c[d]);b["add"+e.className](e)}},a.Message.removeChildren=function(b,c){c instanceof Array||(c=[c]);for(var d=0;d<c.length;d++){var e=a.Assets.get(c[d]);b["add"+e.className](e)}},a.Message.toLoad=[],a.Message.messageLoader=function(b,c,d){a.Message.toLoad.push([b,c,d]),a.Message.toLoad.length==1&&a.Message.loadMessages()},a.Message.loadMessages=function(){var b=a.Message.toLoad.pop(),c=new XMLHttpRequest;c.onreadystatechange=function(){this.readyState==4&&(this.status==200||this.status==0?b[1](this.responseText):a.error("Error loading Document: "+b[0]+" status "+this.status))},c.open("GET",b[0],!0),c.send(""),a.Message.toLoad.length>0&&a.Message.loadMessages()}}(GLGE),function(a){a.Action=function(b){this.channels=[],a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.Action),a.augment(a.JSONLoader,a.Action),a.augment(a.Events,a.Action),a.Action.prototype.start=function(a,b,c){b||(b=!1),a||(a=0);var d=this.channels,e=(new Date).getTime();this.animFinished=!1;for(var f=0;f<d.length;f++){var g=d[f].getAnimation(),h=this,i=d[f],j=i.getTarget();typeof j=="string"&&(c&&c[j]&&(j=c[j]));var k={};k.finishEvent=function(a){j.removeEventListener("animFinished",k.finishEvent),!h.animFinished&&j.animation==g&&(h.fireEvent("animFinished",{}),h.animFinished=!0)},j.addEventListener("animFinished",k.finishEvent),j.setAnimation(g,a,e),j.setLoop(b)}},a.Action.prototype.setStartFrame=function(a){for(var b=0;b<this.channels.length;b++)this.channels[b].getAnimation().setStartFrame(a);return this},a.Action.prototype.setFrames=function(a){for(var b=0;b<this.channels.length;b++)this.channels[b].getAnimation().setFrames(a);return this},a.Action.prototype.addActionChannel=function(a){this.channels.push(a);return this},a.Action.prototype.removeActionChannel=function(a){for(var b=0;b<this.channels.length;b++)if(this.channels[b]==channels){this.channels.splice(b,1);break}}}(GLGE),function(a){a.ActionChannel=function(b){a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.ActionChannel),a.augment(a.JSONLoader,a.ActionChannel),a.ActionChannel.prototype.setTarget=function(a){this.target=a},a.ActionChannel.prototype.setAnimation=function(a){this.animation=a},a.ActionChannel.prototype.getTarget=function(){return this.target},a.ActionChannel.prototype.getAnimation=function(){return this.animation}}(GLGE),function(e){e.AnimationCurve=function(a){this.keyFrames=[],this.solutions={},this.caches={},e.Assets.registerAsset(this,a)},e.augment(e.QuickNotation,e.AnimationCurve),e.augment(e.JSONLoader,e.AnimationCurve),e.AnimationCurve.prototype.className="AnimationCurve",e.AnimationCurve.prototype.keyFrames=null,e.AnimationCurve.prototype.addPoint=function(a){this.keyFrames.push(a);return this.keyFrames.length-1},e.AnimationCurve.prototype.addStepPoint=e.AnimationCurve.prototype.addPoint,e.AnimationCurve.prototype.addLinearPoint=e.AnimationCurve.prototype.addPoint,e.AnimationCurve.prototype.addBezTriple=e.AnimationCurve.prototype.addPoint,e.AnimationCurve.prototype.coord=function(a,b){return{x:a,y:b}},e.AnimationCurve.prototype.setChannel=function(a){this.channel=a},e.AnimationCurve.prototype.getValue=function(a){if(this.keyFrames.length==0)return 0;if(this.caches[a])return this.caches[a];var b,c,d,f;if(a<this.keyFrames[0].x)return this.keyFrames[0].y;for(var g=0;g<this.keyFrames.length;g++){if(this.keyFrames[g].x==a)return this.keyFrames[g].y;this.keyFrames[g].x>a||b!=undefined&&this.keyFrames[g].x<=this.keyFrames[b].x?this.keyFrames[g].x<=a&&(d==undefined||this.keyFrames[g].x>this.keyFrames[d].x)&&(d=g):(d=b,b=g),this.keyFrames[g].x<=a||c!=undefined&&this.keyFrames[g].x>this.keyFrames[c].x?this.keyFrames[g].x>a&&(f==undefined||this.keyFrames[g].x<=this.keyFrames[f].x)&&(f=g):(f=c,c=g)}b==undefined&&(b=c,c=f),c==undefined&&(c=b,b=d);if(this.keyFrames[b]instanceof e.BezTriple&&this.keyFrames[c]instanceof e.BezTriple){var h=this.coord(this.keyFrames[b].x,this.keyFrames[b].y),i=this.coord(this.keyFrames[b].x3,this.keyFrames[b].y3),j=this.coord(this.keyFrames[c].x1,this.keyFrames[c].y1),k=this.coord(this.keyFrames[c].x,this.keyFrames[c].y);return this.atX(a,h,i,j,k).y}if(this.keyFrames[b]instanceof e.LinearPoint&&this.keyFrames[c]instanceof e.BezTriple){var h=this.coord(this.keyFrames[b].x,this.keyFrames[b].y),i=this.coord(this.keyFrames[c].x1,this.keyFrames[c].y1),j=this.coord(this.keyFrames[c].x1,this.keyFrames[c].y1),k=this.coord(this.keyFrames[c].x,this.keyFrames[c].y);return this.atX(a,h,i,j,k).y}if(this.keyFrames[b]instanceof e.BezTriple&&this.keyFrames[c]instanceof e.LinearPoint){var h=this.coord(this.keyFrames[b].x,this.keyFrames[b].y),i=this.coord(this.keyFrames[b].x3,this.keyFrames[b].y3),j=this.coord(this.keyFrames[b].x3,this.keyFrames[b].y3),k=this.coord(this.keyFrames[c].x,this.keyFrames[c].y);return this.atX(a,h,i,j,k).y}if(this.keyFrames[b]instanceof e.LinearPoint&&this.keyFrames[c]instanceof e.LinearPoint){var l=(a-this.keyFrames[b].x)*(this.keyFrames[c].y-this.keyFrames[b].y)/(this.keyFrames[c].x-this.keyFrames[b].x)+this.keyFrames[b].y;return l}if(this.keyFrames[b]instanceof e.StepPoint)return this.keyFrames[b].y;this.keyFrames.preStartKey||(this.keyFrames.preStartKey=this.keyFrames[0].y),this.caches[a]=this.keyFrames.preStartKey;return this.caches[a]},e.AnimationCurve.prototype.B1=function(a){return a*a*a},e.AnimationCurve.prototype.B2=function(a){return 3*a*a*(1-a)},e.AnimationCurve.prototype.B3=function(a){return 3*a*(1-a)*(1-a)},e.AnimationCurve.prototype.B4=function(a){return(1-a)*(1-a)*(1-a)},e.AnimationCurve.prototype.getBezier=function(a,b,c,d,e){var f={};f.x=b.x*this.B1(a)+c.x*this.B2(a)+d.x*this.B3(a)+e.x*this.B4(a),f.y=b.y*this.B1(a)+c.y*this.B2(a)+d.y*this.B3(a)+e.y*this.B4(a);return f},e.AnimationCurve.prototype.Quad3Solve=function(a,b,c,d){ref=a+"-"+b+"--"+c+"-"+d;if(this.solutions[ref])return this.solutions[ref];b/=a,c/=a,d/=a;var e,f,g,h,i,j,k;e=(3*c-b*b)/9,f=-(27*d)+b*(9*c-2*(b*b)),f/=54,j=b/3,discrim=e*e*e+f*f,result=[],discrim>0?(h=f+Math.sqrt(discrim),h=h<0?-Math.pow(-h,1/3):Math.pow(h,1/3),i=f-Math.sqrt(discrim),i=i<0?-Math.pow(-i,1/3):Math.pow(i,1/3),result[0]=-j+h+i,j=j+(h+i)/2,result[1]=result[2]=-j,j=Math.sqrt(3)*(-i+h)/2):discrim==0?(k=f<0?-Math.pow(-f,1/3):Math.pow(f,1/3),result[1]=-j+2*k,result[1]=result[2]=-(k+j)):(e=-e,g=e*e*e,g=Math.acos(f/Math.sqrt(1)),k=2*Math.sqrt(e),result[0]=-j+k*Math.cos(g/3),result[1]=-j+k*Math.cos((g+2*Math.PI)/3),result[2]=-j+k*Math.cos((g+4*Math.PI)/3));var l=!1;result[0]>=0&&result[0]<=1&&(l=result[0]),!l&&result[1]>=0&&result[1]<=1&&(l=result[1]),!l&&result[2]>=0&&result[2]<=1&&(l=result[2]),this.solutions[ref]=l;return l},e.AnimationCurve.prototype.atX=function(e,f,g,h,i){a=f.x-g.x*3+h.x*3-i.x,b=g.x*3-h.x*6+i.x*3,c=h.x*3-i.x*3,d=i.x-e;return this.getBezier(this.Quad3Solve(a,b,c,d),f,g,h,i)}}(GLGE),function(a){a.AnimationVector=function(b){this.curves={},a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.AnimationVector),a.augment(a.JSONLoader,a.AnimationVector),a.AnimationVector.prototype.curves={},a.AnimationVector.prototype.frames=250,a.AnimationVector.prototype.startFrame=0,a.AnimationVector.prototype.addAnimationCurve=function(a){this.curves[a.channel]=a;return this},a.AnimationVector.prototype.removeAnimationCurve=function(a){delete this.curves[a]},a.AnimationVector.prototype.setFrames=function(a){this.frames=a;return this},a.AnimationVector.prototype.getFrames=function(){return this.frames},a.AnimationVector.prototype.setStartFrame=function(a){this.startFrame=a;return this},a.AnimationVector.prototype.getStartFrame=function(){return this.startFrame}}(GLGE),function(a){a.BezTriple=function(b){a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.BezTriple),a.augment(a.JSONLoader,a.BezTriple),a.BezTriple.prototype.className="BezTriple",a.BezTriple.prototype.setX1=function(a){this.x1=parseFloat(a);return this},a.BezTriple.prototype.setY1=function(a){this.y1=parseFloat(a);return this},a.BezTriple.prototype.setX2=function(a){this.x=parseFloat(a);return this},a.BezTriple.prototype.setY2=function(a){this.y=parseFloat(a);return this},a.BezTriple.prototype.setX3=function(a){this.x3=parseFloat(a);return this},a.BezTriple.prototype.setY3=function(a){this.y3=parseFloat(a);return this},a.LinearPoint=function(a){},a.augment(a.QuickNotation,a.LinearPoint),a.augment(a.JSONLoader,a.LinearPoint),a.LinearPoint.prototype.className="LinearPoint",a.LinearPoint.prototype.x=0,a.LinearPoint.prototype.y=0,a.LinearPoint.prototype.setX=function(a){this.x=parseFloat(a);return this},a.LinearPoint.prototype.setY=function(a){this.y=parseFloat(a);return this},a.StepPoint=function(a,b){this.x=parseFloat(a),this.y=b}}(GLGE),function(a){a.Mesh=function(b,c){this.GLbuffers=[],this.buffers=[],this.framePositions=[],this.frameNormals=[],this.frameTangents=[],this.UV=[],this.boneWeights=[],this.setBuffers=[],this.faces={},c!==undefined?this.windingOrder=c:this.windingOrder=a.Mesh.WINDING_ORDER_UNKNOWN,a.Assets.registerAsset(this,b)},a.Mesh.WINDING_ORDER_UNKNOWN=2,a.Mesh.WINDING_ORDER_CLOCKWISE=1,a.Mesh.WINDING_ORDER_COUNTER=0,a.augment(a.QuickNotation,a.Mesh),a.augment(a.JSONLoader,a.Mesh),a.augment(a.Events,a.Mesh),a.Mesh.prototype.gl=null,a.Mesh.prototype.className="Mesh",a.Mesh.prototype.GLbuffers=null,a.Mesh.prototype.buffers=null,a.Mesh.prototype.setBuffers=null,a.Mesh.prototype.GLfaces=null,a.Mesh.prototype.faces=null,a.Mesh.prototype.UV=null,a.Mesh.prototype.joints=null,a.Mesh.prototype.invBind=null,a.Mesh.prototype.loaded=!1,a.Mesh.prototype.getBoundingVolume=function(){if(!this.positions)return new a.BoundingVolume(0,0,0,0,0,0);if(!this.boundingVolume){var b,c,d,e,f,g,h=this.positions;for(var i=0;i<h.length;i=i+3)i==0?(b=c=h[i],d=e=h[i+1],f=g=h[i+2]):(b=Math.min(b,h[i]),c=Math.max(c,h[i]),d=Math.min(d,h[i+1]),e=Math.max(e,h[i+1]),f=Math.min(f,h[i+2]),g=Math.max(g,h[i+2]));this.boundingVolume=new a.BoundingVolume(b,c,d,e,f,g)}return this.boundingVolume},a.Mesh.prototype.setJoints=function(a){this.joints=a,this.fireEvent("shaderupdate",{});return this},a.Mesh.prototype.setInvBindMatrix=function(a){this.invBind=a,this.fireEvent("shaderupdate",{});return this},a.Mesh.prototype.setVertexJoints=function(a,b){b||(b=a.length*3/this.positions.length);if(b<5)this.setBuffer("joints1",a,b);else{var c=[],d=[];for(var e=0;e<a.length;e++)e%b<4?c.push(a[e]):d.push(a[e]);this.setBuffer("joints1",c,4),this.setBuffer("joints2",d,b-4)}this.fireEvent("shaderupdate",{});return this},a.Mesh.prototype.setVertexWeights=function(a,b){b||(b=a.length*3/this.positions.length);for(var c=0;c<a.length;c=c+parseInt(b)){var d=0;for(var e=0;e<b;e++)d+=parseFloat(a[c+e]);d==0&&(d=1);for(var e=0;e<b;e++)a[c+e]=a[c+e]/d}if(b<4)this.setBuffer("weights1",a,b);else{var f=[],g=[];for(var c=0;c<a.length;c++)c%b<4?f.push(a[c]):g.push(a[c]);this.setBuffer("weights1",f,4),this.setBuffer("weights2",g,b-4)}this.fireEvent("shaderupdate",{});return this},a.Mesh.prototype.clearBuffers=function(){this.GLFaces=null,delete this.GLFaces;for(var a in this.buffers)this.buffers[a]=null,delete this.buffers[a];this.buffers=[],this.loaded=!1},a.Mesh.prototype.setUV=function(a){this.uv1set=a;var b=0;for(var c=0;c<a.length;c=c+2)this.UV[b]=a[c],this.UV[b+1]=a[c+1],this.UV[b+2]||(this.UV[b+2]=a[c]),this.UV[b+3]||(this.UV[b+3]=a[c+1]),b=b+4;this.setBuffer("UV",this.UV,4);return this},a.Mesh.prototype.setUV2=function(a){this.uv2set=a;var b=0;for(var c=0;c<a.length;c=c+2)this.UV[b]||(this.UV[b]=a[c]),this.UV[b+1]||(this.UV[b+1]=a[c+1]),this.UV[b+2]=a[c],this.UV[b+3]=a[c+1],b=b+4;this.setBuffer("UV",this.UV,4);return this},a.Mesh.prototype.setPositions=function(a,b){b||(b=0),this.loaded=!0,b==0&&(this.positions=a),this.framePositions[b]=a,this.setBuffer("position"+b,a,3,!0),this.boundingVolume=null,this.fireEvent("updatebound");return this},a.Mesh.prototype.setVertexColors=function(a){this.colors=a,this.setBuffer("color",a,4);return this},a.Mesh.prototype.setNormals=function(a,b){b||(b=0),b==0&&(this.normals=a),this.frameNormals[b]=a,this.setBuffer("normal"+b,a,3,!0);return this},a.Mesh.prototype.setTangents=function(a,b){b||(b=0),b==0&&(this.tangents=a),this.frameTangents[b]=a,this.setBuffer("tangent"+b,a,3,!0);return this},a.Mesh.prototype.setBuffer=function(a,b,c,d){if(typeof b[0]!="number")for(var e=0;e<b.length;e++)b[e]=parseFloat(b[e]);var f;for(var e=0;e<this.buffers.length;e++)this.buffers[e].name==a&&(f=e);f?this.buffers[f]={name:a,data:b,size:c,GL:!1,exclude:d}:this.buffers.push({name:a,data:b,size:c,GL:!1,exclude:d});return this},a.Mesh.prototype.tangentFromUV=function(b,c,d,e,f,g,h){var i=a.toUnitVec3,j=a.subVec3,k=a.scaleVec3,l=a.dotVec3,m=a.crossVec3;uv21=[f[0]-e[0],f[1]-e[1]],uv31=[g[0]-e[0],g[1]-e[1]],p21=a.subVec3(c,b),p31=a.subVec3(d,b);var n=uv21[0]*uv31[1]-uv31[0]*uv21[1];if(n!=0){n=1/n;var o=j(k(p21,uv31[1]*n),k(p31,uv21[1]*n)),p=j(k(p31,uv21[0]*n),k(p21,uv31[0]*n))}else o=[0,0,0],p=[0,0,0];a.dotVec3(a.crossVec3(p21,p31),h)>0&&(o=k(o,-1),p=k(p,-1));return[o,p]},a.Mesh.prototype.setFaces=function(a){this.faces={data:a,GL:!1},this.normals||this.calcNormals(),!this.tangents&&this.UV.length>0&&this.calcTangents();return this},a.Mesh.prototype.calcTangents=function(){for(var b=0;b<this.framePositions.length;b++){var c=this.framePositions[b],d=this.frameNormals[b],e=this.UV,f=[],g={},h;for(var i=0;i<c.length;i++)f[i]=0;for(var i=0;i<this.faces.data.length;i=i+3){var j=parseInt(this.faces.data[i]),k=parseInt(this.faces.data[i+1]),l=parseInt(this.faces.data[i+2]),m=[c[j*3],c[j*3+1],c[j*3+2]],n=[c[k*3],c[k*3+1],c[k*3+2]],o=[c[l*3],c[l*3+1],c[l*3+2]],p=[d[j*3],d[j*3+1],d[j*3+2]],q=[d[k*3],d[k*3+1],d[k*3+2]],r=[d[l*3],d[l*3+1],d[l*3+2]],s=[e[j*4],e[j*4+1]],t=[e[k*4],e[k*4+1]],u=[e[l*4],e[l*4+1]],v=this.tangentFromUV(n,m,o,t,s,u,q),w=[m[0],m[1],m[2],s[0],s[1],p[0],p[1],p[2]].join(",");g[w]?(g[w][0][0]+=v[0][0],g[w][0][1]+=v[0][1],g[w][0][2]+=v[0][2],g[w][1][0]+=v[1][0],g[w][1][1]+=v[1][1],g[w][1][2]+=v[1][2]):g[w]=v,w=[n[0],n[1],n[2],t[0],t[1],q[0],q[1],q[2]].join(","),g[w]?(g[w][0][0]+=v[0][0],g[w][0][1]+=v[0][1],g[w][0][2]+=v[0][2],g[w][1][0]+=v[1][0],g[w][1][1]+=v[1][1],g[w][1][2]+=v[1][2]):g[w]=v,w=[o[0],o[1],o[2],u[0],u[1],r[0],r[1],r[2]].join(","),g[w]?(g[w][0][0]+=v[0][0],g[w][0][1]+=v[0][1],g[w][0][2]+=v[0][2],g[w][1][0]+=v[1][0],g[w][1][1]+=v[1][1],g[w][1][2]+=v[1][2]):g[w]=v}for(var i=0;i<c.length/3;i++){var m=[c[i*3],c[i*3+1],c[i*3+2]],p=[d[i*3],d[i*3+1],d[i*3+2]],s=[e[i*4],e[i*4+1]];try{var x=a.toUnitVec3(g[[m[0],m[1],m[2],s[0],s[1],p[0],p[1],p[2]].join(",")][0]),y=a.toUnitVec3(g[[m[0],m[1],m[2],s[0],s[1],p[0],p[1],p[2]].join(",")][1])}catch(z){}x&&(f[i*3]=x[0],f[i*3+1]=x[1],f[i*3+2]=x[2])}this.setTangents(f,b)}},a.Mesh.prototype.GLSetFaceBuffer=function(a){this.GLfaces||(this.GLfaces=a.createBuffer()),a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,this.GLfaces),a.bufferData(a.ELEMENT_ARRAY_BUFFER,new Uint16Array(this.faces.data),a.STATIC_DRAW),this.GLfaces.itemSize=1,this.GLfaces.numItems=this.faces.data.length},a.Mesh.prototype.GLSetBuffer=function(a,b,c,d){this.GLbuffers[b]||(this.GLbuffers[b]=a.createBuffer()),a.bindBuffer(a.ARRAY_BUFFER,this.GLbuffers[b]),c.byteLength||(c=new Float32Array(c)),a.bufferData(a.ARRAY_BUFFER,c,a.STATIC_DRAW),this.GLbuffers[b].itemSize=d,this.GLbuffers[b].numItems=c.length/d},a.Mesh.prototype.calcNormals=function(){for(var b=0;b<this.framePositions.length;b++){var c=[],d=this.framePositions[b],e=this.faces.data;if(!e){e=[];for(var f=0;f<d.length/3;f++)e[f]=f}for(var f=0;f<e.length;f=f+3){var g=[d[e[f]*3],d[e[f]*3+1],d[e[f]*3+2]],h=[d[e[f+1]*3],d[e[f+1]*3+1],d[e[f+1]*3+2]],i=[d[e[f+2]*3],d[e[f+2]*3+1],d[e[f+2]*3+2]],j=a.subVec3(h,g),k=a.subVec3(i,g),l=a.toUnitVec3(a.crossVec3(j,k));c[e[f]]==undefined&&(c[e[f]]=[]),c[e[f]].push(l),c[e[f+1]]==undefined&&(c[e[f+1]]=[]),c[e[f+1]].push(l),c[e[f+2]]==undefined&&(c[e[f+2]]=[]),c[e[f+2]].push(l)}var m=[];for(f=0;f<c.length;f++){var n=0,o=0,p=0;if(c[f]!=undefined){for(var q=0;q<c[f].length;q++)n+=c[f][q][0],o+=c[f][q][1],p+=c[f][q][2];n/=c[f].length,o/=c[f].length,p/=c[f].length,m[f*3]=n,m[f*3+1]=o,m[f*3+2]=p}}this.setNormals(m,b)}},a.Mesh.prototype.calcFauxAO=function(){this.optimize();var b=this.positions,c=this.faces.data,d=this.normals,e=[],f=b.length/3;for(var g=0;g<f;g++)e.push([]);for(var g=0;g<c.length;g=g+3)e[c[g]].push(c[g+1]),e[c[g]].push(c[g+2]),e[c[g+1]].push(c[g]),e[c[g+1]].push(c[g+2]),e[c[g+2]].push(c[g]),e[c[g+2]].push(c[g+1]);var h=[];for(var g=0;g<f;g++){var i=0,j=[d[g*3],d[g*3+1],d[g*3+2]];for(var k=0;k<e[g].length;k++){var l=e[g][k],m=[b[l*3]-b[g*3],b[l*3+1]-b[g*3+1],b[l*3+2]-b[g*3+2]];m=a.toUnitVec3(m),i+=m[0]*j[0]+m[1]*j[1]+m[2]*j[2]}i/=e[g].length,i=1-(i+1)*.5,h.push(i),h.push(i),h.push(i),h.push(1)}this.setVertexColors(h)},a.Mesh.prototype.optimize=function(){var a=this.positions,b=this.normals,c=this.faces.data,d=this.tangents,e=this.uv1set,f=this.uv2set,g=[],h=[],i=[],j=[],k=[];if(c)for(var l=0;l<c.length;l++)g.push(a[c[l]*3]),g.push(a[c[l]*3+1]),g.push(a[c[l]*3+2]),h.push(b[c[l]*3]),h.push(b[c[l]*3+1]),h.push(b[c[l]*3+2]),d&&d.length>0&&(k.push(d[c[l]*3]),k.push(d[c[l]*3+1]),k.push(d[c[l]*3+2])),e&&(i.push(e[c[l]*2]),i.push(e[c[l]*2+1])),f&&(j.push(f[c[l]*2]),j.push(f[c[l]*2+1]));else g=a,h=b,k=d,i=e,j=f;var m=[],n=[],o=[],p=[],q=[],r=[],s=[];for(var l=0;l<g.length;l=l+3){if(e&&f)var t=[g[l],g[l+1],g[l+2],h[l],h[l+1],h[l+2],i[l/3*2],i[l/3*2+1]].join(" ");else if(e)var t=[g[l],g[l+1],g[l+2],h[l],h[l+1],h[l+2],i[l/3*2],i[l/3*2+1]].join(" ");else var t=[g[l],g[l+1],g[l+2],h[l],h[l+1],h[l+2]].join(" ");var u=s.indexOf(t);u<0&&(s.push(t),u=s.length-1,m.push(g[l]),m.push(g[l+1]),m.push(g[l+2]),n.push(h[l]),n.push(h[l+1]),n.push(h[l+2]),d&&d.length>0&&(r.push(k[l]),r.push(k[l+1]),r.push(k[l+2])),e&&(p.push(i[l/3*2]),p.push(i[l/3*2+1])),f&&(q.push(j[l/3*2]),q.push(j[l/3*2+1]))),o.push(u)}this.setPositions(m).setNormals(n).setFaces(o).setUV(p).setUV2(q).setTangents(r)},a.Mesh.prototype.GLAttributes=function(b,c,d,e){this.gl=b,d||(d=0),this.normals||this.calcNormals();for(var f=0;f<8;f++)b.disableVertexAttribArray(f);!this.faces.GL&&this.faces.data&&this.faces.data.length>0&&(this.GLSetFaceBuffer(b),this.faces.GL=!0);for(f=0;f<this.buffers.length;f++)this.buffers[f].GL||(this.GLSetBuffer(b,this.buffers[f].name,this.buffers[f].data,this.buffers[f].size),this.buffers[f].GL=!0),attribslot=a.getAttribLocation(b,c,this.buffers[f].name),attribslot>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.GLbuffers[this.buffers[f].name]),b.enableVertexAttribArray(attribslot),b.vertexAttribPointer(attribslot,this.GLbuffers[this.buffers[f].name].itemSize,b.FLOAT,!1,0,0));var g=a.getAttribLocation(b,c,"position");g>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.GLbuffers["position"+d]),b.enableVertexAttribArray(g),b.vertexAttribPointer(g,this.GLbuffers["position"+d].itemSize,b.FLOAT,!1,0,0));var h=a.getAttribLocation(b,c,"normal");h>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.GLbuffers["normal"+d]),b.enableVertexAttribArray(h),b.vertexAttribPointer(h,this.GLbuffers["normal"+d].itemSize,b.FLOAT,!1,0,0));var i=a.getAttribLocation(b,c,"tangent");i>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.GLbuffers["tangent"+d]),b.enableVertexAttribArray(i),b.vertexAttribPointer(i,this.GLbuffers["tangent"+d].itemSize,b.FLOAT,!1,0,0));if(e!=undefined){var j=a.getAttribLocation(b,c,"position2");j>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.GLbuffers["position"+e]),b.enableVertexAttribArray(j),b.vertexAttribPointer(j,this.GLbuffers["position"+e].itemSize,b.FLOAT,!1,0,0));var k=a.getAttribLocation(b,c,"normal2");k>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.GLbuffers["normal"+e]),b.enableVertexAttribArray(k),b.vertexAttribPointer(k,this.GLbuffers["normal"+e].itemSize,b.FLOAT,!1,0,0));var l=a.getAttribLocation(b,c,"tangent2");l>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.GLbuffers["tangent"+e]),b.enableVertexAttribArray(l),b.vertexAttribPointer(l,this.GLbuffers["tangent"+e].itemSize,b.FLOAT,!1,0,0))}}}(GLGE),function(a){a.Sphere=function(b){this.vertical=10,this.horizontal=10,this.radius=1,this.dirtySphere=!1,a.Mesh.apply(this,arguments),this.generateMeshData()},a.augment(a.Mesh,a.Sphere),a.Sphere.prototype.generateMeshData=function(){var b=this.vertical,c=this.horizontal,d=this.radius,e,f,g,h,i,j,f,k,l=[],m=[],n=[];for(h=0;h<=b;h++){e=h/b*Math.PI,f=Math.cos(e)*d,g=Math.sin(e)*d;for(i=0;i<c;i++){k=i/c*2*Math.PI,j=Math.sin(k)*g,z=Math.cos(k)*g,l.push(j,f,z);var o=a.toUnitVec3([j,f,z]);this.insideNormals?m.push(-o[0],-o[1],-o[2]):m.push(o[0],o[1],o[2])}if(h>0)for(i=0;i<c;i++){var p=h*c+i,q=(h-1)*c+i,r=h*c+(i+1)%c,s=(h-1)*c+(i+1)%c;n.push(p,r,s,p,s,q)}}this.setPositions(l),this.setNormals(m),this.setFaces(n),this.dirtySphere=!1},a.Sphere.prototype.setInsideNormals=function(a){this.insideNormals=a,this.dirtySphere=!0;return this},a.Sphere.prototype.getInsideNormals=function(){return this.insideNormals},a.Sphere.prototype.setRadius=function(a){this.radius=a,this.dirtySphere=!0;return this},a.Sphere.prototype.getRadius=function(){return this.radius},a.Sphere.prototype.setVertical=function(a){this.vertical=a,this.dirtySphere=!0;return this},a.Sphere.prototype.getRadius=function(){return this.vertical},a.Sphere.prototype.setHorizontal=function(a){this.horizontal=a,this.dirtySphere=!0;return this},a.Sphere.prototype.getRadius=function(){return this.horizontal},a.Sphere.prototype.GLAttributes=function(){this.dirtySphere&&this.generateMeshData(),a.Mesh.prototype.GLAttributes.apply(this,arguments)}}(GLGE),function(a){var b=0;a.Material=function(c){this.layers=[],this.layerlisteners=[],this.textures=[],this.lights=[],this.color={r:1,g:1,b:1,a:1},this.specColor={r:1,g:1,b:1},this.reflect=.8,this.shine=10,this.specular=1,this.emit={r:0,g:0,b:0},this.alpha=1,this.translucency=0,this.materialIdx=b++,a.Assets.registerAsset(this,c)},a.augment(a.Animatable,a.Material),a.augment(a.QuickNotation,a.Material),a.augment(a.JSONLoader,a.Material),a.augment(a.Events,a.Material),a.M_COLOR=1,a.M_NOR=2,a.M_ALPHA=4,a.M_SPECCOLOR=8,a.M_SPECULAR=16,a.M_SHINE=32,a.M_REFLECT=64,a.M_EMIT=128,a.M_ALPHA=256,a.M_MSKR=512,a.M_MSKG=1024,a.M_MSKB=2048,a.M_MSKA=4096,a.M_HEIGHT=8192,a.M_AMBIENT=16384,a.M_STEEP=32768,a.UV1=0,a.UV2=1,a.MAP_NORM=3,a.MAP_OBJ=4,a.MAP_REF=5,a.MAP_ENV=6,a.MAP_VIEW=7,a.MAP_POINT=8,a.MAP_GLOBAL=9,a.BL_MIX=0,a.BL_MUL=1,a.VC_NONE=0,a.VC_BASE=1,a.VC_MUL=2,a.VC_AMB=3,a.VC_AMBMUL=4,a.Material.prototype.layers=null,a.Material.prototype.className="Material",a.Material.prototype.textures=null,a.Material.prototype.color=null,a.Material.prototype.specColor=null,a.Material.prototype.specular=null,a.Material.prototype.emit={r:0,g:0,b:0},a.Material.prototype.shine=null,a.Material.prototype.reflect=null,a.Material.prototype.lights=null,a.Material.prototype.alpha=null,a.Material.prototype.ambient={r:0,g:0,b:0},a.Material.prototype.shadow=!0,a.Material.prototype.shadeless=!1,a.Material.prototype.downloadComplete=!1,a.Material.prototype.fadeDistance=0,a.Material.prototype.vertexColorMode=a.VC_BASE,a.Material.prototype.setFadeDistance=function(a){this.fadeDistance=parseFloat(a),this.fireEvent("shaderupdate",{});return this},a.Material.prototype.getFadeDistance=function(a){return this.fadeDistance},a.Material.prototype.setVertexColorMode=function(a){this.vertexColorMode=a,this.fireEvent("shaderupdate",{});return this},a.Material.prototype.getVertexColorMode=function(a){return this.vertexColorMode},a.Material.prototype.setFallback=function(a){this.fallback=a;return this},a.Material.prototype.getFallback=function(a){return this.fallback},a.Material.prototype.setShadeless=function(a){this.shadeless=a;return this},a.Material.prototype.getShadeless=function(a){return this.shadeless},a.Material.prototype.setShadow=function(a){this.shadow=a;return this},a.Material.prototype.getShadow=function(a){return this.shadow},a.Material.prototype.setColor=function(b){b.r==undefined&&(b=a.colorParse(b)),this.color={r:b.r,g:b.g,b:b.b};return this},a.Material.prototype.setColorR=function(a){this.color={r:a,g:this.color.g,b:this.color.b,a:this.color.a};return this},a.Material.prototype.setColorG=function(a){this.color={r:this.color.r,g:a,b:this.color.b,a:this.color.a};return this},a.Material.prototype.setColorB=function(a){this.color={r:this.color.r,g:this.color.g,b:a,a:this.color.a};return this},a.Material.prototype.getColorR=function(a){return this.color.r},a.Material.prototype.getColorG=function(a){return this.color.g},a.Material.prototype.getColorB=function(a){return this.color.b},a.Material.prototype.getColor=function(){return this.color},a.Material.prototype.setSpecularColor=function(b){b.r==undefined&&(b=a.colorParse(b)),this.specColor={r:parseFloat(b.r),g:parseFloat(b.g),b:parseFloat(b.b)},this.fireEvent("shaderupdate",{});return this},a.Material.prototype.getAmbient=function(){return this.ambient},a.Material.prototype.setAmbient=function(b){b.r||(b=a.colorParse(b)),this.ambient={r:parseFloat(b.r),g:parseFloat(b.g),b:parseFloat(b.b)},this.fireEvent("shaderupdate",{});return this},a.Material.prototype.getSpecularColor=function(){return this.specColor},a.Material.prototype.setTranslucency=function(a){this.translucency=parseFloat(a),this.fireEvent("shaderupdate",{});return this},a.Material.prototype.getTranslucency=function(){return this.translucency},a.Material.prototype.setAlpha=function(a){this.alpha=a;return this},a.Material.prototype.getAlpha=function(){return this.alpha},a.Material.prototype.setSpecular=function(a){this.specular=a,this.fireEvent("shaderupdate",{});return this},a.Material.prototype.getSpecular=function(){return this.specular},a.Material.prototype.setShininess=function(a){a<=0&&(a=.001),this.shine=a,this.fireEvent("shaderupdate",{});return this},a.Material.prototype.getShininess=function(){return this.shine},a.Material.prototype.setEmit=function(b){b>0&&(b={r:b,g:b,b:b}),b.r||(b=a.colorParse(b)),this.emit={r:parseFloat(b.r),g:parseFloat(b.g),b:parseFloat(b.b)},this.fireEvent("shaderupdate",{});return this},a.Material.prototype.setEmitR=function(a){this.emit.r=parseFloat(a);return this},a.Material.prototype.setEmitG=function(a){this.emit.g=parseFloat(a);return this},a.Material.prototype.setEmitB=function(a){this.emit.b=parseFloat(a);return this},a.Material.prototype.getEmitR=function(a){return this.emit.r},a.Material.prototype.getEmitG=function(a){return this.emit.g},a.Material.prototype.getEmitB=function(a){return this.emit.b},a.Material.prototype.getEmit=function(){return this.emit},a.Material.prototype.setReflectivity=function(a){this.reflect=a,this.fireEvent("shaderupdate",{});return this},a.Material.prototype.getReflectivity=function(){return this.reflect},a.Material.prototype.setBinaryAlpha=function(a){this.binaryAlpha=a,this.fireEvent("shaderupdate",{});return this},a.Material.prototype.getBinaryAlpha=function(){return this.binaryAlpha},a.Material.prototype.addMaterialLayer=function(b){typeof b=="string"&&(b=a.Assets.get(b)),this.layers.push(b);var c=this,d=function(a){c.fireEvent("shaderupdate",{})};this.layerlisteners.push(d),b.addEventListener("shaderupdate",d),this.fireEvent("shaderupdate",{});return this},a.Material.prototype.removeMaterialLayer=function(a){var b=this.layers.indexOf(a);b>=0&&(this.layers.splice(b,1),a.removeEventListener("shaderupdate",this.layerlisteners[b]),this.layerlisteners.splice(b,1),this.fireEvent("shaderupdate",{}));return this},a.Material.prototype.getLayers=function(){return this.layers},a.Material.prototype.getLayerCoords=function(b){var c=[];c.push("vec4 texturePos;\n");for(var d=0;d<this.layers.length;d++)c.push("textureCoords"+d+"=vec3(0.0,0.0,0.0);\n"),(this.layers[d].mapinput==a.UV1||this.layers[d].mapinput==a.UV2)&&c.push("texturePos=vec4(vec2(UVCoord["+this.layers[d].mapinput*2+"],(1.0-UVCoord["+(this.layers[d].mapinput*2+1)+"])),1.0,1.0);\n"),this.layers[d].mapinput==a.MAP_NORM&&c.push("texturePos=vec4(normalize(n.xyz),1.0);\n"),this.layers[d].mapinput==a.MAP_OBJ&&c.push("texturePos=vec4(normalize(OBJCoord.xyz),1.0);\n"),this.layers[d].mapinput==a.MAP_GLOBAL&&c.push("texturePos=vec4(OBJCoord.xyz,1.0);\n"),this.layers[d].mapinput==a.MAP_REF&&c.push("texturePos=vec4(reflect(normalize(eyevec.xyz),normalize(n.xyz)),1.0);\n"),this.layers[d].mapinput==a.MAP_ENV&&c.push("texturePos=envMat * vec4(reflect(normalize(eyevec.xyz),normalize(n.xyz)),1.0);\n"),c.push("textureCoords"+d+"=(layer"+d+"Matrix * texturePos).xyz;\n"),b&&~b.indexOf("GLGE_Texcoord")&&c.push("textureCoords"+d+"=GLGE_Texcoord("+d+",textureCoords"+d+");\n");return c.join("")},a.Material.prototype.getVertexVarying=function(){var a=[];for(var b=0;b<this.layers.length;b++)a.push("uniform mat4 layer"+b+"Matrix;\n"),a.push("varying vec3 textureCoords"+b+";\n");return a.join("")},a.Material.prototype.registerPasses=function(a,b){for(var c=0;c<this.textures.length;c++)this.textures[c].registerPasses&&this.textures[c].registerPasses(a,b)},a.Material.prototype.getFragmentShader=function(b,c,d,e){var f="#ifdef GL_ES\nprecision highp float;\n#endif\n#define GLGE_FRAGMENT\n";e&&(f=f+"uniform float distance;\n",f=f+"uniform bool shadowtype;\n"),d&&(f+=d);var g=!1;for(var h=0;h<b.length;h++)if(b[h].type==a.L_POINT||b[h].type==a.L_SPOT||b[h].type==a.L_DIR)f=f+"varying vec3 lightvec"+h+";\n",f=f+"varying float lightdist"+h+";\n";f=f+"varying vec3 n;\n",f=f+"varying vec3 t;\n",f=f+"varying vec4 UVCoord;\n",f=f+"varying vec3 eyevec;\n",f=f+"varying vec3 OBJCoord;\n",c&&(f=f+"varying vec4 vcolor;\n");for(var h=0;h<this.textures.length;h++)this.textures[h].className=="Texture"&&(f=f+"uniform sampler2D TEXTURE"+h+";\n"),this.textures[h].className=="TextureCanvas"&&(f=f+"uniform sampler2D TEXTURE"+h+";\n"),this.textures[h].className=="TextureCanvasCube"&&(f=f+"uniform samplerCube TEXTURE"+h+";\n"),this.textures[h].className=="TextureVideo"&&(f=f+"uniform sampler2D TEXTURE"+h+";\n"),this.textures[h].className=="TextureCube"&&(f=f+"uniform samplerCube TEXTURE"+h+";\n");var i=1,j=[],k;for(var h=0;h<b.length;h++){if(b[h].type==a.L_OFF)continue;f=f+"uniform vec3 lightcolor"+h+";\n",f=f+"uniform vec3 lightAttenuation"+h+";\n",f=f+"uniform float spotCosCutOff"+h+";\n",f=f+"uniform float spotExp"+h+";\n",f=f+"uniform vec3 lightdir"+h+";\n",f=f+"uniform mat4 lightmat"+h+";\n",f=f+"uniform float shadowbias"+h+";\n",f=f+"uniform int shadowsamples"+h+";\n",f=f+"uniform float shadowsoftness"+h+";\n",f=f+"uniform bool castshadows"+h+";\n",f=f+"uniform vec2 shadowoffset"+h+";\n",b[h].getCastShadows()&&this.shadow&&(f=f+"varying vec4 spotcoord"+h+";\n",k=this.textures.length+i++,f=f+"uniform sampler2D TEXTURE"+k+";\n",j[h]=k)}for(h=0;h<this.layers.length;h++){f=f+"varying vec3 textureCoords"+h+";\n",f=f+"uniform float layeralpha"+h+";\n",this.layers[h].mapinput==a.MAP_VIEW&&(f=f+"uniform mat4 layer"+h+"Matrix;\n");if((this.layers[h].mapto&a.M_HEIGHT)==a.M_HEIGHT||(this.layers[h].mapto&a.M_STEEP)==a.M_STEEP)f=f+"uniform float layerheight"+h+";\n"}f=f+"uniform sampler2D sky;\n",f=f+"uniform vec4 baseColor;\n",f=f+"uniform vec3 specColor;\n",f=f+"uniform float shine;\n",f=f+"uniform float specular;\n",f=f+"uniform float reflective;\n",f=f+"uniform vec3 emit;\n",f=f+"uniform float alpha;\n",f=f+"uniform vec3 amb;\n",f=f+"uniform float fognear;\n",f=f+"uniform float fogfar;\n",f=f+"uniform int fogtype;\n",f=f+"uniform vec3 fogcolor;\n",f=f+"uniform float far;\n",f=f+"uniform mat4 worldInverseTranspose;\n",f=f+"uniform mat4 projection;\n",f=f+"uniform bool emitpass;\n",f=f+"uniform bool shadeless;\n",f=f+"void main(void)\n",f=f+"{\n",f=f+"float att;\n",f=f+"int texture;\n",f=f+"float mask=1.0;\n",f=f+"float spec=specular;\n",f=f+"vec3 specC=specColor;\n",f=f+"vec4 view;\n",f=f+"vec3 textureCoords=vec3(0.0,0.0,0.0);\n",f=f+"float ref=reflective;\n",f=f+"float sh=shine;\n",f=f+"vec3 em=emit;\n",f=f+"float al=alpha;\n",f=f+"vec3 amblight=vec3(1.0,1.0,1.0);\n",f=f+"vec4 normalmap= vec4(n,0.0);\n",c&&this.vertexColorMode==a.VC_BASE?(f=f+"vec4 color= vcolor;",f=f+"al = vcolor.a;"):f=f+"vec4 color = baseColor;",f=f+"float pheight=0.0;\n",f=f+"vec3 textureHeight=vec3(0.0,0.0,0.0);\n",f=f+"vec3 normal = normalize(n);\n",f=f+"vec3 b = vec3(0.0,0.0,0.0);\n";var l=0,m=!1;for(h=0;h<this.layers.length;h++){f=f+"textureCoords=textureCoords"+h+"+textureHeight;\n",f=f+"mask=layeralpha"+h+"*mask;\n",this.layers[h].mapinput==a.MAP_VIEW&&(f=f+"view=projection * vec4(-eyevec,1.0);\n",f=f+"textureCoords=view.xyz/view.w*0.5+0.5;\n",f=f+"textureCoords=(layer"+h+"Matrix*vec4(textureCoords,1.0)).xyz+textureHeight;\n"),this.layers[h].mapinput==a.MAP_POINT&&(f=f+"textureCoords=vec3(gl_PointCoord,1.0);\n");if(this.layers[h].getTexture().className=="Texture"||this.layers[h].getTexture().className=="TextureCanvas"||this.layers[h].getTexture().className=="TextureVideo")var n="xy",o="2D";else var n="xyz",o="Cube";(this.layers[h].mapto&a.M_COLOR)==a.M_COLOR&&(l=h,this.layers[h].blendMode==a.BL_MUL?f=f+"color = color*(1.0-mask) + color*texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+")*mask;\n":f=f+"color = color*(1.0-mask) + texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+")*mask;\n"),(this.layers[h].mapto&a.M_HEIGHT)==a.M_HEIGHT&&(f=f+"pheight = texture2D(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").x;\n",f=f+"textureHeight =vec3((layerheight"+h+"* (pheight-0.5)  * normalize(eyevec).xy*vec2(1.0,-1.0)),0.0);\n"),(this.layers[h].mapto&a.M_STEEP)==a.M_STEEP&&(f=f+"b=normalize(cross(t.xyz,n));\n",f=f+"vec3 neye=normalize(eyevec.xyz);",f=f+"neye = vec3(dot(neye,t),dot(neye,b),dot(neye,n));",f=f+"neye = normalize(neye);",f=f+"float stepheight"+h+"=layerheight"+h+";",f=f+"float steepstep"+h+"=(1.0/8.0)*stepheight"+h+"/neye.z;",f=f+"float steepdisplace"+h+"=0.0;",f=f+"for(int steepcount"+h+"=0;steepcount"+h+"<8;steepcount"+h+"++){",f=f+"pheight = texture2D(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+"+vec2(neye.x,neye.y)*steepdisplace"+h+").x;\n",f=f+"if(pheight*stepheight"+h+">neye.z*steepdisplace"+h+"){",f=f+"textureHeight=vec3(vec2(neye.x,neye.y)*steepdisplace"+h+",0.0);",f=f+"}else{",f=f+"steepdisplace"+h+"-=steepstep"+h+";",f=f+"steepstep"+h+"*=0.5;",f=f+"}",f=f+"steepdisplace"+h+"+=steepstep"+h+";",f=f+"}"),(this.layers[h].mapto&a.M_SPECCOLOR)==a.M_SPECCOLOR&&(f=f+"specC = specC*(1.0-mask) + texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").rgb*mask;\n"),(this.layers[h].mapto&a.M_MSKR)==a.M_MSKR&&(f=f+"mask = texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").r;\n"),(this.layers[h].mapto&a.M_MSKG)==a.M_MSKG&&(f=f+"mask = texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").g;\n"),(this.layers[h].mapto&a.M_MSKB)==a.M_MSKB&&(f=f+"mask = texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").b;\n"),(this.layers[h].mapto&a.M_MSKA)==a.M_MSKA&&(f=f+"mask = texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").a;\n"),(this.layers[h].mapto&a.M_SPECULAR)==a.M_SPECULAR&&(f=f+"spec = spec*(1.0-mask) + texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").r*mask;\n"),(this.layers[h].mapto&a.M_REFLECT)==a.M_REFLECT&&(f=f+"ref = ref*(1.0-mask) + texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").g*mask;\n"),(this.layers[h].mapto&a.M_SHINE)==a.M_SHINE&&(f=f+"sh = sh*(1.0-mask) + texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").b*mask*255.0;\n"),(this.layers[h].mapto&a.M_EMIT)==a.M_EMIT&&(f=f+"em = em*(1.0-mask) + texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").rgb*mask;\n"),(this.layers[h].mapto&a.M_NOR)==a.M_NOR&&(f=f+"normalmap = normalmap*(1.0-mask) + texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+")*mask;\n",f=f+"normal = normalmap.rgb;\n",f=f+"normal = 2.0*(vec3(normal.r, -normal.g, normal.b) - vec3(0.5, -0.5, 0.5));",f=f+"b=normalize(cross(t.xyz,n));\n",f=f+"normal = normal.x*t + normal.y*b + normal.z*n;",f=f+"normal = normalize(normal);"),(this.layers[h].mapto&a.M_ALPHA)==a.M_ALPHA&&(m=!0,f=f+"al = al*(1.0-mask) + texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").a*mask;\n"),(this.layers[h].mapto&a.M_AMBIENT)==a.M_AMBIENT&&(f=f+"amblight = amblight*(1.0-mask) + texture"+o+"(TEXTURE"+this.layers[h].texture.idx+", textureCoords."+n+").rgb*mask;\n")}f=f+"amblight *= amb;\n";if(!m&&this.layers.length){if(this.layers[l].getTexture().className=="Texture"||this.layers[l].getTexture().className=="TextureCanvas"||this.layers[l].getTexture().className=="TextureVideo")var n="xy",o="2D";else var n="xyz",o="Cube";f=f+"al = al*(1.0-mask) + texture"+o+"(TEXTURE"+this.layers[l].texture.idx+", textureCoords."+n+").a*al*mask;\n"}c&&this.vertexColorMode==a.VC_MUL&&(f=f+"color *= vcolor;"),this.binaryAlpha?(f=f+"if(al<0.5) discard;\n",f=f+"al=1.0;\n"):f=f+"if(al==0.0) discard;\n",f=f+"vec3 lightvalue=amblight;\n",c&&this.vertexColorMode==a.VC_AMB&&(f=f+"lightvalue = vcolor.rgb;"),c&&this.vertexColorMode==a.VC_AMBMUL&&(f=f+"lightvalue *= vcolor.rgb;"),f=f+"float dotN,spotEffect;",f=f+"vec3 lightvec=vec3(0.0,0.0,0.0);",f=f+"vec3 viewvec=vec3(0.0,0.0,0.0);",f=f+"vec3 specvalue=vec3(0.0,0.0,0.0);",f=f+"vec2 scoord=vec2(0.0,0.0);",f=f+"float sDepth=0.0;",f=f+"float d1=0.0;",f=f+"float d2=0.0;",f=f+"float spotmul=0.0;",f=f+"float rnd=0.0;",f=f+"float spotsampleX=0.0;",f=f+"float spotsampleY=0.0;",f=f+"float totalweight=0.0;",f=f+"int cnt=0;",f=f+"float specularSmoothStepValue=.125;\n",f=f+"vec2 spotoffset=vec2(0.0,0.0);",f=f+"float dp=0.0;",f=f+"vec4 dist;float depth,m1,m2,prob,variance;\n",f=f+"if (normal.z<0.0) {normal.z=0.0;}\n",f=f+"float fogfact=1.0;",f=f+"if(fogtype=="+a.FOG_QUADRATIC+" || fogtype=="+a.FOG_SKYQUADRATIC+") fogfact=clamp(pow(max((fogfar - length(eyevec)) / (fogfar - fognear),0.0),2.0),0.0,1.0);\n",f=f+"if(fogtype=="+a.FOG_LINEAR+" || fogtype=="+a.FOG_SKYLINEAR+") fogfact=clamp((fogfar - length(eyevec)) / (fogfar - fognear),0.0,1.0);\n";if(e)f=f+"float shadowdepth = gl_FragCoord.z;\n",f=f+"if(shadowtype) shadowdepth=length(eyevec)/distance;\n",f=f+"vec4 rgba=fract(shadowdepth * vec4(16777216.0, 65536.0, 256.0, 1.0));\n",f=f+"gl_FragColor=rgba-rgba.rrgb*vec4(0.0,0.00390625,0.00390625,0.00390625);\n";else{f=f+"if (emitpass) {gl_FragColor=vec4(em,1.0);} else if (shadeless) {\n",f=f+"gl_FragColor=vec4(color.rgb,al);\n",this.fadeDistance>0&&(f=f+"gl_FragColor.a=gl_FragColor.a*(1.0-min(1.0,"+this.fadeDistance.toFixed(5)+"/length(eyevec)));\n"),f=f+"} else {\n";for(var h=0;h<b.length;h++){if(b[h].type==a.L_OFF)continue;f=f+"lightvec=lightvec"+h+";\n",f=f+"viewvec=eyevec;\n",b[h].type==a.L_POINT&&(this.translucency==0?f=f+"dotN=max(dot(normal,normalize(-lightvec)),0.0);\n":(f=f+"dotN=dot(normal,normalize(-lightvec));\n",f=f+"if (dotN<0.0) dotN*=-"+this.translucency.toFixed(2)+";\n"),f=f+"att = 1.0 / (lightAttenuation"+h+"[0] + lightAttenuation"+h+"[1] * lightdist"+h+" + lightAttenuation"+h+"[2] * lightdist"+h+" * lightdist"+h+");\n",f=f+"if(dotN>0.0){\n",b[h].diffuse&&(f=f+"lightvalue += att * dotN * lightcolor"+h+";\n"),f=f+"}\n",b[h].specular&&(f=f+"specvalue += smoothstep(-specularSmoothStepValue,specularSmoothStepValue,dotN)*att * specC * lightcolor"+h+" * spec  * pow(max(dot(reflect(normalize(lightvec), normal),normalize(viewvec)),0.0), 0.3*sh);\n")),f=f+"spotEffect = 0.0;\n",b[h].type==a.L_SPOT&&(f=f+"spotEffect = dot(normalize(lightdir"+h+"), normalize(-lightvec"+h+"));",f=f+"if (spotEffect > spotCosCutOff"+h+""+(this.spotCutOff?"":" || spotEffect>0.0")+") {\n",f=f+"spotEffect = pow(spotEffect, spotExp"+h+");",b[h].getCastShadows()&&this.shadow&&(f=f+"scoord=(((spotcoord"+h+".xy)/spotcoord"+h+".w)+1.0)/2.0;\n",f=f+"if(scoord.x>0.0 && scoord.x<1.0 && scoord.y>0.0 && scoord.y<1.0){\n",f=f+"dist=texture2D(TEXTURE"+j[h]+", scoord);\n",b[h].spotSoftness==0?(f=f+"depth = dot(dist, vec4(0.000000059604644775390625,0.0000152587890625,0.00390625,1.0))*"+b[h].distance+".0;\n",f=f+"if(depth<length(lightvec"+h+")) spotmul=1.0; else spotmul=0.0;\n"):(f=f+"m1 = pow(dot(dist, vec4(0.00390625,1.0,0.0,0.0)),2.0);\n",f=f+"m2 = dot(dist, vec4(0.0,0.0,0.00390625,1.0));\n",f=f+"variance = min(max(m1-m2*m2, 0.0) + 0.000002, 1.0);;\n",f=f+"depth=length(lightvec"+h+")/"+b[h].distance+".0-m2;\n",f=f+"prob=variance /(  variance + depth*depth );\n",f=f+"prob=smoothstep("+b[h].spotSoftnessDistance.toFixed(2)+",1.0,prob);\n",f=f+"if (depth<=0.0) prob=1.0;\n",f=f+"spotmul=1.0-prob;\n"),f=f+"spotEffect=spotEffect*(1.0-spotmul);\n",f=f+"spotEffect="+this.translucency.toFixed(2)+"+"+(1-this.translucency).toFixed(2)+"*spotEffect;\n",f=f+"}\n"),this.translucency==0?f=f+"dotN=max(dot(normal,normalize(-lightvec)),0.0);\n":(f=f+"dotN=dot(normal,normalize(-lightvec));\n",f=f+"if (dotN<0.0) dotN*=-"+this.translucency.toFixed(2)+";\n"),b[h].negativeShadow?(f=f+"if(dotN>0.0){\n",b[h].diffuse&&(f=f+"lightvalue -= (1.0-spotEffect) / (lightAttenuation"+h+"[0] + lightAttenuation"+h+"[1] * lightdist"+h+" + lightAttenuation"+h+"[2] * lightdist"+h+" * lightdist"+h+");\n"),f=f+"}\n"):(f=f+"att = spotEffect / (lightAttenuation"+h+"[0] + lightdist"+h+"*(lightAttenuation"+h+"[1]  + lightAttenuation"+h+"[2] * lightdist"+h+"));\n",f=f+"if(dotN>0.0){\n",b[h].diffuse&&(f=f+"lightvalue += att * dotN * lightcolor"+h+";\n"),f=f+"}\n",b[h].specular&&(f=f+"specvalue += smoothstep(-specularSmoothStepValue,specularSmoothStepValue,dotN) * att * specC * lightcolor"+h+" * spec  * pow(max(dot(reflect(normalize(lightvec), normal),normalize(viewvec)),0.0), 0.3 * sh);\n")),f=f+"}\n");if(b[h].type==a.L_DIR){this.translucency==0?f=f+"dotN=max(dot(normal,normalize(-lightvec)),0.0);\n":(f=f+"dotN=dot(normal,normalize(-lightvec));\n",f=f+"if (dotN<0.0) dotN*=-"+this.translucency.toFixed(2)+";\n");if(b[h].getCastShadows()&&this.shadow){f=f+"float shadowfact"+h+" = 0.0;\n",f=f+"scoord=((spotcoord"+h+".xy)/spotcoord"+h+".w+1.0)/2.0;\n";var p=1/b[h].bufferWidth,q=1/b[h].bufferHeight;f=f+"dist=texture2D(TEXTURE"+j[h]+", scoord );\n",f=f+"depth = dot(dist, vec4(0.000000059604644775390625,0.0000152587890625,0.00390625,1.0));\n",f=f+"d1 = depth;\n",f=f+"d2 = depth*depth;\n",f=f+"dist=texture2D(TEXTURE"+j[h]+", scoord+vec2("+p.toFixed(5)+","+q.toFixed(5)+") );\n",f=f+"depth = dot(dist, vec4(0.000000059604644775390625,0.0000152587890625,0.00390625,1.0));\n",f=f+"d1 += depth;\n",f=f+"d2 += depth*depth;\n",f=f+"dist=texture2D(TEXTURE"+j[h]+", scoord+vec2(-"+p.toFixed(5)+","+q.toFixed(5)+"));\n",f=f+"depth = dot(dist, vec4(0.000000059604644775390625,0.0000152587890625,0.00390625,1.0));\n",f=f+"d1 += depth;\n",f=f+"d2 += depth*depth;\n",f=f+"dist=texture2D(TEXTURE"+j[h]+", scoord+vec2("+p.toFixed(5)+",-"+q.toFixed(5)+"));\n",f=f+"depth = dot(dist, vec4(0.000000059604644775390625,0.0000152587890625,0.00390625,1.0));\n",f=f+"d1 += depth;\n",f=f+"d2 += depth*depth;\n",f=f+"dist=texture2D(TEXTURE"+j[h]+", scoord+vec2(-"+p.toFixed(5)+",-"+q.toFixed(5)+"));\n",f=f+"depth = dot(dist, vec4(0.000000059604644775390625,0.0000152587890625,0.00390625,1.0));\n",f=f+"d1 += depth;\n",f=f+"d2 += depth*depth;\n",f=f+"d1 *= 0.2;\n",f=f+"d2 *= 0.2;\n",f=f+"sDepth = max(0.0, ((spotcoord"+h+".z/spotcoord"+h+".w)+1.0)/2.0-d1-"+b[h].shadowBias+");\n",f=f+"variance = min(max(d2-d1*d1, 0.0)+"+b[h].varianceMin+", 1.0);\n",f=f+"prob=variance /(  variance + sDepth*sDepth );\n",f=f+"prob=smoothstep("+b[h].bleedCutoff.toFixed(2)+",1.0,prob);\n",f=f+"shadowfact"+h+"=prob;\n"}else f=f+"float shadowfact"+h+" = 1.0;\n";b[h].diffuse&&(b[h].negativeShadow?f=f+"lightvalue -= lightcolor"+h+"-(dotN * lightcolor"+h+" * shadowfact"+h+");\n":(f=f+"shadowfact"+h+"="+this.translucency.toFixed(2)+"+"+(1-this.translucency).toFixed(2)+"*shadowfact"+h+";\n",f=f+"lightvalue += dotN * lightcolor"+h+" * shadowfact"+h+";\n")),b[h].specular&&(f=f+"specvalue += smoothstep(-specularSmoothStepValue,specularSmoothStepValue,dotN) * specC * lightcolor"+h+" * spec  * pow(max(dot(reflect(normalize(lightvec), normal),normalize(viewvec)),0.0), 0.3 * sh);\n")}}f=f+"lightvalue = (lightvalue)*ref;\n",f=f+"vec3 fc=fogcolor.rgb;\n",f=f+"if(fogtype=="+a.FOG_SKYLINEAR+" || fogtype=="+a.FOG_SKYQUADRATIC+"){",f=f+"vec4 view=projection * vec4(-eyevec,1.0);\n",f=f+"vec2 fogCoords=view.xy/view.w*0.5+0.5;\n",f=f+"fc=texture2D(sky,fogCoords.xy).rgb;\n",f=f+"}\n",f=f+"vec4 finalColor =vec4(specvalue.rgb+color.rgb*lightvalue.rgb+em.rgb,al)*fogfact+vec4(fc,al)*(1.0-fogfact);\n",d&&~d.indexOf("GLGE_FragColor")&&(f=f+"finalColor=GLGE_FragColor(finalColor);\n"),this.fadeDistance>0&&(f=f+"finalColor.a=finalColor.a*(1.0-min(1.0,"+this.fadeDistance.toFixed(5)+"/length(eyevec)));\n"),this.fadeDistance<0&&(f=f+"finalColor.a=finalColor.a*(min(1.0,"+(-this.fadeDistance).toFixed(5)+"/length(eyevec)));\n"),f=f+"gl_FragColor = finalColor;",a.DEBUGNORMALS&&(f=f+"gl_FragColor = vec4(normal.rgb,1.0);"),a.DEBUGCOORD0&&(f=f+"gl_FragColor = vec4(textureCoords0.rg,0.0,1.0);"),f=f+"}\n"}f=f+"}\n";return f},a.Material.prototype.textureUniforms=function(b,c,d,e){this.animation&&this.animate();var f=c.caches;if(!f.baseColor||f.baseColor.r!=this.color.r||f.baseColor.g!=this.color.g||f.baseColor.b!=this.color.b||f.baseColor.a!=this.color.a){if(!this.ccache||this.ccache.r!=this.color.r||this.ccache.g!=this.color.g||this.ccache.b!=this.color.b||this.ccache.a!=this.color.a)this.ccache=this.color,this.glColor=new Float32Array([this.color.r,this.color.g,this.color.b,this.color.a]);b.uniform4fv(a.getUniformLocation(b,c,"baseColor"),this.glColor),f.baseColor=this.color}f.specColor!=this.specColor&&(this.sccache!=this.specColor&&(this.sccache=this.specColor,this.glspecColor=new Float32Array([this.specColor.r,this.specColor.g,this.specColor.b])),b.uniform3fv(a.getUniformLocation(b,c,"specColor"),this.glspecColor),f.specColor=this.specColor),f.emit!=this.emit&&(b.uniform3f(a.getUniformLocation(b,c,"emit"),this.emit.r,this.emit.g,this.emit.b),f.emit=this.emit),f.specular!=this.specular&&(a.setUniform(b,"1f",a.getUniformLocation(b,c,"specular"),this.specular),f.specular=this.specular),f.shine!=this.shine&&(a.setUniform(b,"1f",a.getUniformLocation(b,c,"shine"),this.shine),f.shine=this.shine),f.reflect!=this.reflect&&(a.setUniform(b,"1f",a.getUniformLocation(b,c,"reflective"),this.reflect),f.reflect=this.reflect),f.alpha!=this.alpha&&(a.setUniform(b,"1f",a.getUniformLocation(b,c,"alpha"),this.alpha),f.alpha=this.alpha);if(f.shadeless==undefined||f.shadeless!=this.shadeless)a.setUniform(b,"1i",a.getUniformLocation(b,c,"shadeless"),this.shadeless),f.shadeless=this.shadeless;var g=1,h=0;f.lightcolor||(f.lightcolor=[],f.lightAttenuation=[],f.spotCosCutOff=[],f.spotExponent=[],f.shadowbias=[],f.castshadows=[],f.shadowsamples=[],f.shadowsoftness=[]);if(d)for(var i=0;i<d.length;i++){if(d[i].type==a.L_OFF)continue;f.lightcolor[i]!=d[i].color&&(a.setUniform3(b,"3f",a.getUniformLocation(b,c,"lightcolor"+i),d[i].color.r,d[i].color.g,d[i].color.b),f.lightcolor[i]={r:d[i].color.r,g:d[i].color.g,b:d[i].color.b}),f.lightAttenuation[i]!=d[i].constantAttenuation&&(a.setUniform3(b,"3f",a.getUniformLocation(b,c,"lightAttenuation"+i),d[i].constantAttenuation,d[i].linearAttenuation,d[i].quadraticAttenuation),f.lightAttenuation[i]=d[i].constantAttenuation),f.spotCosCutOff[i]!=d[i].spotCosCutOff&&(a.setUniform(b,"1f",a.getUniformLocation(b,c,"spotCosCutOff"+i),d[i].spotCosCutOff),f.spotCosCutOff[i]=d[i].spotCosCutOff),f.spotExponent[i]!=d[i].spotExponent&&(a.setUniform(b,"1f",a.getUniformLocation(b,c,"spotExp"+i),d[i].spotExponent),f.spotExponent[i]=d[i].spotExponent),f.shadowbias[i]!=d[i].shadowBias&&(a.setUniform(b,"1f",a.getUniformLocation(b,c,"shadowbias"+i),d[i].shadowBias),f.shadowbias[i]=d[i].shadowBias),f.shadowsoftness[i]!=d[i].softness&&(a.setUniform(b,"1f",a.getUniformLocation(b,c,"shadowsoftness"+i),d[i].softness),f.shadowsoftness[i]=d[i].softness),d[i].getCastShadows()&&this.shadow&&(h=this.textures.length+g++,b.activeTexture(b["TEXTURE"+h]),b.bindTexture(b.TEXTURE_2D,d[i].texture),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE),a.setUniform(b,"1i",a.getUniformLocation(b,c,"TEXTURE"+h),h))}c.glarrays.layermat||(c.glarrays.layermat=[]);var j,k;for(i=0;i<this.layers.length;i++){this.layers[i].animation&&this.layers[i].animate(),j=this.layers[i].getScale(),k=this.layers[i].getOffset(),c.glarrays.layermat[i]?a.mat4gl(this.layers[i].getMatrix(),c.glarrays.layermat[i]):c.glarrays.layermat[i]=new Float32Array(this.layers[i].getMatrix());try{a.setUniformMatrix(b,"Matrix4fv",a.getUniformLocation(b,c,"layer"+i+"Matrix"),!0,c.glarrays.layermat[i])}catch(l){}a.setUniform(b,"1f",a.getUniformLocation(b,c,"layeralpha"+i),this.layers[i].getAlpha()),a.setUniform(b,"1f",a.getUniformLocation(b,c,"layerheight"+i),this.layers[i].getHeight())}for(var i=0;i<this.textures.length;i++)b.activeTexture(b["TEXTURE"+(i+1)]),!this.textures[i].doTexture(b,e),a.setUniform(b,"1i",a.getUniformLocation(b,c,"TEXTURE"+i),i+1);b.scene.skyTexture&&(b.activeTexture(b.TEXTURE0),b.bindTexture(b.TEXTURE_2D,b.scene.skyTexture),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE),a.setUniform(b,"1i",a.getUniformLocation(b,c,"sky"),0))},a.Material.prototype.isComplete=function(){for(var a=0;a<this.textures.length;a++){if(!this.textures[a].isComplete)continue;if(!this.textures[a].isComplete())return!1}return!0},a.Material.prototype.addTexture=function(b){typeof b=="string"&&(b=a.Assets.get(b));var c=this;b.addEventListener("downloadComplete",function(){c.isComplete()&&c.fireEvent("downloadComplete")}),this.textures.push(b),b.idx=this.textures.length-1,this.fireEvent("shaderupdate",{});return this},a.Material.prototype.addTextureCube=a.Material.prototype.addTexture,a.Material.prototype.addTextureCamera=a.Material.prototype.addTexture,a.Material.prototype.addTextureCameraCube=a.Material.prototype.addTexture,a.Material.prototype.addTextureCanvas=a.Material.prototype.addTexture,a.Material.prototype.addTextureVideo=a.Material.prototype.addTexture,a.DEFAULT_MATERIAL=new a.Material}(GLGE),function(a){a.MaterialLayer=function(b){this.blendMode=a.BL_MIX,a.Assets.registerAsset(this,b)},a.augment(a.Animatable,a.MaterialLayer),a.augment(a.QuickNotation,a.MaterialLayer),a.augment(a.JSONLoader,a.MaterialLayer),a.augment(a.Events,a.MaterialLayer),a.MaterialLayer.prototype.className="MaterialLayer",a.MaterialLayer.prototype.texture=null,a.MaterialLayer.prototype.blendMode=null,a.MaterialLayer.prototype.mapto=a.M_COLOR,a.MaterialLayer.prototype.mapinput=a.UV1,a.MaterialLayer.prototype.scaleX=1,a.MaterialLayer.prototype.offsetX=0,a.MaterialLayer.prototype.rotX=0,a.MaterialLayer.prototype.scaleY=1,a.MaterialLayer.prototype.offsetY=0,a.MaterialLayer.prototype.rotY=0,a.MaterialLayer.prototype.scaleZ=1,a.MaterialLayer.prototype.offsetZ=0,a.MaterialLayer.prototype.rotZ=0,a.MaterialLayer.prototype.dScaleX=0,a.MaterialLayer.prototype.dOffsetX=0,a.MaterialLayer.prototype.dRotX=0,a.MaterialLayer.prototype.dScaleY=0,a.MaterialLayer.prototype.dOffsetY=0,a.MaterialLayer.prototype.dRotY=0,a.MaterialLayer.prototype.dScaleZ=0,a.MaterialLayer.prototype.dOffsetZ=0,a.MaterialLayer.prototype.dRotZ=0,a.MaterialLayer.prototype.alpha=1,a.MaterialLayer.prototype.height=.05,a.MaterialLayer.prototype.matrix=null,a.MaterialLayer.prototype.getMatrix=function(){if(!this.matrix){var b=this.getOffset(),c=this.getScale(),d=this.getRotation();this.matrix=a.mulMat4(a.mulMat4(a.translateMatrix(b.x,b.y,b.z),a.scaleMatrix(c.x,c.y,c.z)),a.rotateMatrix(d.x,d.y,d.z))}return this.matrix},a.MaterialLayer.prototype.setHeight=function(a){this.height=a;return this},a.MaterialLayer.prototype.getHeight=function(){return this.height},a.MaterialLayer.prototype.setAlpha=function(a){this.alpha=a;return this},a.MaterialLayer.prototype.getAlpha=function(){return this.alpha},a.MaterialLayer.prototype.setTexture=function(b){typeof b=="string"&&(b=a.Assets.get(b)),this.texture=b,this.fireEvent("shaderupdate",{});return this},a.MaterialLayer.prototype.getTexture=function(){return this.texture},a.MaterialLayer.prototype.setMapto=function(a){this.mapto=a,this.fireEvent("shaderupdate",{});return this},a.MaterialLayer.prototype.getMapto=function(){return this.mapto},a.MaterialLayer.prototype.setMapinput=function(a){this.mapinput=a,this.fireEvent("shaderupdate",{});return this},a.MaterialLayer.prototype.getMapinput=function(){return this.mapinput},a.MaterialLayer.prototype.getOffset=function(){var a={};a.x=parseFloat(this.getOffsetX())+parseFloat(this.getDOffsetX()),a.y=parseFloat(this.getOffsetY())+parseFloat(this.getDOffsetY()),a.z=parseFloat(this.getOffsetZ())+parseFloat(this.getDOffsetZ());return a},a.MaterialLayer.prototype.getRotation=function(){var a={};a.x=parseFloat(this.getRotX())+parseFloat(this.getDRotX()),a.y=parseFloat(this.getRotY())+parseFloat(this.getDRotY()),a.z=parseFloat(this.getRotZ())+parseFloat(this.getDRotZ());return a},a.MaterialLayer.prototype.getScale=function(){var a={};a.x=parseFloat(this.getScaleX())+parseFloat(this.getDScaleX()),a.y=parseFloat(this.getScaleY())+parseFloat(this.getDScaleY()),a.z=parseFloat(this.getScaleZ())+parseFloat(this.getDScaleZ());return a},a.MaterialLayer.prototype.setOffsetX=function(a){this.matrix=null,this.offsetX=a;return this},a.MaterialLayer.prototype.getOffsetX=function(){return this.offsetX},a.MaterialLayer.prototype.setOffsetY=function(a){this.matrix=null,this.offsetY=a;return this},a.MaterialLayer.prototype.getOffsetY=function(){return this.offsetY},a.MaterialLayer.prototype.setOffsetZ=function(a){this.matrix=null,this.offsetZ=a;return this},a.MaterialLayer.prototype.getOffsetZ=function(){return this.offsetZ},a.MaterialLayer.prototype.setDOffsetX=function(a){this.matrix=null,this.dOffsetX=a;return this},a.MaterialLayer.prototype.getDOffsetX=function(){return this.dOffsetX},a.MaterialLayer.prototype.setDOffsetY=function(a){this.matrix=null,this.dOffsetY=a;return this},a.MaterialLayer.prototype.getDOffsetY=function(){return this.dOffsetY},a.MaterialLayer.prototype.setDOffsetZ=function(a){this.matrix=null,this.dOffsetZ=a;return this},a.MaterialLayer.prototype.getDOffsetZ=function(){return this.dOffsetZ},a.MaterialLayer.prototype.setScaleX=function(a){this.matrix=null,this.scaleX=a;return this},a.MaterialLayer.prototype.getScaleX=function(){return this.scaleX},a.MaterialLayer.prototype.setScaleY=function(a){this.matrix=null,this.scaleY=a;return this},a.MaterialLayer.prototype.getScaleY=function(){return this.scaleY},a.MaterialLayer.prototype.setScaleZ=function(a){this.matrix=null,this.scaleZ=a;return this},a.MaterialLayer.prototype.getScaleZ=function(){return this.scaleZ},a.MaterialLayer.prototype.setDScaleX=function(a){this.matrix=null,this.dScaleX=a;return this},a.MaterialLayer.prototype.getDScaleX=function(){return this.dScaleX},a.MaterialLayer.prototype.setDScaleY=function(a){this.matrix=null,this.dScaleY=a;return this},a.MaterialLayer.prototype.getDScaleY=function(){return this.dScaleY},a.MaterialLayer.prototype.setDScaleZ=function(a){this.matrix=null,this.dScaleZ=a;return this},a.MaterialLayer.prototype.getDScaleZ=function(){return this.dScaleZ},a.MaterialLayer.prototype.setRotX=function(a){this.matrix=null,this.rotX=a;return this},a.MaterialLayer.prototype.getRotX=function(){return this.rotX},a.MaterialLayer.prototype.setRotY=function(a){this.matrix=null,this.rotY=a;return this},a.MaterialLayer.prototype.getRotY=function(){return this.rotY},a.MaterialLayer.prototype.setRotZ=function(a){this.matrix=null,this.rotZ=a;return this},a.MaterialLayer.prototype.getRotZ=function(){return this.rotZ},a.MaterialLayer.prototype.setDRotX=function(a){this.matrix=null,this.dRotX=a;return this},a.MaterialLayer.prototype.getDRotX=function(){return this.dRotX},a.MaterialLayer.prototype.setDRotY=function(a){this.matrix=null,this.dRotY=a;return this},a.MaterialLayer.prototype.getDRotY=function(){return this.dRotY},a.MaterialLayer.prototype.setDRotZ=function(a){this.matrix=null,this.dRotZ=a;return this},a.MaterialLayer.prototype.getDRotZ=function(){return this.dRotZ},a.MaterialLayer.prototype.setBlendMode=function(a){this.blendMode=a,this.fireEvent("shaderupdate",{});return this},a.MaterialLayer.prototype.getBlendMode=function(){return this.blendMode}}(GLGE),function(a){a.MultiMaterial=function(b){var c=this;this.downloadComplete=function(){c.isComplete()&&c.fireEvent("downloadComplete")},this.boundUpdate=function(){c.fireEvent("boundupdate")},this.lods=[new a.ObjectLod],this.lods[0].addEventListener("downloadComplete",this.downloadComplete),this.lods[0].addEventListener("boundupdate",this.boundUpdate),a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.MultiMaterial),a.augment(a.JSONLoader,a.MultiMaterial),a.augment(a.Events,a.MultiMaterial),a.MultiMaterial.prototype.className="MultiMaterial",a.MultiMaterial.prototype.oneLod=!0,a.MultiMaterial.prototype.isComplete=function(){for(var a=0;a<this.lods.length;a++)if(!this.lods[a].isComplete())return!1;return!0},a.MultiMaterial.prototype.setMesh=function(a){this.lods[0].setMesh(a);return this},a.MultiMaterial.prototype.getMesh=function(){return this.lods[0].getMesh()},a.MultiMaterial.prototype.setMaterial=function(a){this.lods[0].setMaterial(a);return this},a.MultiMaterial.prototype.getMaterial=function(){return this.lods[0].getMaterial()},a.MultiMaterial.prototype.getLOD=function(a){var b=0,c=this.lods[0];if(this.lods.length>1)for(var d=1;d<this.lods.length;d++){var e=this.lods[d].pixelSize;e>b&&e<a&&this.lods[d].mesh&&this.lods[d].mesh.loaded&&(b=e,c=this.lods[d])}return c},a.MultiMaterial.prototype.addObjectLod=function(a){this.oneLod&&(this.oneLod=!1,this.lods=[]),this.lods.push(a),a.addEventListener("downloadComplete",this.downloadComplete);return this},a.MultiMaterial.prototype.updateProgram=function(){for(var a=0;a<this.lods.length;a++)this.lods[a].GLShaderProgram=null;return this},a.MultiMaterial.prototype.removeObjectLod=function(a){var b=this.lods.indexOf(a);lods[b].removeEventListener("downloadComplete",this.downloadComplete),b&&this.lods.splice(b,1);return this}}(GLGE),function(a){a.Texture=function(b){a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.Texture),a.augment(a.JSONLoader,a.Texture),a.augment(a.Events,a.Texture),a.Texture.prototype.className="Texture",a.Texture.prototype.image=null,a.Texture.prototype.glTexture=null,a.Texture.prototype.url=null,a.Texture.prototype.state=0,a.Texture.prototype.anisotropy=8,a.Texture.prototype.preAlpha=!0,a.Texture.prototype.getPreMuliplyAlpha=function(){return this.preAlpha},a.Texture.prototype.setPreMuliplyAlpha=function(a){this.preAlpha=a;return this},a.Texture.prototype.getSrc=function(){return this.url},a.Texture.prototype.setSrc=function(a){this.url=a,this.state=0,this.image=new Image;var b=this;this.image.onload=function(){b.state=1,b.fireEvent("downloadComplete")},this.image.src=a,this.glTexture&&this.gl&&(this.glTexture=null);return this},a.Texture.prototype.doTexture=function(a){this.gl=a,a.urlTextures||(a.urlTextures={}),a.urlTextures[this.url]&&(this.glTexture=a.urlTextures[this.url],this.state=2),this.image||this.setSrc(this.url),this.glTexture||(this.glTexture=a.createTexture());if(this.state==1){a.bindTexture(a.TEXTURE_2D,this.glTexture);var b=Math.pow(2,Math.round(Math.log(this.image.width)/Math.log(2))),c=Math.pow(2,Math.round(Math.log(this.image.height)/Math.log(2))),d;if(b==this.image.width&&c==this.image.height)d=this.image;else{d=document.createElement("canvas"),d.width=b,d.height=c;var e=d.getContext("2d");e.drawImage(this.image,0,0,b,c)}a.texImage2D(a.TEXTURE_2D,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,d),a.urlTextures[this.url]=this.glTexture,a.generateMipmap(a.TEXTURE_2D),a.bindTexture(a.TEXTURE_2D,null),this.state=2}this.state==2?(a.bindTexture(a.TEXTURE_2D,this.glTexture),this.preAlpha&&a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,1),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.LINEAR_MIPMAP_LINEAR),a.af&&a.texParameterf(a.TEXTURE_2D,a.af.TEXTURE_MAX_ANISOTROPY_EXT,this.anisotropy),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.REPEAT),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.REPEAT)):a.bindTexture(a.TEXTURE_2D,null);return this.state==2?!0:!1},a.Texture.prototype.isComplete=function(){return this.state>0}}(GLGE),function(a){a.TextureCamera=function(b){a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.TextureCamera),a.augment(a.JSONLoader,a.TextureCamera),a.augment(a.Events,a.TextureCamera),a.TextureCamera.prototype.className="Texture",a.TextureCamera.prototype.texture=null,a.TextureCamera.prototype.glTexture=null,a.TextureCamera.prototype.object=null,a.TextureCamera.prototype.camera=null,a.TextureCamera.prototype.bufferHeight=0,a.TextureCamera.prototype.bufferWidth=0,a.TextureCamera.prototype.planeOffset=0,a.TextureCamera.prototype.mirrorAxis=a.NONE,a.TextureCamera.prototype.clipAxis=a.NONE,a.TextureCamera.prototype.autoUpdate=!0,a.TextureCamera.prototype.rendered=!1,a.TextureCamera.prototype.render=function(){this.rendered=!1;return this},a.TextureCamera.prototype.setAutoUpdate=function(a){this.autoUpdate=a;return this},a.TextureCamera.prototype.getAutoUpdate=function(){return this.autoUpdate},a.TextureCamera.prototype.setPlaneOffset=function(a){this.planeOffset=a;return this},a.TextureCamera.prototype.getPlaneOffset=function(){return this.planeOffset},a.TextureCamera.prototype.setBufferWidth=function(a){this.bufferWidth=a,this.update=!0;return this},a.TextureCamera.prototype.getBufferWidth=function(){return this.bufferWidth},a.TextureCamera.prototype.setBufferHeight=function(a){this.bufferHeight=a,this.update=!0;return this},a.TextureCamera.prototype.getBufferHeight=function(){return this.bufferHeight},a.TextureCamera.prototype.setClipAxis=function(a){this.clipAxis=a;return this},a.TextureCamera.prototype.getClipAxis=function(){return this.clipAxis},a.TextureCamera.prototype.setMirrorAxis=function(a){this.mirrorAxis=a;return this},a.TextureCamera.prototype.getMirrorAxis=function(){return this.mirrorAxis},a.TextureCamera.prototype.setCamera=function(a){this.camera=a;return this},a.TextureCamera.prototype.getCamera=function(){return this.camera},a.TextureCamera.prototype.doTexture=function(b,c){if(!this.camera)return!1;if(!this.autoRender&&this.rendered&&0)b.bindTexture(b.TEXTURE_2D,this.glTexture);else{this.rendered=!0,this.gl=b;var d=c.getModelMatrix(),e=this.camera.pMatrix,f=this.camera.matrix;this.camera.pMatrix=null,this.camera.matrix=null;var g=this.camera.getProjectionMatrix().slice(0),h=this.camera.getViewMatrix().slice(0);this.camera.pMatrix=e,this.camera.matrix=f;var i;if(this.mirrorAxis)switch(this.mirrorAxis){case a.XAXIS:i=a.mulMat4(a.mulMat4(a.mulMat4(h,d),a.scaleMatrix(-1,1,1)),a.inverseMat4(d));break;case a.YAXIS:i=a.mulMat4(a.mulMat4(a.mulMat4(h,d),a.scaleMatrix(1,-1,1)),a.inverseMat4(d));break;case a.ZAXIS:i=a.mulMat4(a.mulMat4(a.mulMat4(h,d),a.scaleMatrix(1,1,-1)),a.inverseMat4(d))}else i=h;if(this.clipAxis){var j;switch(this.clipAxis){case a.NEG_XAXIS:var k=a.toUnitVec3([-d[0],-d[4],-d[8]]);j=[k[0],k[1],k[2],-a.dotVec3([d[3],d[7],d[11]],k)-this.planeOffset];break;case a.POS_XAXIS:var k=a.toUnitVec3([d[0],d[4],d[8]]);j=[k[0],k[1],k[2],-a.dotVec3([d[3],d[7],d[11]],k)-this.planeOffset];break;case a.NEG_YAXIS:var k=a.toUnitVec3([-d[1],-d[5],-d[9]]);j=[k[0],k[1],k[2],-a.dotVec3([d[3],d[7],d[11]],k)-this.planeOffset];break;case a.POS_YAXIS:var k=a.toUnitVec3([d[1],d[5],d[9]]);j=[k[0],k[1],k[2],-a.dotVec3([d[3],d[7],d[11]],k)-this.planeOffset];break;case a.NEG_ZAXIS:var k=a.toUnitVec3([-d[2],-d[6],-d[10]]);j=[k[0],k[1],k[2],-a.dotVec3([d[3],d[7],d[11]],k)-this.planeOffset];break;case a.POS_ZAXIS:var k=a.toUnitVec3([d[2],d[6],d[10]]);j=[k[0],k[1],k[2],-a.dotVec3([d[3],d[7],d[11]],k)-this.planeOffset]}var l=a.transposeMat4(a.inverseMat4(a.mulMat4(g,i)));j=a.mulMat4Vec4(l,j),j=a.scaleVec4(j,g[10]),j[3]-=1,j[2]<0&&a.scaleVec4(j,-1);var m=[1,0,0,0,0,1,0,0,j[0],j[1],j[2],j[3],0,0,0,1];g=a.mulMat4(m,g)}var n=this.bufferHeight?this.bufferHeight:b.scene.renderer.canvas.height,o=this.bufferWidth?this.bufferWidth:b.scene.renderer.canvas.width;if(!this.glTexture||this.update){this.createFrameBuffer(b),b.scene.addRenderPass(this.frameBuffer,i,b.scene.camera.getProjectionMatrix(),o,n,c,this.mirrorAxis?!0:!1),b.bindTexture(b.TEXTURE_2D,this.glTexture),this.update=!1;return!1}b.bindTexture(b.TEXTURE_2D,this.glTexture),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE),b.scene.addRenderPass(this.frameBuffer,i,g,o,n,c,this.mirrorAxis?!0:!1);return!0}},a.TextureCamera.prototype.registerPasses=a.TextureCamera.prototype.doTexture,a.TextureCamera.prototype.createFrameBuffer=function(a){var b=this.bufferHeight?this.bufferHeight:a.scene.renderer.canvas.height,c=this.bufferWidth?this.bufferWidth:a.scene.renderer.canvas.width;this.frameBuffer||(this.frameBuffer=a.createFramebuffer()),this.renderBuffer||(this.renderBuffer=a.createRenderbuffer()),this.glTexture||(this.glTexture=a.createTexture()),a.bindTexture(a.TEXTURE_2D,this.glTexture);var d=new Uint8Array(c*b*4);a.texImage2D(a.TEXTURE_2D,0,a.RGBA,c,b,0,a.RGBA,a.UNSIGNED_BYTE,d),a.bindFramebuffer(a.FRAMEBUFFER,this.frameBuffer),a.bindRenderbuffer(a.RENDERBUFFER,this.renderBuffer),a.renderbufferStorage(a.RENDERBUFFER,a.DEPTH_COMPONENT16,c,b),a.framebufferRenderbuffer(a.FRAMEBUFFER,a.DEPTH_ATTACHMENT,a.RENDERBUFFER,this.renderBuffer),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_2D,this.glTexture,0),a.bindRenderbuffer(a.RENDERBUFFER,null),a.bindFramebuffer(a.FRAMEBUFFER,null),a.bindTexture(a.TEXTURE_2D,null)}}(GLGE),function(a){a.TextureCameraCube=function(b){a.Assets.registerAsset(this,b),this.cubeBuffers=[]},a.augment(a.QuickNotation,a.TextureCameraCube),a.augment(a.JSONLoader,a.TextureCameraCube),a.augment(a.Events,a.TextureCameraCube),a.TextureCameraCube.prototype.className="TextureCube",a.TextureCameraCube.prototype.texture=null,a.TextureCameraCube.prototype.glTexture=null,a.TextureCameraCube.prototype.object=null,a.TextureCameraCube.prototype.autoUpdate=!1,a.TextureCameraCube.prototype.rendered=!1,a.TextureCameraCube.prototype.bufferHeight=512,a.TextureCameraCube.prototype.bufferWidth=512,a.TextureCameraCube.prototype.offsetX=0,a.TextureCameraCube.prototype.offsetY=0,a.TextureCameraCube.prototype.offsetZ=0,a.TextureCameraCube.prototype.cameraMatries=[[0,0,-1,0,0,1,0,0,-1,0,0,0,0,0,0,1],[0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,1],[-1,0,0,0,0,0,1,0,0,-1,0,0,0,0,0,1],[-1,0,0,0,0,0,-1,0,0,1,0,0,0,0,0,1],[1,0,0,0,0,1,0,0,0,0,-1,0,0,0,0,1],[-1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]],a.TextureCameraCube.prototype.pMatrix=a.makePerspective(90,1,1e-4,1e3),a.TextureCameraCube.prototype.render=function(){this.rendered=!1;return this},a.TextureCameraCube.prototype.setOffsetX=function(a){this.offsetX=a;return this},a.TextureCameraCube.prototype.getOffsetX=function(){return this.offsetX},a.TextureCameraCube.prototype.setOffsetY=function(a){this.offsetY=a;return this},a.TextureCameraCube.prototype.getOffsetY=function(){return this.offsetY},a.TextureCameraCube.prototype.setOffsetZ=function(a){this.offsetZ=a;return this},a.TextureCameraCube.prototype.getOffsetZ=function(){return this.offsetZ},a.TextureCameraCube.prototype.setAutoUpdate=function(a){this.autoUpdate=a;return this},a.TextureCameraCube.prototype.getAutoUpdate=function(){return this.autoUpdate},a.TextureCameraCube.prototype.setBufferWidth=function(a){this.bufferWidth=a,this.update=!0;return this},a.TextureCameraCube.prototype.getBufferWidth=function(){return this.bufferWidth},a.TextureCameraCube.prototype.setBufferHeight=function(a){this.bufferHeight=a,this.update=!0;return this},a.TextureCameraCube.prototype.getBufferHeight=function(){return this.bufferHeight},a.TextureCameraCube.prototype.doTexture=function(b,c){this.gl=b;var d=c.getModelMatrix(),e=this.bufferHeight,f=this.bufferWidth;if(!this.cubeBuffers.length||this.update){this.createFrameBuffers(b),this.update=!1;return!1}b.bindTexture(b.TEXTURE_CUBE_MAP,this.glTexture);if(!this.rendered||this.autoUpdate){for(var g=0;g<6;g++){var h=this.cameraMatries[g].slice(0),i=a.mulMat4(h,d),j=a.mulMat4Vec3(i,[this.offsetX,this.offsetY,this.offsetZ,1]);h[3]=-j[0],h[7]=-j[1],h[11]=-j[2],b.scene.addRenderPass(this.cubeBuffers[g],h,this.pMatrix,f,e,c,!0)}this.rendered=!0}return!0},a.TextureCameraCube.prototype.registerPasses=a.TextureCameraCube.prototype.doTexture,a.TextureCameraCube.prototype.createFrameBuffers=function(a){var b=this.bufferHeight,c=this.bufferWidth,d=a.createRenderbuffer();this.glTexture=a.createTexture(),a.bindTexture(a.TEXTURE_CUBE_MAP,this.glTexture),a.bindRenderbuffer(a.RENDERBUFFER,d),a.renderbufferStorage(a.RENDERBUFFER,a.DEPTH_COMPONENT16,c,b),a.texImage2D(a.TEXTURE_CUBE_MAP_POSITIVE_X,0,a.RGBA,c,b,0,a.RGBA,a.UNSIGNED_BYTE,null),a.texImage2D(a.TEXTURE_CUBE_MAP_NEGATIVE_X,0,a.RGBA,c,b,0,a.RGBA,a.UNSIGNED_BYTE,null),a.texImage2D(a.TEXTURE_CUBE_MAP_POSITIVE_Y,0,a.RGBA,c,b,0,a.RGBA,a.UNSIGNED_BYTE,null),a.texImage2D(a.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,a.RGBA,c,b,0,a.RGBA,a.UNSIGNED_BYTE,null),a.texImage2D(a.TEXTURE_CUBE_MAP_POSITIVE_Z,0,a.RGBA,c,b,0,a.RGBA,a.UNSIGNED_BYTE,null),a.texImage2D(a.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,a.RGBA,c,b,0,a.RGBA,a.UNSIGNED_BYTE,null),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_MAG_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_MIN_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE);var e;e=a.createFramebuffer(),a.bindFramebuffer(a.FRAMEBUFFER,e),a.framebufferRenderbuffer(a.FRAMEBUFFER,a.DEPTH_ATTACHMENT,a.RENDERBUFFER,d),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_CUBE_MAP_NEGATIVE_X,this.glTexture,0),this.cubeBuffers.push(e),e=a.createFramebuffer(),a.bindFramebuffer(a.FRAMEBUFFER,e),a.framebufferRenderbuffer(a.FRAMEBUFFER,a.DEPTH_ATTACHMENT,a.RENDERBUFFER,d),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_CUBE_MAP_POSITIVE_X,this.glTexture,0),this.cubeBuffers.push(e),e=a.createFramebuffer(),a.bindFramebuffer(a.FRAMEBUFFER,e),a.framebufferRenderbuffer(a.FRAMEBUFFER,a.DEPTH_ATTACHMENT,a.RENDERBUFFER,d),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_CUBE_MAP_NEGATIVE_Y,this.glTexture,0),this.cubeBuffers.push(e),e=a.createFramebuffer(),a.bindFramebuffer(a.FRAMEBUFFER,e),a.framebufferRenderbuffer(a.FRAMEBUFFER,a.DEPTH_ATTACHMENT,a.RENDERBUFFER,d),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_CUBE_MAP_POSITIVE_Y,this.glTexture,0),this.cubeBuffers.push(e),e=a.createFramebuffer(),a.bindFramebuffer(a.FRAMEBUFFER,e),a.framebufferRenderbuffer(a.FRAMEBUFFER,a.DEPTH_ATTACHMENT,a.RENDERBUFFER,d),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_CUBE_MAP_NEGATIVE_Z,this.glTexture,0),this.cubeBuffers.push(e),e=a.createFramebuffer(),a.bindFramebuffer(a.FRAMEBUFFER,e),a.framebufferRenderbuffer(a.FRAMEBUFFER,a.DEPTH_ATTACHMENT,a.RENDERBUFFER,d),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_CUBE_MAP_POSITIVE_Z,this.glTexture,0),this.cubeBuffers.push(e),a.bindRenderbuffer(a.RENDERBUFFER,null),a.bindFramebuffer(a.FRAMEBUFFER,null),a.bindTexture(a.TEXTURE_CUBE_MAP,null)}}(GLGE),function(a){a.TextureCanvas=function(b){this.canvas=document.createElement("canvas"),this.t=document.createElement("canvas"),this.t.width=1,this.t.height=1,a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.TextureCanvas),a.augment(a.JSONLoader,a.TextureCanvas),a.augment(a.Events,a.TextureCanvas),a.TextureCanvas.prototype.className="TextureCanvas",a.TextureCanvas.prototype.glTexture=null,a.TextureCanvas.prototype.autoUpdate=!0,a.TextureCanvas.prototype.getAutoUpdate=function(){return this.autoUpdate},a.TextureCanvas.prototype.setAutoUpdate=function(a){this.autoUpdate=a;return this},a.TextureCanvas.prototype.getCanvas=function(){return this.canvas},a.TextureCanvas.prototype.setCanvas=function(a){this.canvas=a;return this},a.TextureCanvas.prototype.setHeight=function(a){this.canvas.height=a;return this},a.TextureCanvas.prototype.setWidth=function(a){this.canvas.width=a;return this},a.TextureCanvas.prototype.getHeight=function(){return this.canvas.height},a.TextureCanvas.prototype.getWidth=function(){return this.canvas.width},a.TextureCanvas.prototype.doTexture=function(a){this.gl=a,this.glTexture?(a.bindTexture(a.TEXTURE_2D,this.glTexture),(this.autoUpdate||this.doUpdate)&&this.updateCanvas(a)):(this.glTexture=a.createTexture(),a.bindTexture(a.TEXTURE_2D,this.glTexture),this.updateCanvas(a)),this.doUpdate=!1;return!0},a.TextureCanvas.prototype.update=function(){this.doUpdate=!0},a.TextureCanvas.prototype.updateCanvas=function(a){var b=this.canvas;a.bindTexture(a.TEXTURE_2D,this.glTexture),a.texImage2D(a.TEXTURE_2D,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,this.t),a.texImage2D(a.TEXTURE_2D,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,b),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.LINEAR),a.generateMipmap(a.TEXTURE_2D)}}(GLGE),function(a){a.TextureCube=function(b){a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.TextureCube),a.augment(a.JSONLoader,a.TextureCube),a.augment(a.Events,a.TextureCube),a.TextureCube.prototype.className="TextureCube",a.TextureCube.prototype.posX=null,a.TextureCube.prototype.negX=null,a.TextureCube.prototype.posY=null,a.TextureCube.prototype.negY=null,a.TextureCube.prototype.posZ=null,a.TextureCube.prototype.negZ=null,a.TextureCube.prototype.texture=null,a.TextureCube.prototype.glTexture=null,a.TextureCube.prototype.loadState=0,a.TextureCube.prototype.setSrc=function(a,b,c){this.url=a,this.state=0,this[b]=new Image;var d=this;this[b].onload=function(){d.loadState+=c},this[b].src=a,this.glTexture&&this.gl&&(this.gl.deleteTexture(this.glTexture),this.glTexture=null);return this},a.TextureCube.prototype.setSrcPosX=function(a){this.setSrc(a,"posX",1);return this},a.TextureCube.prototype.setSrcNegX=function(a){this.setSrc(a,"negX",2);return this},a.TextureCube.prototype.setSrcPosY=function(a){this.setSrc(a,"posY",4);return this},a.TextureCube.prototype.setSrcNegY=function(a){typeof a!="string"?(this.negY=a,this.loadState+=8):this.setSrc(a,"negY",8);return this},a.TextureCube.prototype.setSrcPosZ=function(a){this.setSrc(a,"posZ",16);return this},a.TextureCube.prototype.setSrcNegZ=function(a){this.setSrc(a,"negZ",32);return this},a.TextureCube.prototype.doTexture=function(a,b){this.gl=a,this.glTexture||(this.glTexture=a.createTexture()),a.bindTexture(a.TEXTURE_CUBE_MAP,this.glTexture),this.loadState==63&&this.state==0&&(a.texImage2D(a.TEXTURE_CUBE_MAP_POSITIVE_X,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,this.posX),a.texImage2D(a.TEXTURE_CUBE_MAP_NEGATIVE_X,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,this.negX),a.texImage2D(a.TEXTURE_CUBE_MAP_POSITIVE_Y,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,this.posY),a.texImage2D(a.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,this.negY),a.texImage2D(a.TEXTURE_CUBE_MAP_POSITIVE_Z,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,this.posZ),a.texImage2D(a.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,this.negZ),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_MAG_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_MIN_FILTER,a.LINEAR_MIPMAP_LINEAR),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_CUBE_MAP,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE),a.generateMipmap(a.TEXTURE_CUBE_MAP),a.bindTexture(a.TEXTURE_CUBE_MAP,null),this.state=1),a.bindTexture(a.TEXTURE_CUBE_MAP,this.glTexture);return this.state==1?!0:!1}}(GLGE),function(a){a.TextureVideo=function(b){this.video=document.createElement("video"),this.video.style.display="none",this.video.setAttribute("loop","loop"),this.video.autoplay=!0,this.video.addEventListener("ended",function(){this.play()},!0),document.getElementsByTagName("body")[0].appendChild(this.video),this.canvas=document.createElement("canvas"),this.ctx=this.canvas.getContext("2d"),a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.TextureVideo),a.augment(a.JSONLoader,a.TextureVideo),a.augment(a.Events,a.TextureVideo),a.TextureVideo.prototype.className="TextureVideo",a.TextureVideo.prototype.glTexture=null,a.TextureVideo.prototype.getVideo=function(){return this.video},a.TextureVideo.prototype.setVideo=function(a){this.video=a;return this},a.TextureVideo.prototype.setSrc=function(a){this.video.src=a;return this},a.TextureVideo.prototype.getSrc=function(a){return this.video.src},a.TextureVideo.prototype.doTexture=function(a){this.gl=a,this.glTexture?(a.bindTexture(a.TEXTURE_2D,this.glTexture),this.updateTexture(a)):(this.glTexture=a.createTexture(),a.bindTexture(a.TEXTURE_2D,this.glTexture),this.updateTexture(a));return!0},a.TextureVideo.prototype.updateTexture=function(a){var b=this.video;a.bindTexture(a.TEXTURE_2D,this.glTexture);if(b.readyState>0){b.height<=0&&(b.style.display="",b.height=b.offsetHeight,b.width=b.offsetWidth,b.style.display="none"),this.canvas.height=b.height,this.canvas.width=b.width,this.ctx.drawImage(b,0,0);try{a.texImage2D(a.TEXTURE_2D,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,this.canvas)}catch(c){a.texImage2D(a.TEXTURE_2D,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,this.canvas,null)}a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.LINEAR),a.generateMipmap(a.TEXTURE_2D)}}}(GLGE),function(a){a.ObjectLod=function(b){this.setMaterial(a.DEFAULT_MATERIAL),a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.ObjectLod),a.augment(a.JSONLoader,a.ObjectLod),a.augment(a.Events,a.ObjectLod),a.ObjectLod.prototype.mesh=null,a.ObjectLod.prototype.className="ObjectLod",a.ObjectLod.prototype.material=null,a.ObjectLod.prototype.program=null,a.ObjectLod.prototype.GLShaderProgramPick=null,a.ObjectLod.prototype.GLShaderProgramShadow=null,a.ObjectLod.prototype.GLShaderProgram=null,a.ObjectLod.prototype.pixelSize=0,a.ObjectLod.prototype.setMesh=function(b){typeof b=="string"&&(b=a.Assets.get(b)),this.mesh&&(this.mesh.removeEventListener("shaderupdate",this.meshupdated),this.mesh.removeEventListener("boundupdate",this.boundupdated));var c=this;this.meshupdated=function(a){c.GLShaderProgram=null},this.boundupdated=function(a){c.fireEvent("boundupdate",{})},b.addEventListener("shaderupdate",this.meshupdated),b.addEventListener("boundupdate",this.boundupdated),this.GLShaderProgram=null,this.mesh=b;return this},a.ObjectLod.prototype.isComplete=function(){return this.material.isComplete()},a.ObjectLod.prototype.getMesh=function(){return this.mesh},a.ObjectLod.prototype.setMaterial=function(b){typeof b=="string"&&(b=a.Assets.get(b)),this.material&&(this.material.removeEventListener("shaderupdate",this.materialupdated),this.material.removeEventListener("downloadComplete",this.downloadComplete));var c=this;this.materialupdated=function(a){c.GLShaderProgram=null},b.addEventListener("shaderupdate",this.materialupdated),this.downloadComplete=function(){c.fireEvent("downloadComplete")},b.addEventListener("downloadComplete",this.downloadComplete),this.GLShaderProgram=null,this.material=b;return this},a.ObjectLod.prototype.getMaterial=function(){return this.material},a.ObjectLod.prototype.getPixelSize=function(){return this.pixelSize},a.ObjectLod.prototype.setPixelSize=function(a){this.pixelSize=parseFloat(a)}}(GLGE),function(a){a.Object=function(b){this.multimaterials=[],this.renderCaches=[];var c=this;this.downloadComplete=function(){c.isComplete()&&c.fireEvent("downloadComplete")},a.Assets.registerAsset(this,b)},a.augment(a.Placeable,a.Object),a.augment(a.Animatable,a.Object),a.augment(a.QuickNotation,a.Object),a.augment(a.JSONLoader,a.Object),a.Object.prototype.className="Object",a.Object.prototype.mesh=null,a.Object.prototype.skeleton=null,a.Object.prototype.scene=null,a.Object.prototype.transformMatrix=a.identMatrix(),a.Object.prototype.material=null,a.Object.prototype.gl=null,a.Object.prototype.multimaterials=null,a.Object.prototype.zTrans=!1,a.Object.prototype.renderCaches=null,a.Object.prototype.id="",a.Object.prototype.pickable=!0,a.Object.prototype.drawType=a.DRAW_TRIS,a.Object.prototype.pointSize=1,a.Object.prototype.lineWidth=1,a.Object.prototype.cull=!0,a.Object.prototype.culled=!0,a.Object.prototype.visible=!0,a.Object.prototype.depthTest=!0,a.Object.prototype.meshFrame1=0,a.Object.prototype.meshFrame2=0,a.Object.prototype.meshBlendFactor=0,a.Object.prototype.noCastShadows=null,a.Object.prototype.noDepthMask=!1,a.Object.prototype.shadowAlpha=!0,a.Object.prototype.blending=["SRC_ALPHA","ONE_MINUS_SRC_ALPHA"];var b=[];b.push("#ifdef GL_ES\nprecision highp float;\n#endif\n"),b.push("uniform float distance;\n"),b.push("uniform bool shadowtype;\n"),b.push("varying vec3 eyevec;\n"),b.push("void main(void)\n  "),b.push("{\n"),b.push("float depth = gl_FragCoord.z;\n"),b.push("if(shadowtype) depth=length(eyevec)/distance;\n"),b.push("vec4 rgba=fract(depth * vec4(16777216.0, 65536.0, 256.0, 1.0));\n"),b.push("gl_FragColor=rgba-rgba.rrgb*vec4(0.0,0.00390625,0.00390625,0.00390625);\n"),b.push("}\n"),a.Object.prototype.shfragStr=b.join("");var c=[];c.push("#ifdef GL_ES\nprecision highp float;\n#endif\n"),c.push("varying vec3 n;\n"),c.push("void main(void)\n"),c.push("{\n"),c.push("float depth = gl_FragCoord.z / gl_FragCoord.w;\n"),c.push("gl_FragColor=vec4(normalize(n)/2.0+0.5,depth/1000.0);\n"),c.push("}\n"),a.Object.prototype.nfragStr=c.join("");var d=[];d.push("#ifdef GL_ES\nprecision highp float;\n#endif\n"),d.push("uniform float far;\n"),d.push("uniform vec3 pickcolor;\n"),d.push("varying vec3 n;\n"),d.push("varying vec4 UVCoord;\n"),d.push("void main(void)\n"),d.push("{\n"),d.push("float Xcoord = gl_FragCoord.x+0.5;\n"),d.push("if(Xcoord>0.0) gl_FragColor = vec4(pickcolor,1.0);\n"),d.push("if(Xcoord>1.0) gl_FragColor = vec4(n,1.0);\n"),d.push("if(Xcoord>2.0){"),d.push("vec3 rgb=fract((gl_FragCoord.z/gl_FragCoord.w) * vec3(65536.0, 256.0, 1.0));\n"),d.push("gl_FragColor=vec4(rgb-rgb.rrg*vec3(0.0,0.00390625,0.00390625),1.0);\n"),d.push("}"),d.push("if(Xcoord>3.0){"),d.push("vec3 rgb=fract(UVCoord.x * vec3(65536.0, 256.0, 1.0));\n"),d.push("gl_FragColor=vec4(rgb-rgb.rrg*vec3(0.0,0.00390625,0.00390625),1.0);\n"),d.push("}"),d.push("if(Xcoord>4.0){"),d.push("vec3 rgb=fract(UVCoord.y * vec3(65536.0, 256.0, 1.0));\n"),d.push("gl_FragColor=vec4(rgb-rgb.rrg*vec3(0.0,0.00390625,0.00390625),1.0);\n"),d.push("}"),d.push("}\n"),a.Object.prototype.pkfragStr=d.join(""),a.Object.prototype.noDepthMask,a.Object.prototype.setDepthMask=function(a){this.noDepthMask=!a;return this},a.Object.prototype.getDepthMask=function(){return!this.noDepthMask},a.Object.prototype.setVisible=function(a){this.visible=a;return this},a.Object.prototype.getVisible=function(){return this.visible},a.Object.prototype.setBlending=function(a){this.blending=a;return this},a.Object.prototype.getBlending=function(){return this.blending},a.Object.prototype.setMeshFrame1=function(a){this.meshFrame1=a;return this},a.Object.prototype.setMeshFrame2=function(a){this.meshFrame2=a;return this},a.Object.prototype.setMeshBlendFactor=function(a){this.meshBlendFactor=a;return this},a.Object.prototype.getMeshBlendFactor=function(){return this.meshBlendFactor},a.Object.prototype.getPickable=function(){return this.pickable},a.Object.prototype.setPickable=function(a){this.pickable=a;return this},a.Object.prototype.getDepthTest=function(){return this.depthTest},a.Object.prototype.setDepthTest=function(a){this.depthTest=a;return this},a.Object.prototype.getCull=function(){return this.cull},a.Object.prototype.setCull=function(a){this.cull=a;return this},a.Object.prototype.getDrawType=function(){return this.drawType},a.Object.prototype.setDrawType=function(a){this.drawType=a;return this},a.Object.prototype.getPointSize=function(){return this.pointSize},a.Object.prototype.setPointSize=function(a){this.pointSize=parseFloat(a);return this},a.Object.prototype.getLineWidth=function(){return this.lineWidth},a.Object.prototype.setLineWidth=function(a){this.lineWidth=parseFloat(a);return this},a.Object.prototype.setUniform=function(a,b,c){this.uniforms||(this.uniforms={}),this.uniforms[b]={type:a,value:c}},a.Object.prototype.getUniform=function(a){this.uniforms||(this.uniforms={});return this.uniforms[a].value},a.Object.prototype.getUniformType=function(a){this.uniforms||(this.uniforms={});return this.uniforms[a].type},a.Object.prototype.setVertexShaderInjection=function(a){this.shaderVertexInjection=a,this.updateProgram();return this},a.Object.prototype.getVertexShaderInjection=function(a){return this.shaderVertexInjection},a.Object.prototype.getSkeleton=function(){return this.skeleton},a.Object.prototype.setSkeleton=function(a){this.skeleton=a,this.bones=null;return this},a.Object.prototype.getBoundingVolume=function(b){b||(b=0),this.boundingVolume||(this.boundingVolume=[]),this.boundmatrix||(this.boundmatrix=[]);var c=this.getModelMatrix();if(c!=this.boundmatrix[b]||!this.boundingVolume[b]){var d=this.multimaterials,e;for(var f=0;f<d.length;f++)d[f].lods[0].mesh&&(e?e.addBoundingVolume(d[f].lods[0].mesh.getBoundingVolume()):e=d[f].lods[0].mesh.getBoundingVolume().clone());e||(e=new a.BoundingVolume(0,0,0,0,0,0)),b?e.applyMatrix(this.getLocalMatrix()):e.applyMatrix(this.getModelMatrix()),this.boundingVolume[b]=e}this.boundmatrix[b]=c;return this.boundingVolume[b]},a.Object.prototype.setCastShadows=function(a){this.noCastShadows=!a;return this},a.Object.prototype.getCastShadows=function(){return!this.noCastShadows},a.Object.prototype.setZtransparent=function(a){this.zTrans=a;return this},a.Object.prototype.isZtransparent=function(){return this.zTrans},a.Object.prototype.isComplete=function(){for(var a=0;a<this.multimaterials.length;a++)if(!this.multimaterials[a].isComplete())return!1;return!0},a.Object.prototype.setMaterial=function(b,c){typeof b=="string"&&(b=a.Assets.get(b)),c||(c=0),this.multimaterials[c]||(this.multimaterials[c]=new a.MultiMaterial,this.multimaterials[c].addEventListener("downloadComplete",this.downloadComplete)),this.multimaterials[c].getMaterial()!=b&&(this.multimaterials[c].setMaterial(b),this.updateProgram());return this},a.Object.prototype.getMaterial=function(a){a||(a=0);return this.multimaterials[a]?this.multimaterials[a].getMaterial():!1},a.Object.prototype.setMesh=function(b,c){typeof b=="string"&&(b=a.Assets.get(b)),c||(c=0);if(!this.multimaterials[c]){var d=this;this.multimaterials[c]=new a.MultiMaterial,this.multimaterials[c].addEventListener("downloadComplete",this.downloadComplete),this.multimaterials[c].addEventListener("boundupdate",function(){d.boundingVolume=null})}this.multimaterials[c].setMesh(b),this.boundingVolume=null;return this},a.Object.prototype.getMesh=function(a){a||(a=0);return this.multimaterials[a]?this.multimaterials[a].getMesh():!1},a.Object.prototype.GLInit=function(a){this.gl=a},a.Object.prototype.GLDestory=function(a){},a.Object.prototype.updateProgram=function(){for(var a=0;a<this.multimaterials.length;a++)this.multimaterials[a].updateProgram()},a.Object.prototype.addMultiMaterial=function(b){typeof b=="string"&&(b=a.Assets.get(b)),this.multimaterials.push(b),b.addEventListener("downloadComplete",this.downloadComplete);var c=this;b.addEventListener("boundupdate",function(){c.boundingVolume=null}),this.boundingVolume=null;return this},a.Object.prototype.getMultiMaterials=function(){return this.multimaterials},a.Object.prototype.GLGenerateShader=function(c){var d=UV=joints1=joints2=!1,e=c.lights,f=["#ifdef GL_ES\nprecision highp float;\n#endif\n#define GLGE_VERTEX\n"],g=!1;this.mesh.normals||this.mesh.calcNormals(),f.push("attribute vec3 position;\n"),f.push("attribute vec3 normal;\n");for(var h=0;h<this.mesh.buffers.length;h++){this.mesh.buffers[h].name=="tangent0"&&(g=!0);if(this.mesh.buffers[h].exclude)continue;this.mesh.buffers[h].size>1?f.push("attribute vec"+this.mesh.buffers[h].size+" "+this.mesh.buffers[h].name+";\n"):f.push("attribute float "+this.mesh.buffers[h].name+";\n"),this.mesh.buffers[h].name=="UV"&&(UV=!0),this.mesh.buffers[h].name=="color"&&(d=!0),this.mesh.buffers[h].name=="joints1"&&(joints1=this.mesh.buffers[h]),this.mesh.buffers[h].name=="joints2"&&(joints2=this.mesh.buffers[h])}if(this.mesh.framePositions.length>1){var i=!0;f.push("attribute vec3 position2;\n"),f.push("attribute vec3 normal2;\n"),f.push("uniform float framesBlend;\n"),g&&f.push("attribute vec3 tangent2;\n")}g&&f.push("attribute vec3 tangent;\n"),f.push("uniform mat4 worldView;\n"),f.push("uniform mat4 projection;\n"),f.push("uniform mat4 worldInverseTranspose;\n"),f.push("uniform mat4 envMat;\n"),f.push("uniform float cascadeLevel;\n");for(var h=0;h<e.length;h++){if(e[h].type==a.L_OFF)continue;f.push("uniform vec3 lightpos"+h+";\n"),f.push("uniform vec3 lightdir"+h+";\n"),(e[h].type==a.L_SPOT||e[h].type==a.L_DIR)&&e[h].getCastShadows()&&(f.push("uniform mat4 lightmat"+h+";\n"),f.push("varying vec4 spotcoord"+h+";\n"))}f.push("varying vec3 eyevec;\n");for(var h=0;h<e.length;h++){if(e[h].type==a.L_OFF)continue;f.push("varying vec3 lightvec"+h+";\n"),f.push("varying float lightdist"+h+";\n")}this.mesh.joints&&this.mesh.joints.length>0&&f.push("uniform vec4 jointMat["+3*this.mesh.joints.length+"];\n"),this.material&&f.push(this.material.getVertexVarying(f)),f.push("varying vec3 n;\n"),f.push("varying vec3 t;\n"),d&&f.push("varying vec4 vcolor;\n"),f.push("varying vec4 UVCoord;\n"),f.push("varying vec3 OBJCoord;\n"),this.shaderVertexInjection&&f.push(this.shaderVertexInjection),f.push("void main(void)\n"),f.push("{\n"),d&&f.push("vcolor=color;\n"),UV?f.push("UVCoord=UV;\n"):f.push("UVCoord=vec4(0.0,0.0,0.0,0.0);\n"),f.push("OBJCoord = position;\n"),f.push("vec3 tang;\n"),f.push("vec4 pos = vec4(0.0, 0.0, 0.0, 1.0);\n"),f.push("vec4 norm = vec4(0.0, 0.0, 0.0, 1.0);\n"),g&&f.push("vec4 tang4 = vec4(0.0, 0.0, 0.0, 1.0);\n");if(joints1){if(joints1.size==1)f.push("pos += vec4(dot(jointMat[int(3.0*joints1)],vec4(position,1.0)),\n              dot(jointMat[int(3.0*joints1+1.0)],vec4(position,1.0)),\n              dot(jointMat[int(3.0*joints1+2.0)],vec4(position,1.0)),1.0)*weights1;\n"),f.push("norm += vec4(dot(jointMat[int(3.0*joints1)].xyz,normal),\n               dot(jointMat[int(3.0*joints1+1.0)].xyz,normal),\n               dot(jointMat[int(3.0*joints1+2.0)].xyz,normal),1.0)*weights1;\n"),g&&f.push("tang4 += vec4(dot(jointMat[int(3.0*joints1)].xyz,tangent),\n               dot(jointMat[int(3.0*joints1+1.0)].xyz,tangent),\n               dot(jointMat[int(3.0*joints1+2.0)].xyz,tangent),1.0)*weights1;\n");else for(var h=0;h<joints1.size;h++)f.push("pos += vec4(dot(jointMat[int(3.0*joints1["+h+"])],vec4(position,1.0)),\n              dot(jointMat[int(3.0*joints1["+h+"]+1.0)],vec4(position,1.0)),\n              dot(jointMat[int(3.0*joints1["+h+"]+2.0)],vec4(position,1.0)),1.0)*weights1["+h+"];\n"),f.push("norm += vec4(dot(jointMat[int(3.0*joints1["+h+"])].xyz,normal),\n               dot(jointMat[int(3.0*joints1["+h+"]+1.0)].xyz,normal),\n               dot(jointMat[int(3.0*joints1["+h+"]+2.0)].xyz,normal),1.0)*weights1["+h+"];\n"),g&&f.push("tang4 += vec4(dot(jointMat[int(3.0*joints1["+h+"])].xyz,tangent),\n               dot(jointMat[int(3.0*joints1["+h+"]+1.0)].xyz,tangent),\n               dot(jointMat[int(3.0*joints1["+h+"]+2.0)].xyz,tangent),1.0)*weights1["+h+"];\n");if(joints2)if(joints2.size==1)f.push("pos += vec4(dot(jointMat[int(3.0*joints2)],vec4(position,1.0)),\n              dot(jointMat[int(3.0*joints2+1.0)],vec4(position,1.0)),\n              dot(jointMat[int(3.0*joints2+2.0)],vec4(position,1.0)),1.0)*weights2;\n"),f.push("norm += vec4(dot(jointMat[int(3.0*joints2)].xyz,normal),\n               dot(jointMat[int(3.0*joints2+1.0)].xyz,normal),\n               dot(jointMat[int(3.0*joints2+2.0)].xyz,normal),1.0)*weights2;\n"),g&&f.push("tang4 += vec4(dot(jointMat[int(3.0*joints2)].xyz,tangent),\n               dot(jointMat[int(3.0*joints2+1.0)].xyz,tangent),\n               dot(jointMat[int(3.0*joints2+2.0)].xyz,tangent),1.0)*weights2;\n");else for(var h=0;h<joints2.size;h++)f.push("pos += vec4(dot(jointMat[int(3.0*joints2["+h+"])],vec4(position,1.0)),\n              dot(jointMat[int(3.0*joints2["+h+"]+1.0)],vec4(position,1.0)),\n              dot(jointMat[int(3.0*joints2["+h+"]+2.0)],vec4(position,1.0)),1.0)*weights2["+h+"];\n"),f.push("norm += vec4(dot(jointMat[int(3.0*joints2["+h+"])].xyz,normal),\n               dot(jointMat[int(3.0*joints2["+h+"]+1.0)].xyz,normal),\n               dot(jointMat[int(3.0*joints2["+h+"]+2.0)].xyz,normal),1.0)*weights2["+h+"];\n"),g&&f.push("tang4 += vec4(dot(jointMat[int(3.0*joints2["+h+"])].xyz,tangent),\n               dot(jointMat[int(3.0*joints2["+h+"]+1.0)].xyz,tangent),\n               dot(jointMat[int(3.0*joints2["+h+"]+2.0)].xyz,tangent),1.0)*weights2["+h+"];\n");for(var h=0;h<e.length;h++){if(e[h].type==a.L_OFF)continue;(e[h].type==a.L_SPOT||e[h].type==a.L_DIR)&&e[h].getCastShadows()&&f.push("spotcoord"+h+"=lightmat"+h+"*vec4(pos.xyz,1.0);\n")}this.shaderVertexInjection&&this.shaderVertexInjection.indexOf("GLGE_Position")>-1&&f.push("pos=GLGE_Position(vec4(pos.xyz, 1.0));\n"),f.push("pos = worldView * vec4(pos.xyz, 1.0);\n"),f.push("norm = worldInverseTranspose * vec4(norm.xyz, 1.0);\n"),g&&f.push("tang = (worldInverseTranspose*vec4(tang4.xyz,1.0)).xyz;\n")}else{i?f.push("vec4 pos4=vec4(mix(position,position2,framesBlend),1.0);\n"):f.push("vec4 pos4=vec4(position,1.0);\n"),this.shaderVertexInjection&&this.shaderVertexInjection.indexOf("GLGE_Position")>-1&&f.push("pos4=GLGE_Position(pos4);\n");for(var h=0;h<e.length;h++){if(e[h].type==a.L_OFF)continue;(e[h].type==a.L_SPOT||e[h].type==a.L_DIR)&&e[h].getCastShadows()&&f.push("spotcoord"+h+"=lightmat"+h+"*pos4;\n")}f.push("pos = worldView * pos4;\n"),i?(f.push("norm = worldInverseTranspose * vec4(mix(normal,normal2,framesBlend), 1.0);\n"),g&&f.push("tang = (worldInverseTranspose*vec4(mix(tangent,tangent2,framesBlend),1.0)).xyz;\n")):(f.push("norm = worldInverseTranspose * vec4(normal, 1.0);\n"),g&&f.push("tang = (worldInverseTranspose*vec4(tangent,1.0)).xyz;\n"))}f.push("eyevec = -pos.xyz;\n"),g?f.push("t = normalize(tang);"):f.push("t = vec3(0.0,0.0,0.0);"),f.push("n = normalize(norm.rgb);");for(var h=0;h<e.length;h++){if(e[h].type==a.L_OFF)continue;e[h].getType()==a.L_DIR?f.push("lightvec"+h+" = -lightdir"+h+";\n"):f.push("lightvec"+h+" = pos.xyz-lightpos"+h+";\n"),f.push("lightdist"+h+" = length(lightpos"+h+".xyz-pos.xyz);\n")}this.material&&f.push(this.material.getLayerCoords(this.shaderVertexInjection)),f.push("gl_Position = projection * pos;\n"),f.push("gl_PointSize="+this.pointSize.toFixed(5)+";\n"),f.push("}\n"),f=f.join(""),fragStr=this.material.getFragmentShader(e,d,this.shaderVertexInjection,!1),this.shadowAlpha?b=this.material.getFragmentShader(e,d,this.shaderVertexInjection,!0):b=this.shfragStr,this.GLFragmentShaderNormal=a.getGLShader(c,c.FRAGMENT_SHADER,this.nfragStr),this.GLFragmentShaderShadow=a.getGLShader(c,c.FRAGMENT_SHADER,b),this.GLFragmentShaderPick=a.getGLShader(c,c.FRAGMENT_SHADER,this.pkfragStr),this.GLFragmentShader=a.getGLShader(c,c.FRAGMENT_SHADER,fragStr),this.GLVertexShader=a.getGLShader(c,c.VERTEX_SHADER,f+"//default"),this.GLVertexShaderShadow=a.getGLShader(c,c.VERTEX_SHADER,f+"//shadow"),this.GLVertexShaderPick=a.getGLShader(c,c.VERTEX_SHADER,f+"//pick"),this.GLVertexShaderNormal=a.getGLShader(c,c.VERTEX_SHADER,f+"//normal"),this.GLShaderProgramPick=a.getGLProgram(c,this.GLVertexShaderPick,this.GLFragmentShaderPick),this.GLShaderProgramNormal=a.getGLProgram(c,this.GLVertexShaderNormal,this.GLFragmentShaderNormal),this.GLShaderProgramShadow=a.getGLProgram(c,this.GLVertexShaderShadow,this.GLFragmentShaderShadow),this.GLShaderProgram=a.getGLProgram(c,this.GLVertexShaderShadow,this.GLFragmentShader),c.getProgramParameter(this.GLShaderProgram,c.LINK_STATUS)||this.material.fallback&&(this.material=this.material.fallback,this.multimaterial.material=this.material,this.GLGenerateShader(c))},a.Object.prototype.createShaders=function(a){this.gl&&(this.mesh=a.mesh,this.material=a.material,this.multimaterial=a,this.GLGenerateShader(this.gl),a.GLShaderProgramPick=this.GLShaderProgramPick,a.GLShaderProgramShadow=this.GLShaderProgramShadow,a.GLShaderProgram=this.GLShaderProgram)},a.Object.prototype.GLUniforms=function(b,c,d){var e;switch(c){case a.RENDER_DEFAULT:e=this.GLShaderProgram,a.setUniform(b,"1i",a.getUniformLocation(b,e,"emitpass"),0);break;case a.RENDER_EMIT:e=this.GLShaderProgram,a.setUniform(b,"1i",a.getUniformLocation(b,e,"emitpass"),1);break;case a.RENDER_SHADOW:e=this.GLShaderProgramShadow,a.setUniform(b,"1i",a.getUniformLocation(b,e,"shadowtype"),1);break;case a.RENDER_DEPTH:e=this.GLShaderProgramShadow,a.setUniform(b,"1f",a.getUniformLocation(b,e,"cascadeLevel"),2),a.setUniform(b,"1i",a.getUniformLocation(b,e,"shadowtype"),0);break;case a.RENDER_NORMAL:e=this.GLShaderProgramNormal;break;case a.RENDER_PICK:e=this.GLShaderProgramPick;var f=d>>16&255,g=d>>8&255,h=d&255;a.setUniform3(b,"3f",a.getUniformLocation(b,e,"pickcolor"),h/255,g/255,f/255)}b.lineWidth(this.lineWidth);for(var i in this.uniforms){var j=this.uniforms[i];j.type=="Matrix4fv"?a.setUniformMatrix(b,"Matrix4fv",a.getUniformLocation(b,e,i),!1,j.value):a.setUniform(b,j.type,a.getUniformLocation(b,e,i),j.value)}e.caches||(e.caches={}),e.glarrays||(e.glarrays={});var k=e.caches,l=e.glarrays,m=b.scene,n=m.camera;k.far!=n.far&&(a.setUniform(b,"1i",a.getUniformLocation(b,e,"far"),n.far),k.far=n.far);if(c==a.RENDER_DEFAULT||c==a.RENDER_EMIT){if(k.ambientColor!=m.ambientColor){var o=m.ambientColor;a.setUniform3(b,"3f",a.getUniformLocation(b,e,"amb"),o.r,o.g,o.b),k.ambientColor=o}k.fogFar!=m.fogFar&&(a.setUniform(b,"1f",a.getUniformLocation(b,e,"fogfar"),m.fogFar),k.fogFar=m.fogFar),k.fogNear!=m.fogNear&&(a.setUniform(b,"1f",a.getUniformLocation(b,e,"fognear"),m.fogNear),k.fogNear=m.fogNear),k.fogType!=m.fogType&&(a.setUniform(b,"1i",a.getUniformLocation(b,e,"fogtype"),m.fogType),k.fogType=m.fogType),k.fogType!=m.fogcolor&&(a.setUniform3(b,"3f",a.getUniformLocation(b,e,"fogcolor"),m.fogColor.r,m.fogColor.g,m.fogColor.b),k.fogcolor=m.fogcolor)}k.meshBlendFactor!=this.meshBlendFactor&&(a.setUniform(b,"1f",a.getUniformLocation(b,e,"framesBlend"),this.meshBlendFactor),k.meshBlendFactor=this.meshBlendFactor);var p=n.getViewMatrix(),q=I=this.getModelMatrix();k.mvMatrix||(k.mvMatrix={cameraMatrix:null,modelMatrix:null});var r=k.mvMatrix;if(r.cameraMatrix!=p||r.modelMatrix!=I){this.caches.mvMatrix||(this.caches.mvMatrix=a.mulMat4(p,I)),mvMatrix=this.caches.mvMatrix,this.mesh.joints&&(mvMatrix=p);var s=a.getUniformLocation(b,e,"worldView"),t=a.transposeMat4(mvMatrix);l.mvMatrix?a.mat4gl(t,l.mvMatrixT):l.mvMatrixT=new Float32Array(t),l.mvMatrix=mvMatrix,a.setUniformMatrix(b,"Matrix4fv",s,!1,e.glarrays.mvMatrixT);var u=a.getUniformLocation(b,e,"envMat");if(u){if(!this.caches.envMat){var v=a.inverseMat4(p);v[3]=0,v[7]=0,v[11]=0,this.caches.envMat=v}v=this.caches.envMat,t=a.transposeMat4(v),e.glarrays.envMat?a.mat4gl(t,l.envMatT):l.envMatT=new Float32Array(t),l.envMat=v,a.setUniformMatrix(b,"Matrix4fv",u,!1,l.envMatT)}if(!this.caches.normalMatrix){var w=a.inverseMat4(mvMatrix);this.caches.normalMatrix=w}w=this.caches.normalMatrix;var x=a.getUniformLocation(b,e,"worldInverseTranspose");l.normalMatrix?a.mat4gl(w,l.normalMatrix):l.normalMatrix=new Float32Array(w),a.setUniformMatrix(b,"Matrix4fv",x,!1,l.normalMatrix);var y=a.getUniformLocation(b,e,"view");t=a.transposeMat4(p),l.cameraMatrix?a.mat4gl(t,l.cameraMatrixT):l.cameraMatrixT=new Float32Array(t),l.cameraMatrix=p,a.setUniformMatrix(b,"Matrix4fv",y,!1,l.cameraMatrixT),r.cameraMatrix=p,r.modelMatrix=I}var z=a.getUniformLocation(b,e,"projection");t=a.transposeMat4(n.getProjectionMatrix()),l.pMatrix?a.mat4gl(t,l.pMatrixT):l.pMatrixT=new Float32Array(t),l.pMatrix=n.getProjectionMatrix(),a.setUniformMatrix(b,"Matrix4fv",z,!1,l.pMatrixT);if(c==a.RENDER_DEFAULT||c==a.RENDER_SHADOW||c==a.RENDER_DEPTH||c==a.RENDER_EMIT){var A,B,C=b.lights;k.lights||(k.lights=[]),l.lights||(l.lights=[]),this.caches.lights||(this.caches.lights=[]);var D=k.lights;for(var E=0;E<C.length;E++){if(C[E].type==a.L_OFF)continue;D[E]||(D[E]={modelMatrix:null,cameraMatrix:null});if(D[E].modelMatrix!=I||D[E].cameraMatrix!=p){this.caches.lights[E]||(this.caches.lights[E]={}),this.caches.lights[E].pos||(this.caches.lights[E].pos=a.mulMat4Vec4(a.mulMat4(p,C[E].getModelMatrix()),[0,0,0,1])),A=this.caches.lights[E].pos,a.setUniform3(b,"3f",a.getUniformLocation(b,e,"lightpos"+E),A[0],A[1],A[2]),this.caches.lights[E].lpos||(this.caches.lights[E].lpos=a.mulMat4Vec4(a.mulMat4(p,C[E].getModelMatrix()),[0,0,1,1])),B=this.caches.lights[E].lpos,a.setUniform3(b,"3f",a.getUniformLocation(b,e,"lightdir"+E),B[0]-A[0],B[1]-A[1],B[2]-A[2]);if(C[E].s_cache){var F=a.mulMat4(C[E].s_cache.smatrix,I);l.lights[E]?a.mat4gl(F,l.lights[E]):l.lights[E]=new Float32Array(F),a.setUniformMatrix(b,"Matrix4fv",a.getUniformLocation(b,e,"lightmat"+E),!0,l.lights[E]),a.setUniform2(b,"2f",a.getUniformLocation(b,e,"shadowoffset"+E),C[E].s_cache.pmatrix[3],C[E].s_cache.pmatrix[7]),D[E].modelMatrix=I,D[E].cameraMatrix=p}else D[E].modelMatrix=I,D[E].cameraMatrix=p}}}if(this.mesh.joints){k.joints||(k.joints=[]),l.joints||(l.joints=[]),l.jointsT||(l.jointsT=[]),l.jointsinv||(l.jointsinv=[]);if(!l.jointsCombined||l.jointsCombined.length!=this.mesh.joints.length*12)l.jointsCombined=new Float32Array(this.mesh.joints.length*12);var G=k.joints,H=a.identMatrix();for(E=0;E<this.mesh.joints.length;E++){G[E]||(G[E]={modelMatrix:null,invBind:null});if(typeof this.mesh.joints[E]=="string"){this.bones||(this.bones=this.skeleton.getNames());if(this.bones)var I=this.bones[this.mesh.joints[E]].getModelMatrix()}else var I=this.mesh.joints[E].getModelMatrix();var J=this.mesh.invBind[E];if(G[E].modelMatrix!=I||G[E].invBind!=J){var K=a.mulMat4(I,J);l.joints[E]?a.mat4gl(a.transposeMat4(K),l.jointsT[E]):l.jointsT[E]=new Float32Array(a.transposeMat4(K)),l.joints[E]=K,l.jointsinv[E]?a.mat4gl(a.inverseMat4(K),l.jointsinv[E]):l.jointsinv[E]=new Float32Array(a.inverseMat4(K));var L=l.jointsT[E],M=l.jointsCombined;M[E*12]=L[0],M[E*12+1]=L[4],M[E*12+2]=L[8],M[E*12+3]=L[12],M[E*12+4]=L[1],M[E*12+5]=L[5],M[E*12+6]=L[9],M[E*12+7]=L[13],M[E*12+8]=L[2],M[E*12+9]=L[6],M[E*12+10]=L[10],M[E*12+11]=L[14],G[E].modelMatrix=I,G[E].invBind=J}}b.uniform4fv(a.getUniformLocation(b,e,"jointMat"),l.jointsCombined)}this.material&&(c==a.RENDER_DEFAULT||c==a.RENDER_EMIT||this.shadowAlpha)&&b.scene.lastMaterial!=this.material&&(this.material.textureUniforms(b,e,C,this,c),b.scene.lastMaterial=this.material)},a.Object.prototype.GLRender=function(b,c,d,e,f){if(b){this.gl||this.GLInit(b),this.lookAt&&this.Lookat(this.lookAt),c==a.RENDER_DEFAULT&&(this.animation&&this.animate()),this.renderCaches[c]||(this.renderCaches[c]={});var g=b.scene.camera.getViewMatrix(),h=this.getModelMatrix();if(this.renderCaches[c].cameraMatrix!=g||this.renderCaches[c].modelMatrix!=h)this.renderCaches[c]={},this.renderCaches[c].cameraMatrix=g,this.renderCaches[c].modelMatrix=h;this.caches=this.renderCaches[c];var i;if(e==undefined)var j=0,k=this.multimaterials.length;else var j=e,k=e+1;for(var l=j;l<k;l++){if(this.multimaterials[l].lods.length>1&&!i){var m=b.scene.camera.getPosition(),n=this.getPosition(),o=a.lengthVec3([m.x-n.x,m.y-n.y,m.z-n.z]);o=a.mulMat4Vec4(b.scene.camera.getProjectionMatrix(),[this.getBoundingVolume().getSphereRadius(),0,-o,1]),i=o[0]/o[3]*b.scene.renderer.canvas.width}var p=this.multimaterials[l].getLOD(i);if(p.mesh&&p.mesh.loaded){if(c==a.RENDER_NULL){p.material&&p.material.registerPasses(b,this);break}p.GLShaderProgram?(this.GLShaderProgramPick=p.GLShaderProgramPick,this.GLShaderProgramShadow=p.GLShaderProgramShadow,this.GLShaderProgram=p.GLShaderProgram):this.createShaders(p),this.mesh=p.mesh,this.material=p.material;var q;switch(this.drawType){case a.DRAW_LINES:q=b.LINES;break;case a.DRAW_POINTS:q=b.POINTS;break;case a.DRAW_LINELOOPS:q=b.LINE_LOOP;break;case a.DRAW_LINESTRIPS:q=b.LINE_STRIP;break;case a.DRAW_TRIANGLESTRIP:q=b.TRIANGLE_STRIP;break;default:q=b.TRIANGLES}switch(c){case a.RENDER_DEFAULT:case a.RENDER_EMIT:b.program!=this.GLShaderProgram&&(b.useProgram(this.GLShaderProgram),b.program=this.GLShaderProgram),this.mesh.GLAttributes(b,this.GLShaderProgram,this.meshFrame1,this.meshFrame2);break;case a.RENDER_SHADOW:case a.RENDER_DEPTH:b.program!=this.GLShaderProgramShadow&&(b.useProgram(this.GLShaderProgramShadow,this.meshFrame1,this.meshFrame2),b.program=this.GLShaderProgramShadow),f||(f=b.scene.camera.getFar()),a.setUniform(b,"1f",a.getUniformLocation(b,this.GLShaderProgramShadow,"distance"),f),this.mesh.GLAttributes(b,this.GLShaderProgramShadow,this.meshFrame1,this.meshFrame2);break;case a.RENDER_NORMAL:b.program!=this.GLShaderProgramNormal&&(b.useProgram(this.GLShaderProgramNormal),b.program=this.GLShaderProgramNormal),this.mesh.GLAttributes(b,this.GLShaderProgramNormal,this.meshFrame1,this.meshFrame2);break;case a.RENDER_PICK:b.program!=this.GLShaderProgramPick&&(b.useProgram(this.GLShaderProgramPick),b.program=this.GLShaderProgramPick),this.mesh.GLAttributes(b,this.GLShaderProgramPick,this.meshFrame1,this.meshFrame2),q=b.TRIANGLES}this.GLUniforms(b,c,d);switch(this.mesh.windingOrder){case a.Mesh.WINDING_ORDER_UNKNOWN:b.scene.renderer.cullFaces?(b.cullFace(b.scene.mirror?b.FRONT:b.BACK),b.enable(b.CULL_FACE)):b.disable(b.CULL_FACE);break;case a.Mesh.WINDING_ORDER_CLOCKWISE:b.cullFace(b.scene.mirror?b.FRONT:b.BACK),b.enable(b.CULL_FACE);break;case a.Mesh.WINDING_ORDER_COUNTER:b.cullFace(b.scene.mirror?b.BACK:b.FRONT),b.enable(b.CULL_FACE);default:}c==a.RENDER_PICK&&b.disable(b.CULL_FACE),this.noDepthMask&&b.depthMask(!1),this.mesh.GLfaces?(b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,this.mesh.GLfaces),b.drawElements(q,this.mesh.GLfaces.numItems,b.UNSIGNED_SHORT,0)):b.drawArrays(q,0,this.mesh.positions.length/3),b.depthMask(!0);switch(this.mesh.windingOrder){case a.Mesh.WINDING_ORDER_UNKNOWN:b.scene.renderer.cullFaces&&b.enable(b.CULL_FACE);break;case a.Mesh.WINDING_ORDER_COUNTER:b.cullFace(b.BACK);default:}var r=this.matrix,s=this.caches;this.matrix=r,this.caches=s}}}}}(GLGE),function(a){a.Text=function(b){this.canvas=document.createElement("canvas"),this.scaleCanvas=document.createElement("canvas"),this.color={r:1,g:1,b:1},a.Assets.registerAsset(this,b)},a.augment(a.Placeable,a.Text),a.augment(a.Animatable,a.Text),a.augment(a.QuickNotation,a.Text),a.augment(a.JSONLoader,a.Text),a.Text.prototype.className="Text",a.Text.prototype.zTrans=!0,a.Text.prototype.canvas=null,a.Text.prototype.aspect=1,a.Text.prototype.color=null,a.Text.prototype.text="",a.Text.prototype.font="Times",a.Text.prototype.size=100,a.Text.prototype.pickType=a.TEXT_TEXTPICK,a.Text.prototype.pickable=!0,a.Text.prototype.alpha=1,a.Text.prototype.dirty=!0,a.Text.prototype.getPickType=function(){return this.pickType},a.Text.prototype.setPickType=function(a){this.pickType=a;return this},a.Text.prototype.getFont=function(){return this.size},a.Text.prototype.setFont=function(a){this.font=a,this.dirty=!0;return this},a.Text.prototype.getSize=function(){return this.size},a.Text.prototype.setSize=function(a){this.size=a,this.dirty=!0;return this},a.Text.prototype.getText=function(){return this.text},a.Text.prototype.setText=function(a){this.text=a,this.dirty=!0;return this},a.Text.prototype.setColor=function(b){b=a.colorParse(b),this.color={r:b.r,g:b.g,b:b.b};return this},a.Text.prototype.setColorR=function(a){this.color.r=a;return this},a.Text.prototype.setColorG=function(a){this.color.g=a;return this},a.Text.prototype.setColorB=function(a){this.color.b=a;return this},a.Text.prototype.getColor=function(){return this.color},a.Text.prototype.setAlpha=function(a){this.alpha=a;return this},a.Text.prototype.getAlpha=function(){return this.alpha},a.Text.prototype.setZtransparent=function(a){this.zTrans=a;return this},a.Text.prototype.isZtransparent=function(){return this.zTrans},a.Text.prototype.GLGenerateShader=function(b){this.GLShaderProgram&&b.deleteProgram(this.GLShaderProgram);var c="";c+="attribute vec3 position;\n",c+="attribute vec2 uvcoord;\n",c+="varying vec2 texcoord;\n",c+="uniform mat4 Matrix;\n",c+="uniform mat4 PMatrix;\n",c+="varying vec4 pos;\n",c+="void main(void){\n",c+="texcoord=uvcoord;\n",c+="pos = Matrix * vec4(position,1.0);\n",c+="gl_Position = PMatrix * pos;\n",c+="}\n";var d="#ifdef GL_ES\nprecision highp float;\n#endif\n";d=d+"uniform sampler2D TEXTURE;\n",d=d+"varying vec2 texcoord;\n",d=d+"uniform mat4 Matrix;\n",d=d+"varying vec4 pos;\n",d=d+"uniform float far;\n",d=d+"uniform bool depthrender;\n",d=d+"uniform float distance;\n",d=d+"uniform int picktype;\n",d=d+"uniform vec3 pickcolor;\n",d=d+"uniform vec3 color;\n",d=d+"uniform float alpha;\n",d=d+"void main(void){\n",d=d+"float ob=pow(min(1.0,abs(dot(normalize(Matrix[2].rgb),vec3(0.0,0.0,1.0)))*2.0),1.5);\n",d=d+"float a=texture2D(TEXTURE,texcoord).a*alpha*ob;\n",d=d+"if(picktype=="+a.TEXT_BOXPICK+"){gl_FragColor = vec4(pickcolor,1.0);}",d=d+"else if(picktype=="+a.TEXT_TEXTPICK+"){if(alpha<1.0) discard; gl_FragColor = vec4(pickcolor,alpha);}",d=d+"else{gl_FragColor = vec4(color.rgb,a);};\n",d=d+"if (depthrender) { if(a<0.5) discard; float depth = gl_FragCoord.z / gl_FragCoord.w;\n",d=d+"vec4 rgba=fract(depth/distance * vec4(16777216.0, 65536.0, 256.0, 1.0));\n",d=d+"gl_FragColor=rgba-rgba.rrgb*vec4(0.0,0.00390625,0.00390625,0.00390625);}\n",d=d+"}\n",this.GLFragmentShader=b.createShader(b.FRAGMENT_SHADER),this.GLVertexShader=b.createShader(b.VERTEX_SHADER),b.shaderSource(this.GLFragmentShader,d),b.compileShader(this.GLFragmentShader);if(b.getShaderParameter(this.GLFragmentShader,b.COMPILE_STATUS)){b.shaderSource(this.GLVertexShader,c),b.compileShader(this.GLVertexShader);if(!b.getShaderParameter(this.GLVertexShader,b.COMPILE_STATUS)){a.error(b.getShaderInfoLog(this.GLVertexShader));return}this.GLShaderProgram=b.createProgram(),b.attachShader(this.GLShaderProgram,this.GLVertexShader),b.attachShader(this.GLShaderProgram,this.GLFragmentShader),b.linkProgram(this.GLShaderProgram)}else a.error(b.getShaderInfoLog(this.GLFragmentShader))},a.Text.prototype.GLInit=function(a){this.gl=a,this.createPlane(a),this.GLGenerateShader(a),this.glTexture=a.createTexture(),this.dirty=!0},a.Text.prototype.updateCanvas=function(a){var b=this.canvas;b.width=1,b.height=this.size*1.2;var c=b.getContext("2d");c.font=this.size+"px "+this.font,b.width=c.measureText(this.text).width,b.height=this.size*1.2,c=b.getContext("2d"),c.textBaseline="top",c.font=(this.extra||"")+" "+this.size+"px "+this.font,this.aspect=b.width/b.height,c.fillText(this.text,0,0);var d=Math.pow(2,Math.ceil(Math.log(b.height))/Math.log(2)),e=Math.pow(2,Math.ceil(Math.log(b.width))/Math.log(2));this.scaleCanvas.height=d,this.scaleCanvas.width=e,this.scaleContext=this.scaleCanvas.getContext("2d"),this.scaleContext.clearRect(0,0,e,d),this.scaleContext.drawImage(b,0,0,e,d),a.bindTexture(a.TEXTURE_2D,this.glTexture);try{a.texImage2D(a.TEXTURE_2D,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,this.scaleCanvas)}catch(f){a.texImage2D(a.TEXTURE_2D,0,a.RGBA,a.RGBA,a.UNSIGNED_BYTE,this.scaleCanvas,null)}a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.LINEAR_MIPMAP_LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.LINEAR),a.generateMipmap(a.TEXTURE_2D),a.bindTexture(a.TEXTURE_2D,null),this.dirty=!1},a.Text.prototype.GLRender=function(b,c,d){this.gl||this.GLInit(b),this.dirty&&this.updateCanvas(b);if(c==a.RENDER_DEFAULT||c==a.RENDER_PICK||c==a.RENDER_SHADOW){this.lookAt&&this.Lookat(this.lookAt),b.program!=this.GLShaderProgram&&(b.useProgram(this.GLShaderProgram),b.program=this.GLShaderProgram);var e;for(var f=0;f<8;f++)b.disableVertexAttribArray(f);e=a.getAttribLocation(b,this.GLShaderProgram,"position"),b.bindBuffer(b.ARRAY_BUFFER,this.posBuffer),b.enableVertexAttribArray(e),b.vertexAttribPointer(e,this.posBuffer.itemSize,b.FLOAT,!1,0,0),e=a.getAttribLocation(b,this.GLShaderProgram,"uvcoord"),b.bindBuffer(b.ARRAY_BUFFER,this.uvBuffer),b.enableVertexAttribArray(e),b.vertexAttribPointer(e,this.uvBuffer.itemSize,b.FLOAT,!1,0,0),b.activeTexture(b.TEXTURE0),b.bindTexture(b.TEXTURE_2D,this.glTexture),a.setUniform(b,"1i",a.getUniformLocation(b,this.GLShaderProgram,"TEXTURE"),0),d||(d=0);var g=d>>16&255,h=d>>8&255,i=d&255;a.setUniform3(b,"3f",a.getUniformLocation(b,this.GLShaderProgram,"pickcolor"),i/255,h/255,g/255),c==a.RENDER_PICK?a.setUniform(b,"1i",a.getUniformLocation(b,this.GLShaderProgram,"picktype"),this.pickType):a.setUniform(b,"1i",a.getUniformLocation(b,this.GLShaderProgram,"picktype"),0);var j=b.scene.camera.getFar();a.setUniform(b,"1f",a.getUniformLocation(b,this.GLShaderProgram,"distance"),j),c==a.RENDER_SHADOW?a.setUniform(b,"1i",a.getUniformLocation(b,this.GLShaderProgram,"depthrender"),1):a.setUniform(b,"1i",a.getUniformLocation(b,this.GLShaderProgram,"depthrender"),0),this.GLShaderProgram.glarrays||(this.GLShaderProgram.glarrays={});var k=this.size/100,l=a.mulMat4(b.scene.camera.getViewMatrix(),a.mulMat4(this.getModelMatrix(),a.scaleMatrix(this.aspect*k,k,k))),m=a.getUniformLocation(b,this.GLShaderProgram,"Matrix");this.GLShaderProgram.glarrays.mMatrix?a.mat4gl(l,this.GLShaderProgram.glarrays.mMatrix):this.GLShaderProgram.glarrays.mMatrix=new Float32Array(l),a.setUniformMatrix(b,"Matrix4fv",m,!0,this.GLShaderProgram.glarrays.mMatrix);var m=a.getUniformLocation(b,this.GLShaderProgram,"PMatrix");this.GLShaderProgram.glarrays.pMatrix?a.mat4gl(b.scene.camera.getProjectionMatrix(),this.GLShaderProgram.glarrays.pMatrix):this.GLShaderProgram.glarrays.pMatrix=new Float32Array(b.scene.camera.getProjectionMatrix()),a.setUniformMatrix(b,"Matrix4fv",m,!0,this.GLShaderProgram.glarrays.pMatrix);var n=a.getUniformLocation(b,this.GLShaderProgram,"far");a.setUniform(b,"1f",n,b.scene.camera.getFar());var o=a.getUniformLocation(b,this.GLShaderProgram,"alpha");a.setUniform(b,"1f",o,this.alpha),a.setUniform3(b,"3f",a.getUniformLocation(b,this.GLShaderProgram,"color"),this.color.r,this.color.g,this.color.b),b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,this.GLfaces),b.drawElements(b.TRIANGLES,this.GLfaces.numItems,b.UNSIGNED_SHORT,0),b.scene.lastMaterial=null}},a.Text.prototype.createPlane=function(a){this.posBuffer||(this.posBuffer=a.createBuffer()),a.bindBuffer(a.ARRAY_BUFFER,this.posBuffer),a.bufferData(a.ARRAY_BUFFER,new Float32Array([1,1,0,-1,1,0,-1,-1,0,1,-1,0]),a.STATIC_DRAW),this.posBuffer.itemSize=3,this.posBuffer.numItems=4,this.uvBuffer||(this.uvBuffer=a.createBuffer()),a.bindBuffer(a.ARRAY_BUFFER,this.uvBuffer),a.bufferData(a.ARRAY_BUFFER,new Float32Array([0,0,1,0,1,1,0,1]),a.STATIC_DRAW),this.uvBuffer.itemSize=2,this.uvBuffer.numItems=4,this.GLfaces||(this.GLfaces=a.createBuffer()),a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,this.GLfaces),a.bufferData(a.ELEMENT_ARRAY_BUFFER,new Uint16Array([2,1,0,0,3,2]),a.STATIC_DRAW),this.GLfaces.itemSize=1,this.GLfaces.numItems=6}}(GLGE),function(a){a.Renderer=function(b,c,d){this.viewport=[],this.canvas=b,d||(d={alpha:!0,depth:!0,stencil:!0,antialias:!0,premultipliedAlpha:!0});try{this.gl=b.getContext("experimental-webgl",d)}catch(e){}try{this.gl||(this.gl=b.getContext("webgl",d))}catch(e){}if(!this.gl){console.log("GLGE err:",typeof globalNoWebGLError=="undefined");if(c||typeof globalNoWebGLError!="undefined"){c();throw"cannot create webgl context"}var f=document.createElement("div");f.setAttribute("style","position: absolute; top: 10px; left: 10px; font-family: sans-serif; font-size: 14px; padding: 10px;background-color: #fcffcb;color: #800; width: 200px; border:2px solid #f00"),f.innerHTML="WebGL compatible Browser Required(Firefox 4 or Chrome 9 and up) or you may need to update your graphics card driver.",document.getElementsByTagName("body")[0].appendChild(f);throw"cannot create webgl context"}try{this.gl.canvas=b}catch(e){}this.gl.getProgramParameter||(this.gl.getProgramParameter=this.gl.getProgrami),this.gl.getShaderParameter||(this.gl.getShaderParameter=this.gl.getShaderi),this.gl.uniformMatrix4fvX=this.gl.uniformMatrix4fv,this.gl.uniformMatrix4fv=function(b,c,d){c?(a.mat4gl(a.transposeMat4(d),d),this.uniformMatrix4fvX(b,!1,d)):this.uniformMatrix4fvX(b,!1,d)};var g=this.gl;g.af=g.getExtension("MOZ_EXT_texture_filter_anisotropic")||g.getExtension("WEBKIT_EXT_texture_filter_anisotropic")||g.getExtension("EXT_texture_filter_anisotropic"),this.gl.clearDepth(1),this.gl.clearStencil(0),this.gl.enable(this.gl.DEPTH_TEST),this.gl.depthFunc(this.gl.LEQUAL),this.gl.blendFuncSeparate(this.gl.SRC_ALPHA,this.gl.ONE_MINUS_SRC_ALPHA,this.gl.ZERO,this.gl.ONE)},a.augment(a.QuickNotation,a.Renderer),a.Renderer.prototype.gl=null,a.Renderer.prototype.scene=null,a.C_STENCIL=1,a.C_DEPTH=2,a.C_COLOR=4,a.C_ALL=7,a.Renderer.prototype.clearType=a.C_ALL,a.Renderer.prototype.setViewportWidth=function(a){this.viewport[0]=a;return this},a.Renderer.prototype.setViewportHeight=function(a){this.viewport[1]=a;return this},a.Renderer.prototype.setViewportOffsetX=function(a){this.viewport[2]=a;return this},a.Renderer.prototype.setViewportOffsetY=function(a){this.viewport[3]=a;return this},a.Renderer.prototype.clearViewport=function(){this.viewport=[]},a.Renderer.prototype.getViewportWidth=function(){return this.viewport.length>0?this.viewport[0]:this.canvas.width},a.Renderer.prototype.getViewportHeight=function(){return this.viewport.length>0?this.viewport[1]:this.canvas.height},a.Renderer.prototype.getViewportOffsetX=function(){return this.viewport.length>0?this.viewport[2]:0},a.Renderer.prototype.getViewportOffsetY=function(){return this.viewport.length>0?this.viewport[3]:0},a.Renderer.prototype.setClearType=function(a){this.clearType=a;return this},a.Renderer.prototype.getClearType=function(){return this.clearType},a.Renderer.prototype.GLClear=function(){var b=this.gl,c=this.clearType,d=0;(c&a.C_COLOR)==a.C_COLOR&&(d=d|b.COLOR_BUFFER_BIT),(c&a.C_DEPTH)==a.C_DEPTH&&(d=d|b.DEPTH_BUFFER_BIT),(c&a.C_STENCIL)==a.C_STENCIL&&(d=d|b.STENCIL_BUFFER_BIT),b.clear(d)},a.Renderer.prototype.getScene=function(){return this.scene},a.Renderer.prototype.setScene=function(a){a.renderer=this,this.scene=a,a.gl||a.GLInit(this.gl),a.camera.updateMatrix();return this},a.Renderer.prototype.render=function(){if(this.transitonFilter){var a=+(new Date);if(a<this.transStarted+this.transDuration){this.GLRenderTransition((a-this.transStarted)/this.transDuration);return}this.transStarted==1&&(this.GLRenderTransition(0),this.transStarted=+(new Date))}this.cullFaces&&this.gl.enable(this.gl.CULL_FACE),this.scene&&this.scene.render(this.gl),!this.rendered&&this.scene&&(this.scene.render(this.gl),this.rendered=!0)},a.Renderer.prototype.transitionTo=function(a,b){this.transitonFilter&&(this.transitonFilter.clearPersist(this.gl),this.oldScene=this.scene,this.transStarted=1,this.transDuration=b),this.setScene(a)},a.Renderer.prototype.createTransitionBuffers=function(){var a=this.gl;this.frameBufferTS=a.createFramebuffer(),this.renderBufferTS=a.createRenderbuffer(),this.textureTS=a.createTexture(),a.bindTexture(a.TEXTURE_2D,this.textureTS),this.widthTS=this.getViewportWidth(),this.heightTS=this.getViewportHeight(),a.texImage2D(a.TEXTURE_2D,0,a.RGBA,this.widthTS,this.heightTS,0,a.RGBA,a.UNSIGNED_BYTE,null),a.bindFramebuffer(a.FRAMEBUFFER,this.frameBufferTS),a.bindRenderbuffer(a.RENDERBUFFER,this.renderBufferTS),a.renderbufferStorage(a.RENDERBUFFER,a.DEPTH_COMPONENT16,this.widthTS,this.heightTS),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_2D,this.textureTS,0),a.framebufferRenderbuffer(a.FRAMEBUFFER,a.DEPTH_ATTACHMENT,a.RENDERBUFFER,this.renderBufferTS),a.bindFramebuffer(a.FRAMEBUFFER,null),a.bindRenderbuffer(a.RENDERBUFFER,null),a.bindTexture(a.TEXTURE_2D,null),this.frameBufferTD=a.createFramebuffer(),this.renderBufferTD=a.createRenderbuffer(),this.textureTD=a.createTexture(),a.bindTexture(a.TEXTURE_2D,this.textureTD),this.widthTD=this.getViewportWidth(),this.heightTD=this.getViewportHeight(),a.texImage2D(a.TEXTURE_2D,0,a.RGBA,this.widthTD,this.heightTD,0,a.RGBA,a.UNSIGNED_BYTE,null),a.bindFramebuffer(a.FRAMEBUFFER,this.frameBufferTD),a.bindRenderbuffer(a.RENDERBUFFER,this.renderBufferTD),a.renderbufferStorage(a.RENDERBUFFER,a.DEPTH_COMPONENT16,this.widthTD,this.heightTD),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_2D,this.textureTD,0),a.framebufferRenderbuffer(a.FRAMEBUFFER,a.DEPTH_ATTACHMENT,a.RENDERBUFFER,this.renderBufferTD),a.bindFramebuffer(a.FRAMEBUFFER,null),a.bindRenderbuffer(a.RENDERBUFFER,null),a.bindTexture(a.TEXTURE_2D,null)},a.Renderer.prototype.setTransitionFilter=function(a){this.gl&&a.getFrameBuffer(this.gl),this.transitonFilter=a;var b=this;a.textures=[{name:"GLGE_SOURCE",doTexture:function(a){a.bindTexture(a.TEXTURE_2D,b.textureTS),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE)}},{name:"GLGE_DEST",doTexture:function(a){a.bindTexture(a.TEXTURE_2D,b.textureTD),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE)}}];return this},a.Renderer.prototype.GLRenderTransition=function(a){this.transitonFilter.setUniform("1f","time",a),this.frameBufferTS||(this.createTransitionBuffers(),this.transitonFilter.getFrameBuffer(this.gl)),this.scene.transbuffer=this.frameBufferTS,this.scene.render(this.gl),this.scene.transbuffer=null,this.oldScene.transbuffer=this.frameBufferTD,this.oldScene.render(this.gl),this.oldScene.transbuffer=null,this.transitonFilter.GLRender(this.gl)}}(GLGE),function(a){a.C_PERSPECTIVE=1,a.C_ORTHO=2,a.Camera=function(b){a.Assets.registerAsset(this,b)},a.augment(a.Placeable,a.Camera),a.augment(a.Animatable,a.Camera),a.augment(a.QuickNotation,a.Camera),a.augment(a.JSONLoader,a.Camera),a.Camera.prototype.className="Camera",a.Camera.prototype.fovy=35,a.Camera.prototype.aspect=1,a.Camera.prototype.near=.1,a.Camera.prototype.far=1e3,a.Camera.prototype.orthoscale=5,a.Camera.prototype.type=a.C_PERSPECTIVE,a.Camera.prototype.pMatrix=null,a.Camera.prototype.getOrthoScale=function(){if(this.type==a.C_ORTHO)return this.orthoscale;a.error("You may only get a scale for a orthographic camera");return 1},a.Camera.prototype.setOrthoScale=function(b){this.type==a.C_ORTHO?(this.orthoscale=b,this.pMatrix=null):a.error("You may only set a scale for a orthographic camera");return this},a.Camera.prototype.getFar=function(){return this.far},a.Camera.prototype.setFar=function(a){this.pMatrix=null,this.far=+a;return this},a.Camera.prototype.getNear=function(){return this.near},a.Camera.prototype.setNear=function(a){this.pMatrix=null,this.near=+a;return this},a.Camera.prototype.getType=function(){this.pMatrix=null;return this.type},a.Camera.prototype.setType=function(b){b==a.C_PERSPECTIVE||b==a.C_ORTHO?(this.type=b,this.pMatrix=null):a.error("unsuported camera type");return this},a.Camera.prototype.getFovY=function(){if(this.type==a.C_PERSPECTIVE)return this.fovy;a.error("You may only get a yfov for a perspective camera");return 1},a.Camera.prototype.setFovY=function(b){this.type==a.C_PERSPECTIVE?(this.fovy=+b,this.ymax=null,this.pMatrix=null):a.error("You may only set a yfov for a perspective camera");return this},a.Camera.prototype.getAspect=function(){if(this.type==a.C_PERSPECTIVE||this.type==a.C_ORTHO)return this.aspect;a.error("You may only set a aspect for a perspective or orthographic camera");return 1},a.Camera.prototype.setAspect=function(b){this.type==a.C_PERSPECTIVE||this.type==a.C_ORTHO?(this.aspect=+b,this.pMatrix=null):a.error("You may only set a aspect for a perspective or orthographic camera");return this},a.Camera.prototype.getProjectionMatrix=function(){if(!this.pMatrix)if(this.pMatrixOveride)this.pMatrix=this.pMatrixOveride;else switch(this.type){case a.C_PERSPECTIVE:this.pMatrix=a.makePerspective(this.fovy,this.aspect,this.near,this.far);break;case a.C_ORTHO:this.pMatrix=a.makeOrtho(-this.orthoscale*this.aspect,this.orthoscale*this.aspect,-this.orthoscale,this.orthoscale,this.near,this.far)}return this.pMatrix},a.Camera.prototype.setProjectionMatrix=function(a){this.pMatrix=a;return this},a.Camera.prototype.setCustomProjectionMatrix=function(a){this.pMatrix=a,this.pMatrixOveride=a;return this},a.Camera.prototype.updateMatrix=function(){var b=this.getPosition(),c=a.translateMatrix(b.x,b.y,b.z);c=a.mulMat4(c,this.getRotMatrix()),this.parent&&(c=a.mulMat4(this.parent.getModelMatrix(),c)),this.location=[c[3],c[7],c[11]],this.matrix=a.inverseMat4(c)},a.Camera.prototype.getViewMatrix=function(){(!this.matrix||!this.rotmatrix)&&this.updateMatrix();return this.matrix},a.Camera.prototype.getViewProjection=function(){var b=this.getProjectionMatrix(),c=this.getViewMatrix();if(b!=this.vpProjectionMatrix||c!=this.vpViewMatrix)this.cameraViewProjection=a.mulMat4(b,c),this.vpProjectionMatrix=b,this.vpViewMatrix=c;return this.cameraViewProjection}}(GLGE),function(a){a.Light=function(b){this.color={r:1,g:1,b:1},a.Assets.registerAsset(this,b)},a.augment(a.Placeable,a.Light),a.augment(a.Animatable,a.Light),a.augment(a.QuickNotation,a.Light),a.augment(a.JSONLoader,a.Light),a.Light.prototype.className="Light",a.L_POINT=1,a.L_DIR=2,a.L_SPOT=3,a.L_OFF=4,a.Light.prototype.constantAttenuation=1,a.Light.prototype.linearAttenuation=.002,a.Light.prototype.quadraticAttenuation=8e-4,a.Light.prototype.spotCosCutOff=.95,a.Light.prototype.spotCutOff=!0,a.Light.prototype.spotPMatrix=null,a.Light.prototype.spotExponent=10,a.Light.prototype.color=null,a.Light.prototype.diffuse=!0,a.Light.prototype.specular=!0,a.Light.prototype.type=a.L_POINT,a.Light.prototype.frameBuffer=null,a.Light.prototype.renderBuffer=null,a.Light.prototype.texture=null,a.Light.prototype.bufferHeight=512,a.Light.prototype.bufferWidth=512,a.Light.prototype.shadowBias=5e-4,a.Light.prototype.varianceMin=5e-8,a.Light.prototype.bleedCutoff=.3,a.Light.prototype.dirNear=1,a.Light.prototype.distance=1e3,a.Light.prototype.spotSoftness=0,a.Light.prototype.spotSoftnessDistance=.3,a.Light.prototype.sceneAABB=[-1e3,-1e3,-1e3,1e3,1e3,1e3],a.Light.prototype.setSceneMinX=function(a){this.sceneAABB[0]=parseFloat(a);return this},a.Light.prototype.getSceneMinX=function(){return this.sceneAABB[0]},a.Light.prototype.setSceneMaxX=function(a){this.sceneAABB[3]=parseFloat(a);return this},a.Light.prototype.getSceneMaxX=function(){return this.sceneAABB[3]},a.Light.prototype.setSceneMinY=function(a){this.sceneAABB[1]=parseFloat(a);return this},a.Light.prototype.getSceneMinY=function(){return this.sceneAABB[1]},a.Light.prototype.setSceneMaxY=function(a){this.sceneAABB[4]=parseFloat(a);return this},a.Light.prototype.getSceneMaxY=function(){return this.sceneAABB[4]},a.Light.prototype.setSceneMinZ=function(a){this.sceneAABB[2]=parseFloat(a);return this},a.Light.prototype.getSceneMinZ=function(){return this.sceneAABB[2]},a.Light.prototype.setSceneMaxY=function(a){this.sceneAABB[5]=parseFloat(a);return this},a.Light.prototype.getSceneMaxZ=function(){return this.sceneAABB[5]},a.Light.prototype.setNearShadowBias=function(a){this.dirNear=a;return this},a.Light.prototype.getNearShadowBias=function(){return this.dirNear},a.Light.prototype.setBleedCutoff=function(a){this.bleedCutoff=a,this.fireEvent("shaderupdate",{});return this},a.Light.prototype.getBleedCutoff=function(){return this.bleedCutoff},a.Light.prototype.setVarianceMin=function(a){this.varianceMin=a,this.fireEvent("shaderupdate",{});return this},a.Light.prototype.getVarianceMin=function(){return this.varianceMin},a.Light.prototype.getPMatrix=function(b,c,d,e,f){if(!this.spotPMatrix){var g;this.scene&&this.scene.camera?g=this.scene.camera.far:g=1e3,this.type==a.L_SPOT&&(this.spotPMatrix=a.makePerspective(Math.acos(this.spotCosCutOff)/3.14159*360,1,.1,g))}if(this.type==a.L_DIR){var h=this.getModelMatrix();this.spotPMatrix=this.calcDirMatrix(f,[h[2],h[6],h[10]],this,c)}return this.spotPMatrix},a.Light.prototype.calcDir=function(b,c){var d=[0,0,0];for(var e=0;e<b.length;e++)d=a.addVec3(d,a.subVec3(b[e],c));return a.toUnitVec3(d)},a.Light.prototype.findBound=function(a,b,c){for(var d=0;d<3;d++)c[d]<a[d]?a[d]=c[d]:c[d]>b[d]&&(b[d]=c[d])},a.Light.prototype.lightLook=function(b,c,d){var e=a.toUnitVec3(a.crossVec3(c,d)),f=a.toUnitVec3(a.crossVec3(e,c)),g=a.toUnitVec3(c),h=[];h[0]=e[0],h[4]=f[0],h[8]=-g[0],h[12]=0,h[1]=e[1],h[5]=f[1],h[9]=-g[1],h[13]=0,h[2]=e[2],h[6]=f[2],h[10]=-g[2],h[14]=0,h[3]=-a.dotVec3(e,b),h[7]=-a.dotVec3(f,b),h[11]=a.dotVec3(g,b),h[15]=1;return h},a.Light.prototype.transformPoints=function(b,c){var d=[];for(var e=0;e<b.length;e++){var f=a.mulMat4Vec4(c,[b[e][0],b[e][1],b[e][2],1]);f[0]/=f[3],f[1]/=f[3],f[2]/=f[3],f[3]/=f[3],d.push(f)}return d},a.Light.prototype.scaleTranslateToFit=function(a,b){var c=[];c[0]=2/(b[0]-a[0]),c[1]=0,c[2]=0,c[3]=-(b[0]+a[0])/(b[0]-a[0]),c[4]=0,c[5]=2/(b[1]-a[1]),c[6]=0,c[7]=-(b[1]+a[1])/(b[1]-a[1]),c[8]=0,c[9]=0,c[10]=2/(b[2]-a[2]),c[11]=-(b[2]+a[2])/(b[2]-a[2]),c[12]=0,c[13]=0,c[14]=0,c[15]=1;return c},a.Light.prototype.calcBounds=function(a,b,c){a[0]=c[0][0],a[1]=c[0][1],a[2]=c[0][2],b[0]=c[0][0],b[1]=c[0][1],b[2]=c[0][2];for(var d=1;d<c.length;d++)this.findBound(a,b,c[d])},a.Light.prototype.linComb=function(a,b,c){return[a[0]+c*b[0],a[1]+c*b[1],a[2]+c*b[2]]},a.Light.prototype.getEdgePlanesFromView=function(b){var c=a.inverseMat4(b),d=[[-1,-1,-1,1],[-1,-1,1,1],[-1,1,-1,1],[-1,1,1,1],[1,-1,-1,1],[1,-1,1,1],[1,1,-1,1],[1,1,1,1]],e=this.transformPoints(d,c),f=a.toUnitVec3(a.crossVec3(a.subVec3(e[1],e[0]),a.subVec3(e[2],e[0])));f[3]=a.dotVec3(f,e[0]);var g=a.toUnitVec3(a.crossVec3(a.subVec3(e[6],e[4]),a.subVec3(e[5],e[4])));g[3]=a.dotVec3(g,e[4]);var h=a.toUnitVec3(a.crossVec3(a.subVec3(e[7],e[5]),a.subVec3(e[1],e[5])));h[3]=a.dotVec3(h,e[5]);var i=a.toUnitVec3(a.crossVec3(a.subVec3(e[2],e[0]),a.subVec3(e[4],e[0])));i[3]=a.dotVec3(i,e[0]);var j=a.toUnitVec3(a.crossVec3(a.subVec3(e[3],e[2]),a.subVec3(e[6],e[2])));j[3]=a.dotVec3(j,e[2]);var k=a.toUnitVec3(a.crossVec3(a.subVec3(e[4],e[0]),a.subVec3(e[1],e[0])));k[3]=a.dotVec3(k,e[0]);var l=[[e[0],e[4]],[e[4],e[6]],[e[6],e[2]],[e[2],e[0]],[e[1],e[5]],[e[5],e[7]],[e[7],e[3]],[e[3],e[1]],[e[0],e[1]],[e[3],e[2]],[e[7],e[6]],[e[5],e[4]]];return{edges:l,planes:[f,g,h,i,j,k],points:e}},a.Light.prototype.getEdgePlanesFromAABB=function(a,b,c,d,e,f){var g=[[1,0,0,a],[-1,0,0,-d],[0,1,0,b],[0,-1,0,-e],[0,0,1,c],[0,0,-1,-f]],h=[[a,b,c],[a,b,f],[a,e,c],[a,e,f],[d,b,c],[d,b,f],[d,e,c],[d,e,f]],i=[[h[0],h[4]],[h[4],h[6]],[h[6],h[2]],[h[2],h[0]],[h[1],h[5]],[h[5],h[7]],[h[7],h[3]],[h[3],h[1]],[h[0],h[1]],[h[3],h[2]],[h[7],h[6]],[h[5],h[4]]];return{edges:i,planes:g,points:h}},a.Light.prototype.planeEdgeIntersect=function(b,c){var d=a.dotVec3(b[0],c)-c[3],e=a.dotVec3(b[1],c)-c[3];if(d>0&&e>0||d<0&&e<0)return!1;var f=a.subVec3(b[1],b[0]);f=a.scaleVec3(f,-d/(e-d));return a.addVec3(b[0],f)},a.Light.prototype.pointInPlanes=function(b,c){var d=-.001;for(var e=0;e<c.length;e++)if(a.dotVec3(b,c[e])-c[e][3]<d)return!1;return!0},a.Light.prototype.getViewPoints=function(a){var b=this.getEdgePlanesFromView(a),c=this.getEdgePlanesFromAABB(this.sceneAABB[0],this.sceneAABB[1],this.sceneAABB[2],this.sceneAABB[3],this.sceneAABB[4],this.sceneAABB[5]),d=b.planes,e=c.planes,f=b.edges,g=c.edges,h=[],i=[];for(var j=0;j<d.length;j++){for(var k=0;k<g.length;k++){var l=this.planeEdgeIntersect(g[k],d[j]);l&&h.push(l)}i.push(d[j])}for(var j=0;j<e.length;j++){for(var k=0;k<f.length;k++){var l=this.planeEdgeIntersect(f[k],e[j]);l&&h.push(l)}i.push(e[j])}var m=[];for(var j=0;j<h.length;j++)this.pointInPlanes(h[j],i)&&m.push(h[j]);for(var j=0;j<b.points.length;j++)this.pointInPlanes(b.points[j],i)&&m.push(b.points[j]);for(var j=0;j<c.points.length;j++)this.pointInPlanes(c.points[j],i)&&m.push(c.points[j]);return m},a.Light.prototype.calcDirMatrix=function(b,c,d,e){var f=b.matrix,g=a.inverseMat4(f),h=b.getModelMatrix(),i=b.getProjectionMatrix(),j=b.getViewProjection(),k=this.getViewPoints(j),l=a.scaleVec3(c,b.far),m=k.length;for(var n=0;n<m;n++)k.push(a.addVec3(l,k[n]));if(k.length==0)return[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1];var o=[h[8],h[9],h[10]],p=[g[3],g[7],g[11]],q=[],r=[],s,t=this.dirNear,u=this.calcDir(k,p),v=a.crossVec3(c,u),w=a.crossVec3(v,c);w=a.toUnitVec3(w);var x=a.dotVec3(u,c),y=Math.sqrt(1-x*x),z=this.lightLook(p,c,w),A=this.transformPoints(k,z);this.calcBounds(q,r,A);var B=1/y,C=B*t,D=Math.abs(r[1]-q[1]),E=C+D*y,F=(C+Math.sqrt(E*C))/y,G=F+D,H,H=this.linComb(p,w,-(F-t));z=this.lightLook(H,c,w);var s=a.identMatrix();s[5]=(G+F)/(G-F),s[7]=-2*G*F/(G-F),s[13]=1,s[15]=0;var I=a.mulMat4(s,z);A=this.transformPoints(k,I),this.calcBounds(q,r,A),I=this.scaleTranslateToFit(q,r),I=a.mulMat4(I,s),I=a.mulMat4(I,a.mulMat4(z,a.inverseMat4(e)));return I},a.Light.prototype.setDistance=function(a){this.distance=a,this.fireEvent("shaderupdate",{});return this},a.Light.prototype.getDistance=function(){return this.distance},a.Light.prototype.setNegativeShadow=function(a){this.negativeShadow=a,this.fireEvent("shaderupdate",{});return this},a.Light.prototype.getNegative=function(){return this.negativeShadow},a.Light.prototype.setCastShadows=function(a){this.castShadows=a,this.fireEvent("shaderupdate",{});return this},a.Light.prototype.getCastShadows=function(){return this.castShadows},a.Light.prototype.setShadowBias=function(a){this.shadowBias=a;return this},a.Light.prototype.getShadowBias=function(){return this.shadowBias},a.Light.prototype.setBufferWidth=function(a){this.bufferWidth=a;return this},a.Light.prototype.getBufferHeight=function(){return this.bufferHeight},a.Light.prototype.setBufferHeight=function(a){this.bufferHeight=a;return this},a.Light.prototype.getBufferWidth=function(){return this.bufferWidth},a.Light.prototype.setSpotCosCutOff=function(a){this.spotPMatrix=null,this.spotCosCutOff=a;return this},a.Light.prototype.getSpotCosCutOff=function(){return this.spotCosCutOff},a.Light.prototype.setSpotCutOff=function(a){this.spotCutOff=a,this.fireEvent("shaderupdate",{});return this},a.Light.prototype.getSpotCutOff=function(){return this.spotCutOff},a.Light.prototype.setSpotExponent=function(a){this.spotExponent=a;return this},a.Light.prototype.getSpotExponent=function(){return this.spotExponent},a.Light.prototype.getAttenuation=function(a,b,c){var d={};d.constant=this.constantAttenuation,d.linear=this.linearAttenuation,d.quadratic=this.quadraticAttenuation;return d},a.Light.prototype.setAttenuation=function(a,b,c){this.constantAttenuation=a,this.linearAttenuation=b,this.quadraticAttenuation=c;return this},a.Light.prototype.setAttenuationConstant=function(a){this.constantAttenuation=a;return this},a.Light.prototype.setAttenuationLinear=function(a){this.linearAttenuation=a;return this},a.Light.prototype.setAttenuationQuadratic=function(a){this.quadraticAttenuation=a;return this},a.Light.prototype.setColor=function(b){b=a.colorParse(b),this.color={r:b.r,g:b.g,b:b.b};return this},a.Light.prototype.setColorR=function(a){this.color.r=a;return this},a.Light.prototype.setColorG=function(a){this.color.g=a;return this},a.Light.prototype.setColorB=function(a){this.color.b=a;return this},a.Light.prototype.getColor=function(){return this.color},a.Light.prototype.getColorR=function(a){return this.color.r},a.Light.prototype.getColorG=function(a){return this.color.g},a.Light.prototype.getColorB=function(a){return this.color.b},a.Light.prototype.getType=function(){return this.type},a.Light.prototype.setType=function(a){this.type=a,this.fireEvent("shaderupdate",{});return this},a.Light.prototype.getSpotSoftness=function(){return this.spotSoftness},a.Light.prototype.setSpotSoftness=function(a){this.spotSoftness=+a,this.gl&&this.createSoftPrograms(this.gl),this.fireEvent("shaderupdate",{});return this},a.Light.prototype.getSpotSoftDistance=function(){return this.spotSoftnessDistance},a.Light.prototype.setSpotSoftDistance=function(a){this.spotSoftnessDistance=+a,this.fireEvent("shaderupdate",{});return this},a.Light.prototype.enableLight=function(){this.type==a.L_OFF&&this.old_type!==undefined&&(this.setType(this.old_type),delete this.old_type)},a.Light.prototype.disableLight=function(){this.type!=a.L_OFF&&(this.old_type=this.type,this.setType(a.L_OFF))},a.Light.prototype.GLInit=function(b){this.gl=b,(this.type==a.L_SPOT||this.type==a.L_DIR)&&!this.texture&&(this.createSpotBuffer(b),this.createSoftBuffer(b),this.createSoftPrograms(b))},a.Light.prototype.createSpotBuffer=function(b){this.frameBuffer=b.createFramebuffer(),this.renderBuffer=b.createRenderbuffer(),this.texture=b.createTexture(),b.bindTexture(b.TEXTURE_2D,this.texture);try{b.texImage2D(b.TEXTURE_2D,0,b.RGBA,this.bufferWidth,this.bufferHeight,0,b.RGBA,b.UNSIGNED_BYTE,null)}catch(c){a.error("incompatible texture creation method");var d=parseFloat(this.bufferWidth),e=parseFloat(this.bufferHeight),f=new Uint8Array(d*e*4);b.texImage2D(b.TEXTURE_2D,0,b.RGBA,d,e,0,b.RGBA,b.UNSIGNED_BYTE,f)}b.bindFramebuffer(b.FRAMEBUFFER,this.frameBuffer),b.bindRenderbuffer(b.RENDERBUFFER,this.renderBuffer),b.renderbufferStorage(b.RENDERBUFFER,b.DEPTH_COMPONENT16,this.bufferWidth,this.bufferHeight),b.framebufferTexture2D(b.FRAMEBUFFER,b.COLOR_ATTACHMENT0,b.TEXTURE_2D,this.texture,0),b.framebufferRenderbuffer(b.FRAMEBUFFER,b.DEPTH_ATTACHMENT,b.RENDERBUFFER,this.renderBuffer),b.bindFramebuffer(b.FRAMEBUFFER,null),b.bindRenderbuffer(b.RENDERBUFFER,null),b.bindTexture(b.TEXTURE_2D,null)},a.Light.prototype.createSoftBuffer=function(b){this.frameBufferSf=b.createFramebuffer(),this.renderBufferSf=b.createRenderbuffer(),this.textureSf=b.createTexture(),b.bindTexture(b.TEXTURE_2D,this.textureSf);try{b.texImage2D(b.TEXTURE_2D,0,b.RGBA,this.bufferWidth,this.bufferHeight,0,b.RGBA,b.UNSIGNED_BYTE,null)}catch(c){a.error("incompatible texture creation method");var d=parseFloat(this.bufferWidth),e=parseFloat(this.bufferHeight),f=new Uint8Array(d*e*4);b.texImage2D(b.TEXTURE_2D,0,b.RGBA,d,e,0,b.RGBA,b.UNSIGNED_BYTE,f)}b.bindFramebuffer(b.FRAMEBUFFER,this.frameBufferSf),b.bindRenderbuffer(b.RENDERBUFFER,this.renderBufferSf),b.renderbufferStorage(b.RENDERBUFFER,b.DEPTH_COMPONENT16,this.bufferWidth,this.bufferHeight),b.framebufferTexture2D(b.FRAMEBUFFER,b.COLOR_ATTACHMENT0,b.TEXTURE_2D,this.textureSf,0),b.framebufferRenderbuffer(b.FRAMEBUFFER,b.DEPTH_ATTACHMENT,b.RENDERBUFFER,this.renderBufferSf),b.bindFramebuffer(b.FRAMEBUFFER,null),b.bindRenderbuffer(b.RENDERBUFFER,null),b.bindTexture(b.TEXTURE_2D,null),this.posBuffer||(this.posBuffer=b.createBuffer()),b.bindBuffer(b.ARRAY_BUFFER,this.posBuffer),b.bufferData(b.ARRAY_BUFFER,new Float32Array([1,1,0,-1,1,0,-1,-1,0,1,-1,0]),b.STATIC_DRAW),this.posBuffer.itemSize=3,this.posBuffer.numItems=4,this.uvBuffer||(this.uvBuffer=b.createBuffer()),b.bindBuffer(b.ARRAY_BUFFER,this.uvBuffer),b.bufferData(b.ARRAY_BUFFER,new Float32Array([1,1,0,1,0,0,1,0]),b.STATIC_DRAW),this.uvBuffer.itemSize=2,this.uvBuffer.numItems=4,this.GLfaces||(this.GLfaces=b.createBuffer()),b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,this.GLfaces),b.bufferData(b.ELEMENT_ARRAY_BUFFER,new Uint16Array([0,1,2,2,3,0]),b.STATIC_DRAW),this.GLfaces.itemSize=1,this.GLfaces.numItems=6},a.Light.prototype.createSoftPrograms=function(b){this.GLShaderProgram&&b.deleteProgram(this.GLShaderProgram);var c="";c+="attribute vec3 position;\n",c+="attribute vec2 uvcoord;\n",c+="varying vec2 texCoord;\n",c+="void main(void){\n",c+="texCoord=uvcoord;\n",c+="gl_Position = vec4(position,1.0);\n",c+="}\n";var d=this.spotSoftness,e="precision highp float;\n";e=e+"uniform sampler2D TEXTURE;\n",e=e+"varying vec2 texCoord;\n",e=e+"uniform bool xpass;\n",e=e+"float blurSize = "+(1/this.bufferWidth).toFixed(10)+";\n",e=e+"float unpack(sampler2D TEX, vec2 co){;",e=e+"float value = dot(texture2D(TEX, co), vec4(0.000000059604644775390625,0.0000152587890625,0.00390625,1.0));",e=e+"return value;",e=e+"}",e=e+"vec2 unpack2(sampler2D TEX, vec2 co){;",e=e+"vec4 color = texture2D(TEX, co);",e=e+"float value1 = dot(color.rg, vec2(0.00390625,1.0));",e=e+"float value2 = dot(color.ba, vec2(0.00390625,1.0));",e=e+"return vec2(value1,value2);",e=e+"}",e=e+"vec4 pack(float value){;",e=e+"vec4 rgba=fract(value * vec4(16777216.0, 65536.0, 256.0, 1.0));\n",e=e+"return rgba-rgba.rrgb*vec4(0.0,0.00390625,0.00390625,0.00390625);",e=e+"}",e=e+"vec2 pack2(float value){;",e=e+"vec2 rg=fract(value * vec2(256.0, 1.0));\n",e=e+"return rg-rg.rr*vec2(0.0,0.00390625);",e=e+"}",e=e+"void main(void){\n",e=e+"float value = 0.0;",e=e+"vec2 value2;",e=e+"float mean = 0.0;",e=e+"float mean2 = 0.0;",e=e+"float color = 0.0;",e=e+"if(xpass){";for(var f=-d;f<d;f++)e=e+"value = unpack(TEXTURE, vec2(texCoord.x - "+(f+.5).toFixed(1)+"*blurSize, texCoord.y));",e=e+"mean += value;",e=e+"mean2 += value*value;";e=e+"gl_FragColor = vec4(pack2(pow(mean2/"+(d*2).toFixed(2)+",0.5)),pack2(mean/"+(d*2).toFixed(2)+"));\n",e=e+"}else{";for(var f=-d;f<d;f++)e=e+"value2 = unpack2(TEXTURE, vec2(texCoord.x, texCoord.y - "+(f+.5).toFixed(1)+"*blurSize));",e=e+"mean += value2.g;",e=e+"mean2 += pow(value2.r,2.0);";e=e+"gl_FragColor = vec4(pack2(pow(mean2/"+(d*2).toFixed(2)+",0.5)),pack2(mean/"+(d*2).toFixed(2)+"));\n",e=e+"}",e=e+"}\n",this.GLFragmentShader=b.createShader(b.FRAGMENT_SHADER),this.GLVertexShader=b.createShader(b.VERTEX_SHADER),b.shaderSource(this.GLFragmentShader,e),b.compileShader(this.GLFragmentShader);if(b.getShaderParameter(this.GLFragmentShader,b.COMPILE_STATUS)){b.shaderSource(this.GLVertexShader,c),b.compileShader(this.GLVertexShader);if(!b.getShaderParameter(this.GLVertexShader,b.COMPILE_STATUS)){a.error(b.getShaderInfoLog(this.GLVertexShader));return}this.GLShaderProgram=b.createProgram(),b.attachShader(this.GLShaderProgram,this.GLVertexShader),b.attachShader(this.GLShaderProgram,this.GLFragmentShader),b.linkProgram(this.GLShaderProgram)}else a.error(b.getShaderInfoLog(this.GLFragmentShader))},a.Light.prototype.GLRenderSoft=function(b){if(this.spotSoftness!=0){this.gl||this.GLInit(b),b.bindFramebuffer(b.FRAMEBUFFER,this.frameBufferSf),b.program!=this.GLShaderProgram&&(b.useProgram(this.GLShaderProgram),b.program=this.GLShaderProgram);var c;for(var d=0;d<8;d++)b.disableVertexAttribArray(d);c=a.getAttribLocation(b,this.GLShaderProgram,"position"),b.bindBuffer(b.ARRAY_BUFFER,this.posBuffer),b.enableVertexAttribArray(c),b.vertexAttribPointer(c,this.posBuffer.itemSize,b.FLOAT,!1,0,0),c=a.getAttribLocation(b,this.GLShaderProgram,"uvcoord"),b.bindBuffer(b.ARRAY_BUFFER,this.uvBuffer),b.enableVertexAttribArray(c),b.vertexAttribPointer(c,this.uvBuffer.itemSize,b.FLOAT,!1,0,0),b.activeTexture(b.TEXTURE0),b.bindTexture(b.TEXTURE_2D,this.texture),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE),a.setUniform(b,"1i",a.getUniformLocation(b,this.GLShaderProgram,"TEXTURE"),0),a.setUniform(b,"1i",a.getUniformLocation(b,this.GLShaderProgram,"xpass"),1),b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,this.GLfaces),b.clear(b.DEPTH_BUFFER_BIT|b.COLOR_BUFFER_BIT|b.STENCIL_BUFFER_BIT),b.drawElements(b.TRIANGLES,this.GLfaces.numItems,b.UNSIGNED_SHORT,0),b.activeTexture(b.TEXTURE0),b.bindTexture(b.TEXTURE_2D,this.textureSf),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE),a.setUniform(b,"1i",a.getUniformLocation(b,this.GLShaderProgram,"TEXTURE"),0),a.setUniform(b,"1i",a.getUniformLocation(b,this.GLShaderProgram,"xpass"),0),b.bindFramebuffer(b.FRAMEBUFFER,this.frameBuffer),b.clear(b.DEPTH_BUFFER_BIT|b.COLOR_BUFFER_BIT|b.STENCIL_BUFFER_BIT),b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,this.GLfaces),b.drawElements(b.TRIANGLES,this.GLfaces.numItems,b.UNSIGNED_SHORT,0),b.bindTexture(b.TEXTURE_2D,null),b.bindFramebuffer(b.FRAMEBUFFER,null)}}}(GLGE),function(a){a.FOG_NONE=1,a.FOG_LINEAR=2,a.FOG_QUADRATIC=3,a.FOG_SKYLINEAR=4,a.FOG_SKYQUADRATIC=5,a.Scene=function(b){a.Group.call(this),this.children=[],this.camera=new a.Camera,this.backgroundColor={r:1,g:1,b:1,a:1},this.ambientColor={r:0,g:0,b:0},this.fogColor={r:.5,g:.5,b:.5},this.passes=[],a.Assets.registerAsset(this,b)},a.augment(a.Group,a.Scene),a.Scene.prototype.camera=null,a.Scene.prototype.className="Scene",a.Scene.prototype.renderer=null,a.Scene.prototype.backgroundColor=null,a.Scene.prototype.filter=null,a.Scene.prototype.fogColor=null,a.Scene.prototype.ambientColor=null,a.Scene.prototype.fogNear=10,a.Scene.prototype.fogFar=80,a.Scene.prototype.fogType=a.FOG_NONE,a.Scene.prototype.passes=null,a.Scene.prototype.transbuffer=null,a.Scene.prototype.culling=!0,a.Scene.prototype.getFogType=function(){return this.fogType},a.Scene.prototype.setFogType=function(a){this.fogType=a;return this},a.Scene.prototype.getFogFar=function(){return this.fogFar},a.Scene.prototype.setFogFar=function(a){this.fogFar=a;return this},a.Scene.prototype.getFogNear=function(){return this.fogNear},a.Scene.prototype.setFogNear=function(a){this.fogNear=a;return this},a.Scene.prototype.getFogColor=function(){return this.fogColor},a.Scene.prototype.setFogColor=function(b){b=a.colorParse(b),this.fogColor={r:b.r,g:b.g,b:b.b};return this},a.Scene.prototype.getBackgroundColor=function(){return this.backgroundColor},a.Scene.prototype.setBackgroundColor=function(b){b=a.colorParse(b),this.backgroundColor={r:b.r,g:b.g,b:b.b,a:b.a};return this},a.Scene.prototype.getAmbientColor=function(){return this.ambientColor},a.Scene.prototype.setAmbientColor=function(b){b=a.colorParse(b),this.ambientColor={r:b.r,g:b.g,b:b.b},this.renderer&&this.renderer.gl.clearColor(this.backgroundColor.r,this.backgroundColor.g,this.backgroundColor.b,1);return this},a.Scene.prototype.setAmbientColorR=function(a){this.ambientColor.r=a;return this},a.Scene.prototype.setAmbientColorG=function(a){this.ambientColor.g=a;return this},a.Scene.prototype.setAmbientColorB=function(a){this.ambientColor.b=a;return this},a.Scene.prototype.setCamera=function(b){typeof b=="string"&&(b=a.Assets.get(b)),this.camera=b;return this},a.Scene.prototype.getCamera=function(){return this.camera},a.Scene.prototype.setCull=function(a){this.culling=a;return this},a.Scene.prototype.getCull=function(){return this.culling},a.Scene.prototype.GLInit=function(a){this.gl=a,a.lights=this.getLights(),this.camera.setAspect(this.renderer.canvas.width/this.renderer.canvas.height),this.renderer.gl.clearColor(this.backgroundColor.r,this.backgroundColor.g,this.backgroundColor.b,1);for(var b=0;b<this.children;b++)this.children[b].GLInit&&children[b].GLInit(a)},a.Scene.prototype.GLDestroy=function(a){},a.Scene.sortFunc=function(a,b){return a.zdepth-b.zdepth},a.Scene.prototype.zSort=function(b,c){var d=b.scene.camera.getViewMatrix(),e;for(var f=0;f<c.length;f++){if(c[f].object.getBoundingVolume)var g=c[f].object.getBoundingVolume().getCenter();else var h=c[f].object.getModelMatrix(),g=[h[3],h[7],h[11]];c[f].zdepth=g[0]*d[8]+g[1]*d[9]+g[2]*d[10]+d[11],c[f].object.zDepth&&(c[f].zdepth=c[f].object.zDepth)}c.sort(a.Scene.sortFunc);return c},a.Scene.prototype.setFilter2d=function(a){this.filter=a;return this},a.Scene.prototype.getFilter2d=function(a){return this.filter},a.Scene.prototype.setSkyFilter=function(a){this.skyfilter=a;return this},a.Scene.prototype.getSkyFilter=function(a){return this.skyfilter},a.Scene.prototype.getFrameBuffer=function(a){if(this.filter)return this.filter.getFrameBuffer(a);return null},a.Scene.prototype.objectsInViewFrustum=function(b,c){var d,e=[],f=a.cameraViewProjectionToPlanes(c);for(var g=0;g<b.length;g++){d=b[g];if(d.getBoundingVolume&&d.cull){var h=d.getBoundingVolume(),i=h.getCenter(),j=h.getSphereRadius();if(a.sphereInFrustumPlanes([i[0],i[1],i[2],j],f)){var k=h.getCornerPoints();a.pointsInFrustumPlanes(k,f)?(e.push(d),d.culled&&d.fireEvent("willRender",{}),d.culled=!1):(d.culled||d.fireEvent("willCull",{}),d.culled=!0)}else d.culled||d.fireEvent("willCull",{}),d.culled=!0}else e.push(d)}return e},a.Scene.prototype.unfoldRenderObject=function(a){var b=[];for(var c=0;c<a.length;c++){var d=a[c];if(d.getMultiMaterials){var e=d.getMultiMaterials();for(var f=0;f<e.length;f++){var g=e[f].getMaterial(),h=e[f].getMesh();g.meshIdx||(g.matIdx=f),g.meshIdx||(g.meshIdx=f),b.push({object:d,multiMaterial:f})}}else b.push({object:d,multiMaterial:0})}return b},a.Scene.prototype.stateSort=function(a,b){if(!a.object.GLShaderProgram)return 1;if(!b.object.GLShaderProgram)return-1;var c=a.object.GLShaderProgram.progIdx,d=b.object.GLShaderProgram.progIdx;if(c>d)return 1;if(c<d)return-1;if(!a.object.multimaterials||!b.object.multimaterials)return-1;var c=a.object.multimaterials[a.multiMaterial].getMaterial().matIdx,d=b.object.multimaterials[b.multiMaterial].getMaterial().matIdx;if(c>d)return 1;if(c<d)return-1;var e=a.object.multimaterials[a.multiMaterial].getMesh(),f=a.object.multimaterials[a.multiMaterial].getMesh();if(!e)return-1;if(!f)return 1;var c=e.meshIdx,d=f.meshIdx;return c>d?1:c<d?-1:0},a.Scene.prototype.createSkyBuffer=function(a){this.skyTexture=a.createTexture(),a.bindTexture(a.TEXTURE_2D,this.skyTexture),a.texImage2D(a.TEXTURE_2D,0,a.RGB,this.renderer.canvas.width,this.renderer.canvas.height,0,a.RGB,a.UNSIGNED_BYTE,null)},a.Scene.prototype.render=function(b){this.animate(),this.camera.lookAt&&this.camera.Lookat(this.camera.lookAt),b.lights=this.getLights();var c=b.lights;b.scene=this,this.lastMaterial=null,b.disable(b.BLEND),this.framebuffer=this.getFrameBuffer(b);var d=this.getObjects(),e=this.camera.getViewProjection();if(this.culling){var e=this.camera.getViewProjection();d=this.objectsInViewFrustum(d,e)}d=this.unfoldRenderObject(d),d=d.sort(this.stateSort);for(var f=0;f<c.length;f++)if(c[f].castShadows){c[f].gl||c[f].GLInit(b);var g=this.camera.matrix,h=this.camera.getProjectionMatrix(),i=0;if(c[f].getType()==a.L_DIR){var j=c[f].getModelMatrix(),k=a.inverseMat4(g);j[3]=j[2]*c[f].distance/2+k[3],j[7]=j[6]*c[f].distance/2+k[7],j[11]=j[10]*c[f].distance/2+k[11],c[f].matrix=j;var l=a.mulMat4Vec4(h,[0,0,c[f].distance,1]);i=l[3]/l[2]}b.bindFramebuffer(b.FRAMEBUFFER,c[f].frameBuffer),c[f].s_cache||(c[f].s_cache={}),c[f].s_cache.imvmatrix=a.inverseMat4(c[f].getModelMatrix()),c[f].s_cache.mvmatrix=c[f].getModelMatrix(),c[f].s_cache.pmatrix=c[f].getPMatrix(e,c[f].s_cache.imvmatrix,i,this.camera.far/2,this.camera),c[f].s_cache.smatrix=a.mulMat4(c[f].s_cache.pmatrix,c[f].s_cache.imvmatrix),c[f].shadowRendered=!1,b.viewport(0,0,parseFloat(c[f].bufferWidth),parseFloat(c[f].bufferHeight)),b.clearDepth(1),b.clearColor(1,1,1,1),b.clear(b.COLOR_BUFFER_BIT|b.DEPTH_BUFFER_BIT);var m=parseFloat(c[f].bufferHeight),n=parseFloat(c[f].bufferWidth);b.viewport(0,0,n,m),this.camera.setProjectionMatrix(c[f].s_cache.pmatrix),this.camera.matrix=c[f].s_cache.imvmatrix;for(var o=0;o<d.length;o++){if(d[o].object.getCastShadows&&!d[o].object.getCastShadows())continue;if(d[o].object.className=="ParticleSystem")continue;c[f].getType()==a.L_SPOT?d[o].object.GLRender(b,a.RENDER_SHADOW,o,d[o].multiMaterial,c[f].distance):d[o].object.GLRender(b,a.RENDER_DEPTH,o,d[o].multiMaterial,c[f].distance)}c[f].s_cache.smatrix=a.mulMat4(c[f].s_cache.pmatrix,c[f].s_cache.imvmatrix),c[f].GLRenderSoft(b),this.camera.matrix=null,this.camera.setProjectionMatrix(h)}if(this.culling){var e=this.camera.getViewProjection();d=this.objectsInViewFrustum(d,e)}b.bindFramebuffer(b.FRAMEBUFFER,this.framebuffer),this.camera.animation&&this.camera.animate(),this.getPasses(b,d);var g=this.camera.matrix,h=this.camera.getProjectionMatrix();this.allowPasses=!1;while(this.passes.length>0){var p=this.passes.pop();b.bindFramebuffer(b.FRAMEBUFFER,p.frameBuffer),this.camera.matrix=p.cameraMatrix,this.camera.setProjectionMatrix(p.projectionMatrix),this.mirror=p.mirror,this.renderPass(b,d,0,0,p.width,p.height,a.RENDER_DEFAULT,p.self)}this.mirror=!1,this.camera.matrix=g,this.camera.setProjectionMatrix(h),b.bindFramebuffer(b.FRAMEBUFFER,this.filter?this.framebuffer:this.transbuffer),this.renderPass(b,d,this.renderer.getViewportOffsetX(),this.renderer.getViewportOffsetY(),this.renderer.getViewportWidth(),this.renderer.getViewportHeight()),this.applyFilter(b,d,this.transbuffer),this.allowPasses=!0},a.Scene.prototype.getPasses=function(b,c){for(var d=0;d<c.length;d++)c[d].object.GLRender(b,a.RENDER_NULL,0,c[d].multiMaterial)},a.Scene.prototype.renderPass=function(b,c,d,e,f,g,h,i){b.clearDepth(1),b.depthFunc(b.LEQUAL),b.viewport(d,e,f,g),b.clearColor(this.backgroundColor.r,this.backgroundColor.g,this.backgroundColor.b,this.backgroundColor.a),b.clear(b.DEPTH_BUFFER_BIT|b.COLOR_BUFFER_BIT|b.STENCIL_BUFFER_BIT),h||(h=a.RENDER_DEFAULT);if(this.skyfilter&&h==a.RENDER_DEFAULT){this.skyfilter.GLRender(b),b.clear(b.DEPTH_BUFFER_BIT);if(this.skyfilter&&this.fogType==a.FOG_SKYQUADRATIC||this.fogType==a.FOG_SKYLINEAR)this.skyTexture||this.createSkyBuffer(b),b.bindTexture(b.TEXTURE_2D,this.skyTexture),b.copyTexImage2D(b.TEXTURE_2D,0,b.RGB,0,0,f,g,0)}var j=[];b.disable(b.BLEND);for(var k=0;k<c.length;k++)c[k].object.zTrans&&h==a.RENDER_DEFAULT||c[k].object==i?c[k].object!=i&&j.push(c[k]):c[k].object.GLRender(b,h,0,c[k].multiMaterial);b.enable(b.BLEND),j=this.zSort(b,j);for(var k=0;k<j.length;k++)j[k].object.blending&&(j[k].object.blending.length==4?b.blendFuncSeparate(b[j[k].object.blending[0]],b[j[k].object.blending[1]],b[j[k].object.blending[2]],b[j[k].object.blending[3]]):b.blendFunc(b[j[k].object.blending[0]],b[j[k].object.blending[1]])),j[k].object.depthTest===!1?b.disable(this.gl.DEPTH_TEST):b.enable(this.gl.DEPTH_TEST),c[k]!=i&&j[k].object.GLRender(b,h,0,j[k].multiMaterial)},a.Scene.prototype.applyFilter=function(b,c,d){this.filter&&this.filter.renderDepth&&(b.clearDepth(1),b.depthFunc(b.LEQUAL),b.bindFramebuffer(b.FRAMEBUFFER,this.filter.getDepthBuffer(b)),this.renderPass(b,c,0,0,this.filter.getDepthBufferWidth(),this.filter.getDepthBufferHeight(),a.RENDER_SHADOW)),this.filter&&this.filter.renderEmit&&(b.clearDepth(1),b.depthFunc(b.LEQUAL),b.bindFramebuffer(b.FRAMEBUFFER,this.filter.getEmitBuffer(b)),this.renderPass(b,c,0,0,this.filter.getEmitBufferWidth(),this.filter.getEmitBufferHeight(),a.RENDER_EMIT)),this.filter&&this.filter.renderNormal&&(b.clearDepth(1),b.depthFunc(b.LEQUAL),b.bindFramebuffer(b.FRAMEBUFFER,this.filter.getNormalBuffer(b)),this.renderPass(b,c,0,0,this.filter.getNormalBufferWidth(),this.filter.getNormalBufferHeight(),a.RENDER_NORMAL)),this.filter&&this.filter.GLRender(b,d)},a.Scene.prototype.addRenderPass=function(a,b,c,d,e,f,g){this.allowPasses&&this.passes.push({frameBuffer:a,cameraMatrix:b,projectionMatrix:c,height:e,width:d,self:f,mirror:g});return this},a.Scene.prototype.ray=function(b,c){var d=this.renderer.gl,e=this.camera.matrix,f=this.camera.pMatrix;this.camera.matrix=a.inverseMat4(a.Mat4([c[2],c[1],c[0],b[0],c[0],c[2],c[1],b[1],c[1],c[0],c[2],b[2],0,0,0,1])),this.pickPMatrix||(this.pickPMatrix=a.makeOrtho(-1e-4,1e-4,-1e-4,1e-4,this.camera.near,this.camera.far)),this.camera.pMatrix=this.pickPMatrix,d.viewport(0,0,8,1),d.clear(d.DEPTH_BUFFER_BIT),d.disable(d.BLEND),d.scene=this;var g=this.getObjects();for(var h=0;h<g.length;h++)g[h].pickable&&g[h].GLRender(d,a.RENDER_PICK,h+1);var i=new Uint8Array(32);d.readPixels(0,0,8,1,d.RGBA,d.UNSIGNED_BYTE,i);var j=[i[4]/255,i[5]/255,i[6]/255],k=Math.sqrt(j[0]*j[0]+j[1]*j[1]+j[2]*j[2])*.5;j=[j[0]/k-1,j[1]/k-1,j[2]/k-1];var l=g[i[0]+i[1]*256+i[2]*65536-1],m=(i[10]/255+.00390625*i[9]/255+152587890625e-16*i[8]/255)*this.camera.far,n=[];n[0]=i[14]/255+.00390625*i[13]/255+152587890625e-16*i[12]/255,n[1]=i[18]/255+.00390625*i[17]/255+152587890625e-16*i[16]/255,d.bindFramebuffer(d.FRAMEBUFFER,null),d.viewport(0,0,this.renderer.canvas.width,this.renderer.canvas.height),this.camera.matrix=e,this.camera.pMatrix=f;if(l)return{object:l,distance:m,coord:[b[0]-c[0]*m,b[1]-c[1]*m,b[2]-c[2]*m],normal:j,texture:n};return null},a.Scene.prototype.pick=function(a,b){var c=this.makeRay(a,b);if(!c)return null;return this.ray(c.origin,c.coord)},a.Scene.prototype.makeRay=function(b,c){if(this.camera){if(this.camera.matrix&&this.camera.pMatrix){var d=this.renderer.canvas;b=b/d.offsetWidth*d.width,c=c/d.offsetHeight*d.height;var e=this.renderer.getViewportHeight(),f=this.renderer.getViewportWidth(),g=this.renderer.getViewportOffsetX(),h=this.renderer.getViewportHeight()-this.renderer.canvas.height+this.renderer.getViewportOffsetY(),i=((b-g)/f-.5)*2,j=-((c+h)/e-.5)*2,k=a.mulMat4(a.inverseMat4(this.camera.matrix),a.inverseMat4(this.camera.pMatrix)),l=a.mulMat4Vec4(k,[i,j,-1,1]);l=[l[0]/l[3],l[1]/l[3],l[2]/l[3]];var m=a.mulMat4Vec4(k,[i,j,1,1]);m=[-(m[0]/m[3]-l[0]),-(m[1]/m[3]-l[1]),-(m[2]/m[3]-l[2])],m=a.toUnitVec3(m);return{origin:l,coord:m}}return null}a.error("No camera set for picking");return null}}(GLGE),function(a){a.ParticleSystem=function(b){this.startTime=(new Date).getTime(),this.texture={},this.startMaxVelocity={x:0,y:0,z:0},this.startMinVelocity={x:0,y:0,z:0},this.startMaxAcceleration={x:0,y:0,z:0},this.endMaxAcceleration={x:0,y:0,z:0},this.startMinAcceleration={x:0,y:0,z:0},this.endMinAcceleration={x:0,y:0,z:0},this.startColor={r:0,g:0,b:0,a:1},this.endColor={r:0,g:0,b:0,a:1},a.Assets.registerAsset(this,b)},a.augment(a.Placeable,a.ParticleSystem),a.augment(a.Animatable,a.ParticleSystem),a.ParticleSystem.prototype.depthTest=!0,a.ParticleSystem.prototype.zTrans=!0,a.ParticleSystem.prototype.blending=["SRC_ALPHA","ONE_MINUS_SRC_ALPHA","SRC_ALPHA","ONE_MINUS_SRC_ALPHA"],a.ParticleSystem.prototype.setBlend=function(a){switch(a){case"ADD":this.blending=["SRC_ALPHA","ONE","SRC_ALPHA","ONE_MINUS_SRC_ALPHA"];break;case"MIX":this.blending=["SRC_ALPHA","ONE_MINUS_SRC_ALPHA","SRC_ALPHA","ONE_MINUS_SRC_ALPHA"]}return this},a.ParticleSystem.prototype.setBlending=function(a){this.blending=a;return this},a.ParticleSystem.prototype.getBlending=function(){return this.blending},a.ParticleSystem.prototype.setMaxVelX=function(a){this.startMaxVelocity.x=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMaxVelY=function(a){this.startMaxVelocity.y=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMaxVelZ=function(a){this.startMaxVelocity.z=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMaxVelocity=function(a,b,c){this.startMaxVelocity={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.attribute=null},a.ParticleSystem.prototype.setMinVelX=function(a){this.startMinVelocity.x=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMinVelY=function(a){this.startMinVelocity.y=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMinVelZ=function(a){this.startMinVelocity.z=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMinVelocity=function(a,b,c){this.startMinVelocity={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.attribute=null},a.ParticleSystem.prototype.setVelX=function(a){this.startMaxVelocity.x=parseFloat(a),this.startMinVelocity.x=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setVelY=function(a){this.startMaxVelocity.y=parseFloat(a),this.startMinVelocity.y=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setVelZ=function(a){this.startMaxVelocity.z=parseFloat(a),this.startMinVelocity.z=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setVelocity=function(a,b,c){this.startMaxVelocity={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.startMinVelocity={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.attribute=null},a.ParticleSystem.prototype.setMaxStartAccX=function(a){this.startMaxAcceleration.x=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMaxStartAccY=function(a){this.startMaxAcceleration.y=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMaxStartAccZ=function(a){this.startMaxAcceleration.z=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMaxStartAccelertaion=function(a,b,c){this.startMaxAcceleration={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.attribute=null},a.ParticleSystem.prototype.setMinStartAccX=function(a){this.startMinAcceleration.x=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMinStartAccY=function(a){this.startMinAcceleration.y=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMinStartAccZ=function(a){this.startMinAcceleration.z=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMinStartAccelertaion=function(a,b,c){this.startMinAcceleration={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.attribute=null},a.ParticleSystem.prototype.setStartAccX=function(a){this.startMaxAcceleration.x=parseFloat(a),this.startMinAcceleration.x=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setStartAccY=function(a){this.startMaxAcceleration.y=parseFloat(a),this.startMinAcceleration.y=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setStartAccZ=function(a){this.startMaxAcceleration.z=parseFloat(a),this.startMinAcceleration.z=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setStartAccelertaion=function(a,b,c){this.startMaxAcceleration={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.startMinAcceleration={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.attribute=null},a.ParticleSystem.prototype.setMaxEndAccX=function(a){this.endMaxAcceleration.x=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMaxEndAccY=function(a){this.endMaxAcceleration.y=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMaxEndAccZ=function(a){this.endMaxAcceleration.z=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMaxEndAccelertaion=function(a,b,c){this.endMaxAcceleration={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.attribute=null},a.ParticleSystem.prototype.setMinEndAccX=function(a){this.endMinAcceleration.x=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMinEndAccY=function(a){this.endMinAcceleration.y=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMinEndAccZ=function(a){this.endMinAcceleration.z=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMinEndAccelertaion=function(a,b,c){this.endMinAcceleration={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.attribute=null},a.ParticleSystem.prototype.setEndAccX=function(a){this.endMinAcceleration.x=parseFloat(a),this.endMaxAcceleration.x=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setEndAccY=function(a){this.endMinAcceleration.y=parseFloat(a),this.endMaxAcceleration.y=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setEndAccZ=function(a){this.endMinAcceleration.z=parseFloat(a),this.endMaxAcceleration.z=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setEndAccelertaion=function(a,b,c){this.endMinAcceleration={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.endMaxAcceleration={x:parseFloat(a),y:parseFloat(b),z:parseFloat(c)},this.attribute=null},a.ParticleSystem.prototype.setStartColor=function(b){var c=a.colorParse(b);this.startColor=c,this.attribute=null},a.ParticleSystem.prototype.setEndColor=function(b){var c=a.colorParse(b);this.endColor=c,this.attribute=null},a.ParticleSystem.prototype.setStartSize=function(a){this.startSize=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setEndSize=function(a){this.endSize=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setLifeTime=function(a){this.maxLifeTime=parseFloat(a),this.minLifeTime=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMaxLifeTime=function(a){this.maxLifeTime=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setMinLifeTime=function(a){this.minLifeTime=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.setNumParticles=function(a){this.numParticles=parseFloat(a),this.attribute=null},a.ParticleSystem.prototype.velocityFunction=function(a){return[(this.startMaxVelocity.x-this.startMinVelocity.x)*Math.random()+this.startMinVelocity.x,(this.startMaxVelocity.y-this.startMinVelocity.y)*Math.random()+this.startMinVelocity.y,(this.startMaxVelocity.z-this.startMinVelocity.z)*Math.random()+this.startMinVelocity.z]},a.ParticleSystem.prototype.accelerationFunction=function(a){return[[(this.startMaxAcceleration.x-this.startMinAcceleration.x)*Math.random()+this.startMinAcceleration.x,(this.startMaxAcceleration.y-this.startMinAcceleration.y)*Math.random()+this.startMinAcceleration.y,(this.startMaxAcceleration.z-this.startMinAcceleration.z)*Math.random()+this.startMinAcceleration.z],[(this.endMaxAcceleration.x-this.endMinAcceleration.x)*Math.random()+this.endMinAcceleration.x,(this.endMaxAcceleration.y-this.endMinAcceleration.y)*Math.random()+this.endMinAcceleration.y,(this.endMaxAcceleration.z-this.endMinAcceleration.z)*Math.random()+this.endMinAcceleration.z]]},a.ParticleSystem.prototype.colorFunction=function(a){return[[this.startColor.r,this.startColor.g,this.startColor.b,this.startColor.a],[this.endColor.r,this.endColor.g,this.endColor.b,this.endColor.a]]},a.ParticleSystem.prototype.positionFunction=function(a){return[0,0,0]},a.ParticleSystem.prototype.sizeFunction=function(a){return[this.startSize,this.endSize]},a.ParticleSystem.prototype.lifeTimeFunction=function(a){return(this.maxLifeTime-this.minLifeTime)*Math.random()+this.minLifeTime},a.ParticleSystem.prototype.minLifeTime=2e3,a.ParticleSystem.prototype.maxLifeTime=2e3,a.ParticleSystem.prototype.numParticles=200,a.ParticleSystem.prototype.startTime=0,a.ParticleSystem.prototype.startSize=0,a.ParticleSystem.prototype.endSize=1,a.ParticleSystem.prototype.toRender=!0,a.ParticleSystem.prototype.renderFirst=!0,a.ParticleSystem.prototype.className="ParticleSystem",a.ParticleSystem.prototype.zTrans=!0,a.ParticleSystem.prototype.velocity=null,a.ParticleSystem.prototype.loop=1,a.ParticleSystem.prototype.setVelocityFunction=function(a){this.velocityFunction=a,this.particles=null},a.ParticleSystem.prototype.setAccelerationFunction=function(a){this.accelerationFunction=a,this.particles=null},a.ParticleSystem.prototype.setPositionFunction=function(a){this.colorFunction=a,this.particles=null},a.ParticleSystem.prototype.setColorFunction=function(a){this.positionFunction=a,this.particles=null},a.ParticleSystem.prototype.setSizeFunction=function(a){this.sizeFunction=a,this.particles=null},a.ParticleSystem.prototype.generateParticles=function(a){var b=this.numParticles;this.attribute={initPos:[],initAcc:[],endAcc:[],initVel:[],initColor:[],endColor:[],sizeAndOffset:[]},this.faces=[];for(var c=0;c<b;c++){var d=this.positionFunction(c),e=this.velocityFunction(c),f=this.accelerationFunction(c),g=this.colorFunction(c),h=this.sizeFunction(c),i=this.lifeTimeFunction(c),j=Math.floor(Math.random()*i);for(var k=-1;k<=1;k=k+2)for(var l=-1;l<=1;l=l+2)this.attribute.initPos.push(parseFloat(d[0])+l,parseFloat(d[1])+k,parseFloat(d[2])),this.attribute.initAcc.push(f[0][0],f[0][1],f[0][2]),this.attribute.endAcc.push(f[1][0],f[1][1],f[1][2]),this.attribute.initVel.push(e[0],e[1],e[2]),this.attribute.initColor.push(g[0][0],g[0][1],g[0][2],g[0][3]),this.attribute.endColor.push(g[1][0],g[1][1],g[1][2],g[1][3]),this.attribute.sizeAndOffset.push(h[0],h[1],j,i)}for(var c=0;c<b;c=c+4)this.faces.push(0+c,1+c,2+c),this.faces.push(1+c,2+c,3+c);this.facesGL=a.createBuffer(),a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,this.facesGL),a.bufferData(a.ELEMENT_ARRAY_BUFFER,new Uint16Array(this.faces),a.STATIC_DRAW),this.facesGL.num=this.faces.length,this.attribute.initPosGL=this.createBuffer(a,this.attribute.initPos),this.attribute.initAccGL=this.createBuffer(a,this.attribute.initAcc),this.attribute.endAccGL=this.createBuffer(a,this.attribute.endAcc),this.attribute.initVelGL=this.createBuffer(a,this.attribute.initVel),this.attribute.initColorGL=this.createBuffer(a,this.attribute.initColor),this.attribute.endColorGL=this.createBuffer(a,this.attribute.endColor),this.attribute.sizeAndOffsetGL=this.createBuffer(a,this.attribute.sizeAndOffset)},a.ParticleSystem.prototype.setLoop=function(a){this.loop=a},a.ParticleSystem.prototype.reset=function(){this.startTime=(new Date).getTime()},a.ParticleSystem.prototype.generateProgram=function(b){var c=["attribute vec3 position;","attribute vec3 initVel;","attribute vec3 initAcc;","attribute vec3 endAcc;","attribute vec4 initColor;","attribute vec4 endColor;","attribute vec4 sizeTimeLife;","uniform float time;","uniform bool loop;","uniform mat4 mvMatrix;","uniform mat4 pMatrix;","varying vec2 UV;","varying vec4 color;","void main(){","UV = (position.xy+1.0)/2.0;","if((time>sizeTimeLife[2] && (time-sizeTimeLife[2])<sizeTimeLife[3]) || loop){","float localTime = mod((time - sizeTimeLife[2]), sizeTimeLife[3]);","color = (endColor-initColor)/sizeTimeLife[3]*localTime+initColor;","float size = (sizeTimeLife[1]-sizeTimeLife[0])/sizeTimeLife[3]*localTime+sizeTimeLife[0];","vec3 pos = (endAcc-initAcc)*(localTime*log(localTime)-localTime)+0.5*initAcc*localTime*localTime+initVel*localTime;","pos = (mvMatrix*vec4(pos,1.0)).xyz;","vec3 positions = pos+(position*size);","gl_Position = pMatrix*vec4(positions,1.0);","}else{","gl_Position = vec4(0.0,0.0,0.0,1.0);","}","}"].join("");frgShader=["#ifdef GL_ES\nprecision highp float;\n#endif\n","uniform sampler2D texture;","varying vec2 UV;","varying vec4 color;","void main(){","gl_FragColor=texture2D(texture,UV)*color;","}"].join("");var d=b.createShader(b.VERTEX_SHADER),e=b.createShader(b.FRAGMENT_SHADER);b.shaderSource(d,c),b.compileShader(d);if(b.getShaderParameter(d,b.COMPILE_STATUS)){b.shaderSource(e,frgShader),b.compileShader(e);if(!b.getShaderParameter(e,b.COMPILE_STATUS)){a.error(b.getShaderInfoLog(e));return}this.program&&b.deleteProgram(this.Program),this.program=b.createProgram(),b.attachShader(this.program,d),b.attachShader(this.program,e),b.linkProgram(this.program)}else a.error(b.getShaderInfoLog(d))},a.ParticleSystem.prototype.createBuffer=function(a,b){var c=a.createBuffer();a.bindBuffer(a.ARRAY_BUFFER,c),a.bufferData(a.ARRAY_BUFFER,new Float32Array(b),a.STATIC_DRAW);return c},a.ParticleSystem.prototype.setUniforms=function(b){var c=this.program;c.glarrays||(c.glarrays={});var d=b.scene.camera.getViewMatrix(),e=this.getPosition(),f=a.mulMat4(d,[1,0,0,e.x,0,1,0,e.y,0,0,1,e.z,0,0,0,1]),g=a.getUniformLocation(b,c,"mvMatrix");c.glarrays.mvMatrix?a.mat4gl(f,c.glarrays.mvMatrix):c.glarrays.mvMatrix=new Float32Array(f),b.uniformMatrix4fv(g,!0,c.glarrays.mvMatrix);var h=a.getUniformLocation(b,c,"pMatrix");c.glarrays.pMatrix?a.mat4gl(b.scene.camera.getProjectionMatrix(),c.glarrays.pMatrix):c.glarrays.pMatrix=new Float32Array(b.scene.camera.getProjectionMatrix()),b.uniformMatrix4fv(h,!0,c.glarrays.pMatrix),b.uniform1f(a.getUniformLocation(b,c,"time"),(new Date).getTime()-this.startTime),b.uniform1i(a.getUniformLocation(b,c,"loop"),this.loop),b.activeTexture(b.TEXTURE0),this.glTexture||(this.glTexture=b.createTexture()),this.texture.state==1&&(b.bindTexture(b.TEXTURE_2D,this.glTexture),b.texImage2D(b.TEXTURE_2D,0,b.RGBA,b.RGBA,b.UNSIGNED_BYTE,this.texture.image),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.LINEAR_MIPMAP_LINEAR),b.generateMipmap(b.TEXTURE_2D),b.bindTexture(b.TEXTURE_2D,null),this.texture.state=2,c.texture=!0),b.bindTexture(b.TEXTURE_2D,this.glTexture),c.texture&&b.uniform1i(a.getUniformLocation(b,c,"texture"),0)},a.ParticleSystem.prototype.setImage=function(a){var b=this.texture;b.image=new Image,b.image.onload=function(a){b.state=1},b.image.src=a},a.ParticleSystem.prototype.setAttributes=function(b){for(var c=0;c<8;c++)b.disableVertexAttribArray(c);var d=a.getAttribLocation(b,this.program,"position");d>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.attribute.initPosGL),b.enableVertexAttribArray(d),b.vertexAttribPointer(d,3,b.FLOAT,!1,0,0));var d=a.getAttribLocation(b,this.program,"initAcc");d>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.attribute.initAccGL),b.enableVertexAttribArray(d),b.vertexAttribPointer(d,3,b.FLOAT,!1,0,0));var d=a.getAttribLocation(b,this.program,"endAcc");d>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.attribute.endAccGL),b.enableVertexAttribArray(d),b.vertexAttribPointer(d,3,b.FLOAT,!1,0,0));var d=a.getAttribLocation(b,this.program,"initColor");d>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.attribute.initColorGL),b.enableVertexAttribArray(d),b.vertexAttribPointer(d,4,b.FLOAT,!1,0,0));var d=a.getAttribLocation(b,this.program,"endColor");d>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.attribute.endColorGL),b.enableVertexAttribArray(d),b.vertexAttribPointer(d,4,b.FLOAT,!1,0,0));var d=a.getAttribLocation(b,this.program,"sizeTimeLife");d>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.attribute.sizeAndOffsetGL),b.enableVertexAttribArray(d),b.vertexAttribPointer(d,4,b.FLOAT,!1,0,0));var d=a.getAttribLocation(b,this.program,"initVel");d>-1&&(b.bindBuffer(b.ARRAY_BUFFER,this.attribute.initVelGL),b.enableVertexAttribArray(d),b.vertexAttribPointer(d,3,b.FLOAT,!1,0,0))},a.ParticleSystem.prototype.GLRender=function(a){this.attribute||this.generateParticles(a),this.program||this.generateProgram(a),a.program=this.program,a.useProgram(this.program),this.setAttributes(a),this.setUniforms(a),a.depthMask(!1),a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,this.facesGL),a.drawElements(a.TRIANGLES,this.facesGL.num,a.UNSIGNED_SHORT,0),a.depthMask(!0),a.scene.lastMaterial=null},a.Scene.prototype.addParticleSystem=a.Scene.prototype.addGroup,a.Group.prototype.addParticleSystem=a.Group.prototype.addGroup}(GLGE),function(a){a.MD2=function(b){this.MD2Started=+(new Date),this.setAnimation(new a.AnimationVector),a.Object.call(this,b)},a.augment(a.Object,a.MD2),a.MD2.prototype.loadingCache={},a.MD2.prototype.headersCache={},a.MD2.prototype.meshCache={},a.MD2.prototype.MD2Animations={},a.MD2.prototype.MD2StartFrame=0,a.MD2.prototype.MD2EndFrame=0,a.MD2.prototype.MD2Loop=!0,a.MD2.prototype.MD2AnimFinished=!1,a.MD2.prototype.headerNames=["ident","version","skinwidth","skinheight","framesize","num_skins","num_xyz","num_st","num_tris","num_glcmds","num_frames","ofs_skins","ofs_st","ofs_tris","ofs_frames","ofs_glcmds","ofs_end"],a.MD2.prototype.preNormals=[[-.525731,0,.850651],[-.442863,.238856,.864188],[-.295242,0,.955423],[-.309017,.5,.809017],[-.16246,.262866,.951056],[0,0,1],[0,.850651,.525731],[-.147621,.716567,.681718],[.147621,.716567,.681718],[0,.525731,.850651],[.309017,.5,.809017],[.525731,0,.850651],[.295242,0,.955423],[.442863,.238856,.864188],[.16246,.262866,.951056],[-.681718,.147621,.716567],[-.809017,.309017,.5],[-.587785,.425325,.688191],[-.850651,.525731,0],[-.864188,.442863,.238856],[-.716567,.681718,.147621],[-.688191,.587785,.425325],[-.5,.809017,.309017],[-.238856,.864188,.442863],[-.425325,.688191,.587785],[-.716567,.681718,-.147621],[-.5,.809017,-.309017],[-.525731,.850651,0],[0,.850651,-.525731],[-.238856,.864188,-.442863],[0,.955423,-.295242],[-.262866,.951056,-.16246],[0,1,0],[0,.955423,.295242],[-.262866,.951056,.16246],[.238856,.864188,.442863],[.262866,.951056,.16246],[.5,.809017,.309017],[.238856,.864188,-.442863],[.262866,.951056,-.16246],[.5,.809017,-.309017],[.850651,.525731,0],[.716567,.681718,.147621],[.716567,.681718,-.147621],[.525731,.850651,0],[.425325,.688191,.587785],[.864188,.442863,.238856],[.688191,.587785,.425325],[.809017,.309017,.5],[.681718,.147621,.716567],[.587785,.425325,.688191],[.955423,.295242,0],[1,0,0],[.951056,.16246,.262866],[.850651,-.525731,0],[.955423,-.295242,0],[.864188,-.442863,.238856],[.951056,-.16246,.262866],[.809017,-.309017,.5],[.681718,-.147621,.716567],[.850651,0,.525731],[.864188,.442863,-.238856],[.809017,.309017,-.5],[.951056,.16246,-.262866],[.525731,0,-.850651],[.681718,.147621,-.716567],[.681718,-.147621,-.716567],[.850651,0,-.525731],[.809017,-.309017,-.5],[.864188,-.442863,-.238856],[.951056,-.16246,-.262866],[.147621,.716567,-.681718],[.309017,.5,-.809017],[.425325,.688191,-.587785],[.442863,.238856,-.864188],[.587785,.425325,-.688191],[.688191,.587785,-.425325],[-.147621,.716567,-.681718],[-.309017,.5,-.809017],[0,.525731,-.850651],[-.525731,0,-.850651],[-.442863,.238856,-.864188],[-.295242,0,-.955423],[-.16246,.262866,-.951056],[0,0,-1],[.295242,0,-.955423],[.16246,.262866,-.951056],[-.442863,-.238856,-.864188],[-.309017,-.5,-.809017],[-.16246,-.262866,-.951056],[0,-.850651,-.525731],[-.147621,-.716567,-.681718],[.147621,-.716567,-.681718],[0,-.525731,-.850651],[.309017,-.5,-.809017],[.442863,-.238856,-.864188],[.16246,-.262866,-.951056],[.238856,-.864188,-.442863],[.5,-.809017,-.309017],[.425325,-.688191,-.587785],[.716567,-.681718,-.147621],[.688191,-.587785,-.425325],[.587785,-.425325,-.688191],[0,-.955423,-.295242],[0,-1,0],[.262866,-.951056,-.16246],[0,-.850651,.525731],[0,-.955423,.295242],[.238856,-.864188,.442863],[.262866,-.951056,.16246],[.5,-.809017,.309017],[.716567,-.681718,.147621],[.525731,-.850651,0],[-.238856,-.864188,-.442863],[-.5,-.809017,-.309017],[-.262866,-.951056,-.16246],[-.850651,-.525731,0],[-.716567,-.681718,-.147621],[-.716567,-.681718,.147621],[-.525731,-.850651,0],[-.5,-.809017,.309017],[-.238856,-.864188,.442863],[-.262866,-.951056,.16246],[-.864188,-.442863,.238856],[-.809017,-.309017,.5],[-.688191,-.587785,.425325],[-.681718,-.147621,.716567],[-.442863,-.238856,.864188],[-.587785,-.425325,.688191],[-.309017,-.5,.809017],[-.147621,-.716567,.681718],[-.425325,-.688191,.587785],[-.16246,-.262866,.951056],[.442863,-.238856,.864188],[.16246,-.262866,.951056],[.309017,-.5,.809017],[.147621,-.716567,.681718],[0,-.525731,.850651],[.425325,-.688191,.587785],[.587785,-.425325,.688191],[.688191,-.587785,.425325],[-.955423,.295242,0],[-.951056,.16246,.262866],[-1,0,0],[-.850651,0,.525731],[-.955423,-.295242,0],[-.951056,-.16246,.262866],[-.864188,.442863,-.238856],[-.951056,.16246,-.262866],[-.809017,.309017,-.5],[-.864188,-.442863,-.238856],[-.951056,-.16246,-.262866],[-.809017,-.309017,-.5],[-.681718,.147621,-.716567],[-.681718,-.147621,-.716567],[-.850651,0,-.525731],[-.688191,.587785,-.425325],[-.587785,.425325,-.688191],[-.425325,.688191,-.587785],[-.425325,-.688191,-.587785],[-.587785,-.425325,-.688191],[-.688191,-.587785,-.425325]],a.MD2.prototype.MD2FrameRate=6,a.MD2.prototype.getAbsolutePath=function(a,b){if(a.substr(0,7)=="http://"||a.substr(0,7)=="file://"||a.substr(0,7)=="https://")return a;b||(b=window.location.href);if(b.indexOf("://")==-1)return b.slice(0,b.lastIndexOf("/"))+"/"+a;var c=b.split("/"),d=c[2],e=c[0],f=[];for(var g=3;g<c.length-1;g++)f.push(c[g]);a.substr(0,1)=="/"&&(f=[]);var h=a.split("/");for(var g=0;g<h.length;g++)h[g]==".."?f.pop():h[g]!=""&&f.push(h[g]);return e+"//"+d+"/"+f.join("/")},a.MD2.prototype.setMD2FrameRate=function(a){this.MD2FrameRate=a;return this},a.MD2.prototype.setAutoTangents=function(a){this.doTangents=a;return this},a.MD2.prototype.setMD2Animation=function(a,b){this.MD2Anim=a,this.MD2AnimFinished=!1,b!=undefined&&(this.MD2Loop=b),this.MD2Started=+(new Date);if(this.MD2Animations[this.url]&&this.MD2Animations[this.url][a]){this.MD2LastAnimFrame=this.lastMD2Frame;var c=this.MD2Animations[this.url][a];this.MD2StartFrame=c[0],this.MD2EndFrame=c[1]}return this},a.MD2.prototype.getAnimations=function(){var a=[];for(var b in this.MD2Animations[this.url])a.push(b);return a},a.MD2.prototype.setMD2Frame=function(a){var b=this.MD2EndFrame-this.MD2StartFrame+1;if(b!=1){if(this.MD2Loop){a=a%b;var c=(Math.floor(a)+1)%b}else a=Math.min(b-1,a),c=Math.min(b-1,Math.floor(a)+1),a==b-1&&!this.MD2AnimFinished&&(this.MD2AnimFinished=!0,this.fireEvent("md2AnimFinished",{}));var d=a%1;a<1&&this.MD2LastAnimFrame!=undefined?a=this.MD2LastAnimFrame-this.MD2StartFrame:(this.MD2LastAnimFrame=null,this.lastMD2Frame=Math.floor(a)+this.MD2StartFrame),this.setMeshFrame1(Math.floor(a)+this.MD2StartFrame),this.setMeshFrame2(c+this.MD2StartFrame),this.setMeshBlendFactor(d)}},a.MD2.prototype.animate=function(b,c){b||(b=+(new Date));if(this.header){var d=(b-this.MD2Started)/1e3*this.MD2FrameRate;this.setMD2Frame(d)}a.Object.prototype.animate.call(this,b,c)},a.MD2.prototype.setSrc=function(a,b){b&&(a=this.getAbsolutePath(a,b)),this.url=a;if(this.loadingCache[this.url]&&!this.headersCache[a]){var c=this;setTimeout(function(){c.setSrc(a)},15)}else{this.loadingCache[this.url]=!0;if(this.headersCache[a]){this.header=this.headersCache[a],this.setMesh(this.meshCache[a]),this.MD2Anim&&this.setMD2Animation(this.MD2Anim),this.fireEvent("loaded",{url:this.url});return}var c=this,d=new XMLHttpRequest;d.overrideMimeType("text/plain; charset=x-user-defined"),d.open("GET",a,!0),d.send(null),this.verts=[],this.normals=[],d.onreadystatechange=function(a){if(d.readyState==4)if(d.status==200||d.status==0){response=d.responseText;if(response){var b=new ArrayBuffer(response.length),e=new Uint8Array(b),e=[];for(var f=0;f<response.length;f++)e[f]=response.charCodeAt(f)&255;c.bufferLoaded(e)}}else alert("Error loading page\n")}}},a.MD2.prototype.bufferLoaded=function(a){this.byteArray=a,this.parseHeader(),this.parseFrames(),this.parseUVs(),this.parseFaces(),this.MD2Anim&&this.setMD2Animation(this.MD2Anim,this.MD2Loop)},a.MD2.prototype.parseHeader=function(){this.header={};for(var a=0;a<this.headerNames.length;a++)this.header[this.headerNames[a]]=this.getUint16At(a*4);this.headersCache[this.url]=this.header},a.MD2.prototype.getUint16At=function(a){return this.byteArray[a]+this.byteArray[a+1]*256},a.MD2.prototype.getFloat32At=function(a){var b=this.byteArray[a],c=this.byteArray[a+1],d=this.byteArray[a+2],e=this.byteArray[a+3];sign=1-2*(e>>7),exponent=(e<<1&255|d>>7)-127,mantissa=(d&127)<<16|c<<8|b;if(mantissa==0&&exponent==-127)return 0;if(exponent==-127)return sign*mantissa*Math.pow(2,-126-23);return sign*(1+mantissa*Math.pow(2,-23))*Math.pow(2,exponent)},a.MD2.prototype.parseFrames=function(){var a=this.byteArray,b=0,c={};for(var d=0;d<this.header.num_frames;d++){var e=[this.getFloat32At(this.header.ofs_frames+d*this.header.framesize),this.getFloat32At(this.header.ofs_frames+4+d*this.header.framesize),this.getFloat32At(this.header.ofs_frames+8+d*this.header.framesize),this.getFloat32At(this.header.ofs_frames+12+d*this.header.framesize),this.getFloat32At(this.header.ofs_frames+16+d*this.header.framesize),this.getFloat32At(this.header.ofs_frames+20+d*this.header.framesize)],f=[],g=[],h=this.header.ofs_frames+24+d*this.header.framesize,i="";for(var j=h;j<h+16;j++){if(a[j]==0)break;i+=String.fromCharCode(a[j])}i=i.replace(/[0-9]/g,""),k&&i!=k&&(c[k]=[b,d-1],b=d);var k=i;h=this.header.ofs_frames+40+d*this.header.framesize;for(var j=h;j<h+this.header.framesize-40;j=j+12){f.push(a[j]*e[0]+e[3]),f.push(a[j+1]*e[1]+e[4]),f.push(a[j+2]*e[2]+e[5]),f.push(a[j+4]*e[0]+e[3]),f.push(a[j+5]*e[1]+e[4]),f.push(a[j+6]*e[2]+e[5]),f.push(a[j+8]*e[0]+e[3]),f.push(a[j+9]*e[1]+e[4]),f.push(a[j+10]*e[2]+e[5]);var l=this.preNormals[a[j+3]];l||(l=[0,0,1]),g.push(l[0]),g.push(l[1]),g.push(l[2]),l=this.preNormals[a[j+7]],l||(l=[0,0,1]),g.push(l[0]),g.push(l[1]),g.push(-l[2]),l=this.preNormals[a[j+11]],l||(l=[0,0,1]),g.push(l[0]),g.push(l[1]),g.push(l[2])}this.verts[d]=f,this.normals[d]=g}c[k]=[b,d-2],this.MD2Animations[this.url]=c},a.MD2.prototype.parseUVs=function(){var a=[],b=this.byteArray,c=this.header.ofs_st;for(var d=c;d<c+this.header.num_st*4;d=d+4)a.push(this.getUint16At(d)/this.header.skinwidth),a.push(1-this.getUint16At(d+2)/this.header.skinheight);this.globaluvs=a},a.MD2.prototype.parseFaces=function(){var a=this.header.ofs_tris,b=a+this.header.num_tris*12,c=[],d=[],e=[],f=[],g=0;for(var h=a;h<b;h=h+12){c.push(g++),c.push(g++),c.push(g++);var i=this.getUint16At(h),j=this.getUint16At(h+2),k=this.getUint16At(h+4);for(var l=0;l<this.verts.length;l++){e[l]||(e[l]=[],f[l]=[]);var m=this.verts[l],n=this.normals[l];e[l].push(m[i*3]),e[l].push(m[i*3+1]),e[l].push(m[i*3+2]),f[l].push(n[i*3]),f[l].push(n[i*3+1]),f[l].push(n[i*3+2]),e[l].push(m[j*3]),e[l].push(m[j*3+1]),e[l].push(m[j*3+2]),f[l].push(n[j*3]),f[l].push(n[j*3+1]),f[l].push(n[j*3+2]),e[l].push(m[k*3]),e[l].push(m[k*3+1]),e[l].push(m[k*3+2]),f[l].push(n[k*3]),f[l].push(n[k*3+1]),f[l].push(n[k*3+2])}d.push(this.globaluvs[this.getUint16At(h+6)*2]),d.push(this.globaluvs[this.getUint16At(h+6)*2+1]),d.push(this.globaluvs[this.getUint16At(h+8)*2]),d.push(this.globaluvs[this.getUint16At(h+8)*2+1]),d.push(this.globaluvs[this.getUint16At(h+10)*2]),d.push(this.globaluvs[this.getUint16At(h+10)*2+1])}this.normals=f,this.verts=e,this.uvs=d,this.faces=c,this.createMesh()},a.MD2.prototype.createMesh=function(){var b=new a.Mesh,c=this.verts,d=this.normals,e=this.uvs,f=this.faces;for(var g=0;g<c.length;g++)b.setPositions(c[g],g).setNormals(d[g],g);this.doTangents?b.setUV(e).setFaces(f):b.setFaces(f).setUV(e),this.setMesh(b),this.meshCache[this.url]=b,this.fireEvent("loaded",{url:this.url})},a.Group.prototype.addMD2=a.Group.prototype.addObject,a.Scene.prototype.addMD2=a.Scene.prototype.addObject}(GLGE),function(a){a.MD3=function(b){this.MD3Started=+(new Date),this.MD3Materials=[],this.surfaces=[],this.MD3Children=[],this.loaded=!1,this.setAnimation(new a.AnimationVector),a.Group.call(this,b)},a.augment(a.Group,a.MD3),a.MD3.prototype.MD3FrameRate=10,a.MD3.prototype.MD3Animations={},a.MD3.prototype.MD3Tags={},a.MD3.prototype.MD3StartFrame=0,a.MD3.prototype.MD3EndFrame=0,a.MD3.prototype.MD3Loop=!0,a.MD3.prototype.headerNames=["NUM_FRAMES","NUM_TAGS","NUM_SURFACES","NUM_SKINS","OFS_FRAMES","OFS_TAGS","OFS_SURFACES","OFS_EOF"],a.MD3.prototype.surfaceHeaderNames=["NUM_FRAMES","NUM_SHADERS","NUM_VERTS","NUM_TRIANGLES","OFS_TRIANGLES","OFS_SHADERS","OFS_ST","OFS_XYZNORMAL","OFS_END"],a.MD3.prototype.getAbsolutePath=function(a,b){if(a.substr(0,7)=="http://"||a.substr(0,7)=="file://"||a.substr(0,7)=="https://")return a;b||(b=window.location.href);if(b.indexOf("://")==-1)return b.slice(0,b.lastIndexOf("/"))+"/"+a;var c=b.split("/"),d=c[2],e=c[0],f=[];for(var g=3;g<c.length-1;g++)f.push(c[g]);a.substr(0,1)=="/"&&(f=[]);var h=a.split("/");for(var g=0;g<h.length;g++)h[g]==".."?f.pop():h[g]!=""&&f.push(h[g]);return e+"//"+d+"/"+f.join("/")},a.MD3.prototype.setSrc=function(a,b){b&&(a=this.getAbsolutePath(a,b)),this.url=a;var c=this,d=new XMLHttpRequest;d.overrideMimeType("text/plain; charset=x-user-defined"),d.open("GET",a,!0),d.send(null),this.verts=[],this.normals=[],d.onreadystatechange=function(a){if(d.readyState==4)if(d.status==200||d.status==0){response=d.responseText;if(response){var b=new ArrayBuffer(response.length),e=new Uint8Array(b),e=[];for(var f=0;f<response.length;f++)e[f]=response.charCodeAt(f)&255;c.bufferLoaded(e)}}else alert("Error loading page\n")}},a.MD3.prototype.setMD3FrameRate=function(a){this.MD3FrameRate=a;return this},a.MD3.prototype.setTag=function(a){this.MD3Tag=a;return this},a.MD3.prototype.bufferLoaded=function(a){this.byteArray=a,this.parseHeader(),this.parseFrames(),this.parseTags(),this.createTags(),this.parseSurfaces(),this.addSurfaces(),this.MD3Anim&&this.setMD3Animation(this.MD3Anim,this.MD3Loop),this.MD3Children.length>0&&this.addMD3Childred(),this.loaded=!0,this.fireEvent("loaded",{url:this.url})},a.MD3.prototype.addMD3Childred=function(){for(var a=0;a<this.MD3Children.length;a++)this.addMD3(this.MD3Children[a])},a.MD3.prototype.addSurfaces=function(){for(var a=0;a<this.surfaces.length;a++)this.MD3Tag&&(t=this.MD3Tags[this.url][this.MD3Tag],this.surfaces[a].setLocX(t[0][0]).setLocY(t[0][1]).setLocX(t[0][1]).setRotMatrix(t[1])),this.addObject(this.surfaces[a]);return this},a.MD3.prototype.getAnimations=function(){var a=[];for(var b in this.MD3Animations[this.url])a.push(b);return a},a.MD3.prototype.setMD3Animation=function(a,b){this.MD3Anim=a,b!=undefined&&(this.MD3Loop=b),this.MD3Started=+(new Date);if(this.MD3Animations[this.url]&&this.MD3Animations[this.url][a]){this.MD3LastAnimFrame=this.lastMD2Frame;var c=this.MD3Animations[this.url][a];this.MD3StartFrame=c[0],this.MD3EndFrame=c[1]}return this},a.MD3.prototype.createTags=function(){var b=this.MD3Tags[this.url];this.MD3TagGroups={};for(var c in b){var d=b[c],e=(new a.Group).setLocX(d[0][0]).setLocY(d[0][1]).setLocX(d[0][1]).setRotMatrix(d[1]);this.addGroup(e),this.MD3TagGroups[c]=e}},a.MD3.prototype.parseTags=function(){var a=this.headers.OFS_TAGS,b=112,c=this.MD3Tags[this.url]={};for(var d=0;d<this.headers.NUM_TAGS;d++){var e=this.getStringAt(a+d*b,64).replace(/[0-9_]/g,""),f=a+d*b+64,g=[this.getFloat32At(f)*10,this.getFloat32At(f+4)*10,this.getFloat32At(f+8)*10],h=f+12,i=[this.getFloat32At(h),this.getFloat32At(h+4),this.getFloat32At(h+8),0,this.getFloat32At(h+12),this.getFloat32At(h+16),this.getFloat32At(h+20),0,this.getFloat32At(h+24),this.getFloat32At(h+28),this.getFloat32At(h+32),0,0,0,0,1];c[e]=[g,i]}},a.MD3.prototype.parseFrames=function(){var a=this.headers.OFS_FRAMES+40,b=56,c={},d=!1,e=0;for(var f=0;f<this.headers.NUM_FRAMES;f++){var g=this.getStringAt(a+f*b,16).replace(/[0-9_]/g,"");d&&d!=g&&(c[d]=[e,f-1],e=f),d=g}c[d]=[e,f-3],this.MD3Animations[this.url]=c},a.MD3.prototype.parseHeader=function(){this.headers={};for(var a=0;a<this.headerNames.length;a++)this.headers[this.headerNames[a]]=this.getSint32At(a*4+76)},a.MD3.prototype.parseSurfaces=function(){this.surfaceHeaders=[];var b=this.headers.OFS_SURFACES;for(var c=0;c<this.headers.NUM_SURFACES;c++){var d=b+72,e=this.surfaceHeaders[c]={offset:b},f=0;for(var g=d;g<d+36;g=g+4)e[this.surfaceHeaderNames[f++]]=this.getSint32At(g);var h=this.parseNormVerts(c),i=this.parseUVs(c),j=this.parseFaces(c),k=this.createMesh(h[0],h[1],i,j),l=new a.Object;this.MD3Materials[c]||(this.MD3Materials[c]=new a.Material),l.setMaterial(this.MD3Materials[c]),l.setMesh(k),this.surfaces.push(l),b+=this.surfaceHeaders[c].OFS_END}},a.MD3.prototype.createMesh=function(b,c,d,e){var f=new a.Mesh;for(var g=0;g<b.length;g++)f.setPositions(b[g],g).setNormals(c[g],g);f.setFaces(e).setUV(d);return f},a.MD3.prototype.parseFaces=function(a){var b=this.surfaceHeaders[a],c=[],d=b.offset+b.OFS_TRIANGLES,e=12*b.NUM_TRIANGLES;for(var f=d;f<d+e;f=f+12)c.push(this.getSint32At(f)),c.push(this.getSint32At(f+4)),c.push(this.getSint32At(f+8));return c},a.MD3.prototype.parseUVs=function(a){var b=this.surfaceHeaders[a],c=[],d=b.offset+b.OFS_ST,e=8*b.NUM_VERTS;for(var f=d;f<d+e;f=f+8)c.push(this.getFloat32At(f)),c.push(1-this.getFloat32At(f+4));return c},a.MD3.prototype.parseNormVerts=function(a){var b=this.surfaceHeaders[a],c=[],d=[],e=b.offset+b.OFS_XYZNORMAL,f=8*b.NUM_VERTS;for(var g=0;g<b.NUM_FRAMES;g++){var h=[],i=[];for(var j=e+g*f;j<e+(g+1)*f;j=j+8){h.push(this.getSint16At(j)/64),h.push(this.getSint16At(j+2)/64),h.push(this.getSint16At(j+4)/64);var k=this.decodeNormal(this.byteArray[j+6],this.byteArray[j+7]);i.push(k[0]),i.push(k[1]),i.push(k[2])}c[g]=h,d[g]=i}return[c,d]},a.MD3.prototype.decodeNormal=function(a,b){var c=a*(2*Math.PI)/255,d=b*(2*Math.PI)/255,e=Math.cos(c),f=Math.sin(c),g=Math.cos(d),h=Math.sin(d);return[-e*h,-f*h,g]},a.MD3.prototype.getAttachPoints=function(){var a=[];for(var b in this.MD3TagGroups)a.push(b);return a},a.MD3.prototype.getSint16At=function(a){var b=this.byteArray[a]|this.byteArray[a+1]<<8;b>32768&&(b=b-65536);return b},a.MD3.prototype.getSint32At=function(a){var b=this.byteArray[a]|this.byteArray[a+1]<<8|this.byteArray[a+2]<<16|this.byteArray[a+3]<<24;b>2147483648&&(b=b-4294967296);return b},a.MD3.prototype.getFloat32At=function(a){var b=this.byteArray[a],c=this.byteArray[a+1],d=this.byteArray[a+2],e=this.byteArray[a+3];sign=1-2*(e>>7),exponent=(e<<1&255|d>>7)-127,mantissa=(d&127)<<16|c<<8|b;if(mantissa==0&&exponent==-127)return 0;if(exponent==-127)return sign*mantissa*Math.pow(2,-126-23);return sign*(1+mantissa*Math.pow(2,-23))*Math.pow(2,exponent)},a.MD3.prototype.getStringAt=function(a,b){var c="";for(var d=a;d<a+b;d++){if(this.byteArray[d]==0)break;c+=String.fromCharCode(this.byteArray[d])}return c},a.MD3.prototype.addMD3=function(a){{if(this.loaded){if(this.MD3TagGroups){var b=a.MD3Tag;b&&this.MD3TagGroups[b]?this.MD3TagGroups[b].addGroup(a):this.addGroup(a)}else this.MD3Children.push(a);return this}this.addEventListener("loaded",function(){this.addMD3(a)})}},a.MD3.prototype.setMD3Tag=function(a){this.MD3Tag=a;return this},a.MD3.prototype.setMD3Frame=function(a){var b=this.MD3EndFrame-this.MD3StartFrame;if(b!=0){if(this.MD3Loop){a=a%b;var c=(Math.floor(a)+1)%b}else a=Math.min(b,a),c=Math.min(b,Math.floor(a)+1),a==b&&this.fireEvent("md3AnimFinished",{});var d=a%1;a<1&&this.MD3LastAnimFrame?a=this.MD3LastAnimFrame-this.MD3StartFrame:(this.MD3LastAnimFrame=null,this.lastMD3Frame=Math.floor(a)+this.MD3StartFrame);for(var e=0;e<this.surfaces.length;e++)this.surfaces[e].setMeshFrame1(Math.floor(a)+this.MD3StartFrame),this.surfaces[e].setMeshFrame2(c+this.MD3StartFrame),this.surfaces[e].setMeshBlendFactor(d)}},a.MD3.prototype.animate=function(b,c){b||(b=+(new Date));if(this.headers){var d=(b-this.MD3Started)/1e3*this.MD3FrameRate;this.setMD3Frame(d)}a.Object.prototype.animate.call(this,b,c)},a.MD3.prototype.setMaterial=function(a,b){b||(b=0),this.MD3Materials[b]=a,this.surfaces[b]&&this.surfaces[b].setMaterial(a)};var b=function(a){return function(b){this.setMaterial(b,a)}};for(var c=1;c<32;c++)a.MD3.prototype["setMaterial"+c]=b(c);a.Group.prototype.addMD3=a.Group.prototype.addGroup,a.Scene.prototype.addMD3=a.Scene.prototype.addGroup}(GLGE),window.GLGE||(window.GLGE={}),function(a){a.FILTER_POST=0,a.FILTER_SKY=1,a.Filter2d=function(b){a.Assets.registerAsset(this,b)},a.augment(a.QuickNotation,a.Filter2d),a.Filter2d.prototype.renderDepth=!1,a.Filter2d.prototype.renderNormal=!1,a.Filter2d.prototype.renderEmit=!1,a.Filter2d.prototype.persist=!1,a.Filter2d.prototype.passes=null,a.Filter2d.prototype.textures=null,a.Filter2d.prototype.uniforms=null,a.Filter2d.prototype.buffers=null,a.Filter2d.prototype.filterType=a.FILTER_POST,a.Filter2d.prototype.depthBufferWidth=null,a.Filter2d.prototype.depthBufferHeight=null,a.Filter2d.prototype.emitBufferWidth=null,a.Filter2d.prototype.emitBufferHeight=null,a.Filter2d.prototype.normalBufferWidth=null,a.Filter2d.prototype.normalBufferHeight=null,a.Filter2d.prototype.setFilterType=function(a){this.filterType=a;return this},a.Filter2d.prototype.getFilterType=function(){return this.filterType},a.Filter2d.prototype.addTexture=function(a){this.textures||(this.textures=[]),this.textures.push(a)},a.Filter2d.prototype.removeTexture=function(a){var b=this.textures.indexOf(a);b>-1&&this.textures.splice(b,1)},a.Filter2d.prototype.createBuffer=function(a,b,c){b||(b=a.canvas.width),c||(c=a.canvas.height);var d=a.createFramebuffer(),e=a.createRenderbuffer(),f=a.createTexture();a.bindTexture(a.TEXTURE_2D,f);var g=new Uint8Array(b*c*4);a.texImage2D(a.TEXTURE_2D,0,a.RGBA,b,c,0,a.RGBA,a.UNSIGNED_BYTE,g),a.bindFramebuffer(a.FRAMEBUFFER,d),a.bindRenderbuffer(a.RENDERBUFFER,e),a.renderbufferStorage(a.RENDERBUFFER,a.DEPTH_COMPONENT16,b,c),a.framebufferRenderbuffer(a.FRAMEBUFFER,a.DEPTH_ATTACHMENT,a.RENDERBUFFER,e),a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_2D,f,0),a.bindRenderbuffer(a.RENDERBUFFER,null),a.bindFramebuffer(a.FRAMEBUFFER,null),a.bindTexture(a.TEXTURE_2D,null);return[d,e,f]},a.Filter2d.prototype.getFrameBuffer=function(a){if(!this.passes)return null;this.gl||(this.gl=a),this.buffers||(this.buffers=this.createBuffer(a));return this.buffers[0]},a.Filter2d.prototype.getEmitBuffer=function(a){if(!this.passes)return null;this.gl||(this.gl=a),this.emitBuffers||(this.emitBuffers=this.createBuffer(a,this.getEmitBufferWidth(),this.getEmitBufferHeight()));return this.emitBuffers[0]},a.Filter2d.prototype.setEmitBufferWidth=function(a){this.emitBufferWidth=a,this.emitBuffers=null},a.Filter2d.prototype.getEmitBufferWidth=function(){return this.emitBufferWidth?this.emitBufferWidth:this.gl.canvas.width},a.Filter2d.prototype.setEmitBufferHeight=function(a){this.emitBufferHeight=a,this.emitBuffers=null},a.Filter2d.prototype.getEmitBufferHeight=function(){return this.emitBufferHeight?this.emitBufferHeight:this.gl.canvas.height},a.Filter2d.prototype.getDepthBuffer=function(a){if(!this.passes)return null;this.gl||(this.gl=a),this.depthBuffers||(this.depthBuffers=this.createBuffer(a,this.getDepthBufferWidth(),this.getDepthBufferHeight()));return this.depthBuffers[0]},a.Filter2d.prototype.setDepthBufferWidth=function(a){this.depthBufferWidth=a,this.depthBuffers=null},a.Filter2d.prototype.getDepthBufferWidth=function(){return this.depthBufferWidth?this.depthBufferWidth:this.gl.canvas.width},a.Filter2d.prototype.setDepthBufferHeight=function(a){this.depthBufferHeight=a,this.depthBuffers=null},a.Filter2d.prototype.getDepthBufferHeight=function(){return this.depthBufferHeight?this.depthBufferHeight:this.gl.canvas.height},a.Filter2d.prototype.setNormalBufferWidth=function(a){this.normalBufferWidth=a,this.normalBuffers=null},a.Filter2d.prototype.getNormalBufferWidth=function(){return this.normalBufferWidth?this.normalBufferWidth:this.gl.canvas.width},a.Filter2d.prototype.setNormalBufferHeight=function(a){this.normalBufferHeight=a,this.normalBuffers=null},a.Filter2d.prototype.getNormalBufferHeight=function(){return this.normalBufferHeight?this.normalBufferHeight:this.gl.canvas.height},a.Filter2d.prototype.getNormalBuffer=function(a){this.gl||(this.gl=a),this.normalBuffers||(this.normalBuffers=this.createBuffer(a,this.getNormalBufferWidth(),this.getNormalBufferHeight()));return this.normalBuffers[0]},a.Filter2d.prototype.setUniform=function(a,b,c){this.uniforms||(this.uniforms={}),this.uniforms[b]={type:a,value:c}},a.Filter2d.prototype.getUniform=function(a){this.uniforms||(this.uniforms={});return this.uniforms[a].value},a.Filter2d.prototype.getUniformType=function(a){this.uniforms||(this.uniforms={});return this.uniforms[a].type},a.Filter2d.prototype.addPassFile=function(a){var b=new XMLHttpRequest,c=this;b&&(b.open("GET",a,!1),b.send(""),c.addPass(b.responseText))},a.Filter2d.prototype.addPass=function(a,b,c){this.passes||(this.passes=[]),this.passes.push({GLSL:a,height:c,width:b})},a.Filter2d.prototype.createPersistTexture=function(a){this.persistTexture=a.createTexture(),a.bindTexture(a.TEXTURE_2D,this.persistTexture),a.texImage2D(a.TEXTURE_2D,0,a.RGBA,a.canvas.width,a.canvas.height,0,a.RGBA,a.UNSIGNED_BYTE,null)},a.Filter2d.prototype.GLRender=function(b,c){b.disable(b.BLEND),c||(c=null);if(this.passes){for(var d=0;d<this.passes.length;d++){this.passes.length-1==d?b.bindFramebuffer(b.FRAMEBUFFER,c):(this.passes[d].buffer||(this.passes[d].buffer=this.createBuffer(b,this.passes[d].width,this.passes[d].height)),b.bindFramebuffer(b.FRAMEBUFFER,this.passes[d].buffer[0]));var e=this.passes[d].width?this.passes[d].width:b.canvas.width,f=this.passes[d].height?this.passes[d].height:b.canvas.height;b.viewport(0,0,e,f),b.clearDepth(1),b.depthFunc(b.LEQUAL),b.clearColor(0,0,0,0),b.clear(b.COLOR_BUFFER_BIT|b.DEPTH_BUFFER_BIT),this.passes[d].program||(this.passes[d].program=this.GLCreateShader(b,this.passes[d].GLSL)),b.useProgram(this.passes[d].program),b.program=this.passes[d].program;for(var g=0;g<8;g++)b.disableVertexAttribArray(g);attribslot=a.getAttribLocation(b,this.passes[d].program,"position"),this.posBuffer||this.createPlane(b),b.bindBuffer(b.ARRAY_BUFFER,this.posBuffer),b.enableVertexAttribArray(attribslot),b.vertexAttribPointer(attribslot,this.posBuffer.itemSize,b.FLOAT,!1,0,0),this.GLSetUniforms(b,d),b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,this.GLfaces),b.drawElements(b.TRIANGLES,this.GLfaces.numItems,b.UNSIGNED_SHORT,0)}this.persist&&(this.persistTexture||this.createPersistTexture(b),b.bindTexture(b.TEXTURE_2D,this.persistTexture),b.copyTexImage2D(b.TEXTURE_2D,0,b.RGBA,0,0,b.canvas.width,b.canvas.height,0))}},a.Filter2d.prototype.clearPersist=function(a){this.persistTexture||this.createPersistTexture(a),a.bindTexture(a.TEXTURE_2D,this.persistTexture),a.texImage2D(a.TEXTURE_2D,0,a.RGBA,a.canvas.width,a.canvas.height,0,a.RGBA,a.UNSIGNED_BYTE,null),a.bindTexture(a.TEXTURE_2D,null)};var b=new Float32Array(16);a.Filter2d.prototype.GLSetUniforms=function(c,d){if(this.filterType==a.FILTER_SKY){var e=a.transposeMat4(a.mulMat4(a.inverseMat4(c.scene.camera.matrix),a.inverseMat4(c.scene.camera.pMatrix)));a.mat4gl(e,b),a.setUniformMatrix(c,"Matrix4fv",a.getUniformLocation(c,this.passes[d].program,"invViewProj"),!1,b)}for(var f in this.uniforms){var g=this.uniforms[f];g.type=="Matrix4fv"?a.setUniformMatrix(c,"Matrix4fv",a.getUniformLocation(c,this.passes[d].program,f),!1,g.value):a.setUniform(c,g.type,a.getUniformLocation(c,this.passes[d].program,f),g.value)}var h=0;if(this.buffers){d==0&&(c.activeTexture(c["TEXTURE"+h]),c.bindTexture(c.TEXTURE_2D,this.buffers[2]),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE)),a.setUniform(c,"1i",a.getUniformLocation(c,this.passes[d].program,"GLGE_RENDER"),h),h++,this.persist&&(d==0&&(c.activeTexture(c["TEXTURE"+h]),c.bindTexture(c.TEXTURE_2D,this.persistTexture),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE)),a.setUniform(c,"1i",a.getUniformLocation(c,this.passes[d].program,"GLGE_PERSIST"),h),h++),this.renderDepth&&(d==0&&(c.activeTexture(c["TEXTURE"+h]),c.bindTexture(c.TEXTURE_2D,this.depthBuffers[2]),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE)),a.setUniform(c,"1i",a.getUniformLocation(c,this.passes[d].program,"GLGE_DEPTH"),h),h++),this.renderEmit&&(d==0&&(c.activeTexture(c["TEXTURE"+h]),c.bindTexture(c.TEXTURE_2D,this.emitBuffers[2]),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE)),a.setUniform(c,"1i",a.getUniformLocation(c,this.passes[d].program,"GLGE_EMIT"),h),h++),this.renderNormal&&(d==0&&(c.activeTexture(c["TEXTURE"+h]),c.bindTexture(c.TEXTURE_2D,this.normalBuffers[2]),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE)),a.setUniform(c,"1i",a.getUniformLocation(c,this.passes[d].program,"GLGE_NORMAL"),h),h++);for(var i=0;i<this.passes.length;i++)this.passes[i].buffer&&(c.activeTexture(c["TEXTURE"+h]),c.bindTexture(c.TEXTURE_2D,this.passes[i].buffer[2]),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MAG_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_MIN_FILTER,c.LINEAR),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_S,c.CLAMP_TO_EDGE),c.texParameteri(c.TEXTURE_2D,c.TEXTURE_WRAP_T,c.CLAMP_TO_EDGE)),a.setUniform(c,"1i",a.getUniformLocation(c,this.passes[d].program,"GLGE_PASS"+i),h),h++}this.textures||(this.textures=[]);for(var i=0;i<this.textures.length;i++){c.activeTexture(c["TEXTURE"+(i+h)]),this.textures[i].doTexture(c,null);var j="TEXTURE"+i;this.textures[i].name&&(j=this.textures[i].name),a.setUniform(c,"1i",a.getUniformLocation(c,this.passes[d].program,j),i+h)}},a.Filter2d.prototype.createPlane=function(a){this.posBuffer||(this.posBuffer=a.createBuffer()),a.bindBuffer(a.ARRAY_BUFFER,this.posBuffer),a.bufferData(a.ARRAY_BUFFER,new Float32Array([1,1,.5,-1,1,.5,-1,-1,.5,1,-1,.5]),a.STATIC_DRAW),this.posBuffer.itemSize=3,this.posBuffer.numItems=4,this.GLfaces||(this.GLfaces=a.createBuffer()),a.bindBuffer(a.ELEMENT_ARRAY_BUFFER,this.GLfaces),a.bufferData(a.ELEMENT_ARRAY_BUFFER,new Uint16Array([0,1,2,2,3,0]),a.STATIC_DRAW),this.GLfaces.itemSize=1,this.GLfaces.numItems=6},a.Filter2d.prototype.GLCreateShader=function(b,c){var d=[];d.push("uniform mat4 invViewProj;\n"),d.push("attribute vec3 position;\n"),d.push("varying vec2 texCoord;\n"),d.push("varying vec3 rayCoord;\n"),d.push("void main(void){\n"),d.push("vec4 near=invViewProj * vec4(position.xy,-1.0,1.0);\n"),d.push("near/=near.w;\n"),d.push("vec4 far=invViewProj * vec4(position.xy,1.0,1.0);\n"),d.push("far/=far.w;\n"),d.push("rayCoord=normalize(far.xyz-near.xyz);\n"),d.push("texCoord=(position.xy+vec2(1.0,1.0))/2.0;\n"),d.push("gl_Position = vec4(position.xyz,1.0);\n"),d.push("}\n");var e=a.getGLShader(b,b.VERTEX_SHADER,d.join("")),f=a.getGLShader(b,b.FRAGMENT_SHADER,c);return a.getGLProgram(b,e,f)}}(GLGE),function(a){a.FilterGlow=function(b){this.setEmitBufferWidth(256),this.setEmitBufferHeight(256),a.Assets.registerAsset(this,b)},a.augment(a.Filter2d,a.FilterGlow),a.FilterGlow.prototype.renderEmit=!0,a.FilterGlow.prototype.blur=1.2,a.FilterGlow.prototype.intensity=3,a.FilterGlow.prototype.fxaacutoff=2,a.FilterGlow.prototype.fxaastartintensity=0,a.FilterGlow.prototype.setEmitBufferWidth=function(b){a.Filter2d.prototype.setEmitBufferWidth.call(this,b),this.createPasses();return this},a.FilterGlow.prototype.setEmitBufferHeight=function(b){a.Filter2d.prototype.setEmitBufferHeight.call(this,b),this.createPasses();return this},a.FilterGlow.prototype.setBlur=function(a){this.blur=a,this.createPasses();return this},a.FilterGlow.prototype.setIntensity=function(a){this.intensity=a,this.createPasses();return this},a.FilterGlow.prototype.setFXAA=function(a){this.useFXAA=a,this.createPasses();return this},a.FilterGlow.prototype.setFXAACutoff=function(a){this.fxaacutoff=a,this.createPasses();return this},a.FilterGlow.prototype.setFXAAStartIntensity=function(a){this.fxaastartintensity=a,this.createPasses();return this},a.FilterGlow.prototype.createPasses=function(){var a=[];a.push("precision highp float;"),a.push("uniform sampler2D GLGE_EMIT;"),a.push("varying vec2 texCoord;"),a.push("float blurSize="+(1/this.emitBufferWidth*this.blur).toFixed(10)+";"),a.push("float rand(vec2 co){;"),a.push("return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);"),a.push("}"),a.push("void main(void){"),a.push("vec4 color=vec4(0.0,0.0,0.0,0.0);"),a.push("float rnd=1.0-rand(texCoord.xy)*4.0*blurSize;"),a.push("color += texture2D(GLGE_EMIT, vec2(texCoord.x - 4.0*blurSize, texCoord.y)) * 0.05 * rnd;"),a.push("color += texture2D(GLGE_EMIT, vec2(texCoord.x - 3.0*blurSize, texCoord.y)) * 0.09 * rnd;"),a.push("color += texture2D(GLGE_EMIT, vec2(texCoord.x - 2.0*blurSize, texCoord.y)) * 0.12 * rnd;"),a.push("color += texture2D(GLGE_EMIT, vec2(texCoord.x - blurSize, texCoord.y)) * 0.15 * rnd;"),a.push("color += texture2D(GLGE_EMIT, vec2(texCoord.x, texCoord.y)) * 0.18 * rnd;"),a.push("color += texture2D(GLGE_EMIT, vec2(texCoord.x + blurSize, texCoord.y)) * 0.15 * rnd;"),a.push("color += texture2D(GLGE_EMIT, vec2(texCoord.x + 2.0*blurSize, texCoord.y)) * 0.12 * rnd;"),a.push("color += texture2D(GLGE_EMIT, vec2(texCoord.x + 3.0*blurSize, texCoord.y)) * 0.09 * rnd;"),a.push("color += texture2D(GLGE_EMIT, vec2(texCoord.x + 4.0*blurSize, texCoord.y)) * 0.05 * rnd;"),a.push("gl_FragColor = vec4(color.rgb,1.0);"),a.push("}");var b=[];b.push("precision highp float;"),b.push("uniform sampler2D GLGE_PASS0;"),b.push("uniform sampler2D GLGE_RENDER;"),b.push("uniform sampler2D GLGE_EMIT;"),b.push("varying vec2 texCoord;"),b.push("float blurSize="+(1/this.emitBufferHeight*this.blur).toFixed(10)+";"),b.push("float rand(vec2 co){;"),b.push("return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);"),b.push("}"),b.push("void main(void){"),b.push("vec4 color=vec4(0.0,0.0,0.0,0.0);"),b.push("float rnd=1.0-rand(texCoord.xy)*4.0*blurSize;"),b.push("color += texture2D(GLGE_PASS0, vec2(texCoord.x, texCoord.y - 4.0*blurSize)) * 0.05 * rnd;"),b.push("color += texture2D(GLGE_PASS0, vec2(texCoord.x, texCoord.y - 3.0*blurSize)) * 0.09 * rnd;"),b.push("color += texture2D(GLGE_PASS0, vec2(texCoord.x, texCoord.y - 2.0*blurSize)) * 0.12 * rnd;"),b.push("color += texture2D(GLGE_PASS0, vec2(texCoord.x, texCoord.y - blurSize)) * 0.15 * rnd;"),b.push("color += texture2D(GLGE_PASS0, vec2(texCoord.x, texCoord.y)) * 0.18 * rnd;"),b.push("color += texture2D(GLGE_PASS0, vec2(texCoord.x, texCoord.y + blurSize)) * 0.15 * rnd;"),b.push("color += texture2D(GLGE_PASS0, vec2(texCoord.x, texCoord.y + 2.0*blurSize)) * 0.12 * rnd;"),b.push("color += texture2D(GLGE_PASS0, vec2(texCoord.x, texCoord.y + 3.0*blurSize)) * 0.09 * rnd;"),b.push("color += texture2D(GLGE_PASS0, vec2(texCoord.x, texCoord.y + 4.0*blurSize)) * 0.05 * rnd;"),b.push("gl_FragColor = vec4(color.rgb*"+this.intensity.toFixed(5)+"+texture2D(GLGE_RENDER,texCoord).rgb,1.0);"),b.push("}"),this.passes=[],this.addPass(a.join("")),this.addPass(b.join(""));if(this.useFXAA){var c=[];c.push("precision highp float;"),c.push("uniform sampler2D GLGE_PASS1;"),c.push("varying vec2 texCoord;"),c.push("vec2 inverse_buffer_size=vec2(1.0/1280.0,1.0/720.0);"),c.push("#define FXAA_REDUCE_MIN   (1.0/128.0)"),c.push("#define FXAA_REDUCE_MUL   (1.0/16.0)"),c.push("#define FXAA_SPAN_MAX     8.0"),c.push("void  main(){"),c.push("\tvec3 rgbNW = texture2D(GLGE_PASS1,  (gl_FragCoord.xy + vec2(-1.0,-1.0)) * inverse_buffer_size).xyz;"),c.push("\tvec3 rgbNE = texture2D(GLGE_PASS1,  (gl_FragCoord.xy + vec2(1.0,-1.0)) * inverse_buffer_size).xyz;"),c.push("\tvec3 rgbSW = texture2D(GLGE_PASS1,  (gl_FragCoord.xy + vec2(-1.0,1.0)) * inverse_buffer_size).xyz;"),c.push("\tvec3 rgbSE = texture2D(GLGE_PASS1,  (gl_FragCoord.xy + vec2(1.0,1.0)) * inverse_buffer_size).xyz;"),c.push("\tvec3 rgbM  = texture2D(GLGE_PASS1,  gl_FragCoord.xy  * inverse_buffer_size).xyz;"),c.push("\tvec3 luma = vec3(0.299, 0.587, 0.114);"),c.push("\tfloat lumaNW = dot(rgbNW, luma);"),c.push("\tfloat lumaNE = dot(rgbNE, luma);"),c.push("\tfloat lumaSW = dot(rgbSW, luma);"),c.push("\tfloat lumaSE = dot(rgbSE, luma);"),c.push("\tfloat lumaM  = dot(rgbM,  luma);"),c.push("\tfloat lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));"),c.push("\tfloat lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));"),c.push("\tvec2 dir;"),c.push("\tdir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));"),c.push("\tdir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));"),c.push("\tfloat dirReduce = max("),c.push("\t(lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_REDUCE_MUL),"),c.push("\tFXAA_REDUCE_MIN);"),c.push("\tfloat rcpDirMin = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);"),c.push("\tdir = min(vec2( FXAA_SPAN_MAX,  FXAA_SPAN_MAX),"),c.push("\tmax(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),"),c.push("\tdir * rcpDirMin)) * inverse_buffer_size;"),c.push("\tvec3 rgbA = 0.5 * ("),c.push("\ttexture2D(GLGE_PASS1,   gl_FragCoord.xy  * inverse_buffer_size + dir * (1.0/3.0 - 0.5)).xyz +"),c.push("\ttexture2D(GLGE_PASS1,   gl_FragCoord.xy  * inverse_buffer_size + dir * (2.0/3.0 - 0.5)).xyz);"),c.push("\tvec3 rgbB = rgbA * 0.5 + 0.25 * ("),c.push("\ttexture2D(GLGE_PASS1,  gl_FragCoord.xy  * inverse_buffer_size + dir *  - 0.5).xyz +"),c.push("\ttexture2D(GLGE_PASS1,  gl_FragCoord.xy  * inverse_buffer_size + dir * 0.5).xyz);"),c.push("\tfloat lumaB = dot(rgbB, luma);"),c.push("\tif((lumaB < lumaMin) || (lumaB > lumaMax)) gl_FragColor = vec4(rgbA,1.0);"),c.push("\t    else gl_FragColor = vec4(rgbB,1.0);"),c.push("\tif(length(rgbM)>"+this.fxaacutoff.toFixed(2)+") gl_FragColor = vec4(rgbM,1.0);"),c.push("\tif(length(rgbM)<"+this.fxaastartintensity.toFixed(2)+") gl_FragColor = vec4(rgbM,1.0);"),c.push("}"),this.addPass(c.join("\n"))}}}(GLGE),function(a){a.FilterAO=function(){this.setUniform("1f","cavitygamma",1/3),this.setUniform("1f","whiteMul",2),this.setUniform("1f","aogamma",1/3),this.setUniform("1f","maxDist",.025),this.passes=[]},a.augment(a.Filter2d,a.FilterAO),a.FilterAO.prototype.renderNormal=!0,a.FilterAO.prototype.quality=1,a.FilterAO.prototype.range=80,a.FilterAO.prototype.samples=16,a.FilterAO.prototype.useRender=!0,a.FilterAO.prototype.getNormalBufferHeight=function(){return this.normalBufferHeight?this.normalBufferHeight:this.gl.canvas.height*this.quality|0},a.FilterAO.prototype.getNormalBufferWidth=function(){return this.normalBufferWidth?this.normalBufferWidth:this.gl.canvas.width*this.quality|0},a.FilterAO.prototype.setUseRender=function(a){this.useRender=a,this.normalBuffers=null,this.passes=[];return this},a.FilterAO.prototype.setSamples=function(a){this.samples=a,this.normalBuffers=null,this.passes=[];return this},a.FilterAO.prototype.setQuality=function(a){this.quality=a,this.normalBuffers=null,this.passes=[];return this},a.FilterAO.prototype.setRange=function(a){this.range=a,this.gl&&(this.setUniform("1f","blurX",this.range/this.getNormalBufferWidth()*this.quality/this.samples),this.setUniform("1f","blurY",this.range/this.getNormalBufferHeight()/this.samples));return this},a.FilterAO.prototype.setCavityGamma=function(a){this.setUniform("1f","cavitygamma",1/a);return this},a.FilterAO.prototype.setAmbientMultiplier=function(a){this.setUniform("1f","whiteMul",a);return this},a.FilterAO.prototype.setAmbientGamma=function(a){this.setUniform("1f","aogamma",1/a);return this},a.FilterAO.prototype.setMaximumDistance=function(a){this.setUniform("1f","maxDist",a);return this},a.FilterAO.prototype.GLRender=function(b,c){this.gl=b,this.passes.length==0&&this.createPasses();return a.Filter2d.prototype.GLRender.call(this,b,c)},a.FilterAO.prototype.createPasses=function(){if(this.gl){var a=this.getNormalBufferWidth(),b=this.getNormalBufferHeight(),c=this.samples/4|0,d=[];for(var e=-c,f=0;e<=c;e++,f++){var g=c-Math.abs(e)+1;d[f]=g/(c*c+c)}d[c]=0,this.setUniform("1f","blurX",this.range/a*this.quality/this.samples),this.setUniform("1f","blurY",this.range/b/this.samples);var h=[];h.push("precision highp float;"),h.push("uniform sampler2D GLGE_NORMAL;"),h.push("uniform float maxDist;"),h.push("varying vec2 texCoord;"),h.push("uniform float blurX;"),h.push("float rand(vec2 co){"),h.push("return (fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453)-0.5)*2.0;"),h.push("}"),h.push("void main(void){"),h.push("vec4 n=texture2D(GLGE_NORMAL,texCoord.xy).rgba;"),h.push("vec4 color=vec4(0.0,0.0,0.0,n.a);"),h.push("float blurSize=blurX/(n.a*n.a+1.0);"),h.push("float offset=rand(texCoord.xy)*blurSize+texCoord.x;"),h.push("vec3 samp;"),h.push("float delta;");for(var e=-c,f=0;e<=c;e++,f++){if(e==0)continue;h.push("samp = texture2D(GLGE_NORMAL, vec2("+e+".0*blurSize+offset, texCoord.y)).rga;"),h.push("delta=abs(n.a-samp.b);"),h.push("if(delta<maxDist){"),h.push("delta/=maxDist;"),h.push("color.b -= (samp.r-0.5) * "+d[f]+" * "+(2*e/Math.abs(e)|0)+".0;"),h.push("color.rg += samp.rg * "+d[f]+" * (1.0-delta);"),h.push("color.rg += n.rg  * "+d[f]+" * delta;"),h.push("}else{"),h.push("color.rg +=n.rg * "+d[f]+";"),h.push("}")}h.push("color.b = (color.b+1.0)*0.5;"),h.push("gl_FragColor = color;"),h.push("}");var i=[];i.push("precision highp float;"),i.push("uniform sampler2D GLGE_PASS0;"),i.push("uniform sampler2D GLGE_RENDER;"),i.push("uniform sampler2D GLGE_NORMAL;"),i.push("varying vec2 texCoord;"),i.push("uniform float blurY;"),i.push("uniform float cavitygamma;"),i.push("uniform float whiteMul;"),i.push("uniform float aogamma;"),i.push("uniform float maxDist;"),i.push("float rand(vec2 co){"),i.push("return (fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453)-0.5)*2.0;"),i.push("}"),i.push("void main(void){"),i.push("vec4 color=vec4(0.0,0.0,0.0,1.0);"),i.push("vec4 samp=vec4(0.0);"),i.push("float random=rand(texCoord.xy);"),this.quality<1?(i.push("vec2 displace=vec2("+.5/a+","+.5/b+")*random;"),i.push("vec4 n=texture2D(GLGE_PASS0, texCoord.xy+displace);")):i.push("vec4 n=texture2D(GLGE_PASS0, texCoord.xy);"),i.push("float delta;"),i.push("float blurSize=blurY/(n.a*n.a+1.0);"),i.push("float offset=random*blurSize+texCoord.y;");for(var e=-c,f=0;e<=c;e++,f++){if(e==0)continue;this.quality<1?i.push("samp = texture2D(GLGE_PASS0, vec2(texCoord.x, "+e+".0*blurSize + offset)+displace);"):i.push("samp = texture2D(GLGE_PASS0, vec2(texCoord.x, "+e+".0*blurSize + offset));"),i.push("delta=abs(n.a-samp.a);"),i.push("if(delta<maxDist){"),i.push("delta/=maxDist;"),i.push("color.a -= (samp.g-0.5) * "+d[f]+" * "+(e*2/Math.abs(e)|0)+".0;"),i.push("color.rg += samp.rg  * "+d[f]+" * (1.0-delta);"),i.push("color.rg += n.rg * "+d[f]+" * delta;"),i.push("}else{"),i.push("color.rg += n.rg * "+d[f]+";"),i.push("}")}i.push("color.a = (color.a+1.0)*n.b;"),i.push("color.a = pow(color.a,cavitygamma);"),this.quality<1?(i.push("float dif =  length(color.rg-texture2D(GLGE_NORMAL, texCoord.xy+displace).rg);"),i.push("samp =  texture2D(GLGE_NORMAL, texCoord.xy+displace+"+1/this.gl.canvas.height+").rgba;"),i.push("if(abs(n.a-samp.a)<maxDist) dif =  max(length(color.rg-samp.rg),dif);"),i.push("samp =  texture2D(GLGE_NORMAL, texCoord.xy+displace-"+1/this.gl.canvas.height+").rgba;"),i.push("if(abs(n.a-samp.a)<maxDist) dif =  max(length(color.rg-samp.rg),dif);")):i.push("float dif =  length(color.rg-texture2D(GLGE_NORMAL, texCoord.xy).rg);"),i.push("float result = 1.0-((dif*(color.a-0.5)*2.0)+1.0)*0.5;"),i.push("result = pow(min(result*whiteMul,1.0),aogamma);"),i.push("gl_FragColor = vec4(vec3(result),1.0);"),this.useRender&&i.push("gl_FragColor = vec4(texture2D(GLGE_RENDER, texCoord.xy).rgb*gl_FragColor.r,1.0);"),i.push("}");var j=[];j.push("precision highp float;"),j.push("uniform sampler2D GLGE_PASS1;"),j.push("varying vec2 texCoord;"),j.push("vec2 inverse_buffer_size=vec2(1.0/"+this.gl.canvas.width.toFixed(1)+",1.0/"+this.gl.canvas.height.toFixed(1)+");"),j.push("#define FXAA_REDUCE_MIN   (1.0/128.0)"),j.push("#define FXAA_REDUCE_MUL   (1.0/16.0)"),j.push("#define FXAA_SPAN_MAX     8.0"),j.push("void  main(){"),j.push("\tvec3 rgbNW = texture2D(GLGE_PASS1,  (gl_FragCoord.xy + vec2(-1.0,-1.0)) * inverse_buffer_size).xyz;"),j.push("\tvec3 rgbNE = texture2D(GLGE_PASS1,  (gl_FragCoord.xy + vec2(1.0,-1.0)) * inverse_buffer_size).xyz;"),j.push("\tvec3 rgbSW = texture2D(GLGE_PASS1,  (gl_FragCoord.xy + vec2(-1.0,1.0)) * inverse_buffer_size).xyz;"),j.push("\tvec3 rgbSE = texture2D(GLGE_PASS1,  (gl_FragCoord.xy + vec2(1.0,1.0)) * inverse_buffer_size).xyz;"),j.push("\tvec3 rgbM  = texture2D(GLGE_PASS1,  gl_FragCoord.xy  * inverse_buffer_size).xyz;"),j.push("\tvec3 luma = vec3(0.299, 0.587, 0.114);"),j.push("\tfloat lumaNW = dot(rgbNW, luma);"),j.push("\tfloat lumaNE = dot(rgbNE, luma);"),j.push("\tfloat lumaSW = dot(rgbSW, luma);"),j.push("\tfloat lumaSE = dot(rgbSE, luma);"),j.push("\tfloat lumaM  = dot(rgbM,  luma);"),j.push("\tfloat lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));"),j.push("\tfloat lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));"),j.push("\tvec2 dir;"),j.push("\tdir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));"),j.push("\tdir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));"),j.push("\tfloat dirReduce = max("),j.push("\t(lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_REDUCE_MUL),"),j.push("\tFXAA_REDUCE_MIN);"),j.push("\tfloat rcpDirMin = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);"),j.push("\tdir = min(vec2( FXAA_SPAN_MAX,  FXAA_SPAN_MAX),"),j.push("\tmax(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),"),j.push("\tdir * rcpDirMin)) * inverse_buffer_size;"),j.push("\tvec3 rgbA = 0.5 * ("),j.push("\ttexture2D(GLGE_PASS1,   gl_FragCoord.xy  * inverse_buffer_size + dir * (1.0/3.0 - 0.5)).xyz +"),j.push("\ttexture2D(GLGE_PASS1,   gl_FragCoord.xy  * inverse_buffer_size + dir * (2.0/3.0 - 0.5)).xyz);"),j.push("\tvec3 rgbB = rgbA * 0.5 + 0.25 * ("),j.push("\ttexture2D(GLGE_PASS1,  gl_FragCoord.xy  * inverse_buffer_size + dir *  - 0.5).xyz +"),j.push("\ttexture2D(GLGE_PASS1,  gl_FragCoord.xy  * inverse_buffer_size + dir * 0.5).xyz);"),j.push("\tfloat lumaB = dot(rgbB, luma);"),j.push("\tif((lumaB < lumaMin) || (lumaB > lumaMax)) gl_FragColor = vec4(rgbA,1.0);"),j.push("\t    else gl_FragColor = vec4(rgbB,1.0);"),j.push("\tif(length(rgbM)>10.0) gl_FragColor = vec4(rgbM,1.0);"),j.push("}"),this.passes=[],this.addPass(h.join(""),a,b),this.addPass(i.join("")),this.addPass(j.join("\n"))}}}(GLGE),typeof GLGE=="undefined"&&(GLGE={}),function(a){function c(a,b){var d=null;if(a.getAttribute("id")==b)return a;for(var e=0;e<a.childNodes.length;e++)if(a.childNodes[e].nodeType==1){d=c(a.childNodes[e],b);if(d!=null)break}return d}a.ColladaDocuments=[],a.Collada=function(b){a.Group.call(this),this.children=[],this.actions={},this.boneIdx=0,this.actionsIdx=0,a.Assets.registerAsset(this,b)},a.augment(a.Group,a.Collada),a.Collada.prototype.type=a.G_NODE,a.Collada.prototype.useLights=!1,a.Collada.prototype.useCamera=!1,a.Collada.prototype.useBinaryAlpha=!1,a.Collada.prototype.getAbsolutePath=function(a,b){if(a.substr(0,7)=="http://"||a.substr(0,7)=="file://"||a.substr(0,7)=="https://")return a;b||(b=window.location.href);if(b.indexOf("://")==-1)return b.slice(0,b.lastIndexOf("/"))+"/"+a;var c=b.split("/"),d=c[2],e=c[0],f=[];for(var g=3;g<c.length-1;g++)f.push(c[g]);a.substr(0,1)=="/"&&(f=[]);var h=a.split("/");for(g=0;g<h.length;g++)h[g]==".."?f.pop():h[g]!=""&&f.push(h[g]);return e+"//"+d+"/"+f.join("/")},a.Collada.prototype.getElementById=function(a){if(!this.idcache){var b=this.getElementsByTagName("*"),c;this.idcache={};for(var d=0;d<b.length;d++)c=b[d].getAttribute("id"),c!=""&&(this.idcache[c]=b[d])}return this.idcache[a]},a.Collada.prototype.parseArray=function(a){var b,c=a.firstChild,d="",e=[],f,g;while(c){f=(d+c.nodeValue).replace(/\s+/g," ").replace(/^\s+/g,"").split(" "),c=c.nextSibling,f[0]==""&&f.unshift(),c&&(d=f.pop());for(g=0;g<f.length;g++)f[g]!=""&&e.push(f[g])}return e},a.Collada.prototype.isSketchupFile=function(){var a=this.xml.getElementsByTagName("asset");if(!a||a.length==0)return!1;for(var b=0;b<a.length;++b){var c=a[b].getElementsByTagName("contributor");if(!c||c.length==0)return!1;for(var d=0;d<c.length;++d){var e=c[d].getElementsByTagName("authoring_tool");if(!e||e.length==0)return!1;for(var f=0;f<e.length;++f){var g=e[f].firstChild.nodeValue;if(g.indexOf("Google")==0)return!0}}}return!1},a.Collada.prototype.setUseBinaryAlpha=function(a){this.useBinaryAlpha=a;return this},a.Collada.prototype.setUseCamera=function(a){this.useCamera=a;return this},a.Collada.prototype.getUseCamera=function(){return this.useCamera},a.Collada.prototype.setUseLights=function(a){this.useLights=a;return this},a.Collada.prototype.getUseLights=function(a){return this.useLights},a.Collada.prototype.setDocument=function(b,c,d){this.url=b,this.loadedCallback=d,b.indexOf("#")!=-1&&(this.rootId=b.substr(b.indexOf("#")+1),b=b.substr(0,b.indexOf("#"))),c&&(b=this.getAbsolutePath(b,c)),this.docURL=b;if(a.ColladaDocuments[b])this.xml=a.ColladaDocuments[b];else{var e=new XMLHttpRequest;if(e){e.overrideMimeType("text/xml");var f=b,g=this;e.onreadystatechange=function(){this.readyState==4&&(this.status==200||this.status==0?(this.responseXML.getElementById=g.getElementById,g.loaded(f,this.responseXML)):a.error("Error loading Document: "+f+" status "+this.status))},e.open("GET",b,!0),e.send("")}}},a.Collada.prototype.getSource=function(a){var b=this.xml.getElementById(a);if(!b)return[];if(!b.jsArray||this.badAccessor){var c;if(b.tagName=="vertices"){c=[];var d=b.getElementsByTagName("input");for(var e=0;e<d.length;e++)c[e]=this.getSource(d[e].getAttribute("source").substr(1)),c[e].block=d[e].getAttribute("semantic")}else{var f=b.getElementsByTagName("technique_common")[0].getElementsByTagName("accessor")[0],g=this.xml.getElementById(f.getAttribute("source").substr(1)),h=g.tagName;c=this.parseArray(g),stride=parseInt(f.getAttribute("stride")),offset=parseInt(f.getAttribute("offset")),offset||(offset=0),stride||(stride=1),count=parseInt(f.getAttribute("count"));var i=f.getElementsByTagName("param"),j=[];for(var e=0;e<i.length;e++)i[e].hasAttribute("name")||this.exceptions.badAccessor||this.badAccessor?j.push({type:i[e].getAttribute("type"),name:i[e].getAttribute("name")}):j.push(!1);c={array:c,stride:stride,offset:offset,count:count,pmask:j,type:h}}b.jsArray=c}return b.jsArray};var b={};a.Collada.prototype.getMeshes=function(c,d){b[this.url]||(b[this.url]=[]);if(b[this.url][c])return b[this.url][c];var e,f,g,h,i,j,k,l,m,n,o,p=this.xml.getElementById(c);if(!p){a.error("Collada.getMeshes returning [], id: "+c);return[]}var q=p.getElementsByTagName("mesh");if(!q){a.error("Collada.getMeshes returning [], id: "+c);return[]}meshNode=null,q.length?meshNode=q[0]:a.error("Collada.getMeshes returning [], id: "+c);var r=[];if(!meshNode)return r;var s=meshNode.getElementsByTagName("polylist");for(e=0;e<s.length;e++){l=this.parseArray(s[e].getElementsByTagName("p")[0]),vcount=this.parseArray(s[e].getElementsByTagName("vcount")[0]);var t=s[e].getElementsByTagName("input"),u=0;for(f=0;f<t.length;f++)u=Math.max(u,t[f].getAttribute("offset"));var v=[],w=0;for(f=0;f<vcount.length;f++){for(var x=0;x<vcount[f]-2;x++){for(var y=0;y<=u;y++)v.push(l[w+y]);for(y=0;y<=u;y++)v.push(l[w+(u+1)*(x+1)+y]);for(y=0;y<=u;y++)v.push(l[w+(u+1)*(x+2)+y])}w=w+(u+1)*vcount[f]}s[e].getElementsByTagName("p")[0].data=v}var z=meshNode.getElementsByTagName("polygons");for(e=0;e<z.length;e++){var A=z[e].getElementsByTagName("p"),v=[];for(var B=0;B<A.length;B++){var l=this.parseArray(A[B]),t=z[e].getElementsByTagName("input"),u=0;for(f=0;f<t.length;f++)u=Math.max(u,t[f].getAttribute("offset"));var w=0;for(x=0;x<l.length/(u+1)-2;x++){for(y=0;y<=u;y++)v.push(l[w+y]);for(y=0;y<=u;y++)v.push(l[w+(u+1)*(x+1)+y]);for(y=0;y<=u;y++)v.push(l[w+(u+1)*(x+2)+y])}w=w+(u+1)*(l.length/(u+1))}A.length>0&&(z[e].getElementsByTagName("p")[0].data=v)}var C=[],v=meshNode.getElementsByTagName("triangles");for(e=0;e<s.length;e++)C.push(s[e]);for(e=0;e<z.length;e++)z[e].getElementsByTagName("p").length>0&&C.push(z[e]);for(e=0;e<v.length;e++)C.push(v[e]);for(e=0;e<C.length;e++){h=C[e].getElementsByTagName("input"),j=[],k=[],i=[],m={};for(f=0;f<h.length;f++){h[f].data=this.getSource(h[f].getAttribute("source").substr(1)),n=h[f].getAttribute("semantic"),n=="TEXCOORD"&&(o=h[f].getAttribute("set"),o||(o=0),n=n+o);if(n=="VERTEX")for(var B=0;B<h[f].data.length;B++)m[h[f].data[B].block]=[];h[f].block=n,h[f].offset=parseInt(h[f].getAttribute("offset")),m[n]=[],i.push(h[f])}C[e].getElementsByTagName("p")[0].data?l=C[e].getElementsByTagName("p")[0].data:l=this.parseArray(C[e].getElementsByTagName("p")[0]);for(var f=0;f<i.length;f++)i[f].block!="VERTEX"&&(i[f].data=[i[f].data],i[f].data[0].block=i[f].block);var u=0;for(f=0;f<i.length;f++)u=Math.max(i[f].offset+1,u);for(x=0;x<l.length;x=x+u)for(f=0;f<i.length;f++)for(var B=0;B<i[f].data.length;B++){var n=i[f].data[B].block,D=i[f].data[B].stride;for(y=0;y<i[f].data[B].stride;y++)i[f].data[B].pmask[y]&&m[n].push(i[f].data[B].array[l[x+i[f].offset]*i[f].data[B].stride+y+i[f].data[B].offset]);if(d&&n=="POSITION")for(y=0;y<d.count;y++)j.push(d.vertexJoints[l[x+i[f].offset]*d.count+y]),k.push(d.vertexWeight[l[x+i[f].offset]*d.count+y]);n=="POSITION"&&D==1&&(m[n].push(0),m[n].push(0)),n=="POSITION"&&D==2&&m[n].push(0),n=="TEXCOORD0"&&D==3&&m[n].pop(),n=="TEXCOORD1"&&D==3&&m[n].pop()}l=[];var E=a.Mesh.WINDING_ORDER_CLOCKWISE;if(m.NORMAL){E=a.Mesh.WINDING_ORDER_CLOCKWISE;for(f=0;f<m.POSITION.length;f=f+9){var F=a.subVec3([m.POSITION[f],m.POSITION[f+1],m.POSITION[f+2]],[m.POSITION[f+3],m.POSITION[f+4],m.POSITION[f+5]]),G=a.subVec3([m.POSITION[f+6],m.POSITION[f+7],m.POSITION[f+8]],[m.POSITION[f],m.POSITION[f+1],m.POSITION[f+2]]),H=a.crossVec3(G,F),J=0;for(var K=0;K<9;K+=3)H[0]*m.NORMAL[f+K]+H[1]*m.NORMAL[f+K+1]+H[2]*m.NORMAL[f+K+2]<0?J-=1:J+=1;if(J<0){var I=m.POSITION.length/3;l.push(f/3),l.push(f/3+2),l.push(f/3+1)}else l.push(f/3),l.push(f/3+1),l.push(f/3+2)}}else{console.log("Autogenerating normals, do not know facings"),m.NORMAL=[];for(f=0;f<m.POSITION.length;f=f+9){var F=a.subVec3([m.POSITION[f],m.POSITION[f+1],m.POSITION[f+2]],[m.POSITION[f+3],m.POSITION[f+4],m.POSITION[f+5]]),G=a.subVec3([m.POSITION[f+6],m.POSITION[f+7],m.POSITION[f+8]],[m.POSITION[f],m.POSITION[f+1],m.POSITION[f+2]]),H=a.toUnitVec3(a.crossVec3(a.toUnitVec3(G),a.toUnitVec3(F)));m.NORMAL.push(H[0]),m.NORMAL.push(H[1]),m.NORMAL.push(H[2]),m.NORMAL.push(H[0]),m.NORMAL.push(H[1]),m.NORMAL.push(H[2]),m.NORMAL.push(H[0]),m.NORMAL.push(H[1]),m.NORMAL.push(H[2])}var I=m.POSITION.length/3;for(f=0;f<I;f++)l.push(f)}this.isSketchupFile()||(E=a.Mesh.WINDING_ORDER_UNKNOWN);function L(a,b){return a>b?b:a}var M=21843;M*=3;var N=(l.length-l.length%M)/M+(l.length%M?1:0),O=[],P=3,Q=3,R=2;for(var S=0;S<N;++S)O.push(new a.Mesh(undefined,E)),O[S].setPositions(m.POSITION.slice(M*S*P,L(M*P*(S+1),m.POSITION.length))),O[S].setNormals(m.NORMAL.slice(M*S*Q,L(M*(S+1)*Q,m.POSITION.length))),m.TEXCOORD0&&O[S].setUV(m.TEXCOORD0.slice(M*S*R,L(M*(S+1)*R,m.TEXCOORD0.length))),!m.TEXCOORD0&&m.TEXCOORD1&&O[S].setUV(m.TEXCOORD1.slice(M*S*R,L(M*(S+1)*R,m.TEXCOORD1.length))),m.TEXCOORD1&&O[S].setUV2(m.TEXCOORD1.slice(M*S*R,L(M*(S+1)*R,m.TEXCOORD1.length)));if(d){if(d.count>8){var T=[],U=[];for(var x=0;x<k.length;x=x+d.count){var V=[];for(y=0;y<d.count;y++)V.push({weight:k[x+y],joint:j[x+y]});V.sort(function(a,b){return parseFloat(b.weight)-parseFloat(a.weight)});for(y=0;y<8;y++)T.push(V[y].joint),U.push(V[y].weight)}j=T,k=U,d.count=8}for(var S=0;S<N;++S){O[S].setJoints(d.joints),O[S].setInvBindMatrix(d.inverseBindMatrix);var W=L(M*(S+1)*d.count,j.length),X=M*S*d.count;O[S].setVertexJoints(j.slice(X,W),d.count),O[S].setVertexWeights(k.slice(X,W),d.count)}}for(var S=0;S<N;++S)O[S].setFaces(l.slice(0,L(M*(S+1),l.length)-M*S)),O[S].matName=C[e].getAttribute("material"),r.push(O[S])}b[this.url][c]=r;return r},a.Collada.prototype.getFloat4=function(a,b){var c=a.getElementsByTagName("newparam");for(var d=0;d<c.length;d++)if(c[d].getAttribute("sid")==b)return c[d].getElementsByTagName("float4")[0].firstChild.nodeValue;return null},a.Collada.prototype.getFloat=function(a,b){var c=a.getElementsByTagName("newparam");for(var d=0;d<c.length;d++)if(c[d].getAttribute("sid")==b)return c[d].getElementsByTagName("float")[0].firstChild.nodeValue;return null},a.Collada.prototype.getSampler=function(a,b){var c=a.getElementsByTagName("newparam");for(var d=0;d<c.length;d++)if(c[d].getAttribute("sid")==b)return c[d].getElementsByTagName("sampler2D")[0].getElementsByTagName("source")[0].firstChild.nodeValue;return null},a.Collada.prototype.getSurface=function(a,b){var c=a.getElementsByTagName("newparam");for(var d=0;d<c.length;d++)if(c[d].getAttribute("sid")==b)return c[d].getElementsByTagName("surface")[0].getElementsByTagName("init_from")[0].firstChild.nodeValue;return null},a.Collada.prototype.getImage=function(a){var b=this.xml.getElementById(a);if(b)return this.getAbsolutePath(b.getElementsByTagName("init_from")[0].firstChild.nodeValue,this.docURL)},a.Collada.prototype.createMaterialLayer=function(b,c,d,e,f){var g,h=this.getSurface(d,this.getSampler(d,b.getAttribute("texture")));h||(h=b.getAttribute("texture")),g=this.getImage(h);var i=new a.Texture;i.setSrc(g),c.addTexture(i);var j=new a.MaterialLayer;j.setTexture(i),j.setMapto(e),b.hasAttribute("texcoord")&&f[b.getAttribute("texcoord")]?f[b.getAttribute("texcoord")]==1?j.setMapinput(a.UV2):f[b.getAttribute("texcoord")]==0?j.setMapinput(a.UV1):(a.error("GLGE only supports 2 texture sets\n"),j.setMapinput(a.UV1)):(a.error("Collada material does not specify texture coordinates, but it may have them: defaulting to set 0\n"),j.setMapinput(a.UV1));if(b.getElementsByTagName("blend_mode")[0]){var k=b.getElementsByTagName("blend_mode")[0].firstChild.nodeValue;k=="MULTIPLY"&&j.setBlendMode(a.BL_MUL)}c.addMaterialLayer(j)};var d={};a.Collada.prototype.getMaterial=function(b,e){if(d[this.url]){if(d[this.url][b])return d[this.url][b]}else d[this.url]={};var f=this.xml.getElementsByTagName("library_materials")[0],g=c(f,b);if(!g){var h=new a.Material;d[this.url][b]=h;return h}var i=g.getElementsByTagName("instance_effect")[0].getAttribute("url").substr(1),j=this.xml.getElementById(i),k=j.getElementsByTagName("profile_COMMON")[0],l=k.getElementsByTagName("technique")[0],h=new a.Material;h.setBinaryAlpha(this.useBinaryAlpha),h.setSpecular(0),d[this.url][b]=h;var m,n,o=l.getElementsByTagName("ambient");if(o.length>0){m=o[0].firstChild;do switch(m.tagName){case"color":n=m.firstChild.nodeValue.replace(/\s+/g," ").split(" "),h.setAmbient({r:n[0],g:n[1],b:n[2]});break;case"param":n=this.getFloat4(k,m.getAttribute("ref")).replace(/\s+/g," ").split(" "),h.setAmbient({r:n[0],g:n[1],b:n[2]});break;case"texture":this.createMaterialLayer(m,h,k,a.M_AMBIENT,e)}while(m=m.nextSibling)}var p=l.getElementsByTagName("diffuse");if(p.length>0){m=p[0].firstChild;do switch(m.tagName){case"color":n=m.firstChild.nodeValue.replace(/\s+/g," ").split(" "),h.setColor({r:n[0],g:n[1],b:n[2]});break;case"param":n=this.getFloat4(k,m.getAttribute("ref")).replace(/\s+/g," ").split(" "),h.setColor({r:n[0],g:n[1],b:n[2]});break;case"texture":this.createMaterialLayer(m,h,k,a.M_COLOR,e)}while(m=m.nextSibling)}var q=l.getElementsByTagName("bump");if(q.length>0){m=q[0].firstChild;do switch(m.tagName){case"texture":this.createMaterialLayer(m,h,k,a.M_NOR,e)}while(m=m.nextSibling)}var r=l.getElementsByTagName("shininess");if(r.length>0){h.setSpecular(1),m=l.getElementsByTagName("shininess")[0].firstChild;do switch(m.tagName){case"float":parseFloat(m.firstChild.nodeValue)>1?h.setShininess(parseFloat(m.firstChild.nodeValue)):h.setShininess(parseFloat(m.firstChild.nodeValue)*128);break;case"param":var s=parseFloat(this.getFloat(k,m.getAttribute("ref")));s>1?h.setShininess(s):h.setShininess(s*128);break;case"texture":this.createMaterialLayer(m,h,k,a.M_SHINE,e)}while(m=m.nextSibling)}var t=l.getElementsByTagName("specular");if(t.length>0){h.setSpecular(1),m=t[0].firstChild;do switch(m.tagName){case"color":n=m.firstChild.nodeValue.replace(/\s+/g," ").split(" "),h.setSpecularColor({r:n[0],g:n[1],b:n[2]});break;case"param":n=this.getFloat4(k,m.getAttribute("ref")).replace(/\s+/g," ").split(" "),h.setSpecularColor({r:n[0],g:n[1],b:n[2]});break;case"texture":this.createMaterialLayer(m,h,k,a.M_SPECCOLOR,e)}while(m=m.nextSibling)}var u=l.getElementsByTagName("emission");if(u.length>0){m=u[0].firstChild;do switch(m.tagName){case"color":n=m.firstChild.nodeValue.split(" "),h.setEmit({r:n[0],g:n[1],b:n[2]});break;case"param":n=this.getFloat4(k,m.getAttribute("ref")).split(" "),h.setEmit(n[0]);break;case"texture":this.createMaterialLayer(m,h,k,a.M_EMIT,e)}while(m=m.nextSibling)}var v=l.getElementsByTagName("reflective");if(v.length>0){m=v[0].firstChild;do switch(m.tagName){case"color":n=m.firstChild.nodeValue.replace(/\s+/g," ").split(" ");break;case"param":n=this.getFloat4(k,m.getAttribute("ref")).replace(/\s+/g," ").split(" ");break;case"texture":this.createMaterialLayer(m,h,k,a.M_REFLECT,e)}while(m=m.nextSibling)}var w=l.getElementsByTagName("transparency");if(w.length>0){m=w[0].firstChild;do switch(m.tagName){case"float":m.firstChild.nodeValue<1&&(h.setAlpha(parseFloat(m.firstChild.nodeValue)),h.trans=!0);break;case"param":}while(m=m.nextSibling)}var x=l.getElementsByTagName("transparent");if(x.length>0){var y=x[0].getAttribute("opaque");y||(y="A_ONE"),m=x[0].firstChild;do switch(m.tagName){case"float":var z=parseFloat(m.firstChild.nodeValue);z<1&&(h.setAlpha(parseFloat(m.firstChild.nodeValue)),h.trans=!0);break;case"color":n=m.firstChild.nodeValue.replace(/\s+/g," ").split(" ");var z=this.getMaterialAlpha(n,y,1);z<1&&(h.setAlpha(z),h.trans=!0);break;case"param":n=this.getFloat4(k,m.getAttribute("ref")).replace(/\s+/g," ").split(" ");var z=this.getMaterialAlpha(n,y,1);z<1&&(h.setAlpha(z),h.trans=!0);break;case"texture":this.createMaterialLayer(m,h,k,a.M_ALPHA,e),h.trans=!0}while(m=m.nextSibling)}return h},a.Collada.prototype.getMaterialAlpha=function(a,b,c){var d;switch(b){case"A_ONE":d=parseFloat(a[3])*c;break;case"A_ZERO":d=1-parseFloat(a[3])*c;break;case"RGB_ONE":var e=parseFloat(a[0])*.212671+parseFloat(a[1])*.71516+parseFloat(a[2])*.072169;d=e*c;break;case"RGB_ZERO":var e=parseFloat(a[0])*.212671+parseFloat(a[1])*.71516+parseFloat(a[2])*.072169;d=1-e*c}return d},a.Collada.prototype.setMaterialOntoMesh=function(b,c){var d=c.getElementsByTagName("instance_material"),e={};for(var f=0;f<d.length;f++){var g=d[f].getElementsByTagName("bind_vertex_input"),h={};for(var i=0;i<g.length;i++)if(g[i].hasAttribute("input_set"))h[g[i].getAttribute("semantic")]=g[i].getAttribute("input_set");else{function j(a){var b="";for(var c=a.length-1;c>=0;--c)a[c]>="0"&&a[c]<="9"&&(b=a[c]+b);if(b.length==0)return"0";return b}h[g[i].getAttribute("semantic")]=j(g[i].getAttribute("semantic"))}mat=this.getMaterial(d[f].getAttribute("target").substr(1),h),e[d[f].getAttribute("symbol")]=mat}var k=new a.Object;for(f=0;f<b.length;f++){e[b[f].matName]&&e[b[f].matName].trans&&(k.setZtransparent(!0),k.setPickable(!1));var l=new a.MultiMaterial;l.setMesh(b[f]),e[b[f].matName]||(e[b[f].matName]=new a.Material,e[b[f].matName].setColor("lightgrey")),l.setMaterial(e[b[f].matName]),k.addMultiMaterial(l)}k.setSkeleton(this),c.GLGEObj=k},a.Collada.prototype.getInstanceGeometry=function(b){if(b.GLGEObj&&!1){var c=new a.ObjectInstance;c.setObject(b.GLGEObj);return c}var d=b.getAttribute("url").substr(1),e=this.getMeshes(d);this.setMaterialOntoMesh(e,b),b.GLGEObj.id=d;return b.GLGEObj},a.Collada.prototype.getAnimationSampler=function(b,c){var d=30,e=this.xml.getElementById(b).getElementsByTagName("input"),f={},g=[],h,i;for(var j=0;j<e.length;j++)h=this.getSource(e[j].getAttribute("source").substr(1)),i=e[j].getAttribute("semantic"),g.push({block:i,data:h});for(var k=0;k<g.length;k++){i=g[k].block,f[i]={},f[i].data=[],f[i].names=[];for(var l=0;l<g[k].data.array.length;l=l+g[k].data.stride){var m=0;for(j=0;j<g[k].data.pmask.length;j++)if(g[k].data.pmask[j]){f[i].names.push(g[k].data.pmask[j].name);if(g[k].data.pmask[j].type=="float4x4"){f[i].stride=16;for(var n=0;n<16;n++)f[i].data.push(g[k].data.array[n+l+g[k].data.offset+j])}else m++,f[i].stride=m,f[i].data.push(g[k].data.array[l+g[k].data.offset+j])}}}var o,p=[];for(var j=0;j<f.OUTPUT.stride;j++)p.push(new a.AnimationCurve);for(var j=0;j<f.INPUT.data.length;j++)for(var n=0;n<f.OUTPUT.stride;n++){p[n].name=f.OUTPUT.names[n],f.INTERPOLATION&&f.INTERPOLATION.data[j]=="BEZIER"&&!f.IN_TANGENT&&(f.INTERPOLATION.data[j]="LINEAR");if(!f.INTERPOLATION||f.INTERPOLATION.data[j]=="LINEAR"){o=new a.LinearPoint,o.setX(f.INPUT.data[j]*d);var q=parseFloat(f.OUTPUT.data[j*f.OUTPUT.stride+n]);q==-180&&(q=-179.9),q==180&&(q=179.9),this.exceptions.flipangle&&c&&(p[n].lastval&&(Math.abs(p[n].lastval-(360+q))<Math.abs(p[n].lastval-q)?q=360+q:Math.abs(p[n].lastval-(q-360))<Math.abs(p[n].lastval-q)&&(q=q-360))),o.setY(q),p[n].lastval=q,p[n].addPoint(o)}f.INTERPOLATION&&f.INTERPOLATION.data[j]=="BEZIER"&&(o=new a.BezTriple,o.setX1(f.IN_TANGENT.data[(j*f.OUTPUT.stride+n)*2]*d),o.setY1(f.IN_TANGENT.data[(j*f.OUTPUT.stride+n)*2+1]),o.setX2(Math.round(f.INPUT.data[j]*d)),o.setY2(f.OUTPUT.data[j*f.OUTPUT.stride+n]),o.setX3(f.OUT_TANGENT.data[(j*f.OUTPUT.stride+n)*2]*d),o.setY3(f.OUT_TANGENT.data[(j*f.OUTPUT.stride+n)*2+1]),p[n].addPoint(o))}return p},a.Collada.prototype.getAnimationVector=function(b){var c=0,d=this.xml.getElementById(b[0].target[0]),e=b[0].target[0].toString();if(!d){var e=e.substring(e.indexOf("_")+1);d=this.xml.getElementById(e)}if(!d){var e=e.substring(e.indexOf("_")+1);d=this.xml.getElementById(e)}if(!d){a.error("unable to find targetNode:"+e+" within collada document");return new a.AnimationVector}var f=d.firstChild,g=[],h={};do{switch(f.tagName){case"matrix":case"translate":case"rotate":case"scale":def={type:f.tagName,data:this.parseArray(f),animations:[]},f.hasAttribute("sid")&&(h[f.getAttribute("sid")]=def),g.push(def)}f=f.nextSibling}while(f);var i={};for(var j=0;j<b.length;j++){var e=b[j].target,k=this.getAnimationSampler(b[j].source,/ANGLE/i.test(e));for(n=0;n<k.length;n++)c=Math.max(c,k[n].keyFrames[k[n].keyFrames.length-1].x);if(e[1].indexOf(".")!=-1){var l=e[1].split(".");switch(l[1]){case"X":h[l[0]].animations[0]=k[0];break;case"Y":h[l[0]].animations[1]=k[0];break;case"Z":h[l[0]].animations[2]=k[0];break;case"ANGLE":h[l[0]].animations[3]=k[0]}}else if(e[1].indexOf("(")!=-1){var m=e[1].split("(");sidtarget=m.shift(),m.length>1?m=parseInt(m[0])+4*parseInt(m[1]):m=parseInt(m[0]),h[sidtarget].animations[m]=k[0]}else for(var n=0;n<k.length;n++)switch(k[n].name){case"X":h[e[1]].animations[0]=k[n];break;case"Y":h[e[1]].animations[1]=k[n];break;case"Z":h[e[1]].animations[2]=k[n];break;case"ANGLE":h[e[1]].animations[3]=k[n];break;default:h[e[1]].animations[n]=k[n]}}var o=new a.AnimationVector;o.setFrames(c);var p=new a.AnimationCurve;p.setChannel("QuatX");var q=new a.AnimationCurve;q.setChannel("QuatY");var r=new a.AnimationCurve;r.setChannel("QuatZ");var s=new a.AnimationCurve;s.setChannel("QuatW");var t=new a.AnimationCurve;t.setChannel("LocX");var u=new a.AnimationCurve;u.setChannel("LocY");var v=new a.AnimationCurve;v.setChannel("LocZ");var w=new a.AnimationCurve;w.setChannel("ScaleX");var x=new a.AnimationCurve;x.setChannel("ScaleY");var y=new a.AnimationCurve;y.setChannel("ScaleZ"),o.addAnimationCurve(p),o.addAnimationCurve(q),o.addAnimationCurve(r),o.addAnimationCurve(s),o.addAnimationCurve(t),o.addAnimationCurve(u),o.addAnimationCurve(v),o.addAnimationCurve(w),o.addAnimationCurve(x),o.addAnimationCurve(y);var z=null;for(var A=0;A<c;A++){var B=a.identMatrix();for(var j=0;j<g.length;j++)switch(g[j].type){case"matrix":var C=[g[j].animations[0]?g[j].animations[0].getValue(A):g[j].data[0],g[j].animations[1]?g[j].animations[1].getValue(A):g[j].data[1],g[j].animations[2]?g[j].animations[2].getValue(A):g[j].data[2],g[j].animations[3]?g[j].animations[3].getValue(A):g[j].data[3],g[j].animations[4]?g[j].animations[4].getValue(A):g[j].data[4],g[j].animations[5]?g[j].animations[5].getValue(A):g[j].data[5],g[j].animations[6]?g[j].animations[6].getValue(A):g[j].data[6],g[j].animations[7]?g[j].animations[7].getValue(A):g[j].data[7],g[j].animations[8]?g[j].animations[8].getValue(A):g[j].data[8],g[j].animations[9]?g[j].animations[9].getValue(A):g[j].data[9],g[j].animations[10]?g[j].animations[10].getValue(A):g[j].data[10],g[j].animations[11]?g[j].animations[11].getValue(A):g[j].data[11],g[j].animations[12]?g[j].animations[12].getValue(A):g[j].data[12],g[j].animations[13]?g[j].animations[13].getValue(A):g[j].data[13],g[j].animations[14]?g[j].animations[14].getValue(A):g[j].data[14],g[j].animations[15]?g[j].animations[15].getValue(A):g[j].data[15]];B=a.mulMat4(B,a.Mat4(C));break;case"rotate":var D=[g[j].animations[0]?g[j].animations[0].getValue(A):g[j].data[0],g[j].animations[1]?g[j].animations[1].getValue(A):g[j].data[1],g[j].animations[2]?g[j].animations[2].getValue(A):g[j].data[2],g[j].animations[3]?g[j].animations[3].getValue(A):g[j].data[3]];B=a.mulMat4(B,a.angleAxis(D[3]*.017453278,[D[0],D[1],D[2]]));break;case"translate":var E=[g[j].animations[0]?g[j].animations[0].getValue(A):g[j].data[0],g[j].animations[1]?g[j].animations[1].getValue(A):g[j].data[1],g[j].animations[2]?g[j].animations[2].getValue(A):g[j].data[2]];B=a.mulMat4(B,a.translateMatrix(E[0],E[1],E[2]));break;case"scale":var F=[g[j].animations[0]?g[j].animations[0].getValue(A):g[j].data[0],g[j].animations[1]?g[j].animations[1].getValue(A):g[j].data[1],g[j].animations[2]?g[j].animations[2].getValue(A):g[j].data[2]];B=a.mulMat4(B,a.scaleMatrix(F[0],F[1],F[2]))}scale=a.matrix2Scale(B),B=a.mulMat4(B,a.scaleMatrix(1/scale[0],1/scale[1],1/scale[2])),quat=a.rotationMatrix2Quat(B),z&&(z[0]*quat[0]+z[1]*quat[1]+z[2]*quat[2]+z[3]*quat[3]<0&&(quat[0]=quat[0]*-1,quat[1]=quat[1]*-1,quat[2]=quat[2]*-1,quat[3]=quat[3]*-1)),z=quat,point=new a.LinearPoint,point.setX(A),point.setY(quat[0]),p.addPoint(point),point=new a.LinearPoint,point.setX(A),point.setY(quat[1]),q.addPoint(point),point=new a.LinearPoint,point.setX(A),point.setY(quat[2]),r.addPoint(point),point=new a.LinearPoint,point.setX(A),point.setY(quat[3]),s.addPoint(point),point=new a.LinearPoint,point.setX(A),point.setY(B[3]),t.addPoint(point),point=new a.LinearPoint,point.setX(A),point.setY(B[7]),u.addPoint(point),point=new a.LinearPoint,point.setX(A),point.setY(B[11]),v.addPoint(point),point=new a.LinearPoint,point.setX(A),point.setY(scale[0].toFixed(4)),w.addPoint(point),point=new a.LinearPoint,point.setX(A),point.setY(scale[1].toFixed(4)),x.addPoint(point),point=new a.LinearPoint,point.setX(A),point.setY(scale[2].toFixed(4)),y.addPoint(point)}return o};var e={};a.Collada.prototype.getAnimations=function(){if(e[this.url])this.actions=e[this.url];else{var b=this.xml.getElementsByTagName("animation_clip"),c=this.xml.getElementsByTagName("animation");if(b.length==0){c.name="default";var d=[c]}else{var d=[];for(var f=0;f<b.length;f++){var g=[],h=b[f].getElementsByTagName("instance_animation");for(var i=0;i<h.length;i++)g.push(this.xml.getElementById(h[i].getAttribute("url").substr(1)));g.name=b[f].getAttribute("id"),d.push(g)}}for(var j=0;j<d.length;j++){var c=d[j],k,l,m,n={};for(var f=0;f<c.length;f++){k=c[f].getElementsByTagName("channel");for(var i=0;i<k.length;i++){var l=k[i].getAttribute("target").split("/");m=k[i].getAttribute("source").substr(1),n[l[0]]||(n[l[0]]=[]),n[l[0]].push({source:m,target:l})}}var o=new a.Action;for(var l in n){var p=this.getAnimationVector(n[l]),q=this.xml.getElementById(l);q||(l=l.substring(l.indexOf("_")+1),q=this.xml.getElementById(l)),q||(l=l.substring(l.indexOf("_")+1),q=this.xml.getElementById(l));if(!q){a.error("unable to find targetNode:"+l+" within collada document");continue}for(var f=0;f<q.GLGEObjects.length;f++){var r=new a.ActionChannel,s=q.GLGEObjects[f].getName();r.setTarget(s),r.setAnimation(p),o.addActionChannel(r)}}this.addColladaAction({name:c.name,action:o})}}e[this.url]=this.actions;for(var t in this.actions){this.setAction(this.actions[t],0,!0);break}},a.Collada.prototype.addColladaAction=function(a){this.actions[a.name]=a.action},a.Collada.prototype.getColladaActions=function(){return this.actions},a.Collada.prototype.getInstanceController=function(b){var c=new a.Object,d=this.xml.getElementById(b.getAttribute("url").substr(1));if(!d){a.error("unable to find id:"+b.getAttribute("url").substr(1)+" within collada document");return c}var e=b.getElementsByTagName("skeleton"),f=d.getElementsByTagName("joints")[0],g=f.getElementsByTagName("input"),h;d.getElementsByTagName("bind_shape_matrix").length>0?h=this.parseArray(d.getElementsByTagName("bind_shape_matrix")[0]):h=a.identMatrix();var i=[h],j=new a.Group;this.addGroup(j);var f=[j],k;for(var l=0;l<g.length;l++)if(g[l].getAttribute("semantic")=="JOINT"){var m=this.getSource(g[l].getAttribute("source").substr(1));if(m.type=="IDREF_array"){var n=m.array.length!=0;for(var o=0;o<m.array.length;o=o+m.stride){var p=this.getNode(this.xml.getElementById(m.array[o]),!0),q=p.getName();this.xml.getElementById(m.array[o])?n=!1:(a.error("Bone is not specified "+m.array[o]),i=[h=a.identMatrix()]),f.push(q)}n&&(i=[h=a.identMatrix()])}else if(m.type=="Name_array"){var r={},s,q;if(e.length==0){var t=this.xml.getElementsByTagName("node");for(o=0;o<t.length;o++)s=t[o].getAttribute("sid"),s&&(r[s]=t[o]),q=t[o].getAttribute("name"),q&&!r[q]&&(r[q]=t[o])}else for(var u=0;u<e.length;u++){var v=this.xml.getElementById(e[u].firstChild.nodeValue.substr(1));s=v.getAttribute("sid"),s&&(r[s]=v);var t=v.getElementsByTagName("*");for(o=0;o<t.length;o++)s=t[o].getAttribute("sid"),s&&(r[s]=t[o]),q=t[o].getAttribute("name"),q&&!r[q]&&(r[q]=t[o])}for(var o=0;o<m.array.length;o=o+m.stride)if(m.array[o]!=""){var q=this.getNode(r[m.array[o]],!0).getName();f.push(q)}}}for(var l=0;l<g.length;l++)if(g[l].getAttribute("semantic")=="INV_BIND_MATRIX"){var w=this.getSource(g[l].getAttribute("source").substr(1));for(var o=0;o<w.array.length;o=o+w.stride)k=w.array.slice(o,o+16),i.push(a.mulMat4(a.Mat4(k),a.Mat4(h.slice(0,16))))}var x=d.getElementsByTagName("vertex_weights")[0];g=x.getElementsByTagName("input");var y=[],z={};for(var u=0;u<g.length;u++){E=g[u].getAttribute("semantic"),g[u].data=this.getSource(g[u].getAttribute("source").substr(1)),g[u].block=E,z[E]=[];var A=g[u].getAttribute("offset");y[A]||(y[A]=[]),y[A].push(g[u])}var B=this.parseArray(x.getElementsByTagName("vcount")[0]),C=this.parseArray(x.getElementsByTagName("v")[0]),D=0;for(var l=0;l<B.length;l++)B[l]&&(D=Math.max(D,parseInt(B[l])));vPointer=0;var E;for(var l=0;l<B.length;l++){for(var F=0;F<B[l];F++)for(var o=0;o<y.length;o++)for(var G=0;G<y[o].length;++G){E=y[o][G].block;for(u=0;u<y[o][G].data.stride;u++)y[o][G].data.pmask[u]&&(E!="JOINT"?z[E].push(y[o][G].data.array[parseInt(C[vPointer])+parseInt(y[o][G].data.offset)]):z[E].push(parseInt(C[vPointer])),vPointer++)}for(F=F;F<D;F++)for(var o=0;o<y.length;o++)for(var G=0;G<y[o].length;++G)E=y[o][G].block,z[E].push(0)}if(!this.badAccessor&&z.JOINT.length==0){this.badAccessor=!0;return this.getInstanceController(b)}for(var l=0;l<z.JOINT.length;l++)z.JOINT[l]++;if(this.exceptions.negjoints)for(var l=0;l<z.JOINT.length;l++)z.JOINT[l]==0&&(z.WEIGHT[l]=0);var H={vertexJoints:z.JOINT,vertexWeight:z.WEIGHT,joints:f,inverseBindMatrix:i,count:D},I=this.getMeshes(d.getElementsByTagName("skin")[0].getAttribute("source").substr(1),H);this.setMaterialOntoMesh(I,b);return b.GLGEObj},a.Collada.prototype.getInstanceLight=function(b){var c=b.getElementsByTagName("technique_common")[0].getElementsByTagName("*")[0],d=new a.Light,e=c.getElementsByTagName("color");if(e.length>0){var f=e[0].firstChild.nodeValue.split(" "),g="rgb("+(f[0]*255|0)+","+(f[1]*255|0)+","+(f[2]*255|0)+")";d.setColor(g)}switch(c.tagName){case"point":d.setType(a.L_POINT);case"spot":var h=c.getElementsByTagName("constant_attenuation");h.length>0&&d.setAttenuationConstant(parseFloat(h[0].firstChild.nodeValue));var i=c.getElementsByTagName("linear_attenuation");i.length>0&&d.setAttenuationLinear(parseFloat(i[0].firstChild.nodeValue));var j=c.getElementsByTagName("quadratic_attenuation");j.length>0&&d.setAttenuationQuadratic(parseFloat(j[0].firstChild.nodeValue));if(c.tagName=="spot")d.setType(a.L_SPOT);else break;var k=c.getElementsByTagName("falloff_exponent");if(k.length>0){var l=parseFloat(k[0].firstChild.nodeValue);l<1.0001&&(l*=128),d.setSpotExponent(l)}var m=c.getElementsByTagName("falloff_angle");m.length>0&&d.setSpotCosCutOff(Math.cos(parseFloat(m[0].firstChild.nodeValue)/180*Math.PI))}return d},a.Collada.prototype.addColladaCamera=function(a){a.matrix=null,a.parent=this,this.children.push(a),this.hasCamera=!0;return this},a.Collada.prototype.getNode=function(b,c){if(!c&&b.GLGEObject){d=b.GLGEObject,delete this.GLGEObject;return d}if(c&&b&&b.GLGEObjects)return b.GLGEObjects[0];var d=new a.Group,e="bone"+ ++this.boneIdx;d.setName(e);if(!b)return d;b.GLGEObjects||(b.GLGEObjects=[]),b.GLGEObjects.push(d);var f=b.firstChild,g=a.identMatrix(),h;if(f)do switch(f.tagName){case"node":d.addGroup(this.getNode(f));break;case"instance_node":d.addGroup(this.getNode(this.xml.getElementById(f.getAttribute("url").substr(1))));break;case"instance_visual_scene":d.addGroup(this.getNode(this.xml.getElementById(f.getAttribute("url").substr(1))));break;case"instance_light":this.useLights&&d.addLight(this.getInstanceLight(this.xml.getElementById(f.getAttribute("url").substr(1))));break;case"instance_geometry":d.addObject(this.getInstanceGeometry(f));break;case"instance_controller":d.addObject(this.getInstanceController(f));break;case"instance_camera":if(!this.useCamera)break;d.addColladaCamera(this.getNode(this.xml.getElementById(f.getAttribute("url").substr(1))));break;case"optics":if(!this.useCamera)break;var i=f.getElementsByTagName("technique_common");if(i&&i.length>0){i=i[0].getElementsByTagName("perspective");if(i&&i.length>0){var j=i[0].getElementsByTagName("yfov");j&&j.length>0&&(d.yFov=parseFloat(j[0].textContent));var k=i[0].getElementsByTagName("znear");k&&k.length>0&&(d.zNear=parseFloat(k[0].textContent));var l=i[0].getElementsByTagName("zfar");l&&l.length>0&&(d.zFar=parseFloat(l[0].textContent))}}break;case"matrix":g=this.parseArray(f);break;case"translate":h=this.parseArray(f),g=a.mulMat4(g,a.translateMatrix(h[0],h[1],h[2]));break;case"rotate":h=this.parseArray(f),g=a.mulMat4(g,a.angleAxis(h[3]*.017453278,[h[0],h[1],h[2]]));break;case"scale":h=this.parseArray(f),g=a.mulMat4(g,a.scaleMatrix(h[0],h[1],h[2]))}while(f=f.nextSibling);d.setLoc(g[3],g[7],g[11]);var m=a.Mat4([g[0],g[1],g[2],0,g[4],g[5],g[6],0,g[8],g[9],g[10],0,0,0,0,1]);d.setRotMatrix(m),c&&(b.GLGEObject=d);return d},a.Collada.prototype.initVisualScene=function(){var b=this.xml.getElementsByTagName("asset"),c="Z_UP";if(b.length){var d=b[0].getElementsByTagName("up_axis");if(d.length){d=d[0];var e=d.firstChild.nodeValue;e.length&&(c=e)}}var f=this;c[0]!="Y"&&c[0]!="y"&&(f=new a.Group,this.addChild(f),c[0]!="Z"&&c[0]!="z"?f.setRotMatrix(a.Mat4([0,-1,0,0,1,0,0,0,0,0,1,0,0,0,0,1])):f.setRotMatrix(a.Mat4([1,0,0,0,0,0,1,0,0,-1,0,0,0,0,0,1])));if(this.rootId){var h=this.xml.getElementById(this.rootId);h?f.addGroup(this.getNode(h)):a.error("Asset "+this.rootId+" not found in document"+this.url)}else{var g=this.xml.getElementsByTagName("scene");g.length>0?f.addGroup(this.getNode(g[0])):a.error("Please indicate the asset to render in Collada Document"+this.url)}if(this.useCamera){var i,j=function(a){if(a.hasCamera)i=a;else{if(!a.children)return;for(var b=0;b<a.children.length&&!i;b++)j(a.children[b])}};j(f);if(i){pp=f.parent.parent,pp.camera.locX=i.locX,pp.camera.locY=i.locY,pp.camera.locZ=i.locZ;if(i.children&&i.children.length>0){var k=i.children[0];k.yFov&&(pp.camera.fovy=k.yFov,pp.camera.pMatrix=null),k.zNear&&(pp.camera.near=k.zNear),k.zFar&&(pp.camera.far=k.zFar)}pp.camera.matrix=null,pp.camera.rotmatrix=i.rotmatrix,pp.camera.lookAt=null}}};var f={"default":{},"COLLADA Mixamo exporter":{badAccessor:!0},"FBX COLLADA exporter":{badAccessor:!0},"Blender2.5":{flipangle:!0,negjoints:!0}};a.Collada.prototype.getExceptions=function(){if(this.xml.getElementsByTagName("authoring_tool").length>0&&this.xml.getElementsByTagName("authoring_tool")[0].firstChild.nodeValue=="COLLADA Mixamo exporter")return f["COLLADA Mixamo exporter"];if(this.xml.getElementsByTagName("authoring_tool").length>0&&this.xml.getElementsByTagName("authoring_tool")[0].firstChild.nodeValue=="FBX COLLADA exporter")return f["FBX COLLADA exporter"];if(this.xml.getElementsByTagName("authoring_tool").length>0&&/Blender 2.5/.test(this.xml.getElementsByTagName("authoring_tool")[0].firstChild.nodeValue))return f["Blender2.5"]},a.Collada.prototype.loaded=function(a,b){this.xml=b,b.getElementsByTagName("authoring_tool").length>0&&(this.exceptions=f[b.getElementsByTagName("authoring_tool")[0].firstChild.nodeValue]),this.exceptions=this.getExceptions(),this.exceptions||(this.exceptions=f["default"]),this.initVisualScene(),this.getAnimations(),this.loadedCallback&&this.loadedCallback(this);var c=this;setTimeout(function(){c.fireEvent("loaded",{url:this.url}),c.isComplete()&&c.fireEvent("downloadComplete",{})},1)},a.Scene.prototype.addCollada=a.Scene.prototype.addGroup,a.Group.prototype.addCollada=a.Group.prototype.addGroup,a.Document&&(a.Document.prototype.getCollada=function(b){b.object||(b.object=new(a[this.classString(b.tagName)]),b.object.setDocument(b.getAttribute("document"),this.getAbsolutePath(this.rootURL,null)),b.removeAttribute("document"),this.setProperties(b));return b.object})}(GLGE);if(!GLGE)var GLGE={};(function(a){a.HeightMap=function(a,b,c,d,e,f,g,h,j){this.canvas=document.createElement("canvas"),this.context=this.canvas.getContext("2d"),this.canvas.width=b,this.canvas.height=c,this.minX=d,this.maxX=e,this.minY=f,this.maxY=g,this.minZ=h,this.maxZ=j;var k=new Image;k.heightmap=this,k.onload=function(a){this.heightmap.context.drawImage(this,0,0),this.heightmap.data=this.heightmap.context.getImageData(0,0,this.heightmap.canvas.width,this.heightmap.canvas.height).data,this.heightmap.minImgValue=this.heightmap.data[0],this.heightmap.maxImgValue=this.heightmap.data[0];for(i=0;i<this.heightmap.data.length;i+=4)this.heightmap.data[i]<this.heightmap.minImgValue&&(this.heightmap.minImgValue=this.heightmap.data[i]),this.heightmap.data[i]>this.heightmap.maxImgValue&&(this.heightmap.maxImgValue=this.heightmap.data[i])},k.src=a},a.HeightMap.prototype.canvas=null,a.HeightMap.prototype.context=null,a.HeightMap.prototype.minZ=null,a.HeightMap.prototype.maxZ=null,a.HeightMap.prototype.minY=null,a.HeightMap.prototype.maxY=null,a.HeightMap.prototype.minX=null,a.HeightMap.prototype.maxX=null,a.HeightMap.prototype.data=null,a.HeightMap.prototype.getPixelAt=function(a,b){return this.data?(this.data[(this.canvas.width*b+a)*4]-this.minImgValue)/(this.maxImgValue-this.minImgValue)*(this.maxZ-this.minZ)+this.minZ:0},a.HeightMap.prototype.getHeightAt=function(a,b){var c;if(this.lastx!=undefined&&a==this.lastx&&b==this.lasty)c=this.lastValue;else{var d=Math.round((a-this.minX)/(this.maxX-this.minX)*this.canvas.width),e=Math.round((b-this.minY)/(this.maxY-this.minY)*this.canvas.height);c=this.getPixelAt(d,e),this.lastValue=c}this.lastx=a,this.lasty=b;return c},a.KeyInput=function(){document.keyStates||(document.keyStates=[]),document.addEventListener("keydown",this.onKeyDown,!1),document.addEventListener("keyup",this.onKeyUp,!1)},a.KeyInput.prototype.isKeyPressed=function(a){return document.keyStates[a]?!0:!1};var b=null;a.KeyInput.prototype.onKeyDown=function(a){document.keyStates[a.keyCode]=!0},a.KeyInput.prototype.onKeyUp=function(a){document.keyStates[a.keyCode]=!1},a.MouseInput=function(a){this.element=a,this.element.mouseX=0,this.element.mouseY=0,this.element.buttonState||(this.element.buttonState=[]),a.addEventListener("mousemove",this.onMouseMove,!1),a.addEventListener("mousedown",this.onMouseDown,!1),a.addEventListener("mouseup",this.onMouseUp,!1)},a.MouseInput.prototype.element=null,a.MouseInput.prototype.onMouseMove=function(a){this.mouseX=a.clientX,this.mouseY=a.clientY},a.MouseInput.prototype.onMouseDown=function(a){this.buttonState[a.button]=!0},a.MouseInput.prototype.onMouseUp=function(a){this.buttonState[a.button]=!1},a.MouseInput.prototype.isButtonDown=function(a){return this.element.buttonState[a]?!0:!1},a.MouseInput.prototype.getMousePosition=function(){return{x:this.element.mouseX,y:this.element.mouseY}},a.MI_LEFT=0,a.MI_MIDDLE=1,a.MI_RIGHT=2,a.KI_BACKSPACE=8,a.KI_TAB=9,a.KI_ENTER=13,a.KI_SHIFT=16,a.KI_CTRL=17,a.KI_ALT=18,a.KI_PAUSE_BREAK=19,a.KI_CAPS_LOCK=20,a.KI_ESCAPE=27,a.KI_PAGE_UP=33,a.KI_PAGE_DOWN=34,a.KI_END=35,a.KI_HOME=36,a.KI_LEFT_ARROW=37,a.KI_UP_ARROW=38,a.KI_RIGHT_ARROW=39,a.KI_DOWN_ARROW=40,a.KI_INSERT=45,a.KI_DELETE=46,a.KI_0=48,a.KI_1=49,a.KI_2=50,a.KI_3=51,a.KI_4=52,a.KI_5=53,a.KI_6=54,a.KI_7=55,a.KI_8=56,a.KI_9=57,a.KI_A=65,a.KI_B=66,a.KI_C=67,a.KI_D=68,a.KI_E=69,a.KI_F=70,a.KI_G=71,a.KI_H=72,a.KI_I=73,a.KI_J=74,a.KI_K=75,a.KI_L=76,a.KI_M=77,a.KI_N=78,a.KI_O=79,a.KI_P=80,a.KI_Q=81,a.KI_R=82,a.KI_S=83,a.KI_T=84,a.KI_U=85,a.KI_V=86,a.KI_W=87,a.KI_X=88,a.KI_Y=89,a.KI_Z=90,a.KI_LEFT_WINDOW_KEY=91,a.KI_RIGHT_WINDOW_KEY=92,a.KI_SELECT_KEY=93,a.KI_NUMPAD_0=96,a.KI_NUMPAD_1=97,a.KI_NUMPAD_2=98,a.KI_NUMPAD_3=99,a.KI_NUMPAD_4=100,a.KI_NUMPAD_5=101,a.KI_NUMPAD_6=102,a.KI_NUMPAD_7=103,a.KI_NUMPAD_8=104,a.KI_NUMPAD_9=105,a.KI_MULTIPLY=106,a.KI_ADD=107,a.KI_SUBTRACT=109,a.KI_DECIMAL_POINT=110,a.KI_DIVIDE=111,a.KI_F1=112,a.KI_F2=113,a.KI_F3=114,a.KI_F4=115,a.KI_F5=116,a.KI_F6=117,a.KI_F7=118,a.KI_F8=119,a.KI_F9=120,a.KI_F10=121,a.KI_F11=122,a.KI_F12=123,a.KI_NUM_LOCK=144,a.KI_SCROLL_LOCK=145,a.KI_SEMI_COLON=186,a.KI_EQUAL_SIGN=187,a.KI_COMMA=188,a.KI_DASH=189,a.KI_PERIOD=190,a.KI_FORWARD_SLASH=191,a.KI_GRAVE_ACCENT=192,a.KI_OPEN_BRACKET=219,a.KI_BACK_SLASH=220,a.KI_CLOSE_BRAKET=221,a.KI_SINGLE_QUOTE=222,a.KI_SPACE=32,window.requestAnimationFrame||(window.requestAnimationFrame=function(){return window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(a,b){window.setTimeout(a,1e3/60)}}())})(GLGE),function(a){a.Wavefront=function(b){this.multimaterials=[],this.materials={},this.instances=[],this.queue=[],this.idMaterials=[],a.Object.call(this,b),a.Assets.registerAsset(this,b)},a.augment(a.Object,a.Wavefront),a.Wavefront.prototype.getAbsolutePath=function(a,b){if(a.substr(0,7)=="http://"||a.substr(0,7)=="file://"||a.substr(0,8)=="https://")return a;b||(b=window.location.href),b.indexOf("?")>0&&(b=b.substr(0,b.indexOf("?")));var c=b.split("/"),d=c[2],e=c[0],f=[];for(var g=3;g<c.length-1;g++)f.push(c[g]);a.substr(0,1)=="/"&&(f=[]);var h=a.split("/");for(g=0;g<h.length;g++)h[g]==".."?f.pop():h[g]!=""&&f.push(h[g]);return e+"//"+d+"/"+f.join("/")},a.Wavefront.prototype.loadMaterials=function(a){this.loading?this.queue.push(a):this.loadFile(a,null,function(a,b){this.parseMaterials(b.split("\n"));if(this.queue.length>0){var c=this.queue.pop();this.loadMaterials(c,this.src)}else this.parseMesh(),this.fireEvent("loaded",{})})},a.Wavefront.prototype.parseMaterials=function(b){var c=0,d=0,e=0,f;while(d<b.length){if(b[d].substr(0,6)=="newmtl"){var g=b[d].replace(/^\s+|\s+$/g,"").replace(/\s+/g," ").split(" "),h=new a.Material;f=b[c].substr(7),c=d+1;while(b[c].substr(0,6)!="newmtl"){g=b[c].replace(/^\s+|\s+$/g,"").replace(/\s+/g," ").split(" ");if(g.length>1)switch(g[0]){case"Kd":h.setColorR(parseFloat(g[1])),h.setColorG(parseFloat(g[2])),h.setColorB(parseFloat(g[3]));break;case"Ks":h.setSpecularColor({r:parseFloat(g[1]),g:parseFloat(g[2]),b:parseFloat(g[3])});break;case"Ns":h.setShininess(parseFloat(g[1]));break;case"d":this.setZtransparent(!0),h.setAlpha(parseFloat(g[1]));break;case"map_Kd":var i=new a.MaterialLayer;i.setMapto(a.M_COLOR),i.setMapinput(a.UV1);var j=new a.Texture,k=1;while(g[k][0]=="-")k=k+2;j.setSrc(this.getAbsolutePath(g[k],this.relativeTo)),h.addTexture(j),i.setTexture(j),h.addMaterialLayer(i);break;case"map_Ks":case"map_spec":var i=new a.MaterialLayer;i.setMapto(a.M_SPECULAR),i.setMapinput(a.UV1);var j=new a.Texture,k=1;while(g[k][0]=="-")k=k+2;j.setSrc(this.getAbsolutePath(g[k],this.relativeTo)),h.addTexture(j),i.setTexture(j),h.addMaterialLayer(i);break;case"bump":case"map_bump":var i=new a.MaterialLayer;i.setMapto(a.M_NOR),i.setMapinput(a.UV1);var j=new a.Texture,k=1;while(g[k][0]=="-")k=k+2;j.setSrc(this.getAbsolutePath(g[k],this.relativeTo)),h.addTexture(j),i.setTexture(j),h.addMaterialLayer(i)}c++;if(c>=b.length)break}d=c-1,this.materials[e]=h,this.idMaterials.push(f),e++}d++}},a.Wavefront.prototype.loadFile=function(b,c,d){this.loading=!0,d||(d=this.loaded),!c&&this.relativeTo&&(c=this.relativeTo),b=this.getAbsolutePath(b,c),this.relativeTo||(this.relativeTo=b);var e=new XMLHttpRequest,f=this;e&&(e.overrideMimeType("text/plain"),e.onreadystatechange=function(){this.readyState==4&&(this.status==200||this.status==0?(f.loading=!1,d.call(f,b,this.responseText)):a.error("Error loading Document: "+b+" status "+this.status))},e.open("GET",b,!0),e.send(""))},a.Wavefront.prototype.setSrc=function(a,b){this.src=this.getAbsolutePath(a,b),this.loadFile(this.src,b)},a.Wavefront.prototype.loaded=function(a,b){this.file=objArray=b.split("\n");var c=!1;for(var d=0;d<objArray.length;d++){var e=objArray[d].split(" ");e.length>1&&(e[0]=="mtllib"&&(c=!0,this.loadMaterials(e[1])))}c||(this.parseMesh(),this.fireEvent("loaded",{}))},a.Wavefront.prototype.createMultiMaterial=function(b,c,d,e,f,g,h,i){var j=[],k=[],l=[],m=[],n=[],o={};for(var p=0;p<g.length;p++){var q=b[g[p]],r=o[q];typeof r!=="undefined"&&i?m.push(o[q]):(n.push(q),o[q]=n.length-1,m.push(n.length-1))}g=m;for(p=0;p<n.length;p++){if(n[p].indexOf("/")>0)var s=n[p].split("/");else var s=[n[p]];d[s[0]-1]||a.error(s[0]),j.push(d[s[0]-1][1]),j.push(d[s[0]-1][2]),j.push(d[s[0]-1][3]),s[1]&&(l.push(f[s[1]-1][1]),l.push(f[s[1]-1][2])),s[2]&&(k.push(e[s[2]-1][1]),k.push(e[s[2]-1][2]),k.push(e[s[2]-1][3]))}if(j.length/3>65024){var t=[],u=[],v=[];for(var p=0;p<g.length;p++)t.push(j[g[p]*3],j[g[p]*3+1],j[g[p]*3+2]),k.length>0&&u.push(k[g[p]*3],k[g[p]*3+1],k[g[p]*3+2]),l.length>0&&v.push(l[g[p]*2],l[g[p]*2+1]);j=t,k=u,l=v,g=[]}var w=new a.MultiMaterial,x=new a.Mesh;x.setPositions(j),k.length>0&&x.setNormals(k),l.length>0&&x.setUV(l),g.length>0&&x.setFaces(g),w.setMesh(x),w.setMaterial(h),this.addMultiMaterial(w)},a.Wavefront.prototype.parseMesh=function(){objArray=this.file;var b=[],c=[],d=[],e=[],f=[],g={},h=0,i=!0,j=new a.Material;for(var k=0;k<objArray.length;k++)if(objArray[k][0]!="#"){var l=objArray[k].replace(/^\s+|\s+$/g,"").replace(/\s+/g," ").split(" ");if(l.length>0)switch(l[0]){case"s":l[1]=="1"?i=!0:i=!1;case"o":e.length>0&&(this.createMultiMaterial(f,g,c,d,b,e,j,i),e=[],j=new a.Material);break;case"usemtl":e.length>0&&(this.createMultiMaterial(f,g,c,d,b,e,j,i),e=[]),this.idMaterials.indexOf(l[1])==-1?j=this.materials[0]:j=this.materials[this.idMaterials.indexOf(l[1])];break;case"v":c.push(l);break;case"vt":b.push(l);break;case"vn":d.push(l);break;case"f":var m=[];for(var n=1;n<l.length;n++){var o=g[l[n]];if(typeof o==="undefined"||!i)f.push(l[n]),o=f.length-1,g[l[n]]=o;m.push(o)}for(n=0;n<m.length-2;n++)e.push(m[0]-h),e.push(m[1+n]-h),e.push(m[2+n]-h)}}this.createMultiMaterial(f,g,c,d,b,e,j,i)},a.Document.prototype.getWavefront=function(b){if(!b.object){var c=this.getAbsolutePath(this.rootURL,null);b.object=new(a[this.classString(b.tagName)]),b.object.setSrc(b.getAttribute("src"),c),b.removeAttribute("src"),this.setProperties(b)}return b.object}}(GLGE);var LZMA=LZMA||{};LZMA.OutWindow=function(){this._windowSize=0},LZMA.OutWindow.prototype.create=function(a){if(!this._buffer||this._windowSize!==a)this._buffer=[];this._windowSize=a,this._pos=0,this._streamPos=0},LZMA.OutWindow.prototype.flush=function(){var a=this._pos-this._streamPos;if(a!==0){while(a--)this._stream.writeByte(this._buffer[this._streamPos++]);this._pos>=this._windowSize&&(this._pos=0),this._streamPos=this._pos}},LZMA.OutWindow.prototype.releaseStream=function(){this.flush(),this._stream=null},LZMA.OutWindow.prototype.setStream=function(a){this.releaseStream(),this._stream=a},LZMA.OutWindow.prototype.init=function(a){a||(this._streamPos=0,this._pos=0)},LZMA.OutWindow.prototype.copyBlock=function(a,b){var c=this._pos-a-1;c<0&&(c+=this._windowSize);while(b--)c>=this._windowSize&&(c=0),this._buffer[this._pos++]=this._buffer[c++],this._pos>=this._windowSize&&this.flush()},LZMA.OutWindow.prototype.putByte=function(a){this._buffer[this._pos++]=a,this._pos>=this._windowSize&&this.flush()},LZMA.OutWindow.prototype.getByte=function(a){var b=this._pos-a-1;b<0&&(b+=this._windowSize);return this._buffer[b]},LZMA.RangeDecoder=function(){},LZMA.RangeDecoder.prototype.setStream=function(a){this._stream=a},LZMA.RangeDecoder.prototype.releaseStream=function(){this._stream=null},LZMA.RangeDecoder.prototype.init=function(){var a=5;this._code=0,this._range=-1;while(a--)this._code=this._code<<8|this._stream.readByte()},LZMA.RangeDecoder.prototype.decodeDirectBits=function(a){var b=0,c=a,d;while(c--)this._range>>>=1,d=this._code-this._range>>>31,this._code-=this._range&d-1,b=b<<1|1-d,(this._range&4278190080)===0&&(this._code=this._code<<8|this._stream.readByte(),this._range<<=8);return b},LZMA.RangeDecoder.prototype.decodeBit=function(a,b){var c=a[b],d=(this._range>>>11)*c;if((this._code^2147483648)<(d^2147483648)){this._range=d,a[b]+=2048-c>>>5,(this._range&4278190080)===0&&(this._code=this._code<<8|this._stream.readByte(),this._range<<=8);return 0}this._range-=d,this._code-=d,a[b]-=c>>>5,(this._range&4278190080)===0&&(this._code=this._code<<8|this._stream.readByte(),this._range<<=8);return 1},LZMA.initBitModels=function(a,b){while(b--)a[b]=1024},LZMA.BitTreeDecoder=function(a){this._models=[],this._numBitLevels=a},LZMA.BitTreeDecoder.prototype.init=function(){LZMA.initBitModels(this._models,1<<this._numBitLevels)},LZMA.BitTreeDecoder.prototype.decode=function(a){var b=1,c=this._numBitLevels;while(c--)b=b<<1|a.decodeBit(this._models,b);return b-(1<<this._numBitLevels)},LZMA.BitTreeDecoder.prototype.reverseDecode=function(a){var b=1,c=0,d=0,e;for(;d<this._numBitLevels;++d)e=a.decodeBit(this._models,b),b=b<<1|e,c|=e<<d;return c},LZMA.reverseDecode2=function(a,b,c,d){var e=1,f=0,g=0,h;for(;g<d;++g)h=c.decodeBit(a,b+e),e=e<<1|h,f|=h<<g;return f},LZMA.LenDecoder=function(){this._choice=[],this._lowCoder=[],this._midCoder=[],this._highCoder=new LZMA.BitTreeDecoder(8),this._numPosStates=0},LZMA.LenDecoder.prototype.create=function(a){for(;this._numPosStates<a;++this._numPosStates)this._lowCoder[this._numPosStates]=new LZMA.BitTreeDecoder(3),this._midCoder[this._numPosStates]=new LZMA.BitTreeDecoder(3)},LZMA.LenDecoder.prototype.init=function(){var a=this._numPosStates;LZMA.initBitModels(this._choice,2);while(a--)this._lowCoder[a].init(),this._midCoder[a].init();this._highCoder.init()},LZMA.LenDecoder.prototype.decode=function(a,b){if(a.decodeBit(this._choice,0)===0)return this._lowCoder[b].decode(a);if(a.decodeBit(this._choice,1)===0)return 8+this._midCoder[b].decode(a);return 16+this._highCoder.decode(a)},LZMA.Decoder2=function(){this._decoders=[]},LZMA.Decoder2.prototype.init=function(){LZMA.initBitModels(this._decoders,768)},LZMA.Decoder2.prototype.decodeNormal=function(a){var b=1;do b=b<<1|a.decodeBit(this._decoders,b);while(b<256);return b&255},LZMA.Decoder2.prototype.decodeWithMatchByte=function(a,b){var c=1,d,e;do{d=b>>7&1,b<<=1,e=a.decodeBit(this._decoders,(1+d<<8)+c),c=c<<1|e;if(d!==e){while(c<256)c=c<<1|a.decodeBit(this._decoders,c);break}}while(c<256);return c&255},LZMA.LiteralDecoder=function(){},LZMA.LiteralDecoder.prototype.create=function(a,b){var c;if(!this._coders||this._numPrevBits!==b||this._numPosBits!==a){this._numPosBits=a,this._posMask=(1<<a)-1,this._numPrevBits=b,this._coders=[],c=1<<this._numPrevBits+this._numPosBits;while(c--)this._coders[c]=new LZMA.Decoder2}},LZMA.LiteralDecoder.prototype.init=function(){var a=1<<this._numPrevBits+this._numPosBits;while(a--)this._coders[a].init()},LZMA.LiteralDecoder.prototype.getDecoder=function(a,b){return this._coders[((a&this._posMask)<<this._numPrevBits)+((b&255)>>>8-this._numPrevBits)]},LZMA.Decoder=function(){this._outWindow=new LZMA.OutWindow,this._rangeDecoder=new LZMA.RangeDecoder,this._isMatchDecoders=[],this._isRepDecoders=[],this._isRepG0Decoders=[],this._isRepG1Decoders=[],this._isRepG2Decoders=[],this._isRep0LongDecoders=[],this._posSlotDecoder=[],this._posDecoders=[],this._posAlignDecoder=new LZMA.BitTreeDecoder(4),this._lenDecoder=new LZMA.LenDecoder,this._repLenDecoder=new LZMA.LenDecoder,this._literalDecoder=new LZMA.LiteralDecoder,this._dictionarySize=-1,this._dictionarySizeCheck=-1,this._posSlotDecoder[0]=new LZMA.BitTreeDecoder(6),this._posSlotDecoder[1]=new LZMA.BitTreeDecoder(6),this._posSlotDecoder[2]=new LZMA.BitTreeDecoder(6),this._posSlotDecoder[3]=new LZMA.BitTreeDecoder(6)},LZMA.Decoder.prototype.setDictionarySize=function(a){if(a<0)return!1;this._dictionarySize!==a&&(this._dictionarySize=a,this._dictionarySizeCheck=Math.max(this._dictionarySize,1),this._outWindow.create(Math.max(this._dictionarySizeCheck,4096)));return!0},LZMA.Decoder.prototype.setLcLpPb=function(a,b,c){var d=1<<c;if(a>8||b>4||c>4)return!1;this._literalDecoder.create(b,a),this._lenDecoder.create(d),this._repLenDecoder.create(d),this._posStateMask=d-1;return!0},LZMA.Decoder.prototype.init=function(){var a=4;this._outWindow.init(!1),LZMA.initBitModels(this._isMatchDecoders,192),LZMA.initBitModels(this._isRep0LongDecoders,192),LZMA.initBitModels(this._isRepDecoders,12),LZMA.initBitModels(this._isRepG0Decoders,12),LZMA.initBitModels(this._isRepG1Decoders,12),LZMA.initBitModels(this._isRepG2Decoders,12),LZMA.initBitModels(this._posDecoders,114),this._literalDecoder.init();while(a--)this._posSlotDecoder[a].init();this._lenDecoder.init(),this._repLenDecoder.init(),this._posAlignDecoder.init(),this._rangeDecoder.init()},LZMA.Decoder.prototype.decode=function(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k,l,m,n,o,p;this._rangeDecoder.setStream(a),this._outWindow.setStream(b),this.init();while(c<0||i<c){k=i&this._posStateMask;if(this._rangeDecoder.decodeBit(this._isMatchDecoders,(d<<4)+k)===0)l=this._literalDecoder.getDecoder(i++,j),d<7?j=l.decodeNormal(this._rangeDecoder):j=l.decodeWithMatchByte(this._rangeDecoder,this._outWindow.getByte(e)),this._outWindow.putByte(j),d=d<4?0:d-(d<10?3:6);else{if(this._rangeDecoder.decodeBit(this._isRepDecoders,d)===1)m=0,this._rangeDecoder.decodeBit(this._isRepG0Decoders,d)===0?this._rangeDecoder.decodeBit(this._isRep0LongDecoders,(d<<4)+k)===0&&(d=d<7?9:11,m=1):(this._rangeDecoder.decodeBit(this._isRepG1Decoders,d)===0?n=f:(this._rangeDecoder.decodeBit(this._isRepG2Decoders,d)===0?n=g:(n=h,h=g),g=f),f=e,e=n),m===0&&(m=2+this._repLenDecoder.decode(this._rangeDecoder,k),d=d<7?8:11);else{h=g,g=f,f=e,m=2+this._lenDecoder.decode(this._rangeDecoder,k),d=d<7?7:10,o=this._posSlotDecoder[m<=5?m-2:3].decode(this._rangeDecoder);if(o<4)e=o;else{p=(o>>1)-1,e=(2|o&1)<<p;if(o<14)e+=LZMA.reverseDecode2(this._posDecoders,e-o-1,this._rangeDecoder,p);else{e+=this._rangeDecoder.decodeDirectBits(p-4)<<4,e+=this._posAlignDecoder.reverseDecode(this._rangeDecoder);if(e<0){if(e===-1)break;return!1}}}}if(e>=i||e>=this._dictionarySizeCheck)return!1;this._outWindow.copyBlock(e,m),i+=m,j=this._outWindow.getByte(0)}}this._outWindow.flush(),this._outWindow.releaseStream(),this._rangeDecoder.releaseStream();return!0},LZMA.Decoder.prototype.setDecoderProperties=function(a){var b,c,d,e,f;if(a.size<5)return!1;b=a.readByte(),c=b%9,b=~~(b/9),d=b%5,e=~~(b/5);if(!this.setLcLpPb(c,d,e))return!1;f=a.readByte(),f|=a.readByte()<<8,f|=a.readByte()<<16,f+=a.readByte()*16777216;return this.setDictionarySize(f)},LZMA.decompress=function(a,b,c,d){var e=new LZMA.Decoder;if(!e.setDecoderProperties(a))throw"Incorrect stream properties";if(!e.decode(b,c,d))throw"Error in data stream";return!0},LZMA.decompressFile=function(a,b){var c=new LZMA.Decoder,d;if(!c.setDecoderProperties(a))throw"Incorrect stream properties";d=a.readByte(),d|=a.readByte()<<8,d|=a.readByte()<<16,d+=a.readByte()*16777216,a.readByte(),a.readByte(),a.readByte(),a.readByte();if(!c.decode(a,b,d))throw"Error in data stream";return!0};var CTM=CTM||{};CTM.CompressionMethod={RAW:5718354,MG1:3229517,MG2:3295053},CTM.Flags={NORMALS:1},CTM.File=function(a){this.load(a)},CTM.File.prototype.load=function(a){this.header=new CTM.FileHeader(a),this.body=new CTM.FileBody(this.header),this.getReader().read(a,this.body)},CTM.File.prototype.getReader=function(){var a;switch(this.header.compressionMethod){case CTM.CompressionMethod.RAW:a=new CTM.ReaderRAW;break;case CTM.CompressionMethod.MG1:a=new CTM.ReaderMG1;break;case CTM.CompressionMethod.MG2:a=new CTM.ReaderMG2}return a},CTM.FileHeader=function(a){a.readInt32(),this.fileFormat=a.readInt32(),this.compressionMethod=a.readInt32(),this.vertexCount=a.readInt32(),this.triangleCount=a.readInt32(),this.uvMapCount=a.readInt32(),this.attrMapCount=a.readInt32(),this.flags=a.readInt32(),this.comment=a.readString()},CTM.FileHeader.prototype.hasNormals=function(){return this.flags&CTM.Flags.NORMALS},CTM.FileBody=function(a){var b=a.triangleCount*3,c=a.vertexCount*3,d=a.hasNormals()?a.vertexCount*3:0,e=a.vertexCount*2,f=a.vertexCount*4,g=0,h=new ArrayBuffer((b+c+d+e*a.uvMapCount+f*a.attrMapCount)*4);this.indices=new Uint32Array(h,0,b),this.vertices=new Float32Array(h,b*4,c),a.hasNormals()&&(this.normals=new Float32Array(h,(b+c)*4,d));if(a.uvMapCount){this.uvMaps=[];for(g=0;g<a.uvMapCount;++g)this.uvMaps[g]={uv:new Float32Array(h,(b+c+d+g*e)*4,e)}}if(a.attrMapCount){this.attrMaps=[];for(g=0;g<a.attrMapCount;++g)this.attrMaps[g]={attr:new Float32Array(h,(b+c+d+e*a.uvMapCount+g*f)*4,f)}}},CTM.FileMG2Header=function(a){a.readInt32(),this.vertexPrecision=a.readFloat32(),this.normalPrecision=a.readFloat32(),this.lowerBoundx=a.readFloat32(),this.lowerBoundy=a.readFloat32(),this.lowerBoundz=a.readFloat32(),this.higherBoundx=a.readFloat32(),this.higherBoundy=a.readFloat32(),this.higherBoundz=a.readFloat32(),this.divx=a.readInt32(),this.divy=a.readInt32(),this.divz=a.readInt32(),this.sizex=(this.higherBoundx-this.lowerBoundx)/this.divx,this.sizey=(this.higherBoundy-this.lowerBoundy)/this.divy,this.sizez=(this.higherBoundz-this.lowerBoundz)/this.divz},CTM.ReaderRAW=function(){},CTM.ReaderRAW.prototype.read=function(a,b){this.readIndices(a,b.indices),this.readVertices(a,b.vertices),b.normals&&this.readNormals(a,b.normals),b.uvMaps&&this.readUVMaps(a,b.uvMaps),b.attrMaps&&this.readAttrMaps(a,b.attrMaps)},CTM.ReaderRAW.prototype.readIndices=function(a,b){a.readInt32(),a.readArrayInt32(b)},CTM.ReaderRAW.prototype.readVertices=function(a,b){a.readInt32(),a.readArrayFloat32(b)},CTM.ReaderRAW.prototype.readNormals=function(a,b){a.readInt32(),a.readArrayFloat32(b)},CTM.ReaderRAW.prototype.readUVMaps=function(a,b){var c=0;for(;c<b.length;++c)a.readInt32(),b[c].name=a.readString(),b[c].filename=a.readString(),a.readArrayFloat32(b[c].uv)},CTM.ReaderRAW.prototype.readAttrMaps=function(a,b){var c=0;for(;c<b.length;++c)a.readInt32(),b[c].name=a.readString(),a.readArrayFloat32(b[c].attr)},CTM.ReaderMG1=function(){},CTM.ReaderMG1.prototype.read=function(a,b){this.readIndices(a,b.indices),this.readVertices(a,b.vertices),b.normals&&this.readNormals(a,b.normals),b.uvMaps&&this.readUVMaps(a,b.uvMaps),b.attrMaps&&this.readAttrMaps(a,b.attrMaps)},CTM.ReaderMG1.prototype.readIndices=function(a,b){a.readInt32(),a.readInt32();var c=new CTM.InterleavedStream(b,3);LZMA.decompress(a,a,c,c.data.length),CTM.restoreIndices(b,b.length)},CTM.ReaderMG1.prototype.readVertices=function(a,b){a.readInt32(),a.readInt32();var c=new CTM.InterleavedStream(b,1);LZMA.decompress(a,a,c,c.data.length)},CTM.ReaderMG1.prototype.readNormals=function(a,b){a.readInt32(),a.readInt32();var c=new CTM.InterleavedStream(b,3);LZMA.decompress(a,a,c,c.data.length)},CTM.ReaderMG1.prototype.readUVMaps=function(a,b){var c=0;for(;c<b.length;++c){a.readInt32(),b[c].name=a.readString(),b[c].filename=a.readString(),a.readInt32();var d=new CTM.InterleavedStream(b[c].uv,2);LZMA.decompress(a,a,d,d.data.length)}},CTM.ReaderMG1.prototype.readAttrMaps=function(a,b){var c=0;for(;c<b.length;++c){a.readInt32(),b[c].name=a.readString(),a.readInt32();var d=new CTM.InterleavedStream(b[c].attr,4);LZMA.decompress(a,a,d,d.data.length)}},CTM.ReaderMG2=function(){},CTM.ReaderMG2.prototype.read=function(a,b){this.MG2Header=new CTM.FileMG2Header(a),this.readVertices(a,b.vertices),this.readIndices(a,b.indices),b.normals&&this.readNormals(a,b),b.uvMaps&&this.readUVMaps(a,b.uvMaps),b.attrMaps&&this.readAttrMaps(a,b.attrMaps)},CTM.ReaderMG2.prototype.readVertices=function(a,b){a.readInt32(),a.readInt32();var c=new CTM.InterleavedStream(b,3);LZMA.decompress(a,a,c,c.data.length);var d=this.readGridIndices(a,b);CTM.restoreVertices(b,this.MG2Header,d,this.MG2Header.vertexPrecision)},CTM.ReaderMG2.prototype.readGridIndices=function(a,b){a.readInt32(),a.readInt32();var c=new Uint32Array(b.length/3),d=new CTM.InterleavedStream(c,1);LZMA.decompress(a,a,d,d.data.length),CTM.restoreGridIndices(c,c.length);return c},CTM.ReaderMG2.prototype.readIndices=function(a,b){a.readInt32(),a.readInt32();var c=new CTM.InterleavedStream(b,3);LZMA.decompress(a,a,c,c.data.length),CTM.restoreIndices(b,b.length)},CTM.ReaderMG2.prototype.readNormals=function(a,b){a.readInt32(),a.readInt32();var c=new CTM.InterleavedStream(b.normals,3);LZMA.decompress(a,a,c,c.data.length);var d=CTM.calcSmoothNormals(b.indices,b.vertices);CTM.restoreNormals(b.normals,d,this.MG2Header.normalPrecision)},CTM.ReaderMG2.prototype.readUVMaps=function(a,b){var c=0;for(;c<b.length;++c){a.readInt32(),b[c].name=a.readString(),b[c].filename=a.readString();var d=a.readFloat32();a.readInt32();var e=new CTM.InterleavedStream(b[c].uv,2);LZMA.decompress(a,a,e,e.data.length),CTM.restoreMap(b[c].uv,2,d)}},CTM.ReaderMG2.prototype.readAttrMaps=function(a,b){var c=0;for(;c<b.length;++c){a.readInt32(),b[c].name=a.readString();var d=a.readFloat32();a.readInt32();var e=new CTM.InterleavedStream(b[c].attr,4);LZMA.decompress(a,a,e,e.data.length),CTM.restoreMap(b[c].attr,4,d)}},CTM.restoreIndices=function(a,b){var c=3;b>0&&(a[2]+=a[0]);for(;c<b;c+=3)a[c]+=a[c-3],a[c]===a[c-3]?a[c+1]+=a[c-2]:a[c+1]+=a[c],a[c+2]+=a[c]},CTM.restoreGridIndices=function(a,b){var c=1;for(;c<b;++c)a[c]+=a[c-1]},CTM.restoreVertices=function(a,b,c,d){var e,f,g,h,i,j=new Uint32Array(a.buffer,a.byteOffset,a.length),k=b.divx,l=k*b.divy,m=2147483647,n=0,o=0,p=0,q=c.length;for(;o<q;p+=3)g=e=c[o++],i=~~(g/l),g-=~~(i*l),h=~~(g/k),g-=~~(h*k),f=j[p],e===m&&(f+=n),a[p]=b.lowerBoundx+g*b.sizex+d*f,a[p+1]=b.lowerBoundy+h*b.sizey+d*j[p+1],a[p+2]=b.lowerBoundz+i*b.sizez+d*j[p+2],m=e,n=f},CTM.restoreNormals=function(a,b,c){var d,e,f,g,h,i,j,k,l,m,n=new Uint32Array(a.buffer,a.byteOffset,a.length),o=0,p=a.length,q=1.5707963267948966;for(;o<p;o+=3)d=n[o]*c,e=n[o+1],e===0?(a[o]=b[o]*d,a[o+1]=b[o+1]*d,a[o+2]=b[o+2]*d):(e>4?f=(n[o+2]*4/e-2)*q:f=(n[o+2]-2)*q,e*=c*q,g=d*Math.sin(e),h=g*Math.cos(f),i=g*Math.sin(f),j=d*Math.cos(e),l=b[o+1],k=b[o]-b[o+2],m=Math.sqrt(2*l*l+k*k),m>1e-20&&(k/=m,l/=m),a[o]=b[o]*j+(b[o+1]*l-b[o+2]*k)*i-l*h,a[o+1]=b[o+1]*j-(b[o+2]+b[o])*l*i+k*h,a[o+2]=b[o+2]*j+(b[o]*k+b[o+1]*l)*i+l*h)},CTM.restoreMap=function(a,b,c){var d,e,f=new Uint32Array(a.buffer,a.byteOffset,a.length),g=0,h,i=a.length;for(;g<b;++g){d=0;for(h=g;h<i;h+=b)e=f[h],d+=e&1?-(e+1>>1):e>>1,a[h]=d*c}},CTM.calcSmoothNormals=function(a,b){var c=new Float32Array(b.length),d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;for(q=0,r=a.length;q<r;)d=a[q++]*3,e=a[q++]*3,f=a[q++]*3,j=b[e]-b[d],m=b[f]-b[d],k=b[e+1]-b[d+1],n=b[f+1]-b[d+1],l=b[e+2]-b[d+2],o=b[f+2]-b[d+2],g=k*o-l*n,h=l*m-j*o,i=j*n-k*m,p=Math.sqrt(g*g+h*h+i*i),p>1e-10&&(g/=p,h/=p,i/=p),c[d]+=g,c[d+1]+=h,c[d+2]+=i,c[e]+=g,c[e+1]+=h,c[e+2]+=i,c[f]+=g,c[f+1]+=h,c[f+2]+=i;for(q=0,r=c.length;q<r;q+=3)p=Math.sqrt(c[q]*c[q]+c[q+1]*c[q+1]+c[q+2]*c[q+2]),p>1e-10&&(c[q]/=p,c[q+1]/=p,c[q+2]/=p);return c},CTM.isLittleEndian=function(){var a=new ArrayBuffer(2),b=new Uint8Array(a),c=new Uint16Array(a);b[0]=1;return c[0]===1}(),CTM.InterleavedStream=function(a,b){this.data=new Uint8Array(a.buffer,a.byteOffset,a.byteLength),this.offset=CTM.isLittleEndian?3:0,this.count=b*4,this.len=this.data.length},CTM.InterleavedStream.prototype.writeByte=function(a){this.data[this.offset]=a,this.offset+=this.count,this.offset>=this.len&&(this.offset-=this.len-4,this.offset>=this.count&&(this.offset-=this.count+(CTM.isLittleEndian?1:-1)))},CTM.Stream=function(a){this.data=a,this.offset=0},CTM.Stream.prototype.TWO_POW_MINUS23=Math.pow(2,-23),CTM.Stream.prototype.TWO_POW_MINUS126=Math.pow(2,-126),CTM.Stream.prototype.readByte=function(){return this.data.charCodeAt(this.offset++)&255},CTM.Stream.prototype.readInt32=function(){var a=this.readByte();a|=this.readByte()<<8,a|=this.readByte()<<16;return a|this.readByte()<<24},CTM.Stream.prototype.readFloat32=function(){var a=this.readByte();a+=this.readByte()<<8;var b=this.readByte(),c=this.readByte();a+=(b&127)<<16;var d=(c&127)<<1|(b&128)>>>7,e=c&128?-1:1;if(d===255)return a!==0?NaN:e*Infinity;if(d>0)return e*(1+a*this.TWO_POW_MINUS23)*Math.pow(2,d-127);if(a!==0)return e*a*this.TWO_POW_MINUS126;return e*0},CTM.Stream.prototype.readString=function(){var a=this.readInt32();this.offset+=a;return this.data.substr(this.offset-a,a)},CTM.Stream.prototype.readArrayInt32=function(a){var b=0,c=a.length;while(b<c)a[b++]=this.readInt32();return a},CTM.Stream.prototype.readArrayFloat32=function(a){var b=0,c=a.length;while(b<c)a[b++]=this.readFloat32();return a},function(a){a.OpenCTM=function(b){this.multimaterials=[],this.materials={},this.instances=[],this.queue=[],this.idMaterials=[],a.Object.call(this,b),a.Assets.registerAsset(this,b)},a.augment(a.Object,a.OpenCTM),a.OpenCTM.prototype.getAbsolutePath=function(a,b){if(a.substr(0,7)=="http://"||a.substr(0,7)=="file://"||a.substr(0,7)=="https://")return a;b||(b=window.location.href),b.indexOf("?")>0&&(b=b.substr(0,b.indexOf("?")));var c=b.split("/"),d=c[2],e=c[0],f=[];for(var g=3;g<c.length-1;g++)f.push(c[g]);a.substr(0,1)=="/"&&(f=[]);var h=a.split("/");for(g=0;g<h.length;g++)h[g]==".."?f.pop():h[g]!=""&&f.push(h[g]);return e+"//"+d+"/"+f.join("/")},a.OpenCTM.prototype.loadFile=function(b,c,d){this.loading=!0,d||(d=this.loaded),!c&&this.relativeTo&&(c=this.relativeTo),b=this.getAbsolutePath(b,c),this.relativeTo||(this.relativeTo=b);var e=new XMLHttpRequest,f=this;e&&(e.overrideMimeType("text/plain; charset=x-user-defined"),e.onreadystatechange=function(){this.readyState==4&&(this.status==200||this.status==0?(f.loading=!1,d.call(f,b,this.responseText)):a.error("Error loading Document: "+b+" status "+this.status))},e.open("GET",b,!0),e.send(""))},a.OpenCTM.prototype.setSrc=function(a,b){this.src=this.getAbsolutePath(a,b),this.loadFile(this.src,b)},a.OpenCTM.prototype.loaded=function(a,b){var c=new CTM.Stream(b),d=new CTM.File(c);this.parseMesh(d),this.fireEvent("loaded",{})},a.OpenCTM.prototype.parseMesh=function(b){var c=b.body.vertices,d=b.body.normals||[],e=b.body.uvMaps?b.body.uvMaps[0].uv:[],f=b.body.indices||[];if(c.length/3>65024){var g=[],h=[],i=[];for(var j=0;j<f.length;j++)g.push(c[f[j]*3],c[f[j]*3+1],c[f[j]*3+2]),d.length>0&&h.push(d[f[j]*3],d[f[j]*3+1],d[f[j]*3+2]),e.length>0&&i.push(e[f[j]*2],e[f[j]*2+1]);c=g,d=h,e=i,f=[]}var k=new a.Mesh;k.setPositions(c),d.length>0&&k.setNormals(d),e.length>0&&k.setUV(e),f.length>0&&k.setFaces(f),this.setMesh(k)},a.Document.prototype.getOpenCTM=function(b){if(!b.object){var c=this.getAbsolutePath(this.rootURL,null);b.object=new(a[this.classString(b.tagName)]),b.object.setSrc(b.getAttribute("src"),c),b.removeAttribute("src"),this.setProperties(b)}return b.object},a.Scene.prototype.addOpenCTM=a.Scene.prototype.addObject}(GLGE),function(a){a.Scene.prototype.physicsGravity=[0,0,-9.8,0],a.Scene.prototype.getPhysicsNodes=function(b){b||(b=[]),this.jigLibObj&&b.push(this);if(this.children)for(var c=0;c<this.children.length;c++)a.Scene.prototype.getPhysicsNodes.call(this.children[c],b);return b},a.Scene.prototype.physicsPick=function(b,c,d){this.physicsSystem||this.physicsTick(0,!0);var e=this.makeRay(b,c);if(e){var f=this.physicsSystem.getCollisionSystem(),g=new jigLib.JSegment(e.origin,a.scaleVec3(e.coord,-1e3)),h={};return f.segmentIntersect(h,g,d?d.jigLibObj:null)?{object:h.rigidBody.GLGE,normal:h.normal,distance:h.frac*1e3,position:h.position}:!1}},a.Scene.prototype.physicsPickObject=function(b,c,d){this.physicsSystem||this.physicsTick(0,!0);var e=this.makeRay(b,c);if(e){var f=d.jigLibObj,g=new jigLib.JSegment(e.origin,a.scaleVec3(e.coord,-1e3)),h={};return f.segmentIntersect(h,g)?{normal:h.normal,distance:h.frac*1e3,position:h.position}:!1}},a.Scene.prototype.segmentTest=function(a,b,c){if(!this.physicsSystem||!this.physicsSystem._collisionSystem)return!1;var d=new jigLib.JSegment(a,b),e={};if(this.physicsSystem._collisionSystem.segmentIntersect(e,d,c?c.jigLibObj:null)){var f=Math.sqrt(b[0]*b[0]+b[1]*b[1]+b[2]*b[2]);return{object:e.rigidBody.GLGE,normal:e.normal,distance:e.frac*f,position:e.position}}return!1},a.Scene.prototype.physicsTick=function(a,b){var c=this.getPhysicsNodes();if(!this.physicsSystem){this.physicsSystem=jigLib.PhysicsSystem.getInstance(),this.physicsSystem.setGravity(this.physicsGravity);for(var d=0;d<c.length;d++)c[d].jigLibObj&&this.physicsSystem.addBody(c[d].jigLibObj);var e=this;this.addEventListener("childAdded",function(a){a.obj.jigLibObj&&e.physicsSystem.addBody(a.obj.jigLibObj)}),this.addEventListener("childRemoved",function(a){a.obj.jigLibObj&&e.physicsSystem.removeBody(a.obj.jigLibObj)})}for(var d=0;d<c.length;d++)c[d].jigLibObj&&c[d].preProcess(a);b||this.physicsSystem.integrate(a)},a.Scene.prototype.setGravity=function(a){this.physicsGravity=a,this.physicsSystem&&this.physicsSystem.setGravity(a);return this},a.Scene.prototype.getGravity=function(a){return this.physicsSystem.getGravity(a)},a.Group.prototype.addPhysicsPlane=a.Group.prototype.addChild,a.Group.prototype.addPhysicsBox=a.Group.prototype.addChild,a.Group.prototype.addPhysicsSphere=a.Group.prototype.addChild,a.Group.prototype.addPhysicsMesh=a.Group.prototype.addChild,a.Scene.prototype.addPhysicsPlane=a.Group.prototype.addChild,a.Scene.prototype.addPhysicsBox=a.Group.prototype.addChild,a.Scene.prototype.addPhysicsSphere=a.Group.prototype.addChild,a.Scene.prototype.addPhysicsMesh=a.Group.prototype.addChild}(GLGE),function(a){a.PhysicsAbstract=function(a){this.children=[]},a.augment(a.Group,a.PhysicsAbstract),a.PHYSICS_ALL=1,a.PHYSICS_LOC=2,a.PhysicsAbstract.prototype.physicsType=a.PHYSICS_ALL,a.PhysicsAbstract.prototype.sync=!0,a.PhysicsAbstract.prototype.setType=function(a){this.physicsType=a;return this},a.PhysicsAbstract.prototype.getType=function(a){return this.physicsType},a.PhysicsAbstract.prototype.preProcess=function(a){if(this.sync){var b=this.getModelMatrix();this.jigLibObj.moveTo([b[3],b[7],b[11],0]);if(this.physicsType==1){var c=Math.sqrt(b[0]*b[0]+b[1]*b[1]+b[2]*b[2]),d=Math.sqrt(b[4]*b[4]+b[5]*b[5]+b[6]*b[6]),e=Math.sqrt(b[8]*b[8]+b[9]*b[9]+b[10]*b[10]);this.jigLibObj.setOrientation(new jigLib.Matrix3D([b[0]/c,b[1]/c,b[2]/c,0,b[4]/d,b[5]/d,b[6]/d,0,b[8]/e,b[9]/e,b[10]/e,0,0,0,0,1]))}this.sync=!1}},a.PhysicsAbstract.prototype.get_transform=function(){return new jigLib.Matrix3D(this.getModelMatrix())},a.PhysicsAbstract.prototype.updateMatrix=function(){this.globalMatrix=null,this.sync=!0,a.Placeable.prototype.updateMatrix.call(this)},a.PhysicsAbstract.prototype.getModelMatrix=function(){if(this.globalMatrix)return this.globalMatrix;return a.Placeable.prototype.getModelMatrix.call(this)},a.PhysicsAbstract.prototype.set_transform=function(b){b=b.glmatrix;var c=[b[0],b[1],b[2],b[3],b[4],b[5],b[6],b[7],b[8],b[9],b[10],b[11],b[12],b[13],b[14],b[15]];this.locX=b[3],this.locY=b[7],this.locZ=b[11],c=a.mulMat4(c,this.getScaleMatrix());if(this.physicsType!=1){var d=this.getModelMatrix();c[0]=d[0],c[1]=d[1],c[2]=d[2],c[4]=d[4],c[5]=d[5],c[6]=d[6],c[8]=d[8],c[9]=d[9],c[10]=d[10]}this.globalMatrix=c;if(this.children)for(var e=0;e<this.children.length;e++)this.children[e].updateMatrix();return this},a.PhysicsAbstract.prototype.setVelocity=function(b,c){this.getMovable()||a.error("Cannot set velocity on static object"),this.jigLibObj.setVelocity(b,c);return this},a.PhysicsAbstract.prototype.setVelocityX=function(b){this.getMovable()||a.error("Cannot set velocity on static object");var c=this.jigLibObj.getVelocity([0,0,0]);c[0]=+b,this.jigLibObj.setVelocity(c);return this},a.PhysicsAbstract.prototype.setVelocityY=function(b){this.getMovable()||a.error("Cannot set velocity on static object");var c=this.jigLibObj.getVelocity([0,0,0]);c[1]=+b,this.jigLibObj.setVelocity(c);return this},a.PhysicsAbstract.prototype.setVelocityZ=function(b){this.getMovable()||a.error("Cannot set velocity on static object");var c=this.jigLibObj.getVelocity([0,0,0]);c[2]=+b,this.jigLibObj.setVelocity(c);return this},a.PhysicsAbstract.prototype.getVelocity=function(){return this.jigLibObj.getVelocity([0,0,0])},a.PhysicsAbstract.prototype.getVelocityX=function(){return this.jigLibObj.getVelocity([0,0,0])[0]},a.PhysicsAbstract.prototype.getVelocityY=function(){return this.jigLibObj.getVelocity([0,0,0])[1]},a.PhysicsAbstract.prototype.getVelocityZ=function(){return this.jigLibObj.getVelocity([0,0,0])[2]},a.PhysicsAbstract.prototype.setAngularVelocity=function(b){this.getMovable()||a.error("Cannot set velocity on static object"),this.jigLibObj.setAngVel(b);return this},a.PhysicsAbstract.prototype.setAngularVelocityX=function(b){this.getMovable()||a.error("Cannot set velocity on static object");var c=this.jigLibObj.getAngVel();c[0]=+b,this.jigLibObj.setAngVel(c);return this},a.PhysicsAbstract.prototype.setAngularVelocityY=function(b){this.getMovable()||a.error("Cannot set velocity on static object");var c=this.jigLibObj.getAngVel();c[1]=+b,this.jigLibObj.setAngVel(c);return this},a.PhysicsAbstract.prototype.setAngularVelocityZ=function(b){this.getMovable()||a.error("Cannot set velocity on static object");var c=this.jigLibObj.getAngVel();c[2]=+b,this.jigLibObj.setAngVel(c);return this},a.PhysicsAbstract.prototype.getAngularVelocity=function(){return this.jigLibObj.getAngVel()},a.PhysicsAbstract.prototype.getAngularVelocityX=function(){return this.jigLibObj.getAngVel()[0]},a.PhysicsAbstract.prototype.getAngularVelocityY=function(){return this.jigLibObj.getAngVel()[1]},a.PhysicsAbstract.prototype.getAngularVelocityZ=function(){return this.jigLibObj.getAngVel()[2]},a.PhysicsAbstract.prototype.setMovable=function(a){this.jigLibObj.set_movable(a);return this},a.PhysicsAbstract.prototype.getMovable=function(){return this.jigLibObj.get_movable()},a.PhysicsAbstract.prototype.setFriction=function(a){this.jigLibObj.set_friction(a);return this},a.PhysicsAbstract.prototype.getFriction=function(){return this.jigLibObj.get_friction()},a.PhysicsAbstract.prototype.setMass=function(a){this.jigLibObj.set_mass(a);return this},a.PhysicsAbstract.prototype.getMass=function(){return this.jigLibObj.get_mass()},a.PhysicsAbstract.prototype.setRestitution=function(a){this.jigLibObj.set_restitution(a);return this},a.PhysicsAbstract.prototype.getRestitution=function(){return this.jigLibObj.get_restitution()},a.PhysicsAbstract.prototype.addBodyForce=function(a,b){this.jigLibObj.addBodyForce(a,b);return this},a.PhysicsAbstract.prototype.addWorldForce=function(a,b){this.jigLibObj.addWorldForce(a,b);return this},a.PhysicsAbstract.prototype.addWorldTorque=function(a){this.jigLibObj.addWorldTorque(a);return this},a.PhysicsAbstract.prototype.addBodyTorque=function(a){this.jigLibObj.addBodyTorque(a);return this},a.PhysicsAbstract.prototype.setLinearVelocityDamping=function(a){this.jigLibObj.set_linVelocityDamping(a);return this},a.PhysicsAbstract.prototype.getRotationalVelocityDamping=function(a){return this.jigLibObj.get_rotVelocityDamping()},a.PhysicsAbstract.prototype.getLinearVelocityDamping=function(a){return this.jigLibObj.get_linVelocityDamping()},a.PhysicsAbstract.prototype.setRotationalVelocityDamping=function(a){this.jigLibObj.set_rotVelocityDamping(a);return this},a.PhysicsAbstract.prototype.clearForces=function(){this.jigLibObj.clearForces();return this}}(GLGE),function(a){a.PhysicsBox=function(b){this.jigLibObj=new jigLib.JBox(this,this.width,this.height,this.depth),this.jigLibObj.GLGE=this,this.jigLibObj.addEventListener(jigLib.JCollisionEvent.COLLISION,function(a){this.GLGE.fireEvent("collision",{obj:a.collisionBody.GLGE,impulse:a.collisionImpulse})}),a.PhysicsAbstract.call(this,b)},a.augment(a.PhysicsAbstract,a.PhysicsBox),a.PhysicsBox.prototype.width=1,a.PhysicsBox.prototype.height=1,a.PhysicsBox.prototype.depth=1,a.PhysicsBox.prototype.className="PhysicsBox",a.PhysicsBox.prototype.setWidth=function(a){this.width=a;var b=this.jigLibObj.get_sideLengths();b[0]=+a,this.jigLibObj.set_sideLengths(b);return this},a.PhysicsBox.prototype.setHeight=function(a){this.height=a;var b=this.jigLibObj.get_sideLengths();b[1]=+a,this.jigLibObj.set_sideLengths(b);return this},a.PhysicsBox.prototype.setDepth=function(a){this.depth=a;var b=this.jigLibObj.get_sideLengths();b[2]=+a,this.jigLibObj.set_sideLengths(b);return this},a.PhysicsBox.prototype.getWidth=function(){return this.jigLibObj.get_sideLengths()[0]},a.PhysicsBox.prototype.getHeight=function(){return this.jigLibObj.get_sideLengths()[1]},a.PhysicsBox.prototype.getDepth=function(){return this.jigLibObj.get_sideLengths()[2]}}(GLGE),function(a){a.PhysicsMesh=function(b){this.jigLibObj=new jigLib.JTriangleMesh(null,100,.1),this.jigLibObj.GLGE=this,this.jigLibObj.addEventListener(jigLib.JCollisionEvent.COLLISION,function(a){this.GLGE.fireEvent("collision",{obj:a.collisionBody.GLGE,impulse:a.collisionImpulse})}),this.dirty=!0,this.addEventListener("matrixUpdate",this.makeDirty),this.addEventListener("childMatrixUpdate",this.makeDirty),this.addEventListener("childAdded",this.makeDirty),this.addEventListener("childRemoved",this.makeDirty),a.PhysicsAbstract.call(this,b)},a.augment(a.PhysicsAbstract,a.PhysicsMesh),a.PhysicsMesh.prototype.className="PhysicsMesh",a.PhysicsMesh.prototype.forceUpdate=function(){this.dirty=!0;return this},a.PhysicsMesh.prototype.makeDirty=function(a){this.dirty=!0},a.PhysicsMesh.prototype.preProcess=function(){if(this.dirty){var a=this.getTriangles();this.jigLibObj.createMesh(a.verts,a.faces),this.dirty=!1}},a.PhysicsMesh.prototype.getTriangles=function(){var b=this.getObjects(),c=[],d=[];for(var e=0;e<b.length;e++)if(b[e].multimaterials){var f=b[e].getModelMatrix();for(var g=0;g<b[e].multimaterials.length;g++){var h=b[e].multimaterials[g].getMesh(),i=c.length;if(h){for(var j=0;j<h.positions.length;j=j+3){var k=[h.positions[j],h.positions[j+1],h.positions[j+2],1],l=a.mulMat4Vec4(f,k);c.push([l[0],l[1],l[2],1])}var m=h.faces.data;if(m){var n=m.length;n=(n/3|0)*3;for(var j=0;j<n;j=j+3)d.push([+m[j]+i,+m[j+1]+i,+m[j+2]+i])}else for(var j=0;j<h.positions.length/3;j=j+3)d.push([j+i,j+1+i,j+2+i])}}}return{verts:c,faces:d}}}(GLGE),function(a){a.PHYSICS_XAXIS=[1,0,0,0],a.PHYSICS_YAXIS=[0,1,0,0],a.PHYSICS_ZAXIS=[0,0,1,0],a.PHYSICS_NEGXAXIS=[-1,0,0,0],a.PHYSICS_NEGYAXIS=[0,-1,0,0],a.PHYSICS_NEGZAXIS=[0,0,-1,0],a.PhysicsPlane=function(b){this.jigLibObj=new jigLib.JPlane(this,this.normal,this.distance),this.jigLibObj.GLGE=this,this.jigLibObj.addEventListener(jigLib.JCollisionEvent.COLLISION,function(a){this.GLGE.fireEvent("collision",{obj:a.collisionBody.GLGE,impulse:a.collisionImpulse})}),a.PhysicsAbstract.call(this,b)},a.augment(a.PhysicsAbstract,a.PhysicsPlane),a.PhysicsPlane.prototype.normal=[0,0,1,0],a.PhysicsPlane.prototype.distance=0,a.PhysicsPlane.prototype.className="PhysicsPlane",a.PhysicsPlane.prototype.setNormal=function(a){this.normal=a,this.jigLibObj.set_normal(a);return this},a.PhysicsPlane.prototype.setDistance=function(a){this.distance=a,this.jigLibObj.set_distance(a);return this},a.PhysicsPlane.prototype.getNormal=function(){return this.jigLibObj.get_normal()},a.PhysicsPlane.prototype.getDistance=function(){return this.jigLibObj.get_distance()}}(GLGE),function(a){a.PhysicsSphere=function(b){this.jigLibObj=new jigLib.JSphere(this,this.radius),this.jigLibObj.GLGE=this,this.jigLibObj.addEventListener(jigLib.JCollisionEvent.COLLISION,function(a){this.GLGE.fireEvent("collision",{obj:a.collisionBody.GLGE,impulse:a.collisionImpulse})}),a.PhysicsAbstract.call(this,b)},a.augment(a.PhysicsAbstract,a.PhysicsSphere),a.PhysicsSphere.prototype.radius=1,a.PhysicsSphere.prototype.className="PhysicsSphere",a.PhysicsSphere.prototype.setRadius=function(a){this.physicsRadius=+a,this.jigLibObj.set_radius(+a);return this},a.PhysicsSphere.prototype.getRadius=function(a){return this.jigLibObj.get_radius()}}(GLGE),function(a){a.PhysicsConstraintPoint=function(){},a.augment(a.QuickNotation,a.PhysicsConstraintPoint),a.augment(a.JSONLoader,a.PhysicsConstraintPoint),a.PhysicsConstraintPoint.constraint=null,a.PhysicsConstraintPoint.prototype.className="PhysicsConstraintPoint",a.PhysicsConstraintPoint.prototype.setBody1=function(a){this.body1=a,this.updateConstraint();return this},a.PhysicsConstraintPoint.prototype.setBody2=function(a){this.body2=a,this.updateConstraint();return this},a.PhysicsConstraintPoint.prototype.setBodyPos1=function(a){typeof a=="string"&&(a=a.split(",")),this.bodypos1=[parseFloat(a[0]),parseFloat(a[1]),parseFloat(a[2])],this.updateConstraint();return this},a.PhysicsConstraintPoint.prototype.setBodyPos2=function(a){typeof a=="string"&&(a=a.split(",")),this.bodypos2=[parseFloat(a[0]),parseFloat(a[1]),parseFloat(a[2])],this.updateConstraint();return this},a.PhysicsConstraintPoint.prototype.updateConstraint=function(){this.body1&&this.body2&&this.bodypos1&&this.bodypos2&&(this.constraint&&(this.parent&&this.parent.physicsSystem&&this.parent.physicsSystem.removeConstraint(this.constraint),this.body1.removeConstraint(this.constraint),this.body2.removeConstraint(this.constraint)),this.constraint=new jigLib.JConstraintPoint(this.body1.jigLibObj,this.bodypos1,this.body2.jigLibObj,this.bodypos2),this.parent&&this.parent.physicsSystem&&this.parent.physicsSystem.addConstraint(this.constraint))},a.Scene.prototype.addPhysicsConstraintPoint=function(a){this.constraints||(this.constraints=[]),this.constraints.push(a),this.physicsSystem&&this.physicsSystem.addConstraint(a.constraint);return this},a.Scene.prototype.removePhysicsConstraintPoint=function(a){this.constraints||(this.constraints=[]),this.constraints.indexOf(a)>-1&&(this.constraints.push(a),this.physicsSystem&&this.physicsSystem.removeConstraint(a.constraint));return this}}(GLGE),function(a){a.PhysicsCar=function(b){a.PhysicsBox.call(this,b),this.wheels=[],this.setRotationalVelocityDamping([.1,.6,.1]),this.setLinearVelocityDamping([.996,.92,.996]);return this},a.augment(a.PhysicsBox,a.PhysicsCar),a.PhysicsCar.prototype.className="PhysicsCar",a.Group.prototype.addPhysicsCar=a.Group.prototype.addChild,a.Scene.prototype.addPhysicsCar=a.Group.prototype.addChild,a.PhysicsCar.prototype.drive=function(a){for(var b=0;b<this.wheels.length;b++){var c=this.wheels[b];c.powered&&c.drive(a)}return this},a.PhysicsCar.prototype.brake=function(a){for(var b=0;b<this.wheels.length;b++)this.wheels[b].powered&&this.wheels[b].brake(a);return this},a.PhysicsCar.prototype.addPhysicsWheel=function(b){this.wheels.push(b);return a.PhysicsBox.prototype.addChild.call(this,b)},a.PhysicsCar.prototype.removeWheel=function(b){var c=this.wheels.indexOf(b);c>-1&&this.wheels.splice(c,1);return a.PhsyicsBox.prototype.addChild.call(this,b)},a.PhysicsCar.prototype.getScene=function(){var a=this;while(a.parent)a=a.parent;return a},a.PhysicsCar.prototype.preProcess=function(b){var c=this.getScene(),d=this.getVelocity(),e=this.getMass(),f=this.wheels;for(var g=0;g<f.length;g++){var h=f[g],i=h.getModelMatrix(),j=a.toUnitVec3([i[2],i[6],i[10]]),k=a.toUnitVec3([i[1],i[5],i[9]]),l=a.toUnitVec3([i[0],i[4],i[8]]),m=[i[3],i[7],i[11]],n=h.radius,o=h.travel,p=h.spring,q=h.sideFriction,r=h.frontFriction,s=0,t=c.segmentTest(m,a.scaleVec3(k,-o-n),this);if(t){var u=t.distance-n;u<o&&(s=(o-u)/o*p,this.addWorldForce(a.scaleVec3(k,s),m),h.innerGroup.setLocY(n-t.distance));var v=q,w=a.scaleVec3(j,-a.dotVec3(j,d)*v);this.addWorldForce(w,m)}else h.innerGroup.setLocY(-o);var x=s*r,y=x*b*b/n,z=0;if(h.oldPos){var A=a.dotVec3(a.subVec3(m,h.oldPos),l)/n,z=A/b-h.angVel;z<-y&&(z=-y),z>y&&(z=y)}if(h.driveForce){var B=h.driveForce*(1-h.braking);B<-x&&(B=x),B>x&&(B=x),this.addWorldForce(a.scaleVec3(l,B),m),z+=h.driveForce/e*b/n}if(h.braking){var C=a.dotVec3(d,l),D=-h.braking*C/b;D<-x&&(D=-x),D>x&&(D=x),this.addWorldForce(a.scaleVec3(l,D),m)}h.angVel+=z,h.brake&&(h.angVel*=1-h.braking),h.innerGroup.setRotZ(h.innerGroup.getRotZ()-h.angVel*b),h.angVel*=.995,h.oldPos=m}a.PhysicsBox.prototype.preProcess.call(this,b)},a.PhysicsWheel=function(b){a.Group.call(this,b),this.innerGroup=new a.Group,a.Group.prototype.addChild.call(this,this.innerGroup);return this},a.augment(a.Group,a.PhysicsWheel),a.PhysicsWheel.prototype.radius=1,a.PhysicsWheel.prototype.travel=.75,a.PhysicsWheel.prototype.angVel=0,a.PhysicsWheel.prototype.spring=90,a.PhysicsWheel.prototype.braking=0,a.PhysicsWheel.prototype.driveForce=0,a.PhysicsWheel.prototype.powered=!1,a.PhysicsWheel.prototype.sideFriction=3,a.PhysicsWheel.prototype.frontFriction=3,a.PhysicsWheel.prototype.className="PhysicsWheel",a.PhysicsWheel.prototype.addChild=function(a){return this.innerGroup.addChild(a)},a.PhysicsWheel.prototype.removeChild=function(a){return this.innerGroup.removeChild(a)},a.PhysicsWheel.prototype.addGroup=a.PhysicsWheel.prototype.addChild,a.PhysicsWheel.prototype.addCollada=a.PhysicsWheel.prototype.addChild,a.PhysicsWheel.prototype.addObject=a.PhysicsWheel.prototype.addChild,a.PhysicsWheel.prototype.addMD2=a.PhysicsWheel.prototype.addChild,a.PhysicsWheel.prototype.addMD3=a.PhysicsWheel.prototype.addChild,a.PhysicsWheel.prototype.addWavefront=a.PhysicsWheel.prototype.addChild,a.PhysicsWheel.prototype.setPowered=function(a){this.powered=a;return this},a.PhysicsWheel.prototype.setRadius=function(a){this.radius=a;return this},a.PhysicsWheel.prototype.setSpring=function(a){this.spring=a;return this},a.PhysicsWheel.prototype.setTravel=function(a){this.travel=a;return this},a.PhysicsWheel.prototype.setFrontFriction=function(a){this.frontFriction=a;return this},a.PhysicsWheel.prototype.setSideFriction=function(a){this.sideFriction=a;return this},a.PhysicsWheel.prototype.setWheelRotation=function(a){this.setRotY(a);return this},a.PhysicsWheel.prototype.getWheelRotation=function(a){return this.getRotY()},a.PhysicsWheel.prototype.getRadius=function(){return this.radius},a.PhysicsWheel.prototype.getSpring=function(){return this.spring},a.PhysicsWheel.prototype.getTravel=function(){return this.travel},a.PhysicsWheel.prototype.getFrontFriction=function(){return this.frontFriction},a.PhysicsWheel.prototype.getSideFriction=function(){return this.sideFriction},a.PhysicsWheel.prototype.drive=function(a){this.driveForce=a;return this},a.PhysicsWheel.prototype.brake=function(a){this.braking=a;return this}}(GLGE),function(a){a.FilePreloader=function(){this.files=[]},a.augment(a.Events,a.FilePreloader),a.FilePreloader.prototype.loadedBytes=0,a.FilePreloader.prototype.totalBytes=0,a.FilePreloader.prototype.numLoadedFiles=0,a.FilePreloader.prototype.numTotalFiles=0,a.FilePreloader.prototype.sizesCount=0,a.FilePreloader.prototype.progress=0,a.FilePreloader.prototype.files=null,a.FilePreloader.prototype.addFile=function(a,b,c){this.files.push({url:a,loaded:!1,size:-1,bytesLoaded:0,type:b,callback:c,content:null,preloader:this}),this.numTotalFiles++},a.FilePreloader.prototype.addFileRef=function(a){this.files.push(a),this.numTotalFiles++},a.FilePreloader.prototype.accumulateFileSize=function(a){var b=new XMLHttpRequest;b.preloader=this,b.active=!0,b.file=a,b.overrideMimeType("text/xml"),b.onreadystatechange=function(){this.readyState>1&&b.active&&(this.active=!1,this.file.size=parseFloat(this.getResponseHeader("Content-length")),this.preloader.totalBytes+=this.file.size,++this.preloader.sizesCount>=this.preloader.files.length&&this.preloader.loadFiles(),this.abort(),this.onreadystatechange=null)},b.open("GET",a.url,!0),b.send("")},a.FilePreloader.prototype.start=function(){for(i in this.files)this.accumulateFileSize(this.files[i])},a.FilePreloader.prototype.loadFiles=function(){for(i in this.files){var a=this.files[i];if(a.type=="image"){var b=new Image;a.content=b;var c=this;b.file=a,b.onload=function(){c.fileLoaded(this.file,this.file.size)},b.src=a.url}else{var d=new XMLHttpRequest;d.overrideMimeType("text/xml"),d.preloader=this,d.file=a;var e=setInterval(function(){if(d.readyState==3){var b=d.responseText.length-a.bytesLoaded;a.bytesLoaded=d.responseText.length,d.preloader.update(b)}},100);d.onreadystatechange=function(){if(this.readyState>=4){clearInterval(e),this.file.content=this.responseXML;var a=this.responseText.length-this.file.bytesLoaded;this.preloader.update(a),this.preloader.fileLoaded(this.file,a)}},d.open("GET",a.url,!0),d.send()}}},a.FilePreloader.prototype.update=function(a){this.loadedBytes+=a,this.progress=100*this.loadedBytes/this.totalBytes,this.fireEvent("progress",{progress:this.progress,stepBytes:a,loadedBytes:this.loadedBytes,totalBytes:this.totalBytes,loadedFiles:this.numLoadedFiles,totalFiles:this.numTotalFiles})},a.FilePreloader.prototype.fileLoaded=function(a,b){this.numLoadedFiles++,a.loaded=!0,a.bytesLoaded=a.size,this.numLoadedFiles<this.files.length?this.update(b):(this.progress=100,this.fireEvent("downloadComplete",{file:a,stepBytes:b})),this.fireEvent("fileLoaded",{file:a,stepBytes:b}),a.callback&&a.callback(a)},a.FilePreloader.prototype.getLoadedFiles=function(){var a=[];for(i in this.files)this.files[i].loaded&&a.push(this.files[i]);return a},a.FilePreloader.prototype.getFile=function(a){for(i in this.files)if(this.files[i].url==a)return this.files[i];return-1}}(GLGE),function(a){a.DocumentPreloader=function(b,c){this.imagePreloader=new a.FilePreloader,this.document=b,c.XMLQuota?this.XMLQuota=c.XMLQuota:this.XMLQuota=.2,this.imageQuota=1-this.XMLQuota,c.XMLBytes?this.XMLBytes=c.XMLBytes:c.numXMLFiles?this.numXMLFiles=c.numXMLFiles:this.numXMLFiles=3},a.augment(a.Events,a.DocumentPreloader),a.DocumentPreloader.prototype.progress=0,a.DocumentPreloader.prototype.imageQuota=0,a.DocumentPreloader.prototype.XMLQuota=0,a.DocumentPreloader.prototype.XMLBytes=-1,a.DocumentPreloader.prototype.totalBytes=-1,a.DocumentPreloader.prototype.loadedBytes=0,a.DocumentPreloader.prototype.numXMLFiles=3,a.DocumentPreloader.prototype.state=0,a.DocumentPreloader.prototype.imagePreloader=null,a.DocumentPreloader.prototype.document=null,a.DocumentPreloader.prototype.addImage=function(a){this.imagePreloader.addFile(a,"image")},a.DocumentPreloader.prototype.loadImages=function(){this.changeState(2),this.progress<this.XMLQuota*100&&(this.progress=this.XMLQuota*100);var a=this;this.imagePreloader.addEventListener("progress",function(b){a.updateProgress.call(a,b)}),this.imagePreloader.addEventListener("downloadComplete",function(b){a.finish.call(a,b)}),this.imagePreloader.addEventListener("fileLoaded",function(b){a.fireEvent("fileLoaded",b.file)}),this.imagePreloader.start()},a.DocumentPreloader.prototype.updateProgress=function(a){this.state<2?this.XMLBytes>0?(this.loadedBytes+=a.stepBytes,this.progress=this.XMLQuota*100*this.loadedBytes/this.XMLBytes):(this.progress+=this.XMLQuota*100/this.numXMLFiles,this.progress>this.XMLQuota*100&&(this.progress=this.XMLQuota*100)):this.progress=this.XMLQuota*100+this.imageQuota*this.imagePreloader.progress,this.fireEvent("progress",{progress:this.progress,stepBytes:a.stepBytes,loadedBytes:a.loadedBytes,totalBytes:a.totalBytes,loadedFiles:a.loadedFiles,totalFiles:a.totalFiles})},a.DocumentPreloader.prototype.loadXMLFile=function(b){this.changeState(1);var c=new a.FilePreloader;c.addFile(b,"xml");var d=this;this.XMLBytes>0?c.addEventListener("progress",function(a){d.updateProgress.call(d,a)}):c.addEventListener("downloadComplete",function(a){d.updateProgress.call(d,a)});var e=this.document;c.addEventListener("fileLoaded",function(a){a.file.content.getElementById=e.getElementById,e.loaded(a.file.url,a.file.content),d.fireEvent("fileLoaded",a.file)}),c.start()},a.DocumentPreloader.prototype.changeState=function(a){this.state=a,this.fireEvent("stateChange",a)},a.DocumentPreloader.prototype.finish=function(a){this.changeState(3),this.progress=100,this.fireEvent("downloadComplete")}}(GLGE),function(a){typeof a.GUI=="undefined"&&(a.GUI={}),function(b){b.useLibrary=function(a){a=="jQuery"&&jQuery&&(b.Progressbar.prototype.setValue=function(a){$(this.domRoot).progressbar({value:a})},b.Progressbar.prototype.init=function(){$(this.domRoot).progressbar({value:0})})},b.Widget=function(){this.domRoot=document.createElement("div"),this.domRoot.setAttribute("class","glge-gui-widget-root"),this.init()},b.Widget.prototype.domRoot=null,b.Widget.prototype.init=function(){},b.Progressbar=function(){this.baseclass.call(this),this.domRoot.className+=" glge-gui-progressbar"},b.Progressbar.prototype.value=0,b.Progressbar.prototype.setValue=function(a){this.value=a},a.augment(b.Widget,b.Progressbar)}(a.GUI)}(GLGE),function(a){typeof a.GUI=="undefined"&&(a.GUI={}),function(a){a.Gadget=function(){this.domGadgetRoot=document.createElement("div"),this.domGadgetRoot.setAttribute("class","glge-gui-gadget-root"),this.domGadgetRoot.style.position="absolute",this.domGadgetRoot.style.top="0px",this.domGadgetOuterWrapper=document.createElement("div"),this.domGadgetOuterWrapper.setAttribute("class","glge-gui-gadget-OuterWrapper"),this.domGadgetOuterWrapper.style.position="relative",this.domGadgetRoot.appendChild(this.domGadgetOuterWrapper),this.domGadgetInnerWrapper=document.createElement("div"),this.domGadgetInnerWrapper.setAttribute("class","glge-gui-gadget-InnerWrapper"),this.domGadgetInnerWrapper.style.position="relative",this.domGadgetOuterWrapper.appendChild(this.domGadgetInnerWrapper),this.domGadgetObject=document.createElement("div"),this.domGadgetObject.setAttribute("class","glge-gui-gadget"),this.domGadgetObject.style.position="relative",this.domGadgetInnerWrapper.appendChild(this.domGadgetObject),this.domGadgetFooter=document.createElement("div"),this.domGadgetFooter.setAttribute("class","glge-gui-gadget-footer"),this.domGadgetFooter.style.clear="both",this.domGadgetRoot.appendChild(this.domGadgetFooter),this.position={},this.position.x="middle",this.position.y="middle",this.updatePosition()},a.Gadget.prototype.domGadgetRoot=null,a.Gadget.prototype.domGadgetOuterWrapper=null,a.Gadget.prototype.domGadgetInnerWrapper=null,a.Gadget.prototype.domGadgetObject=null,a.Gadget.prototype.domGadgetFooter=null,a.Gadget.prototype.domGadgetParent=null,a.Gadget.prototype.position=null,a.Gadget.prototype.setPosition=function(a){a&&(a.x&&(this.position.x=a.x),a.y&&(this.position.y=a.y)),this.updatePosition()},a.Gadget.prototype.updatePosition=function(){if(this.domGadgetParent){var a="";document.defaultView&&document.defaultView.getComputedStyle?a=document.defaultView.getComputedStyle(this.domGadgetParent,null).getPropertyValue("position"):this.domGadgetParent.currentStyle&&(a=this.domGadgetParent.currentStyle.position),a=="absolute"?(this.domGadgetRoot.style.width="100%",this.domGadgetRoot.style.height="100%",this.domGadgetRoot.style.display="table",this.domGadgetOuterWrapper.style.display="table-cell",this.position.y=="top"?this.domGadgetOuterWrapper.style.verticalAlign="top":this.position.y=="middle"?this.domGadgetOuterWrapper.style.verticalAlign="middle":this.position.y=="bottom"&&(this.domGadgetOuterWrapper.style.verticalAlign="bottom"),this.position.x=="left"?(this.domGadgetInnerWrapper.style.cssFloat="left",this.domGadgetInnerWrapper.style.left="0px",this.domGadgetObject.style.cssFloat="left",this.domGadgetObject.style.left="0px"):this.position.x=="middle"?(this.domGadgetInnerWrapper.style.cssFloat="right",this.domGadgetInnerWrapper.style.right="50%",this.domGadgetObject.style.cssFloat="left",this.domGadgetObject.style.right="-50%"):this.position.x=="right"&&(this.domGadgetInnerWrapper.style.cssFloat="right",this.domGadgetInnerWrapper.style.right="0px",this.domGadgetObject.style.cssFloat="right",this.domGadgetObject.style.right="0px")):(this.position.y=="top"?this.domGadgetRoot.style.top=this.domGadgetParent.offsetTop:this.position.y=="middle"?this.domGadgetRoot.style.top=this.domGadgetParent.offsetTop+this.domGadgetParent.offsetHeight/2-this.domGadgetRoot.offsetHeight/2:this.position.y=="bottom"&&(this.domGadgetRoot.style.top=this.domGadgetParent.offsetTop+this.domGadgetParent.offsetHeight-this.domGadgetRoot.offsetHeight),this.position.x=="left"?this.domGadgetRoot.style.left=this.domGadgetParent.offsetLeft:this.position.x=="middle"?this.domGadgetRoot.style.left=this.domGadgetParent.offsetLeft+this.domGadgetParent.offsetWidth/2-this.domGadgetRoot.offsetWidth/2:this.position.x=="right"&&(this.domGadgetRoot.style.left=this.domGadgetParent.offsetLeft+this.domGadgetParent.offsetWidth-this.domGadgetRoot.offsetWidth))}},a.Gadget.prototype.addToDOM=function(a,b){this.domGadgetParent=a,this.domGadgetParent.appendChild(this.domGadgetRoot),this.setPosition(b)}}(a.GUI)}(GLGE),function(a){(function(b){b.Preloader=function(){this.baseclass.call(this),this.domGadgetObject.innerHTML="<h1>Loading</h1>",this.domGadgetObject.className+=" glge-gui-gadget-preloader",this.progressBar=new b.Progressbar,this.domGadgetObject.appendChild(this.progressBar.domRoot),this.domPercentageLabel=document.createElement("div"),this.domPercentageLabel.setAttribute("class","glge-gui-gadget-preloader-percentage"),this.domPercentageLabel.innerHTML="<div style='float:left;'>0%</div><div style='float:right;'>100%</div></div>",this.domGadgetObject.appendChild(this.domPercentageLabel),this.domInfoBox=document.createElement("div"),this.domInfoBox.setAttribute("class","glge-gui-gadget-preloader-info"),this.domInfoBox.setAttribute("style","clear:both;"),this.domGadgetObject.appendChild(this.domInfoBox),this.domStateLabel=document.createElement("div"),this.domInfoBox.appendChild(this.domStateLabel),this.domBytesLabel=document.createElement("div"),this.domInfoBox.appendChild(this.domBytesLabel),this.domFilesLabel=document.createElement("div"),this.domInfoBox.appendChild(this.domFilesLabel),this.domLastFileLabel=document.createElement("div"),this.domInfoBox.appendChild(this.domLastFileLabel)},b.Preloader.prototype.progressBar=null,b.Preloader.prototype.documentLoader=null,b.Preloader.prototype.domInfoBox=null,b.Preloader.prototype.domStateLabel=null,b.Preloader.prototype.domBytesLabel=null,b.Preloader.prototype.domFilesLabel=null,b.Preloader.prototype.domLastFileLabel=null,b.Preloader.prototype.domPercentageLabel=null,b.Preloader.prototype.setDocumentLoader=function(a){this.documentLoader=a;var b=this;this.documentLoader.addEventListener("downloadComplete",function(a){b.complete(a)}),this.documentLoader.addEventListener("progress",function(a){b.progress(a)}),this.documentLoader.addEventListener("stateChange",function(a){b.stateChange(a)}),this.documentLoader.addEventListener("fileLoaded",function(a){b.fileLoaded(a)})},b.Preloader.prototype.addToDOM=function(a,b){this.stateChange(this.documentLoader.state),this.progress({progress:0,loadedBytes:0,loadedFiles:0,totalFiles:0,totalBytes:0}),this.fileLoaded({}),this.baseclass.addToDOM.call(this,a,b)},b.Preloader.prototype.progress=function(a){this.progressBar.setValue(a.progress),this.domBytesLabel.innerHTML=a.loadedBytes+" of "+a.totalBytes+" Bytes loaded",this.domFilesLabel.innerHTML=a.loadedFiles+" of "+a.totalFiles+" Files loaded"},b.Preloader.prototype.complete=function(a){this.progressBar.setValue(100);var b=this;setTimeout(function(){b.domGadgetRoot.parentNode.removeChild(b.domGadgetRoot)},300)},b.Preloader.prototype.stateChange=function(a){switch(a){case 0:case 1:this.domStateLabel.innerHTML="Step 1 of 2: Loading XML";break;case 2:case 3:this.domStateLabel.innerHTML="Step 2 of 2: Loading Textures"}},b.Preloader.prototype.fileLoaded=function(a){if(a.url){var b=a.url;b.length>40&&(b=b.slice(-37),b="..."+b),this.domLastFileLabel.innerHTML='Last file loaded: "'+b+'"'}else this.domLastFileLabel.innerHTML==""&&(this.domLastFileLabel.innerHTML="Last file loaded: <i>none</i>")},a.augment(b.Gadget,b.Preloader)})(a.GUI)}(GLGE)