## Description

Please include a summary of the change or which issue is fixed.

## Type of change

- [ ] New feature (non-breaking change which adds functionality)
- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)

## Area of change

- [ ] Frontend
- [ ] Backend

## General checklist:

- [ ] My code follows the style guidelines of this project
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation where needed
- [ ] My changes generate no new warnings
- [ ] I have checked my code and corrected any misspellings
- [ ] I have updated `develop` and merged to my branch before submitting pull request
- [ ] My pull request generate no conflicts with `develop` branch
- [ ] I requested code review from other team members

## Frontend checklist:

- [ ] My `Javascript` generate no new console errors
- [ ] I tested my code cross browsers
- [ ] My slice is pixel perfect for both desktop and mobile according to design
- [ ] I conducted basic QA to assure all features are working
- [ ] I tested responsive for mobile and tablet resolutions

## Backend checklist:

- [ ] I tested by manually adding content from zero
- [ ] I created easy to use experience which is self-explanatory
- [ ] I added description/comments to fields in hard-to-understand areas
- [ ] I followed guidelines for naming `php`/`liquid` variables
- [ ] I conducted basic QA to assure all features are working