<?php

/**
 *
 * Simple password manager written in PHP with Bootstrap and PDO database connections
 *
 *  File name: NullCoalesceExpression.php
 *  Last Modified: 30.12.22 г., 5:53 ч.
 *
 *  @link          https://blacktiehost.com
 *  @since         1.0.0
 *  @version       2.1.0
 *  @author        Milen Karaganski <milen@blacktiehost.com>
 *
 *  @license       GPL-3.0+
 *  @license       http://www.gnu.org/licenses/gpl-3.0.txt
 *  @copyright     Copyright (c)  2020 - 2022 blacktiehost.com
 *
 */

/*
 * This file is part of Twig.
 *
 * (c) Fabien Potencier
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Twig\Node\Expression;

use Twig\Compiler;
use Twig\Node\Expression\Binary\AndBinary;
use Twig\Node\Expression\Test\DefinedTest;
use Twig\Node\Expression\Test\NullTest;
use Twig\Node\Expression\Unary\NotUnary;
use Twig\Node\Node;

class NullCoalesceExpression extends ConditionalExpression
{

	public function __construct(Node $left, Node $right, int $lineno)
	{

		$test = new DefinedTest(clone $left, 'defined', new Node(), $left->getTemplateLine());
		// for "block()", we don't need the null test as the return value is always a string
		if (!$left instanceof BlockReferenceExpression) {
			$test = new AndBinary(
				$test,
				new NotUnary(new NullTest($left, 'null', new Node(), $left->getTemplateLine()), $left->getTemplateLine()),
				$left->getTemplateLine()
			);
		}

		parent::__construct($test, $left, $right, $lineno);
	}

	public function compile(Compiler $compiler): void
	{

		/*
		 * This optimizes only one case. PHP 7 also supports more complex expressions
		 * that can return null. So, for instance, if log is defined, log("foo") ?? "..." works,
		 * but log($a["foo"]) ?? "..." does not if $a["foo"] is not defined. More advanced
		 * cases might be implemented as an optimizer node visitor, but has not been done
		 * as benefits are probably not worth the added complexity.
		 */
		if ($this->getNode('expr2') instanceof NameExpression) {
			$this->getNode('expr2')->setAttribute('always_defined', true);
			$compiler
				->raw('((')
				->subcompile($this->getNode('expr2'))
				->raw(') ?? (')
				->subcompile($this->getNode('expr3'))
				->raw('))');
		} else {
			parent::compile($compiler);
		}
	}

}
