/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.base;

import com.inet.adhoc.base.AHHelpProvider;
import com.inet.adhoc.base.a;
import com.inet.adhoc.base.model.AHCommand;
import com.inet.adhoc.base.model.TableSourceVO;
import com.inet.adhoc.base.model.VO;
import com.inet.adhoc.base.page.PageType;
import com.inet.adhoc.base.xml.AdHocXmlTag;
import com.inet.adhoc.base.xml.XMLSerializable;
import com.inet.adhoc.base.xml.XMLSerializableBoolean;
import com.inet.adhoc.base.xml.XMLSerializableByteArray;
import com.inet.adhoc.base.xml.XMLSerializableInteger;
import com.inet.adhoc.base.xml.XMLSerializableLong;
import com.inet.adhoc.base.xml.XMLSerializableProperties;
import com.inet.adhoc.base.xml.XMLSerializableString;
import com.inet.adhoc.io.IRequest;
import com.inet.adhoc.io.IResponse;
import com.inet.adhoc.io.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.RandomAccess;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class AHBaseUtils {
    private static TransformerFactory a = TransformerFactory.newInstance();
    private static DocumentBuilderFactory b = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder c;

    public static <T extends VO> List<T> copy(List<T> list) {
        if (list == null) {
            return null;
        }
        ArrayList<VO> arrayList = new ArrayList<VO>(list.size());
        if (list instanceof RandomAccess) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                VO vO = (VO)list.get(i2);
                arrayList.add(vO == null ? null : vO.copy());
            }
        } else {
            for (VO vO : list) {
                arrayList.add(vO == null ? null : vO.copy());
            }
        }
        return arrayList;
    }

    public static String encodeArrayToString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length << 1);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2] + 128);
            if (string.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static byte[] decodeStringToArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < string.length(); i2 += 2) {
            byte by2;
            String string2 = string.substring(i2, i2 + 2);
            byArray[i2 / 2] = by2 = (byte)(Integer.parseInt(string2, 16) - 128);
        }
        return byArray;
    }

    public static void printStackTrace(Throwable throwable) {
        throwable.printStackTrace();
    }

    public static Element createPropertiesElement(Document document, HashMap<String, XMLSerializable> iterator, Locale locale) {
        Element element = document.createElement(AdHocXmlTag.Properties.name());
        if (iterator != null) {
            iterator = ((HashMap)((Object)iterator)).entrySet();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                String string = object.getKey();
                object = object.getValue();
                Element element2 = document.createElement(AdHocXmlTag.Entry.name());
                element2.setAttribute(AdHocXmlTag.Key.name(), string);
                element2.appendChild(object.getXMLElement(document, locale));
                element.appendChild(element2);
            }
        }
        return element;
    }

    public static HashMap<String, XMLSerializable> readPropertiesElement(Element object) {
        object = object.getChildNodes();
        HashMap<String, XMLSerializable> hashMap = new HashMap<String, XMLSerializable>();
        for (int i2 = 0; i2 < object.getLength(); ++i2) {
            XMLSerializable xMLSerializable;
            Node node = (Element)object.item(i2);
            String string = node.getAttribute(AdHocXmlTag.Key.name());
            if ((node = node.getFirstChild()).getNodeName().equals(AdHocXmlTag.TableSource.name())) {
                xMLSerializable = new TableSourceVO();
                xMLSerializable.readXMLElement((Element)node);
                hashMap.put(string, xMLSerializable);
                continue;
            }
            if (node.getNodeName().equals(AdHocXmlTag.StringValue.name())) {
                hashMap.put(string, new XMLSerializableString(node.getTextContent()));
                continue;
            }
            if (node.getNodeName().equals(AdHocXmlTag.BooleanValue.name())) {
                hashMap.put(string, new XMLSerializableBoolean(node.getTextContent()));
                continue;
            }
            if (node.getNodeName().equals(AdHocXmlTag.IntegerValue.name())) {
                hashMap.put(string, new XMLSerializableInteger(node.getTextContent()));
                continue;
            }
            if (node.getNodeName().equals(AdHocXmlTag.LongValue.name())) {
                hashMap.put(string, new XMLSerializableLong(node.getTextContent()));
                continue;
            }
            if (node.getNodeName().equals(AdHocXmlTag.ByteArrayValue.name())) {
                hashMap.put(string, new XMLSerializableByteArray(AHBaseUtils.decodeStringToArray(node.getTextContent())));
                continue;
            }
            if (!node.getNodeName().equals(AdHocXmlTag.PropertiesValue.name())) continue;
            xMLSerializable = new XMLSerializableProperties(new Properties());
            ((XMLSerializableProperties)xMLSerializable).readXMLElement((Element)node);
            hashMap.put(string, xMLSerializable);
        }
        return hashMap;
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return b;
    }

    public static Document createBlankDocument() {
        Document document = c.newDocument();
        return document;
    }

    public static void transform(Document object, StreamResult streamResult) throws TransformerException {
        object = new DOMSource((Node)object);
        Transformer transformer = a.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "no");
        transformer.transform((Source)object, streamResult);
    }

    public static AHHelpProvider.HelpType mapPageToHelpType(PageType pageType) {
        switch (pageType) {
            case Report: {
                return AHHelpProvider.HelpType.HELP_REPORT;
            }
            case Datasource: {
                return AHHelpProvider.HelpType.HELP_DATASOURCE;
            }
            case VisualLinking: {
                return AHHelpProvider.HelpType.HELP_VISUALLINKING;
            }
            case DataView: {
                return AHHelpProvider.HelpType.HELP_DATAVIEW;
            }
            case Column: {
                return AHHelpProvider.HelpType.HELP_COLUMN;
            }
            case Filter: {
                return AHHelpProvider.HelpType.HELP_FILTER;
            }
            case Groups: {
                return AHHelpProvider.HelpType.HELP_GROUPS;
            }
            case Summary: {
                return AHHelpProvider.HelpType.HELP_SUMMARY;
            }
            case Chart: {
                return AHHelpProvider.HelpType.HELP_CHART;
            }
            case Crosstab: {
                return AHHelpProvider.HelpType.HELP_CROSSTAB;
            }
            case MailingLabel: {
                return AHHelpProvider.HelpType.HELP_MAILINGLABEL;
            }
            case Document: {
                return AHHelpProvider.HelpType.HELP_DOCUMENT;
            }
        }
        return null;
    }

    public static int compareStrings(String string, String string2, boolean bl2) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        if (bl2) {
            return string.compareTo(string2);
        }
        return string.compareToIgnoreCase(string2);
    }

    public static void sortTables(List<TableSourceVO> list, boolean bl2) {
        Collections.sort(list, new a(bl2));
    }

    public static int mapSqlTypeToCCType(int n2) {
        switch ((short)n2) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 6;
            }
            case -7: 
            case 16: {
                return 8;
            }
            case -16: 
            case -15: 
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return 11;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 14;
            }
            case 91: {
                return 9;
            }
            case 92: {
                return 10;
            }
            case -102: 
            case -101: 
            case 93: {
                return 15;
            }
            case -150: 
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                return 14;
            }
        }
        return -1;
    }

    public static IResponse getResponseFromStream(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        Response response = new Response();
        response.readXMLElement(AHBaseUtils.getDocumentBuilderFactory().newDocumentBuilder().parse(inputStream).getDocumentElement());
        return response;
    }

    public static void writeRequestToStream(IRequest iRequest, OutputStream outputStream, Locale locale) throws TransformerException {
        Document document = AHBaseUtils.createBlankDocument();
        if (iRequest.getCommand().canRemovePageData() && iRequest.getCurrentPage() != null && iRequest.getCommand() != AHCommand.LoadDump) {
            iRequest.getCurrentPage().setPageData(null);
        }
        document.appendChild(iRequest.getXMLElement(document, locale));
        AHBaseUtils.transform(document, new StreamResult(outputStream));
    }

    static {
        try {
            c = AHBaseUtils.getDocumentBuilderFactory().newDocumentBuilder();
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException("problems instantiating the DocumentBuilder!!!");
        }
    }
}

