/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.base.model;

import com.inet.adhoc.base.i18n.Msg;
import com.inet.adhoc.base.model.FieldVO;
import com.inet.adhoc.base.model.VO;
import com.inet.adhoc.base.xml.AdHocXmlAttribute;
import com.inet.adhoc.base.xml.AdHocXmlTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FormattedFieldVO
extends VO {
    public static final int UNFORMATTED = -1;
    public static final int NUMBER_FORMAT_INTEGER = 0;
    public static final int NUMBER_FORMAT_FRACTIONAL = 1;
    public static final int NUMBER_FORMAT_CURRENCY_INTEGER = 2;
    public static final int NUMBER_FORMAT_CURRENCY_FRACTIONAL = 3;
    public static final int NUMBER_FORMAT_PERCENT_INTEGER = 4;
    public static final int NUMBER_FORMAT_PERCENT_FRACTIONAL = 5;
    public static final int DATETIME_FORMAT_LONG = 10;
    public static final int DATETIME_FORMAT_MEDIUM = 11;
    public static final int DATETIME_FORMAT_SHORT = 12;
    public static final int DATE_FORMAT_LONG = 13;
    public static final int DATE_FORMAT_MEDIUM = 14;
    public static final int DATE_FORMAT_SHORT = 15;
    public static final int[] NUMBER_FORMATS = new int[]{-1, 3, 2, 1, 0, 5, 4};
    public static final int[] DATETIME_FORMATS = new int[]{-1, 13, 14, 15, 10, 11, 12};
    private FieldVO a;
    private int b;

    public FormattedFieldVO(FieldVO fieldVO, int n2) {
        this.a = fieldVO;
        this.setFormat(n2);
    }

    FormattedFieldVO() {
    }

    public FieldVO getField() {
        return this.a;
    }

    public int getFormat() {
        return this.b;
    }

    public void setFormat(int n2) {
        if (n2 != -1 && !FormattedFieldVO.isNumberFormat(n2) && !FormattedFieldVO.isDateTimeFormat(n2)) {
            throw new IllegalArgumentException("Parameter 'format' is out of range.");
        }
        for (int n3 : FormattedFieldVO.getAllowedFormats(this.a.getValueType())) {
            if (n3 != n2) continue;
            this.b = n2;
            return;
        }
        throw new IllegalArgumentException("Format " + n2 + " not allowed for type " + this.a.getValueType());
    }

    public static boolean isNumberFormat(int n2) {
        return n2 >= 0 && n2 <= 5;
    }

    public static boolean isDateTimeFormat(int n2) {
        return n2 >= 10 && n2 <= 15;
    }

    public static int[] getAllowedFormats(int n2) {
        if (FormattedFieldVO.isNumberFieldType(n2)) {
            return NUMBER_FORMATS;
        }
        if (FormattedFieldVO.isDateTimeFieldType(n2)) {
            return DATETIME_FORMATS;
        }
        return new int[]{-1};
    }

    public static boolean isDateTimeFieldType(int n2) {
        switch (n2) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumberFieldType(int n2) {
        switch (n2) {
            case 0: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static String getI18nKey(int n2, int n3) {
        n3 = n3 == 4 ? 1 : 0;
        switch (n2) {
            case 0: {
                return "Columns.nfInteger";
            }
            case 1: {
                return "Columns.nfFractional";
            }
            case 2: {
                return "Columns.nfCurInteger";
            }
            case 3: {
                return "Columns.nfCurFractional";
            }
            case 4: {
                return "Columns.nfPerInteger";
            }
            case 5: {
                return "Columns.nfPerFractional";
            }
            case 10: {
                if (n3 != 0) {
                    return "Columns.dtLong";
                }
                return "Columns.tLong";
            }
            case 11: {
                if (n3 != 0) {
                    return "Columns.dtMedium";
                }
                return "Columns.tMedium";
            }
            case 12: {
                if (n3 != 0) {
                    return "Columns.dtShort";
                }
                return "Columns.tShort";
            }
            case 13: {
                return "Columns.dLong";
            }
            case 14: {
                return "Columns.dMedium";
            }
            case 15: {
                return "Columns.dShort";
            }
        }
        return "Columns.unformatted";
    }

    public static String toString(int n2, int n3) {
        return Msg.getMsg(FormattedFieldVO.getI18nKey(n2, n3));
    }

    public static boolean allowMulitpleFormat(int n2) {
        return FormattedFieldVO.getAllowedFormats(n2).length > 1;
    }

    @Override
    public FormattedFieldVO copy() {
        FormattedFieldVO formattedFieldVO = new FormattedFieldVO(this.a.copy(), this.b);
        return formattedFieldVO;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FormattedFieldVO)) {
            return false;
        }
        return this.a.equals(((FormattedFieldVO)object).a) && this.b == ((FormattedFieldVO)object).b;
    }

    @Override
    public Element getXMLElement(Document node, Locale locale) {
        Element element = node.createElement(AdHocXmlTag.FormattedField.name());
        element.setAttribute(AdHocXmlAttribute.format.name(), String.valueOf(this.b));
        node = this.a.getXMLElement((Document)node, locale);
        element.appendChild(node);
        return element;
    }

    @Override
    public void readXMLElement(Element element) {
        String string = element.getAttribute(AdHocXmlAttribute.format.name());
        this.a = new FieldVO();
        this.a.readXMLElement((Element)element.getFirstChild());
        this.setFormat(Integer.parseInt(string));
    }

    @Override
    public List<VO> getReferencedVOs() {
        ArrayList<VO> arrayList = new ArrayList<VO>();
        arrayList.add(this.a);
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.a == null;
    }
}

