/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.base.model;

import com.inet.adhoc.base.i18n.Msg;
import com.inet.adhoc.base.model.FieldVO;
import com.inet.adhoc.base.model.Link;
import com.inet.adhoc.base.model.VO;
import com.inet.adhoc.base.xml.AdHocXmlAttribute;
import com.inet.adhoc.base.xml.AdHocXmlTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JoinVO
extends VO {
    public static final int JOINTYPE_INNER = 0;
    public static final int JOINTYPE_LEFT_OUTER = 1;
    public static final int JOINTYPE_RIGHT_OUTER = 2;
    public static final int JOINTYPE_FULL_OUTER = 3;
    public static final int JOINOP_EQUALS = 0;
    public static final int JOINOP_GREATER_THAN = 1;
    public static final int JOINOP_GREATER_EQUALS_THAN = 2;
    public static final int JOINOP_LESS_THAN = 3;
    public static final int JOINOP_LESS_EQUALS_THAN = 4;
    public static final int JOINOP_NOT_EQUALS = 5;
    private int a;
    private List<Link> b = new ArrayList<Link>();

    public JoinVO(FieldVO fieldVO, FieldVO fieldVO2, int n2, int n3) {
        this.setJoinType(n2);
        this.b.add(new Link(fieldVO, fieldVO2, n3, this));
    }

    JoinVO() {
    }

    public boolean remove(Link link) {
        return this.b.remove(link);
    }

    public int size() {
        return this.b.size();
    }

    public String getFirstTSName() {
        return this.b.get(0).getFirstField().getTableSourceName();
    }

    public String getSecondTSName() {
        return this.b.get(0).getSecondField().getTableSourceName();
    }

    public Link[] getLinks() {
        return this.b.toArray(new Link[0]);
    }

    public boolean contains(Link link) {
        return this.b.contains(link);
    }

    public Link add(FieldVO object, FieldVO fieldVO, int n2) {
        String string = this.getFirstTSName();
        String string2 = this.getSecondTSName();
        if (string.equals(((FieldVO)object).getTableSourceName()) && string2.equals(fieldVO.getTableSourceName())) {
            object = new Link((FieldVO)object, fieldVO, n2, this);
            this.b.add((Link)object);
            return object;
        }
        if (string.equals(fieldVO.getTableSourceName()) && string2.equals(((FieldVO)object).getTableSourceName())) {
            object = new Link(fieldVO, (FieldVO)object, n2, this);
            this.b.add((Link)object);
            return object;
        }
        throw new IllegalArgumentException("Illegal Tablesource names");
    }

    public static JoinVO findJoin(List<JoinVO> object, FieldVO fieldVO, FieldVO fieldVO2) {
        object = object.iterator();
        while (object.hasNext()) {
            JoinVO joinVO = (JoinVO)object.next();
            String string = joinVO.getFirstTSName();
            String string2 = joinVO.getSecondTSName();
            if (string.equals(fieldVO.getTableSourceName()) && string2.equals(fieldVO2.getTableSourceName())) {
                return joinVO;
            }
            if (!string.equals(fieldVO2.getTableSourceName()) || !string2.equals(fieldVO.getTableSourceName())) continue;
            return joinVO;
        }
        return null;
    }

    public static boolean isJoinable(List<JoinVO> linkArray, FieldVO fieldVO, FieldVO fieldVO2) {
        if (fieldVO == null || fieldVO2 == null) {
            return false;
        }
        if (fieldVO.getValueType() != fieldVO2.getValueType()) {
            return false;
        }
        if (fieldVO.getTableSourceName().equals(fieldVO2.getTableSourceName())) {
            return false;
        }
        if (linkArray != null && (linkArray = JoinVO.findJoin((List<JoinVO>)linkArray, fieldVO, fieldVO2)) != null) {
            for (Link link : ((JoinVO)linkArray).getLinks()) {
                FieldVO fieldVO3 = link.getFirstField();
                FieldVO object = link.getSecondField();
                if (!fieldVO3.equals(fieldVO) && !fieldVO3.equals(fieldVO2) || !object.equals(fieldVO) && !object.equals(fieldVO2)) continue;
                return false;
            }
        }
        return true;
    }

    public int getJoinType() {
        return this.a;
    }

    public void setJoinType(int n2) {
        int n3 = n2;
        if (n3 < 0 || n3 > 3) {
            throw new IllegalArgumentException("illegal argument 'type' " + n3);
        }
        this.a = n2;
    }

    @Override
    public JoinVO copy() {
        JoinVO joinVO = new JoinVO();
        new JoinVO().a = this.a;
        for (Link link : this.b) {
            joinVO.b.add(new Link(link.getFirstField(), link.getSecondField(), link.getJoinOp(), joinVO));
        }
        return joinVO;
    }

    @Override
    public Element getXMLElement(Document document, Locale locale) {
        Element element = document.createElement(AdHocXmlTag.Join.name());
        AdHocXmlAttribute.setAttribute(element, AdHocXmlAttribute.type, String.valueOf(this.a));
        for (Link link : this.b) {
            FieldVO fieldVO = link.getFirstField();
            FieldVO fieldVO2 = link.getSecondField();
            int n2 = link.getJoinOp();
            Element element2 = document.createElement(AdHocXmlTag.Link.name());
            AdHocXmlAttribute.setAttribute(element2, AdHocXmlAttribute.operation, String.valueOf(n2));
            element2.appendChild(fieldVO.getXMLElement(document, locale));
            element2.appendChild(fieldVO2.getXMLElement(document, locale));
            element.appendChild(element2);
        }
        return element;
    }

    @Override
    public void readXMLElement(Element object) {
        this.b.clear();
        String string = AdHocXmlAttribute.getAttribute((Element)object, AdHocXmlAttribute.type);
        this.a = Integer.parseInt(string);
        object = object.getChildNodes();
        for (int i2 = 0; i2 < object.getLength(); ++i2) {
            Object object2 = object.item(i2);
            if (!AdHocXmlTag.Link.name().equals(object2.getNodeName())) continue;
            object2 = (Element)object2;
            String string2 = AdHocXmlAttribute.getAttribute((Element)object2, AdHocXmlAttribute.operation);
            int n2 = Integer.parseInt(string2);
            object2 = object2.getChildNodes();
            FieldVO fieldVO = new FieldVO();
            fieldVO.readXMLElement((Element)object2.item(0));
            FieldVO fieldVO2 = new FieldVO();
            fieldVO2.readXMLElement((Element)object2.item(1));
            this.b.add(new Link(fieldVO, fieldVO2, n2, this));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof JoinVO) {
            object = (JoinVO)object;
            if (this.a != ((JoinVO)object).a) {
                return false;
            }
            return this.b.equals(((JoinVO)object).b);
        }
        return false;
    }

    public static String getJoinOpLabel(int n2) {
        switch (n2) {
            case 0: {
                return Msg.getMsg("VisualLink.equal");
            }
            case 1: {
                return Msg.getMsg("VisualLink.greater");
            }
            case 2: {
                return Msg.getMsg("VisualLink.greater_equal");
            }
            case 3: {
                return Msg.getMsg("VisualLink.lesser");
            }
            case 4: {
                return Msg.getMsg("VisualLink.lesser_equal");
            }
            case 5: {
                return Msg.getMsg("VisualLink.not_equal");
            }
        }
        return "";
    }

    public static String getJoinTypeLabel(int n2) {
        switch (n2) {
            case 0: {
                return Msg.getMsg("VisualLink.inner");
            }
            case 2: {
                return Msg.getMsg("VisualLink.right_outer");
            }
            case 1: {
                return Msg.getMsg("VisualLink.left_outer");
            }
            case 3: {
                return Msg.getMsg("VisualLink.full_outer");
            }
        }
        return "";
    }

    @Override
    public boolean isEmpty() {
        return this.b.size() == 0;
    }
}

