/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.base.model;

import com.inet.adhoc.base.i18n.Msg;
import com.inet.adhoc.base.model.FieldVO;
import com.inet.adhoc.base.model.FormattedFieldVO;
import com.inet.adhoc.base.model.GroupVO;
import com.inet.adhoc.base.model.IEmptyCheck;
import com.inet.adhoc.base.model.VO;
import com.inet.adhoc.base.model.diff.IDiffConsumer;
import com.inet.adhoc.base.model.diff.IMatchable;
import com.inet.adhoc.base.xml.AdHocXmlAttribute;
import com.inet.adhoc.base.xml.AdHocXmlTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SumVO
extends VO
implements IEmptyCheck,
IDiffConsumer,
IMatchable {
    private FieldVO a;
    private FieldVO b;
    private int c = 1;
    private Operation d;
    private GroupVO e;
    private String f;

    public SumVO(FieldVO fieldVO, Locale locale, boolean bl2) {
        this.setFirstField(fieldVO);
        if (fieldVO.getValueType() == 0 || fieldVO.getValueType() == 5) {
            this.setOperation(Operation.Sum);
        } else {
            this.setOperation(Operation.Count);
        }
        this.f = SumVO.generateLocalizedName(this, bl2, locale);
    }

    SumVO() {
    }

    public FieldVO getFirstField() {
        return this.a;
    }

    public void setFirstField(FieldVO fieldVO) {
        if (fieldVO == null) {
            throw new IllegalArgumentException("Parameter 'field' is null.");
        }
        this.a = fieldVO;
    }

    public FieldVO getSecondField() {
        return this.b;
    }

    public void setSecondField(FieldVO fieldVO) {
        this.b = fieldVO;
    }

    public int getNth() {
        return this.c;
    }

    public void setNth(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Parameter 'nth' is less than zero.");
        }
        this.c = n2;
    }

    public Operation getOperation() {
        return this.d;
    }

    public void setOperation(Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Parameter 'operation' is null");
        }
        this.d = operation;
    }

    public GroupVO getGroup() {
        return this.e;
    }

    public void setGroup(GroupVO groupVO) {
        this.e = groupVO;
    }

    public String getName() {
        return this.f;
    }

    public void setName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Null or empty string as name not permitted");
        }
        this.f = string;
    }

    @Override
    public SumVO copy() {
        SumVO sumVO = new SumVO(this.a.copy(), Locale.getDefault(), false);
        new SumVO(this.a.copy(), Locale.getDefault(), false).e = this.e == null ? null : this.e.copy();
        sumVO.b = this.b == null ? null : this.b.copy();
        sumVO.c = this.c;
        sumVO.d = this.d;
        sumVO.f = this.f;
        return sumVO;
    }

    @Override
    public Element getXMLElement(Document document, Locale locale) {
        Element element = document.createElement(AdHocXmlTag.Sum.name());
        AdHocXmlAttribute.setAttribute(element, AdHocXmlAttribute.nth, String.valueOf(this.c));
        AdHocXmlAttribute.setAttribute(element, AdHocXmlAttribute.operation, String.valueOf((Object)this.d));
        AdHocXmlAttribute.setAttribute(element, AdHocXmlAttribute.name, this.f);
        element.appendChild(this.a.getXMLElement(document, locale));
        if (this.b != null) {
            element.appendChild(this.b.getXMLElement(document, locale));
        }
        if (this.e != null) {
            element.appendChild(this.e.getXMLElement(document, locale));
        }
        return element;
    }

    @Override
    public void readXMLElement(Element object) {
        this.c = Integer.parseInt(AdHocXmlAttribute.getAttribute((Element)object, AdHocXmlAttribute.nth));
        this.d = Operation.valueOf(AdHocXmlAttribute.getAttribute((Element)object, AdHocXmlAttribute.operation));
        this.f = AdHocXmlAttribute.getAttribute((Element)object, AdHocXmlAttribute.name);
        object = object.getChildNodes();
        this.a = new FieldVO();
        this.a.readXMLElement((Element)object.item(0));
        for (int i2 = 1; i2 < object.getLength(); ++i2) {
            Node node = object.item(i2);
            if (AdHocXmlTag.Field.name().equals(node.getNodeName())) {
                this.b = new FieldVO();
                this.b.readXMLElement((Element)node);
                continue;
            }
            if (!AdHocXmlTag.Group.name().equals(node.getNodeName())) continue;
            this.e = new GroupVO();
            this.e.readXMLElement((Element)node);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SumVO)) {
            return false;
        }
        object = (SumVO)object;
        return this.a.equals(((SumVO)object).a) && (this.b == null ? ((SumVO)object).b == null : this.b.equals(((SumVO)object).b)) && (this.e == null ? ((SumVO)object).e == null : this.e.equals(((SumVO)object).e)) && this.c == ((SumVO)object).c && this.d == ((SumVO)object).d && this.f.equals(((SumVO)object).f);
    }

    public static String generateLocalizedName(SumVO sumVO, boolean bl2, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        if (sumVO.getOperation() != Operation.NoSummaryOperation) {
            String string = Msg.getMsg(locale, sumVO.getOperation().getI18nKey(), sumVO.getNth());
            stringBuffer.append(string);
            stringBuffer.append(" ").append(Msg.getMsg(locale, "SumOperation.SumSeparator")).append(" ");
        }
        stringBuffer.append(sumVO.getFirstField().getDisplayName(bl2));
        return stringBuffer.toString();
    }

    public static String generateLocalizedName(SumVO object, String[] stringArray, boolean bl2, Locale locale) {
        object = SumVO.generateLocalizedName((SumVO)object, false, locale);
        String string = (String)object + " #";
        boolean bl3 = false;
        int n2 = 0;
        for (String string2 : stringArray) {
            if (!string2.startsWith((String)object)) continue;
            if (string2.equals(object)) {
                bl3 = true;
                continue;
            }
            if (!string2.startsWith(string)) continue;
            try {
                n2 = Math.max(n2, Integer.parseInt(string2.substring(string.length())));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!bl3) {
            return object;
        }
        return string + ++n2;
    }

    @Override
    public List<VO> getReferencedVOs() {
        ArrayList<VO> arrayList = new ArrayList<VO>();
        arrayList.add(this.a);
        if (this.b != null) {
            arrayList.add(this.b);
        }
        if (this.e != null) {
            arrayList.add(this.e);
        }
        return arrayList;
    }

    @Override
    public boolean matches(VO vO) {
        if (!(vO instanceof SumVO)) {
            return false;
        }
        vO = (SumVO)vO;
        return this.f.equals(((SumVO)vO).f);
    }

    @Override
    public List<VO> notifyRemoval(List<? extends VO> arrayList) {
        arrayList = arrayList.iterator();
        while (arrayList.hasNext()) {
            Serializable serializable;
            VO vO = (VO)arrayList.next();
            if (vO instanceof FormattedFieldVO && this.a.matches((VO)(serializable = ((FormattedFieldVO)vO).getField()))) {
                arrayList = new ArrayList<VO>();
                arrayList.add(this);
                return arrayList;
            }
            if (!this.a.matches(vO) && (this.b == null || !this.b.matches(vO))) continue;
            serializable = new ArrayList<SumVO>();
            serializable.add(this);
            return serializable;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.a == null || this.d == null;
    }

    public int getValueType() {
        switch (this.d) {
            case Correlation: 
            case Covariance: 
            case Count: 
            case DistinctCount: 
            case Variance: 
            case PopStdVariance: 
            case PopVariance: 
            case StdDeviation: 
            case Percentage: {
                return 0;
            }
            case NthLargest: 
            case NthSmallest: 
            case NthMostFrequent: 
            case Percentile: 
            case WeightedAverage: 
            case Sum: 
            case Average: 
            case Maximum: 
            case Median: 
            case Minimum: 
            case Mode: {
                return this.a.getValueType();
            }
        }
        return 0;
    }

    public static List<Operation> getOperations(FieldVO fieldVO, boolean bl2) {
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        int n2 = fieldVO.getValueType();
        boolean bl3 = n2 == 3 || n2 == 2 || n2 == 4;
        boolean bl4 = n2 == 0 || n2 == 5;
        n2 = n2 == 1 ? 1 : 0;
        for (Operation operation : Operation.getVisibleOperations()) {
            if (operation == Operation.Count || operation == Operation.DistinctCount) {
                arrayList.add(operation);
                continue;
            }
            if (bl4) {
                arrayList.add(operation);
                continue;
            }
            if (bl3 && !bl2) {
                switch (operation) {
                    case NthLargest: 
                    case NthSmallest: 
                    case NthMostFrequent: 
                    case Maximum: 
                    case Minimum: 
                    case Mode: {
                        arrayList.add(operation);
                    }
                }
                continue;
            }
            if (n2 == 0 || bl2) continue;
            switch (operation) {
                case Maximum: 
                case Minimum: {
                    arrayList.add(operation);
                }
            }
        }
        return arrayList;
    }

    public static enum Operation {
        Sum,
        Average,
        Variance,
        StdDeviation,
        Maximum,
        Minimum,
        Count,
        PopVariance,
        PopStdVariance,
        DistinctCount,
        Correlation,
        Covariance,
        WeightedAverage,
        Median,
        Percentile,
        NthLargest,
        NthSmallest,
        Mode,
        NthMostFrequent,
        Percentage,
        NoSummaryOperation;

        private static final Operation[] a;

        public static Operation[] getVisibleOperations() {
            return a;
        }

        public final String getI18nKey() {
            return "SumOperation." + this.name();
        }

        public final boolean isNthRequired() {
            switch (this) {
                case NthLargest: 
                case NthSmallest: 
                case NthMostFrequent: 
                case Percentile: {
                    return true;
                }
            }
            return false;
        }

        public final boolean isSecondFieldRequired() {
            switch (this) {
                case Correlation: 
                case Covariance: 
                case WeightedAverage: {
                    return true;
                }
            }
            return false;
        }

        static {
            a = new Operation[]{Sum, Average, Variance, StdDeviation, Maximum, Minimum, Count, PopVariance, PopStdVariance, DistinctCount, Correlation, Covariance, WeightedAverage, Median, Percentile, NthLargest, NthSmallest, Mode, NthMostFrequent, Percentage};
        }
    }
}

