/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.base.model.filter;

import com.inet.adhoc.base.model.FieldVO;
import com.inet.adhoc.base.model.ModelFactory;
import com.inet.adhoc.base.model.VO;
import com.inet.adhoc.base.model.filter.Evaluable;
import com.inet.adhoc.base.model.filter.ExprValue;
import com.inet.adhoc.base.model.filter.Op;
import com.inet.adhoc.base.xml.AdHocXmlAttribute;
import com.inet.adhoc.base.xml.AdHocXmlTag;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Expr
extends VO
implements Evaluable {
    private FieldVO a;
    private Op b;
    private ExprValue c;

    public Expr() {
    }

    public Expr(FieldVO fieldVO, Op op, ExprValue exprValue) {
        if (fieldVO == null) {
            throw new IllegalArgumentException("field is null");
        }
        if (op == null) {
            throw new IllegalArgumentException("op is null");
        }
        if (exprValue == null) {
            throw new IllegalArgumentException("exprValue is null");
        }
        this.a = fieldVO;
        this.b = op;
        this.c = exprValue;
    }

    public FieldVO getField() {
        return this.a;
    }

    public Op getOp() {
        return this.b;
    }

    public ExprValue getValue() {
        return this.c;
    }

    public boolean isValid() {
        return this.c.getValueCount() >= this.b.getRequiredValueCount();
    }

    @Override
    public String eval() {
        if (!this.isValid()) {
            throw new IllegalStateException("This is not a valid Expression!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "{" + this.a.getCCName() + "}";
        Object object = this.c.getValue1();
        Object object2 = this.c.getValue2();
        int n2 = this.b.getRequiredValueCount();
        if (this.a.getValueType() == 1) {
            if (this.b == Op.OP_NULL || this.b == Op.OP_EQUAL && "".equals(object)) {
                stringBuilder.append("(");
                stringBuilder.append(Op.OP_NULL.eval() + " (" + string + ")");
                stringBuilder.append(" " + Op.OP_OR.eval() + " ");
                stringBuilder.append(string + " " + Op.OP_EQUAL.eval() + " " + this.a(object));
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            if (this.b == Op.OP_NOT_NULL) {
                stringBuilder.append("length (" + string + ") > 0 ");
                return stringBuilder.toString();
            }
        }
        if (n2 == 0) {
            if (this.a.getValueType() == 6 && (this.b == Op.OP_TRUE || this.b == Op.OP_FALSE)) {
                stringBuilder.append(string + " = " + this.b.eval());
            } else {
                stringBuilder.append(this.b.eval() + " (" + string + ")");
            }
        } else if (n2 == 1) {
            if (this.a.getValueType() == 6) {
                object = Boolean.valueOf(object.toString().toLowerCase());
            }
            if (this.b == Op.OP_CONTAINS || this.b == Op.OP_STARTS_WITH || this.b == Op.OP_ENDS_WITH) {
                stringBuilder.append(this.b.eval() + "(" + string + ", " + this.a(object) + ") ");
                if (this.b == Op.OP_CONTAINS) {
                    stringBuilder.append("> 0");
                } else if (this.b == Op.OP_STARTS_WITH) {
                    stringBuilder.append("= 1");
                } else if (this.b == Op.OP_ENDS_WITH) {
                    stringBuilder.append("= 1 + ");
                    stringBuilder.append("abs( length( " + string + " ) - length( " + this.a(object) + ") )");
                }
            } else if (this.b == Op.OP_CONTAINS_NOT || this.b == Op.OP_STARTS_WITH_NOT || this.b == Op.OP_ENDS_WITH_NOT) {
                stringBuilder.append(this.b.eval() + "(" + string + ", " + this.a(object) + ") ");
                if (this.b == Op.OP_CONTAINS_NOT) {
                    stringBuilder.append("<= 0");
                } else if (this.b == Op.OP_STARTS_WITH_NOT) {
                    stringBuilder.append("<> 1");
                } else if (this.b == Op.OP_ENDS_WITH_NOT) {
                    stringBuilder.append("< 1 + ");
                    stringBuilder.append("abs( length( " + string + " ) - length( " + this.a(object) + ") )");
                }
            } else {
                stringBuilder.append(string + " " + this.b.eval() + " " + this.a(object));
            }
        } else if (n2 == 2) {
            stringBuilder.append("(");
            stringBuilder.append(string + " " + Op.OP_GREATER_THAN.eval() + " " + this.a(object));
            stringBuilder.append(" " + Op.OP_AND.eval() + " ");
            stringBuilder.append(string + " " + Op.OP_LESS_THAN.eval() + " " + this.a(object2));
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private String a(Object object) {
        int n2 = this.a.getValueType();
        if (n2 == 4 || n2 == 2 || n2 == 3) {
            StringBuilder stringBuilder = new StringBuilder();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime((Date)object);
            switch (n2) {
                case 4: {
                    stringBuilder.append("Datetime");
                    stringBuilder.append("(");
                    stringBuilder.append(gregorianCalendar.get(1)).append(',');
                    stringBuilder.append(gregorianCalendar.get(2) + 1).append(',');
                    stringBuilder.append(gregorianCalendar.get(5)).append(',');
                    stringBuilder.append(gregorianCalendar.get(11)).append(',');
                    stringBuilder.append(gregorianCalendar.get(12)).append(',');
                    stringBuilder.append(gregorianCalendar.get(13));
                    stringBuilder.append(")");
                    break;
                }
                case 2: {
                    stringBuilder.append("Date");
                    stringBuilder.append("(");
                    stringBuilder.append(gregorianCalendar.get(1)).append(',');
                    stringBuilder.append(gregorianCalendar.get(2) + 1).append(',');
                    stringBuilder.append(gregorianCalendar.get(5));
                    stringBuilder.append(")");
                    break;
                }
                case 3: {
                    stringBuilder.append("Time");
                    stringBuilder.append("(");
                    stringBuilder.append(gregorianCalendar.get(11)).append(',');
                    stringBuilder.append(gregorianCalendar.get(12)).append(',');
                    stringBuilder.append(gregorianCalendar.get(13));
                    stringBuilder.append(")");
                }
            }
            return stringBuilder.toString();
        }
        if (n2 == 0 || n2 == 5 || n2 == 6) {
            return object.toString();
        }
        return "\"" + object + "\"";
    }

    private static String b(Object object) {
        if (object instanceof Date) {
            return Long.toString(((Date)object).getTime());
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object a(String string) {
        try {
            switch (this.a.getValueType()) {
                case 0: 
                case 5: {
                    return Double.valueOf(string);
                }
                case 2: 
                case 3: 
                case 4: {
                    long l2 = Long.parseLong(string);
                    return new Date(l2);
                }
                case 1: {
                    return string;
                }
                case 6: {
                    return Boolean.valueOf(string);
                }
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof Expr) {
            return this.eval().equals(((Expr)object).eval());
        }
        return false;
    }

    @Override
    public Expr copy() {
        return new Expr(this.getField().copy(), this.b, this.c.copy());
    }

    @Override
    public Element getXMLElement(Document document, Locale object) {
        Element element = document.createElement(AdHocXmlTag.Expression.name());
        element.appendChild(this.a.getXMLElement(document, (Locale)object));
        object = document.createElement(AdHocXmlTag.Operation.name());
        object.setAttribute(AdHocXmlAttribute.value.name(), Integer.toString(this.b.getId()));
        element.appendChild((Node)object);
        object = document.createElement(AdHocXmlTag.ExpressionValue.name());
        if (this.c.getValue1() != null) {
            object.appendChild(document.createCDATASection(Expr.b(this.c.getValue1())));
        }
        if (this.c.getValue2() != null) {
            object.appendChild(document.createCDATASection(Expr.b(this.c.getValue2())));
        }
        element.appendChild((Node)object);
        return element;
    }

    @Override
    public void readXMLElement(Element object) {
        object = object.getChildNodes();
        block7: for (int i2 = 0; i2 < object.getLength(); ++i2) {
            Object object2 = object.item(i2);
            if (!(object2 instanceof Element)) continue;
            Object object3 = object2.getNodeName();
            switch (AdHocXmlTag.valueOf((String)object3)) {
                case Field: {
                    this.a = (FieldVO)ModelFactory.readVO((Element)object2);
                    continue block7;
                }
                case Operation: {
                    object2 = ((Element)object2).getAttribute(AdHocXmlAttribute.value.name());
                    int n2 = 0;
                    try {
                        n2 = Integer.parseInt((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    this.b = Op.getInstance(n2);
                    continue block7;
                }
                case ExpressionValue: {
                    object3 = ((Element)object2).getFirstChild();
                    object2 = ((Element)object2).getLastChild();
                    this.c = new ExprValue();
                    if (object3 != null) {
                        this.c.setValue1(this.a(object3.getTextContent()));
                    } else if (this.a != null && this.a.getValueType() == 1) {
                        this.c.setValue1("");
                    }
                    if (object3 == null || object3 == object2) continue block7;
                    this.c.setValue2(this.a(object2.getTextContent()));
                }
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.a == null || this.b == null;
    }
}

