/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.base.model.filter;

import com.inet.adhoc.base.model.filter.Evaluable;

public class Op
implements Evaluable {
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int EQUAL = 2;
    public static final int NOT_EQUAL = 3;
    public static final int GREATER = 4;
    public static final int GREATER_THAN = 5;
    public static final int LESS = 6;
    public static final int LESS_THAN = 7;
    public static final int CONTAINS = 8;
    public static final int CONTAINS_NOT = 9;
    public static final int BETWEEN = 10;
    public static final int NULL = 11;
    public static final int NOT_NULL = 12;
    public static final int STARTS_WITH = 13;
    public static final int STARTS_WITH_NOT = 14;
    public static final int ENDS_WITH = 15;
    public static final int ENDS_WITH_NOT = 16;
    public static final int TRUE = 17;
    public static final int FALSE = 18;
    public static final Op OP_OR = new Op(0);
    public static final Op OP_AND = new Op(1);
    public static final Op OP_EQUAL = new Op(2);
    public static final Op OP_NOT_EQUAL = new Op(3);
    public static final Op OP_GREATER = new Op(4);
    public static final Op OP_GREATER_THAN = new Op(5);
    public static final Op OP_LESS = new Op(6);
    public static final Op OP_LESS_THAN = new Op(7);
    public static final Op OP_CONTAINS = new Op(8);
    public static final Op OP_CONTAINS_NOT = new Op(9);
    public static final Op OP_BETWEEN = new Op(10);
    public static final Op OP_NULL = new Op(11);
    public static final Op OP_NOT_NULL = new Op(12);
    public static final Op OP_STARTS_WITH = new Op(13);
    public static final Op OP_STARTS_WITH_NOT = new Op(14);
    public static final Op OP_ENDS_WITH = new Op(15);
    public static final Op OP_ENDS_WITH_NOT = new Op(16);
    public static final Op OP_TRUE = new Op(17);
    public static final Op OP_FALSE = new Op(18);
    public static final Op[] STRING_OPS = new Op[]{OP_EQUAL, OP_NOT_EQUAL, OP_GREATER, OP_GREATER_THAN, OP_LESS, OP_LESS_THAN, OP_CONTAINS, OP_CONTAINS_NOT, OP_STARTS_WITH, OP_STARTS_WITH_NOT, OP_ENDS_WITH, OP_ENDS_WITH_NOT, OP_NULL, OP_NOT_NULL};
    public static final Op[] BINARY_OPS = new Op[]{OP_NULL, OP_NOT_NULL};
    public static final Op[] BOOLEAN_OPS = new Op[]{OP_TRUE, OP_FALSE, OP_NULL, OP_NOT_NULL};
    public static final Op[] NUMBER_OPS = new Op[]{OP_EQUAL, OP_NOT_EQUAL, OP_GREATER, OP_GREATER_THAN, OP_LESS, OP_LESS_THAN, OP_BETWEEN, OP_NULL, OP_NOT_NULL};
    private final int a;

    private Op(int n2) {
        this.a = n2;
    }

    public int getId() {
        return this.a;
    }

    @Override
    public String eval() {
        switch (this.a) {
            case 0: {
                return "OR";
            }
            case 1: {
                return "AND";
            }
            case 2: {
                return "=";
            }
            case 3: {
                return "<>";
            }
            case 4: {
                return ">";
            }
            case 5: {
                return ">=";
            }
            case 6: {
                return "<";
            }
            case 7: {
                return "<=";
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                return "INSTR";
            }
            case 15: 
            case 16: {
                return "INSTRREV";
            }
            case 10: {
                return "IN";
            }
            case 11: {
                return "ISNULL";
            }
            case 12: {
                return "NOT ISNULL";
            }
            case 17: {
                return "TRUE";
            }
            case 18: {
                return "FALSE";
            }
        }
        throw new IllegalArgumentException("unknown Op id: " + this.a);
    }

    public static Op getInstance(int n2) {
        switch (n2) {
            case 0: {
                return OP_OR;
            }
            case 1: {
                return OP_AND;
            }
            case 2: {
                return OP_EQUAL;
            }
            case 3: {
                return OP_NOT_EQUAL;
            }
            case 4: {
                return OP_GREATER;
            }
            case 5: {
                return OP_GREATER_THAN;
            }
            case 6: {
                return OP_LESS;
            }
            case 7: {
                return OP_LESS_THAN;
            }
            case 8: {
                return OP_CONTAINS;
            }
            case 9: {
                return OP_CONTAINS_NOT;
            }
            case 10: {
                return OP_BETWEEN;
            }
            case 11: {
                return OP_NULL;
            }
            case 12: {
                return OP_NOT_NULL;
            }
            case 13: {
                return OP_STARTS_WITH;
            }
            case 14: {
                return OP_STARTS_WITH_NOT;
            }
            case 15: {
                return OP_ENDS_WITH;
            }
            case 16: {
                return OP_ENDS_WITH_NOT;
            }
            case 17: {
                return OP_TRUE;
            }
            case 18: {
                return OP_FALSE;
            }
        }
        throw new IllegalArgumentException("unknown Op id: " + n2);
    }

    public static Op[] getOperators(int n2) {
        switch (n2) {
            case 1: {
                return STRING_OPS;
            }
            case 7: {
                return BINARY_OPS;
            }
            case 6: {
                return BOOLEAN_OPS;
            }
        }
        return NUMBER_OPS;
    }

    public int getRequiredValueCount() {
        switch (this.a) {
            case 10: {
                return 2;
            }
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                return 0;
            }
        }
        return 1;
    }

    public boolean equals(Object object) {
        return object instanceof Op && ((Op)object).getId() == this.a;
    }

    public int hashCode() {
        return this.a;
    }

    public String toString() {
        return this.eval();
    }
}

