/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.base.page;

import com.inet.adhoc.base.model.IEmptyCheck;
import com.inet.adhoc.base.model.VOList;
import com.inet.adhoc.base.model.filter.Expr;
import com.inet.adhoc.base.model.filter.FilterVO;
import com.inet.adhoc.base.model.filter.Op;
import com.inet.adhoc.base.page.Page;
import com.inet.adhoc.base.page.PageType;
import com.inet.adhoc.base.xml.XMLSerializable;
import java.util.List;

public class PageChecker {
    public static final int FILTER_COMPLEXITY_LIMIT = 5;

    public static WARNING checkPages(List<Page> object) {
        WARNING wARNING = null;
        object = object.iterator();
        while (object.hasNext()) {
            XMLSerializable xMLSerializable = (Page)object.next();
            boolean bl2 = ((Page)xMLSerializable).getUserChoices() == null || ((Page)xMLSerializable).getUserChoices() instanceof IEmptyCheck && ((IEmptyCheck)((Object)((Page)xMLSerializable).getUserChoices())).isEmpty();
            switch (((Page)xMLSerializable).getPageType()) {
                case Datasource: {
                    if (!bl2) break;
                    return WARNING.noDataSource;
                }
                case DataView: {
                    if (!bl2) break;
                    return WARNING.noDataView;
                }
                case Column: {
                    if (bl2) {
                        wARNING = WARNING.emptyColumns;
                        break;
                    }
                    return WARNING.none;
                }
                case Chart: {
                    if (bl2) {
                        if (wARNING != null) break;
                        wARNING = WARNING.emptyChart;
                        break;
                    }
                    return WARNING.none;
                }
                case Crosstab: {
                    if (bl2) {
                        if (wARNING != null) break;
                        return WARNING.emptyCrosstab;
                    }
                    return WARNING.none;
                }
                case Filter: {
                    Object object2;
                    xMLSerializable = ((Page)xMLSerializable).getUserChoices();
                    if (xMLSerializable == null || xMLSerializable instanceof IEmptyCheck && ((IEmptyCheck)((Object)xMLSerializable)).isEmpty()) {
                        object2 = null;
                    } else {
                        bl2 = false;
                        xMLSerializable = (FilterVO)xMLSerializable;
                        for (VOList<Expr> vOList : ((FilterVO)xMLSerializable).getFilter().getVOList()) {
                            if (vOList.isEmpty()) continue;
                            int n2 = vOList.getSize();
                            vOList = vOList.getVOList().iterator();
                            while (vOList.hasNext()) {
                                Expr expr = (Expr)vOList.next();
                                if (expr.getOp() != Op.OP_EQUAL || n2 != 1) continue;
                                bl2 = true;
                            }
                        }
                        object2 = bl2 ? WARNING.equalFilter : (xMLSerializable = ((FilterVO)xMLSerializable).getFilter().getSize() > 5 ? WARNING.complexFilter : null);
                    }
                    if (object2 == null) break;
                    return xMLSerializable;
                }
            }
        }
        if (wARNING == null) {
            return WARNING.none;
        }
        return wARNING;
    }

    public static enum WARNING {
        noDataSource(PageType.Datasource),
        noDataView(PageType.DataView),
        complexFilter(PageType.Filter),
        equalFilter(PageType.Filter),
        emptyColumns(PageType.Column),
        emptyChart(PageType.Chart),
        emptyCrosstab(PageType.Crosstab),
        pagelimit(PageType.Filter),
        none(null);

        private final PageType a;

        private WARNING(PageType pageType) {
            this.a = pageType;
        }

        public final PageType getRefPage() {
            return this.a;
        }

        public final String toString() {
            return "warning." + this.name();
        }
    }
}

