/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.io;

import com.inet.adhoc.base.AHBaseUtils;
import com.inet.adhoc.base.i18n.ErrorCodes;
import com.inet.adhoc.base.i18n.Msg;
import com.inet.adhoc.base.page.Page;
import com.inet.adhoc.base.page.PageType;
import com.inet.adhoc.base.xml.AdHocXmlTag;
import com.inet.adhoc.base.xml.XMLSerializable;
import com.inet.adhoc.base.xml.XMLSerializableInteger;
import com.inet.adhoc.base.xml.XMLSerializableString;
import com.inet.adhoc.io.IRequest;
import com.inet.adhoc.io.IResponse;
import com.inet.adhoc.io.RequiresPasswordException;
import com.inet.adhoc.io.ResponseException;
import com.inet.viewer.ViewerException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ErrorResponse
implements IResponse {
    private Page a;
    private HashMap<String, XMLSerializable> b;

    public ErrorResponse(IRequest iRequest, String string) {
        if (string == null) {
            string = "Unknown Error";
        }
        this.a(iRequest, null, string, 0);
    }

    public ErrorResponse(IRequest iRequest, String string, boolean bl2) {
        if (string == null) {
            string = "Unknown Error";
        }
        this.a(iRequest, null, string, bl2 ? 1 : 0);
    }

    public ErrorResponse(IRequest iRequest, Throwable throwable) {
        int n2 = 1;
        if (throwable instanceof ResponseException) {
            n2 = ((ResponseException)throwable).getType();
            throwable = ((ResponseException)throwable).getCause();
        }
        String string = throwable != null ? (throwable.getMessage() == null ? throwable.getClass().getName() : throwable.getMessage()) : "Unknown error";
        this.a(iRequest, throwable, string, n2);
    }

    public ErrorResponse(IRequest iRequest, Throwable throwable, String string) {
        this.a(iRequest, throwable, string, throwable != null ? 1 : 0);
    }

    public ErrorResponse(IRequest iRequest, Throwable throwable, ErrorCodes errorCodes, Locale locale, Object ... objectArray) {
        this.a(iRequest, throwable, Msg.getMsg(locale, errorCodes.getI18nKey(), objectArray), errorCodes.isError() && throwable != null ? 1 : 0);
        this.setErrorCode(errorCodes.getErrorCode());
    }

    public ErrorResponse(IRequest iRequest, Locale locale, String string, Object ... objectArray) {
        if (string == null) {
            string = "Unknown Error";
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        string = objectArray != null ? Msg.getMsg(locale, string, objectArray) : Msg.getMsg(locale, string);
        this.a(iRequest, null, string, 1);
    }

    public ErrorResponse() {
    }

    private void a(IRequest object, Throwable throwable, String object2, int n2) {
        this.a = object.getCurrentPage();
        this.b = object.getProperties();
        if (this.b == null) {
            this.b = new HashMap();
        }
        this.setType(n2);
        this.b.put("KEY_ERROR_MESSAGE", new XMLSerializableString((String)object2));
        if (throwable != null) {
            if (throwable instanceof RequiresPasswordException) {
                this.b.put("KEY_PASSWORD_REQUIRED", new XMLSerializableString(((RequiresPasswordException)throwable).getDatasourceName()));
            }
            if (throwable instanceof ViewerException && ((ViewerException)throwable).isNeedPrompts()) {
                object = new ByteArrayOutputStream();
                try {
                    object2 = new ObjectOutputStream((OutputStream)object);
                    ((ObjectOutputStream)object2).writeObject(throwable);
                    ((ObjectOutputStream)object2).close();
                    object = AHBaseUtils.encodeArrayToString(((ByteArrayOutputStream)object).toByteArray());
                    this.b.put("KEY_VIEWER_EXCEPTION", new XMLSerializableString((String)object));
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                }
            }
            object = new StringWriter();
            object2 = new PrintWriter((Writer)object);
            throwable.printStackTrace((PrintWriter)object2);
            while ((throwable = throwable.getCause()) != null) {
                ((PrintWriter)object2).print("Caused by: ");
                throwable.printStackTrace((PrintWriter)object2);
            }
            this.b.put("KEY_ERROR_TRACE", new XMLSerializableString(((StringWriter)object).toString()));
        }
    }

    public void setType(int n2) {
        if (this.b == null) {
            return;
        }
        String string = n2 == 1 ? "VALUE_RESPONSE_INVALID" : "VALUE_RESPONSE_MESSAGE";
        this.b.put("KEY_RESPONSE", new XMLSerializableString(string));
    }

    @Override
    public Page getCurrentPage() {
        return this.a;
    }

    @Override
    public HashMap<String, XMLSerializable> getProperties() {
        return this.b;
    }

    @Override
    public List<PageType> getEnabledPageTypes() {
        return null;
    }

    @Override
    public List<PageType> getAvailablePageTypes() {
        return null;
    }

    @Override
    public Element getXMLElement(Document document, Locale locale) {
        Element element;
        Element element2 = document.createElement(AdHocXmlTag.Response.name());
        if (this.a != null) {
            element = this.a.getXMLElement(document, locale);
            element2.appendChild(element);
        }
        element = AHBaseUtils.createPropertiesElement(document, this.b, locale);
        element2.appendChild(element);
        return element2;
    }

    @Override
    public void readXMLElement(Element object) {
        object = object.getChildNodes();
        block4: for (int i2 = 0; i2 < object.getLength(); ++i2) {
            Node node = object.item(i2);
            switch (AdHocXmlTag.valueOf(node.getNodeName())) {
                case Page: {
                    this.a = new Page();
                    this.a.readXMLElement((Element)node);
                    continue block4;
                }
                case Properties: {
                    this.b = AHBaseUtils.readPropertiesElement((Element)node);
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ErrorResponse)) {
            return false;
        }
        object = (ErrorResponse)object;
        return (this.a == null ? ((ErrorResponse)object).a == null : this.a.equals(((ErrorResponse)object).a)) && this.b.equals(((ErrorResponse)object).b);
    }

    @Override
    public boolean isValidResponse() {
        return false;
    }

    public void setErrorCode(int n2) {
        this.b.put("ERR_CODE", new XMLSerializableInteger(n2));
    }
}

