/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class SerializeUtils {
    public static final String ZIP_ENTRY_NAME = "zippedObject";

    public static byte[] zipSerialzable(Serializable serializable) throws IOException {
        if (serializable == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        zipOutputStream.putNextEntry(new ZipEntry(ZIP_ENTRY_NAME));
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
        objectOutputStream.writeObject(serializable);
        zipOutputStream.closeEntry();
        objectOutputStream.close();
        zipOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object unzipSerializable(byte[] object) throws IOException, ClassNotFoundException {
        if (object == null) {
            return null;
        }
        object = new ByteArrayInputStream((byte[])object);
        ZipInputStream zipInputStream = new ZipInputStream((InputStream)object);
        object = zipInputStream;
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null && !ZIP_ENTRY_NAME.equals(zipEntry.getName())) {
            zipEntry = ((ZipInputStream)object).getNextEntry();
        }
        if (zipEntry != null) {
            object = new ObjectInputStream((InputStream)object);
            return ((ObjectInputStream)object).readObject();
        }
        return null;
    }
}

