/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.server;

import com.inet.adhoc.base.AHBaseUtils;
import com.inet.adhoc.base.i18n.ErrorCodes;
import com.inet.adhoc.base.i18n.Msg;
import com.inet.adhoc.base.xml.XMLSerializable;
import com.inet.adhoc.base.xml.XMLSerializableString;
import com.inet.adhoc.io.ErrorResponse;
import com.inet.adhoc.io.IPathResolver;
import com.inet.adhoc.io.IRequest;
import com.inet.adhoc.io.IRequestHandler;
import com.inet.adhoc.io.IRequestHandlerFactory;
import com.inet.adhoc.io.IResponse;
import com.inet.adhoc.io.Request;
import com.inet.adhoc.io.ResponseException;
import com.inet.adhoc.server.AHRequestHandlerFactory;
import com.inet.adhoc.server.visualdb.VLCommandClient;
import com.inet.report.BaseUtils;
import com.inet.report.SystemPermissionChecker;
import com.inet.report.ay;
import com.inet.report.dw;
import com.inet.report.permissions.Permission;
import com.inet.report.permissions.WebUserInfo;
import com.inet.report.permissions.WebUserInfoFactory;
import com.inet.report.permissions.f;
import com.inet.report.util.w;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import javax.management.ServiceNotFoundException;
import javax.servlet.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AdHocServlet
extends HttpServlet
implements FilterChain {
    private IRequestHandlerFactory w;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        com.inet.report.util.w.a(servletConfig);
        dw.sw();
        this.w = AHRequestHandlerFactory.getInstance(false, true);
    }

    @Override
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        com.inet.report.servlets.a.doFilter(httpServletRequest, httpServletResponse, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        com.inet.report.i18n.Msg.setThreadLocale(httpServletRequest);
        try {
            IResponse iResponse;
            WebUserInfo webUserInfo = WebUserInfoFactory.generateWebUserInfo(httpServletRequest, httpServletResponse, new f());
            if (webUserInfo == null) {
                return;
            }
            HttpSession httpSession = httpServletRequest.getSession(true);
            if (!(SystemPermissionChecker.checkAccess(webUserInfo, Permission.INTERFACE_ADHOC) || SystemPermissionChecker.checkAccess(webUserInfo, Permission.INTERFACE_REMOTEDATASOURCES) || SystemPermissionChecker.checkAccess(webUserInfo, Permission.INTERFACE_REMOTEDESIGNER))) {
                this.a(httpServletRequest.getLocale(), httpServletResponse, a.C);
                return;
            }
            try {
                IRequestHandlerFactory.getStaticInstance().updatePathResovler(new b(this.getServletContext()));
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            IRequestHandler iRequestHandler = this.a(httpSession, webUserInfo, httpServletRequest.getLocale());
            if ("GET".equalsIgnoreCase(httpServletRequest.getMethod())) {
                String string;
                Object object;
                if (!this.w.isServiceEnabled()) {
                    throw new ServiceNotFoundException();
                }
                httpServletResponse.setContentType("text/html");
                if (iRequestHandler instanceof com.inet.adhoc.server.io.a) {
                    object = (com.inet.adhoc.server.io.a)iRequestHandler;
                    if (!((com.inet.adhoc.server.io.a)object).hasLayouts()) {
                        this.a(httpServletRequest.getLocale(), httpServletResponse, a.B);
                        return;
                    }
                    if (!((com.inet.adhoc.server.io.a)object).J()) {
                        this.a(httpServletRequest.getLocale(), httpServletResponse, a.A);
                        return;
                    }
                }
                httpServletResponse.setStatus(200);
                object = httpServletResponse.getWriter();
                String string2 = httpServletRequest.getRequestURI();
                String string3 = httpServletRequest.getContextPath();
                if (string2 != null) {
                    if (string3 != null && string2.startsWith(string3)) {
                        string2 = string2.substring(string3.length());
                    }
                    if (string2.startsWith(string = httpServletRequest.getServletPath())) {
                        string2 = string2.substring(string.length());
                    }
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                }
                if ((string = this.a(string2, httpServletRequest)) != null) {
                    ((PrintWriter)object).write(string);
                    ((PrintWriter)object).flush();
                }
                ((PrintWriter)object).close();
                return;
            }
            if (!"POST".equalsIgnoreCase(httpServletRequest.getMethod())) {
                httpServletResponse.setStatus(405);
                return;
            }
            DocumentBuilder documentBuilder = AHBaseUtils.getDocumentBuilderFactory().newDocumentBuilder();
            Document document = documentBuilder.parse(httpServletRequest.getInputStream());
            Element element = document.getDocumentElement();
            Request request = new Request();
            request.readXMLElement(element);
            if (!this.a(request, webUserInfo)) {
                this.a(httpServletRequest.getLocale(), httpServletResponse, a.C);
                return;
            }
            if (request.isRemoteDesignerRequest() && !ay.kE().isPlusVersion()) {
                iResponse = new ErrorResponse((IRequest)request, null, ErrorCodes.plusVersionRequired, httpServletRequest.getLocale(), new Object[0]);
                ((ErrorResponse)iResponse).setType(1);
            } else {
                try {
                    iResponse = iRequestHandler.handleRequest(request, false);
                }
                catch (ResponseException responseException) {
                    iResponse = responseException.getResponse();
                }
                catch (Throwable throwable) {
                    BaseUtils.error(throwable);
                    iResponse = new ErrorResponse((IRequest)request, throwable);
                }
            }
            Document document2 = AHBaseUtils.createBlankDocument();
            Element element2 = iResponse.getXMLElement(document2, iRequestHandler.getUserLocale());
            document2.appendChild(element2);
            httpServletResponse.setStatus(200);
            httpServletResponse.setContentType("text/xml");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            AHBaseUtils.transform(document2, new StreamResult(servletOutputStream));
            servletOutputStream.close();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.a(httpServletRequest.getLocale(), httpServletResponse, a.D);
        }
        catch (Exception exception) {
            if (BaseUtils.isError()) {
                BaseUtils.error(exception);
            }
            this.a(httpServletRequest.getLocale(), httpServletResponse, a.E);
        }
        finally {
            WebUserInfoFactory.destroyWebUserInfo();
        }
    }

    private boolean a(IRequest iRequest, WebUserInfo webUserInfo) throws ServiceNotFoundException {
        switch (iRequest.getCommand()) {
            case VLRequest: {
                HashMap<String, XMLSerializable> hashMap = iRequest.getProperties();
                if (hashMap != null && hashMap.containsKey("VL_CMD")) {
                    String string = ((XMLSerializableString)hashMap.get("VL_CMD")).getValue();
                    try {
                        VLCommandClient.a a2 = VLCommandClient.a.valueOf(string);
                        if (!a2.P()) {
                            return SystemPermissionChecker.checkAccess(webUserInfo, Permission.INTERFACE_REMOTEDESIGNER) || SystemPermissionChecker.checkAccess(webUserInfo, Permission.INTERFACE_REMOTEDATASOURCES);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        BaseUtils.debug(illegalArgumentException);
                    }
                }
                return SystemPermissionChecker.checkAccess(webUserInfo, Permission.INTERFACE_REMOTEDATASOURCES);
            }
        }
        if (!this.w.isServiceEnabled()) {
            throw new ServiceNotFoundException();
        }
        return SystemPermissionChecker.checkAccess(webUserInfo, Permission.INTERFACE_ADHOC);
    }

    private void a(Locale locale, HttpServletResponse httpServletResponse, a a2) throws IOException {
        httpServletResponse.setStatus(a2.getResponseCode());
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = "<html><head><title>i-net Clear Reports Ad Hoc Reporting</title></head><body><h1>" + a2.getResponseCode() + " - " + Msg.getMsg(locale, "http.code" + a2.getResponseCode()) + "</h1>" + "<p>" + Msg.getMsg(locale, a2.b().getI18nKey()) + "</p></body></html>";
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
    }

    private IRequestHandler a(HttpSession httpSession, WebUserInfo webUserInfo, Locale locale) throws ServiceNotFoundException {
        IRequestHandler iRequestHandler = (IRequestHandler)httpSession.getAttribute("adhoc.renderdata");
        if (iRequestHandler == null) {
            iRequestHandler = this.w.createRequestHandler(locale, webUserInfo);
            httpSession.setAttribute("adhoc.renderdata", iRequestHandler);
        }
        return iRequestHandler;
    }

    private String a(String string, HttpServletRequest httpServletRequest) {
        if (string.equals("")) {
            String string2 = httpServletRequest.getRequestURI();
            String string3 = "";
            if (!string2.endsWith("adhoc/")) {
                string3 = "adhoc/";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">\n");
            stringBuilder.append("<html>\n");
            stringBuilder.append("<head>\n");
            stringBuilder.append("<title>i-net Clear Reports Ad Hoc Reporting</title>\n");
            stringBuilder.append("<SCRIPT type=\"text/javascript\">\n");
            stringBuilder.append("function checkHelpContent() {");
            stringBuilder.append("     var felement = document.getElementById('ahframeset');\n");
            stringBuilder.append("     var helement = document.getElementById('adhochelp');\n");
            stringBuilder.append("     var content = navigator.userAgent.indexOf('MSIE') != -1 ? helement.contentWindow.document.body.innerHTML : helement.contentDocument.body.innerHTML;\n");
            stringBuilder.append("     if (content.length==0) {\n");
            stringBuilder.append("         felement.setAttribute(\"cols\", \"*,0\");\n");
            stringBuilder.append("         felement.setAttribute(\"frameborder\", \"0\");\n");
            stringBuilder.append("         felement.setAttribute(\"border\", \"0\");\n");
            stringBuilder.append("     } else {\n");
            stringBuilder.append("         var curCols = felement.getAttribute(\"cols\");\n");
            stringBuilder.append("         if (curCols==\"*,0\") {\n");
            stringBuilder.append("             felement.setAttribute(\"cols\", \"*,300\");\n");
            stringBuilder.append("         }\n");
            stringBuilder.append("         felement.setAttribute(\"frameborder\", \"1\");\n");
            stringBuilder.append("         felement.setAttribute(\"border\", \"5\");\n");
            stringBuilder.append("     }\n");
            stringBuilder.append("}\n");
            stringBuilder.append("</SCRIPT>\n");
            stringBuilder.append("</head>\n");
            stringBuilder.append("<frameset id=\"ahframeset\" cols=\"*,300\">\n");
            stringBuilder.append("<frame src=\"").append(string3).append("applet.html\" id=\"adhocapplet\" name=\"adhocapplet\">\n");
            stringBuilder.append("<frame src=\"\" name=\"adhochelp\" id=\"adhochelp\" onload=\"checkHelpContent()\" scrolling=\"auto\">\n");
            stringBuilder.append("<noframes>\n");
            stringBuilder.append("<p>Your browser does not support framesets. Please use a compatible browser.</p>\n");
            stringBuilder.append("</body>\n");
            stringBuilder.append("</noframes>\n");
            stringBuilder.append("</frameset>\n");
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }
        if (string.equalsIgnoreCase("applet.html")) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<HTML>");
            stringBuilder.append("<HEAD><TITLE>i-net Clear Reports Ad Hoc Reporting</TITLE>");
            stringBuilder.append("<style>div[adblocktab=true], a.visible {display:none !important; visibility:hidden !important;}body applet {position:absolute; top:0px;left:0px;}body {overflow:hidden;} h1, p {margin: 20px 20px 0px 20px; font: 10pt/1.5 Verdana,Arial} h1 {font-size: 14pt; border-bottom:1px solid #B7B7B7;} a {text-decoration:none;color:#0041B7} a:hover {text-decoration:underline} p{width: 30%; min-width: 300px;}</style></HEAD>");
            stringBuilder.append("<BODY style=\"margin:0px; padding: 0px;\" bgcolor=\"C6C6C6\">");
            stringBuilder.append("<applet code=\"com.inet.adhoc.client.loader.AHLoader\" codebase=\"").append("../").append("core").append("\" ").append("archive=\"adhocLoader.jar\" ").append("id=\"AdHoc\" width=\"100%\" height=\"100%\">");
            stringBuilder.append("<param name=\"codebase_lookup\" value=\"false\">");
            String string4 = httpServletRequest.getHeader("Cookie");
            if (string4 != null) {
                stringBuilder.append("<param name=\"cookie\" value=\"").append(string4).append("\">");
            }
            stringBuilder.append("<div>");
            stringBuilder.append("<h1>Java is not active in your Browser</h1>");
            stringBuilder.append("<p>");
            stringBuilder.append("You have to activate Java for your browser to display the content of this page.");
            stringBuilder.append("You can download Java at <a href=\"http://www.java.com/download/\" title=\"SUN Java download\">http://www.java.com/de/download/</a>.");
            stringBuilder.append("</p>");
            stringBuilder.append("</div>");
            stringBuilder.append("</applet>");
            stringBuilder.append("</BODY>");
            stringBuilder.append("</HTML>");
            return stringBuilder.toString();
        }
        return null;
    }

    private static class b
    implements IPathResolver {
        private final ServletContext I;

        public b(ServletContext servletContext) {
            this.I = servletContext;
        }

        @Override
        public String getRealPath(String string) {
            return this.I.getRealPath(string);
        }
    }

    private static enum a {
        A(403, ErrorCodes.noDatasource),
        B(403, ErrorCodes.noLayouts),
        C(403, ErrorCodes.forbidden),
        D(503, ErrorCodes.adhocInactive),
        E(500, ErrorCodes.internalError);

        private final int F;
        private final ErrorCodes G;

        private a(int n3, ErrorCodes errorCodes) {
            this.F = n3;
            this.G = errorCodes;
        }

        public int getResponseCode() {
            return this.F;
        }

        public ErrorCodes b() {
            return this.G;
        }
    }
}

