/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.server.cache.impl.hdstore;

import com.inet.adhoc.server.cache.impl.hdstore.HDFile;
import com.inet.adhoc.server.cache.intf.AdHocFile;
import com.inet.adhoc.server.cache.intf.AdHocFolder;
import com.inet.adhoc.server.cache.intf.IPermissionAccess;
import com.inet.report.permissions.PermissionUrlObject;
import com.inet.report.permissions.ReportPermissions;
import com.inet.report.permissions.WebUserInfo;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class HDFolder
implements AdHocFolder,
IPermissionAccess {
    private final File aJ;
    private final AdHocFolder aH;
    private long aK;
    private PermissionUrlObject aL;

    public HDFolder(File file, AdHocFolder adHocFolder) {
        this.aJ = file;
        this.aH = adHocFolder;
    }

    @Override
    public AdHocFile getFile(String string) {
        File file = new File(this.aJ, string);
        if (file.exists() && !file.isDirectory() && file.canRead()) {
            return new HDFile(this, file);
        }
        return null;
    }

    public List<AdHocFile> getFiles() {
        ArrayList<AdHocFile> arrayList = new ArrayList<AdHocFile>();
        File[] fileArray = this.aJ.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (file.isDirectory() || !file.canRead()) continue;
                arrayList.add(new HDFile(this, file));
            }
        }
        return arrayList;
    }

    public List<AdHocFolder> getFolders() {
        ArrayList<AdHocFolder> arrayList = new ArrayList<AdHocFolder>();
        File[] fileArray = this.aJ.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!file.isDirectory() || !file.canRead()) continue;
                arrayList.add(new HDFolder(file, this));
            }
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return this.aJ.getName();
    }

    @Override
    public AdHocFolder getParent() {
        return this.aH;
    }

    @Override
    public long lastModified() {
        return this.aJ.lastModified();
    }

    @Override
    public boolean canAccess(Object object, String string) {
        WebUserInfo webUserInfo = null;
        if (object instanceof WebUserInfo) {
            webUserInfo = (WebUserInfo)object;
        } else {
            object = null;
        }
        PermissionUrlObject permissionUrlObject = this.getPermissionUrlObject();
        if (permissionUrlObject == null) {
            return false;
        }
        return permissionUrlObject.checkAccess(webUserInfo, string, this.aJ.getPath(), 1);
    }

    private PermissionUrlObject getPermissionUrlObject() {
        block5: {
            try {
                long l2;
                File file = new File(new File(this.aJ.toURL().toURI()), "reportPermissions.xml");
                if (!file.isFile() || this.aK >= (l2 = file.lastModified())) break block5;
                try {
                    this.aL = ReportPermissions.getPermission(this.aJ.toURL());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.aK = l2;
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return this.aL;
    }

    @Override
    public IPermissionAccess getPermissionsAccess() {
        return this;
    }

    @Override
    public void done() {
    }
}

