/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.server.cache.impl.repostore;

import com.inet.adhoc.server.cache.impl.repostore.RepoFolder;
import com.inet.adhoc.server.cache.intf.AdHocFile;
import com.inet.adhoc.server.cache.intf.AdHocFolder;
import com.inet.report.BaseUtils;
import com.inet.report.repository.CCResource;
import com.inet.report.repository.Repository;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class RepoFile
implements AdHocFile {
    private final RepoFolder aU;
    private final String name;
    private long aV;
    private URI uri;
    private final Repository aW;

    public RepoFile(RepoFolder repoFolder, CCResource cCResource, Repository repository) {
        this.aU = repoFolder;
        this.aW = repository;
        this.name = cCResource.getName();
        this.aV = cCResource.getLastModifiedDate() != null ? cCResource.getLastModifiedDate().getTime() : 0L;
        this.uri = cCResource.getLocation();
    }

    @Override
    public InputStream getContent() {
        String string = this.aU.getPath() + this.getName();
        CCResource cCResource = this.aW.getResource(string);
        if (cCResource != null) {
            return cCResource.getDataStream();
        }
        return null;
    }

    @Override
    public URI toURI() {
        block3: {
            if (!this.uri.isAbsolute()) {
                try {
                    return new URI("repo:" + this.uri.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (!BaseUtils.isDebug()) break block3;
                    BaseUtils.debug(uRISyntaxException);
                }
            }
        }
        return this.uri;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long lastModified() {
        return this.aV;
    }

    @Override
    public AdHocFolder getParent() {
        return this.aU;
    }

    @Override
    public boolean isHidden() {
        return this.name.startsWith(".");
    }
}

