/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.server.cache.impl.repostore;

import com.inet.adhoc.server.cache.impl.repostore.RepoFile;
import com.inet.adhoc.server.cache.impl.repostore.RepoStore;
import com.inet.adhoc.server.cache.intf.AdHocFile;
import com.inet.adhoc.server.cache.intf.AdHocFolder;
import com.inet.adhoc.server.cache.intf.IPermissionAccess;
import com.inet.report.permissions.PermissionUrlObject;
import com.inet.report.permissions.WebUserInfo;
import com.inet.report.repository.CCElement;
import com.inet.report.repository.CCFolder;
import com.inet.report.repository.CCResource;
import com.inet.report.repository.Repository;
import java.util.ArrayList;
import java.util.List;

public class RepoFolder
implements AdHocFolder,
IPermissionAccess {
    private final RepoFolder aU;
    private final Repository aW;
    private String name;
    private String path;
    private List<RepoFolder> aX;
    private PermissionUrlObject aY;
    private long aZ = 0L;

    public RepoFolder(RepoFolder repoFolder, CCElement cCElement, Repository repository) {
        this.aU = repoFolder;
        this.aW = repository;
        this.name = cCElement.getName();
    }

    public RepoFolder(String string, String string2, Repository repository) {
        this.aU = null;
        this.aW = repository;
        this.name = string2;
        this.path = string;
    }

    public String getPath() {
        if (this.aU == null) {
            return this.path;
        }
        return this.aU.getPath() + this.getName() + "/";
    }

    private CCFolder r() {
        CCFolder cCFolder = null;
        if (this.aU == null) {
            cCFolder = RepoStore.getFolder(this.path, this.aW.getRoot());
        } else {
            CCFolder cCFolder2 = this.aU.r();
            if (cCFolder2 == null) {
                return null;
            }
            cCFolder = cCFolder2.getFolder(this.getName());
        }
        if (cCFolder != null && this.aZ + 300000L < System.currentTimeMillis()) {
            this.aY = cCFolder.getFolderPermissions().getPermissionUrlObject();
        }
        return cCFolder;
    }

    @Override
    public AdHocFile getFile(String string) {
        CCFolder cCFolder = this.r();
        if (cCFolder != null) {
            CCResource cCResource = cCFolder.getResource(string);
            return cCResource != null ? new RepoFile(this, cCResource, this.aW) : null;
        }
        return null;
    }

    public List<AdHocFile> getFiles() {
        ArrayList<AdHocFile> arrayList = new ArrayList<AdHocFile>();
        CCFolder cCFolder = this.r();
        if (cCFolder == null) {
            return arrayList;
        }
        List<CCResource> list = cCFolder.getResources();
        for (CCResource cCResource : list) {
            arrayList.add(new RepoFile(this, cCResource, this.aW));
        }
        return arrayList;
    }

    public List<AdHocFolder> getFolders() {
        ArrayList<AdHocFolder> arrayList = new ArrayList<AdHocFolder>();
        CCFolder cCFolder = this.r();
        if (cCFolder == null) {
            return arrayList;
        }
        List<CCFolder> list = cCFolder.getFolders();
        if (this.aX == null) {
            this.aX = new ArrayList<RepoFolder>(list.size());
        }
        for (CCElement cCElement : list) {
            RepoFolder repoFolder = new RepoFolder(this, cCElement, this.aW);
            this.aX.add(repoFolder);
            arrayList.add(repoFolder);
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AdHocFolder getParent() {
        return this.aU;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public IPermissionAccess getPermissionsAccess() {
        return this;
    }

    @Override
    public boolean canAccess(Object object, String string) {
        WebUserInfo webUserInfo = null;
        if (object instanceof WebUserInfo) {
            webUserInfo = (WebUserInfo)object;
        } else {
            object = null;
        }
        if (this.aZ + 300000L < System.currentTimeMillis()) {
            this.r();
        }
        if (this.aY == null) {
            return true;
        }
        return this.aY.checkAccess(webUserInfo, string, this.getPath(), 1);
    }

    @Override
    public void done() {
        if (this.aX != null) {
            for (RepoFolder repoFolder : this.aX) {
                repoFolder.done();
            }
        }
        this.aX = null;
    }
}

