/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.server.database;

import com.inet.adhoc.base.model.DatabaseEntryPath;
import com.inet.adhoc.base.model.Parameter;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseSAPDB;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DataFactory;
import com.inet.report.i18n.ErrorCode;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public class DatabaseEntry {
    public static final int TYPE_TABLE = 0;
    public static final int TYPE_SYSTEM_TABLE = 1;
    public static final int TYPE_VIEW = 10;
    public static final int TYPE_VIEW_WITH_PARAM = 11;
    public static final int TYPE_SPROC = 20;
    public static final int TYPE_SPROC_WITH_PARAM = 21;
    private Datasource bF;
    private int entryType;
    private int bG;
    private DatabaseEntryPath bH;
    private ArrayList<Parameter> bI;

    public DatabaseEntry(Datasource datasource, String string, String string2, String string3, int n2, int n3, boolean bl2) {
        this.bF = datasource;
        this.entryType = n2;
        this.bG = n3;
        String string4 = bl2 ? string : null;
        String string5 = ".".equals(string2) ? null : string2;
        this.bH = new DatabaseEntryPath(string4, string5, string3);
    }

    public int getEntryType() {
        return this.entryType;
    }

    public int getSpType() {
        return this.bG;
    }

    public String getDatasourceName() {
        return this.bF.getDataSourceConfigurationName();
    }

    public DatabaseEntryPath getPath() {
        return this.bH;
    }

    public boolean returnsResultSet() {
        switch (this.bG) {
            case 0: 
            case 2: {
                return true;
            }
        }
        if (this.bI == null) {
            return true;
        }
        return this.A();
    }

    private boolean A() {
        for (Parameter parameter : this.bI) {
            switch (parameter.getColumnType()) {
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (parameter.getDataType() != -10) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isStoreProcedure() {
        return this.entryType == 20 || this.entryType == 21 || this.entryType == 11;
    }

    public synchronized void loadParameters() throws ReportException {
        if (this.bI != null) {
            return;
        }
        this.bI = new ArrayList();
        if (!this.isStoreProcedure()) {
            return;
        }
        DataFactory dataFactory = this.bF.getDataFactory();
        Connection connection = this.bF.getConnection();
        try {
            List<ColumnInfo> list = dataFactory.getColumns(this.bF, this.bH.getCatalog(), this.bH.getSchema(), this.bH.getName(), 2);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                int n2;
                ColumnInfo columnInfo = list.get(i2);
                Parameter parameter = new Parameter();
                parameter.setColumnName(columnInfo.getName());
                parameter.setColumnType(columnInfo.getColumnType());
                if (parameter.getColumnType() == 3) continue;
                int n3 = columnInfo.getSqlType();
                if (n3 == 1111) {
                    n2 = -10;
                } else {
                    n2 = DatabaseTables.mapSqlTypeToCCType(n3);
                    int n4 = n3 ^ (short)n3;
                    if (n4 != 0) {
                        n2 |= 0x80;
                    }
                }
                parameter.setDataType(n2);
                this.bI.add(parameter);
            }
            if (dataFactory instanceof DatabaseSAPDB) {
                Parameter parameter = new Parameter();
                parameter.setColumnName("RETURN_VALUE");
                parameter.setColumnType(3);
                parameter.setDataType(-10);
                this.bI.add(parameter);
            }
        }
        catch (Exception exception) {
            this.bI = null;
            if (BaseUtils.gk()) {
                BaseUtils.warning(exception);
            }
            throw ReportExceptionFactory.createReportExceptionWithCause(exception, ErrorCode.errorReadingSPParams, this.getPath().getFullName());
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public List<Parameter> getInputParameters() {
        if (this.bI == null) {
            throw new IllegalStateException("The parameter list is empty. Please execute loadParameters() first.");
        }
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (Parameter parameter : this.bI) {
            switch (parameter.getColumnType()) {
                case 1: 
                case 2: {
                    if (parameter.getDataType() == -10) break;
                    arrayList.add((Parameter)parameter.copy());
                }
            }
        }
        return arrayList;
    }
}

