/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.server.database;

import com.inet.adhoc.base.model.DatabaseEntryPath;
import com.inet.adhoc.base.model.DatabaseVO;
import com.inet.adhoc.base.model.DatasourceVO;
import com.inet.adhoc.base.model.FieldVO;
import com.inet.adhoc.base.model.JoinListVO;
import com.inet.adhoc.base.model.JoinVO;
import com.inet.adhoc.base.model.Parameter;
import com.inet.adhoc.base.model.PasswordData;
import com.inet.adhoc.base.model.TableSourceVO;
import com.inet.adhoc.base.model.VOList;
import com.inet.adhoc.io.RequiresPasswordException;
import com.inet.adhoc.server.database.DatabaseEntry;
import com.inet.adhoc.server.database.NeedParametersException;
import com.inet.adhoc.server.database.a;
import com.inet.adhoc.server.database.b;
import com.inet.adhoc.server.handler.DataInfo;
import com.inet.adhoc.server.handler.DatasourcePageHandler;
import com.inet.adhoc.server.handler.PageHandlerUtilities;
import com.inet.adhoc.server.handler.PageInfo;
import com.inet.adhoc.server.handler.s;
import com.inet.report.Database;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.Section;
import com.inet.report.TableSource;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.datasource.widget.c;
import com.inet.report.database.DataFactory;
import com.inet.report.i18n.ErrorCode;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DatabaseFactory {
    private static final Set<String> bJ = new a();

    public List<FieldVO> getTableSourceFields(List<TableSourceVO> list, PasswordData passwordData, Engine engine) throws ReportException {
        if (passwordData == null) {
            throw new IllegalArgumentException("Parameter 'session' is null.");
        }
        if (list == null) {
            throw new IllegalArgumentException("Parameter 'tables' is null.");
        }
        ArrayList<FieldVO> arrayList = new ArrayList<FieldVO>();
        Engine engine2 = engine != null ? engine : RDC.createEmptyEngine("java");
        DatabaseTables databaseTables = engine2.getDatabaseTables();
        for (TableSourceVO tableSourceVO : list) {
            arrayList.addAll(this.getTableSourceFields(databaseTables, tableSourceVO, passwordData));
        }
        return arrayList;
    }

    public List<FieldVO> getTableSourceFields(DatabaseTables databaseTables, TableSourceVO tableSourceVO, PasswordData passwordData) throws ReportException {
        ArrayList<FieldVO> arrayList = new ArrayList<FieldVO>();
        Connection connection = null;
        try {
            Object object;
            String string = tableSourceVO.getDatasource();
            Datasource datasource = databaseTables.getDatasource(string);
            if (datasource == null) {
                datasource = databaseTables.createDatasource(string);
                object = passwordData.getPassword(string);
                if (object != null && ((String)object).trim().length() > 0) {
                    datasource.setPassword((String)object);
                }
            }
            connection = datasource.getConnection();
            object = datasource.getTableSourceIfExist(tableSourceVO.getAlias());
            if (object == null) {
                if (!tableSourceVO.isCommand()) {
                    if (tableSourceVO.isArtificialAlias()) {
                        object = datasource.createTableSource(tableSourceVO.getDatabaseIdentifier());
                        if (!tableSourceVO.getAlias().equals(((TableSource)object).getAlias())) {
                            tableSourceVO.setAlias(((TableSource)object).getAlias());
                        }
                    } else {
                        object = datasource.createTableSource(tableSourceVO.getDatabaseIdentifier(), tableSourceVO.getAlias());
                    }
                    this.setParameterValue(tableSourceVO, (TableSource)object);
                } else {
                    object = datasource.createTableSourceCommand(tableSourceVO.getAlias(), tableSourceVO.getSqlStatement(), tableSourceVO.getQuoteStringPrompts());
                }
            }
            if (!tableSourceVO.isCommand()) {
                ((TableSource)object).refresh();
            }
            arrayList.addAll(PageHandlerUtilities.getAllFieldsOfTablesource((TableSource)object));
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException, ErrorCode.errorConnecting, new Object[0]);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public void setParameterValue(TableSourceVO tableSourceVO, TableSource tableSource) throws ReportException {
        List<Parameter> list = tableSourceVO.getParameters();
        if (list.size() > 0) {
            String[] stringArray = new String[list.size()];
            int[] nArray = new int[list.size()];
            Object[] objectArray = new Object[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Parameter parameter = list.get(i2);
                stringArray[i2] = parameter.getColumnName();
                nArray[i2] = parameter.getDataType();
                objectArray[i2] = parameter.getValue();
            }
            tableSource.setInputParameter(stringArray, nArray, objectArray);
        }
    }

    public TableSourceVO fillTableSourceVO(TableSourceVO tableSourceVO, List<TableSourceVO> list, PasswordData passwordData, URL uRL) throws ReportException, NeedParametersException {
        if (tableSourceVO == null) {
            throw new IllegalArgumentException("Parameter 'table' is null.");
        }
        if (list == null) {
            throw new IllegalArgumentException("Parameter 'sources' is null.");
        }
        if (passwordData == null) {
            throw new IllegalArgumentException("Parameter 'session' is null.");
        }
        TableSourceVO tableSourceVO2 = tableSourceVO.copy();
        if (!tableSourceVO2.isCommand()) {
            b b2 = b.a(tableSourceVO2.getDatasource(), passwordData.getPassword(tableSourceVO2.getDatasource()), uRL);
            DatabaseEntry databaseEntry = b2.d(tableSourceVO2.getDatabaseIdentifier());
            if (databaseEntry != null) {
                databaseEntry.loadParameters();
                if (!databaseEntry.returnsResultSet()) {
                    throw ReportExceptionFactory.createReportException(ErrorCode.errorNoResultSet, databaseEntry.getPath().getFullName());
                }
                List<Parameter> list2 = tableSourceVO.getParameters();
                if (!this.c(list2)) {
                    list2 = databaseEntry.getInputParameters();
                }
                for (Parameter parameter : list2) {
                    if (parameter.isSetValue()) continue;
                    throw new NeedParametersException(list2);
                }
                if (!tableSourceVO2.isArtificialAlias()) {
                    String string = com.inet.report.a.a(b2.getDatasource(), tableSourceVO2.getAlias());
                    tableSourceVO2.setAlias(string);
                }
                tableSourceVO2 = this.a(tableSourceVO2, passwordData);
            }
            this.a(b2, tableSourceVO2, list);
            b2.E();
        } else {
            tableSourceVO2 = this.a(tableSourceVO2, passwordData);
        }
        return tableSourceVO2;
    }

    private boolean c(List<Parameter> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (Parameter parameter : list) {
            if (parameter.isSetValue()) continue;
            return false;
        }
        return true;
    }

    private TableSourceVO a(TableSourceVO tableSourceVO, PasswordData passwordData) throws ReportException {
        TableSourceVO tableSourceVO2 = tableSourceVO.copy();
        ArrayList<TableSourceVO> arrayList = new ArrayList<TableSourceVO>();
        arrayList.add(tableSourceVO2);
        tableSourceVO2.setFieldList(this.getTableSourceFields(arrayList, passwordData, null));
        return tableSourceVO2;
    }

    private void a(b b2, TableSourceVO tableSourceVO, List<TableSourceVO> list) {
        String string;
        int n2 = Integer.MAX_VALUE;
        DataFactory dataFactory = b2.getDatasource().getDataFactory();
        if (dataFactory instanceof Database) {
            n2 = ((Database)dataFactory).getMaxAliasNameLength();
        }
        if ((string = tableSourceVO.getAlias()).length() > n2) {
            string = string.substring(0, n2);
        }
        if (this.a(string, list)) {
            int n3 = 0;
            if (string.length() > n2 - 2) {
                string = string.substring(0, n2 - 2);
            }
            StringBuilder stringBuilder = new StringBuilder(string).append('_');
            boolean bl2 = true;
            while (bl2) {
                StringBuilder stringBuilder2;
                if ((stringBuilder2 = new StringBuilder(stringBuilder).append(++n3)).length() > n2) {
                    throw new IllegalStateException("Can not find the alias name for table: " + tableSourceVO.getDatabaseIdentifier());
                }
                bl2 = this.a(stringBuilder2.toString(), list);
            }
            tableSourceVO.setAlias(stringBuilder.append(n3).toString());
        } else if (!string.equals(tableSourceVO.getAlias())) {
            tableSourceVO.setAlias(string);
        }
    }

    private boolean a(String string, List<TableSourceVO> list) {
        for (TableSourceVO tableSourceVO : list) {
            if (!tableSourceVO.getAlias().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public DatabaseVO createDatabaseVO(DatasourceVO datasourceVO, String string, boolean bl2, boolean bl3, URL uRL) throws ReportException {
        String string2 = datasourceVO.getName();
        b b2 = b.a(string2, string, uRL);
        DatabaseEntry[] databaseEntryArray = b2.B();
        ArrayList<TableSourceVO> arrayList = new ArrayList<TableSourceVO>(databaseEntryArray.length);
        for (int i2 = 0; i2 < databaseEntryArray.length; ++i2) {
            DatabaseEntry databaseEntry = databaseEntryArray[i2];
            if (bl2 && (databaseEntry.getEntryType() == 1 || bJ.contains(databaseEntry.getPath().getSchema())) || bl3 && databaseEntry.isStoreProcedure()) continue;
            TableSourceVO tableSourceVO = PageHandlerUtilities.getTableSourceVO(databaseEntry);
            arrayList.add(tableSourceVO);
        }
        DatabaseVO databaseVO = new DatabaseVO(string2);
        databaseVO.setTableSourceList(arrayList);
        databaseVO.setOracle(b2.isOracle());
        databaseVO.setJDBC(b2.D());
        databaseVO.setUser(b2.getDatasource().getUsername());
        return databaseVO;
    }

    public VOList<FieldVO> createFieldVOList(JoinListVO joinListVO, PasswordData passwordData) throws ReportException {
        List<TableSourceVO> list = joinListVO.getTableSourceList();
        List<FieldVO> list2 = this.getTableSourceFields(list, passwordData, null);
        return new VOList<FieldVO>(list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDBStatement(PasswordData passwordData, DatasourceVO datasourceVO, JoinListVO joinListVO) throws ReportException, SQLException {
        Object object;
        Object object2;
        ArrayList<JoinVO> arrayList = new ArrayList<JoinVO>();
        for (JoinVO object52 : joinListVO.getJoinList()) {
            TableSourceVO tableSourceVO = joinListVO.getTablesource(object52.getFirstTSName());
            object2 = joinListVO.getTablesource(object52.getSecondTSName());
            if (!tableSourceVO.isSp() && !((TableSourceVO)object2).isSp() && !tableSourceVO.isCommand() && !((TableSourceVO)object2).isCommand()) continue;
            arrayList.add(object52);
        }
        ArrayList arrayList2 = new ArrayList();
        for (TableSourceVO tableSourceVO : joinListVO.getTableSourceList()) {
            if (!tableSourceVO.isSp() && !tableSourceVO.isCommand()) continue;
            arrayList2.add(tableSourceVO);
        }
        joinListVO.getJoinList().removeAll(arrayList);
        joinListVO.getTableSourceList().removeAll(arrayList2);
        Engine engine = RDC.createEmptyEngine("java");
        PageInfo pageInfo = new PageInfo();
        pageInfo.setState(PageInfo.a.cG);
        object2 = new DatasourcePageHandler();
        DataInfo dataInfo = new DataInfo();
        dataInfo.setPasswordData(passwordData);
        ((DatasourcePageHandler)object2).fillEngine(engine, datasourceVO, pageInfo, dataInfo);
        s s2 = new s();
        s2.fillEngine(engine, joinListVO, pageInfo, dataInfo);
        DatabaseTables databaseTables = engine.getDatabaseTables();
        if (databaseTables != null) {
            for (int i2 = 0; i2 < databaseTables.getDatasourceCount(); ++i2) {
                object = databaseTables.getDatasource(i2);
                String string = passwordData.getPassword(((Datasource)object).getDataSourceConfigurationName());
                if (string == null) continue;
                ((Datasource)object).setPassword(string);
            }
        }
        Section section = engine.getArea("D").getSection(0);
        for (TableSourceVO tableSourceVO : joinListVO.getTableSourceList()) {
            if (tableSourceVO.getType() != 0 && tableSourceVO.getType() != 1 || tableSourceVO.getFieldList() == null) continue;
            for (FieldVO fieldVO : tableSourceVO.getFieldList()) {
                if (fieldVO.getValueType() == 7 || fieldVO.getValueType() == 8 || fieldVO.getValueType() == -1) continue;
                section.addFieldElement(PageHandlerUtilities.getField(engine, fieldVO), 0, 0, 0, 0);
            }
        }
        object = engine.getDatabaseTables().getDatasource(0).getConnection();
        if (object != null) {
            try {
                String[] stringArray;
                for (String string : stringArray = engine.getDefaultSqlOfAllStatements(false)) {
                    if (string == null || string.trim().length() <= 0) continue;
                    String string2 = DatabaseTables.changeWhereToNoRows(string);
                    com.inet.report.database.a.a(object.createStatement(), string2, null);
                }
            }
            finally {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void checkPassword(String string, String string2) throws ReportException {
        DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(string2, 3);
        if (dataSourceConfiguration != null && dataSourceConfiguration.isNeedPassword() && "".equals(dataSourceConfiguration.getPassword())) {
            Engine engine = RDC.createEmptyEngine("java");
            Datasource datasource = null;
            try {
                datasource = engine.getDatabaseTables().createDatasource(string2);
                datasource.setPassword(string);
            }
            catch (ReportException reportException) {
                // empty catch block
            }
            try {
                if (datasource != null) {
                    datasource.getConnection();
                }
            }
            catch (ReportException reportException) {
                if (reportException.getCause() instanceof ClassNotFoundException) {
                    throw reportException;
                }
                throw new RequiresPasswordException(string2);
            }
            finally {
                try {
                    if (datasource != null && datasource.hasValidConnection()) {
                        Connection connection = datasource.getConnection();
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getDriverName(DataSourceConfiguration dataSourceConfiguration) {
        String string = "";
        if (dataSourceConfiguration != null) {
            com.inet.report.config.datasource.widget.b b2 = c.k(Locale.getDefault()).d(dataSourceConfiguration);
            string = b2 == null ? dataSourceConfiguration.getDriverClassname() : b2.getDisplayName();
        }
        return string;
    }

    public TableSourceVO getTableSourceVO(TableSource tableSource) throws ReportException {
        try {
            Datasource datasource = tableSource.getDatasource();
            String[] stringArray = com.inet.report.a.b(datasource, tableSource.getDatabaseIdentifier());
            DatabaseEntryPath databaseEntryPath = new DatabaseEntryPath(stringArray[0], stringArray[1], stringArray[2]);
            int n2 = com.inet.report.a.a(tableSource, false);
            TableSourceVO tableSourceVO = new TableSourceVO(n2, datasource.getDataSourceConfigurationName(), databaseEntryPath);
            tableSourceVO.setAlias(tableSource.getAlias());
            List<FieldVO> list = PageHandlerUtilities.getAllFieldsOfTablesource(tableSource);
            tableSourceVO.setFieldList(list);
            return tableSourceVO;
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException, ErrorCode.errorConnecting, new Object[0]);
        }
    }
}

