/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.server.handler;

import com.inet.adhoc.base.model.DatasourceVO;
import com.inet.adhoc.base.model.PasswordData;
import com.inet.adhoc.base.model.VO;
import com.inet.adhoc.base.model.VOList;
import com.inet.adhoc.base.page.Page;
import com.inet.adhoc.base.page.PageType;
import com.inet.adhoc.server.database.DatabaseFactory;
import com.inet.adhoc.server.handler.DataInfo;
import com.inet.adhoc.server.handler.PageInfo;
import com.inet.adhoc.server.handler.o;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import java.util.ArrayList;

public class DatasourcePageHandler
implements o {
    @Override
    public Page createPage(Engine engine, PageInfo pageInfo) {
        if (pageInfo.isReadyReport()) {
            return null;
        }
        Page page = new Page(PageType.Datasource);
        DatasourceVO datasourceVO = this.g(engine);
        page.setUserChoices(datasourceVO);
        return page;
    }

    public static VOList<DatasourceVO> getAllDatasourceVOs(boolean bl2) {
        String[] stringArray = DataSourceConfigurationManager.getDataSourceConfigurationNames();
        ArrayList<DatasourceVO> arrayList = new ArrayList<DatasourceVO>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(stringArray[i2], 3);
            if (dataSourceConfiguration == null || !bl2 && dataSourceConfiguration.isLayoutDataSource()) continue;
            String string = new DatabaseFactory().getDriverName(dataSourceConfiguration);
            DatasourceVO datasourceVO = new DatasourceVO(dataSourceConfiguration.getConfigurationName(), string);
            arrayList.add(datasourceVO);
        }
        return new VOList<DatasourceVO>(arrayList);
    }

    private DatasourceVO g(Engine engine) {
        try {
            if (engine.getDatabaseTables().getDatasourceCount() != 0) {
                DataSourceConfiguration dataSourceConfiguration = engine.getDatabaseTables().getDatasource(0).getDataSourceConfiguration();
                Datasource datasource = engine.getDatabaseTables().getDatasource(0);
                if (!DatasourcePageHandler.isLayoutDatasource(datasource)) {
                    String string = new DatabaseFactory().getDriverName(dataSourceConfiguration);
                    DatasourceVO datasourceVO = new DatasourceVO(dataSourceConfiguration.getConfigurationName(), string);
                    return datasourceVO;
                }
            }
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Engine fillEngine(Engine engine, VO vO, PageInfo pageInfo, DataInfo dataInfo) throws ReportException {
        if (vO != null) {
            DatasourceVO datasourceVO = (DatasourceVO)vO;
            Datasource datasource = engine.getDatabaseTables().createDatasource(datasourceVO.getName());
            PasswordData passwordData = dataInfo.getPasswordData();
            if (datasource != null && passwordData != null && passwordData.getPassword(datasourceVO.getName()) != null) {
                datasource.setPassword(passwordData.getPassword(datasourceVO.getName()));
            }
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[AdHoc] set datasource properties");
            }
        }
        return engine;
    }

    public void clean(Engine engine) throws ReportException {
        DatabaseTables databaseTables = engine.getDatabaseTables();
        int n2 = 0;
        while (n2 < databaseTables.getDatasourceCount()) {
            Datasource datasource = databaseTables.getDatasource(n2);
            if (DatasourcePageHandler.isLayoutDatasource(datasource)) {
                databaseTables.removeDatasource(datasource);
                continue;
            }
            ++n2;
        }
    }

    public static boolean isLayoutDatasource(Datasource datasource) {
        if (datasource == null) {
            return false;
        }
        String string = datasource.getDataSourceConfigurationName();
        DataSourceConfiguration dataSourceConfiguration = datasource.getDataSourceConfiguration();
        if (dataSourceConfiguration != null) {
            return dataSourceConfiguration.isLayoutDataSource();
        }
        return string != null && string.endsWith("LayoutDatasource");
    }
}

