/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.server.handler;

import com.inet.adhoc.base.i18n.Msg;
import com.inet.adhoc.base.model.ChartVO;
import com.inet.adhoc.base.model.FieldVO;
import com.inet.adhoc.base.model.GroupVO;
import com.inet.adhoc.base.model.JoinVO;
import com.inet.adhoc.base.model.SortVO;
import com.inet.adhoc.base.model.SumVO;
import com.inet.adhoc.base.model.TableSourceVO;
import com.inet.adhoc.base.model.VOList;
import com.inet.adhoc.base.page.Page;
import com.inet.adhoc.base.page.PageType;
import com.inet.adhoc.server.database.DatabaseEntry;
import com.inet.adhoc.server.handler.DatasourcePageHandler;
import com.inet.adhoc.server.handler.d;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.Join;
import com.inet.report.ReportException;
import com.inet.report.Section;
import com.inet.report.SortField;
import com.inet.report.SummaryField;
import com.inet.report.TableSource;
import com.inet.report.chart.dataset.ForAllRecordsDataset;
import com.inet.report.chart.dataset.ForEachRecordDataset;
import com.inet.report.chart.dataset.OneGroupDataset;
import com.inet.report.chart.dataset.StandardDataset;
import com.inet.report.chart.dataset.TwoGroupsDataset;
import com.inet.report.chart.plot.BarStyle;
import com.inet.report.chart.plot.ChartPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.PiePlot;
import com.inet.report.chart.plot.StandardPlot;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PageHandlerUtilities {
    public static List<Element> getElements(Engine engine, Class<?> clazz) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        try {
            for (int i2 = 0; i2 < engine.getAreaCount(); ++i2) {
                if (engine.getArea(i2) == null) continue;
                arrayList.addAll(PageHandlerUtilities.getElementsOfArea(engine.getArea(i2), clazz));
            }
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<Element> getElementsOfArea(Area area, Class<?> clazz) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i2 = 0; i2 < area.getSectionCount(); ++i2) {
            Section section = area.getSection(i2);
            Element[] elementArray = section.getElements();
            for (int i3 = 0; i3 < elementArray.length; ++i3) {
                if (elementArray[i3].getClass() != clazz && !clazz.isAssignableFrom(elementArray[i3].getClass())) continue;
                arrayList.add(elementArray[i3]);
            }
        }
        return arrayList;
    }

    public static int mapFieldType(int n2) {
        int n3 = -1;
        if (n2 >= 0) {
            n2 &= 0x7F;
        }
        switch (n2) {
            case 6: {
                n3 = 0;
                break;
            }
            case 7: {
                n3 = 5;
                break;
            }
            case 8: {
                n3 = 6;
                break;
            }
            case 9: {
                n3 = 2;
                break;
            }
            case 10: {
                n3 = 3;
                break;
            }
            case 11: {
                n3 = 1;
                break;
            }
            case 14: {
                n3 = 7;
                break;
            }
            case 15: {
                n3 = 4;
                break;
            }
            case -10: {
                n3 = 8;
            }
        }
        return n3;
    }

    public static int mapFieldTypeToCC(int n2) {
        switch (n2) {
            case 0: {
                return 6;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 8;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 10;
            }
            case 1: {
                return 11;
            }
            case 7: {
                return 14;
            }
            case 4: {
                return 15;
            }
            case 8: {
                return -10;
            }
            case -1: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Unknown field type: " + n2);
    }

    public static GroupVO.SortOrder mapSortOrder(int n2) {
        switch (n2) {
            case 1: {
                return GroupVO.SortOrder.Descending;
            }
            case 2: 
            case 5: {
                return GroupVO.SortOrder.Original;
            }
        }
        return GroupVO.SortOrder.Ascending;
    }

    public static int mapSortOrder(GroupVO.SortOrder sortOrder) {
        if (sortOrder == null) {
            throw new IllegalArgumentException("Parameter 'sortOrder' is null");
        }
        if (sortOrder == GroupVO.SortOrder.Descending) {
            return 1;
        }
        if (sortOrder == GroupVO.SortOrder.Original) {
            return 5;
        }
        if (sortOrder == GroupVO.SortOrder.Ascending) {
            return 0;
        }
        throw new IllegalArgumentException("Unknown sort order: " + sortOrder.name());
    }

    public static GroupVO.TimePeriod mapTimeInterval(int n2) {
        switch (n2) {
            case 1: {
                return GroupVO.TimePeriod.Week;
            }
            case 2: {
                return GroupVO.TimePeriod.TwoWeeks;
            }
            case 3: {
                return GroupVO.TimePeriod.HalfMonth;
            }
            case 4: {
                return GroupVO.TimePeriod.Month;
            }
            case 5: {
                return GroupVO.TimePeriod.Quarter;
            }
            case 6: {
                return GroupVO.TimePeriod.HalfYear;
            }
            case 7: {
                return GroupVO.TimePeriod.Year;
            }
            case 8: {
                return GroupVO.TimePeriod.Second;
            }
            case 9: {
                return GroupVO.TimePeriod.Minute;
            }
            case 10: {
                return GroupVO.TimePeriod.Hour;
            }
            case 11: {
                return GroupVO.TimePeriod.AmPm;
            }
        }
        return GroupVO.TimePeriod.Day;
    }

    public static int mapTimeInterval(GroupVO.TimePeriod timePeriod) {
        if (timePeriod == null) {
            throw new IllegalArgumentException("Parameter 'adHocTime' is null");
        }
        if (timePeriod == GroupVO.TimePeriod.Week) {
            return 1;
        }
        if (timePeriod == GroupVO.TimePeriod.TwoWeeks) {
            return 2;
        }
        if (timePeriod == GroupVO.TimePeriod.HalfMonth) {
            return 3;
        }
        if (timePeriod == GroupVO.TimePeriod.Month) {
            return 4;
        }
        if (timePeriod == GroupVO.TimePeriod.Quarter) {
            return 5;
        }
        if (timePeriod == GroupVO.TimePeriod.HalfYear) {
            return 6;
        }
        if (timePeriod == GroupVO.TimePeriod.Year) {
            return 7;
        }
        if (timePeriod == GroupVO.TimePeriod.Second) {
            return 8;
        }
        if (timePeriod == GroupVO.TimePeriod.Minute) {
            return 9;
        }
        if (timePeriod == GroupVO.TimePeriod.Hour) {
            return 10;
        }
        if (timePeriod == GroupVO.TimePeriod.AmPm) {
            return 11;
        }
        if (timePeriod == GroupVO.TimePeriod.Day) {
            return 0;
        }
        throw new IllegalArgumentException("Unknown time period: " + timePeriod.name());
    }

    public static VOList<FieldVO> getAllFields(Engine engine) {
        ArrayList<FieldVO> arrayList = new ArrayList<FieldVO>();
        try {
            for (int i2 = 0; i2 < engine.getDatabaseTables().getDatasourceCount(); ++i2) {
                Datasource datasource = engine.getDatabaseTables().getDatasource(i2);
                if (datasource == null || datasource.getDataSourceConfiguration() == null || DatasourcePageHandler.isLayoutDatasource(datasource)) continue;
                for (int i3 = 0; i3 < datasource.getTableSourceCount(); ++i3) {
                    TableSource tableSource = datasource.getTableSource(i3);
                    if (tableSource == null) continue;
                    arrayList.addAll(PageHandlerUtilities.getAllFieldsOfTablesource(tableSource));
                }
            }
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        return new VOList<FieldVO>(arrayList);
    }

    public static List<FieldVO> getAllFieldsOfTablesource(TableSource tableSource) {
        ArrayList<FieldVO> arrayList = new ArrayList<FieldVO>();
        for (int i2 = 0; i2 < tableSource.getColumnCount(); ++i2) {
            String string = tableSource.getColumnName(i2);
            int n2 = PageHandlerUtilities.mapFieldType(tableSource.getColumnType(i2));
            FieldVO fieldVO = new FieldVO(string, tableSource.getAlias(), n2);
            fieldVO.setAlias(tableSource.getDatabaseField(string).getColumnLabel());
            arrayList.add(fieldVO);
        }
        return arrayList;
    }

    public static GroupVO getGroupVO(Group group) {
        GroupVO groupVO = null;
        if (group != null && group.getField() != null) {
            FieldVO fieldVO = PageHandlerUtilities.getFieldVO(group.getField());
            groupVO = new GroupVO(fieldVO);
            groupVO.setSortOrder(PageHandlerUtilities.mapSortOrder(group.getSort()));
            groupVO.setGroupingByTimePeriod(PageHandlerUtilities.mapTimeInterval(group.getSectionWillBePrinted()));
        }
        return groupVO;
    }

    public static FieldVO getFieldVO(Field field) throws IllegalArgumentException {
        int n2 = PageHandlerUtilities.mapFieldType(field.getValueType());
        if (field.getType() == 14) {
            String string = field.getName();
            String string2 = "";
            int n3 = string.indexOf(".");
            if (n3 > -1) {
                string2 = string.substring(0, n3);
                string = string.substring(n3 + 1, string.length());
                FieldVO fieldVO = new FieldVO(string, string2, n2);
                fieldVO.setAlias(((DatabaseField)field).getColumnLabel());
                return fieldVO;
            }
        } else {
            FieldVO.FieldType fieldType = null;
            fieldType = field.getType() == 13 ? FieldVO.FieldType.FormulaField : (field.getType() == 17 ? FieldVO.FieldType.SQLField : FieldVO.FieldType.Other);
            return new FieldVO(field.getName(), fieldType, n2);
        }
        throw new IllegalArgumentException("Unsupported field type: " + field.getType());
    }

    public static SumVO getSumVO(SummaryField summaryField) {
        SumVO sumVO = new SumVO(PageHandlerUtilities.getFieldVO(summaryField.getField()), Locale.getDefault(), false);
        if (summaryField.getField2nd() != null) {
            sumVO.setSecondField(PageHandlerUtilities.getFieldVO(summaryField.getField2nd()));
        }
        if (summaryField.getGroup() != null) {
            sumVO.setGroup(PageHandlerUtilities.getGroupVO(summaryField.getGroup()));
        }
        sumVO.setNth(summaryField.getSummaryNth() < 0 ? 0 : summaryField.getSummaryNth());
        sumVO.setOperation(PageHandlerUtilities.mapSumOperation(summaryField.getSummaryOperation()));
        sumVO.setName(summaryField.getName());
        return sumVO;
    }

    public static SumVO.Operation mapSumOperation(int n2) {
        switch (n2) {
            case 0: {
                return SumVO.Operation.Sum;
            }
            case 1: {
                return SumVO.Operation.Average;
            }
            case 2: {
                return SumVO.Operation.Variance;
            }
            case 3: {
                return SumVO.Operation.StdDeviation;
            }
            case 4: {
                return SumVO.Operation.Maximum;
            }
            case 5: {
                return SumVO.Operation.Minimum;
            }
            case 6: {
                return SumVO.Operation.Count;
            }
            case 7: {
                return SumVO.Operation.PopVariance;
            }
            case 8: {
                return SumVO.Operation.PopStdVariance;
            }
            case 9: {
                return SumVO.Operation.DistinctCount;
            }
            case 10: {
                return SumVO.Operation.Correlation;
            }
            case 11: {
                return SumVO.Operation.Covariance;
            }
            case 12: {
                return SumVO.Operation.WeightedAverage;
            }
            case 13: {
                return SumVO.Operation.Median;
            }
            case 14: {
                return SumVO.Operation.Percentile;
            }
            case 15: {
                return SumVO.Operation.NthLargest;
            }
            case 16: {
                return SumVO.Operation.NthSmallest;
            }
            case 17: {
                return SumVO.Operation.Mode;
            }
            case 18: {
                return SumVO.Operation.NthMostFrequent;
            }
            case 19: {
                return SumVO.Operation.Percentage;
            }
        }
        return SumVO.Operation.NoSummaryOperation;
    }

    public static int mapSumOperation(SumVO.Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Parameter 'summaryOperation' is null");
        }
        if (operation == SumVO.Operation.Sum) {
            return 0;
        }
        if (operation == SumVO.Operation.Average) {
            return 1;
        }
        if (operation == SumVO.Operation.Variance) {
            return 2;
        }
        if (operation == SumVO.Operation.StdDeviation) {
            return 3;
        }
        if (operation == SumVO.Operation.Maximum) {
            return 4;
        }
        if (operation == SumVO.Operation.Minimum) {
            return 5;
        }
        if (operation == SumVO.Operation.Count) {
            return 6;
        }
        if (operation == SumVO.Operation.PopVariance) {
            return 7;
        }
        if (operation == SumVO.Operation.PopStdVariance) {
            return 8;
        }
        if (operation == SumVO.Operation.DistinctCount) {
            return 9;
        }
        if (operation == SumVO.Operation.Correlation) {
            return 10;
        }
        if (operation == SumVO.Operation.Covariance) {
            return 11;
        }
        if (operation == SumVO.Operation.WeightedAverage) {
            return 12;
        }
        if (operation == SumVO.Operation.Median) {
            return 13;
        }
        if (operation == SumVO.Operation.Percentile) {
            return 14;
        }
        if (operation == SumVO.Operation.NthLargest) {
            return 15;
        }
        if (operation == SumVO.Operation.NthSmallest) {
            return 16;
        }
        if (operation == SumVO.Operation.Mode) {
            return 17;
        }
        if (operation == SumVO.Operation.NthMostFrequent) {
            return 18;
        }
        if (operation == SumVO.Operation.Percentage) {
            return 19;
        }
        if (operation == SumVO.Operation.NoSummaryOperation) {
            return 20;
        }
        throw new IllegalArgumentException("Unknown summary operation: " + operation.name());
    }

    public static SortVO getSortVO(SortField sortField) {
        FieldVO fieldVO = PageHandlerUtilities.getFieldVO(sortField.getField());
        GroupVO.SortOrder sortOrder = PageHandlerUtilities.mapSortOrder(sortField.getSort());
        return new SortVO(fieldVO, sortOrder);
    }

    public static TableSourceVO getTableSourceVO(DatabaseEntry databaseEntry) {
        int n2 = 0;
        switch (databaseEntry.getEntryType()) {
            case 10: 
            case 11: {
                n2 = 1;
                break;
            }
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        TableSourceVO tableSourceVO = new TableSourceVO(n2, databaseEntry.getDatasourceName(), databaseEntry.getPath());
        return tableSourceVO;
    }

    public static Page getPage(PageType pageType, List<Page> list) {
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2).getPageType() != pageType) continue;
                return list.get(i2);
            }
        }
        return null;
    }

    public static int mapJoinType(int n2) {
        switch (n2) {
            case 3: {
                return 24;
            }
            case 1: {
                return 23;
            }
            case 2: {
                return 22;
            }
            case 0: {
                return 21;
            }
        }
        throw new IllegalArgumentException("Unknown join type: " + n2);
    }

    public static int mapJoinLinkType(int n2) {
        switch (n2) {
            case 0: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 4: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 5: {
                return 6;
            }
        }
        throw new IllegalArgumentException("Unknown join link type: " + n2);
    }

    public static int mapJoinTypeToAdHoc(int n2) {
        switch (n2) {
            case 24: {
                return 3;
            }
            case 23: {
                return 1;
            }
            case 22: {
                return 2;
            }
            case 21: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unknown join type: " + n2);
    }

    public static int mapJoinLinkTypeToAdHoc(int n2) {
        switch (n2) {
            case 1: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 5: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 6: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Unknown join link type: " + n2);
    }

    public static Group setGroupProperties(Engine engine, Group group, GroupVO groupVO) {
        int n2;
        block5: {
            if (group == null) {
                throw new IllegalArgumentException("Parameter 'group' is null");
            }
            if (groupVO == null) {
                throw new IllegalArgumentException("Parameter 'vo' is null");
            }
            try {
                Field field = PageHandlerUtilities.getField(engine, groupVO.getField());
                group.setField(field);
                group.setSectionWillBePrinted(PageHandlerUtilities.mapTimeInterval(groupVO.getGroupingByTimePeriod()));
                group.setCustomizeGroupNameField(0);
                group.setGroupDirectionFormula(null);
                group.setHierarchicalGrouping(false, null, 0);
                group.setSpecifiedOrder(null);
                group.setBySummaryOrder(null);
                group.setSort(PageHandlerUtilities.mapSortOrder(groupVO.getSortOrder()));
            }
            catch (ReportException reportException) {
                if (!BaseUtils.gk()) break block5;
                BaseUtils.warning(reportException);
            }
        }
        if (groupVO.getIntervalType().equals((Object)GroupVO.IntervalType.Periodic) && ((n2 = groupVO.getField().getValueType()) == 2 || n2 == 4 || n2 == 3)) {
            PageHandlerUtilities.a(engine, group);
        }
        return group;
    }

    private static void a(Engine engine, Group group) {
        Field field = PageHandlerUtilities.a(engine, group.getSectionWillBePrinted(), group.getField());
        if (field != null) {
            FormulaField formulaField = PageHandlerUtilities.b(engine, group.getSectionWillBePrinted(), group.getField());
            group.setField(field);
            if (formulaField != null) {
                group.setCustomizeGroupNameField(2);
                group.setGroupNameFormula(formulaField);
            }
        }
    }

    static Field a(Engine engine, int n2, Field field) {
        String string = null;
        switch (n2) {
            case 11: {
                string = "IIF(hour({0})<12, 0, 12)";
                break;
            }
            case 0: {
                string = "Weekday({0})";
                break;
            }
            case 3: {
                string = "iif(Day({0}) < 16, 1, 16)";
                break;
            }
            case 6: {
                string = "iif(Month({0}) < 7, 1, 7)";
                break;
            }
            case 10: {
                string = "Hour({0})";
                break;
            }
            case 9: {
                string = "Minute({0})";
                break;
            }
            case 4: {
                string = "Month({0})";
                break;
            }
            case 5: {
                string = " if ( month( {0} ) in 1 to 3 ) Then 1 else if ( month( {0} ) in 4 to 6 ) Then 4 else if ( month( {0} ) in 7 to 9 ) Then 7 else 10";
                break;
            }
            case 8: {
                string = "Second({0})";
                break;
            }
            case 2: {
                string = "local numbervar weekofyear := datepart(\"ww\",  {0} ); iif(weekofyear mod 2 = 1, weekofyear-0, weekofyear-1)";
                break;
            }
            case 1: {
                string = "datepart(\"ww\", {0})";
                break;
            }
        }
        if (string != null) {
            return PageHandlerUtilities.a(engine, field, string, false);
        }
        return null;
    }

    static FormulaField b(Engine engine, int n2, Field field) {
        String string = null;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 0: {
                string = "WeekdayName(Weekday({0}))";
                break;
            }
            case 4: {
                string = "MonthName(Month({0}))";
                break;
            }
        }
        if (string != null) {
            return PageHandlerUtilities.a(engine, field, string, true);
        }
        return null;
    }

    private static FormulaField a(Engine engine, Field field, String string, boolean bl2) {
        try {
            String string2 = "{" + field.getRefName() + "}";
            String string3 = MessageFormat.format(string, string2);
            int n2 = 0;
            String string4 = "";
            if (bl2) {
                n2 = 3;
            } else {
                String string5 = null;
                string5 = field instanceof DatabaseField ? ((DatabaseField)field).getColumnLabel() : field.getName();
                string4 = string5 + " (" + Msg.getMsg(engine.getLocale(), "IntervalType.Periodic").toLowerCase() + ')';
                string4 = PageHandlerUtilities.b(engine, string4);
            }
            return engine.getFields().addFormulaField(string4, string3, n2);
        }
        catch (ReportException reportException) {
            if (BaseUtils.gk()) {
                BaseUtils.warning(reportException);
            }
            return null;
        }
    }

    private static String b(Engine engine, String string) throws ReportException {
        if (engine.getFields().getFormulaField(string) == null) {
            return string;
        }
        int n2 = 1;
        while (engine.getFields().getFormulaField(string + " " + n2) != null) {
            ++n2;
        }
        return string + " " + n2;
    }

    public static SummaryField setSumProperties(Engine engine, SummaryField summaryField, SumVO sumVO) {
        if (sumVO.getSecondField() != null) {
            summaryField.setField2nd(PageHandlerUtilities.getField(engine, sumVO.getSecondField()));
        }
        summaryField.setName(sumVO.getName());
        summaryField.setRunningTotal(false);
        summaryField.setSummaryNth(sumVO.getNth());
        summaryField.setSummaryOperation(PageHandlerUtilities.mapSumOperation(sumVO.getOperation()));
        summaryField.setSummaryFieldType(0);
        summaryField.setShowPercentVal(false);
        return summaryField;
    }

    static ChartVO.ChartType a(ChartStyle chartStyle) {
        if (chartStyle == null) {
            throw new IllegalArgumentException("Parameter 'style' is null.");
        }
        for (d d2 : d.values()) {
            if (!d2.getStyle().equals(chartStyle)) continue;
            return d2.H();
        }
        return null;
    }

    static ChartStyle a(ChartVO.ChartType chartType) {
        if (chartType == null) {
            throw new IllegalArgumentException("Parameter 'type' is null.");
        }
        for (d d2 : d.values()) {
            if (!d2.H().equals((Object)chartType)) continue;
            return d2.getStyle();
        }
        return BarStyle.BAR2D;
    }

    static ChartVO.DatasetState d(Chart2 chart2) {
        if (chart2 == null) {
            throw new IllegalArgumentException("Parameter 'chart' is null.");
        }
        ChartPlot chartPlot = chart2.getPlot();
        if (chartPlot instanceof StandardPlot) {
            StandardDataset standardDataset = (StandardDataset)chartPlot.getDataset();
            if (standardDataset instanceof TwoGroupsDataset && !(chartPlot instanceof PiePlot)) {
                return ChartVO.DatasetState.State_For_Two_Groups;
            }
            if (standardDataset instanceof OneGroupDataset) {
                return ChartVO.DatasetState.State_For_One_Group;
            }
            if (standardDataset instanceof ForEachRecordDataset) {
                return ChartVO.DatasetState.State_For_Each_Record;
            }
            if (standardDataset instanceof ForAllRecordsDataset) {
                return ChartVO.DatasetState.State_For_All_Records;
            }
        }
        return ChartVO.DEFAULT_DATASET_STATE;
    }

    public static Field getField(Engine engine, FieldVO fieldVO) {
        Fields fields = null;
        try {
            fields = engine.getFields();
        }
        catch (ReportException reportException) {
            if (BaseUtils.gk()) {
                BaseUtils.warning(reportException);
            }
            return null;
        }
        Field field = null;
        if (fieldVO.isDatabaseField()) {
            field = fields.getDatabaseField(fieldVO.getCCName());
        } else if (fieldVO.isFormulaField()) {
            field = fields.getFormulaField(fieldVO.getName());
        } else if (fieldVO.isSQLField()) {
            field = fields.getSQLExpressionField(fieldVO.getName());
        } else {
            field = fields.getSummaryField(fieldVO.getName());
            if (field == null) {
                field = fields.getPromptField(fieldVO.getName());
            }
            if (field == null) {
                field = fields.getGroupNameField(fieldVO.getName());
            }
        }
        return field;
    }

    public static boolean isLayoutField(Field field) {
        if (field == null) {
            return false;
        }
        if (field.getType() == 14) {
            Datasource datasource = ((DatabaseField)field).getTableSource().getDatasource();
            return DatasourcePageHandler.isLayoutDatasource(datasource);
        }
        if (field.getType() == 11) {
            SummaryField summaryField = (SummaryField)field;
            if (PageHandlerUtilities.isLayoutField(summaryField.getField())) {
                return true;
            }
            return summaryField.getField2nd() != null && PageHandlerUtilities.isLayoutField(summaryField.getField2nd());
        }
        return false;
    }

    public static String getAlias(DatabaseField databaseField) {
        String string = databaseField.getColumnLabel();
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        return string;
    }

    public static JoinVO getJoinVO(Join join, int n2, JoinVO joinVO) {
        FieldVO fieldVO = PageHandlerUtilities.getFieldVO(join.getConditionSourceFields()[n2]);
        FieldVO fieldVO2 = PageHandlerUtilities.getFieldVO(join.getConditionTargetFields()[n2]);
        int n3 = PageHandlerUtilities.mapJoinTypeToAdHoc(join.getJoinType());
        int n4 = PageHandlerUtilities.mapJoinLinkTypeToAdHoc(join.getConditionLinkType(n2));
        if (joinVO == null) {
            return new JoinVO(fieldVO, fieldVO2, n3, n4);
        }
        joinVO.add(fieldVO, fieldVO2, n4);
        return joinVO;
    }
}

