/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.server.visualdb;

import com.inet.adhoc.base.AHBaseUtils;
import com.inet.adhoc.base.model.AHCommand;
import com.inet.adhoc.base.model.DatabaseVO;
import com.inet.adhoc.base.model.DatasourceVO;
import com.inet.adhoc.base.model.FieldVO;
import com.inet.adhoc.base.model.JoinListVO;
import com.inet.adhoc.base.model.Parameter;
import com.inet.adhoc.base.model.PasswordData;
import com.inet.adhoc.base.model.RefreshResultVO;
import com.inet.adhoc.base.model.StringVO;
import com.inet.adhoc.base.model.TableSourceVO;
import com.inet.adhoc.base.model.VO;
import com.inet.adhoc.base.model.VOList;
import com.inet.adhoc.base.page.Page;
import com.inet.adhoc.base.page.PageType;
import com.inet.adhoc.base.xml.XMLSerializable;
import com.inet.adhoc.base.xml.XMLSerializableBoolean;
import com.inet.adhoc.base.xml.XMLSerializableByteArray;
import com.inet.adhoc.base.xml.XMLSerializableInteger;
import com.inet.adhoc.base.xml.XMLSerializableString;
import com.inet.adhoc.io.IRequest;
import com.inet.adhoc.io.IRequestHandler;
import com.inet.adhoc.io.IResponse;
import com.inet.adhoc.io.Request;
import com.inet.adhoc.io.RequiresPasswordException;
import com.inet.adhoc.io.ResponseException;
import com.inet.adhoc.server.database.NeedParametersException;
import com.inet.adhoc.server.visualdb.IVLCommand;
import com.inet.adhoc.server.visualdb.VLReportException;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLField;
import com.inet.report.encode.c;
import com.inet.report.i18n.ErrorCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public class VLCommandClient
implements IVLCommand {
    public static final String PREFIX_ERRORCODE = "CODE:";
    public static final String KEY_VL_COMMAND = "VL_CMD";
    public static final String KEY_SUBREPORT_INDEX = "VL_SID";
    public static final String PARAM_NAME = "P_NAME";
    public static final String PARAM_PASSWORD = "P_PWD";
    public static final String PARAM_IGNORE_SYSTEM_TABLES = "P_IST";
    public static final String PARAM_ALIAS = "P_ALIAS";
    public static final String PARAM_STATMENT = "P_STM";
    public static final String PARAM_REPLACE_IN_SUBREPORTS = "P_RIS";
    public static final String PARAM_IDENTIFIER = "P_ID";
    public static final String KEY_PARAM_REQUIRED = "KEY_PR";
    public static final String META_CONNECTORURLSTRING = "ConnectorURLString";
    private Engine dC;
    private final IRequestHandler dD;
    private Engine dE;
    private final PasswordData cC;
    private final int dF;
    private Map<Integer, Map<String, c>> dG;
    private boolean dH = false;
    private boolean dI = false;
    private Properties props;
    private Object dJ;

    public VLCommandClient(IRequestHandler iRequestHandler, Engine engine, PasswordData passwordData, int n2) {
        this.dD = iRequestHandler;
        this.dC = engine;
        this.dE = engine;
        this.cC = passwordData;
        this.dF = n2;
        try {
            this.props = engine != null ? engine.getUserProperties() : null;
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        this.dJ = engine != null ? engine.getMetaProperties().get(META_CONNECTORURLSTRING) : null;
    }

    private Page a(VO vO, VO vO2) {
        return new Page(PageType.RemoteVL, vO2, vO);
    }

    private IRequest a(a a2, Page page, HashMap<String, XMLSerializable> hashMap) throws IOException, ReportException {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        hashMap.put(KEY_VL_COMMAND, new XMLSerializableString(a2.name()));
        if (!this.dH && a2.N()) {
            XMLSerializableByteArray xMLSerializableByteArray = new XMLSerializableByteArray(this.M());
            hashMap.put("KEY_ENGINE_DATA", xMLSerializableByteArray);
            this.dH = true;
        }
        return new Request(AHCommand.VLRequest, page, hashMap);
    }

    private byte[] M() throws ReportException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.dG == null) {
            this.dG = com.inet.report.a.o(this.dC);
        }
        RDC.saveEngine(byteArrayOutputStream, this.dC.isSubEngine() ? this.dC.getParent() : this.dC);
        com.inet.report.a.a(this.dC, this.dG);
        return byteArrayOutputStream.toByteArray();
    }

    private void a(IResponse iResponse) throws IOException, ReportException {
        XMLSerializable xMLSerializable;
        if (iResponse.getProperties() != null && (xMLSerializable = iResponse.getProperties().get("KEY_ENGINE_DATA")) instanceof XMLSerializableByteArray) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((XMLSerializableByteArray)xMLSerializable).getValue());
            Engine engine = RDC.loadEngine(this.dE.getReportFile(), byteArrayInputStream, "java", null);
            if (engine != null) {
                this.dC = engine;
                if (this.dF > 0) {
                    for (int i2 = 0; i2 < this.dC.getSubReportCount(); ++i2) {
                        Engine engine2 = this.dC.getSubReport(i2);
                        if (this.dF != engine2.getReportID()) continue;
                        this.dC = engine2;
                        break;
                    }
                }
            }
        }
    }

    private VO b(a a2, Page page, HashMap<String, XMLSerializable> hashMap) throws ReportException, NeedParametersException {
        try {
            if (this.dF >= 0) {
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                hashMap.put(KEY_SUBREPORT_INDEX, new XMLSerializableInteger(this.dF));
            }
            IResponse iResponse = this.dD.handleRequest(this.a(a2, page, hashMap), false);
            this.a(iResponse);
            if (a2.O()) {
                this.dI = true;
            }
            return iResponse.getCurrentPage().getUserChoices();
        }
        catch (ResponseException responseException) {
            Object object;
            if (responseException.getMessage() != null && responseException.getMessage().startsWith(PREFIX_ERRORCODE)) {
                object = responseException.getMessage().substring(PREFIX_ERRORCODE.length());
                try {
                    throw ReportExceptionFactory.createReportException(ErrorCode.valueOf((String)object), new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (responseException.getProperty("ERR_CODE") instanceof XMLSerializableInteger) {
                throw new VLReportException(responseException);
            }
            if (responseException.getProperty("KEY_PASSWORD_REQUIRED") instanceof XMLSerializableString) {
                throw new RequiresPasswordException(((XMLSerializableString)responseException.getProperty("KEY_PASSWORD_REQUIRED")).getValue());
            }
            if (responseException.getProperty(KEY_PARAM_REQUIRED) instanceof XMLSerializableString && responseException.getResponse().getCurrentPage() != null && responseException.getResponse().getCurrentPage().getUserChoices() instanceof VOList) {
                object = (VOList)responseException.getResponse().getCurrentPage().getUserChoices();
                throw new NeedParametersException(((VOList)object).getVOList());
            }
            throw ReportExceptionFactory.createReportExceptionWithCause(responseException);
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }

    private HashMap<String, XMLSerializable> a(String string, String string2, HashMap<String, XMLSerializable> hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        hashMap.put(string, new XMLSerializableString(string2));
        return hashMap;
    }

    private HashMap<String, XMLSerializable> a(String string, boolean bl2, HashMap<String, XMLSerializable> hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        hashMap.put(string, new XMLSerializableBoolean(bl2));
        return hashMap;
    }

    @Override
    public TableSourceVO addDBItem(TableSourceVO tableSourceVO, List<TableSourceVO> list) throws ReportException {
        Page page = this.a(new VOList<TableSourceVO>(list), tableSourceVO);
        return (TableSourceVO)this.b(a.dK, page, null);
    }

    @Override
    public DatabaseVO addDatasource(String string, boolean bl2) throws ReportException {
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_NAME, string, null);
        this.a(PARAM_IGNORE_SYSTEM_TABLES, bl2, hashMap);
        return (DatabaseVO)this.b(a.dL, null, hashMap);
    }

    @Override
    public void applyJoins(JoinListVO joinListVO) throws ReportException {
        this.b(a.dM, this.a(null, joinListVO), null);
    }

    @Override
    public void cancel() {
        block2: {
            this.dC = this.dE;
            try {
                com.inet.report.a.a(this.dC, this.dG);
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isDebug()) break block2;
                BaseUtils.debug(reportException);
            }
        }
    }

    @Override
    public void checkPassword(String string) throws RequiresPasswordException, ReportException {
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_PASSWORD, string, null);
        this.b(a.dN, null, hashMap);
    }

    @Override
    public TableSourceVO convertToCommand(TableSourceVO tableSourceVO) throws ReportException {
        return (TableSourceVO)this.b(a.dP, this.a(tableSourceVO, null), null);
    }

    @Override
    public List<DatasourceVO> getAllDatasourceVOs() throws ReportException {
        VOList vOList = (VOList)this.b(a.dQ, null, null);
        return vOList != null ? vOList.getVOList() : null;
    }

    @Override
    public Engine getEngine(boolean bl2) {
        block13: {
            block12: {
                block11: {
                    if (!bl2 && !this.dI && this.dC != null) {
                        return this.dC;
                    }
                    try {
                        this.b(a.dR, null, null);
                        com.inet.report.a.a(this.dC, this.dG);
                    }
                    catch (ReportException reportException) {
                        if (!BaseUtils.isError()) break block11;
                        BaseUtils.error(reportException);
                    }
                }
                if (bl2) {
                    try {
                        this.b(a.dS, null, null);
                    }
                    catch (ReportException reportException) {
                        if (!BaseUtils.isError()) break block12;
                        BaseUtils.error(reportException);
                    }
                }
            }
            if (this.props != null && this.dC != null) {
                Properties properties = new Properties();
                try {
                    if (this.dC.getUserProperties() != null) {
                        properties.putAll((Map<?, ?>)this.dC.getUserProperties());
                    }
                    properties.putAll((Map<?, ?>)this.props);
                    this.dC.setUserProperties(properties);
                }
                catch (ReportException reportException) {
                    if (!BaseUtils.isDebug()) break block13;
                    BaseUtils.debug(reportException);
                }
            }
        }
        if (this.dJ != null) {
            this.dC.getMetaProperties().put(META_CONNECTORURLSTRING, this.dJ);
        }
        this.dI = false;
        return this.dC;
    }

    @Override
    public Engine getLocalEngine() {
        block3: {
            try {
                if (this.dF <= 0 || this.dC.isSubEngine()) break block3;
                for (int i2 = 0; i2 < this.dC.getSubReportCount(); ++i2) {
                    Engine engine = this.dC.getSubReport(i2);
                    if (this.dF != engine.getReportID()) continue;
                    this.dC = engine;
                    break;
                }
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isError()) break block3;
                BaseUtils.error(reportException);
            }
        }
        return this.dC;
    }

    @Override
    public String getSQL(String string) throws ReportException {
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_NAME, string, null);
        StringVO stringVO = (StringVO)this.b(a.dT, null, hashMap);
        if (stringVO != null) {
            return stringVO.getValue();
        }
        return null;
    }

    @Override
    public JoinListVO getTablesAndJoins() throws ReportException {
        return (JoinListVO)this.b(a.dU, null, null);
    }

    @Override
    public DatabaseVO refreshDatasource(String string, boolean bl2) throws ReportException {
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_NAME, string, null);
        this.a(PARAM_IGNORE_SYSTEM_TABLES, bl2, hashMap);
        return (DatabaseVO)this.b(a.dV, null, hashMap);
    }

    @Override
    public void removeDBItem(TableSourceVO tableSourceVO) throws ReportException {
        this.b(a.dX, this.a(null, tableSourceVO), null);
    }

    @Override
    public void removeDatasource(String string) throws ReportException {
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_NAME, string, null);
        this.b(a.dY, null, hashMap);
    }

    @Override
    public RefreshResultVO changeCommand(TableSourceVO tableSourceVO, TableSourceVO tableSourceVO2) throws ReportException {
        return (RefreshResultVO)this.b(a.dZ, this.a(tableSourceVO, tableSourceVO2), null);
    }

    @Override
    public DatabaseVO replaceDatasource(DatasourceVO datasourceVO, DatasourceVO datasourceVO2, boolean bl2, boolean bl3) throws ReportException {
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_REPLACE_IN_SUBREPORTS, bl2, null);
        this.a(PARAM_IGNORE_SYSTEM_TABLES, bl3, hashMap);
        return (DatabaseVO)this.b(a.ea, this.a(datasourceVO, datasourceVO2), hashMap);
    }

    @Override
    public RefreshResultVO changeTablesource(TableSourceVO tableSourceVO, String string, String string2, String string3, List<Parameter> list) throws ReportException {
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_NAME, string, null);
        this.a(PARAM_ALIAS, string2, hashMap);
        this.a(PARAM_IDENTIFIER, string3, hashMap);
        VOList<Parameter> vOList = null;
        if (list != null) {
            vOList = new VOList<Parameter>(list);
        }
        return (RefreshResultVO)this.b(a.dO, this.a(tableSourceVO, vOList), hashMap);
    }

    @Override
    public String[] showSQL() throws ReportException {
        VOList vOList;
        VO vO = this.b(a.ec, null, null);
        if (vO instanceof VOList && (vOList = (VOList)vO).getSize() > 0) {
            String[] stringArray = new String[vOList.getSize()];
            for (int i2 = 0; i2 < vOList.getSize(); ++i2) {
                stringArray[i2] = ((StringVO)vOList.getVOList().get(i2)).getValue();
            }
            return stringArray;
        }
        return null;
    }

    @Override
    public void setPassword(String string, String string2) throws ReportException, RequiresPasswordException {
        String string3 = VLCommandClient.encrypt(string2);
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_PASSWORD, string3, null);
        this.a(PARAM_NAME, string, hashMap);
        this.b(a.eb, null, hashMap);
        this.cC.setPassword(string3, string);
    }

    public static String encrypt(String string) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKeySpec secretKeySpec = new SecretKeySpec("KEY_DATA_SOURCE_".getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeySpec);
            return "E" + AHBaseUtils.encodeArrayToString(cipher.doFinal(string.getBytes()));
        }
        catch (Exception exception) {
            return "N" + string;
        }
    }

    public static String decrypt(String string) {
        if (string.startsWith("N")) {
            return string.substring(1);
        }
        try {
            byte[] byArray = AHBaseUtils.decodeStringToArray(string.substring(1));
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKeySpec secretKeySpec = new SecretKeySpec("KEY_DATA_SOURCE_".getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            return new String(cipher.doFinal(byArray));
        }
        catch (Exception exception) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(exception);
            }
            return null;
        }
    }

    @Override
    public void clean() {
        block4: {
            try {
                this.b(a.ek, null, null);
            }
            catch (NeedParametersException needParametersException) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug(needParametersException);
                }
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isDebug()) break block4;
                BaseUtils.debug(reportException);
            }
        }
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public SQLField addSQLField(String string, String string2) throws ReportException {
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_NAME, string, null);
        this.a(PARAM_STATMENT, string2, hashMap);
        this.b(a.ed, null, hashMap);
        Engine engine = this.getEngine(true);
        return engine.getFields().getSQLExpressionField(string);
    }

    @Override
    public SQLField setSQLExpression(SQLField sQLField, String string) throws ReportException {
        String string2 = sQLField.getName();
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_NAME, string2, null);
        this.a(PARAM_STATMENT, string, hashMap);
        this.b(a.ee, null, hashMap);
        Engine engine = this.getEngine(true);
        return engine.getFields().getSQLExpressionField(string2);
    }

    @Override
    public DatabaseVO isDatasourceEnabled(String string, boolean bl2) throws ReportException {
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_NAME, string, null);
        this.a(PARAM_IGNORE_SYSTEM_TABLES, bl2, hashMap);
        return (DatabaseVO)this.b(a.dW, null, hashMap);
    }

    @Override
    public SQLField duplicateSQLField(SQLField sQLField, String string) throws ReportException {
        String string2 = sQLField.getName();
        HashMap<String, XMLSerializable> hashMap = this.a(PARAM_NAME, string, null);
        this.a(PARAM_IDENTIFIER, string2, hashMap);
        this.b(a.ef, null, hashMap);
        Engine engine = this.getEngine(true);
        return engine.getFields().getSQLExpressionField(string);
    }

    @Override
    public TableSourceVO getFields(TableSourceVO tableSourceVO) throws ReportException, NeedParametersException {
        return (TableSourceVO)this.b(a.ei, this.a(tableSourceVO, null), null);
    }

    @Override
    public RefreshResultVO refreshTableSource(TableSourceVO tableSourceVO) throws ReportException {
        return (RefreshResultVO)this.b(a.eg, this.a(tableSourceVO, null), null);
    }

    @Override
    public void replaceColumns(List<FieldVO[]> list) throws ReportException {
        ArrayList arrayList = new ArrayList();
        for (FieldVO[] fieldVOArray : list) {
            VOList vOList = new VOList(new ArrayList());
            for (FieldVO fieldVO : fieldVOArray) {
                vOList.getVOList().add(fieldVO);
            }
            arrayList.add(vOList);
        }
        VOList vOList = new VOList(arrayList);
        this.b(a.eh, this.a(vOList, null), null);
    }

    @Override
    public String getDestinationName() {
        return this.dD.getName();
    }

    @Override
    public List<String> checkDatasources(List<IVLCommand.DatasourceDescription> list) throws ReportException {
        List list2;
        VOList vOList = new VOList(new ArrayList());
        VOList vOList2 = new VOList(new ArrayList());
        for (IVLCommand.DatasourceDescription object2 : list) {
            vOList.getVOList().add(new StringVO(object2.getName()));
            vOList2.getVOList().add(new StringVO(Boolean.toString(object2.hasConfig())));
        }
        VO vO = this.b(a.ej, this.a(vOList, vOList2), null);
        if (vO instanceof VOList && (list2 = ((VOList)vO).getVOList()) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (StringVO stringVO : list2) {
                arrayList.add(stringVO.getValue());
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public String getFormulaExpanderClasses() throws ReportException {
        VO vO = this.b(a.el, null, null);
        if (vO instanceof StringVO) {
            return ((StringVO)vO).getValue();
        }
        return null;
    }

    public static enum a {
        dK(true, true),
        dL(true, true),
        dM(true, true),
        dN(false, false, false),
        dO(true, true),
        dP(true, true),
        dQ(false, false),
        dR(true, false),
        dS(false, false),
        dT(true, false),
        dU(true, false),
        dV(false, false),
        dW(true, false),
        dX(true, true),
        dY(true, true),
        dZ(true, true),
        ea(true, true),
        eb(false, false, false),
        ec(true, false),
        ed(true, true),
        ee(true, true),
        ef(true, true),
        eg(false, false),
        eh(true, true),
        ei(true, true),
        ej(false, false, false),
        ek(false, false),
        el(false, false, false);

        private final boolean em;
        private final boolean en;
        private final boolean eo;

        private a(boolean bl2, boolean bl3) {
            this(bl2, bl3, true);
        }

        private a(boolean bl2, boolean bl3, boolean bl4) {
            this.em = bl2;
            this.en = bl3;
            this.eo = bl4;
        }

        public boolean N() {
            return this.em;
        }

        public boolean O() {
            return this.en;
        }

        public boolean P() {
            return this.eo;
        }
    }
}

