/*
 * Decompiled with CFR 0.152.
 */
package com.inet.adhoc.server.visualdb;

import com.inet.adhoc.base.i18n.ErrorCodes;
import com.inet.adhoc.base.i18n.Msg;
import com.inet.adhoc.base.model.DatabaseEntryPath;
import com.inet.adhoc.base.model.DatabaseVO;
import com.inet.adhoc.base.model.DatasourceVO;
import com.inet.adhoc.base.model.FieldVO;
import com.inet.adhoc.base.model.JoinListVO;
import com.inet.adhoc.base.model.JoinVO;
import com.inet.adhoc.base.model.Link;
import com.inet.adhoc.base.model.Parameter;
import com.inet.adhoc.base.model.PasswordData;
import com.inet.adhoc.base.model.RefreshResultVO;
import com.inet.adhoc.base.model.TableSourceVO;
import com.inet.adhoc.base.model.VOList;
import com.inet.adhoc.io.RequiresPasswordException;
import com.inet.adhoc.server.database.DatabaseEntry;
import com.inet.adhoc.server.database.DatabaseFactory;
import com.inet.adhoc.server.database.NeedParametersException;
import com.inet.adhoc.server.database.b;
import com.inet.adhoc.server.handler.DatasourcePageHandler;
import com.inet.adhoc.server.handler.PageHandlerUtilities;
import com.inet.adhoc.server.visualdb.IVLCommand;
import com.inet.lib.list.StringList;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseSqlServer;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Join;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLField;
import com.inet.report.TableSource;
import com.inet.report.a;
import com.inet.report.ba;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.dw;
import com.inet.report.i18n.ErrorCode;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class VLCommandImpl
implements IVLCommand {
    private Engine dC;
    private final DatabaseFactory er;
    private final PasswordData es;
    private List<String> et;

    public VLCommandImpl(Engine engine, PasswordData passwordData) {
        if (passwordData == null) {
            throw new IllegalArgumentException("Parameter 'passwordHolder' is null.");
        }
        this.er = new DatabaseFactory();
        this.dC = engine;
        this.es = passwordData;
        if (engine != null) {
            this.et = this.k(engine);
        }
    }

    protected List<String> k(Engine engine) {
        return this.a(engine, 4, false);
    }

    protected List<String> a(Engine engine, int n2, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            int n3;
            for (n3 = 0; n3 < engine.getDatabaseTables().getDatasourceCount(); ++n3) {
                String string;
                Datasource datasource = engine.getDatabaseTables().getDatasource(n3);
                DataSourceConfiguration dataSourceConfiguration = datasource.getDataSourceConfiguration();
                if (dataSourceConfiguration == null || DataSourceConfigurationManager.exists(string = dataSourceConfiguration.getConfigurationName())) continue;
                if (bl2 && !dw.j(ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE.getKey(), Boolean.parseBoolean(ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE.getDefault()))) {
                    throw ReportExceptionFactory.createReportException(ErrorCode.AccessDeniedUnknownDatasource, string);
                }
                dataSourceConfiguration.save(n2);
                arrayList.add(string);
            }
            for (n3 = 0; n3 < engine.getSubReportCount(); ++n3) {
                arrayList.addAll(this.k(engine.getSubReport(n3)));
            }
        }
        catch (Exception exception) {
            BaseUtils.error(exception);
        }
        return arrayList;
    }

    @Override
    public void clean() {
        this.j(4);
    }

    protected void j(int n2) {
        if (this.et == null) {
            return;
        }
        for (String string : this.et) {
            DataSourceConfigurationManager.removeDatasourceConfiguration(string, n2);
        }
    }

    @Override
    public Engine getEngine(boolean bl2) {
        return this.dC;
    }

    @Override
    public Engine getLocalEngine() {
        return this.dC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableSourceVO addDBItem(TableSourceVO tableSourceVO, List<TableSourceVO> list) throws ReportException, NeedParametersException {
        TableSource tableSource;
        this.Q();
        this.checkDatasourceConfiguration(tableSourceVO.getDatasource());
        TableSourceVO tableSourceVO2 = null;
        if (tableSourceVO.isCommand()) {
            Datasource datasource = this.dC.getDatabaseTables().getDatasource(tableSourceVO.getDatasource());
            Connection connection = datasource.getConnection();
            try {
                TableSource tableSource2 = datasource.createTableSourceCommand(tableSourceVO.getAlias(), tableSourceVO.getSqlStatement(), tableSourceVO.getQuoteStringPrompts());
                tableSourceVO2 = new TableSourceVO(tableSourceVO.getDatasource(), tableSourceVO.getAlias(), tableSourceVO.getSqlStatement(), tableSourceVO.getQuoteStringPrompts());
                tableSourceVO2.setFieldList(PageHandlerUtilities.getAllFieldsOfTablesource(tableSource2));
                tableSourceVO2.setParameters(tableSourceVO.getParameters());
            }
            finally {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        tableSourceVO2 = this.er.fillTableSourceVO(tableSourceVO, list, this.es, this.dC.getReportFile());
        Datasource datasource = this.dC.getDatabaseTables().getDatasource(tableSourceVO2.getDatasource());
        if (tableSourceVO2.isArtificialAlias()) {
            tableSource = datasource.createTableSource(tableSourceVO2.getDatabaseIdentifier());
            if (!tableSourceVO2.getAlias().equals(tableSource.getAlias())) {
                tableSourceVO2.setAlias(tableSource.getAlias());
            }
        } else {
            tableSource = datasource.createTableSource(tableSourceVO2.getDatabaseIdentifier(), tableSourceVO2.getAlias());
        }
        for (FieldVO fieldVO : tableSourceVO2.getFieldList()) {
            tableSource.addColumn(fieldVO.getName(), PageHandlerUtilities.mapFieldTypeToCC(fieldVO.getValueType()), fieldVO.getAlias());
        }
        this.er.setParameterValue(tableSourceVO2, tableSource);
        return tableSourceVO2;
    }

    @Override
    public DatabaseVO addDatasource(String string, boolean bl2) throws ReportException {
        Object object;
        this.Q();
        this.checkDatasourceConfiguration(string);
        Datasource datasource = this.dC.getDatabaseTables().getDatasource(string);
        if (datasource == null) {
            boolean bl3;
            datasource = this.dC.getDatabaseTables().createDatasource(string);
            object = datasource.getDataSourceConfiguration();
            boolean bl4 = bl3 = ((DataSourceConfiguration)object).isNeedPassword() && "".equals(((DataSourceConfiguration)object).getPassword());
            if (bl3) {
                datasource.setPassword(this.es.getPassword(string));
            }
        }
        try {
            object = this.er.getDriverName(this.f(string));
            return this.er.createDatabaseVO(new DatasourceVO(string, (String)object), this.es.getPassword(string), bl2, false, this.dC.getReportFile());
        }
        catch (ReportException reportException) {
            this.dC.getDatabaseTables().removeDatasource(datasource);
            throw reportException;
        }
    }

    @Override
    public void applyJoins(JoinListVO joinListVO) throws ReportException {
        this.Q();
        DatabaseTables databaseTables = this.dC.getDatabaseTables();
        Vector vector = databaseTables.getJoinsEntries();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Join serializable = (Join)vector.get(i2);
            int n2 = serializable.getConditionCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                databaseTables.removeJoin(serializable.getSourceTableSource(), serializable.getConditionSourceFields()[0], serializable.getTargetTableSource(), serializable.getConditionTargetFields()[0]);
            }
        }
        if (joinListVO != null) {
            for (JoinVO joinVO : joinListVO.getJoinList()) {
                for (Link link : joinVO.getLinks()) {
                    FieldVO fieldVO = link.getFirstField();
                    FieldVO fieldVO2 = link.getSecondField();
                    this.dC.getDatabaseTables().addJoin(fieldVO.getTableSourceName(), fieldVO.getName(), fieldVO2.getTableSourceName(), fieldVO2.getName(), PageHandlerUtilities.mapJoinType(joinVO.getJoinType()), PageHandlerUtilities.mapJoinLinkType(link.getJoinOp()));
                }
            }
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public TableSourceVO convertToCommand(TableSourceVO tableSourceVO) throws ReportException {
        this.Q();
        String string = tableSourceVO.getDatasource();
        String string2 = tableSourceVO.getAlias();
        String string3 = tableSourceVO.getSqlStatement();
        boolean bl2 = tableSourceVO.getQuoteStringPrompts();
        DatabaseTables databaseTables = this.dC.getDatabaseTables();
        Datasource datasource = databaseTables.getDatasource(string);
        TableSource tableSource = datasource.createTableSource(string2, string2);
        Connection connection = datasource.getConnection();
        try {
            tableSource.setSql(string3);
            tableSource.setQuoteStringPrompts(bl2);
            tableSource.refresh();
            this.dC.setSF(null);
            this.dC.setGF(null);
            this.dC.getFields().changeAllAliases(string2, datasource);
            int n2 = datasource.getTableSourceCount();
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                String[] stringArray = datasource.getAliasList();
                databaseTables.removeSqlSource(stringArray[0]);
            }
        }
        catch (SQLException sQLException) {
            datasource.removeTableSource(tableSource);
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
        catch (ReportException reportException) {
            datasource.removeTableSource(tableSource);
            throw reportException;
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
        TableSourceVO tableSourceVO2 = new TableSourceVO(string, string2, string3, bl2);
        tableSourceVO2.setFieldList(PageHandlerUtilities.getAllFieldsOfTablesource(tableSource));
        return tableSourceVO2;
    }

    @Override
    public String getSQL(String string) throws ReportException {
        this.checkDatasourceConfiguration(string);
        Connection connection = null;
        try {
            Datasource datasource = this.dC.getDatabaseTables().getDatasource(string);
            String string2 = this.es.getPassword(datasource.getDataSourceConfigurationName());
            if (string2 != null) {
                datasource.setPassword(string2);
            }
            connection = datasource.getConnection();
            String string3 = datasource.getSql(true);
            return string3;
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public DatabaseVO refreshDatasource(String string, boolean bl2) throws ReportException {
        this.checkDatasourceConfiguration(string);
        b.removeDatasource(string);
        String string2 = this.er.getDriverName(this.f(string));
        DatabaseVO databaseVO = this.er.createDatabaseVO(new DatasourceVO(string, string2), this.es.getPassword(string), bl2, false, this.dC.getReportFile());
        return databaseVO;
    }

    @Override
    public void removeDBItem(TableSourceVO tableSourceVO) throws ReportException {
        this.Q();
        Datasource datasource = this.dC.getDatabaseTables().getDatasource(tableSourceVO.getDatasource());
        TableSource tableSource = datasource.getTableSource(tableSourceVO.getAlias());
        datasource.removeTableSource(tableSource);
    }

    @Override
    public void removeDatasource(String string) throws ReportException {
        this.Q();
        Datasource datasource = this.dC.getDatabaseTables().getDatasource(string);
        this.dC.getDatabaseTables().removeDatasource(datasource);
    }

    @Override
    public RefreshResultVO changeCommand(TableSourceVO tableSourceVO, TableSourceVO tableSourceVO2) throws ReportException {
        Datasource datasource;
        this.Q();
        String string = tableSourceVO2.getDatasource();
        String string2 = tableSourceVO2.getAlias();
        String string3 = tableSourceVO2.getSqlStatement();
        boolean bl2 = tableSourceVO2.getQuoteStringPrompts();
        this.checkDatasourceConfiguration(string);
        if (!tableSourceVO.isCommand()) {
            throw new IllegalArgumentException("This function supports commands only");
        }
        Datasource datasource2 = this.dC.getDatabaseTables().getDatasource(tableSourceVO.getDatasource());
        TableSource tableSource = datasource2.getTableSourceIfExist(tableSourceVO.getAlias());
        if (tableSource == null) {
            throw new IllegalStateException("Tablesource " + tableSourceVO.getAlias() + " not found");
        }
        if (!tableSourceVO.getAlias().equals(string2)) {
            tableSource.changeAliasReferences(string2);
        }
        if (!string3.equals(tableSourceVO.getSqlStatement())) {
            tableSource.setSql(string3);
        }
        if (bl2 != tableSourceVO.getQuoteStringPrompts()) {
            tableSource.setQuoteStringPrompts(bl2);
        }
        if ((datasource = this.dC.getDatabaseTables().getDatasource(string)) == null) {
            throw new IllegalStateException("Datasource " + string + " not found");
        }
        if (!tableSourceVO.getDatasource().equals(string)) {
            tableSource.setLocation(null, datasource);
        }
        TableSourceVO tableSourceVO3 = TableSourceVO.getInstance(tableSourceVO, string2, string3);
        try {
            return this.a(tableSourceVO3, true);
        }
        catch (ReportException reportException) {
            if (!(reportException instanceof ba)) {
                if (!tableSourceVO.getAlias().equals(tableSource.getAlias())) {
                    tableSource.changeAliasReferences(tableSourceVO.getAlias());
                }
                if (!tableSourceVO.getDatasource().equals(string)) {
                    tableSource.setLocation(null, this.dC.getDatabaseTables().getDatasource(tableSourceVO.getDatasource()));
                }
                if (!string3.equals(tableSourceVO.getSqlStatement())) {
                    tableSource.setSql(tableSourceVO.getSqlStatement());
                }
                if (bl2 != tableSourceVO.getQuoteStringPrompts()) {
                    tableSource.setQuoteStringPrompts(tableSourceVO.getQuoteStringPrompts());
                }
            }
            throw reportException;
        }
    }

    @Override
    public RefreshResultVO changeTablesource(TableSourceVO tableSourceVO, String string, String string2, String string3, List<Parameter> arrayList) throws ReportException {
        Datasource datasource;
        this.Q();
        this.checkDatasourceConfiguration(string);
        if (tableSourceVO.isCommand()) {
            throw new IllegalArgumentException("This function don't supports commands");
        }
        Datasource datasource2 = this.dC.getDatabaseTables().getDatasource(tableSourceVO.getDatasource());
        TableSource tableSource = datasource2.getTableSourceIfExist(tableSourceVO.getAlias());
        if (tableSource == null) {
            throw new IllegalStateException("Tablesource " + tableSourceVO.getAlias() + " not found");
        }
        if (!tableSourceVO.getAlias().equals(string2)) {
            tableSource.changeAliasReferences(a.a(datasource2, string2));
        }
        if ((datasource = this.dC.getDatabaseTables().getDatasource(string)) == null) {
            throw new IllegalStateException("Datasource " + string + " not found");
        }
        if (!tableSourceVO.getDatasource().equals(string)) {
            tableSource.setLocation(null, datasource);
        }
        if (!string3.equals(tableSource.getDatabaseIdentifier())) {
            tableSource.setDatabaseIdentifierName(string3);
        }
        String[] stringArray = a.b(datasource, string3);
        DatabaseEntryPath databaseEntryPath = new DatabaseEntryPath(stringArray[0], stringArray[1], stringArray[2]);
        TableSourceVO tableSourceVO2 = new TableSourceVO(tableSourceVO.getType(), string, databaseEntryPath);
        tableSourceVO2.setFieldList(tableSourceVO.getFieldList());
        tableSourceVO2.setParameters(arrayList == null ? new ArrayList() : arrayList);
        if (!tableSource.getAlias().equals(tableSourceVO2.getAlias())) {
            tableSourceVO2.setAlias(tableSource.getAlias());
        }
        try {
            return this.a(tableSourceVO2, true);
        }
        catch (ReportException reportException) {
            if (!(reportException instanceof ba)) {
                this.a(tableSourceVO, tableSource, string);
            }
            throw reportException;
        }
        catch (NeedParametersException needParametersException) {
            this.a(tableSourceVO, tableSource, string);
            throw needParametersException;
        }
    }

    private void a(TableSourceVO tableSourceVO, TableSource tableSource, String string) throws ReportException {
        if (!tableSourceVO.getAlias().equals(tableSource.getAlias())) {
            tableSource.changeAliasReferences(tableSourceVO.getAlias());
        }
        if (!tableSourceVO.getDatasource().equals(string)) {
            tableSource.setLocation(null, this.dC.getDatabaseTables().getDatasource(tableSourceVO.getDatasource()));
        }
        if (!tableSourceVO.getDatabaseIdentifier().equals(tableSource.getDatabaseIdentifier())) {
            tableSource.setDatabaseIdentifierName(tableSourceVO.getDatabaseIdentifier());
        }
    }

    @Override
    public DatabaseVO replaceDatasource(DatasourceVO datasourceVO, DatasourceVO datasourceVO2, boolean bl2, boolean bl3) throws ReportException {
        this.Q();
        String string = datasourceVO2.getName();
        this.checkDatasourceConfiguration(string);
        DataSourceConfiguration dataSourceConfiguration = this.f(string);
        String string2 = this.er.getDriverName(dataSourceConfiguration);
        DatabaseVO databaseVO = this.er.createDatabaseVO(new DatasourceVO(string, string2), this.es.getPassword(string), bl3, false, this.dC.getReportFile());
        Datasource datasource = this.dC.getDatabaseTables().getDatasource(datasourceVO.getName());
        datasource.setDataSourceConfiguration(dataSourceConfiguration);
        if (bl2) {
            for (int i2 = 0; i2 < this.dC.getSubReportCount(); ++i2) {
                Engine engine = this.dC.getSubReport(i2);
                int n2 = engine.getDatabaseTables().getDatasourceCount();
                for (int i3 = 0; i3 < n2; ++i3) {
                    engine.getDatabaseTables().getDatasource(i3).setDataSourceConfiguration(dataSourceConfiguration);
                }
            }
        }
        return databaseVO;
    }

    @Override
    public String[] showSQL() throws ReportException {
        Serializable serializable;
        this.Q();
        DatabaseTables databaseTables = this.dC.getDatabaseTables();
        for (int i2 = 0; i2 < databaseTables.getDatasourceCount(); ++i2) {
            serializable = databaseTables.getDatasource(i2);
            this.checkDatasourceConfiguration(((Datasource)serializable).getDataSourceConfigurationName());
            String[] stringArray = this.es.getPassword(((Datasource)serializable).getDataSourceConfigurationName());
            if (stringArray == null) continue;
            ((Datasource)serializable).setPassword((String)stringArray);
        }
        String[] stringArray = this.dC.getDefaultSqlOfAllStatements(false);
        serializable = new StringList();
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                if (string == null) continue;
                ((StringList)serializable).addElement(string);
            }
        }
        return ((StringList)serializable).toArray();
    }

    @Override
    public JoinListVO getTablesAndJoins() throws ReportException {
        Serializable serializable;
        int n2;
        this.Q();
        JoinListVO joinListVO = new JoinListVO();
        DatabaseTables databaseTables = this.dC.getDatabaseTables();
        for (n2 = 0; n2 < databaseTables.getDatasourceCount(); ++n2) {
            serializable = databaseTables.getDatasource(n2);
            for (int i2 = 0; i2 < ((Datasource)serializable).getTableSourceCount(); ++i2) {
                TableSourceVO tableSourceVO;
                TableSource tableSource = ((Datasource)serializable).getTableSource(i2);
                int n3 = tableSource.getSql() != null ? 3 : 0;
                String string = ((Datasource)serializable).getDataSourceConfigurationName();
                if (n3 == 3) {
                    tableSourceVO = new TableSourceVO(string, tableSource.getAlias(), tableSource.getSql(), tableSource.getQuoteStringPrompts());
                } else {
                    List<PromptField> list = tableSource.getInputParameters();
                    ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
                    if (list.size() > 0) {
                        n3 = 2;
                        for (PromptField promptField : list) {
                            Parameter parameter = new Parameter();
                            parameter.setColumnName(promptField.getName());
                            parameter.setDataType(promptField.getValueType());
                            arrayList.add(parameter);
                        }
                    } else {
                        n3 = this.a(tableSource, string);
                    }
                    String[] stringArray = a.b((Datasource)serializable, tableSource.getDatabaseIdentifier());
                    DatabaseEntryPath object2 = new DatabaseEntryPath(stringArray[0], stringArray[1], stringArray[2]);
                    tableSourceVO = new TableSourceVO(n3, string, object2);
                    tableSourceVO.setParameters(arrayList);
                }
                tableSourceVO.setAlias(tableSource.getAlias());
                tableSourceVO.setFieldList(PageHandlerUtilities.getAllFieldsOfTablesource(tableSource));
                joinListVO.addTableSource(tableSourceVO);
            }
        }
        for (n2 = 0; n2 < databaseTables.getJoinsEntries().size(); ++n2) {
            serializable = (Join)databaseTables.getJoinsEntries().get(n2);
            if (((Join)serializable).getConditionCount() == 0) continue;
            JoinVO joinVO = null;
            joinVO = PageHandlerUtilities.getJoinVO((Join)serializable, 0, joinVO);
            joinListVO.addJoin(joinVO);
            if (((Join)serializable).getConditionCount() <= 1) continue;
            for (int i3 = 1; i3 < ((Join)serializable).getConditionCount(); ++i3) {
                joinVO = PageHandlerUtilities.getJoinVO((Join)serializable, i3, joinVO);
            }
        }
        return joinListVO;
    }

    private int a(TableSource tableSource, String string) {
        try {
            int n2 = a.a(tableSource, true);
            if (n2 >= 0) {
                return n2;
            }
            if (b.contains(string)) {
                DatabaseEntry databaseEntry;
                b b2 = null;
                b2 = b.a(string, this.es.getPassword(string), this.dC.getReportFile());
                if (b2 != null && (databaseEntry = b2.d(tableSource.getDatabaseIdentifier())) != null) {
                    switch (databaseEntry.getEntryType()) {
                        case 11: 
                        case 20: 
                        case 21: {
                            return 2;
                        }
                        case 10: {
                            return 1;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            BaseUtils.error("Error by type checking of tablesource: " + tableSource.getAlias());
            BaseUtils.error(exception);
        }
        return 0;
    }

    @Override
    public void checkPassword(String string) throws RequiresPasswordException, ReportException {
        this.checkDatasourceConfiguration(string);
        this.er.checkPassword(this.es.getPassword(string), string);
    }

    @Override
    public void setPassword(String string, String string2) throws RequiresPasswordException, ReportException {
        this.er.checkPassword(string2, string);
        this.es.setPassword(string2, string);
        if (this.dC != null) {
            this.a(this.dC, string, string2);
            for (int i2 = 0; i2 < this.dC.getSubReportCount(); ++i2) {
                Engine engine = this.dC.getSubReport(i2);
                this.a(engine, string, string2);
            }
        }
    }

    private void a(Engine engine, String string, String string2) throws ReportException {
        DatabaseTables databaseTables = engine.getDatabaseTables();
        for (int i2 = 0; i2 < databaseTables.getDatasourceCount(); ++i2) {
            Datasource datasource = databaseTables.getDatasource(i2);
            if (!datasource.getDataSourceConfigurationName().equals(string)) continue;
            datasource.setPassword(string2);
        }
    }

    @Override
    public List<DatasourceVO> getAllDatasourceVOs() {
        return DatasourcePageHandler.getAllDatasourceVOs(true).getVOList();
    }

    public void checkDatasourceConfiguration(String string) throws ReportException {
    }

    private DataSourceConfiguration f(String string) {
        return DataSourceConfigurationManager.getDataSourceConfiguration(string, 3);
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public SQLField addSQLField(String string, String string2) throws ReportException {
        this.Q();
        return this.dC.getFields().addSQLField(string, string2);
    }

    @Override
    public SQLField setSQLExpression(SQLField sQLField, String string) throws ReportException {
        this.Q();
        if (sQLField != null) {
            sQLField.setSQLExpression(string);
        }
        return sQLField;
    }

    public void setEngine(Engine engine) {
        this.dC = engine;
    }

    private void Q() {
        if (this.dC == null) {
            throw new IllegalStateException(ErrorCodes.missingEngine.getI18nKey());
        }
    }

    @Override
    public DatabaseVO isDatasourceEnabled(String string, boolean bl2) throws ReportException {
        if (b.contains(string)) {
            this.checkDatasourceConfiguration(string);
            String string2 = this.er.getDriverName(this.f(string));
            DatabaseVO databaseVO = this.er.createDatabaseVO(new DatasourceVO(string, string2), this.es.getPassword(string), bl2, false, this.dC.getReportFile());
            return databaseVO;
        }
        return null;
    }

    @Override
    public SQLField duplicateSQLField(SQLField sQLField, String string) throws ReportException {
        this.Q();
        return (SQLField)sQLField.duplicate(string);
    }

    @Override
    public TableSourceVO getFields(TableSourceVO tableSourceVO) throws ReportException, NeedParametersException, IllegalArgumentException {
        return this.getFields(tableSourceVO, false);
    }

    public TableSourceVO getFields(TableSourceVO tableSourceVO, boolean bl2) throws ReportException, NeedParametersException {
        Object object;
        Object object2;
        TableSourceVO tableSourceVO2 = null;
        if (!tableSourceVO.isCommand()) {
            object2 = tableSourceVO.getDatasource();
            this.checkDatasourceConfiguration((String)object2);
            object = b.a((String)object2, this.es.getPassword(object2), this.dC.getReportFile());
            DatabaseEntry databaseEntry = ((b)object).d(tableSourceVO.getDatabaseIdentifier());
            if (databaseEntry != null) {
                tableSourceVO2 = PageHandlerUtilities.getTableSourceVO(databaseEntry);
                tableSourceVO2.setAlias(tableSourceVO.getAlias());
                tableSourceVO2.setParameters(tableSourceVO.getParameters());
                return this.er.fillTableSourceVO(tableSourceVO2, new ArrayList<TableSourceVO>(), this.es, this.dC.getReportFile());
            }
        }
        object2 = new ArrayList();
        object2.add(tableSourceVO);
        object = this.er.getTableSourceFields((List<TableSourceVO>)object2, this.es, bl2 ? this.dC : null);
        tableSourceVO2 = tableSourceVO.copy();
        tableSourceVO2.setFieldList((List<FieldVO>)object);
        return tableSourceVO2;
    }

    @Override
    public void replaceColumns(List<FieldVO[]> list) throws ReportException {
        this.Q();
        for (FieldVO[] fieldVOArray : list) {
            Object object2;
            DatabaseTables databaseTables = this.dC.getDatabaseTables();
            FieldVO fieldVO = fieldVOArray[0];
            String string = fieldVO.getCCName();
            for (Object object2 : databaseTables.getJoinsEntries()) {
                Join join = (Join)object2;
                for (int i2 = 0; i2 < join.getConditionCount(); ++i2) {
                    DatabaseField databaseField = join.getConditionSourceFields()[i2];
                    DatabaseField databaseField2 = join.getConditionTargetFields()[i2];
                    if (!string.equals(databaseField.getName()) && !string.equals(databaseField2.getName())) continue;
                    databaseTables.removeJoin(databaseField.getTableSource(), databaseField, databaseField2.getTableSource(), databaseField2);
                }
            }
            DatabaseField databaseField = this.dC.getFields().getDatabaseField(string);
            if (databaseField == null || (object2 = fieldVOArray[1]) == null) continue;
            databaseField.rename(((FieldVO)object2).getCCName());
            databaseField.setColumnLabel(((FieldVO)object2).getAlias());
        }
    }

    @Override
    public RefreshResultVO refreshTableSource(TableSourceVO tableSourceVO) throws ReportException {
        return this.a(tableSourceVO, false);
    }

    private RefreshResultVO a(TableSourceVO tableSourceVO, boolean bl2) throws ReportException {
        RefreshResultVO refreshResultVO = null;
        try {
            refreshResultVO = new RefreshResultVO(this.c(tableSourceVO), null, null);
        }
        catch (ReportException reportException) {
            if (reportException instanceof ba) {
                refreshResultVO = new RefreshResultVO(this.getFields(tableSourceVO, tableSourceVO.isCommand()), this.a((ba)reportException, tableSourceVO), null);
            }
            if (!bl2 || !tableSourceVO.isCommand() && this.e(tableSourceVO)) {
                VOList<FieldVO> vOList = this.b(tableSourceVO);
                tableSourceVO.setFieldList(new ArrayList<FieldVO>());
                refreshResultVO = new RefreshResultVO(tableSourceVO, vOList, reportException.getMessage());
            }
            throw ReportExceptionFactory.createReportExceptionWithCause(reportException);
        }
        return refreshResultVO;
    }

    private VOList<FieldVO> b(TableSourceVO tableSourceVO) throws ReportException {
        this.Q();
        String string = tableSourceVO.getDatasource();
        this.checkDatasourceConfiguration(string);
        Datasource datasource = this.dC.getDatabaseTables().getDatasource(string);
        if (datasource == null) {
            throw ReportExceptionFactory.createReportException(ErrorCode.dscNotDefined, string);
        }
        ArrayList<FieldVO> arrayList = new ArrayList<FieldVO>();
        TableSource tableSource = datasource.getTableSource(tableSourceVO.getAlias());
        for (int i2 = 0; i2 < tableSourceVO.getFieldList().size(); ++i2) {
            FieldVO fieldVO = tableSourceVO.getFieldList().get(i2);
            try {
                tableSource.canRemoveColumn(fieldVO.getName());
                continue;
            }
            catch (ReportException reportException) {
                if (reportException.getErrorCode() != ErrorCode.DBFieldIsUsed.getErrorCodeNumber()) continue;
                arrayList.add(fieldVO.copy());
            }
        }
        return new VOList<FieldVO>(arrayList);
    }

    private VOList<FieldVO> a(ba ba2, TableSourceVO tableSourceVO) {
        List<String> list = ba2.getColumns();
        ArrayList<FieldVO> arrayList = new ArrayList<FieldVO>();
        block0: for (String string : list) {
            for (FieldVO fieldVO : tableSourceVO.getFieldList()) {
                if (!fieldVO.getName().equals(string)) continue;
                arrayList.add(fieldVO.copy());
                continue block0;
            }
        }
        return new VOList<FieldVO>(arrayList);
    }

    private TableSourceVO c(TableSourceVO tableSourceVO) throws ReportException {
        this.Q();
        String string = tableSourceVO.getDatasource();
        this.checkDatasourceConfiguration(string);
        Datasource datasource = this.dC.getDatabaseTables().getDatasource(string);
        if (datasource == null) {
            throw ReportExceptionFactory.createReportException(ErrorCode.dscNotDefined, string);
        }
        Connection connection = datasource.getConnection();
        try {
            Object object;
            TableSource tableSource = datasource.getTableSource(tableSourceVO.getAlias());
            this.er.setParameterValue(tableSourceVO, tableSource);
            tableSource.refresh();
            TableSourceVO tableSourceVO2 = null;
            if (tableSourceVO.isCommand()) {
                tableSourceVO2 = new TableSourceVO(datasource.getDataSourceConfigurationName(), tableSource.getAlias(), tableSource.getSql(), tableSource.getQuoteStringPrompts());
                object = PageHandlerUtilities.getAllFieldsOfTablesource(tableSource);
                tableSourceVO2.setFieldList((List<FieldVO>)object);
            } else {
                tableSourceVO2 = this.er.getTableSourceVO(tableSource);
                tableSourceVO2 = this.d(tableSourceVO2);
            }
            object = tableSourceVO2;
            return object;
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException, ErrorCode.errorConnecting, new Object[0]);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private TableSourceVO d(TableSourceVO tableSourceVO) throws ReportException {
        TableSourceVO tableSourceVO2 = tableSourceVO.copy();
        String string = tableSourceVO.getDatasource();
        if (b.contains(string)) {
            b b2 = b.a(string, this.es.getPassword(string), this.dC.getReportFile());
            DatabaseEntry databaseEntry = b2.d(tableSourceVO.getDatabaseIdentifier());
            if (databaseEntry == null && b2.getDatasource().getDataFactory() instanceof DatabaseSqlServer && tableSourceVO.getName().indexOf(59) < 0) {
                databaseEntry = b2.d(tableSourceVO.getDatabaseIdentifier() + ";1");
            }
            if (databaseEntry != null) {
                databaseEntry.loadParameters();
                if (!databaseEntry.returnsResultSet()) {
                    throw ReportExceptionFactory.createReportException(ErrorCode.errorNoResultSet, databaseEntry.getPath().getFullName());
                }
                tableSourceVO2.setParameters(databaseEntry.getInputParameters());
            }
        }
        return tableSourceVO2;
    }

    private boolean e(TableSourceVO tableSourceVO) {
        String string = tableSourceVO.getDatasource();
        try {
            b b2 = b.a(string, this.es.getPassword(string), this.dC.getReportFile());
            DatabaseEntry databaseEntry = b2.d(tableSourceVO.getDatabaseIdentifier());
            if (databaseEntry != null) {
                return true;
            }
        }
        catch (ReportException reportException) {
            BaseUtils.error(reportException);
        }
        return false;
    }

    @Override
    public String getDestinationName() {
        return Msg.getMsg("Local");
    }

    @Override
    public List<String> checkDatasources(List<IVLCommand.DatasourceDescription> list) {
        boolean bl2 = dw.j(ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE.getKey(), Boolean.parseBoolean(ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE.getDefault()));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IVLCommand.DatasourceDescription datasourceDescription : list) {
            if (DataSourceConfigurationManager.exists(datasourceDescription.getName()) || datasourceDescription.hasConfig() && bl2) continue;
            arrayList.add(datasourceDescription.getName());
        }
        return arrayList;
    }

    @Override
    public String getFormulaExpanderClasses() {
        return dw.sK();
    }
}

