/*
 * Decompiled with CFR 0.152.
 */
package com.inet.chart3d.geom;

import com.inet.chart3d.geom.h;
import com.inet.report.BaseUtils;
import com.inet.report.chart.f;
import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ViewParams
implements Serializable {
    public static final String TOKEN_VIEW_PARAM = "ViewParam";
    public static final int MIN_VIEW = 0;
    public static final int MAX_VIEW = 100;
    public static final int DEFAULT_H_VIEW = 70;
    public static final int DEFAULT_V_VIEW = 30;
    private int fZ = 70;
    private int ga = 30;

    public ViewParams() {
    }

    public ViewParams(int n2, int n3) {
        this.setHView(n2);
        this.setVView(n3);
    }

    public static ViewParams createDefault() {
        return new ViewParams();
    }

    public void setViewParams(ViewParams viewParams) {
        this.setHView(viewParams.getHView());
        this.setVView(viewParams.getVView());
    }

    public int getHView() {
        return this.fZ;
    }

    public void setHView(int n2) {
        if (n2 >= 0 && n2 <= 100) {
            this.fZ = n2;
        }
    }

    public int getVView() {
        return this.ga;
    }

    public void setVView(int n2) {
        if (n2 >= 0 && n2 <= 100) {
            this.ga = n2;
        }
    }

    public h getU() {
        return h.d(0.0, 1.0, 0.0);
    }

    public h getN() {
        double d2 = -10.0 + 1.1 * (double)this.getHView();
        double d3 = Math.cos(Math.toRadians(d2));
        double d4 = Math.sin(Math.toRadians(d2));
        return h.d(d3, 0.0, d4);
    }

    public h getV() {
        double d2 = -10.0 + 1.1 * (double)this.getHView();
        double d3 = Math.sin(Math.toRadians(d2));
        double d4 = -Math.cos(Math.toRadians(d2));
        return h.d(d3, 0.0, d4);
    }

    public boolean equals(Object object) {
        if (object instanceof ViewParams) {
            ViewParams viewParams = (ViewParams)object;
            return this.getHView() == viewParams.getHView() && this.getVView() == viewParams.getVView();
        }
        return false;
    }

    public int hashCode() {
        return this.getHView() + this.getVView();
    }

    public void saveProperties(StringBuilder stringBuilder, int n2) {
        String string = BaseUtils.L(n2);
        ++n2;
        stringBuilder.append(string);
        stringBuilder.append("<");
        stringBuilder.append(TOKEN_VIEW_PARAM);
        stringBuilder.append(">\n");
        f.b(stringBuilder, n2, "HView", String.valueOf(this.getHView()));
        f.b(stringBuilder, n2, "VView", String.valueOf(this.getVView()));
        stringBuilder.append(string);
        stringBuilder.append("<");
        stringBuilder.append("/");
        stringBuilder.append(TOKEN_VIEW_PARAM);
        stringBuilder.append(">\n");
    }

    public void readProperties(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            String string = element2.getNodeName();
            try {
                String string2;
                if (string.equals("HView")) {
                    string2 = element2.getAttribute("value");
                    this.setHView(Integer.parseInt(string2));
                    continue;
                }
                if (!string.equals("VView")) continue;
                string2 = element2.getAttribute("value");
                this.setVView(Integer.parseInt(string2));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

