/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.BaseEditor;
import com.inet.editor.HtmlEditorUtils;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.InetHtmlTransferHandler;
import com.inet.html.actions.InetHtmlAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class AddImageAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;
    private static File lastDir = null;

    public AddImageAction() {
        super("addimage");
        this.putValue("ShortDescription", HtmlEditorUtils.getTranslation("addimage"));
        this.putValue("Name", HtmlEditorUtils.getTranslation("addimage"));
        this.putValue("SmallIcon", HtmlEditorUtils.getResourceImage("addimage.gif"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, InetHtmlEditorKit.SHORTCUT_KEY_MASK));
    }

    public boolean isEnabled() {
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkPropertyAccess("user.home");
                return super.isEnabled();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return super.isEnabled();
    }

    public void setEnabled(boolean bl2) {
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkPropertyAccess("user.home");
            }
            super.setEnabled(bl2);
        }
        catch (SecurityException securityException) {
            super.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Component) {
            File file;
            Component component;
            Container container;
            Component component2 = (Component)object;
            JTextComponent jTextComponent = this.getHtmlEditor(actionEvent);
            if (jTextComponent == null && component2 instanceof Container) {
                container = (Container)component2;
                while (container != null && !(container instanceof BaseEditor) && !(container instanceof JTextComponent)) {
                    if (container instanceof JPopupMenu) {
                        component = ((JPopupMenu)container).getInvoker();
                        if (component instanceof Container) {
                            container = (Container)component;
                            continue;
                        }
                        container = null;
                        continue;
                    }
                    if (container.getParent() == null) break;
                    container = container.getParent();
                }
                if (container != null && container instanceof BaseEditor) {
                    jTextComponent = ((BaseEditor)container).getEditor();
                }
                if (container != null && container instanceof JTextComponent) {
                    jTextComponent = (JTextComponent)container;
                }
            }
            if (jTextComponent == null || !(jTextComponent.getTransferHandler() instanceof InetHtmlTransferHandler)) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
            container = new JFileChooser();
            if (lastDir != null) {
                ((JFileChooser)container).setCurrentDirectory(lastDir);
            }
            ((JFileChooser)container).setAcceptAllFileFilterUsed(false);
            ((JFileChooser)container).setDialogTitle(HtmlEditorUtils.getTranslation("addimage"));
            ((JFileChooser)container).setDialogType(0);
            ((JFileChooser)container).setMultiSelectionEnabled(false);
            ((JFileChooser)container).setFileSelectionMode(2);
            ((JFileChooser)container).setFileFilter(new FileFilter(){

                public String getDescription() {
                    StringBuffer stringBuffer = new StringBuffer(HtmlEditorUtils.getTranslation("imagefiles"));
                    stringBuffer.append(" (");
                    int n2 = 0;
                    TreeSet<String> treeSet = new TreeSet<String>();
                    treeSet.addAll(InetHtmlTransferHandler.IMAGE_TYPES);
                    for (String string : treeSet) {
                        if (n2 > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(string.toUpperCase(Locale.US));
                        ++n2;
                    }
                    stringBuffer.append(")");
                    return stringBuffer.toString();
                }

                public boolean accept(File file) {
                    String string;
                    String string2;
                    int n2;
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.isFile() && (n2 = (string2 = file.getName()).lastIndexOf(46)) > 0 && (string = string2.substring(n2 + 1)) != null && string.length() > 0 && InetHtmlTransferHandler.IMAGE_TYPES.contains(string.toLowerCase());
                }
            });
            for (component = jTextComponent; component != null && !(component instanceof JScrollPane) && component.getParent() != null; component = component.getParent()) {
            }
            int n2 = ((JFileChooser)container).showOpenDialog(component);
            InetHtmlTransferHandler inetHtmlTransferHandler = (InetHtmlTransferHandler)jTextComponent.getTransferHandler();
            if (n2 == 0 && (file = ((JFileChooser)container).getSelectedFile()) != null && file.exists() && file.canRead() && file.isFile()) {
                Caret caret = jTextComponent.getCaret();
                int n3 = Math.max(caret.getMark(), caret.getDot());
                int n4 = Math.min(caret.getMark(), caret.getDot());
                inetHtmlTransferHandler.importFile(file, jTextComponent.getDocument(), n4, n3, false, true);
                File file2 = file.getParentFile();
                if (file2 != null) {
                    lastDir = file2;
                }
            }
        }
    }
}

