/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.AddImageAction;
import com.inet.editor.BaseEditorToolBar;
import com.inet.editor.ColorButton;
import com.inet.editor.DefaultHyperlinkListener;
import com.inet.editor.HtmlConverter;
import com.inet.editor.HtmlEditorUtils;
import com.inet.editor.HyperlinkAction;
import com.inet.editor.HyperlinkActionPopup;
import com.inet.editor.InetTextPane;
import com.inet.editor.SourceCodeAction;
import com.inet.editor.SpellCheckerProxy;
import com.inet.editor.handler.HyperlinkHandler;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.InetHtmlTransferHandler;
import com.inet.html.actions.EnterAction;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.Styles;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.handler.PasteFileHandler;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.FontFamily;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.FontStyle;
import com.inet.html.parser.converter.FontWeight;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.TextAlign;
import com.inet.html.parser.converter.TextDecoration;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.EmbeddedImage;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseEditor
extends JPanel
implements CaretListener,
ActionListener {
    public static final String PROPERTY_AUTO_SCROLL = "autoScroll";
    private static final long serialVersionUID = 1L;
    private final InetTextPane text;
    private final UndoAction undoAction = new UndoAction();
    private final RedoAction redoAction = new RedoAction();
    private final UndoManager undoManager = new EditorUndoManager();
    private String compactOriginalText;
    private boolean originalIsHtml;
    private URL base;
    private BaseEditorToolBar tools;
    private boolean isCaretUpdate;
    private final JPopupMenu popup = new JPopupMenu();
    private InetHtmlConfiguration editorHtmlConfig = InetHtmlConfiguration.getMailEditorConfig();
    private Font defaultFont;
    private Dictionary<Object, Object> persistentDocProperties;
    private static Dictionary<Object, Object> defaultProperties;
    private volatile int loadingID;
    private volatile int finishedID;
    private boolean showLinkURL = false;
    private boolean textAntiAlias = true;
    private DefaultHyperlinkListener hyperlinkListener;
    private float fontScale = 1.0f;
    private FocusListener internalFocusListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            this.processFocusEvent(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.processFocusEvent(focusEvent);
        }

        private void processFocusEvent(FocusEvent focusEvent) {
            focusEvent = new FocusEvent(BaseEditor.this, focusEvent.getID(), focusEvent.isTemporary(), focusEvent.getOppositeComponent());
            BaseEditor.this.processFocusEvent(focusEvent);
        }
    };
    private Set<TextLoadListener> loadListeners = new HashSet<TextLoadListener>();

    public BaseEditor(boolean bl2) {
        this(bl2, true, true, true);
    }

    public BaseEditor(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Object object;
        Object object2;
        Object object3;
        this.setLayout(new BorderLayout());
        Dictionary<Object, Object> dictionary = this.getDocumentProperties();
        dictionary.put(InetHtmlDocument.PROPERTY_CONFIGURATION, this.editorHtmlConfig);
        dictionary.put(InetHtmlDocument.PROPERTY_INDENT_SPACE, 0);
        dictionary.put("IgnoreCharsetDirective", Boolean.TRUE);
        if (this.defaultFont != null) {
            dictionary.put(InetHtmlDocument.PROPERTY_DEFAULT_FONT, this.defaultFont);
        }
        if (defaultProperties != null) {
            object3 = defaultProperties.keys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                object = defaultProperties.get(object2);
                this.persistentDocProperties.put(object2, object);
            }
        }
        this.text = new InetTextPane();
        this.text.setName("BaseEditor.text");
        this.text.setEditable(bl3);
        this.text.addCaretListener(this);
        this.text.setEditorKit(this.createEditorKit(true));
        if (bl2) {
            this.add((Component)new JScrollPane(this.text, 20, 30), "Center");
        } else {
            this.add((Component)this.text, "Center");
        }
        this.text.addFocusListener(this.internalFocusListener);
        this.text.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("editorKit".equals(propertyChangeEvent.getPropertyName())) {
                    Class<?> clazz;
                    if (propertyChangeEvent.getOldValue() == null) {
                        return;
                    }
                    Class<?> clazz2 = propertyChangeEvent.getOldValue().getClass();
                    if (clazz2 != (clazz = propertyChangeEvent.getNewValue().getClass())) {
                        boolean bl2 = propertyChangeEvent.getNewValue() instanceof InetHtmlEditorKit;
                        BaseEditor.this.tools.notifyFormat(bl2);
                        BaseEditor.this.tools.setEnableFormatButtons(bl2);
                        if (clazz == StyledEditorKit.class) {
                            StyledEditorKit styledEditorKit = new StyledEditorKit();
                            BaseEditor.this.text.setEditorKit(styledEditorKit);
                            BaseEditor.this.text.setDocument(styledEditorKit.createDefaultDocument());
                        }
                    }
                }
            }
        });
        object3 = this.text.getActionMap();
        object2 = this.text.getInputMap();
        object = ((ActionMap)object3).get("insert-softbreak");
        ((InputMap)object2).put(KeyStroke.getKeyStroke(10, 1), "insert-softbreak");
        ((ActionMap)object3).put("insert-softbreak", (Action)object);
        ((ActionMap)object3).put("insert-break", new EnterAction(((ActionMap)object3).get("insert-break")));
        ((InputMap)object2).put(KeyStroke.getKeyStroke(90, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "undo");
        ((ActionMap)object3).put("undo", this.undoAction);
        ((InputMap)object2).put(KeyStroke.getKeyStroke(89, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "redo");
        ((ActionMap)object3).put("redo", this.redoAction);
        ((InputMap)object2).put(KeyStroke.getKeyStroke(72, InetHtmlEditorKit.SHORTCUT_KEY_MASK + 1), "hyperlink");
        ((ActionMap)object3).put("hyperlink", new HyperlinkAction());
        ((InputMap)object2).put(KeyStroke.getKeyStroke(85, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "sourcecode");
        ((ActionMap)object3).put("sourcecode", new SourceCodeAction(this));
        ((InputMap)object2).put(KeyStroke.getKeyStroke(71, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "addimage");
        ((ActionMap)object3).put("addimage", new AddImageAction());
        this.tools = new BaseEditorToolBar(this, bl4, bl3, bl5);
        Document document = this.text.getDocument();
        if (document instanceof InetHtmlDocument) {
            InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)this.text.getDocument();
            inetHtmlDocument.setDocumentProperties(this.persistentDocProperties);
            inetHtmlDocument.setPreservesUnknownTags(false);
            URL uRL = this.getBase();
            if (uRL != null) {
                inetHtmlDocument.setBase(uRL);
            }
            NavigationFilter navigationFilter = new NavigationFilter(){

                public void moveDot(NavigationFilter.FilterBypass filterBypass, int n2, Position.Bias bias) {
                }

                public void setDot(NavigationFilter.FilterBypass filterBypass, int n2, Position.Bias bias) {
                }
            };
            this.text.setNavigationFilter(navigationFilter);
            try {
                this.text.getDocument().remove(0, this.text.getDocument().getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.text.setNavigationFilter(null);
        }
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                BaseEditor.this.text.getCaret().setSelectionVisible(true);
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.hyperlinkListener = new DefaultHyperlinkListener(this);
        this.text.addHyperlinkListener(this.hyperlinkListener);
        this.text.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!BaseEditor.this.hasFocus()) {
                    BaseEditor.this.text.requestFocusInWindow();
                }
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && BaseEditor.this.isEnabled()) {
                    for (Component component : BaseEditor.this.popup.getComponents()) {
                        if (!(component instanceof JMenuItem)) continue;
                        ((JMenuItem)component).setEnabled(BaseEditor.this.isActionEnabled(((JMenuItem)component).getAction()));
                    }
                    BaseEditor.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                BaseEditor.this.text.requestFocusInWindow();
            }
        });
        this.caretUpdate(new SimpleCaretEvent(this.text, 0, 0));
        this.updateCursor();
        SpellCheckerProxy.enableAutoSpell(this.text, this.isAutoSpellCheck());
        this.undoManager.discardAllEdits();
        document.addUndoableEditListener(this.undoManager);
        this.undoAction.updateState();
        this.redoAction.updateState();
        this.allowImagePaste(this.editorHtmlConfig.isAllowInternalImages());
        this.setUnChanged();
        this.text.setBackground(Color.WHITE);
        this.createPopup(this.popup);
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
            }

            public void focusGained(FocusEvent focusEvent) {
                BaseEditor.this.requestFocus();
            }
        });
    }

    @Override
    public void requestFocus() {
        this.text.requestFocusInWindow();
    }

    protected boolean isAutoSpellCheck() {
        return this.tools != null ? this.tools.isAutoSpellCheck() : false;
    }

    protected void setAutoSpellCkeck(boolean bl2) {
        SpellCheckerProxy.enableAutoSpell(this.text, bl2);
        this.tools.setAutoSpellSelected(bl2);
    }

    protected void createPopup(final JPopupMenu jPopupMenu) {
        Object object;
        if (SpellCheckerProxy.isSpellCheckerAvailable() && this.isEditable()) {
            object = new SpellCheckerProxy.ActivationCallback(){

                public void setActive(boolean bl2) {
                    BaseEditor.this.putClientProperty("activator", null);
                    if (bl2) {
                        JMenu jMenu = SpellCheckerProxy.createCheckerMenu();
                        JMenu jMenu2 = SpellCheckerProxy.createLanguagesMenu();
                        JSeparator jSeparator = new JSeparator();
                        jPopupMenu.add((Component)jSeparator, 0);
                        jPopupMenu.add((Component)jMenu2, 0);
                        jPopupMenu.add((Component)jMenu, 0);
                    }
                }
            };
            SpellCheckerProxy.activate((SpellCheckerProxy.ActivationCallback)object);
            this.putClientProperty("activator", object);
        }
        if (this.isEditable()) {
            this.createActionComponent(new HyperlinkActionPopup(this.text), "hyperlinkpopup", null, this.popup);
        }
        object = this.text.getActionMap();
        Action action = ((ActionMap)object).get("copy-to-clipboard");
        Action action2 = ((ActionMap)object).get("cut-to-clipboard");
        Action action3 = ((ActionMap)object).get("paste-from-clipboard");
        Action action4 = ((ActionMap)object).get("paste-from-clipboard-plain");
        Action action5 = ((ActionMap)object).get("copy-to-clipboard-plain");
        InputMap inputMap = this.text.getInputMap();
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        if (action != null || action2 != null || action3 != null || action4 != null) {
            if (action != null) {
                this.createActionComponent(action, "copy", this.getAccelerator(keyStrokeArray, inputMap, "copy-to-clipboard", 67), this.popup);
            }
            this.addPlainAction(action5, false, "copy-to-clipboard", "copycontent", 67, inputMap, keyStrokeArray);
            if (action2 != null && this.isEditable()) {
                this.createActionComponent(action2, "cut", this.getAccelerator(keyStrokeArray, inputMap, "cut-to-clipboard", 88), this.popup);
            }
            if (action3 != null && this.isEditable()) {
                this.createActionComponent(action3, "paste", this.getAccelerator(keyStrokeArray, inputMap, "paste-from-clipboard", 86), this.popup);
            }
            this.addPlainAction(action4, true, "paste-from-clipboard", "pastecontent", 86, inputMap, keyStrokeArray);
            jPopupMenu.add(new JSeparator());
        }
        jPopupMenu.add(((ActionMap)object).get("sourcecode"));
    }

    private void addPlainAction(Action action, boolean bl2, String string, String string2, int n2, InputMap inputMap, KeyStroke[] keyStrokeArray) {
        block4: {
            if (action != null && (this.isEditable() || !bl2)) {
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard();
                    if (System.getSecurityManager() != null) {
                        System.getSecurityManager().checkSystemClipboardAccess();
                    }
                    KeyStroke keyStroke = this.getAccelerator(keyStrokeArray, inputMap, string, n2);
                    this.createActionComponent(action, string2, KeyStroke.getKeyStroke(keyStroke.getKeyCode(), keyStroke.getModifiers() + 1), this.popup);
                }
                catch (Throwable throwable) {
                    if (!Logger.doesLog(2)) break block4;
                    Logger.warning("Unable to install Copy/Paste-Plain action due to security restrictions");
                }
            }
        }
    }

    private KeyStroke getAccelerator(KeyStroke[] keyStrokeArray, InputMap inputMap, String string, int n2) {
        KeyStroke keyStroke;
        int n3;
        for (n3 = 0; n3 < keyStrokeArray.length; ++n3) {
            keyStroke = keyStrokeArray[n3];
            if (keyStroke.getKeyCode() != n2 || string != inputMap.get(keyStroke)) continue;
            return keyStroke;
        }
        for (n3 = 0; n3 < keyStrokeArray.length; ++n3) {
            keyStroke = keyStrokeArray[n3];
            if (string != inputMap.get(keyStroke)) continue;
            return keyStroke;
        }
        return null;
    }

    private void createActionComponent(Action action, String string, KeyStroke keyStroke, JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenuItem.setText(HtmlEditorUtils.getTranslation("popup." + string));
        jMenuItem.setToolTipText(HtmlEditorUtils.getTranslation("popup." + string + "Help"));
        jMenuItem.setAccelerator(keyStroke);
        jMenuItem.setIcon(HtmlEditorUtils.getResourceImage(string + "image.gif"));
        jMenuItem.setHorizontalTextPosition(11);
        jMenuItem.setVerticalTextPosition(0);
        jPopupMenu.add(jMenuItem);
    }

    protected void addButtons(List<Component> list, List<Component> list2, List<Component> list3) {
    }

    private boolean isActionEnabled(Action action) {
        String string;
        if (action == null) {
            return true;
        }
        String string2 = string = action.getValue("Name") != null ? action.getValue("Name").toString() : "";
        if (string.equals("copy-to-clipboard") || string.equals("cut-to-clipboard")) {
            return this.text.getSelectionStart() != this.text.getSelectionEnd();
        }
        return action.isEnabled();
    }

    protected boolean hasFormatButton() {
        return true;
    }

    public void showDocument(URL uRL, String string) {
        if (uRL == null) {
            return;
        }
        URL uRL2 = this.getBase();
        String string2 = uRL2 != null ? uRL2.getPath() : null;
        String string3 = uRL.getPath();
        if ((string2 == null && string3 == null || string2 != null && string3 != null && string2.equals(string3)) && uRL.getRef() != null && this.isHtml()) {
            this.scrollToAnchor(uRL);
        } else {
            this.setPage(uRL);
        }
    }

    private void scrollToAnchor(URL uRL) {
        block7: {
            if (uRL.getRef() == null) {
                return;
            }
            InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)this.text.getDocument();
            String string = InetHtmlDocument.getCachedString(uRL.getRef());
            try {
                string = URLDecoder.decode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            Element element = this.findAnchorElement(string, inetHtmlDocument.getRootElements()[0]);
            if (element != null) {
                try {
                    Rectangle rectangle = this.text.modelToView(element.getStartOffset());
                    int n2 = this.text.getVisibleRect().height;
                    if (rectangle != null) {
                        rectangle.height = n2 > rectangle.height ? n2 : rectangle.height;
                        this.text.scrollRectToVisible(rectangle);
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (!Logger.doesLog(1)) break block7;
                    Logger.error(badLocationException);
                }
            }
        }
    }

    private Element findAnchorElement(String string, Element element) {
        string = InetHtmlDocument.getCachedString(string);
        if (element instanceof AbstractDocument.BranchElement) {
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element;
            for (int i2 = 0; i2 < branchElement.getElementCount(); ++i2) {
                Object object;
                Element element2 = branchElement.getElement(i2);
                AttributeSet attributeSet = element2.getAttributes();
                if (attributeSet.isDefined((Object)HTML.Attribute.NAME) && string == (object = attributeSet.getAttribute((Object)HTML.Attribute.NAME))) {
                    return element2;
                }
                if (attributeSet.isDefined((Object)HTML.Attribute.ID) && string == attributeSet.getAttribute((Object)HTML.Attribute.ID)) {
                    return element2;
                }
                object = this.findAnchorElement(string, element2);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    protected URL getBase() {
        return this.base;
    }

    public void setBase(URL uRL) {
        if (uRL != null) {
            try {
                uRL.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                try {
                    URI uRI = new URI(null, uRL.toString(), null);
                    this.base = uRI.toURL();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.base = uRL;
    }

    public void setText(String string, boolean bl2) {
        this.setText(string, bl2, true);
    }

    public int setTextWithLoadID(String string, boolean bl2) {
        return this.setText(string, bl2, true);
    }

    private int setText(final String string, boolean bl2, boolean bl3) {
        int n2 = ++this.loadingID;
        final LoaderData loaderData = new LoaderData(n2, bl2, bl3);
        new Thread(new Runnable(){

            public void run() {
                try {
                    Object object;
                    Object object2;
                    loaderData.kit = BaseEditor.this.createEditorKit(loaderData.isHtml);
                    loaderData.doc = loaderData.kit.createDefaultDocument();
                    if (loaderData.isHtml) {
                        object2 = (InetHtmlDocument)loaderData.doc;
                        ((InetHtmlDocument)object2).setDocumentProperties(BaseEditor.this.persistentDocProperties);
                        ((HTMLDocument)object2).setPreservesUnknownTags(false);
                        object = BaseEditor.this.getBase();
                        if (object != null) {
                            ((InetHtmlDocument)object2).setBase((URL)object);
                        }
                    }
                    if (Logger.doesLog(4)) {
                        Logger.debug("Set Text: " + string);
                    }
                    object2 = BaseEditor.this.text.getHighlighter();
                    object = object2.getHighlights();
                    int n2 = ((Highlighter.Highlight[])object).length;
                    while (--n2 >= 0) {
                        Highlighter.Highlight highlight = object[n2];
                        object2.removeHighlight(highlight);
                    }
                    loaderData.doc.remove(0, loaderData.doc.getLength());
                    if (string != null && string.length() > 0) {
                        StringReader stringReader = new StringReader(string);
                        loaderData.kit.read(stringReader, loaderData.doc, 0);
                    }
                    EDTLoader eDTLoader = new EDTLoader(loaderData);
                    eDTLoader.add(new InitKitLoader());
                    eDTLoader.add(new ModelLoader());
                    eDTLoader.add(new NewModelNotifyLoader());
                    eDTLoader.add(new SizeUpdateLoader());
                    eDTLoader.add(new UpdatePopupLoader());
                    eDTLoader.start();
                }
                catch (Throwable throwable) {
                    if (loaderData.thisActionID == BaseEditor.this.loadingID) {
                        BaseEditor.this.finishedID = BaseEditor.this.loadingID;
                    }
                    throwable.printStackTrace();
                }
            }
        }).start();
        return n2;
    }

    public int getCurrentLoadID() {
        return this.finishedID;
    }

    protected void textLoaded() {
        this.adjustTextpaneBorders(this.isHtml());
        for (TextLoadListener textLoadListener : this.loadListeners) {
            textLoadListener.notifyTextLoaded(this.text.getDocument());
        }
    }

    private void adjustTextpaneBorders(boolean bl2) {
        Insets insets;
        Insets insets2 = this.text.getBorder().getBorderInsets(this.text);
        Insets insets3 = insets = bl2 ? new Insets(3, 3, 3, 3) : new Insets(8, 8, 8, 8);
        if (!insets.equals(insets2)) {
            this.text.setBorder(new EmptyBorder(insets));
        }
    }

    protected StyledEditorKit createEditorKit(boolean bl2) {
        EditorKit editorKit = this.text.getEditorKit();
        if (bl2) {
            InetHtmlEditorKit inetHtmlEditorKit = editorKit instanceof InetHtmlEditorKit && !(editorKit instanceof SetPageEditorKit) ? (InetHtmlEditorKit)editorKit : new InetHtmlEditorKit(this.textAntiAlias);
            inetHtmlEditorKit.setDefaultConfig(this.editorHtmlConfig);
            return inetHtmlEditorKit;
        }
        if (editorKit != null && editorKit.getClass() == StyledEditorKit.class) {
            return (StyledEditorKit)editorKit;
        }
        return new StyledEditorKit();
    }

    public String getText() {
        return this.text.getText();
    }

    public boolean isHtml() {
        return "text/html".equalsIgnoreCase(this.text.getContentType());
    }

    public boolean isChanged() {
        if (this.loadingID != this.finishedID) {
            return false;
        }
        return this.isHtml() != this.originalIsHtml || !this.getText().equals(this.compactOriginalText);
    }

    public boolean isLoading() {
        return this.loadingID != this.finishedID;
    }

    public void setUnChanged() {
        this.compactOriginalText = this.getText();
        this.originalIsHtml = this.isHtml();
    }

    public boolean isEditable() {
        return this.text.isEditable();
    }

    public void setTextShowMode() {
        this.setEditable(false);
        this.tools.setToolbarVisible(false);
    }

    public void setEditable(boolean bl2) {
        boolean bl3 = this.isEditable();
        if (bl3 != bl2) {
            this.text.setEditable(bl2);
            if (this.isEditable() && this.text.isFocusOwner()) {
                this.text.getCaret().setVisible(true);
            } else {
                this.text.getCaret().setVisible(false);
            }
            this.tools.setEditable(bl2);
            this.firePropertyChange("editable", bl3, bl2);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BaseEditor.this.popup.removeAll();
                    BaseEditor.this.createPopup(BaseEditor.this.popup);
                }
            });
        }
        this.updateCursor();
        this.undoAction.updateState();
        this.redoAction.updateState();
    }

    private void updateCursor() {
        if (this.isEditable()) {
            this.text.setCursor(Cursor.getPredefinedCursor(2));
        } else {
            this.text.setCursor(Cursor.getPredefinedCursor(0));
        }
        EditorKit editorKit = this.text.getEditorKit();
        if (editorKit instanceof InetHtmlEditorKit) {
            ((InetHtmlEditorKit)editorKit).setDefaultCursor(this.text.getCursor());
        }
    }

    @Override
    public void setEnabled(boolean bl2) {
        this.text.setEnabled(bl2);
        this.tools.setEnabled(bl2);
        super.setEnabled(bl2);
        this.undoAction.updateState();
        this.redoAction.updateState();
    }

    public JTextPane getEditor() {
        return this.text;
    }

    public JToolBar getToolbar() {
        return this.tools.getToolbar();
    }

    public BaseEditorToolBar getToolBarController() {
        return this.tools;
    }

    private View getCurrentView() {
        int n2 = this.text.getCaretPosition();
        Element element = this.text.getStyledDocument().getParagraphElement(n2);
        if (element.getStartOffset() != n2) {
            --n2;
        }
        Element element2 = this.text.getStyledDocument().getCharacterElement(n2);
        View view = this.text.getUI().getRootView(this.text);
        return this.findViewForElement(view, element2);
    }

    private View findViewForElement(View view, Element element) {
        if (view.getElement() == element) {
            return view;
        }
        for (int i2 = 0; i2 < view.getViewCount(); ++i2) {
            View view2;
            View view3 = view.getView(i2);
            if (view3 == null || (view2 = this.findViewForElement(view3, element)) == null) continue;
            return view2;
        }
        return null;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.caretUpdate(caretEvent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caretUpdate(CaretEvent caretEvent, boolean bl2) {
        try {
            Object object;
            Object object2;
            this.isCaretUpdate = true;
            int n2 = this.checkCaretRange(caretEvent.getMark());
            int n3 = this.checkCaretRange(caretEvent.getDot());
            if (n2 != caretEvent.getMark() || n3 != caretEvent.getDot()) {
                object2 = this.text.getCaret();
                object2.setDot(n3);
                object2.moveDot(n2);
            }
            object2 = this.getCurrentView();
            BoxView boxView = null;
            if (object2 instanceof BoxView) {
                boxView = (BoxView)object2;
            }
            MutableAttributeSet mutableAttributeSet = ((StyledEditorKit)this.text.getEditorKit()).getInputAttributes();
            float f2 = -1.0f;
            Object object3 = mutableAttributeSet.getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE);
            if (object3 != null) {
                if (boxView != null && object3 instanceof FontSize) {
                    f2 = ((FontSize)object3).getValue(boxView);
                }
                if (object3 instanceof Float) {
                    f2 = ((Float)object3).floatValue();
                }
            }
            if ((object3 = mutableAttributeSet.getAttribute((Object)CSS.Attribute.FONT_SIZE)) != null) {
                if (boxView != null && object3 instanceof FontSize) {
                    f2 = ((FontSize)object3).getValue(boxView);
                }
                if (object3 instanceof Float) {
                    f2 = ((Float)object3).floatValue();
                }
            }
            if ((object = mutableAttributeSet.getAttribute((Object)CSS.Attribute.COLOR)) != null && object instanceof ColorValue) {
                this.tools.setSelectionColor(((ColorValue)object).getValue());
            } else {
                this.tools.setSelectionColor(null);
            }
            String string = null;
            Object object4 = mutableAttributeSet.getAttribute((Object)CSS.Attribute.FONT_FAMILY);
            if (object4 != null && object4 instanceof FontFamily) {
                string = ((FontFamily)object4).getFamily();
            }
            this.tools.setSelectedFontName(string != null ? string : "");
            this.tools.setSelectedFontSize(f2 > 0.0f ? Integer.valueOf((int)LengthUnit.getPTforPX(f2)) : "");
            Object object5 = mutableAttributeSet.getAttribute((Object)CSS.Attribute.FONT_WEIGHT);
            this.tools.setBoldSelected(object5 != null && ((FontWeight)object5).isBold());
            Object object6 = mutableAttributeSet.getAttribute((Object)CSS.Attribute.FONT_STYLE);
            this.tools.setItalicSelected(object6 != null && ((FontStyle)object6).isItalic());
            Object object7 = mutableAttributeSet.getAttribute((Object)CSS.Attribute.TEXT_DECORATION);
            this.tools.setUnderlineSelected(object7 != null && ((TextDecoration)object7).getDecoration() != 0);
            AttributeSet attributeSet = this.text.getParagraphAttributes();
            Object object8 = attributeSet.getAttribute((Object)CSS.Attribute.TEXT_ALIGN);
            if (object8 == null) {
                object8 = attributeSet.getAttribute((Object)TemporaryStyle.Attribute.TEXT_ALIGN);
            }
            if (object8 instanceof TextAlign) {
                switch (((TextAlign)object8).getJustification()) {
                    case 0: {
                        this.tools.setLeftSelected(true);
                        break;
                    }
                    case 1: {
                        this.tools.setCenterSelected(true);
                        break;
                    }
                    case 2: {
                        this.tools.setRightSelected(true);
                        break;
                    }
                    case 3: {
                        this.tools.setJustifySelected(true);
                    }
                }
            } else {
                this.tools.setLeftSelected(true);
            }
        }
        finally {
            this.isCaretUpdate = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isCaretUpdate) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.tools.getFontColor()) {
            return;
        }
        if (object == this.tools.getColorList()) {
            JPopupMenu jPopupMenu = this.tools.getColorMenu();
            if (jPopupMenu != null) {
                jPopupMenu.setVisible(false);
            }
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            Color color = this.tools.getColorList().getColor();
            if (color != null && this.tools.getFontColor() != null) {
                CSS.setTextColor(simpleAttributeSet, color);
                this.text.setCharacterAttributes(simpleAttributeSet, false);
                ((ColorButton)this.tools.getFontColor()).setColor(color);
            }
        } else if (object == this.tools.getFontNameComboBox()) {
            String string = (String)this.tools.getFontNameComboBox().getSelectedItem();
            if (string != null) {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                CSS.setFontFamily(simpleAttributeSet, string);
                this.text.setCharacterAttributes(simpleAttributeSet, false);
            }
        } else if (object == this.tools.getFontSizeComboBox()) {
            try {
                Object object2 = this.tools.getFontSizeComboBox().getSelectedItem();
                String string = object2.toString();
                if (string != null) {
                    int n2 = Integer.parseInt(string);
                    if (n2 < 1 || n2 > 999) {
                        JOptionPane.showMessageDialog(this, "Fontsize must be between 1 and 999.", "Fontsize", 0);
                        this.tools.getFontSizeComboBox().requestFocus();
                        return;
                    }
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                    CSS.setFontSizePT(simpleAttributeSet, n2);
                    this.text.setCharacterAttributes(simpleAttributeSet, false);
                }
            }
            catch (Exception exception) {
                HtmlEditorUtils.printStackTrace(exception);
            }
        } else if (object == this.tools.getHtmlFormat()) {
            String string;
            int n3 = this.text.getCaretPosition();
            String string2 = this.text.getText();
            if (!this.isHtml()) {
                Object object3 = this.persistentDocProperties.get(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS);
                string = HtmlConverter.text2html(string2, null, true, object3 != null ? object3.toString() : null);
            } else {
                string = HtmlConverter.html2text(string2);
                if (!this.isOnlyPlainText()) {
                    Container container;
                    for (container = this; container != null && !(container instanceof JScrollPane); container = container.getParent()) {
                        if (container instanceof JComponent) {
                            JComponent jComponent = container;
                            if (jComponent.getVisibleRect().height == jComponent.getBounds().height) break;
                        }
                        if (container.getParent() == null) break;
                    }
                    if (JOptionPane.showConfirmDialog(container, HtmlEditorUtils.getTranslation("msgHtml2Text"), "i-net HelpDesk", 0) != 0) {
                        return;
                    }
                }
            }
            this.setText(string, !this.isHtml(), false);
            this.text.setCaretPosition(this.checkCaretRange(n3));
        } else if (object == this.tools.getAutoSpell()) {
            this.setAutoSpellCkeck(this.tools.isAutoSpellCheck());
        } else if (object instanceof JMenuItem) {
            this.insertHtml(actionEvent.getActionCommand());
        }
    }

    private boolean isOnlyPlainText() {
        Document document = this.text.getDocument();
        if (!(document instanceof InetHtmlDocument)) {
            return true;
        }
        InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)document;
        Styles styles = inetHtmlDocument.getStyleSheet("INLINE");
        if (styles != null && styles.getRuleCount() > styles.getInitialCount()) {
            return false;
        }
        int n2 = document.getLength();
        Element element = document.getDefaultRootElement();
        if (this.getDefaultFont() != null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Font font;
                Element element2 = ElementUtils.getLeafAt(element, i2);
                if (element2 == null || element2.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.CONTENT || (font = InetHtmlDocument.getFont(element2)).equals(this.getDefaultFont())) continue;
                return false;
            }
        }
        return this.isOnlyPlainTextNode(element);
    }

    private boolean isOnlyPlainTextNode(Element element) {
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (!(object instanceof HTML.Tag)) {
            return false;
        }
        switch ((HTML.Tag)((Object)object)) {
            case HTML: 
            case HEAD: 
            case BODY: 
            case P: 
            case FONT: 
            case SPAN: {
                break;
            }
            case CONTENT: 
            case BR: {
                return true;
            }
            default: {
                return false;
            }
        }
        if (object != HTML.Tag.FONT) {
            AttributeSet attributeSet = element.getAttributes();
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                if (obj instanceof StyleConstants || obj instanceof TemporaryStyle.Attribute || obj == HTML.Attribute.STYLE || (object == HTML.Tag.BODY || object == HTML.Tag.SPAN) && (obj == CSS.Attribute.FONT_SIZE || obj == CSS.Attribute.FONT_FAMILY)) continue;
                return false;
            }
        }
        int n2 = element.getElementCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.isOnlyPlainTextNode(element.getElement(i2))) continue;
            return false;
        }
        return true;
    }

    public void insertHtml(String string) {
        if (string == null) {
            return;
        }
        try {
            Caret caret = this.text.getCaret();
            int n2 = Math.min(caret.getMark(), caret.getDot());
            int n3 = Math.max(caret.getMark(), caret.getDot());
            boolean bl2 = "text/html".equals(this.text.getContentType());
            if (bl2 && string.indexOf(60) >= 0) {
                Document document = this.text.getDocument();
                if (document instanceof InetHtmlDocument) {
                    ((InetHtmlDocument)document).pasteHTML(string, n2, n3);
                    caret.setDot(Math.min(caret.getMark(), caret.getDot()));
                } else {
                    this.text.replaceSelection("");
                    EditorKit editorKit = this.text.getEditorKit();
                    editorKit.read(new StringReader(string), document, this.text.getCaretPosition());
                }
            } else {
                this.text.replaceSelection(HtmlConverter.html2text(string));
            }
        }
        catch (Exception exception) {
            HtmlEditorUtils.printStackTrace(exception);
        }
    }

    public void insertFrom(BaseEditor baseEditor) {
        Object object;
        InetTextPane inetTextPane = baseEditor.text;
        Caret caret = inetTextPane.getCaret();
        int n2 = Math.min(caret.getDot(), caret.getMark());
        int n3 = Math.max(caret.getDot(), caret.getMark());
        String string = null;
        try {
            if (n2 != n3) {
                object = new StringWriter();
                inetTextPane.getEditorKit().write((Writer)object, inetTextPane.getDocument(), n2, n3 - n2);
                string = ((StringWriter)object).toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string == null) {
            string = inetTextPane.getText();
        }
        if (!baseEditor.isHtml()) {
            object = this.persistentDocProperties.get(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS);
            string = HtmlConverter.text2html(string, null, true, object != null ? object.toString() : null);
        }
        this.insertHtml(string);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    private int checkCaretRange(int n2) {
        Document document = this.text.getDocument();
        if (n2 > document.getLength()) {
            return document.getLength();
        }
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    public EmbeddedImage[] getEmbeddedImages() {
        if (this.text != null && this.text.getDocument() != null && this.text.getDocument() instanceof InetHtmlDocument) {
            return ((InetHtmlDocument)this.text.getDocument()).getEmbeddedImages();
        }
        return null;
    }

    public void allowImagePaste(boolean bl2) {
        this.editorHtmlConfig.setAllowInternalImages(bl2);
        Action action = this.tools.getAddImageAction();
        if (action != null) {
            Document document;
            action.setEnabled(bl2);
            this.tools.setAddImageEnabled(action.isEnabled());
            if (this.text != null && (document = this.text.getDocument()) != null && document instanceof InetHtmlDocument) {
                ((InetHtmlDocument)document).setAllowInternalImages(bl2);
            }
        }
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width > 100) {
            dimension.width = 100;
        }
        return dimension;
    }

    public void setConfiguration(InetHtmlConfiguration inetHtmlConfiguration) {
        this.editorHtmlConfig = inetHtmlConfiguration;
        if (this.text != null && this.text.getDocument() instanceof InetHtmlDocument) {
            ((InetHtmlDocument)this.text.getDocument()).putProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, this.editorHtmlConfig);
            this.createEditorKit(true);
        }
    }

    public void setDefaultFont(Font font) {
        if (font != null) {
            Font font2;
            float f2 = LengthUnit.getPXforPT(font.getSize());
            this.defaultFont = font2 = font.deriveFont(f2);
            this.setDocumentProperty(InetHtmlDocument.PROPERTY_DEFAULT_FONT, font);
        } else {
            this.defaultFont = null;
            this.setDocumentProperty(InetHtmlDocument.PROPERTY_DEFAULT_FONT, null);
        }
        if (this.text.getEditorKit() instanceof InetHtmlEditorKit) {
            ((InetHtmlEditorKit)this.text.getEditorKit()).forceUpdateInputAttributes(this.text);
        } else {
            this.text.firePropertyChange("caretUpdate", null, this.text.getDocument());
        }
        this.caretUpdate(new SimpleCaretEvent(this.text, 0, 0), true);
    }

    public void setDefaultFontPX(Font font) {
        if (font != null) {
            this.setDocumentProperty(InetHtmlDocument.PROPERTY_DEFAULT_FONT, font.deriveFont(LengthUnit.getPTforPX(font.getSize())));
            if (this.text.getEditorKit() instanceof InetHtmlEditorKit) {
                ((InetHtmlEditorKit)this.text.getEditorKit()).forceUpdateInputAttributes(this.text);
            } else {
                this.text.firePropertyChange("caretUpdate", null, this.text.getDocument());
            }
            this.caretUpdate(new SimpleCaretEvent(this.text, 0, 0), true);
        } else {
            this.setDocumentProperty(InetHtmlDocument.PROPERTY_DEFAULT_FONT, null);
        }
        this.defaultFont = font;
        this.setFontScaled(font);
    }

    public void setFontScale(float f2) {
        if ((double)f2 < 0.1) {
            f2 = 0.1f;
        }
        if (f2 > 10.0f) {
            f2 = 10.0f;
        }
        this.fontScale = f2;
        if (this.text.getEditorKit() instanceof InetHtmlEditorKit) {
            ((InetHtmlEditorKit)this.text.getEditorKit()).setFontScale(f2);
        }
        if (this.defaultFont == null) {
            this.defaultFont = this.text.getFont();
        }
        this.setFontScaled(this.defaultFont);
    }

    private void setFontScaled(Font font) {
        if (this.fontScale != 1.0f) {
            font = font.deriveFont((float)font.getSize() * this.fontScale);
        }
        this.text.setFont(font);
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setPage(final URL uRL) {
        try {
            ++this.loadingID;
            this.setBase(uRL);
            if (!(this.text.getEditorKit() instanceof SetPageEditorKit)) {
                this.text.setEditorKit(new SetPageEditorKit(this));
            }
            this.setFontScale(this.fontScale);
            this.text.addPropertyChangeListener("editorContent", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Document document = BaseEditor.this.text.getDocument();
                            if (document instanceof InetHtmlDocument && ((InetHtmlDocument)document).isLocked()) {
                                SwingUtilities.invokeLater(this);
                                return;
                            }
                            if (uRL != null && uRL.getRef() != null) {
                                BaseEditor.this.scrollToAnchor(uRL);
                            }
                            BaseEditor.this.finishedID = BaseEditor.this.loadingID;
                            BaseEditor.this.notifyNewModel(BaseEditor.this.isHtml(), true, BaseEditor.this.text.getDocument());
                            BaseEditor.this.textLoaded();
                        }
                    });
                    BaseEditor.this.text.removePropertyChangeListener(this);
                }
            });
            this.text.setPage(uRL);
        }
        catch (Throwable throwable) {
            if (Logger.doesLog(1)) {
                Logger.error("Unable to open page: " + uRL);
                Logger.error(throwable);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><head><title>");
            stringBuilder.append(HtmlEditorUtils.getTranslation("setPageErrorH1"));
            stringBuilder.append("</title></head><body><h1>");
            stringBuilder.append(HtmlEditorUtils.getTranslation("setPageErrorH1"));
            stringBuilder.append("</h1><p>");
            stringBuilder.append(HtmlEditorUtils.getTranslation("setPageErrorBody1"));
            stringBuilder.append(uRL != null ? uRL.toString() : "<no URL>");
            stringBuilder.append(HtmlEditorUtils.getTranslation("setPageErrorBody2"));
            stringBuilder.append("</p></body></html>");
            this.setText(stringBuilder.toString(), true);
        }
    }

    public Dictionary<Object, Object> getDocumentProperties() {
        Dictionary<Object, Object> dictionary;
        Document document;
        if (this.persistentDocProperties == null) {
            this.persistentDocProperties = new Hashtable<Object, Object>(2){

                @Override
                public synchronized Object put(Object object, Object object2) {
                    if (object == InetHtmlDocument.PROPERTY_CONFIGURATION && object2 != null && object2 instanceof InetHtmlConfiguration) {
                        BaseEditor.this.setConfiguration((InetHtmlConfiguration)object2);
                    }
                    return super.put(object, object2);
                }
            };
        }
        if (this.text != null && this.text.getDocument() != null && (document = this.text.getDocument()) instanceof InetHtmlDocument && (dictionary = ((AbstractDocument)document).getDocumentProperties()) != null && dictionary != this.persistentDocProperties) {
            Enumeration<Object> enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = dictionary.get(object);
                this.persistentDocProperties.put(object, object2);
            }
        }
        return this.persistentDocProperties;
    }

    public void setDocumentProperties(Dictionary<Object, Object> dictionary) {
        this.persistentDocProperties = null;
        this.persistentDocProperties = this.getDocumentProperties();
        Enumeration<Object> enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = dictionary.get(object);
            this.persistentDocProperties.put(object, object2);
        }
    }

    public void setDocumentProperty(Object object, Object object2) {
        if (this.persistentDocProperties == null) {
            this.persistentDocProperties = new Hashtable<Object, Object>(2){

                @Override
                public synchronized Object put(Object object, Object object2) {
                    if (object == InetHtmlDocument.PROPERTY_CONFIGURATION && object2 != null && object2 instanceof InetHtmlConfiguration) {
                        BaseEditor.this.setConfiguration((InetHtmlConfiguration)object2);
                    }
                    return super.put(object, object2);
                }
            };
        }
        this.persistentDocProperties.put(object, object2);
        Document document = this.text.getDocument();
        if (document != null && document instanceof InetHtmlDocument) {
            ((InetHtmlDocument)document).setDocumentProperty(object, object2);
        }
    }

    public void setShowLinkURL(boolean bl2) {
        this.showLinkURL = bl2;
    }

    public boolean isShowLinkURL() {
        return this.showLinkURL;
    }

    public void setCustomHyperlinkHandler(HyperlinkHandler hyperlinkHandler) {
        if (this.hyperlinkListener != null) {
            this.hyperlinkListener.setCustomHyperlinkHandler(hyperlinkHandler);
        }
    }

    public void setCustomPasteHandler(PasteFileHandler pasteFileHandler) {
        this.text.putClientProperty("PasteFileHandler", pasteFileHandler);
        TransferHandler transferHandler = this.text.getTransferHandler();
        if (transferHandler != null && transferHandler instanceof InetHtmlTransferHandler) {
            ((InetHtmlTransferHandler)transferHandler).updatePasteFileHandler();
        }
    }

    public void setTextAntiAlias(boolean bl2) {
        this.textAntiAlias = bl2;
    }

    public void setSearchVisible(boolean bl2) {
        this.tools.setSearchVisible(bl2);
    }

    public void addTextLoadListener(TextLoadListener textLoadListener) {
        this.loadListeners.add(textLoadListener);
    }

    public void removeTextLoadListener(TextLoadListener textLoadListener) {
        this.loadListeners.remove(textLoadListener);
    }

    private void notifyNewModel(boolean bl2, boolean bl3, Document document) {
        if (!bl2) {
            this.text.setTransferHandler(new InetHtmlTransferHandler(this.text));
        }
        document.removeUndoableEditListener(this.undoManager);
        this.text.setCaretPosition(0);
        this.caretUpdate(new SimpleCaretEvent(this.text, 0, 0));
        this.updateCursor();
        this.tools.notifyFormat(bl2);
        this.tools.setEnableFormatButtons(bl2);
        if (bl3) {
            this.setUnChanged();
        }
        SpellCheckerProxy.enableAutoSpell(this.text, this.isAutoSpellCheck() && this.isEditable());
        this.undoManager.discardAllEdits();
        document.addUndoableEditListener(this.undoManager);
        this.undoAction.updateState();
        this.redoAction.updateState();
        this.allowImagePaste(this.editorHtmlConfig.isAllowInternalImages());
    }

    public void setTextSelectionEnabled(boolean bl2) {
        if (bl2) {
            this.text.getUI().installUI(this.text);
        } else {
            this.text.setCaret(new NoSelectionCaret());
        }
    }

    static {
        JEditorPane.registerEditorKitForContentType("text/plain", "javax.swing.text.StyledEditorKit");
        JEditorPane.registerEditorKitForContentType("text/html", "com.inet.html.InetHtmlEditorKit");
        defaultProperties = new DefaultStyledDocument().getDocumentProperties();
    }

    private class UpdatePopupLoader
    extends LoaderStep {
        private UpdatePopupLoader() {
        }

        public void execute(LoaderData loaderData) {
            BaseEditor.this.finishedID = loaderData.thisActionID;
            BaseEditor.this.popup.removeAll();
            BaseEditor.this.createPopup(BaseEditor.this.popup);
            BaseEditor.this.textLoaded();
            if (!Boolean.FALSE.equals(BaseEditor.this.getClientProperty(BaseEditor.PROPERTY_AUTO_SCROLL))) {
                BaseEditor.this.text.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
            }
        }
    }

    private class SizeUpdateLoader
    extends LoaderStep {
        private SizeUpdateLoader() {
        }

        public void execute(LoaderData loaderData) {
            block2: {
                try {
                    BaseEditor.this.text.getPreferredSize();
                }
                catch (NullPointerException nullPointerException) {
                    if (!Logger.doesLog(1)) break block2;
                    Logger.error(nullPointerException);
                }
            }
        }
    }

    private class NewModelNotifyLoader
    extends LoaderStep {
        private NewModelNotifyLoader() {
        }

        public void execute(LoaderData loaderData) {
            BaseEditor.this.notifyNewModel(loaderData.isHtml, loaderData.isExternal, loaderData.doc);
        }
    }

    private class ModelLoader
    extends LoaderStep {
        private ModelLoader() {
        }

        public void execute(LoaderData loaderData) {
            block2: {
                BaseEditor.this.setFontScale(BaseEditor.this.fontScale);
                BaseEditor.this.adjustTextpaneBorders(loaderData.isHtml);
                try {
                    BaseEditor.this.text.setDocument(loaderData.doc);
                }
                catch (Throwable throwable) {
                    if (!Logger.doesLog(1)) break block2;
                    Logger.error(throwable);
                }
            }
        }
    }

    private class InitKitLoader
    extends LoaderStep {
        private InitKitLoader() {
        }

        public void execute(LoaderData loaderData) {
            if (!loaderData.isHtml) {
                StyledEditorKit styledEditorKit = BaseEditor.this.createEditorKit(false);
                BaseEditor.this.text.setEditorKit(styledEditorKit);
                BaseEditor.this.text.setDocument(styledEditorKit.createDefaultDocument());
                BaseEditor.this.text.setEditorKit(loaderData.kit);
            } else if (BaseEditor.this.text.getEditorKit().getClass() != loaderData.kit.getClass()) {
                BaseEditor.this.text.setEditorKit(loaderData.kit);
            }
            BaseEditor.this.setFontScale(BaseEditor.this.fontScale);
        }
    }

    private class LoaderData {
        private final int thisActionID;
        private final boolean isHtml;
        private final boolean isExternal;
        private EditorKit kit;
        private Document doc;

        private LoaderData(int n2, boolean bl2, boolean bl3) {
            this.thisActionID = n2;
            this.isHtml = bl2;
            this.isExternal = bl3;
        }
    }

    private abstract class LoaderStep
    implements Runnable {
        private LoaderData data;
        private EDTLoader edtLoader;

        private LoaderStep() {
        }

        public void run() {
            block3: {
                if (this.data.thisActionID != BaseEditor.this.loadingID || this.data.thisActionID <= BaseEditor.this.finishedID) {
                    return;
                }
                try {
                    this.execute(this.data);
                    this.edtLoader.next();
                }
                catch (Throwable throwable) {
                    BaseEditor.this.popup.removeAll();
                    BaseEditor.this.createPopup(BaseEditor.this.popup);
                    BaseEditor.this.textLoaded();
                    if (!Logger.doesLog(1)) break block3;
                    Logger.error(throwable);
                }
            }
        }

        public void setLoader(EDTLoader eDTLoader) {
            this.edtLoader = eDTLoader;
        }

        public void start(LoaderData loaderData) {
            this.data = loaderData;
            if (loaderData.thisActionID != BaseEditor.this.loadingID || loaderData.thisActionID <= BaseEditor.this.finishedID) {
                return;
            }
            SwingUtilities.invokeLater(this);
        }

        public abstract void execute(LoaderData var1);
    }

    private class EDTLoader {
        private LoaderData data;
        private List<LoaderStep> steps = new ArrayList<LoaderStep>();

        public EDTLoader(LoaderData loaderData) {
            this.data = loaderData;
        }

        public void add(LoaderStep loaderStep) {
            this.steps.add(loaderStep);
            loaderStep.setLoader(this);
        }

        public void start() {
            this.next();
        }

        public void next() {
            if (this.steps.size() == 0) {
                return;
            }
            LoaderStep loaderStep = this.steps.remove(0);
            loaderStep.start(this.data);
        }
    }

    public static class SetPageEditorKit
    extends InetHtmlEditorKit {
        private static final String PROPERTY_EDITOR_CONTENT = "editorContent";
        private final BaseEditor editor;

        public SetPageEditorKit(BaseEditor baseEditor) {
            this.editor = baseEditor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(Reader reader, Document document, int n2) throws IOException, BadLocationException {
            try {
                super.read(reader, document, n2);
            }
            finally {
                this.editor.text.firePropertyChange(PROPERTY_EDITOR_CONTENT, null, null);
            }
        }
    }

    public static interface TextLoadListener {
        public void notifyTextLoaded(Document var1);
    }

    private static class NoSelectionCaret
    extends DefaultCaret {
        private static final long serialVersionUID = -3468079662160318085L;

        private NoSelectionCaret() {
        }

        public void setSelectionVisible(boolean bl2) {
            super.setSelectionVisible(false);
        }

        public void setDot(int n2) {
            super.setDot(0);
        }

        public void moveDot(int n2) {
            super.moveDot(0);
        }
    }

    public static class SimpleCaretEvent
    extends CaretEvent {
        private static final long serialVersionUID = -6561566333480275448L;
        private int dot;
        private int mark;

        public SimpleCaretEvent(Object object, int n2, int n3) {
            super(object);
            this.dot = n2;
            this.mark = n3;
        }

        public int getDot() {
            return this.dot;
        }

        public int getMark() {
            return this.mark;
        }
    }

    private class EditorUndoManager
    extends UndoManager
    implements Runnable {
        private static final long serialVersionUID = 447739009751130194L;
        private CompoundEdit recent = null;
        private long lastDoTime = 0L;
        private static final int EVENT_LATENCY_TOLERANCE = 10;

        private EditorUndoManager() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (this.recent != null && System.currentTimeMillis() - this.lastDoTime < 10L) {
                this.recent.addEdit(undoableEditEvent.getEdit());
            } else {
                if (this.recent != null) {
                    this.recent.end();
                }
                this.recent = new CompoundEdit(){

                    public boolean isInProgress() {
                        return false;
                    }
                };
                this.recent.addEdit(undoableEditEvent.getEdit());
                undoableEditEvent = new UndoableEditEvent(undoableEditEvent.getSource(), this.recent);
                super.undoableEditHappened(undoableEditEvent);
                this.lastDoTime = System.currentTimeMillis();
                SwingUtilities.invokeLater(this);
            }
        }

        public synchronized void undo() throws CannotUndoException {
            if (this.recent != null) {
                this.recent.end();
            }
            super.undo();
            this.recent = null;
        }

        public void run() {
            BaseEditor.this.undoAction.updateState();
            BaseEditor.this.redoAction.updateState();
        }
    }

    private class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 5558159401954793463L;

        public RedoAction() {
            super("Redo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            try {
                BaseEditor.this.undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                HtmlEditorUtils.printStackTrace(cannotRedoException);
            }
            this.updateState();
            BaseEditor.this.undoAction.updateState();
        }

        void updateState() {
            this.setEnabled(BaseEditor.this.undoManager.canRedo());
            BaseEditor.this.tools.setRedoButtonEnabled(BaseEditor.this.undoManager.canRedo());
            this.putValue("ShortDescription", BaseEditor.this.undoManager.getRedoPresentationName());
        }

        public boolean isEnabled() {
            return BaseEditor.this.text.isEnabled() && BaseEditor.this.text.isEditable() && super.isEnabled();
        }
    }

    private class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -338168489010023258L;

        public UndoAction() {
            super("Undo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            try {
                BaseEditor.this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                HtmlEditorUtils.printStackTrace(cannotUndoException);
            }
            this.updateState();
            BaseEditor.this.redoAction.updateState();
        }

        public void updateState() {
            this.setEnabled(BaseEditor.this.undoManager.canUndo());
            BaseEditor.this.tools.setUndoButtonEnabled(BaseEditor.this.undoManager.canUndo());
            this.putValue("ShortDescription", BaseEditor.this.undoManager.getUndoPresentationName());
        }

        public boolean isEnabled() {
            return BaseEditor.this.text.isEnabled() && BaseEditor.this.text.isEditable() && super.isEnabled();
        }
    }
}

