/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.AutoCompletionKeyListener;
import com.inet.editor.BaseEditor;
import com.inet.editor.ColorButton;
import com.inet.editor.ColorList;
import com.inet.editor.FocusLostComboBox;
import com.inet.editor.HtmlEditorUtils;
import com.inet.editor.InetToolBar;
import com.inet.editor.ScrollPopup;
import com.inet.editor.SpellCheckerProxy;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.css.CSS;
import com.inet.html.utils.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.SimpleAttributeSet;

public class BaseEditorToolBar
implements ContainerListener {
    private HashMap<Integer, ComponentGroup<Component>> comMap = new HashMap();
    private static final String[] FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static final String[] FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private JToolBar toolbar;
    private JComboBox fontNameComboBox;
    private JComboBox fontSizeComboBox;
    private JButton fontColor;
    private JPopupMenu colorMenu;
    private ColorList colorList;
    private JToggleButton bold;
    private JToggleButton italic;
    private JToggleButton underline;
    private JToggleButton left;
    private JToggleButton center;
    private JToggleButton right;
    private JToggleButton justify;
    private JButton bulletList;
    private JButton numberList;
    private JButton blockLeft;
    private JButton blockRight;
    private JButton hr;
    private JButton hyperlink;
    private JButton undoButton;
    private JButton redoButton;
    private JButton htmlFormat;
    private JButton addimage;
    private JButton spellchecker;
    private JToggleButton autoSpell;
    private JButton search;
    private int buttonoffset;
    private final BaseEditor editor;
    private final boolean isEditable;
    private final boolean isHtml;
    private boolean toolBarUpdateMode;
    private Dimension sepDimension;
    private boolean editComponentsCreated;
    private boolean htmlButtonsCreated;
    private static final Integer GROUP_DEFAULT = 1;
    private static final Integer GROUP_EDIT = 100;
    private static final Integer GROUP_HTMLFORMAT = 200;
    private static final Integer GROUP_UNDOREDO = 300;

    protected BaseEditorToolBar(BaseEditor baseEditor, boolean bl2, boolean bl3, boolean bl4) {
        this.editor = baseEditor;
        this.isEditable = bl3;
        this.isHtml = bl4;
        if (bl2) {
            this.createToolbar();
        }
        this.addButtons();
    }

    private void createToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setRollover(true);
            this.toolbar.addContainerListener(this);
        }
    }

    public void addComponent(Component component, Integer n2, ActionListener actionListener) {
        Serializable serializable;
        if (component == null) {
            return;
        }
        if (component instanceof AbstractButton) {
            serializable = (AbstractButton)component;
            boolean bl2 = false;
            for (ActionListener actionListener2 : ((AbstractButton)serializable).getActionListeners()) {
                if (actionListener2 != actionListener) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                ((AbstractButton)serializable).addActionListener(actionListener);
            }
            component.setFocusable(false);
        } else {
            component.setFocusable(true);
        }
        if (n2 != null) {
            serializable = this.comMap.get(n2);
            if (serializable == null) {
                serializable = new ComponentGroup(false, false);
                this.comMap.put(n2, (ComponentGroup<Component>)serializable);
            }
            ((ComponentGroup)serializable).add(component);
        }
    }

    public void createComponentGroup(Integer n2, boolean bl2, boolean bl3, boolean bl4) {
        ComponentGroup<Component> componentGroup = this.comMap.get(n2);
        if (componentGroup != null) {
            componentGroup.setRequiresLeftSep(bl2);
            componentGroup.setRequiresRightSep(bl3);
            componentGroup.setEnabled(bl4);
        } else {
            componentGroup = new ComponentGroup(bl2, bl3);
            componentGroup.setEnabled(bl4);
            this.comMap.put(n2, componentGroup);
        }
    }

    private void createHtmlButtons() {
        Serializable serializable;
        if (this.htmlButtonsCreated) {
            return;
        }
        this.htmlButtonsCreated = true;
        this.fontNameComboBox = new FocusLostComboBox(FONTS);
        this.fontNameComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Component component;
                if (itemEvent.getStateChange() == 1 && BaseEditorToolBar.this.fontNameComboBox.getEditor() != null && !BaseEditorToolBar.this.fontNameComboBox.isPopupVisible() && (component = BaseEditorToolBar.this.fontNameComboBox.getEditor().getEditorComponent()) instanceof JTextField) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ((JTextField)component).setCaretPosition(0);
                        }
                    });
                }
            }
        });
        this.fontSizeComboBox = new FocusLostComboBox(FONT_SIZES);
        this.fontColor = new ColorButton();
        this.fontColor.setName("font_color");
        this.fontColor.setToolTipText(HtmlEditorUtils.getTranslation("font_color"));
        this.colorMenu = new ScrollPopup();
        this.colorList = new ColorList();
        this.bold = this.createToogleButton(HtmlEditorUtils.getTranslation("font_bold"), DEFAULT_COMPONENTS.btnBold);
        this.italic = this.createToogleButton(HtmlEditorUtils.getTranslation("font_italic"), DEFAULT_COMPONENTS.btnItalic);
        this.underline = this.createToogleButton(HtmlEditorUtils.getTranslation("font_underlined"), DEFAULT_COMPONENTS.btnUnderline);
        this.left = this.createToogleButton("font_align_left", DEFAULT_COMPONENTS.btnAlignLeft);
        this.center = this.createToogleButton("font_align_center", DEFAULT_COMPONENTS.btnAlignCenter);
        this.right = this.createToogleButton("font_align_right", DEFAULT_COMPONENTS.btnAlignRight);
        this.justify = this.createToogleButton("font_align_justify", DEFAULT_COMPONENTS.btnAlignJustify);
        this.bulletList = this.createButton("bulled_list", DEFAULT_COMPONENTS.btnUnorderedList);
        this.numberList = this.createButton("numbered_list", DEFAULT_COMPONENTS.btnOrderedList);
        this.blockLeft = this.createButton("block_left", DEFAULT_COMPONENTS.btnIndentDecrease);
        this.blockRight = this.createButton("block_right", DEFAULT_COMPONENTS.btnIndentIncrease);
        this.hr = this.createButton("hr", DEFAULT_COMPONENTS.btnHorizontalRule);
        this.hyperlink = this.createButton("hyperlink", DEFAULT_COMPONENTS.btnHyperlink);
        this.addimage = this.createButton("addimage", DEFAULT_COMPONENTS.btnAddImage);
        this.fontNameComboBox.addActionListener(this.editor);
        Dimension dimension = this.fontNameComboBox.getPreferredSize();
        if (dimension.width > 130) {
            dimension.width = 130;
        }
        ((JTextField)this.fontNameComboBox.getEditor().getEditorComponent()).addKeyListener(new AutoCompletionKeyListener(this.fontNameComboBox));
        this.fontNameComboBox.setPreferredSize(dimension);
        this.fontNameComboBox.setMaximumSize(dimension);
        this.fontNameComboBox.setMinimumSize(dimension);
        this.fontNameComboBox.setEditable(true);
        this.fontNameComboBox.setToolTipText(HtmlEditorUtils.getTranslation("font_name"));
        this.fontNameComboBox.setName(DEFAULT_COMPONENTS.cmbFontFamily.name());
        this.addComponent(this.fontNameComboBox, GROUP_HTMLFORMAT, this.editor);
        this.fontSizeComboBox.addActionListener(this.editor);
        Dimension dimension2 = this.fontSizeComboBox.getPreferredSize();
        dimension2.width += 10;
        this.fontSizeComboBox.setPreferredSize(dimension2);
        this.fontSizeComboBox.setMaximumSize(dimension2);
        this.fontSizeComboBox.setEditable(true);
        this.fontSizeComboBox.setToolTipText(HtmlEditorUtils.getTranslation("font_size"));
        this.fontSizeComboBox.setName(DEFAULT_COMPONENTS.cmbFontSize.name());
        this.addComponent(this.fontSizeComboBox, GROUP_HTMLFORMAT, this.editor);
        Component component = this.fontSizeComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            serializable = (AbstractDocument)((JTextField)component).getDocument();
            ((AbstractDocument)serializable).setDocumentFilter(new MyFilter());
        }
        this.colorList.addActionListener(this.editor);
        this.fontColor.setName(DEFAULT_COMPONENTS.ddbFontColor.name());
        this.fontColor.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (BaseEditorToolBar.this.editor.isEnabled()) {
                    if (mouseEvent.getX() < BaseEditorToolBar.this.fontColor.getWidth() - 14) {
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        CSS.setTextColor(simpleAttributeSet, ((ColorButton)BaseEditorToolBar.this.fontColor).getColor());
                        BaseEditorToolBar.this.editor.getEditor().setCharacterAttributes(simpleAttributeSet, false);
                    } else if (BaseEditorToolBar.this.fontColor.isShowing()) {
                        BaseEditorToolBar.this.colorMenu.removeAll();
                        for (JMenuItem jMenuItem : BaseEditorToolBar.this.colorList.getMenuItems()) {
                            BaseEditorToolBar.this.colorMenu.add(jMenuItem);
                        }
                        BaseEditorToolBar.this.colorMenu.show(BaseEditorToolBar.this.fontColor, 0, BaseEditorToolBar.this.fontColor.getHeight() - 2);
                    } else {
                        Component component = mouseEvent.getComponent();
                        if (component != null && component.isShowing()) {
                            Point point = BaseEditorToolBar.this.editor.getParent().getLocationOnScreen();
                            try {
                                point = component.getLocationOnScreen();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            Point point2 = BaseEditorToolBar.this.editor.getParent().getLocationOnScreen();
                            BaseEditorToolBar.this.colorMenu.show(BaseEditorToolBar.this.editor.getParent(), point.x - point2.x, point.y - point2.y);
                        }
                    }
                }
                mouseEvent.consume();
            }
        });
        this.addComponent(this.fontColor, GROUP_HTMLFORMAT, this.editor);
        this.addComponent(new JToolBar.Separator(this.sepDimension), GROUP_HTMLFORMAT, this.editor);
        this.addAction("font-bold", this.bold, GROUP_HTMLFORMAT);
        this.addAction("font-italic", this.italic, GROUP_HTMLFORMAT);
        this.addAction("font-underline", this.underline, GROUP_HTMLFORMAT);
        this.addComponent(new JToolBar.Separator(this.sepDimension), GROUP_HTMLFORMAT, this.editor);
        this.addAction("left-justify", this.left, GROUP_HTMLFORMAT);
        this.addAction("center-justify", this.center, GROUP_HTMLFORMAT);
        this.addAction("right-justify", this.right, GROUP_HTMLFORMAT);
        this.addAction("justified-justify", this.justify, GROUP_HTMLFORMAT);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.left);
        ((ButtonGroup)serializable).add(this.center);
        ((ButtonGroup)serializable).add(this.right);
        ((ButtonGroup)serializable).add(this.justify);
        ActionMap actionMap = this.editor.getEditor().getActionMap();
        this.addComponent(new JToolBar.Separator(this.sepDimension), GROUP_HTMLFORMAT, this.editor);
        this.addAction("bulletListAction", this.bulletList, GROUP_HTMLFORMAT);
        this.addAction("numberedListAction", this.numberList, GROUP_HTMLFORMAT);
        Action action = actionMap.get("paraIndentRight");
        if (action != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 0));
        }
        this.addAction("paraIndentRight", this.blockLeft, GROUP_HTMLFORMAT);
        action = actionMap.get("paraIndentLeft");
        if (action != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 1));
        }
        this.addAction("paraIndentLeft", this.blockRight, GROUP_HTMLFORMAT);
        this.addAction("InsertHR", this.hr, GROUP_HTMLFORMAT);
        this.addAction("addimage", this.addimage, GROUP_HTMLFORMAT);
        this.addAction("hyperlink", this.hyperlink, GROUP_HTMLFORMAT);
    }

    private void createEditButtons() {
        Action action;
        if (this.editComponentsCreated) {
            return;
        }
        this.editComponentsCreated = true;
        this.undoButton = this.createButton("backward", DEFAULT_COMPONENTS.btnUndo);
        this.redoButton = this.createButton("forward", DEFAULT_COMPONENTS.btnRedo);
        this.search = this.createButton("search_init", DEFAULT_COMPONENTS.btnFind);
        this.htmlFormat = this.createButton("format", DEFAULT_COMPONENTS.btnChangeFormat);
        this.htmlFormat.setText(HtmlEditorUtils.getTranslation("PlainText"));
        this.htmlFormat.setIcon(HtmlEditorUtils.getResourceImage("format_plain.png"));
        this.htmlFormat.setIconTextGap(2);
        if (SpellCheckerProxy.isSpellCheckerAvailable()) {
            this.spellchecker = this.createButton("spellchecker", DEFAULT_COMPONENTS.btnCheckSpelling);
            boolean bl2 = this.editor.isAutoSpellCheck();
            this.autoSpell = this.createToogleButton("autospell", DEFAULT_COMPONENTS.btnAutoSpellCheck);
            this.autoSpell.setSelected(bl2);
            SpellCheckerProxy.enableShortKey(this.editor.getEditor(), true);
            this.addAction("spell-checking", this.spellchecker, GROUP_EDIT);
            this.addComponent(this.autoSpell, GROUP_EDIT, this.editor);
            SpellCheckerProxy.ActivationCallback activationCallback = new SpellCheckerProxy.ActivationCallback(){

                public void setActive(boolean bl2) {
                    BaseEditorToolBar.this.toolbar.putClientProperty("activator", null);
                    BaseEditorToolBar.this.spellchecker.setVisible(bl2);
                    BaseEditorToolBar.this.autoSpell.setVisible(bl2);
                }
            };
            SpellCheckerProxy.activate(activationCallback);
            this.toolbar.putClientProperty("activator", activationCallback);
        }
        if ((action = this.addAction("undo", this.undoButton, GROUP_UNDOREDO)) != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, InetHtmlEditorKit.SHORTCUT_KEY_MASK));
        }
        if ((action = this.addAction("redo", this.redoButton, GROUP_UNDOREDO)) != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, InetHtmlEditorKit.SHORTCUT_KEY_MASK));
        }
        action = this.addAction("search-init", this.search, GROUP_UNDOREDO);
        this.undoButton.setEnabled(true);
        if (this.editor.hasFormatButton()) {
            this.addComponent(this.htmlFormat, GROUP_UNDOREDO, this.editor);
            this.notifyFormat(this.editor.isHtml());
        }
    }

    private JButton createButton(String string, DEFAULT_COMPONENTS dEFAULT_COMPONENTS) {
        ImageIcon imageIcon = HtmlEditorUtils.getResourceImage(string + ".gif");
        if (imageIcon == null) {
            imageIcon = HtmlEditorUtils.getResourceImage(string + ".png");
        }
        JButton jButton = new JButton(imageIcon);
        jButton.setName(dEFAULT_COMPONENTS.name());
        jButton.setToolTipText(HtmlEditorUtils.getTranslation(string));
        return jButton;
    }

    private JToggleButton createToogleButton(String string, DEFAULT_COMPONENTS dEFAULT_COMPONENTS) {
        ImageIcon imageIcon = HtmlEditorUtils.getResourceImage(string + ".gif");
        if (imageIcon == null) {
            imageIcon = HtmlEditorUtils.getResourceImage(string + ".png");
        }
        JToggleButton jToggleButton = new JToggleButton(imageIcon);
        jToggleButton.setToolTipText(HtmlEditorUtils.getTranslation(string));
        jToggleButton.setName(dEFAULT_COMPONENTS.name());
        return jToggleButton;
    }

    private Action addAction(String string, AbstractButton abstractButton, Integer n2) {
        Action action = this.editor.getEditor().getActionMap().get(string);
        if (action != null) {
            action.putValue("ShortDescription", HtmlEditorUtils.getTranslation(string));
            String string2 = abstractButton.getText();
            Icon icon = abstractButton.getIcon();
            abstractButton.setAction(action);
            abstractButton.setText(string2);
            abstractButton.setIcon(icon);
            this.addComponent(abstractButton, n2, this.editor);
        } else if (Logger.doesLog(2)) {
            Logger.warning("Editor action not found: '" + string + "'");
        }
        return action;
    }

    protected void addButtons() {
        this.sepDimension = new Dimension(new JToolBar.Separator().getPreferredSize().width, 16);
        this.comMap.put(GROUP_DEFAULT, new ComponentGroup(false, false));
        if (this.toolbar != null) {
            this.comMap.put(GROUP_EDIT, new ComponentGroup(false, true));
            this.comMap.put(GROUP_UNDOREDO, new ComponentGroup(false, false));
            this.comMap.put(GROUP_HTMLFORMAT, new ComponentGroup(true, true));
            if (this.isEditable) {
                this.createEditButtons();
            }
            if (this.isHtml) {
                this.createHtmlButtons();
            }
            this.editor.addButtons((List<Component>)this.comMap.get(GROUP_DEFAULT), (List<Component>)this.comMap.get(GROUP_EDIT), (List<Component>)this.comMap.get(GROUP_HTMLFORMAT));
            for (Component component : this.comMap.get(GROUP_DEFAULT)) {
                this.addComponent(component, null, this.editor);
            }
            this.editor.add((Component)new InetToolBar(this.toolbar), "North");
            this.setEditable(this.isEditable);
        }
        this.updateToolbar();
    }

    protected boolean isAutoSpellCheck() {
        return this.autoSpell != null && this.autoSpell.isSelected();
    }

    public void notifyFormat(boolean bl2) {
        if (this.htmlFormat != null) {
            this.htmlFormat.setText(HtmlEditorUtils.getTranslation(bl2 ? "PlainText" : "HtmlText"));
            this.htmlFormat.setIcon(HtmlEditorUtils.getResourceImage(bl2 ? "format_plain.png" : "format_html.png"));
        }
    }

    public void setToolbarVisible(boolean bl2) {
        if (this.toolbar != null) {
            this.toolbar.setVisible(bl2);
        }
    }

    public void enableGroups(Integer ... integerArray) {
        this.changeGroupStatus(true, true, false, integerArray);
    }

    public void disableGroups(Integer ... integerArray) {
        this.changeGroupStatus(false, false, false, integerArray);
    }

    private boolean changeGroupStatus(boolean bl2, boolean bl3, boolean bl4, Integer ... integerArray) {
        boolean bl5 = false;
        if (integerArray == null) {
            return bl5;
        }
        for (Integer n2 : integerArray) {
            ComponentGroup<Component> componentGroup = this.comMap.get(n2);
            if (componentGroup == null) continue;
            bl5 |= bl2 != componentGroup.isEnabled();
            componentGroup.setEnabled(bl2);
            if (!bl4) continue;
            for (Component component : componentGroup) {
                bl5 |= bl3 != component.isEnabled();
                component.setEnabled(bl3);
            }
        }
        return bl5;
    }

    private boolean checkGroups(boolean bl2, boolean bl3) {
        boolean bl4 = false;
        if (bl2) {
            if (!this.editComponentsCreated) {
                this.createEditButtons();
                bl4 = true;
            }
            if (!this.htmlButtonsCreated && bl3) {
                this.createHtmlButtons();
                bl4 = true;
            }
        }
        return bl4;
    }

    public void setEditable(boolean bl2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>(this.comMap.keySet());
        boolean bl3 = false;
        if (bl2) {
            bl3 |= this.checkGroups(bl2, this.editor.isHtml());
        } else {
            bl3 = true;
            treeSet.remove(GROUP_DEFAULT);
        }
        if (bl3 |= this.changeGroupStatus(bl2, bl2, true, treeSet.toArray(new Integer[0]))) {
            this.updateToolbar();
        }
    }

    protected void setEnableFormatButtons(boolean bl2) {
        boolean bl3 = false;
        bl3 |= this.checkGroups(this.editor.isEditable(), this.editor.isHtml());
        if (bl3 |= this.changeGroupStatus(bl2 && this.editor.isEditable(), this.editor.isEnabled() && this.editor.isEditable() && bl2, true, GROUP_HTMLFORMAT)) {
            this.updateToolbar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateToolbar() {
        if (this.toolbar == null) {
            return;
        }
        this.toolBarUpdateMode = true;
        try {
            this.toolbar.removeAll();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.comMap.keySet());
            Collections.sort(arrayList);
            boolean bl2 = false;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                Integer n2 = arrayList.get(i2);
                ComponentGroup<Component> componentGroup = this.comMap.get(n2);
                if (componentGroup.size() == 0 || !componentGroup.isEnabled()) continue;
                if (componentGroup.requiresLeftSep() && this.toolbar.getComponentCount() > 0 && !bl2) {
                    this.toolbar.add(new JToolBar.Separator());
                }
                bl2 = false;
                for (Component component : componentGroup) {
                    this.toolbar.add(component);
                }
                if (!componentGroup.requiresRightSep() || i2 >= arrayList.size() - 1) continue;
                this.toolbar.add(new JToolBar.Separator());
                bl2 = true;
            }
        }
        finally {
            this.toolBarUpdateMode = false;
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        if (this.toolBarUpdateMode) {
            return;
        }
        this.addComponent(containerEvent.getChild(), GROUP_DEFAULT, this.editor);
        this.updateToolbar();
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        int n2;
        if (this.toolBarUpdateMode) {
            return;
        }
        ComponentGroup<Component> componentGroup = this.comMap.get(GROUP_DEFAULT);
        if (componentGroup != null && containerEvent.getChild() != null && (n2 = componentGroup.indexOf(containerEvent.getChild())) >= 0) {
            componentGroup.remove(n2);
        }
        this.updateToolbar();
    }

    public void setEnabled(boolean bl2) {
        if (bl2) {
            this.checkGroups(this.editor.isEditable(), this.editor.isHtml());
        }
        for (ComponentGroup<Component> componentGroup : this.comMap.values()) {
            if (!componentGroup.isEnabled()) continue;
            for (Component component : componentGroup) {
                component.setEnabled(bl2);
            }
        }
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public void setSelectionColor(Color color) {
        if (this.colorList != null) {
            this.colorList.setSelectionColor(color);
        }
    }

    public void setSearchVisible(boolean bl2) {
        if (this.search != null) {
            this.search.setVisible(bl2);
        }
    }

    public void setBoldSelected(boolean bl2) {
        if (this.bold != null) {
            this.bold.setSelected(bl2);
        }
    }

    public void setItalicSelected(boolean bl2) {
        if (this.italic != null) {
            this.italic.setSelected(bl2);
        }
    }

    public void setUnderlineSelected(boolean bl2) {
        if (this.underline != null) {
            this.underline.setSelected(bl2);
        }
    }

    public void setSelectedFontName(String string) {
        if (this.fontNameComboBox != null) {
            this.fontNameComboBox.setSelectedItem(string);
        }
    }

    public void setSelectedFontSize(Object object) {
        if (this.fontSizeComboBox != null) {
            this.fontSizeComboBox.setSelectedItem(object);
        }
    }

    public void setLeftSelected(boolean bl2) {
        if (this.left != null) {
            this.left.setSelected(bl2);
        }
    }

    public void setCenterSelected(boolean bl2) {
        if (this.center != null) {
            this.center.setSelected(bl2);
        }
    }

    public void setRightSelected(boolean bl2) {
        if (this.right != null) {
            this.right.setSelected(bl2);
        }
    }

    public void setJustifySelected(boolean bl2) {
        if (this.justify != null) {
            this.justify.setSelected(bl2);
        }
    }

    public JComboBox getFontNameComboBox() {
        return this.fontNameComboBox;
    }

    public JComboBox getFontSizeComboBox() {
        return this.fontSizeComboBox;
    }

    public JButton getFontColor() {
        return this.fontColor;
    }

    public JPopupMenu getColorMenu() {
        return this.colorMenu;
    }

    public ColorList getColorList() {
        return this.colorList;
    }

    public JToggleButton getBold() {
        return this.bold;
    }

    public JToggleButton getItalic() {
        return this.italic;
    }

    public JToggleButton getUnderline() {
        return this.underline;
    }

    public JToggleButton getLeft() {
        return this.left;
    }

    public JToggleButton getCenter() {
        return this.center;
    }

    public JToggleButton getRight() {
        return this.right;
    }

    public JToggleButton getJustify() {
        return this.justify;
    }

    public JButton getBulletList() {
        return this.bulletList;
    }

    public JButton getNumberList() {
        return this.numberList;
    }

    public JButton getBlockLeft() {
        return this.blockLeft;
    }

    public JButton getBlockRight() {
        return this.blockRight;
    }

    public JButton getHr() {
        return this.hr;
    }

    public JButton getHyperlink() {
        return this.hyperlink;
    }

    public JButton getUndoButton() {
        return this.undoButton;
    }

    public JButton getRedoButton() {
        return this.redoButton;
    }

    public JButton getHtmlFormat() {
        return this.htmlFormat;
    }

    public JButton getAddimage() {
        return this.addimage;
    }

    public JButton getSpellchecker() {
        return this.spellchecker;
    }

    public JToggleButton getAutoSpell() {
        return this.autoSpell;
    }

    public int getButtonoffset() {
        return this.buttonoffset;
    }

    public void setUndoButtonEnabled(boolean bl2) {
        if (this.undoButton != null) {
            this.undoButton.setEnabled(bl2);
        }
    }

    public void setRedoButtonEnabled(boolean bl2) {
        if (this.redoButton != null) {
            this.redoButton.setEnabled(bl2);
        }
    }

    public Action getAddImageAction() {
        return this.addimage != null ? this.addimage.getAction() : null;
    }

    public void setAddImageEnabled(boolean bl2) {
        if (this.addimage != null) {
            this.addimage.setEnabled(bl2);
        }
    }

    public void setAutoSpellSelected(boolean bl2) {
        if (this.autoSpell != null) {
            this.autoSpell.setSelected(bl2);
        }
    }

    private static class MyFilter
    extends DocumentFilter {
        private MyFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            filterBypass.insertString(n2, this.filterPositiveNumber(string), attributeSet);
        }

        public void remove(DocumentFilter.FilterBypass filterBypass, int n2, int n3) throws BadLocationException {
            filterBypass.remove(n2, n3);
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
            filterBypass.replace(n2, n3, this.filterPositiveNumber(string), attributeSet);
        }

        private String filterPositiveNumber(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            for (char c2 : string.toCharArray()) {
                if (!Character.isDigit(c2)) continue;
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentGroup<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -8231009536777119100L;
        private boolean requiresLeftSep;
        private boolean requiresRightSep;
        private boolean enabled = true;

        public ComponentGroup(boolean bl2, boolean bl3) {
            this.requiresLeftSep = bl2;
            this.requiresRightSep = bl3;
        }

        public boolean requiresLeftSep() {
            return this.requiresLeftSep;
        }

        public boolean requiresRightSep() {
            return this.requiresRightSep;
        }

        public void setEnabled(boolean bl2) {
            this.enabled = bl2;
        }

        public void setRequiresLeftSep(boolean bl2) {
            this.requiresLeftSep = bl2;
        }

        public void setRequiresRightSep(boolean bl2) {
            this.requiresRightSep = bl2;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void add(int n2, T t2) {
            super.add(n2, t2);
        }

        @Override
        public boolean add(T t2) {
            return super.add(t2);
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            return super.addAll(collection);
        }

        @Override
        public boolean addAll(int n2, Collection<? extends T> collection) {
            return super.addAll(n2, collection);
        }

        @Override
        public void clear() {
            super.clear();
        }

        @Override
        public T remove(int n2) {
            return (T)super.remove(n2);
        }

        @Override
        public boolean remove(Object object) {
            return super.remove(object);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return super.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return super.retainAll(collection);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ComponentGroup( enabled=").append(this.enabled).append(" )\n");
            stringBuilder.append(super.toString());
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DEFAULT_COMPONENTS {
        btnAutoSpellCheck,
        btnCheckSpelling,
        cmbFontFamily,
        cmbFontSize,
        ddbFontColor,
        btnBold,
        btnItalic,
        btnUnderline,
        btnAlignLeft,
        btnAlignCenter,
        btnAlignRight,
        btnAlignJustify,
        btnUnorderedList,
        btnOrderedList,
        btnIndentIncrease,
        btnIndentDecrease,
        btnHorizontalRule,
        btnAddImage,
        btnHyperlink,
        btnUndo,
        btnRedo,
        btnFind,
        btnChangeFormat;

    }
}

