/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlEditorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;

public class ColorButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private Color color = Color.BLACK;
    private boolean buttonBorderPainted = false;
    private Border border = new SoftBevelBorder(0){
        private static final long serialVersionUID = 1L;

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (ColorButton.this.buttonBorderPainted) {
                super.paintBorder(component, graphics, n2, n3, n4, n5);
            }
            Color color = graphics.getColor();
            graphics.translate(n2, n3);
            graphics.setColor(this.getShadowInnerColor(component));
            graphics.drawLine(n4 - 14, 1, n4 - 14, n5 - 2);
            graphics.translate(-n2, -n3);
            graphics.setColor(color);
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            if (ColorButton.this.isEnabled()) {
                ColorButton.this.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ColorButton.this.setBorderPainted(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (ColorButton.this.isEnabled() && mouseEvent.getX() < ColorButton.this.getWidth() - 14) {
                ColorButton.this.setBorderPainted(false);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ColorButton.this.setBorderPainted(false);
        }
    };

    public ColorButton() {
        this.initGUI();
    }

    public void setVisible(boolean bl2) {
        super.setVisible(bl2);
        this.setBorderPainted(false);
    }

    private void initGUI() {
        this.setBorder(this.border);
        this.setBorderPainted(false);
        this.addMouseListener(this.mouseListener);
        this.setIcon(this.createIcon(this.color));
        this.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = 1L;

            public boolean isArmed() {
                if (this.isEnabled()) {
                    return super.isArmed();
                }
                return false;
            }
        });
    }

    public void setColor(Color color) {
        if (color != null) {
            this.setIcon(this.createIcon(color));
            this.color = color;
        }
    }

    public Color getColor() {
        return this.color;
    }

    private ImageIcon createIcon(Color color) {
        ImageIcon imageIcon = HtmlEditorUtils.getResourceImage("font_color.gif");
        BufferedImage bufferedImage = new BufferedImage(29, 16, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        graphics2D.setColor(color == null ? this.getBackground() : color);
        graphics2D.fillRect(0, 12, 16, 4);
        graphics2D.setColor(Color.BLACK);
        int n2 = 21;
        int n3 = 6;
        for (int i2 = 0; i2 < 4; ++i2) {
            graphics2D.drawLine(n2 + i2, n3 + i2, n2 + 7 - i2, n3 + i2);
        }
        return new ImageIcon(bufferedImage);
    }
}

