/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlEditorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;

public class ColorList {
    private static final long serialVersionUID = 1L;
    static final int COLOR_BLACK = 0;
    static final int COLOR_BLUE = 255;
    static final int COLOR_FUCHSIA = 0xFF00FF;
    static final int COLOR_GRAY = 0x808080;
    static final int COLOR_GREEN = 32768;
    static final int COLOR_LIME = 65280;
    static final int COLOR_MAROON = 0x800000;
    static final int COLOR_NAVY = 128;
    static final int COLOR_OLIVE = 0x808000;
    static final int COLOR_PURPLE = 0x800080;
    static final int COLOR_RED = 0xFF0000;
    static final int COLOR_SILVER = 0xC0C0C0;
    static final int COLOR_TEAL = 32896;
    static final int COLOR_WHITE = 0xFFFFFF;
    static final int COLOR_YELLOW = 0xFFFF00;
    static final int COLOR_ORANGE = 16753920;
    static final int COLOR_CYAN = 65535;
    private static ArrayList<Object> COLOR_ITEMS = new ArrayList();
    private ArrayList<ActionListener> actList = new ArrayList();
    private JMenuItem rememberedItem = null;
    private Object selectedColor = Color.black;
    private Color currentColor;
    private Color selectioncolor;

    public Color getColor() {
        Object object = this.selectedColor;
        if (!(object instanceof Color)) {
            object = null;
        }
        return (Color)object;
    }

    public void setSelectionColor(Color color) {
        this.selectioncolor = color;
    }

    public Color getSelectionColor() {
        return this.selectioncolor;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actList.add(actionListener);
    }

    public void mouseClickedCL() {
        if (!(this.selectedColor instanceof Color)) {
            Color color = JColorChooser.showDialog(this.rememberedItem, HtmlEditorUtils.getTranslation("Color_Dialog_Title"), this.selectioncolor != null ? this.selectioncolor : this.currentColor);
            if (color != null) {
                COLOR_ITEMS.add(COLOR_ITEMS.size() - 1, color);
                Action action = this.rememberedItem.getAction();
                action.putValue("ShortDescription", this.getColorText(color));
                action.putValue("Name", this.getColorText(color));
                action.putValue("obj", color);
                action.putValue("SmallIcon", new ImageIcon(this.createImage(color)));
                this.selectedColor = color;
            }
        } else {
            this.currentColor = (Color)this.selectedColor;
        }
        for (int i2 = 0; i2 < this.actList.size(); ++i2) {
            this.actList.get(i2).actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    public JMenuItem[] getMenuItems() {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        for (int i2 = 0; i2 < COLOR_ITEMS.size(); ++i2) {
            Object object = COLOR_ITEMS.get(i2);
            AbstractAction abstractAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorList.this.selectedColor = this.getValue("obj");
                    ColorList.this.mouseClickedCL();
                }
            };
            abstractAction.putValue("ShortDescription", this.getColorText(object));
            abstractAction.putValue("Name", this.getColorText(object));
            abstractAction.putValue("obj", object);
            abstractAction.putValue("SmallIcon", new ImageIcon(this.createImage(object)));
            JMenuItem jMenuItem = new JMenuItem(abstractAction);
            if (object instanceof Color) {
                this.rememberedItem = jMenuItem;
            }
            arrayList.add(jMenuItem);
        }
        return arrayList.toArray(new JMenuItem[arrayList.size()]);
    }

    private Image createImage(Object object) {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 6);
        if (object instanceof Color) {
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor((Color)object);
            graphics.fillRect(0, 3, 15, 9);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 3, 15, 9);
        }
        return bufferedImage;
    }

    private String getColorText(Object object) {
        if (!(object instanceof Color)) {
            return object.toString();
        }
        int n2 = ((Color)object).getRGB() & 0xFFFFFF;
        switch (n2) {
            case 0: {
                return HtmlEditorUtils.getTranslation("Black");
            }
            case 255: {
                return HtmlEditorUtils.getTranslation("Blue");
            }
            case 65535: {
                return HtmlEditorUtils.getTranslation("Cyan");
            }
            case 0x808080: {
                return HtmlEditorUtils.getTranslation("Gray");
            }
            case 32768: {
                return HtmlEditorUtils.getTranslation("Green");
            }
            case 0xC0C0C0: {
                return HtmlEditorUtils.getTranslation("Silver");
            }
            case 0xFF00FF: {
                return HtmlEditorUtils.getTranslation("Fuchsia");
            }
            case 16753920: {
                return HtmlEditorUtils.getTranslation("Orange");
            }
            case 0xFF0000: {
                return HtmlEditorUtils.getTranslation("Red");
            }
            case 0xFFFFFF: {
                return HtmlEditorUtils.getTranslation("White");
            }
            case 0xFFFF00: {
                return HtmlEditorUtils.getTranslation("Yellow");
            }
            case 65280: {
                return HtmlEditorUtils.getTranslation("Lime");
            }
            case 0x800000: {
                return HtmlEditorUtils.getTranslation("Maroon");
            }
            case 128: {
                return HtmlEditorUtils.getTranslation("Navy");
            }
            case 0x808000: {
                return HtmlEditorUtils.getTranslation("Olive");
            }
            case 0x800080: {
                return HtmlEditorUtils.getTranslation("Purple");
            }
            case 32896: {
                return HtmlEditorUtils.getTranslation("Teal");
            }
        }
        return Integer.toHexString(n2).toUpperCase(Locale.US);
    }

    static {
        COLOR_ITEMS.add(Color.black);
        COLOR_ITEMS.add(Color.blue);
        COLOR_ITEMS.add(Color.cyan);
        COLOR_ITEMS.add(Color.green);
        COLOR_ITEMS.add(Color.lightGray);
        COLOR_ITEMS.add(Color.magenta);
        COLOR_ITEMS.add(new Color(16753920));
        COLOR_ITEMS.add(Color.red);
        COLOR_ITEMS.add(Color.white);
        COLOR_ITEMS.add(Color.yellow);
        COLOR_ITEMS.add(Color.gray);
        COLOR_ITEMS.add(new Color(32768));
        COLOR_ITEMS.add(new Color(0x800000));
        COLOR_ITEMS.add(new Color(0x800080));
        COLOR_ITEMS.add(new Color(0x808000));
        COLOR_ITEMS.add(new Color(128));
        COLOR_ITEMS.add(new Color(32896));
        COLOR_ITEMS.add(HtmlEditorUtils.getTranslation("Custom"));
    }
}

