/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.BaseEditor;
import com.inet.editor.HtmlEditorUtils;
import com.inet.editor.handler.HyperlinkHandler;
import com.inet.html.utils.Logger;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class DefaultHyperlinkListener
implements HyperlinkListener {
    private static HyperlinkHandler defaultHandler = null;
    private HyperlinkHandler customHandler = null;
    private BaseEditor editor;

    public DefaultHyperlinkListener(BaseEditor baseEditor) {
        this.editor = baseEditor;
    }

    public static void setDefaultHyperlinkHandler(HyperlinkHandler hyperlinkHandler) {
        defaultHandler = hyperlinkHandler;
    }

    public void setCustomHyperlinkHandler(HyperlinkHandler hyperlinkHandler) {
        this.customHandler = hyperlinkHandler;
    }

    private boolean checkHandler(HyperlinkHandler hyperlinkHandler, HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkHandler != null) {
            try {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    return hyperlinkHandler.processActivated(hyperlinkEvent);
                }
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    return hyperlinkHandler.processEntered(hyperlinkEvent);
                }
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    return hyperlinkHandler.processExited(hyperlinkEvent);
                }
            }
            catch (Exception exception) {
                Logger.error(exception);
            }
        }
        return false;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (this.checkHandler(this.customHandler, hyperlinkEvent)) {
            return;
        }
        if (this.checkHandler(defaultHandler, hyperlinkEvent)) {
            return;
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            if (uRL != null) {
                this.editor.showDocument(uRL, "_blank");
            }
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            boolean bl2;
            String string = hyperlinkEvent.getDescription();
            String string2 = null;
            if (hyperlinkEvent.getURL() != null) {
                string2 = hyperlinkEvent.getURL().toString();
            }
            if (string != null && string.equals(string2) || !this.editor.isShowLinkURL()) {
                string2 = null;
            }
            StringBuilder stringBuilder = new StringBuilder("<html><body>");
            boolean bl3 = string != null && string.length() > 0;
            boolean bl4 = bl2 = string2 != null && string2.length() > 0;
            if (this.editor.isEditable()) {
                stringBuilder.append(HtmlEditorUtils.getTranslation("openLinkToolTip"));
                stringBuilder.append("<br>");
            }
            if (bl3) {
                stringBuilder.append(string);
            }
            if (bl3 && bl2) {
                stringBuilder.append("<br>");
            }
            if (bl2) {
                stringBuilder.append(string2);
            }
            stringBuilder.append("</body></html>");
            this.editor.getEditor().setToolTipText(stringBuilder.toString());
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.editor.getEditor().setToolTipText(null);
        }
    }
}

