/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;

class FocusLostComboBox
extends JComboBox
implements FocusListener {
    private static final long serialVersionUID = 6975900908437940675L;
    private Object oldItem;
    private Component lastFocusComponent;

    FocusLostComboBox(Object[] objectArray) {
        super(objectArray);
    }

    protected void fireActionEvent() {
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getOppositeComponent();
        if (component != this) {
            this.oldItem = this.getSelectedItemInEditor();
            this.lastFocusComponent = component;
        }
    }

    private Object getSelectedItemInEditor() {
        if (this.getSelectedIndex() >= 0) {
            return super.getSelectedItem();
        }
        return this.getEditor().getItem();
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = this.getSelectedItemInEditor();
        if (object == null) {
            if (this.oldItem == null) {
                return;
            }
            super.fireActionEvent();
            return;
        }
        if (object.equals(this.oldItem)) {
            return;
        }
        super.fireActionEvent();
    }

    public void setPopupVisible(boolean bl2) {
        super.setPopupVisible(bl2);
        Component component = this.lastFocusComponent;
        if (!this.isVisible()) {
            return;
        }
        if (component != null) {
            component.requestFocusInWindow();
        }
    }

    public void addNotify() {
        super.addFocusListener(this);
        this.getEditor().getEditorComponent().addFocusListener(this);
        super.addNotify();
    }

    public void removeNotify() {
        ComboBoxEditor comboBoxEditor = this.getEditor();
        if (comboBoxEditor != null && comboBoxEditor.getEditorComponent() != null) {
            comboBoxEditor.getEditorComponent().removeFocusListener(this);
        }
        super.removeNotify();
    }
}

