/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlWriter;
import com.inet.html.css.HTML;
import com.inet.html.utils.ImageInliner;
import com.inet.html.utils.Logger;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlConverter {
    private static Pattern linePattern = Pattern.compile("^(-{3,}|_{3,})$");

    public static String text2html(String string, Font font) {
        return HtmlConverter.text2html(string, font, false, null);
    }

    public static String text2html(String string, Font font, boolean bl2) {
        return HtmlConverter.text2html(string, font, bl2, null);
    }

    public static String text2html(String string, Font font, boolean bl2, String string2) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (font != null) {
            stringBuffer.append("<head><style>body{font-family:").append(font.getName()).append("; font-size:").append(font.getSize()).append("px;}</style></head><body>");
        }
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.length() == 0 || string3.length() == 1 && string3.charAt(0) == '\u00a0') {
                    if (bl3) {
                        if (bl2) {
                            stringBuffer.append(HtmlConverter.getElement("p", string2) + "&nbsp;</p>");
                            bl5 = true;
                        } else {
                            stringBuffer.append("<br>");
                            bl5 = false;
                        }
                    } else if (bl5) {
                        if (!bl4) {
                            stringBuffer.append("</p>" + HtmlConverter.getElement("p", string2) + "&nbsp;</p>");
                        } else {
                            stringBuffer.append(HtmlConverter.getElement("p", string2) + "&nbsp;</p>");
                        }
                    } else {
                        stringBuffer.append(HtmlConverter.getElement("p", string2) + "&nbsp;</p>");
                    }
                    bl4 = true;
                    bl3 = false;
                    continue;
                }
                if (linePattern.matcher(string3).matches()) {
                    if (bl5) {
                        if (bl4) {
                            stringBuffer.append(HtmlConverter.getElement("hr", string2));
                        } else {
                            stringBuffer.append("</p>" + HtmlConverter.getElement("hr", string2));
                        }
                        bl4 = true;
                        continue;
                    }
                    stringBuffer.append(HtmlConverter.getElement("hr", string2));
                    bl4 = true;
                    continue;
                }
                if (bl3) {
                    if (bl2) {
                        stringBuffer.append(HtmlConverter.getElement("p", string2));
                        bl5 = true;
                    } else {
                        bl5 = false;
                    }
                    bl3 = false;
                } else {
                    if (bl4) {
                        if (bl5) {
                            stringBuffer.append(HtmlConverter.getElement("p", string2));
                        }
                    } else {
                        stringBuffer.append("<br>");
                    }
                    bl4 = false;
                }
                block12: for (int i2 = 0; i2 < string3.length(); ++i2) {
                    char c2 = string3.charAt(i2);
                    int n2 = i2 + 1 < string3.length() ? (int)string3.charAt(i2 + 1) : 65535;
                    switch (c2) {
                        case '\"': {
                            stringBuffer.append("&quot;");
                            continue block12;
                        }
                        case '<': {
                            stringBuffer.append("&lt;");
                            continue block12;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            continue block12;
                        }
                        case '&': {
                            stringBuffer.append("&amp;");
                            continue block12;
                        }
                        case '\u00a0': {
                            stringBuffer.append("&nbsp;");
                            continue block12;
                        }
                        case '\t': {
                            stringBuffer.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        }
                        case ' ': {
                            if (n2 == 32 || n2 == 9 || n2 == 160) {
                                stringBuffer.append("&nbsp;");
                                continue block12;
                            }
                            stringBuffer.append(' ');
                            continue block12;
                        }
                        default: {
                            stringBuffer.append(c2);
                        }
                    }
                }
            }
            if (bl5 && !bl4) {
                stringBuffer.append("</p>");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (font != null) {
            stringBuffer.append("</body>");
        }
        return stringBuffer.toString();
    }

    private static String getElement(String string, String string2) {
        return "<" + string + (string2 != null ? " class=\"" + string2 + "\">" : ">");
    }

    public static String html2text(String string) {
        if (string == null) {
            return "";
        }
        StringReader stringReader = new StringReader(string);
        ParserCallback parserCallback = new ParserCallback(-1);
        try {
            new ParserDelegator().parse(stringReader, parserCallback, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return parserCallback.text.toString();
    }

    public static ConvertResult html2text(String string, int n2) {
        if (string == null) {
            return new ConvertResult("", true);
        }
        StringReader stringReader = new StringReader(string);
        ParserCallback parserCallback = new ParserCallback(n2);
        try {
            new ParserDelegator().parse(stringReader, parserCallback, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return new ConvertResult(parserCallback.text.toString(), !parserCallback.wasInterrupted);
    }

    public static String html2inlinedHtml(String string) {
        return HtmlConverter.html2inlinedHtml(string, true);
    }

    public static String html2inlinedHtml(String string, boolean bl2) {
        return HtmlConverter.html2inlinedHtml(string, bl2, null);
    }

    public static String html2inlinedHtml(String string, boolean bl2, URL uRL) {
        Object object;
        InetHtmlDocument inetHtmlDocument = new InetHtmlDocument();
        inetHtmlDocument.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, InetHtmlConfiguration.getBrowserConfig());
        try {
            try {
                inetHtmlDocument.parse(new StringReader(string), 0);
            }
            catch (ChangedCharSetException changedCharSetException) {
                inetHtmlDocument = new InetHtmlDocument();
                inetHtmlDocument.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                if (uRL != null) {
                    inetHtmlDocument.putProperty("stream", uRL);
                }
                inetHtmlDocument.parse(new StringReader(new String(string.getBytes(), HtmlConverter.getEncoding(changedCharSetException.getCharSetSpec()))), 0);
            }
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
        if (bl2) {
            object = new ImageInliner();
            ((ImageInliner)object).inlineImages(inetHtmlDocument);
        }
        object = new StringWriter();
        InetHtmlWriter inetHtmlWriter = new InetHtmlWriter((Writer)object, inetHtmlDocument, 0, inetHtmlDocument.getLength());
        inetHtmlWriter.setInlineMode(true);
        try {
            inetHtmlWriter.write();
        }
        catch (Exception exception) {
            Logger.error(exception);
        }
        return ((StringWriter)object).toString();
    }

    private static String getEncoding(String string) {
        if (string == null || string.indexOf(59) < 0 && string.indexOf(61) < 0) {
            return string;
        }
        String[] stringArray = string.split(";");
        String string2 = stringArray[0];
        for (String string3 : stringArray) {
            if (!string3.toLowerCase().contains("charset")) continue;
            string2 = string3;
            break;
        }
        if ((stringArray = string2.split("=")).length < 2) {
            return stringArray[0].trim();
        }
        return stringArray[1].trim();
    }

    public static String getCompactHtmlText(String string, Map<String, String> map) {
        return HtmlConverter.getCompactHtmlText(string, map, null);
    }

    public static String getCompactHtmlText(String string, Map<String, String> map, Map<HTML.Tag, Boolean> map2) {
        InetHtmlDocument inetHtmlDocument = new InetHtmlDocument();
        inetHtmlDocument.putProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, InetHtmlConfiguration.getBrowserConfig());
        inetHtmlDocument.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            inetHtmlDocument.parse(new StringReader(string), 0);
            return HtmlConverter.getCompactHtmlText(inetHtmlDocument, map, map2);
        }
        catch (Exception exception) {
            if (Logger.doesLog(1)) {
                Logger.error(exception);
            }
            return string;
        }
    }

    public static String getCompactHtmlText(InetHtmlDocument inetHtmlDocument, Map<String, String> map) throws BadLocationException {
        return HtmlConverter.getCompactHtmlText(inetHtmlDocument, map, null);
    }

    public static String getCompactHtmlText(InetHtmlDocument inetHtmlDocument, Map<String, String> map, Map<HTML.Tag, Boolean> map2) throws BadLocationException {
        Object object = inetHtmlDocument.getProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE);
        inetHtmlDocument.putProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE, new Integer(0));
        inetHtmlDocument.putProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, InetHtmlConfiguration.getBrowserConfig());
        StringWriter stringWriter = new StringWriter();
        InetHtmlWriter inetHtmlWriter = new InetHtmlWriter((Writer)stringWriter, inetHtmlDocument, 0, inetHtmlDocument.getModelLength());
        inetHtmlWriter.setTagWritingOptions(map2);
        inetHtmlWriter.registerImageSRCreplace(map);
        try {
            inetHtmlWriter.write();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (object != null) {
            inetHtmlDocument.putProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE, object);
        }
        return stringWriter.toString();
    }

    private static class InterruptParserException
    extends RuntimeException {
        private InterruptParserException() {
        }

        public void printStackTrace() {
        }
    }

    public static class ConvertResult {
        private String content;
        private boolean isComplete;

        private ConvertResult(String string, boolean bl2) {
            this.content = string;
            this.isComplete = bl2;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public String getContent() {
            return this.content;
        }
    }

    private static class ParserCallback
    extends HTMLEditorKit.ParserCallback {
        private final StringBuffer text = new StringBuffer();
        private boolean dontWrite;
        private boolean nbspPending = false;
        private boolean recentBlockClose = false;
        private boolean recentBlockOpen = false;
        private int bodyPos = 0;
        private int maxLength;
        private boolean wasInterrupted = false;

        public ParserCallback(int n2) {
            this.maxLength = n2;
        }

        public void handleText(char[] cArray, int n2) {
            if (!this.dontWrite) {
                if (this.nbspPending) {
                    this.text.append(' ');
                    this.nbspPending = false;
                }
                if (cArray != null && cArray.length == 1 && cArray[0] == '\u00a0' && this.recentBlockOpen) {
                    this.nbspPending = true;
                } else {
                    if (cArray != null && cArray.length > 0) {
                        for (int i2 = 0; i2 < cArray.length; ++i2) {
                            if (cArray[i2] != '\u00a0') continue;
                            cArray[i2] = 32;
                        }
                    }
                    if (this.maxLength <= 0) {
                        this.text.append(cArray);
                    } else {
                        if (this.text.length() + cArray.length > this.maxLength) {
                            this.text.append(cArray, 0, this.maxLength - this.text.length());
                            this.wasInterrupted = true;
                            throw new InterruptParserException();
                        }
                        this.text.append(cArray);
                    }
                }
            }
            this.recentBlockOpen = false;
            this.recentBlockClose = false;
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n2) {
            if (tag == HTML.Tag.BODY) {
                this.bodyPos = n2;
                this.recentBlockOpen = true;
            }
            if (tag == HTML.Tag.P || tag == HTML.Tag.DIV || tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.TD || tag == HTML.Tag.TH || tag == HTML.Tag.LI || tag == HTML.Tag.PRE || tag == HTML.Tag.UL || tag == HTML.Tag.BLOCKQUOTE) {
                if (!this.recentBlockClose && !this.recentBlockOpen && n2 > this.bodyPos) {
                    this.text.append('\n');
                }
                this.recentBlockOpen = true;
            }
            if (tag == HTML.Tag.LI && !this.dontWrite) {
                this.text.append("* ");
            }
            if (tag == HTML.Tag.TABLE) {
                this.text.append('\n');
            } else if (tag == HTML.Tag.TITLE || tag == HTML.Tag.STYLE) {
                this.dontWrite = true;
            }
            this.recentBlockClose = false;
        }

        public void handleEndTag(HTML.Tag tag, int n2) {
            boolean bl2 = this.recentBlockClose;
            if (tag == HTML.Tag.P || tag == HTML.Tag.DIV || tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.TD || tag == HTML.Tag.TH || tag == HTML.Tag.LI || tag == HTML.Tag.PRE || tag == HTML.Tag.UL || tag == HTML.Tag.BLOCKQUOTE) {
                this.nbspPending = false;
                bl2 = true;
                this.recentBlockOpen = false;
            }
            if (tag == HTML.Tag.BODY || tag == HTML.Tag.HTML) {
                return;
            }
            if (tag == HTML.Tag.P || tag == HTML.Tag.TR || tag == HTML.Tag.DIV || tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.LI) {
                if (!this.recentBlockClose) {
                    this.text.append('\n');
                }
            } else if (tag == HTML.Tag.TD) {
                this.text.append(' ');
            } else if (tag == HTML.Tag.TITLE || tag == HTML.Tag.STYLE) {
                this.dontWrite = false;
            }
            this.recentBlockClose = bl2;
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n2) {
            if (tag == HTML.Tag.HR) {
                try {
                    char c2;
                    int n3 = this.text.length();
                    if (n3 > 0 && (c2 = this.text.charAt(n3 - 1)) != '\n') {
                        this.text.append('\n');
                    }
                    this.text.append("________________________________\n");
                }
                catch (Exception exception) {
                    if (Logger.doesLog(2)) {
                        Logger.warning(exception.getMessage());
                    }
                }
            } else if (tag == HTML.Tag.BR) {
                this.text.append('\n');
            }
            if (this.maxLength > 0 && this.text.length() > this.maxLength) {
                this.wasInterrupted = true;
                throw new InterruptParserException();
            }
            this.recentBlockOpen = false;
            this.recentBlockClose = false;
        }
    }
}

