/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.html.utils.Logger;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;

public class HtmlEditorUtils {
    private static final Map<String, ImageIcon> IMAGE_CACHE = Collections.synchronizedMap(new WeakHashMap());

    public static String getTranslation(String string) {
        block2: {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com.inet.editor.i18n.Resources");
                string = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (!Logger.doesLog(2)) break block2;
                Logger.warning("No lokalization for: " + string + " = " + string);
            }
        }
        return string;
    }

    static ImageIcon getResourceImage(String string) {
        ImageIcon imageIcon = null;
        if (IMAGE_CACHE != null) {
            imageIcon = IMAGE_CACHE.get(string);
        }
        if (imageIcon == null) {
            try {
                URL uRL = HtmlEditorUtils.class.getResource("images/" + string);
                if (uRL != null) {
                    imageIcon = new ImageIcon(uRL);
                    IMAGE_CACHE.put(string, imageIcon);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return imageIcon;
    }

    static void printStackTrace(Exception exception) {
        exception.printStackTrace();
    }
}

