/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlEditorUtils;
import com.inet.editor.HyperlinkInputDialog;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.actions.InetHtmlAction;
import com.inet.html.css.ClassIDGenerator;
import com.inet.html.css.HTML;
import com.inet.html.parser.converter.ClassValue;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class HyperlinkAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;
    private static final String REMOVE_LINK = "remove";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("\\S{1,}@\\S{1,}\\.\\S{1,}");

    public HyperlinkAction() {
        super("hyperlink");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, InetHtmlEditorKit.SHORTCUT_KEY_MASK + 1));
    }

    public Object getValue(String string) {
        if (string == "ShortDescription") {
            return HtmlEditorUtils.getTranslation("hyperlink");
        }
        return super.getValue(string);
    }

    private Element findAnchorElement(InetHtmlDocument inetHtmlDocument, int n2) {
        Element element;
        for (element = ElementUtils.getLeafAt(inetHtmlDocument.getDefaultRootElement(), n2); element != null && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.A; element = element.getParentElement()) {
        }
        return element;
    }

    private String getLink(Element element) {
        Object object = element.getAttributes().getAttribute((Object)HTML.Attribute.HREF);
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        String string;
        String string2;
        String string3;
        Element element;
        int n2;
        int n3;
        Object object3;
        InetHtmlDocument inetHtmlDocument;
        JEditorPane jEditorPane;
        block34: {
            jEditorPane = this.getHtmlEditor(actionEvent);
            if (jEditorPane == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
            if (!(jEditorPane.getDocument() instanceof InetHtmlDocument)) {
                return;
            }
            inetHtmlDocument = (InetHtmlDocument)jEditorPane.getDocument();
            object3 = inetHtmlDocument.getProperty(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS);
            Caret caret = jEditorPane.getCaret();
            n3 = Math.min(caret.getDot(), caret.getMark());
            n2 = Math.max(caret.getDot(), caret.getMark());
            element = this.findAnchorElement(inetHtmlDocument, n2 > n3 ? n2 - 1 : n3);
            string3 = "";
            string2 = "";
            string = element != null ? this.getLink(element) : null;
            bl5 = false;
            bl4 = false;
            bl3 = false;
            bl2 = true;
            if (this.isInSameBlock(n3, n2, inetHtmlDocument)) {
                try {
                    if (n2 - n3 == 0 && element != null) {
                        n3 = element.getStartOffset();
                        n2 = element.getEndOffset();
                        while (n3 > 0 && (object2 = this.findAnchorElement(inetHtmlDocument, n3 - 1)) != null && string.equals(this.getLink((Element)object2))) {
                            n3 = object2.getStartOffset();
                        }
                        while (n2 < inetHtmlDocument.getLength() - 1 && (object2 = this.findAnchorElement(inetHtmlDocument, n2 + 1)) != null && string.equals(this.getLink((Element)object2))) {
                            n2 = object2.getEndOffset();
                        }
                    }
                    if ((string3 = (string2 = inetHtmlDocument.getText(n3, n2 - n3))).endsWith("\n")) {
                        string2 = string3 = string3.substring(0, string3.length() - 1);
                        --n2;
                        bl3 = true;
                    }
                    break block34;
                }
                catch (BadLocationException badLocationException) {
                    if (Logger.doesLog(1)) {
                        Logger.error(badLocationException);
                    }
                    break block34;
                }
            }
            bl5 = true;
        }
        do {
            block35: {
                if (string == null) {
                    if (string2 != null && string2.length() > 0) {
                        try {
                            object2 = new URL(string2.trim());
                            ((URL)object2).toURI();
                            string = ((URL)object2).toString();
                        }
                        catch (Exception exception) {
                            object = string2.trim();
                            if (((String)object).length() > 0 && EMAIL_PATTERN.matcher((CharSequence)object).matches()) {
                                string = "mailto:" + (String)object;
                                break block35;
                            }
                            string = "http://";
                        }
                    } else {
                        string = "http://";
                    }
                }
            }
            String[] stringArray = this.requestAdresseAndName(jEditorPane, string, string2);
            string2 = stringArray[1];
            string = stringArray[0];
            bl2 = true;
            if (string2 == null) {
                return;
            }
            if (string2 == REMOVE_LINK) {
                bl4 = true;
                bl2 = true;
                break;
            }
            for (object2 = jEditorPane; object2 != null && !(object2 instanceof JScrollPane) && ((Component)object2).getParent() != null; object2 = ((Component)object2).getParent()) {
            }
            if (object2 != null && ((Component)object2).getParent() != null) {
                object2 = ((Component)object2).getParent();
            }
            if (!(bl5 && element != null || string2.trim().length() != 0)) {
                JOptionPane.showMessageDialog((Component)object2, HtmlEditorUtils.getTranslation("HyperlinkInputDialog.error.emptyName"), HtmlEditorUtils.getTranslation("HyperlinkInputDialog.error.emptyName.title"), 0);
                bl2 = false;
                continue;
            }
            if (string != null && string.length() != 0 && !string.equals("http://")) continue;
            JOptionPane.showMessageDialog((Component)object2, HtmlEditorUtils.getTranslation("HyperlinkInputDialog.error.emptyAdress"), HtmlEditorUtils.getTranslation("HyperlinkInputDialog.error.emptyAdress.title"), 0);
            bl2 = false;
        } while (!bl2);
        try {
            object2 = new SimpleAttributeSet();
            ((SimpleAttributeSet)object2).addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.A);
            if (bl3) {
                inetHtmlDocument.removeElement((AttributeSet)object2, n2, n2 + 1, true);
            }
            if (bl4) {
                inetHtmlDocument.removeElement((AttributeSet)object2, n3, n2, true);
            } else {
                Object object4;
                Element element2;
                ((SimpleAttributeSet)object2).addAttribute((Object)HTML.Attribute.HREF, new UrlValue(string));
                object = new ClassValue();
                if (object3 != null) {
                    ((ClassValue)object).addClass(object3);
                }
                if ((element2 = ElementUtils.findSharedParagraph(n3, n2 - n3, inetHtmlDocument.getDefaultRootElement())) != null && (object4 = element2.getAttributes().getAttribute((Object)HTML.Attribute.CLASS)) instanceof ClassValue) {
                    ArrayList<Object> arrayList = ((ClassValue)object4).getClassNames();
                    for (Object object5 : arrayList) {
                        String string4 = object5.toString();
                        if (!ClassIDGenerator.WEBENGINE_PREFIX_PATTERN.matcher(string4).matches()) continue;
                        ((ClassValue)object).addClass(string4);
                    }
                }
                if (((ClassValue)object).getClassNames() != null && ((ClassValue)object).getClassNames().size() > 0) {
                    ((SimpleAttributeSet)object2).addAttribute((Object)HTML.Attribute.CLASS, object);
                }
                if (bl5 || !string3.equals(string2)) {
                    inetHtmlDocument.replace(n3, n2 - n3, string2, (AttributeSet)object2);
                } else {
                    inetHtmlDocument.setCharacterAttributes(n3, n2 - n3, (AttributeSet)object2, false, true);
                }
            }
        }
        catch (Exception exception) {
            if (Logger.doesLog(1)) {
                Logger.error(exception);
            }
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        }
    }

    private boolean isInSameBlock(int n2, int n3, InetHtmlDocument inetHtmlDocument) {
        Element element;
        Element element2 = inetHtmlDocument.getParagraphElement(n2);
        if (element2 != (element = inetHtmlDocument.getParagraphElement(n3))) {
            return false;
        }
        return inetHtmlDocument.getUpperContentBoundary(n2, element2) > inetHtmlDocument.getLowerContentBoundary(n3, element2);
    }

    private String[] requestAdresseAndName(JEditorPane jEditorPane, String string, String string2) {
        String[] stringArray = new String[2];
        HyperlinkInputDialog hyperlinkInputDialog = new HyperlinkInputDialog(string, string2);
        int n2 = hyperlinkInputDialog.showDialog(jEditorPane);
        if (n2 == 1) {
            stringArray[0] = hyperlinkInputDialog.getUrl();
            stringArray[1] = hyperlinkInputDialog.getDisplaytext();
        }
        if (n2 == 2) {
            stringArray[0] = REMOVE_LINK;
            stringArray[1] = REMOVE_LINK;
        }
        return stringArray;
    }
}

