/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlEditorUtils;
import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.utils.ElementUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;

public class HyperlinkActionPopup
extends AbstractAction {
    private static final long serialVersionUID = 1428792977186450745L;
    public static final String NAME = "popupHyperlinkAction";
    private final JEditorPane editor;

    public HyperlinkActionPopup(JEditorPane jEditorPane) {
        this.editor = jEditorPane;
        this.putValue("AcceleratorKey", null);
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", HtmlEditorUtils.getTranslation("hyperlink_popup"));
    }

    private Element findAnchorElement(InetHtmlDocument inetHtmlDocument, int n2) {
        Element element;
        for (element = ElementUtils.getLeafAt(inetHtmlDocument.getDefaultRootElement(), n2); element != null && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.A; element = element.getParentElement()) {
        }
        return element;
    }

    public boolean isEnabled() {
        if (this.editor != null && this.editor.getDocument() instanceof InetHtmlDocument) {
            InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)this.editor.getDocument();
            Element element = this.findAnchorElement(inetHtmlDocument, this.editor.getSelectionStart());
            Element element2 = this.findAnchorElement(inetHtmlDocument, this.editor.getSelectionEnd());
            if (element != null && element == element2 && element.getAttributes().isDefined((Object)HTML.Attribute.HREF)) {
                return true;
            }
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Action action = this.editor.getActionMap().get("hyperlink");
        if (action != null) {
            action.actionPerformed(actionEvent);
        }
    }
}

