/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlEditorUtils;
import com.inet.html.InetHtmlEditorKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import sun.swing.DefaultLookup;

public class HyperlinkInputDialog {
    private String url;
    private String displaytext;
    private int selectedOption = 0;
    private JTextField tfName;
    private JTextField tfUrl;
    public static final int CANCEL_OPTION = 0;
    public static final int OK_OPTION = 1;
    public static final int REMOVE_LINK_OPTION = 2;

    public HyperlinkInputDialog(String string, String string2) {
        this.url = string;
        this.displaytext = string2;
    }

    public int showDialog(Component component) {
        JDialog jDialog;
        Serializable serializable;
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            window = SwingUtilities.windowForComponent(component);
        }
        if (window instanceof Frame) {
            serializable = (Frame)window;
            jDialog = new JDialog((Frame)serializable);
        } else if (window instanceof Dialog) {
            serializable = (Dialog)window;
            jDialog = new JDialog((Dialog)serializable);
        } else {
            jDialog = new JDialog();
        }
        jDialog.setDefaultCloseOperation(2);
        jDialog.setModal(true);
        jDialog.setTitle(HtmlEditorUtils.getTranslation("HyperlinkInputDialog.Title"));
        serializable = new AbstractAction("okAction"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                HyperlinkInputDialog.this.selectedOption = 1;
                HyperlinkInputDialog.this.url = HyperlinkInputDialog.this.tfUrl.getText();
                HyperlinkInputDialog.this.displaytext = HyperlinkInputDialog.this.tfName.getText();
                jDialog.dispose();
            }
        };
        AbstractAction abstractAction = new AbstractAction("cancelAction"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                HyperlinkInputDialog.this.selectedOption = 0;
                jDialog.dispose();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction("removeLinkAction"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                HyperlinkInputDialog.this.selectedOption = 2;
                jDialog.dispose();
            }
        };
        JPanel jPanel = (JPanel)jDialog.getContentPane();
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        InputMap inputMap = jPanel.getInputMap(2);
        ActionMap actionMap = jPanel.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "okAction");
        inputMap.put(KeyStroke.getKeyStroke(10, InetHtmlEditorKit.SHORTCUT_KEY_MASK), "okAction");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancelAction");
        actionMap.put("okAction", (Action)((Object)serializable));
        actionMap.put("cancelAction", abstractAction);
        actionMap.put("removeLinkAction", abstractAction2);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 0));
        jPanel.add((Component)jPanel2, "South");
        Icon icon = (Icon)DefaultLookup.get(jPanel2, jPanel2.getUI(), "OptionPane.okIcon");
        Icon icon2 = (Icon)DefaultLookup.get(jPanel2, jPanel2.getUI(), "OptionPane.cancelIcon");
        Locale locale = jPanel2.getLocale();
        JButton jButton = new JButton(UIManager.getString((Object)"OptionPane.okButtonText", locale), icon);
        jButton.addActionListener((ActionListener)((Object)serializable));
        JButton jButton2 = new JButton(UIManager.getString((Object)"OptionPane.cancelButtonText", locale), icon2);
        jButton2.addActionListener(abstractAction);
        JButton jButton3 = new JButton(HtmlEditorUtils.getTranslation("HyperlinkInputDialog.remLink"), new ImageIcon(this.getClass().getResource("/com/inet/editor/images/delete_16.gif")));
        jButton3.addActionListener(abstractAction2);
        int n2 = jButton2.getMinimumSize().height;
        int n3 = jButton3.getMinimumSize().width;
        Dimension dimension = new Dimension(n3, n2);
        jButton3.setMinimumSize(dimension);
        jButton3.setPreferredSize(dimension);
        if (this.url != null && !"".equals(this.url) && !"http://".equalsIgnoreCase(this.url)) {
            jPanel2.add(jButton3);
        }
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel3, "Center");
        Icon icon3 = (Icon)DefaultLookup.get(jPanel, jPanel.getUI(), "OptionPane.questionIcon");
        JLabel jLabel = new JLabel(icon3);
        jPanel3.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        JLabel jLabel2 = new JLabel(HtmlEditorUtils.getTranslation("HyperlinkInputDialog.Name"));
        jPanel3.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        JLabel jLabel3 = new JLabel(HtmlEditorUtils.getTranslation("HyperlinkInputDialog.Link"));
        jPanel3.add((Component)jLabel3, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 10, 5), 0, 0));
        this.tfName = new JTextField(this.displaytext, 20);
        if (this.displaytext != null && this.displaytext.length() > 0) {
            this.tfName.setEditable(false);
        }
        jPanel3.add((Component)this.tfName, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.tfUrl = new JTextField(this.url, 20);
        jPanel3.add((Component)this.tfUrl, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 10, 5), 0, 0));
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.pack();
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Point point = jComponent.getLocationOnScreen();
            Rectangle rectangle = jComponent.getBounds();
            Rectangle rectangle2 = jComponent.getVisibleRect();
            point.x += rectangle2.x;
            point.y += rectangle2.y;
            rectangle.width = rectangle2.width > 0 ? rectangle2.width : rectangle.width;
            rectangle.height = rectangle2.height;
            jDialog.setLocation(point.x + rectangle.width / 2 - jDialog.getWidth() / 2, point.y + rectangle.height / 2 - jDialog.getHeight() / 2);
        } else {
            jDialog.setLocationRelativeTo(component);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (HyperlinkInputDialog.this.tfName.getText().length() > 0) {
                    HyperlinkInputDialog.this.tfUrl.requestFocusInWindow();
                } else {
                    HyperlinkInputDialog.this.tfName.requestFocusInWindow();
                }
            }
        });
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowLostFocus(WindowEvent windowEvent) {
                if (jDialog.isShowing()) {
                    jDialog.toFront();
                }
            }
        });
        jDialog.setVisible(true);
        return this.selectedOption;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDisplaytext() {
        return this.displaytext;
    }
}

