/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.BaseEditor;
import com.inet.html.InetHtmlEditorKit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import javax.swing.text.StyledEditorKit;

public class InetTextPane
extends JTextPane
implements PropertyChangeListener {
    private static final long serialVersionUID = 2172337629876615093L;
    private Dimension last;
    public static final int SHORTCUT_KEY_MASK;

    public InetTextPane() {
        this.setFocusTraversalKeys(0, new HashSet());
        this.setFocusTraversalKeys(1, new HashSet());
        this.addPropertyChangeListener("editorKit", this);
        this.setEditorKitForContentType("text/plain", new StyledEditorKit());
        if (this.getCaretColor() == null) {
            this.setCaretColor(Color.BLACK);
        }
    }

    public void setKeymap(Keymap keymap) {
        super.setKeymap(keymap);
        if (keymap == null) {
            return;
        }
        Action[] actionArray = this.getEditorKit().getActions();
        if (actionArray != null) {
            for (Action action : actionArray) {
                if (!"paste-from-clipboard".equals(action.getValue("Name"))) continue;
                keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 64 + SHORTCUT_KEY_MASK), action);
                keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 64 + SHORTCUT_KEY_MASK), action);
                break;
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        block4: {
            try {
                Container container;
                if (focusEvent.isTemporary()) break block4;
                for (container = this.getParent(); container != null && !(container instanceof BaseEditor); container = container.getParent()) {
                }
                if (container == null) break block4;
                for (Component component = focusEvent.getOppositeComponent(); component != null; component = component.getParent()) {
                    if (component != container) continue;
                    focusEvent = new FocusEvent(focusEvent.getComponent(), focusEvent.getID(), true, focusEvent.getOppositeComponent());
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.processFocusEvent(focusEvent);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (!"editable".equals(string)) {
            super.firePropertyChange(string, object, object2);
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (!dimension.equals(this.last)) {
            super.getMinimumSize();
        }
        this.last = dimension;
        return dimension;
    }

    public void setPage(String string) throws IOException {
        this.putClientProperty("charset", null);
        super.setPage(string);
    }

    public void setPage(URL uRL) throws IOException {
        this.putClientProperty("charset", null);
        super.setPage(uRL);
    }

    public void setCaretPosition(int n2) {
        super.setCaretPosition(Math.max(0, n2));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof InetHtmlEditorKit) {
            return;
        }
        Action[] actionArray = this.getEditorKit().getActions();
        if (actionArray != null) {
            Keymap keymap = this.getKeymap();
            for (Action action : actionArray) {
                if (!"paste-from-clipboard".equals(action.getValue("Name"))) continue;
                keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 64 + SHORTCUT_KEY_MASK), action);
                keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 64 + SHORTCUT_KEY_MASK), action);
                break;
            }
        }
    }

    static {
        try {
            String string = System.getProperty("java.protocol.handler.pkgs", "");
            if (string.indexOf("com.inet.protocol") < 0) {
                if (string.length() > 0) {
                    string = string + "|";
                }
                string = string + "com.inet.protocol";
                System.getProperties().put("java.protocol.handler.pkgs", string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SHORTCUT_KEY_MASK = !GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() : 2;
    }
}

