/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlEditorUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class InetToolBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton expandbutton;
    private JToolBar toolbar;
    private JPopupMenu expandPopup;
    private volatile boolean isWorking = false;
    private volatile boolean requireReLayout = false;
    private Object syncObj = new Object();
    private HashMap<JMenuItem, Component> extendMenus = new HashMap();
    private ActionListener extendAction;

    public InetToolBar(JToolBar jToolBar) {
        super(new BorderLayout());
        this.toolbar = jToolBar;
        jToolBar.setFloatable(false);
        this.setOpaque(false);
        this.add((Component)jToolBar, "Center");
        this.expandbutton = new JButton(HtmlEditorUtils.getResourceImage("expandtoolbar.gif"));
        this.expandbutton.setMargin(new Insets(0, 2, 0, 2));
        this.expandbutton.setVisible(false);
        this.expandPopup = new JPopupMenu();
        this.registerListeners();
    }

    private void registerListeners() {
        this.expandPopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                HashSet hashSet = new HashSet();
                hashSet.addAll(InetToolBar.this.extendMenus.keySet());
                for (JMenuItem jMenuItem : hashSet) {
                    Component component = (Component)InetToolBar.this.extendMenus.get(jMenuItem);
                    jMenuItem.setVisible(!component.getIgnoreRepaint());
                    jMenuItem.setEnabled(component.isEnabled() && !(component instanceof JSeparator));
                    if (!(component instanceof AbstractButton)) continue;
                    AbstractButton abstractButton = (AbstractButton)component;
                    String string = abstractButton.getText();
                    jMenuItem.setText(string == null || string.length() == 0 ? (abstractButton.getToolTipText() == null || abstractButton.getToolTipText().length() == 0 ? " " : abstractButton.getToolTipText()) : string);
                    jMenuItem.setIcon(abstractButton.getIcon());
                    for (MouseListener mouseListener : abstractButton.getMouseListeners()) {
                        jMenuItem.addMouseListener(mouseListener);
                    }
                    if (abstractButton.getToolTipText() == null || abstractButton.getToolTipText().length() <= 0) continue;
                    jMenuItem.setToolTipText(abstractButton.getToolTipText());
                }
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.extendAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                Component component = (Component)InetToolBar.this.extendMenus.get(object);
                if (component != null && component instanceof AbstractButton) {
                    AbstractButton abstractButton = (AbstractButton)component;
                    actionEvent.setSource(abstractButton);
                    if (abstractButton instanceof JToggleButton) {
                        ActionListener[] actionListenerArray;
                        actionListenerArray.setSelected(!(actionListenerArray = (ActionListener[])abstractButton).isSelected());
                    }
                    for (ActionListener actionListener : abstractButton.getActionListeners()) {
                        actionListener.actionPerformed(actionEvent);
                    }
                }
            }
        };
        this.expandbutton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (!InetToolBar.this.expandPopup.isVisible()) {
                    InetToolBar.this.expandPopup.show(InetToolBar.this.expandbutton, 0, InetToolBar.this.expandbutton.getHeight());
                }
            }
        });
        ComponentListener componentListener = new ComponentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentShown(ComponentEvent componentEvent) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentResized(ComponentEvent componentEvent) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentMoved(ComponentEvent componentEvent) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentHidden(ComponentEvent componentEvent) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }
        };
        this.toolbar.addComponentListener(componentListener);
        this.addAncestorListener(new AncestorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void ancestorMoved(AncestorEvent ancestorEvent) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.relayoutComponents();
                }
            }
        });
        this.toolbar.addContainerListener(new ContainerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentRemoved(ContainerEvent containerEvent) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.removePopupComponent(containerEvent.getChild());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentAdded(ContainerEvent containerEvent) {
                if (InetToolBar.this.isWorking) {
                    InetToolBar.this.requireReLayout = true;
                    return;
                }
                if (!InetToolBar.this.toolbar.isShowing()) {
                    return;
                }
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.addPopupComponent(containerEvent.getChild());
                }
            }
        });
    }

    private void removePopupComponent(Component component) {
        HashSet<JMenuItem> hashSet = new HashSet<JMenuItem>();
        hashSet.addAll(this.extendMenus.keySet());
        for (JMenuItem jMenuItem : hashSet) {
            Component component2 = this.extendMenus.get(jMenuItem);
            if (!component2.equals(component)) continue;
            component2.setVisible(true);
            this.extendMenus.remove(jMenuItem);
            jMenuItem.setAction(null);
            this.expandPopup.remove(jMenuItem);
        }
        this.relayoutComponents();
    }

    private void addPopupComponent(Component component) {
        this.relayoutComponents();
    }

    public void relayoutComponents() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = InetToolBar.this.syncObj;
                synchronized (object) {
                    InetToolBar.this.requireReLayout = true;
                    while (InetToolBar.this.requireReLayout) {
                        Component component;
                        Object object2;
                        int n2;
                        InetToolBar.this.requireReLayout = false;
                        InetToolBar.this.isWorking = true;
                        Rectangle rectangle = InetToolBar.this.toolbar.getBounds();
                        Component[] componentArray = InetToolBar.this.toolbar.getComponents();
                        for (n2 = componentArray.length - 1; n2 >= 0 && componentArray.length != 0; --n2) {
                            if (n2 > componentArray.length - 1) {
                                n2 = componentArray.length - 1;
                            }
                            if (!((object2 = componentArray[n2]) instanceof AbstractButton) && !(object2 instanceof JSeparator) || ((Component)object2).getIgnoreRepaint() || !((Component)object2).isVisible()) continue;
                            Rectangle rectangle2 = ((Component)object2).getBounds();
                            Dimension dimension = ((Component)object2).getPreferredSize();
                            if (rectangle2.x + dimension.width <= rectangle.width) break;
                            component = new JMenuItem();
                            ((Component)object2).setVisible(false);
                            if (object2 instanceof AbstractButton) {
                                AbstractButton abstractButton = (AbstractButton)object2;
                                if (abstractButton.getAction() != null) {
                                    ((AbstractButton)component).setAction(abstractButton.getAction());
                                } else {
                                    ((AbstractButton)component).addActionListener(InetToolBar.this.extendAction);
                                }
                                String string = abstractButton.getText();
                                ((AbstractButton)component).setActionCommand(abstractButton.getActionCommand());
                                ((AbstractButton)component).setText(string == null || string.length() == 0 ? (abstractButton.getToolTipText() == null || abstractButton.getToolTipText().length() == 0 ? " " : abstractButton.getToolTipText()) : string);
                                ((AbstractButton)component).setIcon(abstractButton.getIcon());
                                if (abstractButton.getToolTipText() != null && abstractButton.getToolTipText().length() > 0) {
                                    ((JComponent)component).setToolTipText(abstractButton.getToolTipText());
                                }
                            }
                            boolean bl2 = false;
                            for (JMenuItem jMenuItem : InetToolBar.this.extendMenus.keySet()) {
                                if (!((Component)InetToolBar.this.extendMenus.get(jMenuItem)).equals(object2)) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl2) continue;
                            InetToolBar.this.extendMenus.put(component, object2);
                            InetToolBar.this.expandPopup.add(component, 0);
                        }
                        n2 = 0;
                        object2 = componentArray;
                        int n3 = ((Component[])object2).length;
                        for (int i2 = 0; i2 < n3; ++i2) {
                            component = object2[i2];
                            if (!component.isVisible()) continue;
                            Rectangle rectangle3 = component.getBounds();
                            if (rectangle3.x > n2) {
                                n2 = rectangle3.x + rectangle3.width;
                                continue;
                            }
                            n2 += component.getWidth();
                        }
                        int n4 = InetToolBar.this.expandPopup.getComponentCount();
                        for (n3 = 0; n3 < n4 && InetToolBar.this.expandPopup.getComponentCount() != 0; ++n3) {
                            Component component2 = InetToolBar.this.expandPopup.getComponent(n3);
                            component = (Component)InetToolBar.this.extendMenus.get(component2);
                            if (component == null) continue;
                            Dimension dimension = component.getPreferredSize();
                            if (n2 + dimension.width >= rectangle.width) break;
                            component.setVisible(!component.getIgnoreRepaint());
                            InetToolBar.this.extendMenus.remove(component2);
                            ((JMenuItem)component2).setAction(null);
                            InetToolBar.this.expandPopup.remove(n3);
                            n3 = -1;
                            n4 = InetToolBar.this.expandPopup.getComponentCount();
                            n2 += dimension.width;
                        }
                        n4 = InetToolBar.this.expandPopup.getComponentCount();
                        for (n3 = 0; n3 < n4 && InetToolBar.this.expandPopup.getComponentCount() != 0; ++n3) {
                            Component component3 = InetToolBar.this.expandPopup.getComponent(n3);
                            component = (Component)InetToolBar.this.extendMenus.get(component3);
                            if (component == null || !component.isVisible()) continue;
                            InetToolBar.this.extendMenus.remove(component3);
                            ((JMenuItem)component3).setAction(null);
                            InetToolBar.this.expandPopup.remove(n3);
                            n3 = -1;
                            n4 = InetToolBar.this.expandPopup.getComponentCount();
                        }
                        int n5 = n3 = InetToolBar.this.expandPopup.getComponentCount() > 0 ? 1 : 0;
                        if (n3 != 0) {
                            n3 = 0;
                            for (Component component2 : InetToolBar.this.expandPopup.getComponents()) {
                                if (!component2.isVisible()) continue;
                                n3 = 1;
                                break;
                            }
                        }
                        if (n3 != 0) {
                            if (!InetToolBar.this.expandbutton.isVisible()) {
                                InetToolBar.this.add((Component)InetToolBar.this.expandbutton, "East");
                            }
                        } else if (InetToolBar.this.expandbutton.isVisible()) {
                            InetToolBar.this.remove(InetToolBar.this.expandbutton);
                        }
                        InetToolBar.this.expandbutton.setVisible(n3 != 0);
                        InetToolBar.this.isWorking = false;
                    }
                }
                InetToolBar.this.validate();
                InetToolBar.this.repaint();
            }
        });
    }

    public Dimension getPreferredSize() {
        if (!this.toolbar.isVisible()) {
            return new Dimension(0, 0);
        }
        Dimension dimension = super.getPreferredSize();
        if (dimension.width > 100) {
            dimension.width = 100;
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        if (!this.toolbar.isVisible()) {
            return new Dimension(0, 0);
        }
        Dimension dimension = super.getMinimumSize();
        if (dimension.width > 40) {
            dimension.width = 40;
        }
        return dimension;
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }
}

