/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.SyntaxDocument;
import com.inet.html.InetHtmlEditorKit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class LineNumTextPane
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private int areaWidth = 35;
    private Color areaColor = new Color(225, 225, 225);
    private boolean lineNumbersVisible = true;

    public LineNumTextPane() {
        this.init();
        this.setTabs(4);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public void setSize(Dimension dimension) {
        dimension.width = Math.max(dimension.width, this.getParent().getWidth());
        super.setSize(dimension);
    }

    public void setTabs(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n3 = fontMetrics.charWidth(' ');
        int n4 = n3 * n2;
        TabStop[] tabStopArray = new TabStop[10];
        for (int i2 = 0; i2 < tabStopArray.length; ++i2) {
            int n5 = i2 + 1;
            tabStopArray[i2] = new TabStop(n5 * n4);
        }
        TabSet tabSet = new TabSet(tabStopArray);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setTabSet(simpleAttributeSet, tabSet);
        int n6 = this.getDocument().getLength();
        this.getStyledDocument().setParagraphAttributes(0, n6, simpleAttributeSet, false);
    }

    private void init() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(76, InetHtmlEditorKit.SHORTCUT_KEY_MASK);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                LineNumTextPane.this.setLineNumbersVisible(!LineNumTextPane.this.isLineNumbersVisible());
            }
        };
        this.getInputMap().put(keyStroke, "lines");
        this.getActionMap().put("lines", abstractAction);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        if (this.isLineNumbersVisible()) {
            try {
                Rectangle rectangle2 = this.modelToView(0);
                if (rectangle.x <= rectangle2.x) {
                    rectangle.x = 0;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        super.scrollRectToVisible(rectangle);
    }

    protected EditorKit createDefaultEditorKit() {
        return new StyledEditorKit(){
            private static final long serialVersionUID = 1L;

            public Document createDefaultDocument() {
                SyntaxDocument syntaxDocument = new SyntaxDocument();
                return syntaxDocument;
            }

            public ViewFactory getViewFactory() {
                return new LnViewFactory();
            }
        };
    }

    public void setFont(Font font) {
        if (font != null) {
            int n2 = this.getFontMetrics(font).stringWidth("99999");
            this.areaWidth = Math.max(35, n2);
        }
        super.setFont(font);
    }

    public boolean isLineNumbersVisible() {
        return this.lineNumbersVisible;
    }

    public void setLineNumbersVisible(boolean bl2) {
        if (!this.isEditable()) {
            return;
        }
        boolean bl3 = this.lineNumbersVisible;
        this.lineNumbersVisible = bl2;
        if (this.lineNumbersVisible != bl3) {
            this.repaint();
        }
    }

    public Color getNumberAreaColor() {
        return this.areaColor;
    }

    public void setNumberAreaColor(Color color) {
        if (color != null) {
            this.areaColor = color;
        }
    }

    class LnParagraphView
    extends ParagraphView {
        public LnParagraphView(Element element) {
            super(element);
        }

        protected short getLeftInset() {
            return LineNumTextPane.this.isLineNumbersVisible() ? (short)(super.getLeftInset() + LineNumTextPane.this.areaWidth) : super.getLeftInset();
        }

        public void paint(Graphics graphics, Shape shape) {
            super.paint(graphics, shape);
            for (int i2 = 0; i2 < this.getViewCount(); ++i2) {
                Shape shape2 = this.getChildAllocation(i2, shape);
                this.paintChild(graphics, shape2.getBounds(), i2);
            }
        }

        public void paintChild(Graphics graphics, Rectangle rectangle, int n2) {
            super.paintChild(graphics, rectangle, n2);
            int n3 = this.getPreviousLineCount() + 1;
            if (LineNumTextPane.this.isLineNumbersVisible()) {
                graphics.setFont(graphics.getFont().deriveFont(0));
                if (n2 == 0) {
                    graphics.setColor(Color.black);
                    String string = String.valueOf(n3);
                    int n4 = graphics.getFontMetrics().stringWidth(string);
                    int n5 = LineNumTextPane.this.areaWidth - 5 - n4;
                    int n6 = rectangle.y + rectangle.height - 3;
                    graphics.drawString(string, n5, n6);
                } else if (this.getViewCount() - 1 == n2) {
                    graphics.setColor(Color.gray);
                    int n7 = graphics.getFontMetrics().stringWidth("0");
                    graphics.drawLine(LineNumTextPane.this.areaWidth - 6 - n7 / 2, rectangle.y, LineNumTextPane.this.areaWidth - 6 - n7 / 2, rectangle.y + rectangle.height / 2);
                    graphics.drawLine(LineNumTextPane.this.areaWidth - 6 - n7 / 2, rectangle.y + rectangle.height / 2, LineNumTextPane.this.areaWidth - 2 - n7 / 2, rectangle.y + rectangle.height / 2);
                } else {
                    graphics.setColor(Color.gray);
                    int n8 = graphics.getFontMetrics().stringWidth("0");
                    graphics.drawLine(LineNumTextPane.this.areaWidth - 6 - n8 / 2, rectangle.y, LineNumTextPane.this.areaWidth - 6 - n8 / 2, rectangle.y + rectangle.height);
                }
            }
        }

        public int getPreviousLineCount() {
            View view = this.getParent();
            int n2 = view.getViewCount();
            int n3 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                if (view.getView(n3) != this) continue;
                return n3;
            }
            return n2;
        }
    }

    class LnViewFactory
    implements ViewFactory {
        LnViewFactory() {
        }

        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new LabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new LnParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1){

                        public void paint(Graphics graphics, Shape shape) {
                            if (LineNumTextPane.this.isLineNumbersVisible()) {
                                graphics.setColor(LineNumTextPane.this.areaColor);
                                graphics.fillRect(0, 0, LineNumTextPane.this.areaWidth, this.getContainer().getHeight() - 1);
                            }
                            super.paint(graphics, shape);
                        }
                    };
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }
    }
}

