/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ScrollPopup
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private JScrollPane sp;
    private MenuPanel content;
    private WindowAdapter windowAdapter = new WindowAdapter(){

        public void windowIconified(WindowEvent windowEvent) {
            if (ScrollPopup.this.isVisible()) {
                ScrollPopup.this.setVisible(false);
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            if (ScrollPopup.this.isVisible()) {
                ScrollPopup.this.setVisible(false);
            }
        }
    };

    public ScrollPopup() {
        this(null);
    }

    public ScrollPopup(String string) {
        super(string);
        this.content = new MenuPanel();
        this.content.setLayout(new BoxLayout(this.content, 1));
        this.sp = new JScrollPane();
        this.sp.setBorder(null);
        this.sp.setViewportBorder(null);
        this.sp.setFocusable(false);
        this.sp.getVerticalScrollBar().setFocusable(false);
        Font font = new JMenuItem(" ").getFont();
        int n2 = 12;
        if (font != null) {
            n2 = font.getSize();
        }
        this.sp.getVerticalScrollBar().setUnitIncrement(n2);
        this.sp.setViewportView(this.content);
        super.add(this.sp);
    }

    public void setMenuPanelBackground(Color color) {
        this.content.setBackground(color);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getInvoker() != null) {
            GraphicsConfiguration graphicsConfiguration = this.getInvoker().getGraphicsConfiguration();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            Rectangle rectangle = graphicsConfiguration.getBounds();
            Point point = this.getInvoker().getLocationOnScreen();
            Component component = this.getInvoker();
            int n2 = component instanceof AbstractButton ? this.getInvoker().getHeight() : 0;
            int n3 = rectangle.height - n2 - point.y - insets.bottom - insets.top - 2;
            if (n3 < 50) {
                n3 = 50;
            }
            if (dimension.height > n3) {
                dimension.height = n3;
                dimension.width += this.sp.getVerticalScrollBar().getMinimumSize().width;
            }
        }
        return dimension;
    }

    public void insert(Component component, int n2) {
        this.add(component, n2);
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = super.createActionComponent(action);
        jMenuItem.setAction(action);
        return this.add(jMenuItem);
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        this.content.add(jMenuItem);
        return jMenuItem;
    }

    public Component add(Component component, int n2) {
        this.content.add(component, n2);
        return component;
    }

    public void show(Component component, int n2, int n3) {
        Window window;
        if (component != null && (window = SwingUtilities.getWindowAncestor(component)) != null) {
            window.addWindowListener(this.windowAdapter);
        }
        int n4 = UIManager.getInt("Menu.submenuPopupOffsetX");
        int n5 = UIManager.getInt("Menu.submenuPopupOffsetY");
        if (n3 < n5) {
            n3 = n5;
        }
        super.show(component, n2, n3);
        int n6 = this.content.getPreferredSize().width;
        n6 += n4;
        for (Component component2 : this.content.getComponents()) {
            if (!(component2 instanceof JMenu)) continue;
            ((JMenu)component2).setMenuLocation(n6, n5);
        }
    }

    public void setVisible(boolean bl2) {
        Window window;
        Component component = this.getInvoker();
        if (component != null && !bl2 && (window = SwingUtilities.getWindowAncestor(component)) != null) {
            window.removeWindowListener(this.windowAdapter);
        }
        super.setVisible(bl2);
    }

    public void addSeparator() {
        this.content.add(new JSeparator());
    }

    public void addSeparatorIfProper() {
        if (this.content.getComponentCount() != 0 && !(this.content.getComponent(this.content.getComponentCount() - 1) instanceof JSeparator)) {
            this.addSeparator();
        }
    }

    public Component add(Component component) {
        this.content.add(component);
        return component;
    }

    public MenuElement[] getSubElements() {
        return this.content.getSubElements();
    }

    public void removeAll() {
        this.content.removeAll();
    }

    public Component getComponent() {
        return this.content;
    }

    private class MenuPanel
    extends JPanel
    implements MenuElement {
        private static final long serialVersionUID = 1L;

        private MenuPanel() {
        }

        public Component getComponent() {
            return this;
        }

        public MenuElement[] getSubElements() {
            ArrayList<MenuElement> arrayList = new ArrayList<MenuElement>();
            for (int i2 = 0; i2 < ScrollPopup.this.content.getComponentCount(); ++i2) {
                Component component = ScrollPopup.this.content.getComponent(i2);
                if (!(component instanceof MenuElement)) continue;
                MenuElement menuElement = (MenuElement)((Object)component);
                arrayList.add(menuElement);
            }
            return arrayList.toArray(new MenuElement[arrayList.size()]);
        }

        public void menuSelectionChanged(boolean bl2) {
        }

        public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        }

        public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        }
    }
}

