/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.BaseEditor;
import com.inet.editor.HtmlEditorUtils;
import com.inet.editor.SourceCodeDialog;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;

public class SourceCodeAction
extends HTMLEditorKit.HTMLTextAction {
    private static final long serialVersionUID = 1L;
    private final BaseEditor editor;

    public SourceCodeAction(BaseEditor baseEditor) {
        super("sourcecode");
        this.editor = baseEditor;
        this.putValue("ShortDescription", HtmlEditorUtils.getTranslation("sourcecode"));
        this.putValue("Name", HtmlEditorUtils.getTranslation("sourcecode"));
        this.putValue("SmallIcon", HtmlEditorUtils.getResourceImage("sourcecode.gif"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, InetHtmlEditorKit.SHORTCUT_KEY_MASK));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Component) {
            Window window;
            Component component;
            Container container;
            Component component2 = (Component)object;
            JTextComponent jTextComponent = null;
            if (component2 instanceof Container) {
                container = (Container)component2;
                while (container != null && !(container instanceof BaseEditor) && !(container instanceof JTextComponent)) {
                    if (container instanceof JPopupMenu) {
                        component = ((JPopupMenu)container).getInvoker();
                        if (component instanceof Container) {
                            container = component;
                            continue;
                        }
                        container = null;
                        continue;
                    }
                    if (container.getParent() == null) break;
                    container = container.getParent();
                }
                if (container != null && container instanceof BaseEditor) {
                    jTextComponent = ((BaseEditor)container).getEditor();
                }
                if (container != null && container instanceof JTextComponent) {
                    jTextComponent = (JTextComponent)container;
                }
            }
            if (jTextComponent == null) {
                jTextComponent = this.getEditor(actionEvent);
            }
            if (jTextComponent == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
            container = null;
            component = SwingUtilities.getWindowAncestor(jTextComponent);
            if (component instanceof JFrame) {
                window = (JFrame)component;
                container = new SourceCodeDialog((JFrame)window);
            }
            if (component instanceof JDialog) {
                window = (JDialog)component;
                container = new SourceCodeDialog((JDialog)window);
            }
            if (component instanceof Frame) {
                window = (Frame)component;
                container = new SourceCodeDialog((Frame)window);
            }
            if (container != null) {
                ((SourceCodeDialog)container).setEditor(jTextComponent);
                jTextComponent.getDocument().putProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE, new Integer(4));
                ((SourceCodeDialog)container).setSourceCode(jTextComponent.getText());
                jTextComponent.getDocument().putProperty(InetHtmlDocument.PROPERTY_INDENT_SPACE, new Integer(0));
                ((SourceCodeDialog)container).showDialog();
            }
        }
    }

    public boolean isEnabled() {
        return this.editor != null && this.editor.isHtml();
    }
}

