/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.html.utils.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SpellCheckerProxy {
    private static final State state = new State();

    public static boolean isSpellCheckerAvailable() {
        return state.spellCheckerClass != null;
    }

    static void notifyDictionaryLoaded() {
        if (state.initListener == null) {
            return;
        }
        state.initListener = null;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean bl2 = SpellCheckerProxy.isDictionaryLoaded();
                ArrayList arrayList = state.pendingActivations;
                synchronized (arrayList) {
                    for (WeakReference weakReference : state.pendingActivations) {
                        ActivationCallback activationCallback = (ActivationCallback)weakReference.get();
                        if (activationCallback == null) continue;
                        activationCallback.setActive(bl2);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate(ActivationCallback activationCallback) {
        if (SpellCheckerProxy.isSpellCheckerAvailable()) {
            ArrayList arrayList = state.pendingActivations;
            synchronized (arrayList) {
                if (SpellCheckerProxy.getCurrentLocale() != null) {
                    activationCallback.setActive(true);
                } else {
                    state.pendingActivations.add(new WeakReference<ActivationCallback>(activationCallback));
                    activationCallback.setActive(false);
                }
            }
        } else {
            activationCallback.setActive(false);
        }
    }

    public static void enableAutoSpell(JTextComponent jTextComponent, boolean bl2) {
        SpellCheckerProxy.state.call("enableAutoSpell", new Object[]{jTextComponent, bl2});
    }

    public static Locale getCurrentLocale() {
        Object object = SpellCheckerProxy.state.call("getCurrentLocale", new Object[0]);
        if (object instanceof Locale) {
            return (Locale)object;
        }
        return null;
    }

    public static String getApplicationName() {
        Object object = SpellCheckerProxy.state.call("getApplicationName", new Object[0]);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static JMenu createCheckerMenu() {
        Object object = SpellCheckerProxy.state.call("createCheckerMenu", new Object[0]);
        if (object instanceof JMenu) {
            return (JMenu)object;
        }
        return null;
    }

    public static boolean isDictionaryLoaded() {
        Object object = SpellCheckerProxy.state.call("isDictionaryLoaded", new Object[0]);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public static JMenu createLanguagesMenu() {
        Object object = SpellCheckerProxy.state.call("createLanguagesMenu", new Object[0]);
        if (object instanceof JMenu) {
            return (JMenu)object;
        }
        return null;
    }

    public static void enableShortKey(JTextComponent jTextComponent, boolean bl2) {
        SpellCheckerProxy.state.call("enableShortKey", new Object[]{jTextComponent, bl2});
    }

    public static void registerDictionaries(URL uRL, String string, String string2) {
        SpellCheckerProxy.state.call("registerDictionaries", new Object[]{uRL, string, string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Thread thread = new Thread(new Loader(state));
        thread.setName("SpellChecker loader");
        thread.start();
        try {
            State state = SpellCheckerProxy.state;
            synchronized (state) {
                SpellCheckerProxy.state.wait(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class State {
        private Class<?> spellCheckerClass;
        private Object initListener = null;
        private ArrayList<WeakReference<ActivationCallback>> pendingActivations = new ArrayList();

        private State() {
        }

        private Object call(String string, Object ... objectArray) {
            block11: {
                if (this.spellCheckerClass != null) {
                    Object object = null;
                    try {
                        if (objectArray != null && objectArray.length > 0) {
                            Class[] classArray = new Class[objectArray.length];
                            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                                classArray[i2] = objectArray[i2].getClass();
                                if (classArray[i2] == Boolean.class) {
                                    classArray[i2] = Boolean.TYPE;
                                }
                                if (!(objectArray[i2] instanceof JTextComponent)) continue;
                                classArray[i2] = JTextComponent.class;
                            }
                            Method method = this.spellCheckerClass.getMethod(string, classArray);
                            object = method.invoke(null, objectArray);
                        } else {
                            Method method = this.spellCheckerClass.getMethod(string, new Class[0]);
                            object = method.invoke(null, new Object[0]);
                        }
                        return object;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (objectArray == null || objectArray.length <= 0) break block11;
                        try {
                            Method[] methodArray;
                            for (Method method : methodArray = this.spellCheckerClass.getMethods()) {
                                if (!method.getName().equals(string)) continue;
                                object = method.invoke(null, objectArray);
                                return object;
                            }
                        }
                        catch (Exception exception) {
                            System.out.println(noSuchMethodException);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
            }
            return null;
        }
    }

    private static class Loader
    implements Runnable {
        private State loaderState;

        public Loader(State state) {
            this.loaderState = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class<?> clazz;
            block7: {
                URL uRL = null;
                try {
                    this.loaderState.spellCheckerClass = Class.forName("com.inet.jortho.SpellChecker");
                    try {
                        uRL = new URL("file:dictionary_en.ortho");
                        clazz = uRL.openStream();
                        ((InputStream)((Object)clazz)).close();
                    }
                    catch (IOException iOException) {
                        URL uRL2 = this.loaderState.spellCheckerClass.getProtectionDomain().getCodeSource().getLocation();
                        uRL = new URL(uRL2, "dictionary_en.ortho");
                        InputStream inputStream = uRL.openStream();
                        inputStream.close();
                    }
                    clazz = Class.forName("com.inet.editor.DictionaryListener");
                    this.loaderState.initListener = clazz.newInstance();
                    this.loaderState.call("addLanguageChangeLister", new Object[]{this.loaderState.initListener});
                    this.loaderState.call("registerDictionaries", new Object[]{uRL, "en", "en"});
                }
                catch (Exception exception) {
                    if (!Logger.doesLog(3)) break block7;
                    Logger.info("Optional JOrtho spell checker not found, spell checking is disabled.");
                    if (uRL == null) break block7;
                    Logger.info("Dictionairy reference is: " + uRL);
                }
            }
            clazz = this.loaderState;
            synchronized (clazz) {
                this.loaderState.notifyAll();
            }
        }
    }

    public static interface ActivationCallback {
        public void setActive(boolean var1);
    }
}

