/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.html.css.HTML;
import java.awt.Color;
import java.util.HashSet;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class SyntaxDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = 1L;
    private Element rootElement = this.getDefaultRootElement();
    private boolean multiLineComment;
    private MutableAttributeSet normal;
    private MutableAttributeSet keyword;
    private MutableAttributeSet attribute;
    private MutableAttributeSet comment;
    private MutableAttributeSet quote;
    private HashSet<String> keywords;
    private HashSet<String> attributes;

    public SyntaxDocument() {
        String string;
        this.putProperty("__EndOfLine__", "\n");
        this.normal = new SimpleAttributeSet();
        StyleConstants.setForeground(this.normal, Color.black);
        this.comment = new SimpleAttributeSet();
        StyleConstants.setForeground(this.comment, Color.gray);
        StyleConstants.setItalic(this.comment, true);
        this.keyword = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword, new Color(91, 9, 112));
        StyleConstants.setBold(this.keyword, true);
        this.attribute = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attribute, Color.blue);
        this.quote = new SimpleAttributeSet();
        StyleConstants.setForeground(this.quote, Color.red);
        this.keywords = new HashSet();
        for (HTML.Tag enum_ : HTML.Tag.values()) {
            string = enum_.toString().toLowerCase();
            if (string.equals("content")) continue;
            this.keywords.add(string);
        }
        this.attributes = new HashSet();
        for (Enum enum_ : HTML.Attribute.values()) {
            string = ((HTML.Attribute)enum_).toString().toLowerCase();
            this.attributes.add(string);
        }
    }

    public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        super.insertString(n2, string, attributeSet);
        this.processChangedLines(n2, string.length());
    }

    public void remove(int n2, int n3) throws BadLocationException {
        super.remove(n2, n3);
        this.processChangedLines(n2, 0);
    }

    public void processChangedLines(int n2, int n3) throws BadLocationException {
        String string = this.getText(0, this.getLength());
        int n4 = this.rootElement.getElementIndex(n2);
        int n5 = this.rootElement.getElementIndex(n2 + n3);
        this.setMultiLineComment(this.commentLinesBefore(string, n4));
        for (int i2 = n4; i2 <= n5; ++i2) {
            this.applyHighlighting(string, i2);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(string, n5);
        } else {
            this.highlightLinesAfter(string, n5);
        }
    }

    private boolean commentLinesBefore(String string, int n2) {
        int n3 = this.rootElement.getElement(n2).getStartOffset();
        int n4 = this.lastIndexOf(string, this.getStartDelimiter(), n3 - 2);
        if (n4 < 0) {
            return false;
        }
        int n5 = this.indexOf(string, this.getEndDelimiter(), n4);
        if (n5 < n3 & n5 != -1) {
            return false;
        }
        this.setCharacterAttributes(n4, n3 - n4 + 1, this.comment, false);
        return true;
    }

    private void commentLinesAfter(String string, int n2) {
        int n3 = this.rootElement.getElement(n2).getEndOffset();
        int n4 = this.indexOf(string, this.getEndDelimiter(), n3);
        if (n4 < 0) {
            return;
        }
        int n5 = this.lastIndexOf(string, this.getStartDelimiter(), n4);
        if (n5 < 0 || n5 <= n3) {
            this.setCharacterAttributes(n3, n4 - n3 + 1, this.comment, false);
        }
    }

    private void highlightLinesAfter(String string, int n2) throws BadLocationException {
        int n3;
        int n4 = this.rootElement.getElement(n2).getEndOffset();
        int n5 = this.indexOf(string, this.getStartDelimiter(), n4);
        int n6 = this.indexOf(string, this.getEndDelimiter(), n4);
        if (n5 < 0) {
            n5 = string.length();
        }
        if (n6 < 0) {
            n6 = string.length();
        }
        if ((n3 = Math.min(n5, n6)) < n4) {
            return;
        }
        int n7 = this.rootElement.getElementIndex(n3);
        for (int i2 = n2 + 1; i2 < n7; ++i2) {
            Element element = this.rootElement.getElement(i2);
            Element element2 = this.getCharacterElement(element.getStartOffset());
            AttributeSet attributeSet = element2.getAttributes();
            if (!attributeSet.isEqual(this.comment)) continue;
            this.applyHighlighting(string, i2);
        }
    }

    private void applyHighlighting(String string, int n2) throws BadLocationException {
        int n3 = this.rootElement.getElement(n2).getStartOffset();
        int n4 = this.rootElement.getElement(n2).getEndOffset() - 1;
        int n5 = n4 - n3;
        int n6 = string.length();
        if (n4 >= n6) {
            n4 = n6 - 1;
        }
        if (this.endingMultiLineComment(string, n3, n4) || this.isMultiLineComment() || this.startingMultiLineComment(string, n3, n4)) {
            this.setCharacterAttributes(n3, n4 - n3 + 1, this.comment, false);
            return;
        }
        this.setCharacterAttributes(n3, n5, this.normal, true);
        this.checkForTokens(string, n3, n4);
    }

    private boolean startingMultiLineComment(String string, int n2, int n3) throws BadLocationException {
        int n4 = this.indexOf(string, this.getStartDelimiter(), n2);
        if (n4 < 0 || n4 > n3) {
            return false;
        }
        this.setMultiLineComment(true);
        return true;
    }

    private boolean endingMultiLineComment(String string, int n2, int n3) throws BadLocationException {
        int n4 = this.indexOf(string, this.getEndDelimiter(), n2);
        if (n4 < 0 || n4 > n3) {
            return false;
        }
        this.setMultiLineComment(false);
        return true;
    }

    private boolean isMultiLineComment() {
        return this.multiLineComment;
    }

    private void setMultiLineComment(boolean bl2) {
        this.multiLineComment = bl2;
    }

    private void checkForTokens(String string, int n2, int n3) {
        while (n2 <= n3) {
            while (this.isDelimiter(string.substring(n2, n2 + 1))) {
                if (n2 < n3) {
                    ++n2;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(string.substring(n2, n2 + 1))) {
                n2 = this.getQuoteToken(string, n2, n3);
                continue;
            }
            n2 = this.getOtherToken(string, n2, n3);
        }
    }

    private int getQuoteToken(String string, int n2, int n3) {
        String string2 = string.substring(n2, n2 + 1);
        String string3 = this.getEscapeString(string2);
        int n4 = n2;
        int n5 = string.indexOf(string3, n4 + 1);
        while (n5 > -1 && n5 < n3) {
            n4 = n5 + 1;
            n5 = string.indexOf(string3, n4);
        }
        n5 = string.indexOf(string2, n4 + 1);
        n4 = n5 < 0 || n5 > n3 ? n3 : n5;
        this.setCharacterAttributes(n2, n4 - n2 + 1, this.quote, false);
        return n4 + 1;
    }

    private int getOtherToken(String string, int n2, int n3) {
        int n4;
        for (n4 = n2 + 1; n4 <= n3 && !this.isDelimiter(string.substring(n4, n4 + 1)); ++n4) {
        }
        String string2 = string.substring(n2, n4);
        if (this.isKeyword(string2)) {
            this.setCharacterAttributes(n2, n4 - n2, this.keyword, false);
        } else if (this.isAttribute(string2)) {
            this.setCharacterAttributes(n2, n4 - n2, this.attribute, false);
        }
        return n4 + 1;
    }

    private int indexOf(String string, String string2, int n2) {
        String string3;
        int n3;
        while ((n3 = string.indexOf(string2, n2)) != -1 && !(string3 = this.getLine(string, n3).trim()).startsWith(string2) && !string3.endsWith(string2)) {
            n2 = n3 + 1;
        }
        return n3;
    }

    private int lastIndexOf(String string, String string2, int n2) {
        String string3;
        int n3;
        while ((n3 = string.lastIndexOf(string2, n2)) != -1 && !(string3 = this.getLine(string, n3).trim()).startsWith(string2) && !string3.endsWith(string2)) {
            n2 = n3 - 1;
        }
        return n3;
    }

    private String getLine(String string, int n2) {
        int n3 = this.rootElement.getElementIndex(n2);
        Element element = this.rootElement.getElement(n3);
        int n4 = element.getStartOffset();
        int n5 = element.getEndOffset();
        return string.substring(n4, n5 - 1);
    }

    protected boolean isDelimiter(String string) {
        String string2 = ";{}()[]+/%<=>!&|^~*";
        return Character.isWhitespace(string.charAt(0)) || string2.indexOf(string) != -1;
    }

    protected boolean isQuoteDelimiter(String string) {
        String string2 = "\"'";
        return string2.indexOf(string) >= 0;
    }

    protected boolean isKeyword(String string) {
        return this.keywords.contains(string);
    }

    protected boolean isAttribute(String string) {
        return this.attributes.contains(string);
    }

    protected String getStartDelimiter() {
        return "<!--";
    }

    protected String getEndDelimiter() {
        return "-->";
    }

    protected String getEscapeString(String string) {
        return "\\" + string;
    }
}

