/*
 * Decompiled with CFR 0.152.
 */
package com.inet.help.model;

import com.inet.help.model.b;
import com.inet.report.SkipDotNetCapitalizing;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SkipDotNetCapitalizing
public class HelpPage
implements Serializable {
    private String key;
    private String url;
    private String title;
    private List<HelpPage> childPages = new ArrayList<HelpPage>();
    private HelpPage parentPage;
    private transient Map<String, HelpPage> map;

    public HelpPage(String string, String string2, String string3) {
        this.key = string;
        this.url = string2;
        this.title = string3;
    }

    public HelpPage() {
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void addPage(HelpPage helpPage) throws b {
        this.addPage(helpPage, this.childPages.size());
    }

    public void addPage(HelpPage helpPage, int n2) throws b {
        this.childPages.add(n2, helpPage);
        helpPage.setParentPage(this);
        if (this.map != null) {
            helpPage.addToMapWithChildren(this.map);
        }
    }

    public List<HelpPage> getChildPages() {
        return this.childPages;
    }

    public String getKey() {
        return this.key;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getTitle() {
        return this.title;
    }

    private void setParentPage(HelpPage helpPage) {
        this.parentPage = helpPage;
    }

    public HelpPage getParentPage() {
        return this.parentPage;
    }

    public void addToMapWithChildren(Map<String, HelpPage> map) throws b {
        if (this.map != null) {
            throw new IllegalStateException("Cannot add the same Page more than once! Page:" + this.getKey());
        }
        if (map.containsKey(this.key)) {
            this.map = map;
            if (this.getChildPages().isEmpty()) {
                throw new b("A page with the key '" + this.key + "' already exists and it does not have further children!");
            }
            HelpPage helpPage = map.get(this.key);
            for (HelpPage helpPage2 : this.getChildPages()) {
                helpPage.addPage(helpPage2);
            }
            if (this.parentPage != null) {
                this.parentPage.getChildPages().remove(this);
            }
            return;
        }
        this.map = map;
        map.put(this.key, this);
        for (HelpPage helpPage : this.getChildPages()) {
            helpPage.addToMapWithChildren(map);
        }
    }

    public String toString() {
        return "@" + this.getKey() + "|" + this.getTitle() + "|" + this.getChildPages().size() + "|" + this.getUrl();
    }
}

