/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.html.CssDocument;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocumentIterator;
import com.inet.html.InetHtmlParser;
import com.inet.html.InetHtmlWriter;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.Styles;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.event.AttributeUndoableEdit;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.image.ImageCache;
import com.inet.html.parser.DocType;
import com.inet.html.parser.converter.Background;
import com.inet.html.parser.converter.BorderStyleValue;
import com.inet.html.parser.converter.ClassValue;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.FontStyle;
import com.inet.html.parser.converter.FontWeight;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.Position;
import com.inet.html.parser.converter.SingleAttributeValue;
import com.inet.html.utils.DocumentImage;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.EmbeddedImage;
import com.inet.html.utils.InetStreamHandler;
import com.inet.html.utils.Logger;
import com.inet.html.utils.URLUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.management.StringValueExp;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetHtmlDocument
extends HTMLDocument
implements CssDocument {
    public static final int MAJOR_VERSION = 1;
    private StyleResolver styleResolver;
    public static final Object FLAG_INIT = StyleConstants.ModelAttribute;
    @Deprecated
    public static final int DOCTYPE_UNKNOWN = 0;
    @Deprecated
    public static final int DOCTYPE_HTML = 1;
    @Deprecated
    public static final int DOCTYPE_XHTML = 2;
    @Deprecated
    public static final int DOCTYPE_STRICT = 3;
    @Deprecated
    public static final int DOCTYPE_TRANSIENT = 4;
    @Deprecated
    public static final int DOCTYPE_FRAMESET = 5;
    public static final Object PROPERTY_INDENT_SPACE = "IndentSpace";
    public static final Object PROPERTY_WRITE_HIERARCHY = "WriteHierarchy";
    public static final Object PROPERTY_CONFIGURATION = "Configuration";
    public static final Object PROPERTY_DEFAULT_FONT = "DefaultFont";
    public static final Object PROPERTY_DROP_UNKNOWN_STYLES = "DropUnknownStyles";
    public static final Object PROPERTY_MEDIA = "RenderMedia";
    public static final String MEDIA_SCREEN = "screen";
    public static final String MEDIA_PRINT = "print";
    public static final Object PROPERTY_PERSISTENT_STYLES = "PersistentStyles";
    public static final Object PROPERTY_DEFAULT_STYLE_CLASS = "DefaultStyleClass";
    public static final Object PROPERTY_IGNORE_NAMESPACES = "IgnoreNameSpaces";
    public static final Object PROPERTY_TIMEOUT = "ParserTimeout";
    public static final Object PROPERTY_TAB_WIDTH = "TabWidth";
    public static final Object PROPERTY_BREAK_MODE = "BreakMode";
    public static final Object BREAK_MODE_OVERFLOW = "BreakModeOverflow";
    public static final Object BREAK_MODE_WORDBREAK = "BreakModeWordbreak";
    public static final Object BREAK_MODE_WORDBREAKINLINE = "BreakModeWordbreakInline";
    public static final Object PROPERTY_USE_FONT_FALLBACK = "UseFontFallback";
    private DocType docType = new DocType();
    private boolean eventsLocked = false;
    private boolean allowTableEdit = false;
    private String defaultStyleName = null;
    private InetHtmlConfiguration configuration = InetHtmlConfiguration.getMailEditorConfig();
    private Dictionary<Object, Object> documentProperties;
    private int siteCount = 0;
    private int revision = 0;
    private static boolean dhInit = false;
    private static final String[][] PATH = new String[][]{{"com.inet.report.layout.richhtml", "com.inet.report.layout.richhtml", "com.inet.report.renderer.thread"}, {"com.inet.designer.welcome", "com.inet.designer.welcome", "com.inet.designer.", "com.inet.designer."}, {"com.inet.designer.welcome", "com.inet.designer.Startup", "com.inet.designer.Main"}, {"com.inet.designer.Startup", "com.inet.designer.Startup.main", "com.inet.designer.Main.main"}, {"com.inet.designer.dialog.formulaeditor", "com.inet.designer.AbstractDesignerDataModel", "com.inet.designer.fieldbrowser.FieldsBrowserActions"}, {"com.inet.designer.", "com.inet.designer.Startup.startEmbedded"}, {"com.inet.helpdesk.components.editor", "com.inet.helpdesk.dialogs", "inet"}, {"srv.ListeningServerSocket.init", "srv.ListeningServerSocket", "srv.ServerInterface"}, {"javax.help.JHelpContentViewer", "javax.help.DefaultHelpBroker", "com.inet.designer.MessageAdapter"}, {"javax.help.JHelpContentViewer", "javax.help.DefaultHelpBroker", "com.inet.designer.actions.menu"}, {"com.inet.ccquality.InetHtmlIndexerKit.parse", "com.sun.java.help.search.Indexer.compile", "com.inet.ccquality.InetIndexer.main"}, {"com.izforge.izpack.installer.HelpTab", "com.izforge.izpack.installer.HelpBrowser", "com.izforge.izpack.installer.InstallerFrame"}, {"com.inet.setup.panels.AbstractPanel", "com.inet.setup.panels.CCLicensePanel", "com.izforge.izpack.installer.InstallerFrame"}, {"com.izforge.izpack.panels.CCLicensePanel", "com.izforge.izpack.installer.InstallerFrame", "com.izforge.izpack.installer.GUIInstaller"}, {"com.izforge.izpack.panels.SummaryPanel", "com.izforge.izpack.installer.InstallerFrame", "com.izforge.izpack.installer.GUIInstaller"}, {"mgr.SrvMgr.loadHelpSystem", "mgr.SrvMgr.init", "mgr.SrvMgr.<init>"}, {"at javax.swing.JEditorPane.setContentType", "com.izforge.izpack.uninstaller.UninstallerFrame.buildUninstallerScreen", "com.izforge.izpack.uninstaller.UninstallerFrame.buildGUI"}, {"at com.inet.designer.Startup.preInit", "at com.inet.designer.Startup", "at java.lang.Thread.run"}, {"com.inet.helpdesk.help.HelpBrowser.showHelpPage", "inet.HelpDeskClient.showHelp(HelpDeskClient.java", "com.inet.helpdesk.auth.LoginBox"}, {"com.inet.helpdesk.util.UtilFunctions.convertHtml2OptionPaneText", "inet.HelpDeskClient.loadStartInfo", "com.inet.helpdesk.db.CachedDataDisposer.initValidators"}, {"javax.help.JHelpContentViewer.setUI", "javax.help.WindowPresentation.createJHelp", "com.inet.report.configuration.util.HelpUtils.showHelp", "com.inet.report.configuration.view.MainViewImpl"}, {"com.inet.report.encode.html.", "com.inet.report.renderer.doc.controller.", "com.inet.report.renderer.doc.controller.", ".run"}};

    public InetHtmlDocument() {
        if (this.styleResolver == null) {
            this.styleResolver = new StyleResolver();
        }
        AttributeFinder<Background> attributeFinder = AttributeFinder.BACKGROUND;
        this.fillAttributes(this.getDefaultRootElement());
        if (!dhInit) {
            dhInit = this.isInitialized();
        }
    }

    public static final boolean isReady() {
        return dhInit;
    }

    private boolean isInitialized() {
        Object object;
        try {
            object = this.getClass().getResource("").toString().toLowerCase();
            if (((String)object).startsWith("jar:http://www.inetsoftware.de/_media/other-products/jwebengine/samples/")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if ("true".equalsIgnoreCase(System.getProperty("com.inet.html.dump"))) {
                object = new PrintWriter(new File("./JWebEngine.dump"));
                new Throwable().printStackTrace((PrintWriter)object);
                ((PrintWriter)object).close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter((OutputStream)object);
        new Throwable().printStackTrace(printWriter);
        printWriter.flush();
        String string = ((ByteArrayOutputStream)object).toString();
        block4: for (int i2 = 0; i2 < PATH.length; ++i2) {
            String[] stringArray = PATH[i2];
            int n2 = -1;
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                String string2 = stringArray[i3];
                int n3 = string.indexOf(string2, n2 + 1);
                if (n3 < 0) continue block4;
                n2 = n3;
            }
            return true;
        }
        return false;
    }

    @Override
    public StyleResolver getStyleResolver() {
        return this.styleResolver;
    }

    public boolean isLocked() {
        return this.getCurrentWriter() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader reader, int n2) throws IOException, BadLocationException {
        Serializable serializable;
        AbstractDocument.BranchElement branchElement;
        boolean bl2;
        InetHtmlParser inetHtmlParser = new InetHtmlParser();
        int n3 = this.getModelLength();
        boolean bl3 = bl2 = n3 > 1;
        if (bl2) {
            int n4 = n2 > 0 ? n2 - 1 : 0;
            branchElement = (AbstractDocument.BranchElement)this.getParagraphElement(n4);
        } else {
            branchElement = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        }
        EventList eventList = new EventList();
        Element[] elementArray = ElementUtils.getAllChildren(branchElement);
        Element[] elementArray2 = null;
        boolean bl4 = false;
        try {
            this.writeLock();
            if (!bl2) {
                int n5 = branchElement.getChildCount();
                branchElement.replace(0, n5, new Element[0]);
                eventList.getEventFor(branchElement, 0, elementArray, new Element[0]);
                eventList.addEvent(this.getContent().remove(0, n3));
                ++this.siteCount;
            }
            inetHtmlParser.parse(reader, this, branchElement, n2, eventList, false, null);
            elementArray2 = ElementUtils.getAllChildren(branchElement);
            if (this.getModelLength() == 0) {
                eventList.addEvent(this.getContent().insertString(0, "\n"));
                AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)branchElement.getElement(0);
                if (branchElement2 != null) {
                    serializable = new SimpleAttributeSet();
                    serializable.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                    serializable.addAttribute("CR", Boolean.TRUE);
                    Element[] elementArray3 = new Element[]{this.createLeafElement((Element)branchElement2, (AttributeSet)((Object)serializable), 0, 1)};
                    this.replaceElements(ElementUtils.getChildren(branchElement2, 0, 1), elementArray3, eventList);
                    eventList.getEventFor(branchElement, 0, new Element[0], ElementUtils.getChildren(branchElement, 0, 1));
                } else {
                    this.clearBody(eventList);
                }
            }
            bl4 = true;
        }
        finally {
            if (!bl4) {
                branchElement.replace(0, branchElement.getElementCount(), elementArray);
            }
            this.styleResolver.optimize();
            this.writeUnlock();
        }
        ExtendedDocuementEvent extendedDocuementEvent = null;
        if (bl2) {
            int n6 = elementArray2[0].getStartOffset();
            int n7 = elementArray2[elementArray2.length - 1].getEndOffset() - n6;
            extendedDocuementEvent = new ExtendedDocuementEvent(n6, n7, DocumentEvent.EventType.INSERT, this);
            eventList.getEventFor(branchElement, 0, elementArray, elementArray2);
            try {
                this.writeLock();
                this.splice(branchElement, n2, eventList, false);
                this.splice(branchElement, n2 + (this.getModelLength() - n7), eventList, false);
            }
            finally {
                this.writeUnlock();
            }
        } else {
            extendedDocuementEvent = new ExtendedDocuementEvent(0, this.getModelLength(), DocumentEvent.EventType.CHANGE, this);
        }
        eventList.fillEvent(extendedDocuementEvent);
        extendedDocuementEvent.end();
        if (bl2) {
            this.fireInsertUpdate(extendedDocuementEvent);
        } else {
            this.fireChangedUpdate(extendedDocuementEvent);
        }
        serializable = new UndoableEditEvent(this, extendedDocuementEvent);
        this.fireUndoableEditUpdate((UndoableEditEvent)serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractDocument.DefaultDocumentEvent parseLight(Reader reader, int n2, Element element, Element element2, boolean bl2, boolean bl3, EventList eventList, Object object) throws IOException, BadLocationException {
        Object object2;
        int n3;
        InetHtmlParser inetHtmlParser = new InetHtmlParser();
        Element element3 = this.getDefaultRootElement();
        if (element == null && (element = ElementUtils.getLeafAt(element3, n2)).isLeaf()) {
            element = element.getParentElement();
        }
        int n4 = this.getModelLength();
        int n5 = n2;
        int n6 = 0;
        int n7 = n3 = element2 == null ? element.getElementIndex(n2) : ElementUtils.getChildIndex(element, element2);
        if (element2 != null) {
            if (bl2) {
                n5 = element2.getStartOffset();
                n6 = 0;
            } else {
                n5 = element2.getEndOffset();
                ++n3;
                n6 = 1;
            }
        }
        int n8 = element.getElementCount();
        if (!bl3 && this.getParagraphElement(n5 + n6) == this.getParagraphElement(n5) && (object2 = ElementUtils.getLeafAt(element, n5 + n6)) != null) {
            element = object2.getParentElement();
            n3 = element.getElementIndex(n2);
            n8 = element.getElementCount();
        }
        object2 = new EventList(eventList);
        try {
            this.writeLock();
            inetHtmlParser.parse(reader, this, (AbstractDocument.BranchElement)element, n2, (EventList)object2, false, object);
        }
        catch (Exception exception) {
            if (Logger.doesLog(1)) {
                Logger.error(exception);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.styleResolver.optimize();
        int n9 = element.getElementCount() - n8;
        if (n9 == 0) {
            return null;
        }
        int n10 = this.getModelLength() - n4;
        int n11 = n5 + n10;
        Element[] elementArray = null;
        if (element2 != null) {
            elementArray = new Element[n9];
            System.arraycopy(ElementUtils.getChildren(element, 0, element.getElementCount()), n3, elementArray, 0, n9);
            ((EventList)object2).getEventFor(element, n3, new Element[0], elementArray);
        }
        element = this.getParagraphElement(n11, element3);
        this.splice(element, n11, (EventList)object2, false);
        element = this.getParagraphElement(n5, element3);
        this.splice(element, n5, (EventList)object2, false);
        ExtendedDocuementEvent extendedDocuementEvent = new ExtendedDocuementEvent(n5, n11 - n5, DocumentEvent.EventType.INSERT, this);
        ((EventList)object2).fillEvent(extendedDocuementEvent);
        extendedDocuementEvent.end();
        this.fillAttributes(element);
        return extendedDocuementEvent;
    }

    private void checkAndCleanModel(EventList eventList) {
        this.checkAndCleanModelRecurse(this.getDefaultRootElement(), eventList);
    }

    private void checkAndCleanModelRecurse(Element element, EventList eventList) {
        Element element2;
        int n2;
        Element element3 = element.getElement(0);
        if (element.getElementCount() > 1) {
            for (n2 = 1; n2 < element.getElementCount(); ++n2) {
                element2 = element.getElement(n2);
                if (!element2.isLeaf() && element2.getElementCount() == 0) {
                    if (Logger.doesLog(2)) {
                        Logger.warning("Inconsistent datamodel state found!");
                        Logger.warning("Branch element has no children: " + element3.getName());
                    }
                } else {
                    int n3;
                    block12: {
                        n3 = element2.getStartOffset() - element3.getEndOffset();
                        if (n3 > 0) {
                            if (Logger.doesLog(2)) {
                                Logger.warning("Inconsistent datamodel state found...");
                                Logger.warning("Left Element : " + element3.getAttributes().getAttribute(StyleConstants.NameAttribute) + "(" + element3.getStartOffset() + ":" + element3.getEndOffset() + ")");
                                Logger.warning("Right Element: " + element2.getAttributes().getAttribute(StyleConstants.NameAttribute) + "(" + element2.getStartOffset() + ":" + element2.getEndOffset() + ")");
                            }
                            try {
                                eventList.addEvent(this.getContent().remove(element3.getEndOffset(), n3));
                            }
                            catch (BadLocationException badLocationException) {
                                if (!Logger.doesLog(1)) break block12;
                                Logger.error(badLocationException);
                            }
                        }
                    }
                    if (n3 < 0 && Logger.doesLog(2)) {
                        Logger.warning("Inconsistent datamodel state found!");
                        Logger.warning("Left Element : " + element3.getAttributes().getAttribute(StyleConstants.NameAttribute) + "(" + element3.getStartOffset() + ":" + element3.getEndOffset() + ")");
                        Logger.warning("Right Element: " + element2.getAttributes().getAttribute(StyleConstants.NameAttribute) + "(" + element2.getStartOffset() + ":" + element2.getEndOffset() + ")");
                    }
                }
                element3 = element2;
            }
        }
        for (n2 = 0; n2 < element.getElementCount(); ++n2) {
            element2 = element.getElement(n2);
            if (element2.getParentElement() != element && Logger.doesLog(2)) {
                Logger.warning("Inconsistent datamodel state found!");
                Logger.warning("Element has deprecated parent: " + element2.getAttributes().getAttribute(StyleConstants.NameAttribute) + "(" + element2.getStartOffset() + ":" + element2.getEndOffset() + ")");
            }
            if (element2.isLeaf()) continue;
            this.checkAndCleanModelRecurse(element2, eventList);
        }
    }

    protected final AbstractDocument.Content getContentImpl() {
        return super.getContent();
    }

    public Color getForeground(Element element) {
        return StyleResolver.getAttributeValue(element, AttributeFinder.COLOR).getValue();
    }

    public Color getBackground(Element element) {
        ColorValue colorValue = StyleResolver.getAttributeValue(element, AttributeFinder.BACKGROUND_COLOR);
        if (colorValue != null) {
            return colorValue.getValue();
        }
        return super.getBackground(element.getAttributes());
    }

    public static float getFontSize(Element element) {
        return ((Float)element.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)).floatValue();
    }

    public static Font getFont(Element element) {
        return InetHtmlDocument.getFont(element, InetHtmlDocument.getFontSize(element));
    }

    public static Font getFont(Element element, float f2) {
        SingleAttributeValue singleAttributeValue = StyleResolver.getAttributeValue(element, AttributeFinder.FONT_FAMILY);
        String string = singleAttributeValue.getFamily();
        int n2 = 0;
        singleAttributeValue = StyleResolver.getAttributeValue(element, AttributeFinder.FONT_STYLE);
        if (singleAttributeValue instanceof FontStyle && ((FontStyle)singleAttributeValue).isItalic()) {
            n2 |= 2;
        }
        if ((singleAttributeValue = StyleResolver.getAttributeValue(element, AttributeFinder.FONT_WEIGHT)) instanceof FontWeight && ((FontWeight)singleAttributeValue).isBold()) {
            n2 |= 1;
        }
        return new Font(string, n2, (int)f2);
    }

    @Override
    protected BoxElement createBranchElement(Element element, AttributeSet attributeSet) {
        if (element == null && attributeSet.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.HTML) {
            throw new IllegalArgumentException("Cannot create an element without parent!");
        }
        BoxElement boxElement = new BoxElement(element, attributeSet);
        return boxElement;
    }

    protected BoxElement createBranchElement(Element element, Object object) throws IllegalArgumentException {
        if (element == null && object != HTML.Tag.HTML) {
            throw new IllegalArgumentException("Cannot create an element without parent!");
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, object);
        BoxElement boxElement = new BoxElement(element, (AttributeSet)simpleAttributeSet);
        return boxElement;
    }

    @Override
    protected ContentElement createLeafElement(Element element, AttributeSet attributeSet, int n2, int n3) {
        ContentElement contentElement = new ContentElement(element, attributeSet, n2, n3);
        return contentElement;
    }

    protected ContentElement createLeafElement(Element element, Object object, int n2, int n3) {
        if (element == null && object != HTML.Tag.HTML) {
            throw new IllegalArgumentException("Cannot create an element without parent!");
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, object);
        ContentElement contentElement = new ContentElement(element, (AttributeSet)simpleAttributeSet, n2, n3);
        return contentElement;
    }

    @Override
    public AbstractDocument.BranchElement createAnnonymousElement(Element element) {
        ImpliedElement impliedElement = new ImpliedElement(element);
        return impliedElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertAfterEnd(Element element, String string) throws BadLocationException, IOException {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertAfterEnd");
        }
        boolean bl2 = false;
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = null;
        Element element2 = element.getParentElement();
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl2 = true;
            }
            int n2 = element.getEndOffset();
            defaultDocumentEvent = this.parseLight(new StringReader(string), n2, element2, element, false, false, null, null);
        }
        catch (Exception exception) {
            if (Logger.doesLog(1)) {
                Logger.error(exception);
            }
        }
        finally {
            if (bl2) {
                this.writeUnlock();
            }
        }
        if (defaultDocumentEvent != null) {
            this.fireInsertUpdate(defaultDocumentEvent);
            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, defaultDocumentEvent);
            this.fireUndoableEditUpdate(undoableEditEvent);
        }
    }

    public void insertHTML(String string, int n2) {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertHTML(" + n2 + ")");
        }
        this.pasteHTML(string, n2, n2);
    }

    public void pasteHTML(String string, int n2, int n3) {
        this.pasteHTML(string, n2, n3, new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteHTML(String string, int n2, int n3, Object object) {
        Object object2;
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:pasteHTML(" + n2 + ")");
        }
        if (!this.allowTableEdit && ElementUtils.crossesTable(n2, n3, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        EventList eventList = new EventList();
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl2 = true;
            }
            if (n3 > n2) {
                this.removeImpl(n2, n3 - n2, eventList);
            }
            n4 = this.getContent().length();
            if (string.contains("Fragment-->") && string.contains("<!--StartFragment-->") && string.contains("<!--EndFragment-->")) {
                InetHtmlDocument inetHtmlDocument = new InetHtmlDocument();
                inetHtmlDocument.writeLock();
                inetHtmlDocument.setDocumentProperties(this.getDocumentProperties());
                InetHtmlParser inetHtmlParser = new InetHtmlParser();
                AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)inetHtmlDocument.getRootElements()[0];
                inetHtmlParser.parse(new StringReader(string), inetHtmlDocument, branchElement, 0, null, false, object);
                object2 = inetHtmlParser.getContentOffsets();
                if (object2 != null) {
                    StringWriter stringWriter = new StringWriter();
                    InetHtmlWriter inetHtmlWriter = new InetHtmlWriter((Writer)stringWriter, inetHtmlDocument, (int)object2[0], (int)(object2[1] - object2[0]));
                    inetHtmlWriter.setAllowStyleSpan(true);
                    inetHtmlWriter.setInlineMode(true);
                    inetHtmlWriter.write();
                    string = stringWriter.toString();
                }
            }
            this.parseLight(new StringReader(string), n2, null, null, false, false, eventList, object);
            int n6 = n2 + this.getContent().length() - n4;
            if (n6 > 0 && object != null && this.appendEditLine(eventList, n6 - 1)) {
                ++n5;
            }
        }
        catch (Exception exception) {
            if (Logger.doesLog(1)) {
                Logger.error(exception);
            }
        }
        finally {
            if (bl2) {
                this.writeUnlock();
            }
        }
        int n7 = eventList.getStartOffset();
        int n8 = eventList.getEndOffset();
        int n9 = n2;
        n4 = this.getContent().length() - n4 - n5;
        object2 = new ExtendedDocuementEvent(n7, n8 - n7, n9, n4, DocumentEvent.EventType.INSERT, this);
        eventList.fillEvent((AbstractDocument.DefaultDocumentEvent)object2);
        ((CompoundEdit)object2).end();
        this.fireInsertUpdate((DocumentEvent)object2);
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, (UndoableEdit)object2));
    }

    private boolean appendEditLine(EventList eventList, int n2) throws IOException, BadLocationException {
        boolean bl2;
        Element element = ElementUtils.getLeafAt(this.getRootElements()[0], n2);
        boolean bl3 = bl2 = this.getLength() == n2 + 1;
        if (element != null && bl2) {
            Object object;
            Object object2;
            Element element2 = ElementUtils.findNextHigherBlock(element);
            if (element2 == null) {
                return false;
            }
            Element element3 = ElementUtils.findNextHigherBlock(element2);
            if (!this.shouldHaveEditLineAfter(element2)) {
                return false;
            }
            Object object3 = object2 = element3 != null ? element3.getAttributes().getAttribute(StyleConstants.NameAttribute) : null;
            while (object2 != HTML.Tag.BODY && object2 != HTML.Tag.HTML && element2.getEndOffset() >= n2 + 1) {
                element3 = ElementUtils.findNextHigherBlock(element2 = ElementUtils.findNextHigherBlock(element2));
                object2 = element3 != null ? element3.getAttributes().getAttribute(StyleConstants.NameAttribute) : null;
            }
            Object object4 = object = element2 != null ? element2.getAttributes().getAttribute(StyleConstants.NameAttribute) : null;
            if (object != HTML.Tag.P) {
                if (!this.shouldHaveEditLineAfter(element2)) {
                    return false;
                }
                this.parseLight(new StringReader("<p" + (this.defaultStyleName != null ? " class=\"" + this.defaultStyleName + "\"" : "") + "></p>"), n2 + 1, element3, element2, false, true, eventList, null);
                if (n2 + 2 == this.getLength()) {
                    this.removeCompleteImpl(ElementUtils.getLeafAt(element3, n2 + 2), eventList);
                    eventList.addEvent(this.getContent().remove(n2 + 2, 1));
                }
                return true;
            }
        }
        return false;
    }

    private boolean shouldHaveEditLineAfter(Element element) {
        if (element == null) {
            return false;
        }
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.BODY || object == HTML.Tag.HTML) {
            return false;
        }
        FloatValue floatValue = StyleResolver.getAttributeValue(element, AttributeFinder.FLOAT);
        if (floatValue != null && floatValue.getFloat() != 0) {
            return false;
        }
        DisplayValue displayValue = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        if (displayValue == null) {
            return false;
        }
        switch (displayValue.getDisplay()) {
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertAfterStart(Element element, String string) throws BadLocationException, IOException {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertAfterEnd");
        }
        boolean bl2 = false;
        Element element2 = element.getParentElement();
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = null;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl2 = true;
            }
            int n2 = element.getEndOffset();
            defaultDocumentEvent = this.parseLight(new StringReader(string), n2, element2, element, true, true, null, null);
        }
        catch (Exception exception) {
            if (Logger.doesLog(1)) {
                Logger.error(exception);
            }
        }
        finally {
            if (bl2) {
                this.writeUnlock();
            }
        }
        if (defaultDocumentEvent != null) {
            this.fireInsertUpdate(defaultDocumentEvent);
            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, defaultDocumentEvent);
            this.fireUndoableEditUpdate(undoableEditEvent);
        }
    }

    @Override
    public void insertBeforeEnd(Element element, String string) throws BadLocationException, IOException {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertBeforeEnd");
        }
        super.insertBeforeEnd(element, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertBeforeStart(Element element, String string) throws BadLocationException, IOException {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertBeforeStart");
        }
        boolean bl2 = false;
        Element element2 = element.getParentElement();
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = null;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl2 = true;
            }
            int n2 = element.getStartOffset();
            defaultDocumentEvent = this.parseLight(new StringReader(string), n2, element2, element, true, true, null, null);
        }
        catch (Exception exception) {
            if (Logger.doesLog(1)) {
                Logger.error(exception);
            }
        }
        finally {
            if (bl2) {
                this.writeUnlock();
            }
        }
        if (defaultDocumentEvent != null) {
            this.fireInsertUpdate(defaultDocumentEvent);
            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, defaultDocumentEvent);
            this.fireUndoableEditUpdate(undoableEditEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        Object object;
        Object object2;
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:insertString(" + n2 + ", \"" + string + "\")");
        }
        if (string == null || string.length() == 0) {
            return;
        }
        Element element = this.getParagraphElement(n2);
        Element element2 = ElementUtils.getLeafAt(element, n2);
        Element element3 = ElementUtils.getLeafAt(element, n2 - 1);
        if (element2 != null) {
            object2 = ElementUtils.findParentByTag(element3, HTML.Tag.A);
            if (object2 != null && !ElementUtils.isRelated(element, (Element)object2)) {
                if (object2.getEndOffset() == n2) {
                    this.insertStringBeforeStart(element2, string, element2.getAttributes());
                    return;
                }
                if (object2.getStartOffset() == n2) {
                    this.insertStringBeforeStart((Element)object2, string, element2.getAttributes());
                    return;
                }
                if (object2.getEndOffset() == n2 + 1 && element2.getAttributes().isDefined("CR")) {
                    AbstractDocument.Content content = this.getContent();
                    EventList eventList = new EventList();
                    this.writeLock();
                    try {
                        Element element4;
                        Element element5 = object2.getParentElement();
                        this.splitElement((Element)object2, n2, null, eventList, false, true);
                        int n3 = string.length();
                        eventList.addEvent(content.insertString(n2 + 1, string + "\n"));
                        eventList.addEvent(content.remove(n2, 1));
                        Element element6 = ElementUtils.getLeafAt(element5, n2);
                        object2 = ElementUtils.findParentByTag(element6, HTML.Tag.A);
                        MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)object2.getAttributes();
                        mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.SPAN);
                        mutableAttributeSet.removeAttribute((Object)HTML.Attribute.HREF);
                        mutableAttributeSet.removeAttribute((Object)HTML.Attribute.NAME);
                        mutableAttributeSet.removeAttribute((Object)HTML.Attribute.ALT);
                        mutableAttributeSet = ElementUtils.removeNonessentialAttributes(mutableAttributeSet, object2.getParentElement());
                        ElementUtils.clearTemp(mutableAttributeSet);
                        if (mutableAttributeSet.getAttributeCount() == 1) {
                            element4 = object2.getParentElement();
                            int n4 = ElementUtils.getChildIndex(element4, (Element)object2);
                            this.createCopy((Element)object2, element4, object2.getStartOffset(), object2.getEndOffset(), n4);
                            int n5 = object2.getElementCount();
                            Element[] elementArray = ElementUtils.getChildren(element4, n4, n5);
                            ((AbstractDocument.BranchElement)element4).replace(n4 + n5, 1, new Element[0]);
                            eventList.getEventFor(element4, n4, new Element[]{object2}, elementArray);
                            element6 = ElementUtils.getLeafAt(element4, n2);
                        }
                        element5 = element6.getParentElement();
                        element4 = this.createLeafElement(element5, (Object)HTML.Tag.CONTENT, n2, n2 + n3);
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                        simpleAttributeSet.addAttribute("CR", Boolean.TRUE);
                        ContentElement contentElement = this.createLeafElement(element5, simpleAttributeSet, n2 + n3, n2 + n3 + 1);
                        this.replaceElements(new Element[]{element6}, new Element[]{element4, contentElement}, eventList);
                        this.styleResolver.fillAttributesNonLocked((Element)object2, null);
                        this.styleResolver.fillAttributesNonLocked(element4, null);
                        this.styleResolver.fillAttributesNonLocked(contentElement, null);
                    }
                    finally {
                        this.writeUnlock();
                    }
                    this.fireUpdateEvent(n2, string.length(), DocumentEvent.EventType.INSERT, eventList);
                    return;
                }
            } else if (!ElementUtils.isContent(element2)) {
                this.insertStringBeforeStart(element2, string, attributeSet);
                return;
            }
        }
        object2 = this.getContent();
        EventList eventList = new EventList();
        string = string.replaceAll("\\n", " ");
        if (n2 == element.getStartOffset() || element3 != null && !ElementUtils.isContent(element3)) {
            object = object2.getString(n2, 1);
            eventList.add(object2.insertString(n2 + 1, string + (String)object));
            eventList.add(object2.remove(n2, 1));
        } else {
            eventList.add(object2.insertString(n2, string));
        }
        object = ElementUtils.getLeafAt(element, n2);
        MutableAttributeSet mutableAttributeSet = ElementUtils.removeNonessentialAttributes(attributeSet, object.getParentElement());
        if (!StyleResolver.matchesAttributes((Element)object, mutableAttributeSet)) {
            this.writeLock();
            try {
                this.setCharacterAttributesSegment(n2, string.length(), element, mutableAttributeSet, false, false, eventList);
                this.splice(element, n2, eventList, false);
                this.splice(element, n2 + string.length(), eventList, false);
            }
            finally {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(n2, string.length(), DocumentEvent.EventType.INSERT, eventList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertStringBeforeStart(Element element, String string, AttributeSet attributeSet) throws BadLocationException {
        Element element2 = element.getParentElement();
        int n2 = ElementUtils.getChildIndex(element2, element);
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset() - n3;
        boolean bl2 = element.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HR;
        EventList eventList = new EventList();
        AbstractDocument.Content content = this.getContent();
        String string2 = n3 > 0 ? content.getString(n3 - 1, 1) : "";
        boolean bl3 = false;
        try {
            Element[] elementArray;
            Element element3;
            Element element4;
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl3 = true;
            }
            if (n2 == 0 || !ElementUtils.isContent(element2.getElement(n2 - 1)) || "\n".equals(string2)) {
                String string3 = content.getString(n3, 1);
                eventList.addEvent(content.insertString(n3 + 1, string + string3));
                eventList.addEvent(content.remove(n3, 1));
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                simpleAttributeSet.removeAttribute("CR");
                simpleAttributeSet.removeAttribute(FLAG_INIT);
                element4 = this.createLeafElement(element2, simpleAttributeSet, n3, n3 + string.length());
                this.fillAttributes(element4);
                element3 = this.createCopy(element, n3 + string.length(), n3 + string.length() + n4, element2);
                this.fillAttributes(element3);
                elementArray = new Element[]{element};
                Element[] elementArray2 = new Element[]{element4, element3};
                ((AbstractDocument.BranchElement)element2).replace(n2, 1, elementArray2);
                eventList.getEventFor(element2, n2, elementArray, elementArray2);
                if (bl2) {
                    element2 = this.wrapImpliedElement(n3, eventList);
                }
            } else {
                eventList.addEvent(content.insertString(n3, string));
            }
            int n5 = string.length();
            int n6 = element2.getElementIndex(n3 + n5);
            Element element5 = element4 = n6 >= 0 ? element2.getElement(n6) : null;
            if (element4 != null && element4.getAttributes().getAttribute("CR") != null) {
                ++n5;
            }
            if ((element3 = ElementUtils.getLeafAt(element2, n3)).getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
                element3 = element3.getParentElement();
            }
            if (!StyleResolver.matchesAttributes(element3, (AttributeSet)(elementArray = ElementUtils.removeNonessentialAttributes(attributeSet, element2)))) {
                if (!InetHtmlDocument.isParagraph(element2)) {
                    element2 = element2.getParentElement();
                }
                this.setCharacterAttributesSegment(n3, n5, element2, (AttributeSet)elementArray, false, false, eventList);
            }
        }
        finally {
            if (bl3) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(n3, string.length(), DocumentEvent.EventType.INSERT, eventList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performParagraphBreak(int n2) {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:performParagraphBreak( " + n2 + " )");
        }
        Element element = this.getParagraphElement(n2);
        if (!this.allowTableEdit && ElementUtils.isTablePart(element)) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        Element element2 = ElementUtils.getLeafAt(element, n2);
        if (element2 != null && !ElementUtils.isContent(element2) && InetHtmlDocument.isParagraph(element2)) {
            block23: {
                try {
                    this.insertBeforeStart(element2, "<p> </p>");
                }
                catch (IOException iOException) {
                    if (Logger.doesLog(1)) {
                        Logger.error(iOException);
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (!Logger.doesLog(1)) break block23;
                    Logger.error(badLocationException);
                }
            }
            return;
        }
        Element element3 = ElementUtils.findListItemParent(element);
        EventList eventList = new EventList();
        boolean bl2 = false;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl2 = true;
            }
            if (element3 != null) {
                int n3;
                int n4 = element.getEndOffset();
                if (n4 - (n3 = element.getStartOffset()) <= 1) {
                    Element element4 = ElementUtils.findListContainer(element3);
                    if (element4 != null) {
                        Element element5 = ElementUtils.findListContainer(element4);
                        if (element5 != null) {
                            this.changeIndent(-1, n3, 1, false);
                        } else {
                            Object object = element4.getAttributes().getAttribute(StyleConstants.NameAttribute);
                            this.changeListStatus(n3, 1, object == HTML.Tag.OL);
                        }
                    } else {
                        BoxElement boxElement = this.createBranchElement(element3.getParentElement(), (Object)this.configuration.getDefaultBlock());
                        this.checkDefaultStyle(boxElement);
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                        simpleAttributeSet.addAttribute("CR", Boolean.TRUE);
                        ContentElement contentElement = this.createLeafElement((Element)boxElement, simpleAttributeSet, element3.getStartOffset(), element3.getEndOffset());
                        ((AbstractDocument.BranchElement)boxElement).replace(0, 0, new Element[]{contentElement});
                        this.replaceElements(new Element[]{element3}, new Element[]{boxElement}, eventList);
                    }
                    return;
                }
                this.splitElement(element3, n2, null, eventList, false, true);
            } else {
                this.splitElement(element, n2, null, eventList, true, true);
            }
        }
        catch (BadLocationException badLocationException) {
            if (Logger.doesLog(1)) {
                Logger.error(badLocationException);
            }
        }
        finally {
            if (bl2) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(n2, 1, DocumentEvent.EventType.INSERT, eventList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertHRule(int n2) {
        Element element = this.getParagraphElement(n2);
        if (element.isLeaf()) {
            element = ElementUtils.findNextHigherBlock(element);
        }
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        Element element2 = ElementUtils.getLeafAt(element, n2);
        Object object2 = element2.getAttributes().getAttribute(StyleConstants.NameAttribute);
        DisplayValue displayValue = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        EventList eventList = new EventList();
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl2 = true;
            }
            if (object2 != HTML.Tag.HR) {
                if (object == HTML.Tag.BODY || displayValue != null && displayValue.getDisplay() == 4) {
                    element = this.wrapImpliedElement(n2, eventList);
                }
                if (n2 > element.getStartOffset()) {
                    this.splitElement(element, n2, null, eventList, false, true);
                    bl3 = true;
                    ++n2;
                }
                element = element.getParentElement();
            }
            n3 = bl3 ? 1 : 0;
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.HR);
            int n4 = n2;
            AbstractDocument.Content content = this.getContent();
            String string = content.getString(n4, 1);
            eventList.addEvent(content.insertString(n4 + 1, "\n" + string));
            eventList.addEvent(content.remove(n4, 1));
            Element element3 = ElementUtils.getLeafAt(element, n4);
            this.cropElement(element3, n4 + 1, element3.getEndOffset(), eventList);
            ContentElement contentElement = this.createLeafElement(element, simpleAttributeSet, n2, n2 + 1);
            int n5 = element.getElementIndex(n4);
            Element[] elementArray = new Element[]{contentElement};
            ((AbstractDocument.BranchElement)element).replace(n5, 0, elementArray);
            eventList.getEventFor(element, n5, new Element[0], elementArray);
        }
        catch (BadLocationException badLocationException) {
            if (Logger.doesLog(1)) {
                Logger.error(badLocationException);
            }
        }
        finally {
            if (bl2) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(n2 - n3, 1 + n3, DocumentEvent.EventType.INSERT, eventList);
    }

    AbstractDocument.DefaultDocumentEvent splitElement(Element element, int n2, AttributeSet attributeSet, EventList eventList, boolean bl2, boolean bl3) throws BadLocationException {
        Object object;
        int n3;
        AbstractDocument.AbstractElement abstractElement;
        AbstractDocument.AbstractElement abstractElement2;
        Object object2;
        boolean bl4;
        EventList eventList2 = new EventList(eventList);
        int n4 = n2;
        boolean bl5 = bl4 = InetHtmlDocument.isParagraph(element);
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element.getParentElement();
        if (element instanceof AbstractDocument.BranchElement) {
            if (bl2 && (object2 = this.wrapImpliedElement(n2, eventList2)) != null) {
                element = object2;
                branchElement = (AbstractDocument.BranchElement)element.getParentElement();
            }
            abstractElement2 = this.createBranchElement(element.getParentElement(), element.getAttributes().copyAttributes());
            abstractElement = this.createBranchElement(element.getParentElement(), attributeSet != null ? attributeSet : element.getAttributes().copyAttributes());
            n3 = element.getStartOffset();
            int n5 = element.getEndOffset();
            if (n3 == n2) {
                object2 = this.getContent();
                object = object2.getString(n3, 1);
                eventList2.addEvent(object2.insertString(n3 + 1, "\n" + (String)object));
                eventList2.addEvent(object2.remove(n3, 1));
                ++n2;
                ++n5;
                bl4 = false;
            }
            if (n5 == n2) {
                eventList2.addEvent(this.getContent().insertString(n5, "\n"));
                Logger.debug("Split inconsistent in element : " + element);
                ++n5;
            }
            this.createCopy(element, abstractElement2, n3, n2);
            this.createCopy(element, abstractElement, n2, n5);
            if (n2 - n3 == 1 && !bl4 && bl5 && (object2 = ElementUtils.getLeafAt(abstractElement2, n3)) != null) {
                object = (MutableAttributeSet)object2.getAttributes();
                object.removeAttribute(StyleConstants.IconAttribute);
                object.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                object.addAttribute("CR", Boolean.TRUE);
            }
        } else {
            abstractElement2 = this.createLeafElement(element.getParentElement(), element.getAttributes().copyAttributes(), element.getStartOffset(), n2);
            abstractElement = this.createLeafElement(element.getParentElement(), element.getAttributes().copyAttributes(), n2, element.getEndOffset());
            bl4 = false;
        }
        n3 = branchElement.getElementIndex(n2);
        Element[] elementArray = new Element[]{abstractElement2, abstractElement};
        branchElement.replace(n3, 1, elementArray);
        object2 = ElementUtils.getLeafAt(abstractElement2, n2 - 1);
        if (object2 != null) {
            object = n2 > 0 ? this.getContent().getString(n2 - 1, 1) : "";
            boolean bl6 = !ElementUtils.isContent((Element)object2);
            boolean bl7 = object2.getAttributes().containsAttribute("CR", Boolean.TRUE);
            if (bl6 && bl7 || !bl6 && "\n".equals(object)) {
                bl4 = false;
            }
            if (bl4) {
                MutableAttributeSet mutableAttributeSet;
                eventList2.addEvent(this.getContent().insertString(n2, "\n"));
                if (object2.getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.A) {
                    mutableAttributeSet = new SimpleAttributeSet(object2.getParentElement().getAttributes());
                    ((SimpleAttributeSet)mutableAttributeSet).addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.SPAN);
                    ((SimpleAttributeSet)mutableAttributeSet).removeAttribute((Object)HTML.Attribute.HREF);
                    ((SimpleAttributeSet)mutableAttributeSet).removeAttribute((Object)HTML.Attribute.NAME);
                    ((SimpleAttributeSet)mutableAttributeSet).removeAttribute((Object)HTML.Attribute.TITLE);
                    ((SimpleAttributeSet)mutableAttributeSet).removeAttribute((Object)HTML.Attribute.ALT);
                    ElementUtils.clearTemp(mutableAttributeSet);
                    this.splitElement(object2.getParentElement(), n2, mutableAttributeSet, eventList, false, true);
                } else {
                    this.splitContentElement((Element)object2, n2, eventList);
                }
                object2 = ElementUtils.getLeafAt(abstractElement2, n2);
                mutableAttributeSet = (MutableAttributeSet)object2.getAttributes();
                ElementUtils.clearTemp(mutableAttributeSet);
                mutableAttributeSet.removeAttribute(StyleConstants.IconAttribute);
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                mutableAttributeSet.addAttribute("CR", Boolean.TRUE);
            }
        }
        if (bl3) {
            this.fillAttributes(abstractElement2);
            this.fillAttributes(abstractElement);
        }
        eventList2.getEventFor(branchElement, n3, new Element[]{element}, elementArray);
        object = new ExtendedDocuementEvent(n4, 1, DocumentEvent.EventType.INSERT, this);
        eventList2.fillEvent((AbstractDocument.DefaultDocumentEvent)object);
        ((CompoundEdit)object).end();
        return object;
    }

    static boolean isParagraph(Element element) {
        DisplayValue displayValue = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        return displayValue != null && displayValue.getDisplay() != 2 && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED;
    }

    private int getLowerContentBoundary(int n2, Element element, Element element2) {
        int n3 = element2.getElementIndex(n2);
        int n4 = -1;
        for (int i2 = n3; i2 >= 0; --i2) {
            Element element3 = element2.getElement(i2);
            if (!element3.isLeaf()) {
                if (InetHtmlDocument.isParagraph(element3)) {
                    return element3.getEndOffset();
                }
                int n5 = element3.getEndOffset();
                n5 = n2 < n5 ? n2 : n5;
                n4 = this.getLowerContentBoundary(n5, element, element3);
                if (n4 < 0) continue;
                break;
            }
            if (!InetHtmlDocument.isParagraph(element3)) continue;
            return element3.getEndOffset();
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLowerContentBoundary(int n2, Element element) {
        try {
            this.readLock();
            int n3 = this.getLowerContentBoundary(n2, element, element);
            if (n3 >= 0) {
                int n4 = n3;
                return n4;
            }
            int n5 = element.getStartOffset();
            return n5;
        }
        finally {
            this.readUnlock();
        }
    }

    private int getUpperContentBoundaryImpl(int n2, Element element, Element element2) {
        int n3 = element2.getElementIndex(n2);
        int n4 = -1;
        if (element2.isLeaf()) {
            return element2.getEndOffset();
        }
        for (int i2 = n3; i2 < element2.getElementCount(); ++i2) {
            Element element3 = element2.getElement(i2);
            if (!element3.isLeaf()) {
                if (InetHtmlDocument.isParagraph(element3)) {
                    return element3.getStartOffset();
                }
                int n5 = element3.getStartOffset();
                n5 = n2 > n5 ? n2 : n5;
                n4 = this.getUpperContentBoundaryImpl(n5, element, element3);
                if (n4 < 0) continue;
                break;
            }
            if (!InetHtmlDocument.isParagraph(element3)) continue;
            return element3.getStartOffset();
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUpperContentBoundary(int n2, Element element) {
        try {
            this.readLock();
            if (n2 == element.getEndOffset()) {
                int n3 = n2;
                return n3;
            }
            int n4 = this.getUpperContentBoundaryImpl(n2, element, element);
            if (n4 >= 0) {
                int n5 = n4;
                return n5;
            }
            int n6 = element.getEndOffset();
            return n6;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element wrapImpliedElement(int n2, EventList eventList) throws BadLocationException {
        boolean bl2 = false;
        try {
            Element element;
            Object object;
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl2 = true;
            }
            Element element2 = this.getParagraphElement(n2);
            int n3 = this.getLowerContentBoundary(n2, element2);
            int n4 = this.getUpperContentBoundary(n2, element2);
            Object object2 = element2.getAttributes().getAttribute(StyleConstants.NameAttribute);
            DisplayValue displayValue = StyleResolver.getAttributeValue(element2, AttributeFinder.DISPLAY);
            if (!(n3 != element2.getStartOffset() || n4 != element2.getEndOffset() || object2 == HTML.Tag.BODY || displayValue != null && displayValue.getDisplay() == 4 || ElementUtils.isTablePart(element2))) {
                Element element3 = element2;
                return element3;
            }
            BoxElement boxElement = this.createBranchElement(element2, (Object)this.configuration.getDefaultBlock());
            this.checkDefaultStyle(boxElement);
            this.createCopy(element2, boxElement, n3, n4);
            int n5 = element2.getElementIndex(n3);
            int n6 = element2.getElementIndex(n4 - 1);
            BoxElement boxElement2 = null;
            BoxElement boxElement3 = null;
            if (n3 > element2.getStartOffset() && n5 == element2.getElementIndex(n3 - 1)) {
                object = element2.getElement(element2.getElementIndex(n3 - 1));
                boxElement2 = this.createBranchElement(element2, object.getAttributes().copyAttributes());
                this.createCopy((Element)object, boxElement2, object.getStartOffset(), n3);
            }
            if (n4 < element2.getEndOffset() && n6 == element2.getElementIndex(n4)) {
                object = element2.getElement(element2.getElementIndex(n4 + 1));
                boxElement3 = this.createBranchElement(element2, object.getAttributes().copyAttributes());
                this.createCopy((Element)object, boxElement3, n4, object.getEndOffset());
            }
            ++n6;
            object = new ArrayList<BoxElement>(3);
            if (boxElement2 != null) {
                ((ArrayList)object).add(boxElement2);
            }
            ((ArrayList)object).add(boxElement);
            if (boxElement3 != null) {
                ((ArrayList)object).add(boxElement3);
            }
            int n7 = n6 - n5;
            Element[] elementArray = ((ArrayList)object).toArray(new Element[((ArrayList)object).size()]);
            Element[] elementArray2 = ElementUtils.getChildren(element2, n5, n7);
            eventList.getEventFor(element2, n5, elementArray2, elementArray);
            ((AbstractDocument.BranchElement)element2).replace(n5, n7, elementArray);
            int n8 = boxElement.getEndOffset();
            Element element4 = ElementUtils.getLeafAt(boxElement, n8 - 1);
            if (!element4.getAttributes().isDefined("CR")) {
                eventList.addEvent(this.getContent().insertString(n8, "\n"));
                element = ElementUtils.getLeafAt(boxElement, n8);
                this.splitElement(element, n8, null, eventList, false, false);
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                simpleAttributeSet.addAttribute("CR", Boolean.TRUE);
                ContentElement contentElement = this.createLeafElement((Element)boxElement, simpleAttributeSet, n8, n8 + 1);
                elementArray = new Element[]{contentElement};
                elementArray2 = new Element[]{boxElement.getElement(boxElement.getElementCount() - 1)};
                this.replaceElements(elementArray2, elementArray, eventList);
            }
            this.styleResolver.fillAttributesNonLocked(boxElement, null);
            element = boxElement;
            return element;
        }
        finally {
            if (bl2) {
                this.writeUnlock();
            }
        }
    }

    private void checkDefaultStyle(Element element) {
        if (this.defaultStyleName != null) {
            Object object;
            Element element2 = element.getParentElement();
            if (HTML.Tag.BODY != element2.getAttributes().getAttribute(StyleConstants.NameAttribute) && element2.getAttributes().isDefined((Object)HTML.Attribute.CLASS) && ((object = (ClassValue)element2.getAttributes().getAttribute((Object)HTML.Attribute.CLASS)) == null || !((ClassValue)object).getClassNames().contains(this.defaultStyleName))) {
                return;
            }
            object = (MutableAttributeSet)element.getAttributes();
            if (!object.isDefined((Object)HTML.Attribute.CLASS)) {
                ClassValue classValue = new ClassValue();
                classValue.addClass(this.defaultStyleName);
                object.addAttribute((Object)HTML.Attribute.CLASS, classValue);
            } else {
                ClassValue classValue = (ClassValue)object.getAttribute((Object)HTML.Attribute.CLASS);
                if (!classValue.getClassNames().contains(this.defaultStyleName)) {
                    classValue.addClass(this.defaultStyleName);
                }
            }
            this.styleResolver.fillAttributesNonLocked(element, null);
        }
    }

    protected Element createCopy(Element element, int n2, int n3, Element element2) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(element.getAttributes());
        ElementUtils.clearTemp(simpleAttributeSet);
        if (element.isLeaf()) {
            return this.createLeafElement(element2, simpleAttributeSet, n2, n3);
        }
        BoxElement boxElement = this.createBranchElement(element2, simpleAttributeSet);
        this.createCopy(element, boxElement, n2, n3);
        return boxElement;
    }

    protected Element createCopy(Element element, Element element2, int n2, int n3) {
        return this.createCopy(element, element2, n2, n3, element2.getElementCount());
    }

    protected Element createCopy(Element element, Element element2, int n2, int n3, int n4) {
        int n5 = element.getElementCount();
        int n6 = 0;
        if (n2 < n3) {
            for (int i2 = 0; i2 < n5; ++i2) {
                AbstractDocument.AbstractElement abstractElement;
                Element element3 = element.getElement(i2);
                int n7 = element3.getStartOffset();
                int n8 = element3.getEndOffset();
                if (!(n7 < n3 && n8 > n2 || n7 == n3 && n8 == n3) && (n7 != n2 || n8 != n2)) continue;
                if (element3 instanceof AbstractDocument.BranchElement) {
                    abstractElement = this.createBranchElement(element2, element3.getAttributes());
                    this.createCopy(element3, abstractElement, n2, n3, 0);
                    if (abstractElement.getElementCount() > 0) {
                        ((AbstractDocument.BranchElement)element2).replace(n4 + n6, 0, new Element[]{abstractElement});
                    }
                } else {
                    int n9 = n7 >= n2 ? n7 : n2;
                    int n10 = n8 <= n3 ? n8 : n3;
                    abstractElement = this.createLeafElement(element2, element3.getAttributes().copyAttributes(), n9, n10);
                    ((AbstractDocument.BranchElement)element2).replace(n4 + n6, 0, new Element[]{abstractElement});
                }
                ++n6;
            }
        } else {
            return null;
        }
        return element2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int n2, int n3) throws BadLocationException {
        EventList eventList = new EventList();
        boolean bl2 = false;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl2 = true;
            }
            this.removeImpl(n2, n3, eventList);
        }
        finally {
            if (bl2) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(n2, n3, DocumentEvent.EventType.REMOVE, eventList);
    }

    public void removeImpl(int n2, int n3, EventList eventList) throws BadLocationException {
        int n4;
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:remove(" + n2 + ", " + n3 + ")");
        }
        if (n3 >= (n4 = this.getLength()) && n2 == 0) {
            this.clearBody(eventList);
            return;
        }
        if (!this.allowTableEdit && ElementUtils.crossesTable(n2, n2 + n3, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        if (n2 + n3 > n4 && (n3 = n4 - n2 - 1) <= 0) {
            return;
        }
        if (!this.mergeBlocks(n2, n3, true)) {
            Element element = ElementUtils.findSharedParent(n2, n3, this.getDefaultRootElement());
            this.removeRange(element, n2, n2 + n3, eventList);
            eventList.addEvent(this.getContent().remove(n2, n3));
            if (n2 > element.getStartOffset() && n2 < element.getEndOffset()) {
                Element element2 = ElementUtils.getLeafAt(element, n2 - 1);
                Element element3 = ElementUtils.getLeafAt(element, n2);
                Element element4 = element2.getParentElement();
                Element element5 = element3.getParentElement();
                if (element3.getAttributes().isDefined("CR") && element4 != element5) {
                    ContentElement contentElement = this.createLeafElement(element4, element3.getAttributes(), element3.getStartOffset(), element3.getEndOffset());
                    this.removeCompleteImpl(element3, eventList);
                    int n5 = element4.getElementCount();
                    Element[] elementArray = new Element[]{contentElement};
                    ((AbstractDocument.BranchElement)element4).replace(n5, 0, elementArray);
                    eventList.getEventFor(element4, n5, new Element[0], elementArray);
                }
            }
        }
        if (this.getLength() == 0) {
            this.styleResolver.clearStyles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getCharacterElement(int n2) {
        try {
            this.readLock();
            Element element = ElementUtils.getLeafAt(this.getDefaultRootElement(), n2);
            return element;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int getLength() {
        return super.getLength() - 1;
    }

    public int getModelLength() {
        return super.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBody(EventList eventList) {
        int n2 = this.getModelLength();
        ++this.siteCount;
        boolean bl2 = false;
        try {
            this.allowTableEdit = true;
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl2 = true;
            }
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.getDefaultRootElement();
            AbstractDocument.Content content = this.getContent();
            if (n2 > 0) {
                eventList.add(content.remove(0, n2));
                n2 = this.getModelLength();
            }
            if (n2 <= 0) {
                eventList.add(content.insertString(0, "\n"));
            }
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.BODY);
            BoxElement boxElement = this.createBranchElement((Element)branchElement, simpleAttributeSet);
            simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
            simpleAttributeSet.addAttribute("CR", Boolean.TRUE);
            Element[] elementArray = new Element[]{this.createLeafElement((Element)boxElement, simpleAttributeSet, 0, 1)};
            boxElement.replace(0, 0, elementArray);
            elementArray = new Element[]{boxElement};
            Element[] elementArray2 = ElementUtils.getChildren(branchElement, 0, branchElement.getElementCount());
            branchElement.replace(0, elementArray2 != null ? elementArray2.length : 0, elementArray);
            eventList.add(new StyleSheetClearEdit(this.styleResolver.getStyles()));
            Styles styles = new Styles("INLINE", (Styles)this.getProperty(PROPERTY_PERSISTENT_STYLES));
            this.styleResolver.setStyles(styles);
            Object object = this.getProperty(PROPERTY_DEFAULT_FONT);
            if (object != null) {
                if (object instanceof Font) {
                    SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
                    Font font = (Font)object;
                    simpleAttributeSet2.addAttribute((Object)CSS.Attribute.FONT_SIZE, new FontSize(font.getSize(), true));
                    CSS.setFontFamily(simpleAttributeSet2, font.getName());
                    CSS.setFontStyle(simpleAttributeSet2, font.isItalic());
                    CSS.setFontWeight(simpleAttributeSet2, font.isBold());
                    styles.addInitialRule("body", simpleAttributeSet2, null);
                }
                if (object instanceof MutableAttributeSet) {
                    styles.addInitialRule("body", (MutableAttributeSet)object, null);
                }
            }
            ElementUtils.clearTemp(branchElement);
            ElementUtils.clearTemp(boxElement);
            this.fillAttributes(branchElement);
            eventList.getEventFor(branchElement, 0, elementArray2 != null ? elementArray2 : new Element[]{}, elementArray);
        }
        catch (BadLocationException badLocationException) {
            if (Logger.doesLog(1)) {
                Logger.error(badLocationException);
            }
        }
        finally {
            this.allowTableEdit = false;
            if (bl2) {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeComplete(Element element) {
        boolean bl2 = false;
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset();
        EventList eventList = new EventList();
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl2 = true;
            }
            this.removeCompleteImpl(element, eventList);
            eventList.addEvent(this.getContent().remove(n2, n3 - n2));
        }
        catch (BadLocationException badLocationException) {
            if (Logger.doesLog(1)) {
                Logger.error(badLocationException);
            }
        }
        finally {
            if (bl2) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(n2, n3 - n2, DocumentEvent.EventType.REMOVE, eventList);
    }

    void removeCompleteImpl(Element element, EventList eventList) {
        Element element2;
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset();
        Element element3 = this.getDefaultRootElement().getElement(this.getDefaultRootElement().getElementCount() - 1);
        for (element2 = element.getParentElement(); element2.getParentElement() != null && element2 != element3 && element2.getStartOffset() == n2 && element2.getEndOffset() == n3 && (this.allowTableEdit || !ElementUtils.isTablePart(element2.getParentElement())); element2 = element2.getParentElement()) {
            element = element2;
        }
        int n4 = ElementUtils.getChildIndex(element2, element);
        Element[] elementArray = new Element[]{};
        ((AbstractDocument.BranchElement)element2).replace(n4, 1, elementArray);
        if (eventList != null) {
            eventList.getEventFor(element2, n4, new Element[]{element}, elementArray);
        }
    }

    private void removeRange(Element element, int n2, int n3, EventList eventList) {
        if (element.isLeaf()) {
            return;
        }
        int n4 = element.getElementIndex(n2);
        int n5 = element.getElementIndex(n3);
        Element element2 = element.getElement(n4);
        Element element3 = element.getElement(n5);
        int n6 = element2.getEndOffset();
        int n7 = element2.getStartOffset();
        int n8 = element3.getEndOffset();
        int n9 = element3.getStartOffset();
        if (element2 == element3) {
            if (n7 == n2 && n6 == n3) {
                n5 = n4 + 1;
            } else {
                this.removeRange(element2, n2, n3, eventList);
            }
        } else {
            if (n7 < n2) {
                this.removeRange(element2, n2, n6, eventList);
                ++n4;
            }
            if (n8 > n3) {
                if (n9 < n3) {
                    this.removeRange(element3, n9, n3, eventList);
                }
            } else {
                ++n5;
            }
        }
        int n10 = n5 - n4;
        if (n10 > 0) {
            Element[] elementArray = new Element[]{};
            Element[] elementArray2 = ElementUtils.getChildren(element, n4, n10);
            boolean bl2 = false;
            for (Element element4 : elementArray2) {
                if (this.allowTableEdit || !ElementUtils.isTablePart(element4, true)) continue;
                this.removeRange(element4, element4.getStartOffset(), element4.getEndOffset(), eventList);
                bl2 = true;
            }
            if (!bl2) {
                if (eventList != null) {
                    eventList.getEventFor(element, n4, elementArray2, elementArray);
                }
                ((AbstractDocument.BranchElement)element).replace(n4, n10, elementArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(AttributeSet attributeSet, int n2, int n3, boolean bl2) {
        boolean bl3 = false;
        EventList eventList = new EventList();
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl3 = true;
            }
            int n4 = n2;
            while (n4 < n3) {
                Element element;
                for (element = ElementUtils.getLeafAt(this.getDefaultRootElement(), n4); element != null && !StyleResolver.matchesAttributes(element, attributeSet); element = element.getParentElement()) {
                }
                if (element == null) {
                    ++n4;
                    continue;
                }
                int n5 = element.getEndOffset();
                if (element.isLeaf()) {
                    n4 = n5;
                    continue;
                }
                Element element2 = element.getParentElement();
                int n6 = ElementUtils.getChildIndex(element2, element);
                int n7 = element.getStartOffset();
                ((AbstractDocument.BranchElement)element2).replace(n6, 1, new Element[0]);
                this.createCopy(element, element2, n7, n5, n6);
                Element[] elementArray = ElementUtils.getChildren(element2, n6, element.getElementCount());
                Element[] elementArray2 = new Element[]{element};
                eventList.getEventFor(element2, n6, elementArray2, elementArray);
                if (bl2) {
                    SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(element.getAttributes());
                    simpleAttributeSet.removeAttribute((Object)HTML.Attribute.ALINK);
                    simpleAttributeSet.removeAttribute((Object)HTML.Attribute.ALT);
                    simpleAttributeSet.removeAttribute((Object)HTML.Attribute.CLASS);
                    simpleAttributeSet.removeAttribute((Object)HTML.Attribute.CLEAR);
                    simpleAttributeSet.removeAttribute((Object)HTML.Attribute.HREF);
                    simpleAttributeSet.removeAttribute((Object)HTML.Attribute.NAME);
                    simpleAttributeSet.removeAttribute((Object)HTML.Attribute.ID);
                    simpleAttributeSet.removeAttribute((Object)HTML.Attribute.SRC);
                    simpleAttributeSet.removeAttribute(StyleConstants.NameAttribute);
                    simpleAttributeSet.removeAttribute(StyleConstants.IconAttribute);
                    ElementUtils.clearTemp(simpleAttributeSet);
                    Element element3 = ElementUtils.findNextHigherBlock(element);
                    this.setCharacterAttributesSegment(n7, n5 - n7, element3, simpleAttributeSet, false, false, eventList);
                    element2 = element3;
                }
                this.splice(element2, n7, eventList, false);
                this.splice(element2, n5, eventList, false);
                n4 = n5;
            }
        }
        finally {
            if (bl3) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(n2, n3 - n2, DocumentEvent.EventType.CHANGE, eventList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mergeBlocks(int n2, int n3, boolean bl2) throws BadLocationException {
        Object object;
        int n4;
        boolean bl3;
        Element element = ElementUtils.findSharedParagraph(n2, n3, this.getDefaultRootElement());
        Element element2 = ElementUtils.findSharedParent(n2, n3, element);
        int n5 = n2 + n3;
        Element element3 = this.getParagraphElement(n2, element2);
        Element element4 = this.getParagraphElement(n5, element2);
        Element element5 = ElementUtils.getLeafAt(element3, n2);
        boolean bl4 = element3 == element;
        boolean bl5 = bl3 = element4 == element;
        if (bl4 && bl3 && this.getUpperContentBoundary(n2, element) >= n2 + n3) {
            if (element5.isLeaf() && n3 == 1 && element5.getEndOffset() - element5.getStartOffset() == 1) {
                this.removeComplete(element5);
                return true;
            }
            return false;
        }
        if (n3 == 1 && element3.getEndOffset() - element3.getStartOffset() == 1) {
            this.removeComplete(element3);
            return true;
        }
        EventList eventList = new EventList();
        boolean bl6 = false;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl6 = true;
            }
            if (n2 != element3.getStartOffset() && element5.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.HR) {
                int n6;
                n4 = this.getUpperContentBoundary(n5, element4);
                Element element6 = this.createCopy(element4, n5, n4, element3);
                if (element6.getElementCount() == 0) {
                    ++n4;
                    ++n3;
                }
                if (!(object = element3.getElement(element3.getElementIndex(n2))).isLeaf() && object.getEndOffset() - object.getStartOffset() > 1) {
                    n6 = this.getContent().length();
                    this.splitElement((Element)object, n2, null, eventList, false, true);
                    int n7 = this.getContent().length() - n6;
                    n4 += n7;
                    element = ElementUtils.findSharedParagraph(n2, n3 += n7, this.getDefaultRootElement());
                    element2 = ElementUtils.findSharedParent(n2, n3, element);
                    element3 = this.getParagraphElement(n2, element2);
                }
                this.removeRange(element, n2, n4, eventList);
                eventList.addEvent(this.getContent().remove(n2, n3));
                if (element6.getElementCount() > 0) {
                    n6 = element3.getElementIndex(n2);
                    if (element3.getElement(n6).getEndOffset() == n2) {
                        ++n6;
                    }
                    this.createCopy(element6, element3, element6.getStartOffset(), element6.getEndOffset(), n6);
                    Element[] elementArray = ElementUtils.getChildren(element3, n6, element6.getElementCount());
                    eventList.getEventFor(element3, n6, new Element[0], elementArray);
                    if (bl2) {
                        this.splice(element, n2, eventList, false);
                    }
                } else {
                    eventList.addEvent(this.getContent().insertString(n2, "\n"));
                }
            } else {
                this.removeRange(element, n2, n2 + n3, eventList);
                eventList.addEvent(this.getContent().remove(n2, n3));
            }
        }
        finally {
            if (bl6) {
                this.writeUnlock();
            }
        }
        n4 = n2;
        int n8 = n3;
        object = new ExtendedDocuementEvent(n4, n8, n3, DocumentEvent.EventType.REMOVE, this);
        eventList.fillEvent((AbstractDocument.DefaultDocumentEvent)object);
        ((CompoundEdit)object).end();
        this.fireRemoveUpdate((DocumentEvent)object);
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, (UndoableEdit)object);
        this.fireUndoableEditUpdate(undoableEditEvent);
        return true;
    }

    private void cropElement(Element element, int n2, int n3, EventList eventList) {
        if (element.getStartOffset() < n2 || element.getEndOffset() > n3) {
            if (!element.isLeaf()) {
                int n4;
                Element[] elementArray;
                int n5;
                int n6 = -1;
                int n7 = -1;
                int n8 = -1;
                int n9 = -1;
                int n10 = -1;
                int n11 = -1;
                int n12 = element.getElementCount();
                for (n5 = 0; n5 < n12; ++n5) {
                    elementArray = element.getElement(n5);
                    if (elementArray.getEndOffset() < n2) {
                        if (n6 <= 0) {
                            n6 = 0;
                        }
                        n7 = n5 + 1;
                    }
                    if (elementArray.getStartOffset() > n3) {
                        if (n9 <= 0) {
                            n9 = n5;
                        }
                        n10 = n5 + 1;
                    }
                    if (elementArray.getStartOffset() < n2 && elementArray.getEndOffset() > n2) {
                        n8 = n5;
                    }
                    if (elementArray.getStartOffset() >= n3 || elementArray.getEndOffset() <= n3) continue;
                    n11 = n5;
                }
                if (n8 >= 0) {
                    this.cropElement(element.getElement(n8), n2, n3, eventList);
                }
                if (n11 >= 0 && n11 != n8) {
                    this.cropElement(element.getElement(n11), n2, n3, eventList);
                }
                if (n6 >= 0) {
                    n5 = n7 - n6;
                    elementArray = new Element[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        elementArray[n4] = element.getElement(n6 + n4);
                    }
                    ((AbstractDocument.BranchElement)element).replace(n6, n5, new Element[0]);
                    if (eventList != null) {
                        eventList.getEventFor(element, n6, elementArray, new Element[0]);
                    }
                }
                if (n9 >= 0) {
                    n5 = n10 - n9;
                    elementArray = new Element[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        elementArray[n4] = element.getElement(n9 + n4);
                    }
                    ((AbstractDocument.BranchElement)element).replace(n9, n5, new Element[0]);
                    if (eventList != null) {
                        eventList.getEventFor(element, n9, elementArray, new Element[0]);
                    }
                }
            } else {
                Element element2 = element.getParentElement();
                AttributeSet attributeSet = element.getAttributes().copyAttributes();
                int n13 = element.getStartOffset() > n2 ? element.getStartOffset() : n2;
                int n14 = element.getEndOffset() < n3 ? element.getEndOffset() : n3;
                ContentElement contentElement = this.createLeafElement(element2, attributeSet, n13, n14);
                int n15 = ElementUtils.getChildIndex(element2, element);
                Element[] elementArray = new Element[]{element};
                Element[] elementArray2 = new Element[]{contentElement};
                ((AbstractDocument.BranchElement)element2).replace(n15, 1, elementArray2);
                if (eventList != null) {
                    eventList.getEventFor(element2, n15, elementArray, elementArray2);
                }
            }
        }
    }

    private void splice(Element element, int n2, EventList eventList, boolean bl2) {
        block20: {
            Object object;
            Element[] elementArray;
            boolean bl3;
            Element element2;
            Element element3;
            if (n2 < 1 || n2 >= element.getEndOffset()) {
                return;
            }
            if (bl2) {
                element3 = this.getParagraphElement(n2 - 1);
                element2 = this.getParagraphElement(n2);
            } else {
                element3 = element.getElement(element.getElementIndex(n2 - 1));
                element2 = element.getElement(element.getElementIndex(n2));
            }
            if (element3 == element2) {
                if (element3 != null && !element3.isLeaf()) {
                    this.splice(element3, n2, eventList, false);
                }
                return;
            }
            boolean bl4 = bl3 = !(!StyleResolver.matchesAttributes(element3, element2.getAttributes()) || !StyleResolver.matchesAttributes(element2, element3.getAttributes()) || element3.isLeaf() && !ElementUtils.isContent(element3) || element2.isLeaf() && !ElementUtils.isContent(element2));
            if (bl2) {
                elementArray = StyleResolver.getAttributeValue(element3, AttributeFinder.DISPLAY);
                object = StyleResolver.getAttributeValue(element2, AttributeFinder.DISPLAY);
                if (elementArray != null && elementArray.isBlockElement() && object != null && object.isBlockElement()) {
                    bl3 = true;
                }
            }
            if (bl3) {
                if (element3.isLeaf() && element2.isLeaf()) {
                    elementArray = new Element[]{element3, element2};
                    object = new Element[]{this.createLeafElement(element, element3.getAttributes().copyAttributes(), element3.getStartOffset(), element2.getEndOffset())};
                    int n3 = ElementUtils.getChildIndex(element, element3);
                    ((AbstractDocument.BranchElement)element).replace(n3, 2, (Element[])object);
                    if (eventList != null) {
                        eventList.getEventFor(element, n3, elementArray, (Element[])object);
                    }
                } else {
                    int n4;
                    elementArray = null;
                    object = element3.getElement(element3.getElementCount() - 1);
                    int n5 = 0;
                    if (object != null && object.getStartOffset() == object.getEndOffset()) {
                        n5 = 1;
                    }
                    if (eventList != null) {
                        int n6 = element3.getElementCount() - 1 - n5;
                        n6 = n6 >= 0 ? n6 : 0;
                        elementArray = this.spliceElements(element3.getElement(n6), element2.getElement(0));
                    }
                    Element[] elementArray2 = null;
                    elementArray2 = elementArray != null ? (n5 > 0 ? new Element[]{element3.getElement(element3.getElementCount() - 2), object} : new Element[]{element3.getElement(element3.getElementCount() - 1)}) : (n5 > 0 ? new Element[]{object} : new Element[]{});
                    Element[] elementArray3 = new Element[element2.getElementCount()];
                    for (n4 = 0; n4 < element2.getElementCount(); ++n4) {
                        if (elementArray != null && n4 == 0) {
                            elementArray3[n4] = elementArray;
                            continue;
                        }
                        Element element4 = element2.getElement(n4);
                        if (element4 instanceof ElementClonable) {
                            elementArray3[n4] = ((ElementClonable)((Object)element4)).clone(element3);
                            continue;
                        }
                        Logger.error("The current document object is not a valid InetHtml document.");
                    }
                    n4 = element3.getElementCount() - elementArray2.length;
                    ((AbstractDocument.BranchElement)element3).replace(n4, elementArray2.length, elementArray3);
                    if (eventList != null) {
                        eventList.getEventFor(element3, n4, elementArray2, elementArray3);
                    }
                    this.removeCompleteImpl(element2, eventList);
                    this.splice(element3, n2, eventList, false);
                }
                int n7 = n2 - 1;
                try {
                    if (eventList != null && "\n".equals(this.getText(n7, 1)) && ElementUtils.isContent(ElementUtils.getLeafAt(element3, n7))) {
                        object = this.getContent().remove(n7, 1);
                        eventList.addEvent(object);
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (!Logger.doesLog(1)) break block20;
                    Logger.error(badLocationException);
                }
            }
        }
    }

    private Element spliceElements(Element element, Element element2) {
        if (element == element2 || element == null || element2 == null) {
            return null;
        }
        if (!(!element.getAttributes().isEqual(element2.getAttributes()) || element.isLeaf() && !ElementUtils.isContent(element) || element2.isLeaf() && !ElementUtils.isContent(element2))) {
            int n2;
            if (element.isLeaf() && element2.isLeaf()) {
                return this.createLeafElement(element.getParentElement(), element.getAttributes().copyAttributes(), element.getStartOffset(), element2.getEndOffset());
            }
            Element[] elementArray = new Element[element.getElementCount() + element2.getElementCount()];
            BoxElement boxElement = this.createBranchElement(element.getParentElement(), element.getAttributes().copyAttributes());
            for (n2 = 0; n2 < element.getElementCount(); ++n2) {
                elementArray[n2] = ((ElementClonable)((Object)element.getElement(n2))).clone(boxElement);
            }
            n2 = element.getElementCount();
            for (int i2 = 0; i2 < element2.getElementCount(); ++i2) {
                elementArray[i2 + n2] = ((ElementClonable)((Object)element2.getElement(i2))).clone(boxElement);
            }
            boxElement.replace(0, 0, elementArray);
            return boxElement;
        }
        return null;
    }

    @Override
    public void replace(int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
        if (Logger.doesLog(4)) {
            Logger.debug("InetHtmlDocument:replace(" + n2 + ", " + n3 + ", '" + string + "', " + (attributeSet != null ? attributeSet.getAttribute(StyleConstants.NameAttribute) : "no attributes") + ")");
        }
        if (!this.allowTableEdit && ElementUtils.crossesTable(n2, n2 + n3, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        super.replace(n2, n3, string, attributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractDocument.AbstractElement createDefaultRoot() {
        try {
            Object object;
            SimpleAttributeSet simpleAttributeSet;
            block8: {
                this.writeLock();
                simpleAttributeSet = new SimpleAttributeSet();
                try {
                    object = this.getContent();
                    int n2 = this.getModelLength();
                    if (n2 > 0) {
                        object.remove(0, n2);
                        n2 = this.getModelLength();
                    }
                    if (n2 <= 0) {
                        object.insertString(0, "\n");
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (!Logger.doesLog(1)) break block8;
                    Logger.error(badLocationException);
                }
            }
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.HTML);
            object = this.createBranchElement(null, simpleAttributeSet.copyAttributes());
            simpleAttributeSet.removeAttributes(simpleAttributeSet);
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.BODY);
            BoxElement boxElement = this.createBranchElement((Element)object, simpleAttributeSet.copyAttributes());
            simpleAttributeSet.removeAttributes(simpleAttributeSet);
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
            ContentElement contentElement = this.createLeafElement((Element)boxElement, simpleAttributeSet, 0, 1);
            Element[] elementArray = new Element[]{contentElement};
            boxElement.replace(0, 0, elementArray);
            elementArray[0] = boxElement;
            ((AbstractDocument.BranchElement)object).replace(0, 0, elementArray);
            if (this.styleResolver != null) {
                this.fillAttributes((Element)object);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setBase(URL uRL) {
        uRL = URLUtils.safeEncode(uRL);
        this.putProperty("stream", uRL);
    }

    @Override
    public URL getBase() {
        Object object = this.getProperty("stream");
        if (object instanceof URL) {
            return (URL)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillAttributes(Element element) {
        boolean bl2 = false;
        try {
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl2 = true;
            }
            this.styleResolver.fillAttributesNonLocked(element, null);
        }
        finally {
            if (bl2) {
                this.writeUnlock();
            }
        }
    }

    public void checkInit(Element element) {
        if (this.getCurrentWriter() != null && this.getCurrentWriter() == Thread.currentThread() && !element.getAttributes().isDefined(FLAG_INIT)) {
            this.fillAttributes(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        try {
            this.writeLock();
            if (object2 != null && attributeSet != null && object != null && attributeSet instanceof MutableAttributeSet) {
                ((MutableAttributeSet)attributeSet).addAttribute(object, object2);
            }
            return;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Deprecated
    public void setDocType(int n2) {
        this.setDocVariant(n2);
    }

    @Deprecated
    public void setDocVersion(float f2) {
        this.getDocType().setVersion(f2);
    }

    @Deprecated
    public void setDocVariant(int n2) {
        DocType docType = this.getDocType();
        switch (n2) {
            case 1: {
                docType.setType(DocType.Type.HTML);
                break;
            }
            case 3: {
                docType.setVariant(DocType.Variant.Strict);
                break;
            }
            case 5: {
                docType.setVariant(DocType.Variant.Frameset);
                break;
            }
            case 2: {
                docType.setType(DocType.Type.XHTML);
                break;
            }
            case 4: {
                docType.setVariant(DocType.Variant.Transitional);
                break;
            }
            case 0: {
                docType.setType(DocType.Type.quirks);
            }
        }
    }

    @Deprecated
    public float getHtmlVersion() {
        switch (this.docType.getType()) {
            case HTML: {
                return this.docType.getVersion();
            }
            case XHTML: {
                if (this.docType.getVersion() < 2.0f) {
                    return this.docType.getVersion() + 3.0f;
                }
                return this.docType.getVersion();
            }
        }
        return 3.2f;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public Element getParagraphElement(int n2, Element element) {
        int n3;
        Element element2 = element;
        if (element2.getElementCount() == 0) {
            return element2;
        }
        Element element3 = null;
        for (element2 = element; element2 != null && !element2.isLeaf(); element2 = element2.getElement(n3)) {
            n3 = element2.getElementIndex(n2);
            element3 = element2;
        }
        if (element2 == null) {
            if (element3 != null) {
                element2 = element3;
            } else {
                return element;
            }
        }
        DisplayValue displayValue = StyleResolver.getAttributeValue(element2, AttributeFinder.DISPLAY);
        while (displayValue != null && displayValue.getDisplay() == 2 && element2.getParentElement() != null && element2.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED) {
            element2 = element2.getParentElement();
            displayValue = StyleResolver.getAttributeValue(element2, AttributeFinder.DISPLAY);
        }
        return element2;
    }

    public Element getNextParagraphElement(int n2, Element element) {
        int n3;
        Element element2 = element;
        if (element2.getElementCount() == 0) {
            return element2;
        }
        DisplayValue displayValue = StyleResolver.getAttributeValue(element2, AttributeFinder.DISPLAY);
        for (element2 = element; element2 != null && displayValue.getDisplay() == 2 && element2.getParentElement() != null && element2.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.IMPLIED; element2 = element2.getElement(n3)) {
            n3 = element2.getElementIndex(n2);
            displayValue = StyleResolver.getAttributeValue(element2, AttributeFinder.DISPLAY);
        }
        return element2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getParagraphElement(int n2) {
        if (this.styleResolver == null) {
            return null;
        }
        try {
            this.readLock();
            Element element = this.getParagraphElement(n2, this.getDefaultRootElement());
            return element;
        }
        finally {
            this.readUnlock();
        }
    }

    public int getBlockStart(int n2) {
        return this.getLowerContentBoundary(n2, this.getParagraphElement(n2, this.getDefaultRootElement()));
    }

    @Override
    public void setCharacterAttributes(int n2, int n3, AttributeSet attributeSet, boolean bl2) {
        this.setCharacterAttributes(n2, n3, attributeSet, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterAttributes(int n2, int n3, AttributeSet attributeSet, boolean bl2, boolean bl3) {
        EventList eventList = new EventList();
        Element element = this.getParagraphElement(n2);
        int n4 = n2;
        int n5 = n2 + n3;
        Element element2 = this.getParagraphElement(n5);
        if (n5 == element2.getEndOffset() - 1) {
            ++n3;
            ++n5;
        }
        int n6 = 0;
        try {
            this.writeLock();
            while (n4 < n5) {
                Element element3 = this.getParagraphElement(n4);
                n6 = this.getUpperContentBoundary(n4, element3);
                if (n6 == n4) {
                    ++n4;
                    continue;
                }
                if (element3.isLeaf()) {
                    n4 = n6;
                    continue;
                }
                this.setCharacterAttributesSegment(n4, (n6 < n5 ? n6 : n5) - n4, element3, attributeSet, bl2, bl3, eventList);
                n4 = n6;
            }
            this.splice(element, n2, eventList, false);
            this.splice(this.getParagraphElement(n5), n5, eventList, false);
        }
        finally {
            this.writeUnlock();
        }
        this.fireUpdateEvent(n2, n3, DocumentEvent.EventType.CHANGE, eventList);
    }

    public int findNextBlank(int n2, boolean bl2) {
        int n3 = Math.max(0, n2 - (bl2 ? 0 : 3000));
        int n4 = Math.min(this.getLength(), n2 + (bl2 ? 3000 : 0));
        Segment segment = new Segment();
        try {
            this.getContent().getChars(n3, n4 - n3, segment);
        }
        catch (BadLocationException badLocationException) {
            return n2;
        }
        int n5 = n3 - segment.getBeginIndex();
        if (bl2) {
            char c2 = segment.first();
            while (segment.getIndex() < segment.getEndIndex()) {
                if (c2 == ' ' || c2 == '\u00a0' || c2 == '\n') {
                    return segment.getIndex() + n5;
                }
                c2 = segment.next();
            }
            return segment.getEndIndex() + n5;
        }
        char c3 = segment.last();
        while (segment.getIndex() > segment.getBeginIndex()) {
            if (c3 == ' ' || c3 == '\u00a0' || c3 == '\n') {
                return segment.getIndex() + n5 + 1;
            }
            c3 = segment.previous();
        }
        return segment.getBeginIndex() + n5;
    }

    private void setCharacterAttributesSegment(int n2, int n3, Element element, AttributeSet attributeSet, boolean bl2, boolean bl3, EventList eventList) {
        int n4 = n2;
        Element element2 = null;
        int n5 = n2 + n3;
        boolean bl4 = attributeSet.containsAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.A);
        while (n4 < n5) {
            Element[] elementArray;
            Element element3;
            Object object;
            Object object2;
            element2 = ElementUtils.getLeafAt(element, n4);
            if (StyleResolver.matchesAttributes(element2, attributeSet)) {
                n4 = element2.getEndOffset();
                continue;
            }
            if (element2.getParentElement() != element && !this.configuration.isInlineBoxCompatible() && !bl3) {
                block21: {
                    object2 = element2.getParentElement();
                    try {
                        if (n4 > object2.getStartOffset()) {
                            this.splitElement((Element)object2, n4, null, eventList, false, true);
                            object = ElementUtils.getLeafAt(element, n4);
                            object2 = object.getParentElement();
                        }
                        if (object2.getEndOffset() > n5) {
                            this.splitElement((Element)object2, n5, null, eventList, false, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        if (!Logger.doesLog(4)) break block21;
                        Logger.debug(badLocationException.getMessage());
                    }
                }
                element2 = ElementUtils.getLeafAt(element, n4);
            } else {
                if (n4 > element2.getStartOffset()) {
                    this.splitContentElement(element2, n4, eventList);
                    element2 = ElementUtils.getLeafAt(element, n4);
                }
                if (element2.getEndOffset() > n5) {
                    this.splitContentElement(element2, n5, eventList);
                    element2 = ElementUtils.getLeafAt(element, n4);
                }
            }
            if (element2.getParentElement() != element) {
                object2 = element2.getParentElement();
                if (object2.getStartOffset() >= n2 && object2.getEndOffset() <= n5) {
                    object = new SimpleAttributeSet(object2.getAttributes());
                    ElementUtils.clearTemp((MutableAttributeSet)object);
                    if (bl2) {
                        object.removeAttributes((AttributeSet)object);
                    }
                    object.addAttributes(attributeSet);
                    element3 = this.createCopy((Element)object2, this.createBranchElement(object2.getParentElement(), (AttributeSet)object), 0, this.getModelLength());
                    this.fillAttributes(element3);
                    if (StyleResolver.hasRelevantInlineStyles(element3)) {
                        this.replaceElements(new Element[]{object2}, new Element[]{element3}, eventList);
                    } else {
                        elementArray = new Element[object2.getElementCount()];
                        for (int i2 = 0; i2 < object2.getElementCount(); ++i2) {
                            Element element4 = object2.getElement(i2);
                            elementArray[i2] = element4.isLeaf() ? this.createLeafElement(object2.getParentElement(), element4.getAttributes().copyAttributes(), element4.getStartOffset(), element4.getEndOffset()) : this.createCopy(element4, this.createBranchElement(object2.getParentElement(), element4.getAttributes().copyAttributes()), 0, this.getModelLength());
                        }
                        this.replaceElements(new Element[]{object2}, elementArray, eventList);
                    }
                    this.splice(element, n4, eventList, false);
                    n4 = element3.getEndOffset();
                    continue;
                }
                object = new SimpleAttributeSet();
                object.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.SPAN);
                if (bl2) {
                    object.removeAttributes((AttributeSet)object);
                }
                object.addAttributes(attributeSet);
                element3 = this.createBranchElement((Element)object2, (AttributeSet)object);
                elementArray = new Element[]{element2};
                this.createCopy((Element)object2, element3, element2.getStartOffset(), element2.getEndOffset());
                this.fillAttributes(element3);
                if (StyleResolver.hasRelevantInlineStyles(element3)) {
                    this.replaceElements(elementArray, new Element[]{element3}, eventList);
                }
                this.splice(element, n4, eventList, false);
                n4 = ((BoxElement)element3).getEndOffset();
                continue;
            }
            object2 = new SimpleAttributeSet();
            if (bl2) {
                object2.removeAttributes((AttributeSet)object2);
            }
            object2.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.SPAN);
            object2.addAttributes(attributeSet);
            if (bl4 && element2.getAttributes().isDefined("CR")) {
                object2.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.SPAN);
                object2.removeAttribute((Object)HTML.Attribute.HREF);
                object2.removeAttribute((Object)HTML.Attribute.NAME);
                object2.removeAttribute((Object)HTML.Attribute.TITLE);
                object2.removeAttribute((Object)HTML.Attribute.ALT);
            }
            object = this.createBranchElement(element, (AttributeSet)object2);
            element3 = this.createLeafElement((Element)object, element2.getAttributes().copyAttributes(), element2.getStartOffset(), element2.getEndOffset());
            elementArray = new Element[]{element2};
            ((AbstractDocument.BranchElement)object).replace(0, 0, new Element[]{element3});
            ElementUtils.clearTemp((MutableAttributeSet)object);
            this.fillAttributes((Element)object);
            if (StyleResolver.hasRelevantInlineStyles((Element)object)) {
                this.replaceElements(elementArray, new Element[]{object}, eventList);
            }
            this.splice(element, n4, eventList, false);
            n4 = ((BoxElement)object).getEndOffset();
        }
    }

    private void replaceElements(Element[] elementArray, Element[] elementArray2, EventList eventList) {
        if (elementArray == null || elementArray.length == 0) {
            return;
        }
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)elementArray[0].getParentElement();
        int n2 = ElementUtils.getChildIndex(branchElement, elementArray[0]);
        branchElement.replace(n2, elementArray.length, elementArray2);
        eventList.getEventFor(branchElement, n2, elementArray, elementArray2);
    }

    void splitContentElement(Element element, int n2, EventList eventList) {
        if (n2 == element.getStartOffset() || n2 == element.getEndOffset() || !(element instanceof AbstractDocument.LeafElement)) {
            return;
        }
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element.getParentElement();
        AttributeSet attributeSet = element.getAttributes();
        ContentElement contentElement = this.createLeafElement((Element)branchElement, attributeSet.copyAttributes(), element.getStartOffset(), n2);
        ContentElement contentElement2 = this.createLeafElement((Element)branchElement, attributeSet.copyAttributes(), n2, element.getEndOffset());
        Element[] elementArray = new Element[]{element};
        Element[] elementArray2 = new Element[]{contentElement, contentElement2};
        int n3 = ElementUtils.getChildIndex(branchElement, element);
        branchElement.replace(n3, 1, elementArray2);
        if (eventList != null) {
            eventList.getEventFor(branchElement, n3, elementArray, elementArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParagraphAttributes(int n2, int n3, AttributeSet attributeSet, boolean bl2) {
        if (!this.allowTableEdit && ElementUtils.crossesTable(n2, n2 + n3, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        int n4 = n2;
        int n5 = Math.min(n2 + (n3 > 0 ? n3 : 1), this.getModelLength());
        AttributeSet attributeSet2 = attributeSet.copyAttributes();
        EventList eventList = new EventList();
        try {
            this.writeLock();
            while (n4 < n5) {
                Element element = this.getParagraphElement(n4);
                boolean bl3 = ElementUtils.isTablePart(element);
                if ((element.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY || bl3) && ElementUtils.isContent(element)) {
                    int n6 = this.getLowerContentBoundary(n4, element);
                    int n7 = this.getUpperContentBoundary(n4, element);
                    if (n6 != element.getStartOffset() || n7 != element.getEndOffset() || bl3) {
                        try {
                            element = this.wrapImpliedElement(n4, eventList);
                        }
                        catch (BadLocationException badLocationException) {
                            Logger.error("Exception: " + badLocationException.getMessage());
                        }
                    }
                }
                if (!element.isLeaf()) {
                    this.setAttributeToElement(element, attributeSet2, bl2, eventList);
                } else {
                    ++n4;
                }
                n4 = this.getUpperContentBoundary(n4, element);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.fireUpdateEvent(n2, n3, DocumentEvent.EventType.CHANGE, eventList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setElementAttributes(Element element, AttributeSet attributeSet, boolean bl2) {
        if (element.getDocument() != this || attributeSet == null) {
            return;
        }
        DefaultStyledDocument.AttributeUndoableEdit attributeUndoableEdit = new DefaultStyledDocument.AttributeUndoableEdit(element, attributeSet, bl2);
        try {
            this.writeLock();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
            if (bl2) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(attributeSet);
        }
        finally {
            this.writeUnlock();
        }
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset();
        EventList eventList = new EventList();
        eventList.addEvent(attributeUndoableEdit);
        this.fireUpdateEvent(n2, n3 - n2, DocumentEvent.EventType.CHANGE, eventList);
    }

    private void fireUpdateEvent(int n2, int n3, DocumentEvent.EventType eventType, EventList eventList) {
        if (eventList.size() == 0) {
            return;
        }
        ExtendedDocuementEvent extendedDocuementEvent = new ExtendedDocuementEvent(n2, n3, eventType, this);
        eventList.fillEvent(extendedDocuementEvent);
        extendedDocuementEvent.end();
        if (eventType == DocumentEvent.EventType.INSERT) {
            this.fireInsertUpdate(extendedDocuementEvent);
        } else if (eventType == DocumentEvent.EventType.REMOVE) {
            this.fireRemoveUpdate(extendedDocuementEvent);
        } else {
            this.fireChangedUpdate(extendedDocuementEvent);
        }
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, extendedDocuementEvent));
    }

    private void setAttributeToElement(Element element, AttributeSet attributeSet, boolean bl2, EventList eventList) {
        MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
        eventList.addEvent(new HtmlAttributeUndoableEdit(element, attributeSet, bl2));
        if (bl2) {
            mutableAttributeSet.removeAttributes(mutableAttributeSet);
        }
        mutableAttributeSet.addAttributes(attributeSet);
        this.fillAttributes(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeIndent(int n2, int n3, int n4, boolean bl2) {
        int n5 = n3;
        int n6 = Math.min(n3 + (n4 > 0 ? n4 : 1), this.getModelLength());
        Element element = null;
        Element element2 = null;
        boolean bl3 = bl2;
        if (!this.allowTableEdit && ElementUtils.crossesTable(n3, n6, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        EventList eventList = new EventList();
        try {
            this.writeLock();
            while (n5 < n6) {
                int n7;
                Element[] elementArray;
                Object object;
                Element element3;
                Element element4;
                Object object2 = this.getParagraphElement(n5);
                if (object2.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY) {
                    try {
                        object2 = this.wrapImpliedElement(n5, eventList);
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.error("Exception: " + badLocationException.getMessage());
                    }
                }
                if ((element4 = ElementUtils.findListItemParent((Element)object2)) != null) {
                    if (bl2) {
                        Element[] elementArray2;
                        element3 = ElementUtils.findListContainer((Element)object2);
                        if (element == null || element3 != element2) {
                            object = ElementUtils.findNextHigherBlock(element4);
                            Object object3 = object.getAttributes().getAttribute(StyleConstants.NameAttribute);
                            if (object3 != HTML.Tag.UL && object3 != HTML.Tag.OL) {
                                object3 = HTML.Tag.UL;
                            }
                            elementArray = (AbstractDocument.BranchElement)element4.getParentElement();
                            element = this.createBranchElement((Element)elementArray, object3);
                            this.checkDefaultStyle(element);
                            elementArray2 = new Element[]{element};
                            Element[] elementArray3 = new Element[]{element4};
                            this.createCopy((Element)elementArray, element, element4.getStartOffset(), element4.getEndOffset(), 0);
                            this.replaceElements(elementArray3, elementArray2, eventList);
                            this.fillAttributes(element);
                            object2 = element.getElement(0);
                        } else {
                            object = (AbstractDocument.BranchElement)element4.getParentElement();
                            int n8 = element.getElementCount();
                            this.createCopy((Element)object, element, element4.getStartOffset(), element4.getEndOffset(), n8);
                            elementArray = new Element[]{};
                            this.replaceElements(new Element[]{element4}, elementArray, eventList);
                            elementArray2 = element.getElement(n8);
                            this.fillAttributes(element);
                            object2 = elementArray2;
                        }
                        element2 = element3;
                    } else {
                        element3 = ElementUtils.findNextHigherBlock(element4);
                        object = ElementUtils.findNextHigherBlock(element3);
                        Object object4 = element3.getAttributes().getAttribute(StyleConstants.NameAttribute);
                        elementArray = object.getAttributes().getAttribute(StyleConstants.NameAttribute);
                        if (!(object4 != HTML.Tag.UL && object4 != HTML.Tag.OL || elementArray != HTML.Tag.UL && elementArray != HTML.Tag.OL)) {
                            int n9 = ElementUtils.getChildIndex(element3, element4);
                            int n10 = ElementUtils.getChildIndex((Element)object, element3);
                            if (n9 != -1 && n9 > 0 && n9 < element3.getElementCount() - 1) {
                                this.splitElement(element3, element4.getStartOffset(), null, eventList, false, true);
                                element4 = ElementUtils.findListItemParent(ElementUtils.getLeafAt((Element)object, element4.getStartOffset()));
                                element3 = ElementUtils.findNextHigherBlock(element4);
                                n9 = ElementUtils.getChildIndex(element3, element4);
                                n10 = ElementUtils.getChildIndex((Element)object, element3);
                            }
                            boolean bl4 = n9 == 0;
                            this.createCopy(element3, (Element)object, element4.getStartOffset(), element4.getEndOffset(), n10 + (bl4 ? 0 : 1));
                            Element[] elementArray4 = new Element[]{object.getElement(n10 + (bl4 ? 0 : 1))};
                            Element[] elementArray5 = new Element[]{};
                            if (element3.getElementCount() <= 1) {
                                ((AbstractDocument.BranchElement)object).replace(n10 + (bl4 ? 1 : -1), 1, elementArray5);
                                elementArray5 = new Element[]{element3};
                            } else {
                                ((AbstractDocument.BranchElement)element3).replace(n9, 1, elementArray5);
                                eventList.getEventFor(element3, n9, new Element[]{element4}, elementArray5);
                            }
                            bl3 = true;
                            eventList.getEventFor((Element)object, n10 + (bl4 ? 0 : 1), elementArray5, elementArray4);
                            this.fillAttributes(elementArray4[0]);
                            object2 = elementArray4[0];
                        }
                    }
                    n5 = object2.getEndOffset();
                    continue;
                }
                element3 = null;
                element = null;
                if (!bl2) {
                    for (object = object2; object != null && object.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BLOCKQUOTE; object = object.getParentElement()) {
                    }
                    if (object != null) {
                        element3 = object;
                    }
                }
                if (element3 != null && (n7 = ElementUtils.getChildIndex((Element)(object = (AbstractDocument.BranchElement)element3.getParentElement()), element3)) >= 0) {
                    if (((AbstractDocument.BranchElement)object).getElementCount() == 1) {
                        int n11 = element3.getElementCount();
                        this.createCopy(element3, (Element)object, element3.getStartOffset(), element3.getEndOffset(), n7 + 1);
                        ((AbstractDocument.BranchElement)object).replace(n7, 1, new Element[0]);
                        Element[] elementArray6 = ElementUtils.getChildren((Element)object, n7, n11);
                        eventList.getEventFor((Element)object, n7, new Element[]{element3}, elementArray6);
                    } else {
                        this.moveElementTo(element3, (Object)this.configuration.getDefaultBlock(), (Element)object, n7, true, eventList, true);
                    }
                    n5 = this.getUpperContentBoundary(element3.getEndOffset(), (Element)object);
                    object2 = object;
                    bl3 = true;
                    continue;
                }
                object = StyleResolver.getAttributeValue((Element)object2, AttributeFinder.MARGIN_LEFT);
                int n12 = object != null && ((LengthUnit)object).getType() != -1 ? (int)((LengthUnit)object).getValue() : 0;
                elementArray = new SimpleAttributeSet();
                if (n12 > 0 || bl2) {
                    n12 = (n12 += bl2 ? n2 : -n2) > 0 ? n12 : 0;
                    CSS.setMarginLeft((MutableAttributeSet)elementArray, n12);
                    MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)object2.getAttributes();
                    eventList.addEvent(new HtmlAttributeUndoableEdit((Element)object2, (AttributeSet)elementArray, false));
                    mutableAttributeSet.addAttributes((AttributeSet)elementArray);
                    ElementUtils.clearTemp(mutableAttributeSet);
                    this.fillAttributes((Element)object2);
                    bl3 = true;
                }
                n5 = this.getUpperContentBoundary(n5, (Element)object2);
            }
        }
        catch (BadLocationException badLocationException) {
            if (Logger.doesLog(1)) {
                Logger.error(badLocationException);
            }
        }
        finally {
            this.writeUnlock();
        }
        if (eventList.size() > 0) {
            int n13 = Math.min(n3, eventList.getStartOffset());
            int n14 = n4 + n3;
            int n15 = eventList.getEndOffset();
            int n16 = Math.max(n14, n15) - n13;
            ExtendedDocuementEvent extendedDocuementEvent = new ExtendedDocuementEvent(n13, n16, n3, n4, DocumentEvent.EventType.CHANGE, this);
            eventList.fillEvent(extendedDocuementEvent);
            extendedDocuementEvent.end();
            if (bl3) {
                this.fireChangedUpdate(extendedDocuementEvent);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, extendedDocuementEvent));
            } else {
                this.lockEvents();
                try {
                    this.writeLock();
                    extendedDocuementEvent.undo();
                }
                finally {
                    this.writeUnlock();
                }
                this.unlockEvents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeListStatus(int n2, int n3, boolean bl2) throws BadLocationException {
        int n4;
        HTML.Tag tag;
        if (n2 + n3 > this.getLength()) {
            n3 = this.getLength() - n2;
        }
        int n5 = n2;
        int n6 = n2 + n3;
        HTML.Tag tag2 = tag = bl2 ? HTML.Tag.OL : HTML.Tag.UL;
        if (!this.allowTableEdit && ElementUtils.crossesTable(n2, n6, this.getDefaultRootElement())) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        EventList eventList = new EventList();
        EventList eventList2 = new EventList();
        Element element = null;
        int n7 = -1;
        try {
            Object object;
            Element[] elementArray;
            Object object2;
            Object object3;
            Element element2;
            int n8;
            this.writeLock();
            do {
                element2 = this.getParagraphElement(n5);
                Element element3 = ElementUtils.findListItemParent(element2);
                if (element2.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY) {
                    n8 = this.getLowerContentBoundary(n5, element2);
                    int n9 = this.getUpperContentBoundary(n5, element2);
                    if (n8 != element2.getStartOffset() || n9 != element2.getEndOffset()) {
                        object3 = element2.getElement(element2.getElementIndex(n8));
                        if (n9 - n8 == 1 && object3.isLeaf() && object3.getAttributes().isDefined("CR")) {
                            if (n9 > this.getLength()) {
                                --n9;
                            } else {
                                this.removeCompleteImpl((Element)object3, eventList2);
                                eventList2.add(this.getContent().remove(n8, 1));
                            }
                        } else {
                            try {
                                element2 = this.wrapImpliedElement(n5, eventList2);
                            }
                            catch (BadLocationException badLocationException) {
                                Logger.error("Exception: " + badLocationException.getMessage());
                            }
                        }
                    }
                }
                if (element3 != null) {
                    Element element4 = ElementUtils.findNextHigherBlock(element3);
                    if (element4 != null) {
                        Object object4 = element4.getAttributes().getAttribute(StyleConstants.NameAttribute);
                        if (object4 == HTML.Tag.OL) {
                            bl5 = true;
                        } else if (object4 == HTML.Tag.UL) {
                            bl4 = true;
                        }
                    }
                } else {
                    bl3 = true;
                }
                n8 = this.getUpperContentBoundary(n5, element2);
                if (n8 != n5) continue;
            } while ((n5 = ++n8) < n6);
            n5 = n2;
            element2 = null;
            n4 = !bl3 && (bl5 && !bl4 && bl2 || !bl5 && bl4 && !bl2) ? 1 : 0;
            Element element5 = this.getParagraphElement(n5);
            if (n4 == 0) {
                object2 = ElementUtils.findListContainer(element5);
                if (object2 != null && (object2.getStartOffset() < n2 || object2.getEndOffset() > n2 + n3)) {
                    object3 = object2.getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (object3 == tag) {
                        element2 = (AbstractDocument.BranchElement)object2;
                        n7 = object2.getElementIndex(n2);
                    } else {
                        Element element6 = ElementUtils.findListContainer((Element)object2);
                        while (element6 != null) {
                            object2 = element6;
                            element6 = ElementUtils.findListContainer((Element)object2);
                        }
                        element6 = object2.getParentElement();
                        if (element5.getStartOffset() > object2.getStartOffset()) {
                            this.splitElement((Element)object2, element5.getStartOffset(), null, eventList, false, true);
                        }
                        element2 = this.createBranchElement(element6, (Object)tag);
                        this.checkDefaultStyle(element2);
                        this.fillAttributes(element2);
                        element = element2;
                        n7 = element6.getElementIndex(n2);
                    }
                } else {
                    if (element5.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.BODY || ElementUtils.isTablePart(element5)) {
                        try {
                            element5 = this.wrapImpliedElement(n5, eventList2);
                        }
                        catch (BadLocationException badLocationException) {
                            Logger.error("Exception: " + badLocationException.getMessage());
                        }
                    }
                    int n10 = element5.getStartOffset();
                    int n11 = this.getParagraphElement(n5 + n3).getEndOffset();
                    elementArray = ElementUtils.findSharedParagraph(n10, n11 - n10, this.getRootElements()[0]);
                    object = elementArray.getAttributes().getAttribute(StyleConstants.NameAttribute);
                    while (object != HTML.Tag.BODY && object != HTML.Tag.HTML && elementArray.getStartOffset() >= n10 && elementArray.getEndOffset() <= n11) {
                        elementArray = elementArray.getParentElement();
                        object = elementArray.getAttributes().getAttribute(StyleConstants.NameAttribute);
                    }
                    element2 = this.createBranchElement((Element)elementArray, (Object)tag);
                    this.checkDefaultStyle(element2);
                    this.fillAttributes(element2);
                    element = element2;
                    n7 = elementArray.getElementIndex(n2);
                }
            } else {
                int n12;
                Element element7;
                int n13;
                Element element8;
                element2 = (AbstractDocument.BranchElement)ElementUtils.findSharedParent(n2, n3, this.getDefaultRootElement());
                while (ElementUtils.findListContainer(element2) != null) {
                    element2 = (AbstractDocument.BranchElement)ElementUtils.findListContainer(element2);
                }
                object2 = ((AbstractDocument.AbstractElement)element2).getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (object2 != null && (object2 == HTML.Tag.OL || object2 == HTML.Tag.UL)) {
                    int n14 = ((AbstractDocument.BranchElement)element2).getStartOffset();
                    int n15 = ((AbstractDocument.BranchElement)element2).getEndOffset();
                    if (n2 == n14 && n6 == n15 - 1 && n15 > n14) {
                        ++n6;
                        ++n3;
                    }
                    element2 = (AbstractDocument.BranchElement)((AbstractDocument.AbstractElement)element2).getParentElement();
                }
                if ((element8 = ((AbstractDocument.BranchElement)element2).getElement(((AbstractDocument.BranchElement)element2).getElementIndex(n13 = element5.getStartOffset()))).getStartOffset() != n13) {
                    int n16 = this.getLength();
                    this.splitElement(element8, n13, null, eventList, false, true);
                    if (this.getLength() > n16) {
                        ++n5;
                        ++n2;
                        ++n6;
                        ++n13;
                    }
                }
                if ((element7 = ((AbstractDocument.BranchElement)element2).getElement(((AbstractDocument.BranchElement)element2).getElementIndex(n12 = (elementArray = this.getParagraphElement(n2 + n3 - 1, element2)).getEndOffset()))) != null && element7.getStartOffset() != n12 && element7.getEndOffset() != n12) {
                    this.splitElement(element7, n12, null, eventList, false, true);
                }
                n7 = ((AbstractDocument.BranchElement)element2).getElementIndex(n13);
            }
            if (n4 != 0) {
                do {
                    if ((object2 = StyleResolver.getAttributeValue(element5 = this.getParagraphElement(n5), AttributeFinder.DISPLAY)) != null && ((DisplayValue)object2).getDisplay() == 4) {
                        this.moveElementTo(element5, (Object)this.configuration.getDefaultBlock(), element2, n7++, true, eventList, true);
                        continue;
                    }
                    this.moveElementTo(element5, null, element2, n7++, true, eventList, true);
                } while ((n5 = this.getUpperContentBoundary(n5, element5)) < n6);
            } else {
                Element element9;
                int n17;
                object2 = this.createBranchElement(this.getDefaultRootElement(), (Object)HTML.Tag.BODY);
                this.fillAttributes((Element)object2);
                Element element10 = this.getParagraphElement(n2);
                Element element11 = n6 > 0 ? this.getParagraphElement(n6 - 1) : null;
                elementArray = this.getParagraphElement(n6);
                if (element11 != null && InetHtmlParser.isMonolithic(element11) || elementArray.getStartOffset() == n6 && n3 > 0) {
                    elementArray = element11;
                }
                object = element2;
                int n18 = 1;
                int n19 = element10.getStartOffset();
                n6 = n17 = elementArray != null ? elementArray.getEndOffset() : n19;
                if (ElementUtils.isRelated(element10, element2) && (ElementUtils.findListItemParent(element10) != null || element10.getEndOffset() == ((AbstractDocument.BranchElement)element2).getEndOffset())) {
                    n19 = element10.getEndOffset();
                }
                n5 = n19;
                int n20 = 0;
                Element element12 = this.getDefaultRootElement().getElement(n20);
                while (element12 != null && element12.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY) {
                    element12 = this.getDefaultRootElement().getElement(++n20);
                }
                if (element12 == null) {
                    element12 = this.getDefaultRootElement();
                }
                this.createCopy(element12, (Element)object2, n19, n17);
                this.removeRange(element12, n19, n17, eventList);
                if (n5 >= n6) {
                    n6 = n5 + 1;
                }
                do {
                    Element element13;
                    element5 = this.getParagraphElement(n5, (Element)object2);
                    int n21 = 0;
                    element9 = ElementUtils.findListItemParent(element5);
                    if (element9 != null) {
                        element13 = ElementUtils.findNextHigherBlock(element9);
                        while (element13 != null && element13 != object2) {
                            Object object5 = element13.getAttributes().getAttribute(StyleConstants.NameAttribute);
                            if (object5 == HTML.Tag.OL || object5 == HTML.Tag.UL) {
                                ++n21;
                            }
                            element13 = ElementUtils.findNextHigherBlock(element13);
                        }
                    }
                    if (n21 < 1) {
                        n21 = 1;
                    }
                    while (n21 > n18) {
                        element13 = this.createBranchElement((Element)object, (Object)tag);
                        this.checkDefaultStyle(element13);
                        int n22 = ((AbstractDocument.BranchElement)object).getElementCount();
                        Element[] elementArray2 = new Element[]{element13};
                        ((AbstractDocument.BranchElement)object).replace(((AbstractDocument.BranchElement)object).getElementCount(), 0, elementArray2);
                        eventList.getEventFor((Element)object, n22, new Element[0], elementArray2);
                        object = (AbstractDocument.BranchElement)element13;
                        this.fillAttributes(element13);
                        ++n18;
                    }
                    while (n21 < n18 && n18 > 1) {
                        object = (AbstractDocument.BranchElement)((AbstractDocument.AbstractElement)object).getParentElement();
                        --n18;
                    }
                    int n23 = ((AbstractDocument.BranchElement)object).getElementCount();
                    if (n23 > 0) {
                        try {
                            int n24 = ((AbstractDocument.BranchElement)object).getElement(n23 - 1).getStartOffset();
                            while (n5 <= n24 && n23 > 0) {
                                n24 = --n23 > 0 ? ((AbstractDocument.BranchElement)object).getElement(n23 - 1).getStartOffset() : 0;
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    if (element9 != null) {
                        this.moveElementTo(element9, null, (Element)object, n23, false, eventList, true);
                        n5 = element9.getEndOffset();
                        continue;
                    }
                    if (element5.isLeaf()) {
                        BoxElement boxElement = this.createBranchElement((Element)object, (Object)HTML.Tag.LI);
                        this.checkDefaultStyle(boxElement);
                        this.moveElementTo(element5, null, boxElement, 0, false, eventList, false);
                        ((AbstractDocument.BranchElement)element2).replace(n23, 0, new Element[]{boxElement});
                        eventList.getEventFor((Element)object, n23, new Element[0], new Element[]{boxElement});
                        this.fillAttributes(boxElement);
                    } else {
                        int n25 = this.getUpperContentBoundary(n5, element5);
                        int n26 = this.getLowerContentBoundary(n5, element5);
                        if (element5.getStartOffset() < n26 || element5.getEndOffset() > n25) {
                            if (n25 - n5 == 1 && ElementUtils.getLeafAt(element5, n5).getAttributes().isDefined("CR")) {
                                this.removeCompleteImpl(ElementUtils.getLeafAt(element5, n5), eventList);
                                eventList.add(this.getContent().remove(n5, 1));
                                --n6;
                            } else {
                                BoxElement boxElement = this.createBranchElement((Element)object, (Object)HTML.Tag.LI);
                                this.checkDefaultStyle(boxElement);
                                this.createCopy(element5, boxElement, n26, n25, 0);
                                ((AbstractDocument.BranchElement)element2).replace(n23, 0, new Element[]{boxElement});
                                eventList.getEventFor((Element)object, n23, new Element[0], new Element[]{boxElement});
                                this.fillAttributes(boxElement);
                            }
                        } else {
                            this.moveElementTo(element5, (Object)HTML.Tag.LI, (Element)object, n23, false, eventList, true);
                        }
                    }
                    n5 = this.getUpperContentBoundary(n5, element5);
                } while (n5 < n6);
                if (element != null) {
                    Element[] elementArray3 = new Element[]{element};
                    element9 = element.getParentElement();
                    ((AbstractDocument.BranchElement)element9).replace(n7, 0, elementArray3);
                    eventList.getEventFor(element9, n7, new Element[0], elementArray3);
                }
                eventList.clean();
            }
            if (eventList2.size() > 0) {
                for (Object e2 : eventList2) {
                    if (e2 instanceof ElementEditBuffer) {
                        ElementEditBuffer elementEditBuffer = (ElementEditBuffer)e2;
                        elementArray = elementEditBuffer.removed != null && elementEditBuffer.removed.size() > 0 ? elementEditBuffer.removed.toArray(new Element[elementEditBuffer.removed.size()]) : new Element[]{};
                        object = elementEditBuffer.added != null && elementEditBuffer.added.size() > 0 ? elementEditBuffer.added.toArray(new Element[elementEditBuffer.added.size()]) : new Element[]{};
                        eventList.getEventFor(elementEditBuffer.parent, elementEditBuffer.index, elementArray, (Element[])object);
                        continue;
                    }
                    eventList.addEvent(e2);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
        int n27 = Math.min(n2, eventList.getStartOffset());
        n4 = n3 + n2;
        int n28 = eventList.getEndOffset();
        int n29 = Math.max(n4, n28) - n27;
        ExtendedDocuementEvent extendedDocuementEvent = new ExtendedDocuementEvent(n27, n29, n2, n3, DocumentEvent.EventType.CHANGE, this);
        eventList.fillEvent(extendedDocuementEvent);
        extendedDocuementEvent.end();
        this.fireChangedUpdate(extendedDocuementEvent);
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, extendedDocuementEvent));
    }

    private void moveElementTo(Element element, Object object, Element element2, int n2, boolean bl2, EventList eventList, boolean bl3) {
        AbstractDocument.AbstractElement abstractElement;
        Object object2;
        Object object3;
        if (element == null) {
            return;
        }
        if (object == HTML.Tag.P) {
            object3 = this.getParagraphElement(element.getStartOffset(), element);
            object2 = this.getParagraphElement(element.getEndOffset() - 1, element);
            if (object3.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.P || object2.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.P) {
                this.createCopy(element, element2, element.getStartOffset(), element.getEndOffset(), n2);
                Element[] elementArray = ElementUtils.getChildren(element2, n2, element.getElementCount());
                eventList.getEventFor(element2, n2, new Element[0], elementArray);
                this.removeCompleteImpl(element, eventList);
                return;
            }
        }
        if (element instanceof AbstractDocument.BranchElement) {
            object3 = object != null ? object : element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            object2 = new SimpleAttributeSet(element.getAttributes());
            object2.addAttribute(StyleConstants.NameAttribute, object3);
            ElementUtils.clearTemp((MutableAttributeSet)object2);
            abstractElement = this.createBranchElement(element2, (AttributeSet)object2);
            this.createCopy(element, abstractElement, element.getStartOffset(), element.getEndOffset(), 0);
        } else {
            abstractElement = this.createLeafElement(element2, element.getAttributes(), element.getStartOffset(), element.getEndOffset());
        }
        object3 = element.getParentElement();
        int n3 = ElementUtils.getChildIndex((Element)object3, element);
        Element[] elementArray = new Element[]{abstractElement};
        if (object3 != element2 || n2 != n3) {
            Element[] elementArray2 = new Element[]{};
            if (bl2) {
                this.removeCompleteImpl(element, eventList);
            }
            ((AbstractDocument.BranchElement)element2).replace(n2, 0, elementArray);
            eventList.getEventFor(element2, n2, elementArray2, elementArray);
        } else {
            this.replaceElements(new Element[]{element}, elementArray, eventList);
        }
        if (bl3) {
            this.fillAttributes(abstractElement);
        }
    }

    public EmbeddedImage[] getEmbeddedImages() {
        ArrayList<EmbeddedImage> arrayList = new ArrayList<EmbeddedImage>();
        this.findImages(this.getDefaultRootElement(), arrayList);
        return arrayList.toArray(new EmbeddedImage[arrayList.size()]);
    }

    private void findImages(Element element, List<EmbeddedImage> list) {
        for (int i2 = 0; i2 < element.getElementCount(); ++i2) {
            DocumentImage documentImage;
            Element element2 = element.getElement(i2);
            AttributeSet attributeSet = element2.getAttributes();
            if (attributeSet.isDefined(StyleConstants.IconAttribute)) {
                documentImage = (DocumentImage)attributeSet.getAttribute(StyleConstants.IconAttribute);
                documentImage.setRefElement(element2);
                list.add(documentImage);
            } else if (attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMG && attributeSet.isDefined((Object)HTML.Attribute.SRC)) {
                documentImage = new DocumentImage(null, element2);
                documentImage.setURL(attributeSet.getAttribute((Object)HTML.Attribute.SRC).toString());
                list.add(documentImage);
            }
            if (element2.isLeaf()) continue;
            this.findImages(element2, list);
        }
    }

    public void insertImage(Image image, int n2, File file) {
        this.insertImage(image, n2, null, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertImage(Image image, int n2, String string, File file) {
        if (!this.configuration.isAllowInternalImages()) {
            return;
        }
        Element element = this.getParagraphElement(n2);
        Element element2 = ElementUtils.getLeafAt(element, n2);
        Element element3 = ElementUtils.findParentByTag(element2, HTML.Tag.A);
        boolean bl2 = true;
        if (element3 != null && element3.getStartOffset() == n2 && ElementUtils.isRelated(element3, element) && element3.getStartOffset() != element.getStartOffset()) {
            bl2 = false;
        }
        EventList eventList = new EventList();
        boolean bl3 = false;
        try {
            Element element4;
            Object object;
            Object object2;
            if (this.getCurrentWriter() != Thread.currentThread()) {
                this.writeLock();
                bl3 = true;
            }
            if (ElementUtils.isContent(element2) && n2 > element2.getStartOffset()) {
                this.splitContentElement(element2, n2, eventList);
            }
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.IMG);
            if (image != null) {
                simpleAttributeSet.addAttribute((Object)HTML.Attribute.WIDTH, new LengthUnit(image.getWidth(null)));
                simpleAttributeSet.addAttribute((Object)HTML.Attribute.HEIGHT, new LengthUnit(image.getHeight(null)));
            }
            if (string != null) {
                simpleAttributeSet.addAttribute((Object)HTML.Attribute.ALT, new StringValueExp(string));
            }
            int n3 = n2;
            AbstractDocument.Content content = this.getContent();
            if (bl2) {
                object2 = content.getString(n3, 1);
                eventList.addEvent(content.insertString(n3 + 1, "\n" + (String)object2));
                eventList.addEvent(content.remove(n3, 1));
                object = ElementUtils.getLeafAt(element, n3);
                this.cropElement((Element)object, n3 + 1, object.getEndOffset(), eventList);
                element4 = object.getParentElement();
            } else {
                eventList.addEvent(content.insertString(n3, "\n"));
                object2 = ElementUtils.getLeafAt(element, n3);
                this.cropElement((Element)object2, object2.getStartOffset(), object2.getEndOffset() - 1, eventList);
                element4 = object2.getParentElement();
            }
            object2 = this.createLeafElement(element4, simpleAttributeSet, n2, n2 + 1);
            object = image != null ? new DocumentImage(image, (Element)object2) : new DocumentImage(null, (Element)object2);
            if (file != null) {
                String string2 = file.getAbsolutePath();
                try {
                    string2 = file.toURI().toURL().toString();
                }
                catch (MalformedURLException malformedURLException) {
                    if (Logger.doesLog(1)) {
                        Logger.error(malformedURLException);
                    }
                    malformedURLException.printStackTrace();
                }
                ((DocumentImage)object).setURL(string2);
                ImageCache.getStaticInstance().removeKey(string2, this.getBase());
            }
            ((MutableAttributeSet)object2.getAttributes()).addAttribute(StyleConstants.IconAttribute, object);
            this.styleResolver.fillAttributesNonLocked((Element)object2, null);
            int n4 = element4.getElementIndex(n3);
            Element[] elementArray = new Element[]{object2};
            ((AbstractDocument.BranchElement)element4).replace(n4, 0, elementArray);
            eventList.getEventFor(element4, n4, new Element[0], elementArray);
        }
        catch (BadLocationException badLocationException) {
            if (Logger.doesLog(1)) {
                Logger.error(badLocationException);
            }
        }
        finally {
            if (bl3) {
                this.writeUnlock();
            }
        }
        this.fireUpdateEvent(n2, 1, DocumentEvent.EventType.INSERT, eventList);
    }

    private void lockEvents() {
        this.eventsLocked = true;
    }

    private void unlockEvents() {
        this.eventsLocked = false;
    }

    @Override
    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        if (!this.eventsLocked) {
            ++this.revision;
            this.fireDocumentEvent(documentEvent);
        }
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        if (!this.eventsLocked) {
            ++this.revision;
            this.fireDocumentEvent(documentEvent);
        }
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        if (!this.eventsLocked) {
            ++this.revision;
            this.fireDocumentEvent(documentEvent);
        }
    }

    private void fireDocumentEvent(DocumentEvent documentEvent) {
        if (documentEvent == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != DocumentListener.class) continue;
            try {
                if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
                    ((DocumentListener)objectArray[i2 + 1]).insertUpdate(documentEvent);
                    continue;
                }
                if (documentEvent.getType() == DocumentEvent.EventType.REMOVE) {
                    ((DocumentListener)objectArray[i2 + 1]).removeUpdate(documentEvent);
                    continue;
                }
                ((DocumentListener)objectArray[i2 + 1]).changedUpdate(documentEvent);
                continue;
            }
            catch (Exception exception) {
                if (!Logger.doesLog(1)) continue;
                Logger.error(exception);
            }
        }
    }

    public void setAllowInternalImages(boolean bl2) {
        this.configuration.setAllowInternalImages(bl2);
    }

    public boolean isAllowInternalImages() {
        return this.configuration.isAllowInternalImages();
    }

    @Override
    public Dictionary<Object, Object> getDocumentProperties() {
        if (this.documentProperties == null) {
            this.documentProperties = new Hashtable<Object, Object>(2){

                @Override
                public synchronized Object put(Object object, Object object2) {
                    if (object == PROPERTY_CONFIGURATION && object2 != null && object2 instanceof InetHtmlConfiguration) {
                        InetHtmlDocument.this.configuration = (InetHtmlConfiguration)object2;
                    }
                    if (object == PROPERTY_DEFAULT_STYLE_CLASS) {
                        InetHtmlDocument.this.defaultStyleName = object2 != null ? object2.toString().toLowerCase().intern() : null;
                    }
                    if (object == "stream" && object2 != null) {
                        if (object2 instanceof URL) {
                            URL uRL = URLUtils.safeEncode((URL)object2);
                            try {
                                object2 = new URL((URL)object2, uRL.toString());
                            }
                            catch (MalformedURLException malformedURLException) {
                                if (Logger.doesLog(4)) {
                                    Logger.debug("persisiting the stream handler failed, falling back to default");
                                }
                                object2 = uRL;
                            }
                        }
                        if (object2 instanceof String) {
                            object2 = URLUtils.safeEncode((String)object2);
                        }
                    }
                    return super.put(object, object2);
                }
            };
        }
        return this.documentProperties;
    }

    @Override
    public void setDocumentProperties(Dictionary<Object, Object> dictionary) {
        this.documentProperties = this.getDocumentProperties();
        Enumeration<Object> enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            this.setDocumentProperty(object, dictionary.get(object));
        }
    }

    public void setDocumentProperty(Object object, Object object2) {
        if (this.documentProperties != null) {
            this.documentProperties.put(object, object2);
            if (object == PROPERTY_CONFIGURATION && object2 != null && object2 instanceof InetHtmlConfiguration) {
                this.configuration = (InetHtmlConfiguration)object2;
            }
            if (object == PROPERTY_DEFAULT_STYLE_CLASS) {
                this.defaultStyleName = object2 != null ? object2.toString().toLowerCase().intern() : null;
            }
        }
    }

    public InetHtmlConfiguration getConfiguration() {
        return this.configuration;
    }

    public static String getCachedString(String string) {
        return string.intern();
    }

    @Override
    public Enumeration<?> getStyleNames() {
        return this.styleResolver.getStyleNames();
    }

    public Styles getStyleSheet(String string) {
        return this.styleResolver.getStyleSheet(string);
    }

    @Override
    public int getSiteCount() {
        return this.siteCount;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public HTMLDocument.Iterator getIterator(HTML.Tag tag) {
        return new InetHtmlDocumentIterator(this, tag);
    }

    public URL getURLwithReferrer(URL uRL) {
        if (uRL == null) {
            return null;
        }
        InetStreamHandler inetStreamHandler = new InetStreamHandler(uRL);
        inetStreamHandler.setReferrer(this.getBase());
        String string = uRL.getPath() + (uRL.getQuery() != null ? "?" + uRL.getQuery() : "") + (uRL.getRef() != null ? "#" + uRL.getRef() : "");
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string, inetStreamHandler);
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
        catch (SecurityException securityException) {
            if (Logger.doesLog(4)) {
                Logger.debug("Could not attach referrer due to security restriction. URL was '" + uRL + "'");
            }
            return uRL;
        }
    }

    @Override
    public boolean readStylesOfVirtualTags() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ImpliedElement
    extends AbstractDocument.BranchElement
    implements ElementClonable,
    AttributeSet {
        private ArrayList<Element> children;
        private MutableAttributeSet attributes;
        private Element parent;

        public ImpliedElement(Element element) {
            super(InetHtmlDocument.this, element, null);
            this.children = new ArrayList();
            this.attributes = new SimpleAttributeSet();
            LengthUnit lengthUnit = new LengthUnit("0px");
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.PADDING_BOTTOM, lengthUnit);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.PADDING_TOP, lengthUnit);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.PADDING_LEFT, lengthUnit);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.PADDING_RIGHT, lengthUnit);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MARGIN_BOTTOM, lengthUnit);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MARGIN_TOP, lengthUnit);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MARGIN_LEFT, lengthUnit);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MARGIN_RIGHT, lengthUnit);
            LengthUnit lengthUnit2 = new LengthUnit("auto");
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.WIDTH, lengthUnit2);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.HEIGHT, lengthUnit2);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MIN_WIDTH, lengthUnit2);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MIN_HEIGHT, lengthUnit2);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MAX_WIDTH, lengthUnit2);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.MAX_HEIGHT, lengthUnit2);
            BorderStyleValue borderStyleValue = new BorderStyleValue("none", 0);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.BORDER_LEFT_STYLE, borderStyleValue);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.BORDER_RIGHT_STYLE, borderStyleValue);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.BORDER_BOTTOM_STYLE, borderStyleValue);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.BORDER_TOP_STYLE, borderStyleValue);
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.POSITION, new Position());
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.FLOAT, new FloatValue());
            this.attributes.addAttribute((Object)TemporaryStyle.Attribute.DISPLAY, new DisplayValue(3));
            this.attributes.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.IMPLIED);
            this.attributes.addAttribute(FLAG_INIT, true);
            this.parent = element;
        }

        @Override
        public AttributeSet getAttributes() {
            return this;
        }

        @Override
        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        @Override
        public Object getAttribute(Object object) {
            return this.attributes.getAttribute(object);
        }

        @Override
        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        @Override
        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        @Override
        public Document getDocument() {
            return InetHtmlDocument.this;
        }

        @Override
        public Element getElement(int n2) {
            if (n2 >= 0 && n2 < this.children.size()) {
                return this.children.get(n2);
            }
            return null;
        }

        @Override
        public int getElementCount() {
            return this.children.size();
        }

        @Override
        public int getElementIndex(int n2) {
            for (int i2 = 0; i2 < this.children.size(); ++i2) {
                if (this.children.get(i2).getStartOffset() > n2 || this.children.get(i2).getEndOffset() <= n2) continue;
                return i2;
            }
            return -1;
        }

        @Override
        public int getEndOffset() {
            if (this.children.size() > 0) {
                return this.children.get(this.children.size() - 1).getEndOffset();
            }
            return -1;
        }

        @Override
        public String getName() {
            Object object = this.attributes.getAttribute(StyleConstants.NameAttribute);
            if (object != null) {
                return object.toString();
            }
            return "IMPLIED";
        }

        @Override
        public Element getParentElement() {
            return this.parent;
        }

        @Override
        public int getStartOffset() {
            if (this.children.size() > 0) {
                return this.children.get(0).getStartOffset();
            }
            return -1;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Element clone(Element element) {
            try {
                InetHtmlDocument.this.writeLock();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)InetHtmlDocument.this.configuration.getDefaultBlock());
                BoxElement boxElement = InetHtmlDocument.this.createBranchElement(element, simpleAttributeSet);
                boxElement.replace(0, 0, this.children.toArray(new Element[this.children.size()]));
                InetHtmlDocument.this.fillAttributes(boxElement);
                BoxElement boxElement2 = boxElement;
                return boxElement2;
            }
            finally {
                InetHtmlDocument.this.writeUnlock();
            }
        }

        @Override
        public void replace(int n2, int n3, Element[] elementArray) {
            block7: {
                block6: {
                    int n4;
                    if (n2 >= this.children.size()) break block6;
                    if (n3 > 0) {
                        if (n2 + n3 > this.children.size()) {
                            n3 = this.children.size() - n2;
                        }
                        for (n4 = 0; n4 < n3; ++n4) {
                            this.children.remove(n2);
                        }
                    }
                    if (elementArray == null) break block7;
                    for (n4 = 0; n4 < n3; ++n4) {
                        this.children.add(n2 + n4, elementArray[n4]);
                    }
                    break block7;
                }
                if (elementArray != null) {
                    for (Element element : elementArray) {
                        this.children.add(element);
                    }
                }
            }
        }
    }

    class ContentElement
    extends AbstractDocument.LeafElement
    implements ElementClonable {
        public ContentElement(Element element, AttributeSet attributeSet, int n2, int n3) {
            super(InetHtmlDocument.this, element, attributeSet, n2, n3);
        }

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            if (object != null) {
                return object.toString();
            }
            return super.getName();
        }

        public Element clone(Element element) {
            return InetHtmlDocument.this.createLeafElement(element, this.getAttributes().copyAttributes(), this.getStartOffset(), this.getEndOffset());
        }

        public String toString() {
            int n2 = this.getStartOffset();
            int n3 = this.getEndOffset();
            try {
                String string = InetHtmlDocument.this.getText(n2, n3 - n2);
                return "ContentElement(" + n2 + ":" + n3 + "):" + (string.length() > 100 ? string.substring(0, 100) + "..." : string) + "\n";
            }
            catch (BadLocationException badLocationException) {
                return "ContentElement(" + n2 + ":" + n3 + ")\n";
            }
        }
    }

    class BoxElement
    extends AbstractDocument.BranchElement
    implements ElementClonable {
        public BoxElement(Element element, AttributeSet attributeSet) {
            super(InetHtmlDocument.this, element, attributeSet);
        }

        public String getName() {
            Object object = this.getAttribute(StyleConstants.NameAttribute);
            if (object != null) {
                return object.toString();
            }
            return super.getName();
        }

        public Element clone(Element element) {
            BoxElement boxElement = InetHtmlDocument.this.createBranchElement(element, this.getAttributes().copyAttributes());
            Element[] elementArray = ElementUtils.getChildren(this, 0, this.getElementCount());
            for (int i2 = 0; i2 < elementArray.length; ++i2) {
                elementArray[i2] = ((ElementClonable)((Object)elementArray[i2])).clone(boxElement);
            }
            boxElement.replace(0, 0, elementArray);
            return boxElement;
        }

        public int getStartOffset() {
            int n2 = this.getElementCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    Element element = this.getElement(i2);
                    if (element.getElementCount() <= 0 && !element.isLeaf()) continue;
                    return this.getElement(i2).getStartOffset();
                }
                catch (Exception exception) {
                    Logger.error(exception);
                }
            }
            return super.getStartOffset();
        }

        public int getEndOffset() {
            int n2 = this.getElementCount();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                try {
                    return this.getElement(i2).getEndOffset();
                }
                catch (NullPointerException nullPointerException) {
                    Logger.debug("Element " + this.getElement(i2).getName() + " has no leafs");
                    continue;
                }
            }
            return super.getEndOffset();
        }

        public String toString() {
            if (this.getElementCount() == 0) {
                return "BoxElement(" + this.getName() + ", empty)\n";
            }
            int n2 = this.getStartOffset();
            int n3 = this.getEndOffset();
            try {
                String string = InetHtmlDocument.this.getText(n2, n3 - n2);
                return "BoxElement(" + this.getName() + " " + n2 + ":" + n3 + "):" + (string.length() > 100 ? string.substring(0, 100) + "..." : string) + "\n";
            }
            catch (BadLocationException badLocationException) {
                return "BoxElement(" + this.getName() + " " + n2 + ":" + n3 + ")\n";
            }
        }
    }

    static interface ElementClonable {
        public Element clone(Element var1);
    }

    public class StyleSheetClearEdit
    extends AbstractUndoableEdit {
        private Styles oldStyleSheet;

        public StyleSheetClearEdit(Styles styles) {
            this.oldStyleSheet = styles;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Styles styles = InetHtmlDocument.this.styleResolver.getStyles();
            InetHtmlDocument.this.styleResolver.setStyles(this.oldStyleSheet);
            this.oldStyleSheet = styles;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Styles styles = InetHtmlDocument.this.styleResolver.getStyles();
            InetHtmlDocument.this.styleResolver.setStyles(this.oldStyleSheet);
            this.oldStyleSheet = styles;
        }
    }

    private class HtmlAttributeUndoableEdit
    extends AttributeUndoableEdit {
        private AttributeSet newAttributes;
        private AttributeSet copy;
        private boolean isReplacing;
        private Element element;

        public HtmlAttributeUndoableEdit(Element element, AttributeSet attributeSet, boolean bl2) {
            super(element);
            this.element = element;
            this.newAttributes = attributeSet;
            this.isReplacing = bl2;
            this.copy = element.getAttributes().copyAttributes();
        }

        public void redo() throws CannotRedoException {
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.element.getAttributes();
            if (this.isReplacing) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(this.newAttributes);
            InetHtmlDocument.this.fillAttributes(this.element);
        }

        public void undo() throws CannotUndoException {
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.element.getAttributes();
            mutableAttributeSet.removeAttributes(mutableAttributeSet);
            mutableAttributeSet.addAttributes(this.copy);
            InetHtmlDocument.this.fillAttributes(this.element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExtendedDocuementEvent
    extends AbstractDocument.DefaultDocumentEvent {
        private HashMap<Element, ArrayList<DocumentEvent.ElementChange>> editByParagraph;
        private ArrayList<UndoableEdit> changes;
        private DocumentEvent.EventType type;
        private int contentChangeLen;
        private int contentChangeStart;

        public ExtendedDocuementEvent(int n2, int n3, DocumentEvent.EventType eventType, InetHtmlDocument inetHtmlDocument2) {
            InetHtmlDocument inetHtmlDocument3 = inetHtmlDocument2;
            inetHtmlDocument3.getClass();
            super(inetHtmlDocument3, n2, n3, eventType);
            this.contentChangeLen = -1;
            this.contentChangeStart = -1;
            this.type = eventType;
        }

        public ExtendedDocuementEvent(int n2, int n3, int n4, DocumentEvent.EventType eventType, InetHtmlDocument inetHtmlDocument2) {
            InetHtmlDocument inetHtmlDocument3 = inetHtmlDocument2;
            inetHtmlDocument3.getClass();
            super(inetHtmlDocument3, n2, n3, eventType);
            this.contentChangeLen = -1;
            this.contentChangeStart = -1;
            this.type = eventType;
            this.contentChangeLen = n4;
        }

        public ExtendedDocuementEvent(int n2, int n3, int n4, int n5, DocumentEvent.EventType eventType, InetHtmlDocument inetHtmlDocument2) {
            InetHtmlDocument inetHtmlDocument3 = inetHtmlDocument2;
            inetHtmlDocument3.getClass();
            super(inetHtmlDocument3, n2, n3, eventType);
            this.contentChangeLen = -1;
            this.contentChangeStart = -1;
            this.type = eventType;
            this.contentChangeStart = n4;
            this.contentChangeLen = n5;
        }

        public int getStructureChangeLen() {
            return super.getLength();
        }

        public int getStructureChangeStart() {
            return super.getOffset();
        }

        @Override
        public int getLength() {
            if (this.contentChangeLen >= 0) {
                return this.contentChangeLen;
            }
            return super.getLength();
        }

        @Override
        public int getOffset() {
            if (this.contentChangeStart >= 0) {
                return this.contentChangeStart;
            }
            return super.getOffset();
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (this.changes == null) {
                this.changes = new ArrayList();
            }
            this.changes.add(undoableEdit);
            if (undoableEdit instanceof DocumentEvent.ElementChange) {
                DocumentEvent.ElementChange elementChange;
                Element element;
                ArrayList<DocumentEvent.ElementChange> arrayList;
                if (this.editByParagraph == null) {
                    this.editByParagraph = new HashMap();
                }
                if ((arrayList = this.editByParagraph.get(element = ElementUtils.getParagraphFor((elementChange = (DocumentEvent.ElementChange)((Object)undoableEdit)).getElement()))) == null) {
                    arrayList = new ArrayList();
                    this.editByParagraph.put(element, arrayList);
                }
                arrayList.add((DocumentEvent.ElementChange)((Object)undoableEdit));
            }
            return super.addEdit(undoableEdit);
        }

        public ArrayList<UndoableEdit> getAllChanges() {
            return this.changes;
        }

        public boolean hasEditsFor(Element element) {
            return this.editByParagraph != null && this.editByParagraph.containsKey(element);
        }

        public ArrayList<DocumentEvent.ElementChange> getEditsFor(Element element) {
            return this.editByParagraph.get(element);
        }

        @Override
        public DocumentEvent.EventType getType() {
            return this.type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undo() throws CannotUndoException {
            InetHtmlDocument.this.lockEvents();
            try {
                super.undo();
                InetHtmlDocument.this.unlockEvents();
                InetHtmlDocument.this.revision -= 2;
                if (this.hasEditsFor(InetHtmlDocument.this.getDefaultRootElement())) {
                    InetHtmlDocument.this.siteCount--;
                }
                if (this.type == DocumentEvent.EventType.INSERT) {
                    this.type = DocumentEvent.EventType.REMOVE;
                    InetHtmlDocument.this.fireRemoveUpdate(this);
                } else if (this.type == DocumentEvent.EventType.REMOVE) {
                    this.type = DocumentEvent.EventType.INSERT;
                    InetHtmlDocument.this.fireInsertUpdate(this);
                } else {
                    this.type = DocumentEvent.EventType.CHANGE;
                    InetHtmlDocument.this.fireChangedUpdate(this);
                }
            }
            catch (Exception exception) {
                if (Logger.doesLog(0)) {
                    Logger.critical("Unable to perform Undo");
                }
                if (Logger.doesLog(1)) {
                    Logger.error(exception);
                }
            }
            finally {
                InetHtmlDocument.this.unlockEvents();
            }
        }

        @Override
        public void redo() throws CannotUndoException {
            InetHtmlDocument.this.lockEvents();
            super.redo();
            InetHtmlDocument.this.unlockEvents();
            if (this.hasEditsFor(InetHtmlDocument.this.getDefaultRootElement())) {
                InetHtmlDocument.this.siteCount++;
            }
            if (this.type == DocumentEvent.EventType.INSERT) {
                this.type = DocumentEvent.EventType.REMOVE;
                InetHtmlDocument.this.fireRemoveUpdate(this);
            } else if (this.type == DocumentEvent.EventType.REMOVE) {
                this.type = DocumentEvent.EventType.INSERT;
                InetHtmlDocument.this.fireInsertUpdate(this);
            } else {
                this.type = DocumentEvent.EventType.CHANGE;
                InetHtmlDocument.this.fireChangedUpdate(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EventList
    extends ArrayList<Object> {
        private EventList child;

        public EventList(EventList eventList) {
            this.child = eventList;
        }

        public EventList() {
            this.child = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ElementEditBuffer getEventFor(Element element, int n2, Element[] elementArray, Element[] elementArray2) {
            ElementEditBuffer elementEditBuffer = null;
            if (this.child != null) {
                elementEditBuffer = this.child.getEventFor(element, n2, elementArray, elementArray2);
                if (elementEditBuffer != null && !this.contains(elementEditBuffer)) {
                    this.add(elementEditBuffer);
                }
            } else {
                ArrayList<Element> arrayList = null;
                for (int i2 = this.size() - 1; i2 >= 0; --i2) {
                    Object e2 = this.get(i2);
                    if (!(e2 instanceof ElementEditBuffer) || ((ElementEditBuffer)e2).getElement() != element) continue;
                    elementEditBuffer = (ElementEditBuffer)e2;
                    int n3 = Logger.getLogLevel();
                    Logger.setLogLevel(-1);
                    try {
                        int n4;
                        int n5 = -1;
                        int n6 = n4 = elementArray != null && elementArray.length > 0 && elementArray[0].getElementCount() > 0 ? 1 : 0;
                        if (n4 != 0) {
                            n5 = elementArray[0].getStartOffset();
                        } else if (elementArray2 != null && elementArray2.length > 0 && elementArray2[0].getElementCount() > 0) {
                            n5 = elementArray2[0].getStartOffset();
                        }
                        if (n5 >= 0) {
                            int n7;
                            int n8 = n7 = n4 != 0 ? elementArray[elementArray.length - 1].getEndOffset() : elementArray2[elementArray2.length - 1].getEndOffset();
                            if (n7 >= 0) {
                                int n9 = elementEditBuffer.getEndOffset();
                                int n10 = elementEditBuffer.getStartOffset();
                                if (n5 > n9 || n7 < n10) {
                                    elementEditBuffer = null;
                                    continue;
                                }
                            }
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    finally {
                        Logger.setLogLevel(n3);
                    }
                    if (n2 < elementEditBuffer.getIndex()) {
                        elementEditBuffer.setIndex(n2);
                    }
                    for (Element element2 : elementArray) {
                        if (!elementEditBuffer.addRemove(element2)) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList<Element>();
                        }
                        arrayList.add(element2);
                    }
                    for (Element element3 : elementArray2) {
                        elementEditBuffer.addAdd(element3);
                    }
                    break;
                }
                if (arrayList != null) {
                    this.cleanUp(arrayList);
                }
                if (elementEditBuffer == null) {
                    elementEditBuffer = new ElementEditBuffer(element, n2, elementArray, elementArray2);
                    this.add(elementEditBuffer);
                }
            }
            if (elementEditBuffer != null && (elementEditBuffer.added != null && elementEditBuffer.added.size() > 0 || elementEditBuffer.removed != null && elementEditBuffer.removed.size() > 0)) {
                return elementEditBuffer;
            }
            return null;
        }

        private void cleanUp(List<Element> list) {
            HashMap<Element, Object> hashMap = new HashMap<Element, Object>();
            for (Object object : this) {
                if (!(object instanceof ElementEditBuffer)) continue;
                hashMap.put(((ElementEditBuffer)object).getElement(), object);
            }
            for (Element element : list) {
                Object v2 = hashMap.remove(element);
                if (v2 == null) continue;
                this.remove(v2);
                this.cleanUpRecurseion(ElementUtils.getAllChildren(element), hashMap);
            }
        }

        private void cleanUpRecurseion(Element[] elementArray, HashMap<Element, Object> hashMap) {
            for (Element element : elementArray) {
                Object object = hashMap.remove(element);
                if (object == null) continue;
                this.remove(object);
                this.cleanUpRecurseion(ElementUtils.getAllChildren(element), hashMap);
            }
        }

        public void setChild(EventList eventList) {
            this.child = eventList;
        }

        @Override
        public boolean add(Object object) {
            return super.add(object);
        }

        public void addEvent(Object object) {
            this.add(object);
            if (this.child != null) {
                this.child.addEvent(object);
            }
        }

        public void fillEvent(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            for (Object e2 : this) {
                if (e2 instanceof ElementEditBuffer) {
                    ElementEditBuffer elementEditBuffer = (ElementEditBuffer)e2;
                    if (elementEditBuffer.added.size() <= 0 && elementEditBuffer.removed.size() <= 0) continue;
                    defaultDocumentEvent.addEdit(elementEditBuffer.getElementEdit());
                    continue;
                }
                defaultDocumentEvent.addEdit((UndoableEdit)e2);
            }
        }

        public int getStartOffset() {
            int n2 = Integer.MAX_VALUE;
            for (Object e2 : this) {
                if (!(e2 instanceof ElementEditBuffer)) continue;
                Element[] elementArray = ((ElementEditBuffer)e2).getChildrenAdded();
                Element[] elementArray2 = ((ElementEditBuffer)e2).getChildrenRemoved();
                for (Element element : elementArray) {
                    try {
                        if (element.getStartOffset() >= n2) continue;
                        n2 = element.getStartOffset();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                for (Element element : elementArray2) {
                    try {
                        if (element.getStartOffset() >= n2) continue;
                        n2 = element.getStartOffset();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
            return n2;
        }

        public int getEndOffset() {
            int n2 = 0;
            for (Object e2 : this) {
                if (!(e2 instanceof ElementEditBuffer)) continue;
                Element[] elementArray = ((ElementEditBuffer)e2).getChildrenAdded();
                Element[] elementArray2 = ((ElementEditBuffer)e2).getChildrenRemoved();
                for (Element element : elementArray) {
                    try {
                        if (element.getEndOffset() <= n2) continue;
                        n2 = element.getEndOffset();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                for (Element element : elementArray2) {
                    try {
                        if (element.getEndOffset() <= n2) continue;
                        n2 = element.getEndOffset();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
            return n2;
        }

        public void clean() {
            int n2 = 0;
            while (n2 < this.size()) {
                Object e2 = this.get(n2);
                if (e2 instanceof ElementEditBuffer && ((ElementEditBuffer)e2).parent.getElementCount() == 0) {
                    this.remove(n2);
                    continue;
                }
                ++n2;
            }
        }
    }

    protected static class ElementEditBuffer {
        private ArrayList<Element> removed = new ArrayList();
        private ArrayList<Element> added;
        private Element parent;
        private int index;
        private static final Sorter SORTER = new Sorter();

        public ElementEditBuffer(Element element, int n2, Element[] elementArray, Element[] elementArray2) {
            if (elementArray != null) {
                for (Element element2 : elementArray) {
                    this.removed.add(element2);
                }
            }
            this.added = new ArrayList();
            if (elementArray2 != null) {
                for (Element element2 : elementArray2) {
                    this.added.add(element2);
                }
            }
            this.index = n2;
            this.parent = element;
        }

        public Element[] getChildrenAdded() {
            return this.added.toArray(new Element[this.added.size()]);
        }

        public Element[] getChildrenRemoved() {
            return this.removed.toArray(new Element[this.removed.size()]);
        }

        public Element getElement() {
            return this.parent;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n2) {
            this.index = n2;
        }

        public boolean addRemove(Element element) {
            if (!this.added.remove(element)) {
                if (!this.removed.contains(element)) {
                    this.removed.add(element);
                }
                return false;
            }
            return true;
        }

        public void addAdd(Element element) {
            if (!this.removed.remove(element) && !this.added.contains(element)) {
                this.added.add(element);
            }
        }

        public AbstractDocument.ElementEdit getElementEdit() {
            Collections.sort(this.added, SORTER);
            Collections.sort(this.removed, SORTER);
            return new AbstractDocument.ElementEdit(this.parent, this.index, this.getChildrenRemoved(), this.getChildrenAdded());
        }

        public String toString() {
            return "Add: " + this.added + "\n Remove: " + this.removed + " \n@" + this.parent + ":" + this.parent.hashCode();
        }

        public int getStartOffset() {
            int n2 = Integer.MAX_VALUE;
            if (this.added != null && this.added.size() > 0) {
                for (Element element : this.added) {
                    if (element.getStartOffset() >= n2) continue;
                    n2 = element.getStartOffset();
                }
            }
            if (this.removed != null && this.removed.size() > 0) {
                for (Element element : this.removed) {
                    if (element.getStartOffset() >= n2) continue;
                    n2 = element.getStartOffset();
                }
            }
            return n2;
        }

        public int getEndOffset() {
            int n2 = -1;
            if (this.added != null && this.added.size() > 0) {
                for (Element element : this.added) {
                    if (element.getEndOffset() <= n2) continue;
                    n2 = element.getEndOffset();
                }
            }
            if (this.removed != null && this.removed.size() > 0) {
                for (Element element : this.removed) {
                    if (element.getEndOffset() <= n2) continue;
                    n2 = element.getEndOffset();
                }
            }
            return n2;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Sorter
        implements Comparator<Element> {
            private Sorter() {
            }

            @Override
            public int compare(Element element, Element element2) {
                int n2 = element.getStartOffset() - element2.getStartOffset();
                if (n2 != 0) {
                    return n2;
                }
                return element.getEndOffset() - element2.getEndOffset();
            }
        }
    }
}

