/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.utils.ElementUtils;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class InetHtmlDocumentIterator
extends HTMLDocument.Iterator {
    private HTML.Tag tag;
    private HTML.Tag secondary;
    private Element pointer;

    protected InetHtmlDocumentIterator(InetHtmlDocument inetHtmlDocument, HTML.Tag tag) {
        this.secondary = tag;
        this.pointer = inetHtmlDocument.getRootElements()[0];
        if (tag != null) {
            try {
                this.tag = HTML.Tag.valueOf(tag.toString().toUpperCase(Locale.US));
            }
            catch (Exception exception) {
                this.tag = null;
            }
        } else {
            this.tag = null;
        }
        this.search();
    }

    private Element getNextElement(Element element) {
        if (element.getElementCount() > 0) {
            return element.getElement(0);
        }
        Element element2 = element.getParentElement();
        int n2 = ElementUtils.getChildIndex(element2, element);
        while (element2 != null && n2 == element2.getElementCount() - 1) {
            element = element2;
            if ((element2 = element2.getParentElement()) == null) {
                return null;
            }
            n2 = ElementUtils.getChildIndex(element2, element);
        }
        return element2 != null ? element2.getElement(n2 + 1) : null;
    }

    private Element search() {
        if (this.pointer == null) {
            return null;
        }
        this.pointer = this.getNextElement(this.pointer);
        do {
            Object object = this.pointer.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (this.tag != null && object == this.tag || object == this.secondary) {
                return this.pointer;
            }
            this.pointer = this.getNextElement(this.pointer);
        } while (this.pointer != null);
        return null;
    }

    public AttributeSet getAttributes() {
        if (this.pointer == null) {
            return null;
        }
        AttributeSet attributeSet = this.pointer.getAttributes();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            HTML.Attribute attribute;
            Object obj = enumeration.nextElement();
            if (!(obj instanceof HTML.Attribute) || (attribute = HTML.getAttributeKey(obj.toString())) == null) continue;
            simpleAttributeSet.addAttribute(attribute, attributeSet.getAttribute(obj));
        }
        simpleAttributeSet.addAttributes(attributeSet);
        return simpleAttributeSet;
    }

    public int getEndOffset() {
        return this.pointer != null ? this.pointer.getEndOffset() : 0;
    }

    public int getStartOffset() {
        return this.pointer != null ? this.pointer.getStartOffset() : 0;
    }

    public HTML.Tag getTag() {
        return this.secondary;
    }

    public boolean isValid() {
        return this.pointer != null;
    }

    public void next() {
        this.search();
    }
}

