/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlFactory;
import com.inet.html.InetHtmlFontFactory;
import com.inet.html.InetHtmlTransferHandler;
import com.inet.html.InetHtmlWriter;
import com.inet.html.actions.AlignmentAction;
import com.inet.html.actions.BeginEndLineAction;
import com.inet.html.actions.BoldAction;
import com.inet.html.actions.DeleteNextCharAction;
import com.inet.html.actions.DeletePrevCharAction;
import com.inet.html.actions.EnterAction;
import com.inet.html.actions.HRuleAction;
import com.inet.html.actions.InsertHtmlAction;
import com.inet.html.actions.ItalicAction;
import com.inet.html.actions.ListAction;
import com.inet.html.actions.ParagraphIndentAction;
import com.inet.html.actions.TabKeyAction;
import com.inet.html.actions.UnderlineAction;
import com.inet.html.actions.search.DefaultSearchDialog;
import com.inet.html.actions.search.DefaultSearchHighlighter;
import com.inet.html.actions.search.SearchAction;
import com.inet.html.actions.search.SearchClearAction;
import com.inet.html.actions.search.SearchControl;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.FontFamily;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.HtmlAttribute;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxView;
import com.inet.html.views.ViewPositionInfo;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class InetHtmlEditorKit
extends StyledEditorKit {
    private static final long serialVersionUID = 1L;
    private static final String MSO_BLOCKED_LINK_PREFIX = "blocked::";
    public static final String PARAGRAPH_INDENT_LEFT = "paraIndentLeft";
    public static final String PARAGRAPH_INDENT_RIGHT = "paraIndentRight";
    public static final String TAB_KEY_ACTION = "tabKeyAction";
    public static final String TAB_KEY_SHIFT_ACTION = "tabKeyShiftAction";
    public static final String BULLET_LIST_ACTION = "bulletListAction";
    public static final String NUMBERED_LIST_ACTION = "numberedListAction";
    public static final String PASTE_PLAIN_ACTION = "paste-from-clipboard-plain";
    public static final String COPY_PLAIN_ACTION = "copy-to-clipboard-plain";
    public static final String SEARCH_INIT_ACTION = "search-init";
    public static final String SEARCH_NEXT_ACTION = "search-next";
    public static final String SEARCH_PREVIOUS_ACTION = "search-previous";
    public static final String SEARCH_CLEAR_ACTION = "search-clear";
    private static PastePlainAction pasteFromClipBoardPlainAction;
    private static BoldAction boldAction;
    private static ItalicAction italicAction;
    private static UnderlineAction underlineAction;
    private static SearchAction searchInit;
    private static SearchAction searchNext;
    private static SearchAction searchPrev;
    private static SearchClearAction searchClear;
    private static final Action[] DEFAULT_ACTIONS;
    public static final int SHORTCUT_KEY_MASK;
    private MutableAttributeSet inputAttributes;
    private InetHtmlAttributeTracker tracker;
    private LinkController linkController;
    private Cursor defaultCursor = new Cursor(0);
    private Cursor linkCursor = new Cursor(12);
    private InetHtmlConfiguration defaultConfig = InetHtmlConfiguration.getMailEditorConfig();
    private TransferHandler prevTransferHandler = null;
    private Object recentEditor = null;
    private InetHtmlFactory factory;
    private ScalingFontFactory fontFactory;
    private long parserTimeout;

    public InetHtmlEditorKit() {
        this.init();
    }

    public InetHtmlEditorKit(boolean bl2) {
        this.init();
        this.factory.setUseTextAntiAlias(bl2);
    }

    private void init() {
        this.tracker = new InetHtmlAttributeTracker();
        this.createInputAttributes();
        this.fontFactory = new ScalingFontFactory();
        this.factory = new InetHtmlFactory(null, this.fontFactory);
    }

    public void setFontScale(float f2) {
        this.fontFactory.setScale(f2);
    }

    public void setParserTimeout(long l2) {
        this.parserTimeout = l2;
    }

    public Document createDefaultDocument() {
        InetHtmlDocument inetHtmlDocument = new InetHtmlDocument();
        inetHtmlDocument.setAsynchronousLoadPriority(4);
        try {
            if (this.recentEditor != null && this.recentEditor.getClass().getName().endsWith("JHEditorPane")) {
                inetHtmlDocument.putProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, this.getJavaHelpConfig());
            } else {
                inetHtmlDocument.putProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, this.defaultConfig.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger.error(cloneNotSupportedException);
        }
        return inetHtmlDocument;
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }

    public void setDefaultConfig(InetHtmlConfiguration inetHtmlConfiguration) {
        if (inetHtmlConfiguration == null) {
            return;
        }
        this.defaultConfig = inetHtmlConfiguration;
    }

    public void read(Reader reader, Document document, int n2) throws IOException, BadLocationException {
        InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)document;
        try {
            if (this.parserTimeout <= 0L) {
                document.putProperty(InetHtmlDocument.PROPERTY_TIMEOUT, null);
            } else {
                document.putProperty(InetHtmlDocument.PROPERTY_TIMEOUT, this.parserTimeout);
            }
            inetHtmlDocument.parse(reader, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            throw badLocationException;
        }
    }

    public void write(Writer writer, Document document, int n2, int n3) throws IOException, BadLocationException {
        InetHtmlWriter inetHtmlWriter = new InetHtmlWriter(writer, document, n2, n3);
        inetHtmlWriter.write();
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), DEFAULT_ACTIONS);
    }

    public String getContentType() {
        return "text/html";
    }

    private InetHtmlConfiguration getJavaHelpConfig() {
        return InetHtmlConfiguration.getBrowserConfig();
    }

    public void install(JEditorPane jEditorPane) {
        if (jEditorPane == null) {
            return;
        }
        this.recentEditor = jEditorPane;
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        this.createInputAttributes();
        jEditorPane.addCaretListener(this.tracker);
        jEditorPane.addPropertyChangeListener(this.tracker);
        Caret caret = jEditorPane.getCaret();
        if (caret != null) {
            this.tracker.updateAttributes(caret.getDot(), caret.getMark(), jEditorPane);
        }
        CopyPlainAction copyPlainAction = new CopyPlainAction(jEditorPane);
        Keymap keymap = jEditorPane.getKeymap();
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), new TabKeyAction());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 64 + SHORTCUT_KEY_MASK), pasteFromClipBoardPlainAction);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 64 + SHORTCUT_KEY_MASK), pasteFromClipBoardPlainAction);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 64 + SHORTCUT_KEY_MASK), copyPlainAction);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(70, 64 + SHORTCUT_KEY_MASK), boldAction);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(75, 64 + SHORTCUT_KEY_MASK), italicAction);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(85, 64 + SHORTCUT_KEY_MASK), underlineAction);
        jEditorPane.putClientProperty("searchController", new SearchControl(new DefaultSearchDialog(jEditorPane), new DefaultSearchHighlighter(jEditorPane)));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(70, SHORTCUT_KEY_MASK), searchInit);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(70, 64 + SHORTCUT_KEY_MASK), searchClear);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(114, 0), searchNext);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(114, 64), searchPrev);
        this.prevTransferHandler = jEditorPane.getTransferHandler();
        InetHtmlTransferHandler inetHtmlTransferHandler = new InetHtmlTransferHandler(jEditorPane);
        jEditorPane.addCaretListener(inetHtmlTransferHandler);
        jEditorPane.setTransferHandler(inetHtmlTransferHandler);
        jEditorPane.setDragEnabled(true);
        jEditorPane.getActionMap().put(PASTE_PLAIN_ACTION, pasteFromClipBoardPlainAction);
        jEditorPane.getActionMap().put(COPY_PLAIN_ACTION, copyPlainAction);
        this.linkController = new LinkController();
        jEditorPane.addMouseListener(this.linkController);
        jEditorPane.addMouseMotionListener(this.linkController);
    }

    public void deinstall(JEditorPane jEditorPane) {
        this.recentEditor = null;
        Keymap keymap = jEditorPane.getKeymap();
        if (keymap != null) {
            keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(9, 0));
            keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(9, 64));
            keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(86, 64 + SHORTCUT_KEY_MASK));
            keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(155, 64 + SHORTCUT_KEY_MASK));
            keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(70, 64 + SHORTCUT_KEY_MASK));
            keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(75, 64 + SHORTCUT_KEY_MASK));
            keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(85, 64 + SHORTCUT_KEY_MASK));
        }
        for (MouseListener mouseListener : jEditorPane.getMouseListeners()) {
            if (!(mouseListener instanceof LinkController)) continue;
            jEditorPane.removeMouseListener(mouseListener);
        }
        for (MouseMotionListener mouseMotionListener : jEditorPane.getMouseMotionListeners()) {
            if (!(mouseMotionListener instanceof LinkController)) continue;
            jEditorPane.removeMouseMotionListener(mouseMotionListener);
        }
        jEditorPane.removeCaretListener(this.tracker);
        jEditorPane.removePropertyChangeListener(this.tracker);
        TransferHandler transferHandler = jEditorPane.getTransferHandler();
        if (transferHandler instanceof InetHtmlTransferHandler) {
            jEditorPane.removeCaretListener((InetHtmlTransferHandler)transferHandler);
        }
        jEditorPane.setTransferHandler(this.prevTransferHandler);
        jEditorPane.getActionMap().remove(PASTE_PLAIN_ACTION);
        jEditorPane.getActionMap().remove(COPY_PLAIN_ACTION);
        this.inputAttributes = null;
        this.linkController = null;
        jEditorPane.setToolTipText(null);
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
        this.createInputAttributes(element, element, mutableAttributeSet);
    }

    protected void createInputAttributes(Element element, Element element2, MutableAttributeSet mutableAttributeSet) {
        if (element == null || element2 == null) {
            return;
        }
        Element element3 = element;
        Element element4 = element2;
        if (element.getStartOffset() > element2.getStartOffset()) {
            element3 = element2;
            element4 = element;
        }
        int n2 = element4.getEndOffset();
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        HtmlAttribute htmlAttribute = null;
        boolean bl6 = false;
        float f2 = -1.0f;
        boolean bl7 = false;
        Object object = null;
        if (element3.getDocument() instanceof InetHtmlDocument) {
            InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)element3.getDocument();
            Element element5 = element3;
            do {
                Object object2;
                bl2 |= CSS.isBold(element5);
                bl3 |= CSS.isItalic(element5);
                bl4 |= CSS.isUnderline(element5);
                if (!bl5) {
                    object2 = StyleResolver.getAttributeValue(element5, AttributeFinder.COLOR);
                    if (htmlAttribute == null) {
                        htmlAttribute = object2;
                    } else if (!((ColorValue)htmlAttribute).equals(object2)) {
                        bl5 = true;
                        htmlAttribute = null;
                    }
                }
                if (!bl7) {
                    object2 = StyleResolver.getAttributeValue(element5, AttributeFinder.FONT_FAMILY);
                    if (object == null) {
                        object = object2;
                    } else if (!((FontFamily)object).equals(object2)) {
                        bl7 = true;
                        object = null;
                    }
                }
                if (!bl6 && (object2 = element5.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)) != null) {
                    float f3 = ((Float)object2).floatValue();
                    if (f2 < 0.0f) {
                        f2 = f3;
                    } else if (f2 != f3) {
                        bl6 = true;
                        f2 = -1.0f;
                    }
                }
                if (element5 == element4 || element5.getEndOffset() > n2) {
                    element5 = null;
                    continue;
                }
                object2 = element5;
                element5 = ElementUtils.getLeafAt(inetHtmlDocument.getRootElements()[0], element5.getEndOffset());
                if (element5 != object2) continue;
                element5 = ElementUtils.getLeafAt(inetHtmlDocument.getRootElements()[0], element5.getEndOffset() + 1);
            } while (element5 != null);
            CSS.setFontWeight(mutableAttributeSet, bl2);
            CSS.setFontStyle(mutableAttributeSet, bl3);
            CSS.setTextDecoration(mutableAttributeSet, bl4 ? 1 : 0);
            if (!bl5 && htmlAttribute != null) {
                CSS.setTextColor(mutableAttributeSet, ((ColorValue)htmlAttribute).getValue());
                mutableAttributeSet.addAttribute((Object)CSS.Attribute.COLOR, htmlAttribute);
            }
            if (!bl7) {
                mutableAttributeSet.addAttribute((Object)CSS.Attribute.FONT_FAMILY, object);
            }
            if (!bl6) {
                mutableAttributeSet.addAttribute((Object)CSS.Attribute.FONT_SIZE, new FontSize((int)LengthUnit.getPTforPX(f2)));
                mutableAttributeSet.addAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE, Float.valueOf(f2));
            }
        }
    }

    public MutableAttributeSet getInputAttributes() {
        return this.inputAttributes;
    }

    private void createInputAttributes() {
        this.inputAttributes = new NonCopyAttributeSet();
    }

    public void forceUpdateInputAttributes(JEditorPane jEditorPane) {
        if (jEditorPane == null) {
            return;
        }
        Document document = jEditorPane.getDocument();
        if (!(document instanceof InetHtmlDocument)) {
            return;
        }
        Element element = ((InetHtmlDocument)document).getCharacterElement(Math.max(jEditorPane.getCaret().getMark() - 1, 0));
        this.createInputAttributes(element, this.getInputAttributes());
    }

    public Cursor getDefaultCursor() {
        return this.defaultCursor;
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
    }

    public Cursor getLinkCursor() {
        return this.linkCursor;
    }

    public void setLinkCursor(Cursor cursor) {
        this.linkCursor = cursor;
    }

    public Object clone() {
        return new InetHtmlEditorKit();
    }

    static {
        block4: {
            pasteFromClipBoardPlainAction = new PastePlainAction();
            boldAction = new BoldAction();
            italicAction = new ItalicAction();
            underlineAction = new UnderlineAction();
            searchInit = new SearchAction(true, true);
            searchNext = new SearchAction(false, true);
            searchPrev = new SearchAction(false, false);
            searchClear = new SearchClearAction();
            DEFAULT_ACTIONS = new Action[]{new HRuleAction(), new InsertHtmlAction("insert-softbreak", "<br>"), new BeginEndLineAction("caret-end-line", false, false), new BeginEndLineAction("selection-end-line", false, true), new BeginEndLineAction("caret-begin-line", true, false), new BeginEndLineAction("selection-begin-line", true, true), new AlignmentAction("left-justify", 0), new AlignmentAction("right-justify", 2), new AlignmentAction("center-justify", 1), new AlignmentAction("justified-justify", 3), new DeletePrevCharAction(), new DeleteNextCharAction(), new EnterAction(new DefaultEditorKit.InsertBreakAction()), boldAction, italicAction, underlineAction, new ParagraphIndentAction(true, 40), new ParagraphIndentAction(false, 40), new ListAction(false), new ListAction(true), searchInit, searchNext, searchPrev, searchClear};
            try {
                String string = System.getProperty("java.protocol.handler.pkgs", "");
                if (string.indexOf("com.inet.protocol") < 0) {
                    if (string.length() > 0) {
                        string = string + "|";
                    }
                    string = string + "com.inet.protocol";
                    System.getProperties().put("java.protocol.handler.pkgs", string);
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof SecurityException)) break block4;
                System.err.println("The application does not have the permission to register the 'data' protocol, date URL are therefore disabled");
            }
        }
        SHORTCUT_KEY_MASK = !GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() : 2;
    }

    private static class ScalingFontFactory
    implements InetHtmlFontFactory {
        private float scale = 1.0f;

        private ScalingFontFactory() {
        }

        public Font getFont(String string, int n2, int n3, String string2) {
            return this.getFont(string, n2, (float)n3, string2);
        }

        public Font getFont(String string, int n2, float f2, String string2) {
            float f3 = f2 * this.scale;
            Font font = new Font(string, n2, (int)f3);
            if (f3 != (float)((int)f3)) {
                font = font.deriveFont(f3);
            }
            return font;
        }

        public void setScale(float f2) {
            if ((double)f2 < 0.1) {
                f2 = 0.1f;
            }
            if (f2 > 10.0f) {
                f2 = 10.0f;
            }
            this.scale = f2;
        }

        public boolean requiresText() {
            return false;
        }
    }

    private static class NonCopyAttributeSet
    extends SimpleAttributeSet {
        private NonCopyAttributeSet() {
        }

        public AttributeSet copyAttributes() {
            return this;
        }
    }

    private static class CopyPlainAction
    extends AbstractAction {
        private final JTextComponent editor;

        public CopyPlainAction(JTextComponent jTextComponent) {
            this.editor = jTextComponent;
        }

        public boolean isEnabled() {
            return this.editor != null && this.editor.getSelectionStart() != this.editor.getSelectionEnd();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.editor == null) {
                return;
            }
            TransferHandler transferHandler = this.editor.getTransferHandler();
            if (transferHandler instanceof InetHtmlTransferHandler) {
                InetHtmlTransferHandler inetHtmlTransferHandler = (InetHtmlTransferHandler)transferHandler;
                inetHtmlTransferHandler.setModePlain();
            }
            this.editor.dispatchEvent(new KeyEvent(this.editor, 401, System.currentTimeMillis(), SHORTCUT_KEY_MASK, 67, 'c'));
        }
    }

    private static class PastePlainAction
    extends AbstractAction {
        private static final long serialVersionUID = -6328692980720768453L;

        private PastePlainAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == null) {
                return;
            }
            while (object instanceof Container && !(object instanceof JTextComponent)) {
                if (object instanceof JPopupMenu) {
                    object = ((JPopupMenu)object).getInvoker();
                    continue;
                }
                object = ((Container)object).getParent();
            }
            if (object instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)object;
                TransferHandler transferHandler = jTextComponent.getTransferHandler();
                if (transferHandler instanceof InetHtmlTransferHandler) {
                    InetHtmlTransferHandler inetHtmlTransferHandler = (InetHtmlTransferHandler)transferHandler;
                    inetHtmlTransferHandler.setModePlain();
                }
                jTextComponent.dispatchEvent(new KeyEvent(jTextComponent, 401, System.currentTimeMillis(), SHORTCUT_KEY_MASK, 86, 'v'));
            }
        }
    }

    private class InetHtmlAttributeTracker
    implements CaretListener,
    PropertyChangeListener {
        private Element dotLeaf;
        private Element markLeaf;

        private InetHtmlAttributeTracker() {
        }

        private void updateAttributes(int n2, int n3, JTextComponent jTextComponent) {
            Element element;
            Element element2;
            Document document = jTextComponent.getDocument();
            if (!(document instanceof InetHtmlDocument)) {
                return;
            }
            if (n2 != n3) {
                if (n2 > n3) {
                    ++n3;
                } else {
                    ++n2;
                }
            }
            InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)document;
            Element element3 = null;
            Element element4 = ElementUtils.getLeafAt(element2, n2 == (element2 = inetHtmlDocument.getParagraphElement(n2)).getStartOffset() ? n2 : Math.max(n2 - 1, 0));
            element3 = n2 != n3 ? ElementUtils.getLeafAt(element, n2 == (element = inetHtmlDocument.getParagraphElement(n3)).getStartOffset() ? n3 : Math.max(n3 - 1, 0)) : element4;
            if (element4 != this.dotLeaf || element3 != this.markLeaf) {
                this.dotLeaf = element4;
                this.markLeaf = element3;
                InetHtmlEditorKit.this.createInputAttributes(this.dotLeaf, this.markLeaf, InetHtmlEditorKit.this.getInputAttributes());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getSource();
            if (object2 instanceof JTextComponent && object instanceof InetHtmlDocument) {
                this.updateAttributes(0, 0, (JTextComponent)object2);
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.updateAttributes(caretEvent.getDot(), caretEvent.getMark(), (JTextComponent)caretEvent.getSource());
        }
    }

    public static class ExtendedHyperlinkEvent
    extends HyperlinkEvent {
        private static final long serialVersionUID = 1737694883377397946L;
        public static final String TARGET_TOP = "_top";
        public static final String TARGET_BLANK = "_blank";
        public static final String TARGET_NEW_TAB = "_newtab";
        private String target = "_top";

        public ExtendedHyperlinkEvent(Object object, HyperlinkEvent.EventType eventType, URL uRL, String string, Element element) {
            super(object, eventType, uRL, string, element);
        }

        public void setTarget(String string) {
            this.target = string;
        }

        public String getTarget() {
            return this.target;
        }
    }

    public static class LinkController
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Element curElem = null;
        private Element anchor = null;
        private String href = null;
        private boolean wasCtrlPressed = false;
        private Point start;
        private static final int LINK_TOLERANCE = 10;

        public void mouseMoved(MouseEvent mouseEvent) {
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            if (!(jEditorPane.getEditorKit() instanceof InetHtmlEditorKit) || !(jEditorPane.getDocument() instanceof InetHtmlDocument)) {
                return;
            }
            InetHtmlEditorKit inetHtmlEditorKit = (InetHtmlEditorKit)jEditorPane.getEditorKit();
            InetHtmlDocument inetHtmlDocument = (InetHtmlDocument)jEditorPane.getDocument();
            boolean bl2 = false;
            boolean bl3 = (mouseEvent.getModifiers() & SHORTCUT_KEY_MASK) != 0;
            boolean bl4 = jEditorPane.isEditable();
            Cursor cursor = inetHtmlEditorKit.getDefaultCursor();
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            View view = jEditorPane.getUI().getRootView(jEditorPane).getView(0);
            if (jEditorPane.getDocument() instanceof InetHtmlDocument && view instanceof BoxView) {
                Object object;
                Cloneable cloneable;
                BoxView boxView = (BoxView)view;
                Border border = jEditorPane.getBorder();
                if (border != null && (cloneable = border.getBorderInsets(jEditorPane)) != null) {
                    point.x -= ((Insets)cloneable).left;
                    point.y -= ((Insets)cloneable).top;
                }
                cloneable = ((BoxView)view).getViewForPosition(point, new Rectangle(0, 0, boxView.getOuterWidth(), boxView.getOuterHeight()));
                Element element = boxView.getElement();
                if (cloneable != null) {
                    element = ((ViewPositionInfo)cloneable).getView().getElement();
                }
                this.anchor = null;
                while (element != null) {
                    object = element.getAttributes();
                    if (object.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.A && object.getAttribute((Object)HTML.Attribute.HREF) != null) {
                        this.anchor = element;
                        break;
                    }
                    element = element.getParentElement();
                }
                if (this.anchor != this.curElem) {
                    this.curElem = this.anchor;
                    if (this.anchor == null) {
                        this.href = null;
                        jEditorPane.fireHyperlinkUpdate(this.createHyperlinkEvent(jEditorPane, inetHtmlDocument, this.href, this.curElem, HyperlinkEvent.EventType.EXITED));
                    } else {
                        object = this.anchor.getAttributes().getAttribute((Object)HTML.Attribute.HREF);
                        if (object instanceof UrlValue) {
                            this.href = ((UrlValue)object).getUrl();
                            cursor = inetHtmlEditorKit.getLinkCursor();
                        } else {
                            this.href = object.toString();
                            cursor = inetHtmlEditorKit.getLinkCursor();
                        }
                        jEditorPane.fireHyperlinkUpdate(this.createHyperlinkEvent(jEditorPane, inetHtmlDocument, this.href, this.curElem, HyperlinkEvent.EventType.ENTERED));
                    }
                    if (!bl3 && bl4) {
                        cursor = inetHtmlEditorKit.getDefaultCursor();
                    }
                    bl2 = true;
                } else if (bl4) {
                    if (!this.wasCtrlPressed && bl3 && this.anchor != null && this.href != null) {
                        cursor = inetHtmlEditorKit.getLinkCursor();
                        bl2 = true;
                    }
                    if (this.wasCtrlPressed && !bl3) {
                        cursor = inetHtmlEditorKit.getDefaultCursor();
                        bl2 = true;
                    }
                }
            } else if (bl4) {
                if (!this.wasCtrlPressed && bl3 && this.anchor != null && this.href != null) {
                    cursor = inetHtmlEditorKit.getLinkCursor();
                    bl2 = true;
                }
                if (this.wasCtrlPressed && !bl3) {
                    cursor = inetHtmlEditorKit.getDefaultCursor();
                    bl2 = true;
                }
            }
            if (bl2 && jEditorPane.getCursor() != cursor) {
                jEditorPane.setCursor(cursor);
            }
            this.wasCtrlPressed = bl3;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            this.start = mouseEvent.getPoint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (this.start != null) {
                Point point = mouseEvent.getPoint();
                int n2 = point.x - this.start.x;
                int n3 = point.y - this.start.y;
                int n4 = (int)Math.sqrt(n2 * n2 + n3 * n3);
                if (n4 < 10 && mouseEvent.getButton() == 1) {
                    this.mouseClickedEvent(mouseEvent);
                }
            }
            this.start = null;
        }

        public void mouseClickedEvent(MouseEvent mouseEvent) {
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            if (((mouseEvent.getModifiers() & SHORTCUT_KEY_MASK) != 0 || !jEditorPane.isEditable()) && this.curElem != null && this.href != null && this.anchor != null && jEditorPane.getDocument() instanceof InetHtmlDocument) {
                InetHtmlDocument inetHtmlDocument;
                ExtendedHyperlinkEvent extendedHyperlinkEvent;
                if (this.href.toLowerCase().startsWith(InetHtmlEditorKit.MSO_BLOCKED_LINK_PREFIX)) {
                    this.href = this.href.substring(InetHtmlEditorKit.MSO_BLOCKED_LINK_PREFIX.length());
                }
                if ((extendedHyperlinkEvent = this.createHyperlinkEvent(jEditorPane, inetHtmlDocument = (InetHtmlDocument)jEditorPane.getDocument(), this.href, this.curElem, HyperlinkEvent.EventType.ACTIVATED)) != null) {
                    if (!jEditorPane.isEditable() && (mouseEvent.getModifiers() & SHORTCUT_KEY_MASK) != 0 || mouseEvent.getButton() == 2) {
                        extendedHyperlinkEvent.setTarget("_newtab");
                    }
                    if ((mouseEvent.getModifiers() & 1) != 0) {
                        extendedHyperlinkEvent.setTarget("_blank");
                    }
                    jEditorPane.fireHyperlinkUpdate(extendedHyperlinkEvent);
                    jEditorPane.setToolTipText(null);
                }
            }
        }

        private ExtendedHyperlinkEvent createHyperlinkEvent(JEditorPane jEditorPane, InetHtmlDocument inetHtmlDocument, String string, Element element, HyperlinkEvent.EventType eventType) {
            Serializable serializable;
            URL uRL = null;
            try {
                if (string != null) {
                    string = string.replaceAll("%23", "#");
                    serializable = inetHtmlDocument.getBase();
                    uRL = new URL((URL)serializable, string);
                    if (string != null && "file".equals(uRL.getProtocol()) && string.startsWith("#")) {
                        String string2 = ((URL)serializable).getFile();
                        String string3 = uRL.getFile();
                        if (string2 != null && string3 != null && !string3.startsWith(string2)) {
                            uRL = new URL((URL)serializable, string2 + string);
                        }
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (Logger.doesLog(2)) {
                    Logger.warning("Unable to create link event for invalid URL: " + string);
                }
                uRL = null;
            }
            if (element != null && element.getAttributes().isDefined((Object)HTML.Attribute.TITLE)) {
                string = element.getAttributes().getAttribute((Object)HTML.Attribute.TITLE).toString();
            }
            serializable = new ExtendedHyperlinkEvent(jEditorPane, eventType, uRL, string, element);
            return serializable;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

