/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.html.InetHtmlFontFactory;
import com.inet.html.PainterFactory;
import com.inet.html.ViewPainter;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.Position;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.utils.CSSRules;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxView;
import com.inet.html.views.BulletView;
import com.inet.html.views.ContentView;
import com.inet.html.views.ControlView;
import com.inet.html.views.HRuleView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.ImageView;
import com.inet.html.views.InlineView;
import com.inet.html.views.InsertedContentView;
import com.inet.html.views.ObjectView;
import com.inet.html.views.TableView;
import com.inet.html.views.VariableSpaceView;
import java.awt.Font;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class InetHtmlFactory
implements ViewFactory {
    private final PainterFactory factory;
    private final InetHtmlFontFactory fontFactory;
    private boolean useTextAntiAlias = true;
    private boolean autoScaleImages;

    public InetHtmlFactory() {
        this.factory = new DefaultPainterFactory();
        this.fontFactory = null;
    }

    public InetHtmlFactory(PainterFactory painterFactory, InetHtmlFontFactory inetHtmlFontFactory) {
        this.factory = painterFactory == null ? new DefaultPainterFactory() : painterFactory;
        this.fontFactory = inetHtmlFontFactory != null ? inetHtmlFontFactory : null;
    }

    public void setUseTextAntiAlias(boolean bl2) {
        this.useTextAntiAlias = bl2;
    }

    public void setAutoScaleImages(boolean bl2) {
        this.autoScaleImages = bl2;
    }

    public View create(Element element) {
        Position position;
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.SCRIPT) {
            return null;
        }
        byte by2 = 2;
        byte by3 = 0;
        byte by4 = 0;
        if (object == HTML.Tag.CONTENT) {
            ContentView contentView;
            if (element.getAttributes().isDefined("CR")) {
                contentView = new VariableSpaceView(element, this.factory.createInstance());
                contentView.setBreakable(true);
            } else {
                contentView = new ContentView(element, this.factory.createInstance());
            }
            contentView.factoryPreset(by3, by2, by4);
            return contentView;
        }
        DisplayValue displayValue = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        if (displayValue != null) {
            by2 = displayValue.getDisplay();
        }
        if (by2 == 1) {
            return null;
        }
        FloatValue floatValue = StyleResolver.getAttributeValue(element, AttributeFinder.FLOAT);
        if (floatValue != null) {
            by3 = floatValue.getFloat();
        }
        if (by3 == 0 && (by2 == 8 || object == HTML.Tag.IMG) && (floatValue = StyleResolver.getAttributeValue(element, AttributeFinder.FLOAT_ALIGN)) != null) {
            by3 = floatValue.getFloat();
        }
        if ((position = StyleResolver.getAttributeValue(element, AttributeFinder.POSITION)) != null) {
            by4 = position.getPosition();
        }
        if (object == HTML.Tag.IMG && by3 == 1) {
            by2 = 3;
        }
        if (!CSSRules.isInFlow(by4, by3)) {
            by2 = CSSRules.convertDisplayOnNonFlow(by2);
        }
        BoxView boxView = null;
        if (object == HTML.Tag.INPUT || object == HTML.Tag.SELECT || object == HTML.Tag.OPTION || object == HTML.Tag.TEXTAREA) {
            boxView = new ControlView(element, this.factory.createInstance());
        } else {
            if (by2 == 2 && element.getElementCount() > 0) {
                return new InlineView(element);
            }
            if (object == HTML.Tag.OBJECT || object == HTML.Tag.APPLET) {
                ObjectView objectView = new ObjectView(element);
                boxView = objectView.canLoad() ? objectView : new BlockView(element, this.factory.createInstance());
            } else if (object == HTML.Tag.BR) {
                VariableSpaceView variableSpaceView = new VariableSpaceView(element, this.factory.createInstance());
                variableSpaceView.setFixed(true);
                variableSpaceView.setWidth(1);
                boxView = variableSpaceView;
            } else if (object == HTML.Tag.CONTENT) {
                boxView = new ContentView(element, this.factory.createInstance());
            } else if (object == HTML.Tag.TABLE || by2 == 8) {
                boxView = new TableView(element, this.factory.createInstance());
            } else if (object == HTML.Tag.HR) {
                boxView = new HRuleView(element, this.factory.createInstance());
            } else if (object == HTML.Tag.IMG) {
                boxView = new ImageView(element, this.factory.createInstance());
                ((ImageView)boxView).setAutoScaleMode(this.autoScaleImages);
            } else {
                if (object == HTML.Tag.SCRIPT || object == HTML.Tag.HEAD) {
                    return null;
                }
                if (object == HTML.Tag.HTML && element.getParentElement() == null) {
                    HtmlRootView htmlRootView = new HtmlRootView(element, this.factory.createInstance(), this.fontFactory);
                    htmlRootView.getRenderContext().setTextAntiAlias(this.useTextAntiAlias);
                    boxView = htmlRootView;
                } else {
                    boxView = new BlockView(element, this.factory.createInstance());
                }
            }
        }
        boxView.factoryPreset(by3, by2, by4);
        return boxView;
    }

    public VariableSpaceView createSpace(Element element, boolean bl2) {
        return new VariableSpaceView(element, bl2, this.factory.createInstance());
    }

    public VariableSpaceView createSpace(Element element, int n2) {
        return new VariableSpaceView(element, n2, this.factory.createInstance());
    }

    public ImageView createImage(Element element) {
        ImageView imageView = new ImageView(element, this.factory.createInstance());
        imageView.setAutoScaleMode(this.autoScaleImages);
        return imageView;
    }

    public BoxView create(Element element, int n2) {
        switch (n2) {
            case 8: {
                return new TableView(element, this.factory.createInstance());
            }
            case 3: {
                return new BlockView(element, this.factory.createInstance());
            }
        }
        return (BoxView)this.create(element);
    }

    public BoxView createListItem(BoxView boxView, int n2) {
        UriValue uriValue = AttributeFinder.LIST_STYLE_IMAGE.getAttributeValue(boxView);
        if (uriValue != null) {
            ImageView imageView = this.createImage(boxView.getElement());
            imageView.setBase(uriValue.getBaseURL());
            imageView.predictSource(uriValue.getUrl());
            imageView.setMarker(true);
            imageView.setListItemFallback(this.createNonImageListItem(boxView, n2));
            return imageView;
        }
        return this.createNonImageListItem(boxView, n2);
    }

    private BoxView createNonImageListItem(BoxView boxView, int n2) {
        int n3 = AttributeFinder.LIST_STYLE_TYPE.getAttributeValue(boxView).getType();
        switch (n3) {
            case 0: 
            case 1: 
            case 2: {
                return new BulletView(boxView.getElement(), n3, this.factory.createInstance());
            }
        }
        InsertedContentView insertedContentView = new InsertedContentView(boxView.getElement(), this.factory.createInstance());
        insertedContentView.setNewContent(InetHtmlFactory.getListValue(n2, n3));
        insertedContentView.setMarker(true);
        return insertedContentView;
    }

    private static final String getListValue(int n2, int n3) {
        switch (n3) {
            case 0: {
                return "\u2022";
            }
            case 1: {
                return "\u25e6";
            }
            case 2: {
                return "\u25aa";
            }
            case 15: {
                return InetHtmlFactory.getLatinListValue(n2, true);
            }
            case 16: {
                return InetHtmlFactory.getLatinListValue(n2, false);
            }
            case 6: {
                if (n2 <= 0) {
                    return n2 + ".";
                }
                return InetHtmlFactory.calculateRomanNumerals(n2) + ".";
            }
            case 5: {
                if (n2 <= 0) {
                    return n2 + ".";
                }
                return InetHtmlFactory.calculateRomanNumerals(n2).toLowerCase() + ".";
            }
        }
        return n2 + ".";
    }

    private static String getLatinListValue(int n2, boolean bl2) {
        int n3 = bl2 ? 97 : 65;
        String string = "";
        if (n2 <= 0) {
            return n2 + ".";
        }
        string = (char)(--n2 % 26 + n3) + string;
        n2 /= 26;
        while (n2 > 0) {
            string = (char)((n2 - 1) % 26 + n3) + string;
            n2 /= 26;
        }
        return string + ".";
    }

    private static final String calculateRomanNumerals(int n2) {
        String string = "IVXLCDM";
        String string2 = "";
        int n3 = 1000;
        if (n2 < 1 || n2 > 4999) {
            return "0";
        }
        if (n2 > 3999) {
            string2 = string2 + string.charAt(6);
            n2 -= 1000;
        }
        for (int i2 = 3; i2 >= 0; --i2) {
            int n4 = n2 / n3;
            n2 %= n3;
            switch (n4) {
                case 0: {
                    break;
                }
                case 5: {
                    string2 = string2 + string.charAt(2 * i2 + 1);
                    break;
                }
                case 9: {
                    string2 = string2 + string.charAt(2 * i2);
                    string2 = string2 + string.charAt(2 * i2 + 2);
                    break;
                }
                case 4: {
                    string2 = string2 + string.charAt(2 * i2);
                    string2 = string2 + string.charAt(2 * i2 + 1);
                    break;
                }
                default: {
                    if (n4 > 5) {
                        string2 = string2 + string.charAt(2 * i2 + 1);
                        n4 -= 5;
                    }
                    for (int i3 = 0; i3 < n4; ++i3) {
                        string2 = string2 + string.charAt(2 * i2);
                    }
                }
            }
            n3 /= 10;
        }
        return string2;
    }

    public static class DefaultFontFactory
    implements InetHtmlFontFactory {
        public Font getFont(String string, int n2, int n3, String string2) {
            return new Font(string, n2, n3);
        }

        public Font getFont(String string, int n2, float f2, String string2) {
            Font font = new Font(string, n2, (int)f2);
            if (f2 != (float)((int)f2)) {
                font = font.deriveFont(f2);
            }
            return font;
        }

        public boolean requiresText() {
            return false;
        }
    }

    private class DefaultPainterFactory
    implements PainterFactory {
        private DefaultPainterFactory() {
        }

        public ViewPainter createInstance() {
            return null;
        }
    }
}

