/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.Styles;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.CssParser;
import com.inet.html.parser.DocType;
import com.inet.html.parser.PushReader;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.ClassValue;
import com.inet.html.parser.converter.DisplayValue;
import com.inet.html.parser.converter.EmptyValue;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.SingleAttributeValue;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.parser.converter.WhiteSpace;
import com.inet.html.utils.DocumentImage;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.html.utils.URLUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreeNode;

public class InetHtmlParser {
    private static int maximumStackSize = 200;
    private static final String FRAGMENT_START = "StartFragment-->";
    private static final String FRAGMENT_END = "EndFragment-->";
    private PushReader reader;
    private InetHtmlDocument doc;
    private InetHtmlConfiguration currentConfig;
    private URL url;
    private boolean ignoreCharset;
    private boolean ignoreNamespaces = true;
    private String charset;
    private boolean dropUnknownStyles;
    private static final Element[] EMPTY = new Element[0];
    private boolean isInsert = false;
    private Styles styles;
    private Object currentSource;
    private Object classAppendix;
    private long endTime = -1L;
    private InetHtmlDocument.EventList eventList;
    private ParserState state;
    private ParserState rootState;
    private List<ParserState> tableStack = new ArrayList<ParserState>();
    private Position startFragment;
    private Position endFragment;
    private static final HashMap<HTML.Tag, TagList> PARENT_REQUIRED = new HashMap();
    private static final HashMap<HTML.Tag, TagList> PARENT_FORBIDDEN = new HashMap();
    public static final Set<HTML.Tag> TABLE_STRUCT_TAGS = new HashSet<HTML.Tag>(){
        {
            this.add(HTML.Tag.TR);
            this.add(HTML.Tag.TBODY);
            this.add(HTML.Tag.THEAD);
            this.add(HTML.Tag.TFOOT);
            this.add(HTML.Tag.COL);
            this.add(HTML.Tag.COLGROUP);
            this.add(HTML.Tag.TABLE);
        }
    };
    private static final Set<HTML.Tag> TABLE_CELL_TAGS = new HashSet<HTML.Tag>(){
        {
            this.add(HTML.Tag.CAPTION);
            this.add(HTML.Tag.TD);
            this.add(HTML.Tag.TH);
        }
    };

    public static void setMaximumStackSize(int n2) {
        maximumStackSize = Math.max(2, n2);
    }

    public void parse(Reader reader, InetHtmlDocument inetHtmlDocument, AbstractDocument.BranchElement branchElement, int n2, InetHtmlDocument.EventList eventList, boolean bl2, Object object) throws IOException, BadLocationException {
        Object object2;
        Boolean bl3;
        long l2;
        this.currentConfig = inetHtmlDocument.getConfiguration();
        this.dropUnknownStyles = inetHtmlDocument.getProperty(InetHtmlDocument.PROPERTY_DROP_UNKNOWN_STYLES) == Boolean.TRUE;
        this.eventList = eventList != null ? eventList : new DummyEventList();
        this.doc = inetHtmlDocument;
        this.styles = inetHtmlDocument.getStyleResolver().getStyles();
        this.currentSource = object;
        this.startFragment = null;
        this.endFragment = null;
        Object object3 = inetHtmlDocument.getProperty(InetHtmlDocument.PROPERTY_TIMEOUT);
        if (object3 instanceof Number && (l2 = ((Number)object3).longValue()) > 0L) {
            this.endTime = System.currentTimeMillis() + l2;
        }
        boolean bl4 = this.ignoreCharset = (bl3 = (Boolean)inetHtmlDocument.getProperty("IgnoreCharsetDirective")) == null ? false : bl3;
        if (reader instanceof InputStreamReader) {
            this.charset = ((InputStreamReader)reader).getEncoding();
        }
        this.ignoreNamespaces = (object2 = inetHtmlDocument.getProperty(InetHtmlDocument.PROPERTY_IGNORE_NAMESPACES)) == null || !(object2 instanceof Boolean) || object2 != Boolean.FALSE;
        this.reader = new PushReader(reader);
        this.isInsert = branchElement != inetHtmlDocument.getDefaultRootElement();
        this.url = inetHtmlDocument.getBase();
        inetHtmlDocument.getDocType().setType(DocType.Type.quirks);
        this.state = new ParserState(branchElement, n2, -1);
        for (Element element = branchElement; element != null; element = element.getParentElement()) {
            this.state.tagStack.add(element.getAttributes().getAttribute(StyleConstants.NameAttribute));
        }
        Collections.reverse(this.state.tagStack);
        this.state.activate();
        this.state.isInBody = this.isInsert;
        this.rootState = this.state;
        this.checkForUtf8Prefix();
        int n3 = -1;
        try {
            while (true) {
                int n4 = this.reader.read();
                switch (n4) {
                    case -1: {
                        this.finishParse(eventList);
                        return;
                    }
                    case 60: {
                        if (this.parseTag()) break;
                        this.appendCharToContent((char)n4);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: 
                    case 65279: {
                        if (this.state.isPreformatted) {
                            if (n4 == 13) {
                                this.state.content.append('\n');
                                break;
                            }
                            if (n3 == 13 && n4 == 10) break;
                            this.state.content.append((char)n4);
                            break;
                        }
                        if (this.state.isFirstTextInLine && !bl2 || this.state.wasWhitespace && !this.state.wasNBWhitespace && !bl2) break;
                        this.appendCharToContent(' ');
                        break;
                    }
                    case 38: {
                        this.appendCharToContent(this.reader.readQuotedChar());
                        break;
                    }
                    default: {
                        this.appendCharToContent((char)n4);
                    }
                }
                n3 = n4;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.finishParse(eventList);
            return;
        }
    }

    private void appendCharToContent(char c2) {
        this.state.content.append(c2);
        this.state.isFirstTextInLine = false;
        this.state.wasWhitespace = c2 == ' ' || c2 == '\u00a0';
        this.state.wasNBWhitespace = this.state.wasWhitespace && c2 == '\u00a0';
    }

    private boolean parseTag() throws IOException, BadLocationException {
        boolean bl2;
        HTML.Tag tag;
        if (this.endTime > 0L && System.currentTimeMillis() > this.endTime) {
            this.reader.shutDown();
            return true;
        }
        this.reader.startTransaction();
        String string = this.reader.readKey();
        if (string == null) {
            this.reader.rollBack();
            return false;
        }
        if ("!DOCTYPE".equals(string)) {
            this.addContentToken(false);
            this.parseDocType();
            this.reader.commit();
            return true;
        }
        if (string == "!--") {
            this.reader.commit();
            String string2 = this.reader.skipComment();
            if (this.startFragment == null && FRAGMENT_START.equals(string2)) {
                this.startFragment = this.doc.getContentImpl().createPosition(this.state.pos.getOffset() - 1);
            }
            if (this.endFragment == null && FRAGMENT_END.equals(string2)) {
                this.endFragment = this.doc.getContentImpl().createPosition(this.state.pos.getOffset() - 1 + this.state.content.length());
            }
            return true;
        }
        if (string.length() == 0) {
            if (this.reader.read() != 47) {
                this.addContentToken(true);
                if (Logger.doesLog(2)) {
                    Logger.warning("Empty Tag: " + string);
                }
                return true;
            }
            string = this.reader.readKey();
            if (string != null) {
                string = string.toLowerCase();
            }
            if (string == null) {
                return false;
            }
            tag = HTML.getTag(string);
            if (tag != HTML.Tag.BR) {
                if (tag != null && this.skipTagIfNamespace(string)) {
                    return true;
                }
                if (!this.reader.skipTag()) {
                    this.reader.rollBack();
                    return false;
                }
                if (tag != null && !ElementUtils.isMonolithic(tag) && !this.isSkipOnInsert(tag)) {
                    this.addContentToken(true);
                    this.removeTag((Object)tag, false);
                } else {
                    this.addContentToken(false);
                    if (string.equals(this.state.getParentName())) {
                        string = InetHtmlDocument.getCachedString(string);
                        this.removeTag(string, false);
                    }
                }
                return true;
            }
        }
        if ((tag = HTML.getTag(string)) == null && this.skipTagIfNamespace(string)) {
            return true;
        }
        if (this.state.isInBody || !this.state.wasWhitespace || this.state.content.length() > 1) {
            this.addContentToken(false);
        } else {
            this.state.content.setLength(0);
            this.state.wasWhitespace = false;
        }
        MutableAttributeSet mutableAttributeSet = this.parseAttributes(tag);
        if (mutableAttributeSet == null) {
            this.reader.rollBack();
            return false;
        }
        this.reader.commit();
        this.setSourceClassIfRequired(mutableAttributeSet);
        Element element = null;
        if (tag == null) {
            if (string.startsWith("![")) {
                return true;
            }
            if (Logger.doesLog(2)) {
                Logger.warning("Unknown Tag: " + string);
            }
            string = InetHtmlDocument.getCachedString(string.toLowerCase());
            bl2 = mutableAttributeSet.getAttribute("/") == Boolean.TRUE;
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, string);
            this.checkForBodyTag();
        } else {
            if (this.isSkipOnInsert(tag)) {
                return true;
            }
            mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)tag);
            switch (tag) {
                case STYLE: {
                    this.parseStyle();
                    return true;
                }
                case LINK: {
                    this.parseLink(mutableAttributeSet);
                    return true;
                }
                case SCRIPT: {
                    this.reader.skipScript();
                    return true;
                }
                case TITLE: {
                    this.state.isInTitle = true;
                    return true;
                }
                case HTML: {
                    if (!this.isEquals(this.state.parentElement, (Object)HTML.Tag.HTML)) break;
                    MutableAttributeSet mutableAttributeSet2 = (MutableAttributeSet)this.state.parentElement.getAttributes();
                    mutableAttributeSet2.removeAttributes(mutableAttributeSet2);
                    mutableAttributeSet2.addAttributes(mutableAttributeSet);
                    this.doc.fillAttributes(this.state.parentElement);
                    return true;
                }
                case BASE: {
                    this.checkBaseURLChange(mutableAttributeSet);
                    break;
                }
                case META: {
                    this.readMetaElement(mutableAttributeSet);
                    break;
                }
                case BODY: {
                    this.removeTag((Object)HTML.Tag.HEAD, false);
                    this.state.isInBody = true;
                    break;
                }
                default: {
                    this.checkForBodyTag(tag);
                }
            }
            element = this.removeTagThatNeedNoEndtag(tag, mutableAttributeSet);
            bl2 = ElementUtils.isMonolithic(tag);
        }
        if (element == null) {
            Element element2 = element = bl2 ? this.addLeafElement(mutableAttributeSet, "\n") : this.addBranchElement(mutableAttributeSet);
        }
        if (element == null) {
            return true;
        }
        if (bl2) {
            this.state.wasWhitespace = false;
            this.state.isFirstTextInLine = false;
        }
        if (!this.state.isFirstTextInLine && InetHtmlParser.breaksFlow(element)) {
            this.state.isFirstTextInLine = true;
        }
        if (InetHtmlParser.isPreformatted(element)) {
            this.state.isPreformatted = true;
        }
        return true;
    }

    private void readMetaElement(MutableAttributeSet mutableAttributeSet) throws ChangedCharSetException {
        if (!this.ignoreCharset && !this.isCharsetSetByHTTP()) {
            String string = (String)mutableAttributeSet.getAttribute((Object)HTML.Attribute.CONTENT);
            String string2 = (String)mutableAttributeSet.getAttribute((Object)HTML.Attribute.CHARSET);
            if (string != null) {
                String string3 = (String)mutableAttributeSet.getAttribute((Object)HTML.Attribute.HTTP_EQUIV);
                if ("content-type".equalsIgnoreCase(string3)) {
                    if (!string.equalsIgnoreCase("text/html") && !string.equalsIgnoreCase("text/plain")) {
                        this.throwCharsetException(string, false);
                    }
                } else if ("charset".equalsIgnoreCase(string3)) {
                    this.throwCharsetException(string, true);
                }
            } else if (string2 != null) {
                this.throwCharsetException(string2, true);
            }
        }
    }

    private void checkBaseURLChange(MutableAttributeSet mutableAttributeSet) {
        block4: {
            Object object;
            if (!this.state.isInBody && mutableAttributeSet.isDefined((Object)HTML.Attribute.HREF) && (object = mutableAttributeSet.getAttribute((Object)HTML.Attribute.HREF)) instanceof UrlValue) {
                try {
                    URL uRL = new URL(this.url, ((UrlValue)object).getUrl().toString());
                    if (uRL.getHost() != null) {
                        this.doc.setBase(uRL);
                        this.url = uRL;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    if (!Logger.doesLog(3)) break block4;
                    Logger.info("Could not set Base-URL, the URL '" + ((UrlValue)object).getUrl() + "'");
                }
            }
        }
    }

    private void setSourceClassIfRequired(MutableAttributeSet mutableAttributeSet) {
        if (this.classAppendix != null && this.currentSource != null) {
            Object object = mutableAttributeSet.getAttribute((Object)HTML.Attribute.CLASS);
            if (!(object instanceof ClassValue)) {
                ClassValue classValue = new ClassValue();
                mutableAttributeSet.addAttribute((Object)HTML.Attribute.CLASS, classValue);
                classValue.addClass(this.classAppendix);
            } else {
                ClassValue classValue = (ClassValue)object;
                ArrayList<Object> arrayList = classValue.getClassNames();
                boolean bl2 = false;
                if (arrayList != null && arrayList.size() > 0) {
                    for (Object object2 : arrayList) {
                        if (object2.getClass() != String.class || !object2.toString().startsWith("jwe-style")) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (!bl2) {
                    classValue.addClass(this.classAppendix);
                }
            }
        }
    }

    private void throwCharsetException(String string, boolean bl2) throws ChangedCharSetException {
        string = string.replaceAll("(?i)gb2312|euc_cn|GB18030", "GBK");
        if (bl2) {
            this.charset = string;
        }
        throw new ChangedCharSetException(string, bl2);
    }

    private boolean isCharsetSetByHTTP() {
        String string = (String)this.doc.getProperty("content-type");
        return string != null && string.contains("charset");
    }

    private void addContentToken(boolean bl2) throws BadLocationException {
        Element element;
        char c2;
        if (this.state.isInTitle) {
            this.state.isInTitle = false;
            this.doc.getDocumentProperties().put("title", this.state.getContentAndReset().trim());
            this.state.isFirstTextInLine = true;
            return;
        }
        if (this.state.content.length() == 0) {
            return;
        }
        this.checkForBodyTag();
        String string = this.state.getContentAndReset();
        if (this.state.isInTableStructure()) {
            this.switchToTableFallback();
        }
        this.state.crInsertLevel = this.state.parentElement;
        if (bl2 && this.state.wasWhitespace && string.length() > 0 && InetHtmlDocument.isParagraph(this.state.parentElement) && (this.state.parentElement.getElementCount() == 0 || this.state.parentElement.getElementCount() <= this.state.elementIdx) && ((c2 = string.charAt(string.length() - 1)) == ' ' || c2 == '\t')) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.state.elementIdx > 0 && this.state.tagStack.size() > maximumStackSize && (element = this.state.parentElement.getElement(this.state.elementIdx - 1)).isLeaf() && !element.getAttributes().isDefined("CR") && element.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
            this.insertString(this.state.getOffset() - 1, string);
            return;
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
        this.addLeafElement(simpleAttributeSet, string);
    }

    private void checkForBodyTag() throws BadLocationException {
        if (HTML.Tag.HTML != this.state.getParentName() || this.state.isInBody) {
            return;
        }
        this.removeTag((Object)HTML.Tag.HEAD, false);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.BODY);
        this.addBranchElement(simpleAttributeSet);
    }

    private void checkForBodyTag(HTML.Tag tag) throws BadLocationException {
        if (tag != null) {
            switch (tag) {
                case STYLE: 
                case LINK: 
                case SCRIPT: 
                case META: 
                case HEAD: {
                    return;
                }
            }
        }
        this.checkForBodyTag();
    }

    protected static boolean isMonolithic(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        if (attributeSet.containsAttribute("CR", Boolean.TRUE)) {
            return true;
        }
        if (attributeSet.containsAttribute("/", Boolean.TRUE)) {
            return true;
        }
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            return ElementUtils.isMonolithic((HTML.Tag)((Object)object));
        }
        return attributeSet.containsAttribute("/", Boolean.TRUE);
    }

    private boolean isSkipOnInsert(HTML.Tag tag) {
        if (!this.isInsert()) {
            return false;
        }
        switch (tag) {
            case HTML: 
            case META: 
            case BODY: 
            case HEAD: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNeedNoEndTag(HTML.Tag tag) {
        if (tag == null) {
            return false;
        }
        switch (tag) {
            case P: 
            case LI: 
            case TD: 
            case TR: 
            case H1: 
            case H2: 
            case H3: 
            case H4: 
            case H5: 
            case H6: 
            case TH: {
                return true;
            }
        }
        return false;
    }

    private static boolean isParagraph(HTML.Tag tag) {
        switch (tag) {
            case P: 
            case H1: 
            case H2: 
            case H3: 
            case H4: 
            case H5: 
            case H6: {
                return true;
            }
        }
        return false;
    }

    private Element removeEmptyElement(Element element, Element element2) {
        while (element != null && element.getElementCount() == 0 && element != element2) {
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element.getParentElement();
            if (branchElement == null) {
                return element;
            }
            int n2 = branchElement.getIndex((TreeNode)((Object)element));
            if (n2 < 0) {
                return branchElement;
            }
            this.replaceElements(branchElement, n2, EMPTY, new Element[]{element});
            element = branchElement;
        }
        return element;
    }

    private Element removeTagThatNeedNoEndtag(HTML.Tag tag, AttributeSet attributeSet) throws BadLocationException {
        if (InetHtmlParser.isNeedNoEndTag(tag)) {
            boolean bl2 = InetHtmlParser.isParagraph(tag);
            Element element = this.state.parentElement;
            int n2 = this.state.getOffset() - 1;
            for (AbstractDocument.BranchElement branchElement = this.state.parentElement; branchElement != null; branchElement = (AbstractDocument.BranchElement)branchElement.getParentElement()) {
                HTML.Tag tag2;
                byte by2 = StyleResolver.getAttributeValue(branchElement, AttributeFinder.DISPLAY).getDisplay();
                if (by2 == 2) continue;
                Object object = branchElement.getAttribute(StyleConstants.NameAttribute);
                HTML.Tag tag3 = tag2 = object instanceof HTML.Tag ? (HTML.Tag)((Object)object) : null;
                if (tag2 != null && (tag2 == tag || bl2 && InetHtmlParser.isParagraph(tag2))) {
                    AbstractDocument.BranchElement branchElement2 = null;
                    if (element.getElementCount() == 0 && element != branchElement) {
                        element = this.removeEmptyElement(element, branchElement);
                        this.state.parentElement = element;
                    }
                    if (!this.removeTag((Object)tag2, false)) {
                        branchElement2 = this.splitBranchElementIfNeeded(branchElement, attributeSet);
                    }
                    if (n2 > element.getStartOffset()) {
                        char c2 = n2 > 0 ? this.doc.getContentImpl().getString(n2 - 1, 1).charAt(0) : (char)'\u0000';
                        Element element2 = ElementUtils.getLeafAt(this.state.rootElement, n2 - 1);
                        if (c2 == ' ' || c2 == '\t') {
                            if (element2.getEndOffset() - element2.getStartOffset() == 1) {
                                this.doc.removeCompleteImpl(element2, this.eventList);
                            }
                            this.removeString(n2 - 1, 1);
                        }
                    }
                    return branchElement2;
                }
                if (InetHtmlParser.isNeedNoEndTag(tag2) && !bl2) continue;
                return null;
            }
        }
        return null;
    }

    private AbstractDocument.BranchElement splitBranchElementIfNeeded(AbstractDocument.BranchElement branchElement, AttributeSet attributeSet) {
        AbstractDocument.BranchElement branchElement2;
        block6: {
            if (!this.isInsert()) {
                return branchElement;
            }
            branchElement2 = (AbstractDocument.BranchElement)branchElement.getParent();
            if (branchElement2 == null) {
                return null;
            }
            if (ElementUtils.isRelated(this.state.rootElement, branchElement)) {
                this.state.rootElement = branchElement2;
            }
            try {
                if (this.state.getOffset() - 1 >= branchElement.getStartOffset()) {
                    this.doc.splitElement(branchElement, this.state.getOffset() - 1, attributeSet, this.eventList, false, true);
                }
            }
            catch (BadLocationException badLocationException) {
                if (!Logger.doesLog(1)) break block6;
                Logger.error(badLocationException);
            }
        }
        this.state.parentElement = (AbstractDocument.BranchElement)branchElement2.getElement(branchElement2.getElementIndex(this.state.getOffset() - 1));
        this.state.elementIdx = 0;
        return this.state.parentElement;
    }

    private boolean skipTagIfNamespace(String string) throws IOException {
        if (this.ignoreNamespaces && string.indexOf(58) >= 0) {
            return this.reader.skipTag();
        }
        return false;
    }

    private MutableAttributeSet parseAttributes(HTML.Tag tag) throws IOException {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        String string;
        block6: while ((string = this.reader.readKey()) != null) {
            int n2;
            string = string.toLowerCase();
            do {
                n2 = this.reader.read();
                switch (n2) {
                    case 60: {
                        return null;
                    }
                    case -1: 
                    case 62: {
                        if (string.length() > 0) {
                            this.addEmptyValue(tag, simpleAttributeSet, string);
                        }
                        return simpleAttributeSet;
                    }
                    case 61: {
                        String string2 = this.reader.readValue();
                        HTML.Attribute attribute = HTML.getAttributeKey(string);
                        if (attribute == HTML.Attribute.STYLE) {
                            new CssParser(string2, this.styles, this.url, this.dropUnknownStyles, this.isInsert).parseStyle(simpleAttributeSet);
                            simpleAttributeSet.addAttribute((Object)attribute, string2);
                            continue block6;
                        }
                        if (attribute != null) {
                            AttributeValue attributeValue = AttributeValue.convertValue(this.doc, tag, attribute, string2);
                            simpleAttributeSet.addAttribute((Object)attribute, attributeValue == null ? InetHtmlDocument.getCachedString(string2) : attributeValue);
                            continue block6;
                        }
                        simpleAttributeSet.addAttribute(string, InetHtmlDocument.getCachedString(string2));
                        continue block6;
                    }
                    case 47: {
                        if (tag != null) continue block6;
                        simpleAttributeSet.addAttribute("/", Boolean.TRUE);
                        continue block6;
                    }
                }
            } while (Character.isWhitespace(n2));
            this.reader.push((char)n2);
            this.addEmptyValue(tag, simpleAttributeSet, string);
        }
        return null;
    }

    private void addEmptyValue(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, String string) {
        HTML.Attribute attribute = HTML.getAttributeKey(string);
        if (attribute != null) {
            AttributeValue attributeValue = AttributeValue.convertValue(this.doc, tag, attribute, null);
            if (attributeValue == null) {
                mutableAttributeSet.addAttribute((Object)attribute, EmptyValue.PARSER);
            } else {
                mutableAttributeSet.addAttribute((Object)attribute, attributeValue);
            }
        } else {
            mutableAttributeSet.addAttribute(string, EmptyValue.PARSER);
        }
    }

    private void finishParse(InetHtmlDocument.EventList eventList) throws BadLocationException {
        Object object;
        int n2;
        int n3;
        if (this.state.isInTableStructure()) {
            this.addContentToken(true);
        }
        if (this.state != this.rootState) {
            this.state.deactivate();
            this.addContentToken(true);
            this.state = this.rootState;
        }
        if (this.tableStack.size() > 0) {
            for (n3 = this.tableStack.size() - 1; n3 >= 0; --n3) {
                this.tableStack.remove(n3).finalizeState();
            }
        }
        this.state.isOnFinish = true;
        this.addContentToken(true);
        n3 = this.state.tagStack.contains((Object)HTML.Tag.TABLE) ? 1 : 0;
        if (n3 == 0 && (n2 = this.state.pos.getOffset() - 2) >= 0) {
            object = this.state.parentElement.getChildCount() > 0 ? ElementUtils.getLeafAt(this.state.parentElement, n2) : this.state.parentElement;
            n3 |= ElementUtils.findParentByTag(object, HTML.Tag.TABLE) != null ? 1 : 0;
        }
        for (n2 = this.state.tagStack.size() - 1; n2 >= 0; --n2) {
            object = this.state.tagStack.get(n2);
            if (n3 != 0 && (object == HTML.Tag.BODY || object == HTML.Tag.HTML)) {
                Element element;
                if (object == HTML.Tag.BODY) {
                    this.addCRMarker();
                    n3 = 0;
                }
                if (object == HTML.Tag.HTML && (element = ElementUtils.getBodyElement(this.doc)) != null) {
                    AbstractDocument.BranchElement branchElement = this.state.parentElement;
                    int n4 = this.state.elementIdx;
                    this.state.parentElement = (AbstractDocument.BranchElement)element;
                    this.state.elementIdx = element.getElementCount();
                    this.addCRMarker();
                    this.state.parentElement = branchElement;
                    this.state.elementIdx = n4;
                }
            }
            this.removeTag(object, false);
        }
        this.state.finalizeState();
    }

    private boolean removeTag(Object object, boolean bl2) throws BadLocationException {
        Object object2;
        int n2;
        MutableAttributeSet mutableAttributeSet;
        Object object3;
        Element element;
        if (this.state != this.rootState && (TABLE_CELL_TAGS.contains(object) || TABLE_STRUCT_TAGS.contains(object))) {
            this.state.deactivate();
            this.state = this.rootState;
        }
        int n3 = this.state.tagStack.size() - 1;
        boolean bl3 = this.state.isInTableStructure();
        if (n3 > maximumStackSize) {
            element = this.state.tagStack.get(n3);
            while (n3 > maximumStackSize && element != object && n3 > 0) {
                element = this.state.tagStack.get(--n3);
                if (element == HTML.Tag.TABLE && object != element && !bl2) {
                    return false;
                }
                if ((bl3 || object != HTML.Tag.TH) && object != HTML.Tag.TD) continue;
                bl3 = true;
            }
        }
        element = this.state.parentElement;
        if (n3 <= maximumStackSize) {
            while (element != null && element != this.state.rootElement) {
                object3 = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (object3 == HTML.Tag.TABLE && object != object3 && !bl2) {
                    return false;
                }
                if (!bl3 && object == HTML.Tag.TH || object == HTML.Tag.TD) {
                    bl3 = true;
                }
                if (object == object3) break;
                element = element.getParentElement();
                --n3;
            }
            if (element == null || element == this.state.rootElement || element.getParentElement() == null) {
                return false;
            }
        }
        if (object == HTML.Tag.TABLE) {
            if (this.tableStack.size() > 0) {
                this.tableStack.remove(this.tableStack.size() - 1).finalizeState();
            }
            bl3 = false;
            this.state.setInTableStructure(false);
        }
        while (this.state.tagStack.size() > n3) {
            this.state.tagStack.remove(this.state.tagStack.size() - 1);
        }
        if (this.state.tagStack.size() > maximumStackSize) {
            this.state.setInTableStructure(bl3);
            return true;
        }
        if (this.state.parentElement.getChildCount() == 0) {
            object3 = new SimpleAttributeSet();
            ((SimpleAttributeSet)object3).addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
            if (this.currentConfig.isTransformEmptyBlocks() && this.state.isInBody && ElementUtils.isBlockElement(element)) {
                ((SimpleAttributeSet)object3).addAttribute("CR", Boolean.TRUE);
                this.addLeafElement((AttributeSet)object3, "\n");
            } else {
                this.addLeafElement((AttributeSet)object3, "");
            }
        }
        if (this.state.getOffset() - 1 < element.getEndOffset() && !this.state.isOnFinish && this.state.isInBody) {
            element = this.splitBranchElementIfNeeded((AbstractDocument.BranchElement)element, element.getAttributes());
            object3 = element;
            n2 = ((AbstractDocument.AbstractElement)(mutableAttributeSet = (AbstractDocument.BranchElement)element.getParentElement())).getIndex((TreeNode)((Object)element));
            int n4 = n2 - 1;
            element = ((AbstractDocument.BranchElement)mutableAttributeSet).getElement(n4 >= 0 ? n4 : 0);
            if (object3.getEndOffset() - object3.getStartOffset() == 1 && (object2 = ElementUtils.getLeafAt((Element)object3, object3.getStartOffset())).getAttributes().isDefined("CR")) {
                this.replaceElements((AbstractDocument.BranchElement)mutableAttributeSet, n2, EMPTY, new Element[]{object3});
                this.removeString(object3.getStartOffset(), 1);
            }
        }
        if (this.state.getOffset() - 1 == element.getEndOffset() && InetHtmlParser.breaksFlow(element)) {
            Element element2;
            object3 = ElementUtils.getLeafAt(element, element.getEndOffset() - 1);
            if (object3 == null || !object3.getAttributes().isDefined("CR")) {
                mutableAttributeSet = new SimpleAttributeSet();
                ((SimpleAttributeSet)mutableAttributeSet).addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                ((SimpleAttributeSet)mutableAttributeSet).addAttribute("CR", Boolean.TRUE);
                if (this.currentConfig.isTransformEmptyBlocks()) {
                    n2 = element.getEndOffset() - element.getStartOffset();
                    AbstractDocument.Content content = this.doc.getContentImpl();
                    Object object4 = object2 = this.state.getOffset() > 1 ? content.getString(this.state.getOffset() - 2, 1) : "X";
                    if (n2 == 1 && ((String)object2).charAt(0) == '\u00a0') {
                        int n5 = this.state.getOffset() - 1;
                        Element element3 = ElementUtils.getLeafAt(element, n5 - 1);
                        this.doc.addAttribute(element3.getAttributes(), "CR", Boolean.TRUE);
                        this.insertString(n5, "\n");
                        this.removeString(n5 - 1, 1);
                        this.state.isFirstTextInLine = true;
                    } else {
                        if (this.state.crInsertLevel != null) {
                            this.state.parentElement = this.state.crInsertLevel;
                            this.state.elementIdx = this.state.parentElement.getElementCount();
                            if (this.state.elementIdx > 0 && InetHtmlParser.getLength(this.state.crInsertLevel) == 0 && this.state.crInsertLevel.getElement(this.state.elementIdx - 1) instanceof InetHtmlDocument.ContentElement) {
                                this.removeEmptyElement(this.state.crInsertLevel.getElement(this.state.elementIdx - 1), this.state.crInsertLevel);
                                this.state.elementIdx--;
                            }
                        } else {
                            this.state.parentElement = element;
                            this.state.elementIdx = element.getElementCount();
                        }
                        this.addLeafElement(mutableAttributeSet, "\n");
                        this.state.parentElement = element;
                        this.state.elementIdx = element.getElementCount();
                        this.state.isFirstTextInLine = true;
                    }
                } else {
                    if (this.state.crInsertLevel != null) {
                        this.state.parentElement = this.state.crInsertLevel;
                        this.state.elementIdx = this.state.parentElement.getElementCount();
                    } else {
                        this.state.parentElement = element;
                        this.state.elementIdx = element.getElementCount();
                    }
                    this.addLeafElement(mutableAttributeSet, "\n");
                    this.state.parentElement = element;
                    this.state.elementIdx = element.getElementCount();
                    this.state.isFirstTextInLine = true;
                }
            } else {
                this.state.isFirstTextInLine = true;
            }
            int n6 = element.getEndOffset();
            if (n6 - element.getStartOffset() > 1 && ((n2 = (int)this.doc.getContentImpl().getString(n6 - 2, 1).charAt(0)) == 32 || n2 == 9) && (element2 = ElementUtils.getLeafAt(this.state.rootElement, n6 - 2)) != null) {
                if (element2.getEndOffset() - element2.getStartOffset() == 1) {
                    this.doc.removeCompleteImpl(element2, this.eventList);
                }
                this.removeString(n6 - 2, 1);
            }
        }
        this.state.setInTableStructure(bl3);
        this.state.parentElement = (AbstractDocument.BranchElement)element.getParentElement();
        this.state.elementIdx = this.state.parentElement.getIndex((TreeNode)((Object)element)) + 1;
        this.state.isPreformatted = InetHtmlParser.isPreformatted(this.state.parentElement);
        return true;
    }

    private boolean isEquals(Element element, Object object) {
        return object == element.getAttributes().getAttribute(StyleConstants.NameAttribute);
    }

    private void parseStyle() throws IOException {
        CssParser cssParser = new CssParser(this.reader, this.styles, this.currentSource, this.url, this.dropUnknownStyles, this.isInsert);
        this.classAppendix = cssParser.parseWithID();
        this.doc.getStyleResolver().optimize();
        if (this.state.rootElement != null && this.state.rootElement.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HTML) {
            this.doc.getStyleResolver().fillAttributesNonLocked(this.state.rootElement, null);
        }
    }

    private void parseLink(MutableAttributeSet mutableAttributeSet) {
        block6: {
            try {
                Object object = mutableAttributeSet.getAttribute((Object)HTML.Attribute.REL);
                Object object2 = mutableAttributeSet.getAttribute((Object)HTML.Attribute.MEDIA);
                Object object3 = mutableAttributeSet.getAttribute((Object)HTML.Attribute.TYPE);
                Object object4 = mutableAttributeSet.getAttribute((Object)HTML.Attribute.HREF);
                if (object != null && object.toString().equalsIgnoreCase("stylesheet") && (object3 == null || object3.toString().equalsIgnoreCase("text/css")) && (object2 == null || object2.toString().equalsIgnoreCase("all") || object2.toString().toLowerCase().contains("screen")) && object4 != null) {
                    String string = URLUtils.safeEncode(object4.toString());
                    URL uRL = new URL(this.url, string);
                    CssParser cssParser = new CssParser(uRL, this.currentSource == null ? null : uRL, this.styles, this.charset, this.dropUnknownStyles);
                    cssParser.parse();
                    this.doc.getStyleResolver().optimize();
                    if (this.state.rootElement != null && this.state.rootElement.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HTML) {
                        this.doc.getStyleResolver().fillAttributesNonLocked(this.state.rootElement, null);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (Logger.doesLog(1)) {
                    Logger.error("Unable to find the referenced CSS: " + fileNotFoundException.getMessage());
                }
            }
            catch (Exception exception) {
                if (!Logger.doesLog(1)) break block6;
                Logger.error(exception);
            }
        }
    }

    private void parseDocType() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n2 = this.reader.read();
            switch (n2) {
                case -1: 
                case 62: {
                    this.doc.getDocType().parseDocType(stringBuilder.toString());
                    return;
                }
            }
            stringBuilder.append((char)n2);
        }
    }

    static boolean breaksFlow(Element element) {
        SingleAttributeValue singleAttributeValue;
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.BR) {
            return true;
        }
        if (object == HTML.Tag.CONTENT) {
            return false;
        }
        FloatValue floatValue = StyleResolver.getAttributeValue(element, AttributeFinder.FLOAT);
        if (floatValue != null && (((FloatValue)(singleAttributeValue = floatValue)).getFloat() == 3 || ((FloatValue)singleAttributeValue).getFloat() == 2)) {
            return true;
        }
        singleAttributeValue = StyleResolver.getAttributeValue(element, AttributeFinder.DISPLAY);
        switch (((DisplayValue)singleAttributeValue).getDisplay()) {
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    private static boolean isPreformatted(Element element) {
        WhiteSpace whiteSpace = StyleResolver.getAttributeValue(element, AttributeFinder.WHITE_SPACE);
        boolean bl2 = true;
        if (whiteSpace != null) {
            bl2 = whiteSpace.isCollapseSpaces();
        }
        return !bl2;
    }

    private Element addLeafElement(AttributeSet attributeSet, String string) throws BadLocationException {
        Object object;
        Object object2;
        Object object3;
        if (this.state.isInTableStructure() && (object3 = attributeSet.getAttribute(StyleConstants.NameAttribute)) != HTML.Tag.COL && (!attributeSet.isDefined("CR") || attributeSet.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.CONTENT) && string.length() > 0) {
            this.switchToTableFallback();
        }
        int n2 = this.state.getOffset();
        if (string.length() > 0 && this.state.isInBody) {
            object2 = this.doc.getContentImpl();
            char c2 = object2.getString(n2 - 1, 1).charAt(0);
            this.insertString(n2, string + c2);
            this.removeString(n2 - 1, 1);
        }
        this.state.crInsertLevel = this.state.parentElement;
        object2 = this.doc.createLeafElement((Element)this.state.parentElement, attributeSet, n2 - 1, n2 - 1 + (this.state.isInBody ? string.length() : 0));
        if (this.isInsert && (object = attributeSet.getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.IMG && attributeSet.isDefined((Object)HTML.Attribute.SRC)) {
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)object2.getAttributes();
            DocumentImage documentImage = new DocumentImage(null, (Element)object2);
            documentImage.setURL(attributeSet.getAttribute((Object)HTML.Attribute.SRC).toString());
            mutableAttributeSet.addAttribute(StyleConstants.IconAttribute, documentImage);
        }
        this.appendElement((Element)object2);
        return object2;
    }

    private void insertString(int n2, String string) throws BadLocationException {
        this.eventList.addEvent(this.doc.getContentImpl().insertString(n2, string));
    }

    private void removeString(int n2, int n3) throws BadLocationException {
        this.eventList.addEvent(this.doc.getContentImpl().remove(n2, n3));
    }

    private AbstractDocument.BranchElement addBranchElement(AttributeSet attributeSet) throws BadLocationException {
        AbstractDocument.BranchElement branchElement;
        Object object;
        block22: {
            object = attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object == HTML.Tag.BODY) {
                this.state.isInBody = true;
            }
            if (object != HTML.Tag.TABLE) {
                if (this.state.isInTableStructure()) {
                    if (TABLE_CELL_TAGS.contains(object)) {
                        this.state.setInTableStructure(false);
                    } else if (!TABLE_STRUCT_TAGS.contains(object)) {
                        this.switchToTableFallback();
                    }
                } else if (this.state != this.rootState && (TABLE_CELL_TAGS.contains(object) || TABLE_STRUCT_TAGS.contains(object))) {
                    this.state.deactivate();
                    this.state = this.rootState;
                    if (TABLE_CELL_TAGS.contains(object)) {
                        this.state.setInTableStructure(false);
                    }
                }
            } else if (this.state != this.rootState || this.state.isInTableStructure()) {
                if (this.state != this.rootState) {
                    this.state.deactivate();
                    if (this.tableStack.size() > 0) {
                        this.tableStack.remove(this.tableStack.size() - 1).finalizeState();
                    }
                    this.state = this.rootState;
                }
                if (this.state.isInTableStructure()) {
                    this.removeTag((Object)HTML.Tag.TABLE, false);
                    this.state.setInTableStructure(false);
                }
            } else if (this.state.pos.getOffset() <= 1) {
                this.addCRMarker();
            }
            branchElement = this.doc.createBranchElement((Element)this.state.parentElement, attributeSet);
            try {
                branchElement = this.checkParent(branchElement);
            }
            catch (BadLocationException badLocationException) {
                if (!Logger.doesLog(1)) break block22;
                Logger.error(badLocationException);
            }
        }
        branchElement = this.checkPrequirements(branchElement);
        if (branchElement == null) {
            return null;
        }
        this.appendElement(branchElement);
        if (object == HTML.Tag.TABLE) {
            ParserState parserState = new ParserState(this.state.parentElement, this.state.getOffset() - 1, this.state.elementIdx - 1);
            parserState.isInBody = this.state.isInBody;
            parserState.tagStack.addAll(this.state.tagStack);
            this.tableStack.add(parserState);
        }
        if (this.state == this.rootState && TABLE_STRUCT_TAGS.contains(object)) {
            this.state.setInTableStructure(true);
        }
        if (this.state.tagStack.size() <= maximumStackSize) {
            this.state.parentElement = branchElement;
            this.state.elementIdx = 0;
        }
        return branchElement;
    }

    private void addCRMarker() throws BadLocationException {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
        simpleAttributeSet.addAttribute("CR", Boolean.TRUE);
        this.addLeafElement(simpleAttributeSet, "\n");
    }

    private void switchToTableFallback() throws BadLocationException {
        if (this.tableStack.size() == 0) {
            return;
        }
        ParserState parserState = this.tableStack.get(this.tableStack.size() - 1);
        parserState.activate();
        this.state = parserState;
    }

    private void appendElement(Element element) {
        Element element2;
        if (!element.isLeaf()) {
            this.state.tagStack.add(element.getAttributes().getAttribute(StyleConstants.NameAttribute));
            if (this.state.tagStack.size() > maximumStackSize) {
                return;
            }
        }
        Element[] elementArray = new Element[]{element};
        this.replaceElements(this.state.parentElement, this.state.elementIdx++, elementArray, EMPTY);
        this.doc.fillAttributes(element);
        if (element instanceof AbstractDocument.BranchElement && InetHtmlDocument.isParagraph(element) && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY && (element2 = ElementUtils.getPreviousContent(element)) != null && !element2.getAttributes().containsAttribute("CR", Boolean.TRUE) && element2.getEndOffset() - element2.getStartOffset() > 0 && !ElementUtils.isBlockElement(element2)) {
            try {
                int n2 = element2.getEndOffset();
                int n3 = ElementUtils.getChildIndex(element2.getParentElement(), element2);
                this.insertString(n2, "\n");
                this.doc.splitContentElement(element2, n2, this.eventList);
                Element element3 = element2.getParentElement();
                element2 = element3.getElement(n3 + 1);
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                ElementUtils.clearTemp(mutableAttributeSet);
                mutableAttributeSet.removeAttribute(StyleConstants.IconAttribute);
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.CONTENT);
                mutableAttributeSet.addAttribute("CR", Boolean.TRUE);
                this.doc.fillAttributes(element2);
                if (element3 == this.state.parentElement) {
                    this.state.elementIdx++;
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.error(badLocationException);
            }
        }
    }

    private void checkForUtf8Prefix() throws IOException, ChangedCharSetException {
        if (!this.ignoreCharset && !"UTF8".equalsIgnoreCase(this.charset)) {
            this.reader.checkForUtf8Prefix();
        }
    }

    private boolean isInsert() {
        return this.isInsert;
    }

    private AbstractDocument.BranchElement checkPrequirements(AbstractDocument.BranchElement branchElement) {
        Object object = branchElement.getAttributes().getAttribute(StyleConstants.NameAttribute);
        TagList tagList = PARENT_REQUIRED.get(object);
        if (tagList != null) {
            Object object2 = this.state.getParentName();
            if (object2 == HTML.Tag.FORM && this.state.parentElement.getParent() != null) {
                object2 = this.state.parentElement.getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            }
            if (!tagList.contains(object2)) {
                if (tagList.isAutoCreate()) {
                    Object e2 = tagList.get(0);
                    InetHtmlDocument.BoxElement boxElement = this.doc.createBranchElement((Element)this.state.parentElement, e2);
                    if (this.checkPrequirements(boxElement) != null) {
                        this.appendElement(boxElement);
                        if (this.state.tagStack.size() <= maximumStackSize) {
                            this.state.parentElement = boxElement;
                            this.state.elementIdx = 0;
                        }
                        InetHtmlDocument.BoxElement boxElement2 = this.doc.createBranchElement((Element)this.state.parentElement, branchElement.getAttributes());
                        return boxElement2;
                    }
                    return null;
                }
                return null;
            }
        }
        return branchElement;
    }

    private AbstractDocument.BranchElement checkParent(AbstractDocument.BranchElement branchElement) throws BadLocationException {
        Object object = branchElement.getAttributes().getAttribute(StyleConstants.NameAttribute);
        TagList tagList = PARENT_FORBIDDEN.get(object);
        if (tagList != null) {
            List list = tagList;
            Object object2 = this.state.getParentName();
            if (object2 == HTML.Tag.FORM && this.state.parentElement.getParent() != null) {
                object2 = this.state.parentElement.getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            }
            if (object == HTML.Tag.TR && object2 == HTML.Tag.TD) {
                object2 = HTML.Tag.TR;
            }
            if (object2 instanceof HTML.Tag && list.contains(object2)) {
                if (!this.removeTag(object2, false)) {
                    return branchElement;
                }
                InetHtmlDocument.BoxElement boxElement = this.doc.createBranchElement((Element)this.state.parentElement, branchElement.getAttributes());
                return this.checkParent(boxElement);
            }
        }
        return branchElement;
    }

    private static int getLength(Element element) {
        if (element.getElementCount() == 0) {
            return 0;
        }
        return element.getEndOffset() - element.getStartOffset();
    }

    public int[] getContentOffsets() {
        if (this.startFragment != null && this.endFragment != null) {
            return new int[]{this.startFragment.getOffset(), this.endFragment.getOffset()};
        }
        return null;
    }

    private void replaceElements(AbstractDocument.BranchElement branchElement, int n2, Element[] elementArray, Element[] elementArray2) {
        this.eventList.getEventFor(branchElement, n2, elementArray2, elementArray);
        branchElement.replace(n2, elementArray2 != null ? elementArray2.length : 0, elementArray);
    }

    static {
        PARENT_REQUIRED.put(HTML.Tag.TD, new TagList(true, HTML.Tag.TR));
        PARENT_REQUIRED.put(HTML.Tag.TH, new TagList(true, HTML.Tag.TR));
        PARENT_REQUIRED.put(HTML.Tag.TR, new TagList(true, HTML.Tag.TBODY, HTML.Tag.THEAD, HTML.Tag.TFOOT));
        PARENT_REQUIRED.put(HTML.Tag.TBODY, new TagList(HTML.Tag.TABLE));
        PARENT_REQUIRED.put(HTML.Tag.THEAD, new TagList(HTML.Tag.TABLE));
        PARENT_REQUIRED.put(HTML.Tag.TFOOT, new TagList(HTML.Tag.TABLE));
        PARENT_REQUIRED.put(HTML.Tag.CAPTION, new TagList(HTML.Tag.TABLE));
        PARENT_REQUIRED.put(HTML.Tag.COL, new TagList(true, HTML.Tag.COLGROUP));
        PARENT_REQUIRED.put(HTML.Tag.COLGROUP, new TagList(HTML.Tag.TABLE));
        PARENT_FORBIDDEN.put(HTML.Tag.TABLE, new TagList(HTML.Tag.TR, HTML.Tag.TABLE, HTML.Tag.TBODY, HTML.Tag.THEAD, HTML.Tag.TFOOT, HTML.Tag.COL, HTML.Tag.COLGROUP));
        PARENT_FORBIDDEN.put(HTML.Tag.LI, new TagList(HTML.Tag.LI));
        PARENT_FORBIDDEN.put(HTML.Tag.A, new TagList(HTML.Tag.A));
        PARENT_FORBIDDEN.put(HTML.Tag.TR, new TagList(HTML.Tag.COLGROUP, HTML.Tag.COL, HTML.Tag.TR));
        PARENT_FORBIDDEN.put(HTML.Tag.TD, new TagList(HTML.Tag.COLGROUP, HTML.Tag.TD));
        PARENT_FORBIDDEN.put(HTML.Tag.TH, new TagList(HTML.Tag.COLGROUP));
        PARENT_FORBIDDEN.put(HTML.Tag.TBODY, new TagList(HTML.Tag.COLGROUP));
        PARENT_FORBIDDEN.put(HTML.Tag.THEAD, new TagList(HTML.Tag.COLGROUP));
        PARENT_FORBIDDEN.put(HTML.Tag.TFOOT, new TagList(HTML.Tag.COLGROUP));
        PARENT_FORBIDDEN.put(HTML.Tag.COLGROUP, new TagList(HTML.Tag.COLGROUP));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagList
    extends ArrayList<HTML.Tag> {
        private final boolean autoCreate;

        public TagList(boolean bl2, HTML.Tag ... tagArray) {
            this.autoCreate = bl2;
            for (HTML.Tag tag : tagArray) {
                this.add(tag);
            }
        }

        public TagList(HTML.Tag ... tagArray) {
            this(false, tagArray);
        }

        public boolean isAutoCreate() {
            return this.autoCreate;
        }
    }

    private static class DummyEventList
    extends InetHtmlDocument.EventList {
        private DummyEventList() {
        }

        public InetHtmlDocument.ElementEditBuffer getEventFor(Element element, int n2, Element[] elementArray, Element[] elementArray2) {
            return null;
        }
    }

    private class ParserState {
        private AbstractDocument.BranchElement rootElement;
        private AbstractDocument.BranchElement parentElement;
        private AbstractDocument.BranchElement crInsertLevel;
        private Position pos;
        private int elementIdx;
        private final StringBuilder content = new StringBuilder();
        private boolean isInTitle;
        private boolean isInBody = false;
        private boolean isFirstTextInLine = true;
        private boolean wasWhitespace;
        private boolean wasNBWhitespace;
        private boolean isPreformatted;
        private boolean isOnFinish;
        private boolean isInTableStructure;
        private boolean activated;
        private int gapOffset;
        private List<Object> tagStack = new ArrayList<Object>(InetHtmlParser.access$1700());

        public ParserState(AbstractDocument.BranchElement branchElement, int n2, int n3) throws BadLocationException {
            this.rootElement = branchElement;
            this.parentElement = branchElement;
            this.gapOffset = n2 == 0 ? 0 : -1;
            this.pos = InetHtmlParser.this.doc.getContentImpl().createPosition(n2 + this.gapOffset);
            this.elementIdx = n3;
        }

        public void activate() throws BadLocationException {
            if (this.activated) {
                return;
            }
            this.activated = true;
            AbstractDocument.Content content = InetHtmlParser.this.doc.getContentImpl();
            int n2 = this.getOffset();
            this.gapOffset = 0;
            if (this.rootElement.getChildCount() > 0) {
                Element element;
                int n3;
                if (this.elementIdx < 0) {
                    this.elementIdx = this.rootElement.getElementIndex(n2 > 0 ? n2 - 1 : 0);
                }
                if ((n3 = ElementUtils.getStartOffset(element = this.rootElement.getElement(this.elementIdx))) < 0) {
                    InetHtmlParser.this.insertString(n2, "X");
                    this.pos = content.createPosition(n2 + 1);
                    if (n2 > 0) {
                        element = ElementUtils.getLeafAt(((InetHtmlParser)InetHtmlParser.this).rootState.rootElement, n2);
                        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element.getParentElement();
                        InetHtmlDocument.ContentElement contentElement = InetHtmlParser.this.doc.createLeafElement((Element)branchElement, element.getAttributes(), element.getStartOffset(), n2);
                        int n4 = branchElement.getIndex((TreeNode)((Object)element));
                        InetHtmlParser.this.replaceElements(branchElement, n4, new Element[]{contentElement}, new Element[]{element});
                    }
                } else if (n3 < n2) {
                    int n5 = element.getEndOffset();
                    boolean bl2 = n2 != n5;
                    InetHtmlParser.this.insertString(n2, " ");
                    Element[] elementArray = new Element[bl2 ? 2 : 1];
                    if (element instanceof AbstractDocument.LeafElement) {
                        elementArray[0] = InetHtmlParser.this.doc.createLeafElement((Element)this.rootElement, element.getAttributes(), n3, n2);
                        if (bl2) {
                            elementArray[1] = InetHtmlParser.this.doc.createLeafElement((Element)this.rootElement, element.getAttributes(), n2 + 1, n5 + 1);
                        }
                    } else {
                        elementArray[0] = InetHtmlParser.this.doc.createBranchElement((Element)this.rootElement, element.getAttributes().copyAttributes());
                        InetHtmlParser.this.doc.createCopy(element, elementArray[0], n3, n2);
                        if (bl2) {
                            elementArray[1] = InetHtmlParser.this.doc.createBranchElement((Element)this.rootElement, element.getAttributes().copyAttributes());
                            InetHtmlParser.this.doc.createCopy(element, elementArray[1], n2 + 1, element.getEndOffset());
                        }
                    }
                    InetHtmlParser.this.replaceElements(this.rootElement, this.elementIdx, elementArray, new Element[]{this.rootElement.getElement(this.elementIdx)});
                    ++this.elementIdx;
                } else {
                    String string = content.getString(n2, 1);
                    InetHtmlParser.this.insertString(n2 + 1, " " + string);
                    InetHtmlParser.this.removeString(n2, 1);
                    AbstractDocument.BranchElement branchElement = this.rootElement;
                    int n6 = this.elementIdx;
                    if (!(element instanceof AbstractDocument.LeafElement)) {
                        element = ElementUtils.getLeafAt(this.rootElement, n2 + 1);
                        branchElement = (AbstractDocument.BranchElement)element.getParentElement();
                        n6 = 0;
                    }
                    Element[] elementArray = new Element[]{InetHtmlParser.this.doc.createLeafElement((Element)branchElement, element.getAttributes(), n2 + 1, element.getEndOffset())};
                    Element[] elementArray2 = new Element[]{branchElement.getElement(n6)};
                    if (elementArray2[0].getStartOffset() == elementArray2[0].getEndOffset() && branchElement.getElementCount() > n6 + 1) {
                        elementArray2 = new Element[]{elementArray2[0], branchElement.getElement(n6 + 1)};
                    }
                    InetHtmlParser.this.replaceElements(branchElement, n6, elementArray, elementArray2);
                }
                this.pos = content.createPosition(n2 + 1);
            } else {
                InetHtmlParser.this.insertString(0, "X");
                this.pos = content.createPosition(1);
            }
            if (this.elementIdx < 0) {
                this.elementIdx = 0;
            }
        }

        public void deactivate() throws BadLocationException {
            while (this.parentElement != this.rootElement) {
                InetHtmlParser.this.removeTag(this.getParentName(), false);
            }
        }

        public Object getParentName() {
            if (this.tagStack.size() <= maximumStackSize) {
                return this.parentElement.getAttributes().getAttribute(StyleConstants.NameAttribute);
            }
            return this.tagStack.get(this.tagStack.size() - 1);
        }

        public String getContentAndReset() {
            String string = this.content.toString();
            this.content.setLength(0);
            return string;
        }

        public int getOffset() {
            return this.pos != null ? this.pos.getOffset() - this.gapOffset : -1;
        }

        public void finalizeState() throws BadLocationException {
            if (this.activated) {
                InetHtmlParser.this.eventList.addEvent(InetHtmlParser.this.doc.getContentImpl().remove(this.getOffset() - 1, 1));
                this.pos = null;
            }
        }

        public String toString() {
            return "" + this.getOffset() + " -> " + this.parentElement;
        }

        private void setInTableStructure(boolean bl2) {
            this.isInTableStructure = bl2;
        }

        private boolean isInTableStructure() {
            return this.isInTableStructure;
        }
    }
}

