/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.editor.HtmlConverter;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.InetHtmlWriter;
import com.inet.html.handler.PasteFileHandler;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.html.views.ImageView;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class InetHtmlTransferHandler
extends TransferHandler
implements CaretListener {
    private JEditorPane editor;
    private PasteFileHandler customPasteHandler = null;
    private JTextComponent exportComp;
    private boolean shouldRemove;
    private boolean exportoccurred = false;
    private boolean dropPending = false;
    private int sourceStart;
    private int sourceEnd;
    private int insertStart;
    private int insertEnd;
    private boolean pasteAlwaysPlain;
    private long pasteAlwaysPlainActivationTime;
    private boolean isExportToSystemClipboard = false;
    private static final long PASTE_PLAIN_TIMEOUT = 5000L;
    public static final Set<String> IMAGE_TYPES = new HashSet<String>();
    public static final Set<String> HTML_TYPES = new HashSet<String>();
    public static final Set<String> TEXT_TYPES = new HashSet<String>();
    private static final DataFlavor FLAVOUR_INTERNAL_STRING = new DataFlavor(String.class, null);
    private static final boolean RTF_ACTIVE = false;
    private static final String FRAGMENT_START = "<!--StartFragment-->";
    private static final String FRAGMENT_END = "<!--EndFragment-->";

    public InetHtmlTransferHandler(JEditorPane jEditorPane) {
        this.editor = jEditorPane;
        Object object = this.editor.getClientProperty("PasteFileHandler");
        if (object instanceof PasteFileHandler) {
            this.customPasteHandler = (PasteFileHandler)object;
        }
        HtmlTransferable.AVAILABLE_FLAVORS_BASE = new ArrayList();
        HtmlTransferable.AVAILABLE_FLAVORS_HTML = new ArrayList();
        HtmlTransferable.AVAILABLE_FLAVORS_IMAGE = new ArrayList();
        try {
            HtmlTransferable.AVAILABLE_FLAVORS_BASE.add(new DataFlavor("text/plain;class=java.lang.String"));
            HtmlTransferable.AVAILABLE_FLAVORS_BASE.add(new DataFlavor("text/plain;class=java.io.Reader"));
            HtmlTransferable.AVAILABLE_FLAVORS_BASE.add(new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream"));
            HtmlTransferable.AVAILABLE_FLAVORS_BASE.add(FLAVOUR_INTERNAL_STRING);
            HtmlTransferable.AVAILABLE_FLAVORS_HTML.add(new DataFlavor("text/html;class=java.lang.String"));
            HtmlTransferable.AVAILABLE_FLAVORS_HTML.add(new DataFlavor("text/html;class=java.io.Reader"));
            HtmlTransferable.AVAILABLE_FLAVORS_HTML.add(new DataFlavor("text/html;charset=unicode;class=java.io.InputStream"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(DataFlavor.imageFlavor);
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/png"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/jpeg"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/tiff"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/gif"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/x-ico"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/x-icon"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/x-win-bitmap"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/x-ms-bmp"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/bmp"));
            HtmlTransferable.AVAILABLE_FLAVORS_IMAGE.add(new DataFlavor("image/x-java-image"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.error(classNotFoundException);
        }
    }

    public void updatePasteFileHandler() {
        if (this.editor == null) {
            return;
        }
        Object object = this.editor.getClientProperty("PasteFileHandler");
        this.customPasteHandler = object != null && object instanceof PasteFileHandler ? (PasteFileHandler)this.editor.getClientProperty("PasteFileHandler") : null;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        boolean bl2;
        boolean bl3 = this.editor.isEditable();
        boolean bl4 = bl2 = this.customPasteHandler != null;
        if (dataFlavorArray != null) {
            for (DataFlavor dataFlavor : dataFlavorArray) {
                if (dataFlavor.getMimeType().startsWith("text/plain")) {
                    return bl3;
                }
                if (dataFlavor.getMimeType().startsWith("text/html")) {
                    return bl3;
                }
                if (dataFlavor.getMimeType().startsWith("text/rtf")) {
                    return bl3;
                }
                if (dataFlavor.getMimeType().startsWith("image/x-java-image")) {
                    return bl3;
                }
                if (dataFlavor.getMimeType().startsWith("application/x-java-file-list") && dataFlavor.getRepresentationClass() == List.class) {
                    return bl3 || bl2;
                }
                if (!dataFlavor.getMimeType().startsWith("text/uri-list") || dataFlavor.getRepresentationClass() != String.class && dataFlavor.getRepresentationClass() != List.class) continue;
                return bl3 || bl2;
            }
        }
        return false;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        Document document = this.editor.getDocument();
        this.insertStart = this.editor.getSelectionStart();
        this.insertEnd = this.editor.getSelectionEnd();
        if (this.exportoccurred) {
            this.dropPending = true;
        }
        if (transferable != null && (this.editor.isEditable() || this.customPasteHandler != null) && jComponent.getTransferHandler() instanceof InetHtmlTransferHandler) {
            boolean bl2 = (this.getCurrentEventModifiers() & 1) > 0 && !this.isNormalInsert() || this.isModePlain();
            InetHtmlTransferHandler inetHtmlTransferHandler = (InetHtmlTransferHandler)jComponent.getTransferHandler();
            boolean bl3 = inetHtmlTransferHandler.insertDataIntoDocument(transferable, document, this.insertStart, this.insertEnd, bl2);
            if (bl3) {
                this.editor.setSelectionEnd(this.editor.getSelectionStart());
                this.editor.requestFocus();
            }
            return bl3;
        }
        return false;
    }

    private int getCurrentEventModifiers() {
        int n2 = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n2 = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n2 = ((ActionEvent)aWTEvent).getModifiers();
        }
        return n2;
    }

    private boolean isNormalInsert() {
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            return keyEvent.getKeyCode() == 155 && (keyEvent.getModifiers() & InetHtmlEditorKit.SHORTCUT_KEY_MASK) == 0;
        }
        return false;
    }

    public int getSourceActions(JComponent jComponent) {
        return ((JTextComponent)jComponent).isEditable() ? 3 : 1;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        boolean bl2;
        this.exportComp = (JTextComponent)jComponent;
        this.shouldRemove = true;
        this.sourceStart = this.exportComp.getSelectionStart();
        this.sourceEnd = this.exportComp.getSelectionEnd();
        this.exportoccurred = true;
        this.dropPending = false;
        boolean bl3 = bl2 = (this.getCurrentEventModifiers() & 1) > 0 || this.isModePlain();
        if (this.isExportToSystemClipboard || bl2) {
            return this.sourceStart != this.sourceEnd ? new SelectionTransferable(this.exportComp, this.sourceStart, this.sourceEnd) : null;
        }
        return this.sourceStart != this.sourceEnd ? new HtmlTransferable(this.exportComp, this.sourceStart, this.sourceEnd) : null;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n2) {
        if (this.shouldRemove && n2 == 2) {
            if (this.dropPending && jComponent instanceof JEditorPane) {
                try {
                    int n3 = this.sourceEnd - this.sourceStart;
                    if (this.insertStart >= this.sourceEnd) {
                        this.exportComp.getDocument().remove(this.sourceStart, n3);
                    } else if (this.insertEnd <= this.sourceStart) {
                        this.exportComp.getDocument().remove(this.sourceStart + n3, n3);
                    } else {
                        int n4;
                        int n5 = this.sourceEnd - this.insertStart;
                        if (n5 > 0) {
                            this.exportComp.getDocument().remove(this.insertStart + n3, n5);
                        }
                        if ((n4 = this.insertStart - this.sourceStart) > 0) {
                            this.exportComp.getDocument().remove(this.sourceStart, n4);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    HtmlTransferable htmlTransferable = (HtmlTransferable)transferable;
                    htmlTransferable.removeData();
                }
            } else {
                HtmlTransferable htmlTransferable = (HtmlTransferable)transferable;
                htmlTransferable.removeData();
            }
        }
        this.exportoccurred = false;
        this.dropPending = false;
    }

    public boolean insertDataIntoDocument(Transferable transferable, Document document, int n2, int n3, boolean bl2) {
        DataFlavor[] dataFlavorArray;
        block72: {
            Object object;
            DataFlavor stringArray;
            block71: {
                DataFlavor stringArray2;
                DataFlavor stringArray3;
                DataFlavor stringArray4;
                DataFlavor object2;
                block69: {
                    Object object3;
                    dataFlavorArray = transferable.getTransferDataFlavors();
                    bl2 |= !(document instanceof InetHtmlDocument);
                    DataFlavor stringArray5 = null;
                    DataFlavor stringArray6 = null;
                    DataFlavor stringArray7 = null;
                    object2 = null;
                    stringArray4 = null;
                    stringArray = null;
                    stringArray3 = null;
                    stringArray2 = null;
                    for (DataFlavor object4 : dataFlavorArray) {
                        if (object4.getMimeType().startsWith("text/rtf") && object4.getRepresentationClass() == InputStream.class) {
                            object2 = object4;
                            continue;
                        }
                        if (object4.getMimeType().startsWith("text/richtext") && object4.getRepresentationClass() == InputStream.class) {
                            object2 = object4;
                            continue;
                        }
                        if (object4.getMimeType().startsWith("text/html")) {
                            object3 = object4.getRepresentationClass();
                            if (stringArray6 == null && object3 == char[].class) {
                                stringArray6 = object4;
                            }
                            if (stringArray7 == null && object3 == String.class) {
                                stringArray7 = object4;
                            }
                            if (stringArray5 != null || object3 != Reader.class) continue;
                            stringArray5 = object4;
                            continue;
                        }
                        if (object4.getMimeType().startsWith("image/x-java-image") && object4.getRepresentationClass() == Image.class) {
                            stringArray4 = object4;
                            continue;
                        }
                        if (object4.getMimeType().startsWith("text/plain") && object4.getRepresentationClass() == String.class) {
                            stringArray = object4;
                            continue;
                        }
                        if (object4.getMimeType().startsWith("application/x-java-serialized-object") && object4.getRepresentationClass() == String.class) {
                            stringArray = object4;
                            continue;
                        }
                        if (object4.getMimeType().startsWith("text/uri-list") && object4.getRepresentationClass() == String.class) {
                            stringArray2 = object4;
                            continue;
                        }
                        if ((!object4.getMimeType().startsWith("x-special/gnome-copied-files") || object4.getRepresentationClass() != InputStream.class) && (!object4.getMimeType().startsWith("application/x-java-file-list") || object4.getRepresentationClass() != List.class)) continue;
                        stringArray3 = object4;
                    }
                    if (!bl2) {
                        block68: {
                            int n4;
                            if (stringArray5 != null) {
                                try {
                                    object = (Reader)transferable.getTransferData(stringArray5);
                                    CharArrayWriter charArrayWriter = new CharArrayWriter();
                                    char[] object5 = new char[65536];
                                    while ((n4 = ((Reader)object).read(object5)) >= 0) {
                                        charArrayWriter.write(object5, 0, n4);
                                    }
                                    ((Reader)object).close();
                                    object3 = charArrayWriter.toString();
                                    if (((String)object3).length() > 0) {
                                        this.pasteHTML((InetHtmlDocument)document, n2, n3, (String)object3);
                                        return true;
                                    }
                                }
                                catch (UnsupportedFlavorException unsupportedFlavorException) {
                                    unsupportedFlavorException.printStackTrace();
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                catch (StackOverflowError stackOverflowError) {
                                    stackOverflowError.printStackTrace();
                                }
                            }
                            if (stringArray6 != null) {
                                try {
                                    object = (char[])transferable.getTransferData(stringArray6);
                                    StringBuffer stringBuffer = new StringBuffer(((DataFlavor[])object).length / 2 + 1);
                                    for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                                        Object object4 = object[n4];
                                        if (object4 == false || n4 <= 3 && object4 >= 65530) continue;
                                        stringBuffer.append((char)object4);
                                    }
                                    String string = stringBuffer.toString();
                                    this.pasteHTML((InetHtmlDocument)document, n2, n3, string);
                                    return true;
                                }
                                catch (UnsupportedFlavorException unsupportedFlavorException) {
                                    if (Logger.doesLog(1)) {
                                        Logger.error(unsupportedFlavorException);
                                    }
                                }
                                catch (IOException iOException) {
                                    if (!Logger.doesLog(1)) break block68;
                                    Logger.error(iOException);
                                }
                            }
                        }
                        if (stringArray7 != null) {
                            try {
                                ((InetHtmlDocument)document).pasteHTML((String)transferable.getTransferData(stringArray7), n2, n3);
                                return true;
                            }
                            catch (UnsupportedFlavorException unsupportedFlavorException) {
                                if (Logger.doesLog(1)) {
                                    Logger.error(unsupportedFlavorException);
                                }
                            }
                            catch (IOException iOException) {
                                if (!Logger.doesLog(1)) break block69;
                                Logger.error(iOException);
                            }
                        }
                    }
                }
                if (stringArray3 != null || stringArray2 != null) {
                    object = new ArrayList();
                    try {
                        if (stringArray3 != null && stringArray3.getRepresentationClass() == List.class) {
                            List list = (List)transferable.getTransferData(stringArray3);
                            for (File file : list) {
                                object.add(file.toURI());
                            }
                        } else if (stringArray3 != null && stringArray3.getRepresentationClass() == InputStream.class && stringArray != null) {
                            String string = (String)transferable.getTransferData(stringArray);
                            String[] stringArray8 = string.split("(\r\n|\r|\n)");
                            object = new ArrayList();
                            for (String string2 : stringArray8) {
                                object.add(new File(string2).toURI());
                            }
                        } else if (stringArray2 != null) {
                            String string = (String)transferable.getTransferData(stringArray2);
                            String[] stringArray9 = string.split("(\r\n|\r|\n)");
                            object = new ArrayList();
                            for (String string2 : stringArray9) {
                                URI uRI = new URI(string2);
                                object.add(uRI);
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (Logger.doesLog(2)) {
                            Logger.warning("Failed to insert File/URI-List content: " + exception.getMessage() + ", trying to insert text/plain content.");
                        }
                        object = null;
                    }
                    if (object != null && object.size() > 0) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            int n4;
                            block70: {
                                URI uRI = (URI)iterator.next();
                                n4 = document.getLength();
                                File file = null;
                                try {
                                    file = new File(uRI);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                                if (file == null || !this.importFile(file, document, n2, n3, bl2, false)) {
                                    try {
                                        boolean bl3;
                                        String string = uRI.getPath();
                                        int n5 = string.lastIndexOf(47);
                                        if (n5 > 0) {
                                            string = string.substring(n5 + 1);
                                        }
                                        boolean bl4 = bl3 = object.get(object.size() - 1) != uRI;
                                        if (!bl2 && document instanceof InetHtmlDocument) {
                                            Object object5 = document.getProperty(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS);
                                            string = HtmlConverter.text2html(string, null, false, object5 != null ? object5.toString() : null);
                                            if (bl3) {
                                                string = string + "<br>";
                                            }
                                            ((InetHtmlDocument)document).pasteHTML(string, n2, n3, uRI);
                                        } else {
                                            document.remove(n2, n3 - n2);
                                            document.insertString(n2, string + (bl3 ? "\n" : ""), null);
                                        }
                                    }
                                    catch (BadLocationException badLocationException) {
                                        if (!Logger.doesLog(2)) break block70;
                                        Logger.warning("Failed to insert File/URI-List content: " + badLocationException.getMessage());
                                    }
                                }
                            }
                            int n6 = document.getLength();
                            n3 = n2 = n2 + n6 - n4;
                        }
                        return true;
                    }
                }
                if (!(bl2 || object2 != null && stringArray != null || stringArray4 == null)) {
                    try {
                        ((InetHtmlDocument)document).insertImage((Image)transferable.getTransferData(stringArray4), n2, null);
                        return true;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        if (Logger.doesLog(1)) {
                            Logger.error(unsupportedFlavorException);
                        }
                    }
                    catch (IOException iOException) {
                        if (!Logger.doesLog(1)) break block71;
                        Logger.error(iOException);
                    }
                }
            }
            if (stringArray != null) {
                try {
                    object = (String)transferable.getTransferData(stringArray);
                    if (object == null) {
                        return false;
                    }
                    if (document instanceof InetHtmlDocument) {
                        object = HtmlConverter.text2html((String)object, null, false, (String)document.getProperty(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS));
                        this.pasteHTML((InetHtmlDocument)document, n2, n3, (String)object);
                    } else {
                        document.remove(n2, n3 - n2);
                        document.insertString(n2, (String)object, null);
                    }
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    if (Logger.doesLog(1)) {
                        Logger.error(unsupportedFlavorException);
                    }
                }
                catch (IOException iOException) {
                    if (Logger.doesLog(1)) {
                        Logger.error(iOException);
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (!Logger.doesLog(1)) break block72;
                    Logger.error(badLocationException);
                }
            }
        }
        if (dataFlavorArray.length > 0 && Logger.doesLog(2)) {
            Logger.warning("The editor cannot use this type of pasted data. " + dataFlavorArray[0]);
        }
        return false;
    }

    private void pasteHTML(InetHtmlDocument inetHtmlDocument, int n2, int n3, String string) {
        if (n2 > 0 || n3 != inetHtmlDocument.getLength()) {
            inetHtmlDocument.pasteHTML(string, n2, n3);
        } else {
            if (n2 == n3) {
                try {
                    inetHtmlDocument.remove(0, 0);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            inetHtmlDocument.pasteHTML(string, n2, n3, null);
        }
    }

    public boolean importFile(File file, Document document, int n2, int n3, boolean bl2, boolean bl3) {
        block27: {
            if (this.customPasteHandler != null && !bl3) {
                try {
                    if (this.customPasteHandler.handlePaste(file, document)) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    if (!Logger.doesLog(1)) break block27;
                    Logger.error(throwable);
                }
            }
        }
        if (!this.editor.isEditable()) {
            return true;
        }
        if (file == null || !file.exists() || !file.canRead() || document == null) {
            return false;
        }
        String string = file.getName().toLowerCase();
        int n4 = string.lastIndexOf(46);
        if (n4 < 0 || n4 >= string.length() - 1) {
            return false;
        }
        String string2 = string.substring(n4 + 1);
        bl2 |= !(document instanceof InetHtmlDocument);
        if (IMAGE_TYPES.contains(string2)) {
            if (bl2) {
                if (Logger.doesLog(1)) {
                    Logger.error("Cannot insert an image into a text/plain document.");
                }
                return false;
            }
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(file);
            }
            catch (IOException iOException) {
                if (Logger.doesLog(1)) {
                    Logger.error(iOException);
                }
                iOException.printStackTrace();
            }
            if (bufferedImage != null) {
                ((InetHtmlDocument)document).insertImage(bufferedImage, n2, file);
            } else {
                ((InetHtmlDocument)document).insertImage(null, n2, file);
            }
            return true;
        }
        if (HTML_TYPES.contains(string2)) {
            String string3 = this.getContent(file);
            if (string3 != null) {
                if (!bl2) {
                    ((InetHtmlDocument)document).pasteHTML(string3, n2, n3, file.toURI());
                    return true;
                }
                string3 = HtmlConverter.html2text(string3);
                try {
                    document.remove(n2, n3 - n2);
                    document.insertString(n2, string3, null);
                    return true;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (Logger.doesLog(2)) {
                Logger.warning("Unable to paste the html content referenced by the filename '" + file.getPath() + "'");
            }
            return false;
        }
        if (TEXT_TYPES.contains(string2)) {
            String string4 = this.getContent(file);
            if (string4 != null) {
                if (!bl2) {
                    Object object = document.getProperty(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS);
                    string4 = HtmlConverter.text2html(string4, null, true, object != null ? object.toString() : null);
                    this.pasteHTML((InetHtmlDocument)document, n2, n3, string4);
                    return true;
                }
                try {
                    document.remove(n2, n3 - n2);
                    document.insertString(n2, string4, null);
                    return true;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (Logger.doesLog(2)) {
                Logger.warning("Unable to paste the html content referenced by the filename '" + file.getPath() + "'");
            }
            return false;
        }
        return false;
    }

    private String getContent(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n2 = 0;
            while ((n2 = ((InputStream)fileInputStream).read()) >= 0) {
                stringBuilder.append((char)n2);
            }
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() == this.editor && caretEvent.getDot() != caretEvent.getMark()) {
            try {
                Clipboard clipboard = this.editor.getToolkit().getSystemSelection();
                if (clipboard != null) {
                    this.isExportToSystemClipboard = true;
                    this.exportToClipboard(this.editor, clipboard, 1);
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.isExportToSystemClipboard = false;
            }
        }
    }

    public void setModePlain() {
        this.pasteAlwaysPlain = true;
        this.pasteAlwaysPlainActivationTime = System.currentTimeMillis();
    }

    private boolean isModePlain() {
        if (System.currentTimeMillis() - this.pasteAlwaysPlainActivationTime > 5000L) {
            this.pasteAlwaysPlain = false;
        }
        boolean bl2 = this.pasteAlwaysPlain;
        this.pasteAlwaysPlain = false;
        return bl2;
    }

    static {
        IMAGE_TYPES.add("png");
        IMAGE_TYPES.add("gif");
        IMAGE_TYPES.add("jpg");
        IMAGE_TYPES.add("jpeg");
        IMAGE_TYPES.add("tif");
        HTML_TYPES.add("htm");
        HTML_TYPES.add("html");
        TEXT_TYPES.add("txt");
        TEXT_TYPES.add("csv");
    }

    private static class SelectionTransferable
    implements Transferable {
        private String plain = null;

        public SelectionTransferable(JComponent jComponent, int n2, int n3) {
            if (jComponent instanceof JEditorPane) {
                JEditorPane jEditorPane = (JEditorPane)jComponent;
                Document document = jEditorPane.getDocument();
                try {
                    int n4 = document.getLength();
                    if (n2 > n4) {
                        n2 = n4;
                    }
                    if (n3 > n4) {
                        n3 = n4;
                    }
                    if (n2 == n3) {
                        this.plain = "";
                        return;
                    }
                    this.plain = document.getText(n2, n3 - n2);
                }
                catch (BadLocationException badLocationException) {
                    Logger.error(badLocationException);
                }
            }
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.getPrimaryType().endsWith("text") && dataFlavor.getSubType().equals("plain")) {
                return this.plain;
            }
            if (dataFlavor.equals(FLAVOUR_INTERNAL_STRING)) {
                return this.plain;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return HtmlTransferable.AVAILABLE_FLAVORS_BASE.toArray(new DataFlavor[HtmlTransferable.AVAILABLE_FLAVORS_BASE.size()]);
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (DataFlavor dataFlavor2 : this.getTransferDataFlavors()) {
                if (!dataFlavor2.equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }
    }

    private static class HtmlTransferable
    implements Transferable {
        private static List<DataFlavor> AVAILABLE_FLAVORS_BASE;
        private static List<DataFlavor> AVAILABLE_FLAVORS_HTML;
        private static List<DataFlavor> AVAILABLE_FLAVORS_IMAGE;
        private String html = null;
        private String plain = null;
        private int start;
        private int end;
        private JComponent source;
        private Image image;

        public HtmlTransferable(JComponent jComponent, int n2, int n3) {
            this.start = n2;
            this.end = n3;
            this.source = jComponent;
            if (jComponent instanceof JEditorPane) {
                JEditorPane jEditorPane = (JEditorPane)jComponent;
                Document document = jEditorPane.getDocument();
                try {
                    int n4 = document.getLength();
                    if (n2 > n4) {
                        n2 = n4;
                    }
                    if (n3 > n4) {
                        n3 = n4;
                    }
                    if (n2 == n3) {
                        this.plain = "";
                        this.html = "";
                        return;
                    }
                    this.plain = document.getText(n2, n3 - n2);
                    if (document instanceof InetHtmlDocument) {
                        Object object;
                        Object object2;
                        Element element = ElementUtils.getLeafAt(document.getRootElements()[0], n2);
                        if (n3 - n2 == 1 && element != null && "IMG".equalsIgnoreCase(element.getName()) && (object2 = jEditorPane.getUI().getRootView(jEditorPane)) != null && (object = this.findViewForElement((View)object2, element)) instanceof ImageView) {
                            this.image = ((ImageView)object).getImage();
                            URL uRL = ((ImageView)object).getUrl();
                            this.plain = uRL != null ? uRL.toString() : "image";
                            return;
                        }
                        object2 = new CharArrayWriter();
                        object = (InetHtmlDocument)document;
                        InetHtmlWriter inetHtmlWriter = new InetHtmlWriter((Writer)object2, (Document)object, n2, n3 - n2);
                        inetHtmlWriter.write();
                        this.html = InetHtmlTransferHandler.FRAGMENT_START + ((CharArrayWriter)object2).toString() + InetHtmlTransferHandler.FRAGMENT_END;
                    }
                }
                catch (BadLocationException badLocationException) {
                    Logger.error(badLocationException);
                }
                catch (IOException iOException) {
                    Logger.error(iOException);
                }
            }
        }

        private View findViewForElement(View view, Element element) {
            if (view.getElement() == element) {
                return view;
            }
            for (int i2 = 0; i2 < view.getViewCount(); ++i2) {
                View view2;
                View view3 = view.getView(i2);
                if (view3 == null || (view2 = this.findViewForElement(view3, element)) == null) continue;
                return view2;
            }
            return null;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            Class<?> clazz;
            if (dataFlavor.getPrimaryType().endsWith("text")) {
                String string = null;
                if (dataFlavor.getSubType().equals("plain")) {
                    string = this.plain;
                }
                if (dataFlavor.getSubType().equals("html")) {
                    string = this.html;
                }
                if (string != null) {
                    clazz = dataFlavor.getRepresentationClass();
                    if (clazz == String.class) {
                        return string;
                    }
                    if (clazz == InputStream.class) {
                        return new StringBufferInputStream(string);
                    }
                    if (clazz == Reader.class) {
                        return new StringReader(string);
                    }
                }
            }
            if (dataFlavor.getPrimaryType().equals("image")) {
                if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                    return this.image;
                }
                int n2 = 2;
                if (dataFlavor.getSubType().startsWith("bmp")) {
                    n2 = 1;
                }
                clazz = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), n2);
                ((BufferedImage)((Object)clazz)).getGraphics().drawImage(this.image, 0, 0, new Color(1, 1, 1, 1), null);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                boolean bl2 = false;
                if (dataFlavor.getSubType().startsWith("jpeg")) {
                    bl2 = ImageIO.write((RenderedImage)((Object)clazz), "jpeg", byteArrayOutputStream);
                }
                if (dataFlavor.getSubType().startsWith("tiff")) {
                    bl2 = ImageIO.write((RenderedImage)((Object)clazz), "tiff", byteArrayOutputStream);
                }
                if (dataFlavor.getSubType().startsWith("png")) {
                    bl2 = ImageIO.write((RenderedImage)((Object)clazz), "png", byteArrayOutputStream);
                }
                if (dataFlavor.getSubType().startsWith("gif")) {
                    bl2 = ImageIO.write((RenderedImage)((Object)clazz), "gif", byteArrayOutputStream);
                }
                if (dataFlavor.getSubType().startsWith("bmp")) {
                    bl2 = ImageIO.write((RenderedImage)((Object)clazz), "bmp", byteArrayOutputStream);
                }
                if (!bl2) {
                    return null;
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (dataFlavor.getRepresentationClass() == InputStream.class) {
                    return new ByteArrayInputStream(byArray, 0, byArray.length);
                }
                return byArray;
            }
            if (FLAVOUR_INTERNAL_STRING.equals(dataFlavor)) {
                return this.plain;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
            if (this.image != null) {
                arrayList.addAll(AVAILABLE_FLAVORS_IMAGE);
            }
            if (this.html != null && this.image == null) {
                arrayList.addAll(AVAILABLE_FLAVORS_HTML);
            }
            if (this.plain != null && this.image == null) {
                arrayList.addAll(AVAILABLE_FLAVORS_BASE);
            }
            return arrayList.toArray(new DataFlavor[arrayList.size()]);
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (DataFlavor dataFlavor2 : this.getTransferDataFlavors()) {
                if (!dataFlavor2.equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        public void removeData() {
            if (this.source instanceof JEditorPane) {
                try {
                    JEditorPane jEditorPane = (JEditorPane)this.source;
                    jEditorPane.getDocument().remove(this.start, this.end - this.start);
                }
                catch (BadLocationException badLocationException) {
                    Logger.error(badLocationException);
                }
            }
        }
    }
}

